<?php
/////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Build string for site.css file /////
// Created: 3/31/2010	ELL
// Revised: 12/27/2011	ELL
// Changed CKEDITOR.addStylesSet to CKEDITOR.stylesSet.add as former is depricated in CKEditor 3.6.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 3/4/2012	ELL
// Revised from using currently saved style sheet to using site styles and mail forms styles.  These styles MUST be used to create
// the styles.js file for the CKEditor, AND the other styles sheets SHOULD be left out of that file.  Note: The CKEditor uses
// the styles.js file to generate the styles dropdown list the users use to style their page.
// Revised: 12/30/2013	ELL
// Added checking for mail form classes table.
// Revised:	12/12/2014	ELL
// Changed queries to INNER JOIN on CSS tables to eliminate inactive classes from list.
// 
//
	
	$jason_string = "CKEDITOR.stylesSet.add( 'bwb_styles',\n";
	$jason_string .= "[\n";
					   
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "site_classes INNER JOIN " . BWB_TABLE_PREFIX . "site_css ON " . BWB_TABLE_PREFIX . "site_classes.class = " . BWB_TABLE_PREFIX . "site_css.class WHERE " . BWB_TABLE_PREFIX . "site_classes.custom = 1 AND " . BWB_TABLE_PREFIX . "site_css.use_table_data = 1 ORDER BY sort_order";	
	$result = $bwb_dbh->query($query);

	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{		
		$class = $row["class"];
		$description = addslashes($row["description"]);
		$class = str_replace(".", "", $class);
		$class = str_replace("#", "", $class);
		$class_type = substr($class, 0, 1);
		if ($class_type == "#")
			$jason_string .= "   { name : '" . $description . "', element : 'div', attributes : { 'class' : '" . $class . "' } },\n";
		else
			$jason_string .= "   { name : '" . $description . "', element : 'span', attributes : { 'class' : '" . $class . "' } },\n";
		
	}	// end while
	
	if ($bwb_dbh->query("SHOW TABLES LIKE '" . BWB_TABLE_PREFIX . "mail_form_classes'")->rowCount() > 0)
    {	
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "mail_form_classes INNER JOIN " . BWB_TABLE_PREFIX . "mail_form_css ON " . BWB_TABLE_PREFIX . "mail_form_classes.class = " . BWB_TABLE_PREFIX . "mail_form_css.class WHERE " . BWB_TABLE_PREFIX . "mail_form_classes.custom = 1 AND " . BWB_TABLE_PREFIX . "mail_form_css.use_table_data = 1 ORDER BY sort_order";
		
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{		
			$class = $row["class"];
			$description = addslashes($row["description"]);
			$class = str_replace(".", "", $class);
			$class = str_replace("#", "", $class);
			$class_type = substr($class, 0, 1);
			if ($class_type == "#")
				$jason_string .= "   { name : '" . $description . "', element : 'div', attributes : { 'class' : '" . $class . "' } },\n";
			else
				$jason_string .= "   { name : '" . $description . "', element : 'span', attributes : { 'class' : '" . $class . "' } },\n";
			
		}	// end while
	}
	
	// Add in default styles
	$jason_string .=  "	{name:'Blue Title',element:'h3',styles:{color:'Blue'}},\n	{name:'Red Title',element:'h3',styles:{color:'Red'}},\n	{name:'Marker: Yellow',element:'span',styles:{'background-color':'Yellow'}},\n	{name:'Marker: Green',element:'span',styles:{'background-color':'Lime'}},\n	{name:'Big',element:'big'},\n	{name:'Small',element:'small'},\n	{name:'Typewriter',element:'tt'},\n	{name:'Computer Code',element:'code'},\n	{name:'Keyboard Phrase',element:'kbd'},\n	{name:'Sample Text',element:'samp'},\n	{name:'Variable',element:'var'},\n	{name:'Deleted Text',element:'del'},\n	{name:'Inserted Text',element:'ins'},\n	{name:'Cited Work',element:'cite'},\n	{name:'Inline Quotation',element:'q'},\n	{name:'Language: RTL',element:'span',attributes:{dir:'rtl'}},\n	{name:'Language: LTR',element:'span',attributes:{dir:'ltr'}},\n	{name:'Image on Left',element:'img',attributes:{style:'padding: 5px; margin-right: 5px',border:'2',align:'left'}},\n	{name:'Image on Right',element:'img',attributes:{style:'padding: 5px; margin-left: 5px',border:'2',align:'right'}}";
	
	// Fininh JASON definition.
	$jason_string .= "\n]);";
?>