<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/30/2010
// Modified: 12/2/2010	Ed Lemmers
// Changed relative path to index.php to absolute path to fix problem of infinite loop back to index.php in kfm folder.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 3/25/2013	ELL
// Security enhancements for PDO.
// Revised: 7/31/2014	ELL
// Added checking and setting of session path in case not set by default.
//
	error_reporting (E_ALL ^ E_NOTICE);
	
	include ("../connect/config.php");
	
	$sess_save_path = session_save_path();
	if (!isset($sess_save_path) || ($sess_save_path == ""))
		session_save_path(SESSION_SAVE_PATH);
	
	session_start();
	$userid = $_SESSION['userid'];
	$curr_session = md5(session_id());
	
	include ("../connect/db_connect.php");
	
	$query = "SELECT `Session`, `IP`, `AccessLevel`, `first_name`, `last_name` FROM `" . BWB_TABLE_PREFIX . "users` WHERE `UserID`=:userid";
	$stmt = $bwb_dbh->prepare($query);
	$stmt->execute(array(':userid' => $userid));
	$row = $stmt->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT);
	
	$session = $row['Session'];
	$ip = $row['IP'];
	$access_level = $row['AccessLevel'];
	$curr_ip = $_SERVER['REMOTE_ADDR'];
	
	if (($curr_session != $session) || ($curr_ip != $ip))
		header("Location: /index.php");
		
	$first_name = $row['first_name'];
	$last_name = $row['last_name'];
?>