<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010	ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 9/28/2010	ELL
// Fixed bug with shadow parameters not loading into editor.
// Revised: 10/7/2010	ELL
// Added selection of top, bottom, right, left for border style assignment, each independently selectable.
// Revised: 11/9/2010	ELL
// Changed centering to modify #wrap instead of .wrap.  Part of switching 
// Revised: 11/10/2010	ELL
// Added persistence of style sheet selected.
// Revised: 2/3/2011	ELL
// Added sorting of image file list.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added reference to user files folder constant.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/27/2013	ELL
// Added ability to change style sheet from this module.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/16/2014	ELL
// Added modal color tinting of grouping tables to make it easier to find controls and to make enabled=disabled obvious.
// Revised 2/20/2014	ELL
// Added checking for correct parameters selected for border and line height.
// Revised: 3/3/2014	ELL
// Replaced image uploader with "AJAX" image uploader.
// Revised: 8/27/2014	ELL
// Added switch between alpha and user-defined sort for class list.
// Revised: 12/27/2014	ELL
// Added drilling down one more directory level for building background image list.
// Revised: 12/30/2014	ELL
// Added browser CSS reset button.
// 
//
	include ("check_session.php");

	
	$style_sheet = $_REQUEST['style_sheet'];
	$_SESSION['last_style_sheet_edited'] = $style_sheet;
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $style_sheet . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$show_class_editor = $row["show_class_editor"];
	
	$class_sort_method = $_SESSION['class_sort_method'];
		
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script language="javascript" type="text/javascript" src="js/json2.js"></script>
<script language="javascript" type="text/javascript" src="js/ajax.js"> </script>
<script language="javascript" type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<script language="javascript" type="text/javascript" src="js/ajaxupload.js"></script>

<script language="javascript" type="text/javascript" src="js/check_color_str.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>

<script language="javascript" type="text/javascript" src="js/edit_css.js"></script>

<script language="javascript" type="text/javascript">
////////////////////////////////////////////////////////////////////////////////////
var upload_index;

<?php
$document_root = $_SERVER['DOCUMENT_ROOT'];
$http_host = $_SERVER['HTTP_HOST'];

if (BWB_BASE_DIR == '')
{
	$path = $document_root . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_IMAGE_DIR . "/tn";
}
else
{
	$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/tn";
}
							
echo "var image_dir_path = '$image_dir_path';\n";
echo "var image_tn_dir_path = '$image_tn_dir_path';\n";

if (!is_dir($path . "/tn"))
		mkdir($path . "/tn", 0755);
?>

function PopulateForm(class_select)
{
	var class_index = class_select.selectedIndex;
	var class_name = class_select.options[class_index].value;
	var ajaxRequest;
	ajaxRequest = getXmlHttpRequestObject();

	// Create a function that will receive data sent from the server
	ajaxRequest.onreadystatechange = function(){
		if(ajaxRequest.readyState == 4){
			var row = ajaxRequest.responseText;
//				alert(row);
			if (row == "-no data-")
			{
				document.getElementById("use_table_data").checked = false;
				
				document.getElementById("font").value = "-not selected-";
				document.getElementById("font2").value = "-not selected-";
				document.getElementById("font3").value = "-not selected-";
				document.getElementById("font_size").value = -1;
				document.getElementById("text_color").value = "-not set-";
				document.getElementById("align").value = "-not selected-";
				document.getElementById("vertical_align").value = "-not selected-";
				document.getElementById("display").value = "-not selected-";
				document.getElementById("weight").value = "-not selected-";
				document.getElementById("font_stretch").value = "-not selected-";
				document.getElementById("italic").checked = false;
				document.getElementById("underline").checked = false;
				document.getElementById("overline").checked = false;
				document.getElementById("blink").checked = false;
				document.getElementById("linethrough").checked = false;
				document.getElementById("oblique").checked = false;
				document.getElementById("small_caps").checked = false;
				document.getElementById("no_text_decoration").checked = false;
				document.getElementById("line_height").value = -1;
				document.getElementById("line_height_units").value = 0;
				
				document.getElementById("shadow").checked = false;
				document.getElementById("shadow_color").value = "-not set-";
				document.getElementById("shadow_x_offset").value = 0;
				document.getElementById("shadow_y_offset").value = 0;
				document.getElementById("shadow_blur").value = 0;
		
				document.getElementById("bkgd_color").value = "-not set-";
				document.getElementById("bkgd_opacity").value = -1;
				document.getElementById("border").value = -1;
				document.getElementById("border_color").value = "-not set-";
				document.getElementById("border_style").value = "-not selected-";
				document.getElementById("outline_style").value = "-not selected-";
				document.getElementById("border_collapse").value = "-not selected-";
				document.getElementById("border_top").value = 1;
				document.getElementById("border_bottom").value = 1;
				document.getElementById("border_left").value = 1;
				document.getElementById("border_right").value = 1;
				document.getElementById("padding_top").value = -1;
				document.getElementById("padding_right").value = -1;
				document.getElementById("padding_bottom").value = -1;
				document.getElementById("padding_left").value = -1;

				document.getElementById("width").value = -1;
				document.getElementById("width_units").value = 0;
				document.getElementById("width_prefix").value = "-not selected-";
				document.getElementById("height").value = -1;
				document.getElementById("height_units").value = 0;
				document.getElementById("height_prefix").value = "-not selected-";
				document.getElementById("background_image").value = "-not selected-";
				document.getElementById("background_attachment").value = "-not selected-";
				document.getElementById("background_repeat").value = "-not selected-";
				document.getElementById("background_position").value = "-not selected-";
				document.getElementById("background_position_x").value = 0;
				document.getElementById("background_position_y").value = 0;
				document.getElementById("background_position_units").value = 0;
				
				document.getElementById("margin_top").value = -1000000;
				document.getElementById("margin_right").value = -1000000;
				document.getElementById("margin_left").value = -1000000;
				document.getElementById("margin_bottom").value = -1000000;
				document.getElementById("margin_top_auto").checked = false;
				document.getElementById("margin_right_auto").checked = false;
				document.getElementById("margin_left_auto").checked = false;
				document.getElementById("margin_bottom_auto").checked = false;
		
				document.getElementById("position").value = "-not selected-";
				document.getElementById("position_left").value = -1000000;
				document.getElementById("position_left_units").value = 0;
				document.getElementById("position_top").value = -1000000;
				document.getElementById("position_top_units").value = 0;
				document.getElementById("position_right").value = -1000000;
				document.getElementById("position_right_units").value = 0;
				document.getElementById("position_bottom").value = -1000000;
				document.getElementById("position_bottom_units").value = 0;
				document.getElementById("z_index").value = -1000000;
				document.getElementById("overflow").value = "-not selected-";
				document.getElementById("clip_top").value = -1;
				document.getElementById("clip_top_units").value = -1;
				document.getElementById("clip_right").value = -1;
				document.getElementById("clip_right_units").value = -1;
				document.getElementById("clip_bottom").value = -1;
				document.getElementById("clip_bottom_units").value = -1;
				document.getElementById("clip_left").value = -1;
				document.getElementById("clip_left_units").value = -1;
				document.getElementById("float").value = "-not selected-";
				document.getElementById("white_space").value = "-not selected-";
		
				document.getElementById("list_style_type").value = "-not selected-";
				document.getElementById("list_style_position").value = "-not selected-";
				document.getElementById("list_style_image").value = "-not selected-";
		
				document.getElementById("table_layout").value = "-not selected-";
				document.getElementById("clear").value = "-not selected-";
				
				document.getElementById("radius_top_left").value = 0;
				document.getElementById("radius_top_left_units").value = 0;
				document.getElementById("radius_top_right").value = 0;
				document.getElementById("radius_top_right_units").value = 0;
				document.getElementById("radius_bottom_right").value = 0;
				document.getElementById("radius_bottom_right_units").value = 0;
				document.getElementById("radius_bottom_left").value = 0;
				document.getElementById("radius_bottom_left_units").value = 0;
				
				document.getElementById("box_shadow_horizontal").value = -1000000;
				document.getElementById("box_shadow_vertical").value = -1000000;
				document.getElementById("box_shadow_blur").value = -1;
				document.getElementById("box_shadow_spread").value = -1000000;
				document.getElementById("box_shadow_color").value = "-not set-";
				document.getElementById("box_shadow_inset").checked = false;
				
				document.getElementById("cursor").value = "-not selected-";
				
				document.getElementById("background_size").value = "-not selected-";
				document.getElementById("background_width").value = -1;
				document.getElementById("background_width_units").value = 0;
				document.getElementById("background_height").value = -1;
				document.getElementById("background_height_units").value = 0;
				
				document.getElementById("text_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("background_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("border_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("margin_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("position_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("background_img_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("list_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("box_shadow_table").style.backgroundColor = "#D9D9D9";
				
				var html = "<img alt='photo' src='/manage/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img1' />";
				document.getElementById("preview1").innerHTML = html;
				html = "<img alt='photo' src='/manage/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img2' />";
				document.getElementById("preview2").innerHTML = html;
			}
			else
			{
				var JSON_row = JSON.parse(row);

				if (JSON_row.use_table_data == 1)
					document.getElementById("use_table_data").checked = true;
				else
					document.getElementById("use_table_data").checked = false;
				document.getElementById("font").value = JSON_row.font;
				document.getElementById("font2").value = JSON_row.font2;
				document.getElementById("font3").value = JSON_row.font3;
				document.getElementById("font_size").value = JSON_row.font_size;
				document.getElementById("text_color").value = JSON_row.text_color;
				document.getElementById("align").value = JSON_row.align;
				document.getElementById("vertical_align").value = JSON_row.vertical_align;
				document.getElementById("display").value = JSON_row.display;
				document.getElementById("weight").value = JSON_row.weight;
				document.getElementById("font_stretch").value = JSON_row.font_stretch;
				if (JSON_row.italic == 1)
					document.getElementById("italic").checked = true;
				else
					document.getElementById("italic").checked = false;
				if (JSON_row.underline == 1)
					document.getElementById("underline").checked = true;
				else
					document.getElementById("underline").checked = false;
				if (JSON_row.overline == 1)
					document.getElementById("overline").checked = true;
				else
					document.getElementById("overline").checked = false;
				if (JSON_row.blink == 1)
					document.getElementById("blink").checked = true;
				else
					document.getElementById("blink").checked = false;
				if (JSON_row.linethrough == 1)
					document.getElementById("linethrough").checked = true;
				else
					document.getElementById("linethrough").checked = false;
				if (JSON_row.oblique == 1)
					document.getElementById("oblique").checked = true;
				else
					document.getElementById("oblique").checked = false;
				if (JSON_row.small_caps == 1)
					document.getElementById("small_caps").checked = true;
				else
					document.getElementById("small_caps").checked = false;
				if (JSON_row.no_text_decoration == 1)
					document.getElementById("no_text_decoration").checked = true;
				else
					document.getElementById("no_text_decoration").checked = false;
				document.getElementById("line_height").value = JSON_row.line_height;
				document.getElementById("line_height_units").value = JSON_row.line_height_units;
				
				if (JSON_row.shadow == 1)
					document.getElementById("shadow").checked = true;
				else
					document.getElementById("shadow").checked = false;
				document.getElementById("shadow_color").value = JSON_row.shadow_color;
				document.getElementById("shadow_x_offset").value = JSON_row.shadow_x_offset;
				document.getElementById("shadow_y_offset").value = JSON_row.shadow_y_offset;
				document.getElementById("shadow_blur").value = JSON_row.shadow_blur;
		
				document.getElementById("bkgd_color").value = JSON_row.bkgd_color;
				document.getElementById("bkgd_opacity").value = JSON_row.bkgd_opacity;
				document.getElementById("border").value = JSON_row.border;
				document.getElementById("border_color").value = JSON_row.border_color;
				document.getElementById("border_style").value = JSON_row.border_style;
				document.getElementById("outline_style").value = JSON_row.outline_style;
				document.getElementById("border_collapse").value = JSON_row.border_collapse;
				if ((JSON_row.border_sides & 8) == 8)
					document.getElementById("border_top").checked = true;
				else
					document.getElementById("border_top").checked = false;
				if ((JSON_row.border_sides & 4) == 4)
					document.getElementById("border_bottom").checked = true;
				else
					document.getElementById("border_bottom").checked = false;
				if ((JSON_row.border_sides & 2) == 2)
					document.getElementById("border_left").checked = true;
				else
					document.getElementById("border_left").checked = false;
				if ((JSON_row.border_sides & 1) == 1)
					document.getElementById("border_right").checked = true;
				else
					document.getElementById("border_right").checked = false;
				document.getElementById("padding_top").value = JSON_row.padding_top;
				document.getElementById("padding_right").value = JSON_row.padding_right;
				document.getElementById("padding_bottom").value = JSON_row.padding_bottom;
				document.getElementById("padding_left").value = JSON_row.padding_left;

				document.getElementById("width").value = JSON_row.width;
				document.getElementById("width_units").value = JSON_row.width_units;
				document.getElementById("width_prefix").value = JSON_row.width_prefix;
				document.getElementById("height").value = JSON_row.height;
				document.getElementById("height_units").value = JSON_row.height_units;
				document.getElementById("height_prefix").value = JSON_row.height_prefix;
				document.getElementById("background_image").value = JSON_row.background_image;
				document.getElementById("background_attachment").value = JSON_row.background_attachment;
				document.getElementById("background_repeat").value = JSON_row.background_repeat;
				document.getElementById("background_position").value = JSON_row.background_position;
				document.getElementById("background_position_x").value = JSON_row.background_position_x;
				document.getElementById("background_position_y").value = JSON_row.background_position_y;
				document.getElementById("background_position_units").value = JSON_row.background_position_units;
		
				document.getElementById("margin_top").value = JSON_row.margin_top;
				document.getElementById("margin_right").value = JSON_row.margin_right;
				document.getElementById("margin_left").value = JSON_row.margin_left;
				document.getElementById("margin_bottom").value = JSON_row.margin_bottom;
				if (JSON_row.margin_top_auto == 1)
					document.getElementById("margin_top_auto").checked = true;
				else
					document.getElementById("margin_top_auto").checked = false;
				if (JSON_row.margin_right_auto == 1)
					document.getElementById("margin_right_auto").checked = true;
				else
					document.getElementById("margin_right_auto").checked = false;
				if (JSON_row.margin_left_auto == 1)
					document.getElementById("margin_left_auto").checked = true;
				else
					document.getElementById("margin_left_auto").checked = false;
				if (JSON_row.margin_bottom_auto == 1)
					document.getElementById("margin_bottom_auto").checked = true;
				else
					document.getElementById("margin_bottom_auto").checked = false;
		
				document.getElementById("position").value = JSON_row.position;
				document.getElementById("position_left").value = JSON_row.position_left;
				document.getElementById("position_left_units").value = JSON_row.position_left_units;
				document.getElementById("position_top").value = JSON_row.position_top;
				document.getElementById("position_top_units").value = JSON_row.position_top_units;
				document.getElementById("position_right").value = JSON_row.position_right;
				document.getElementById("position_right_units").value = JSON_row.position_right_units;
				document.getElementById("position_bottom").value = JSON_row.position_bottom;
				document.getElementById("position_bottom_units").value = JSON_row.position_bottom_units;
				document.getElementById("z_index").value = JSON_row.z_index;
				document.getElementById("overflow").value = JSON_row.overflow;
				document.getElementById("clip_top").value = JSON_row.clip_top;
				document.getElementById("clip_top_units").value = JSON_row.clip_top_units;
				document.getElementById("clip_right").value = JSON_row.clip_right;
				document.getElementById("clip_right_units").value = JSON_row.clip_right_units;
				document.getElementById("clip_bottom").value = JSON_row.clip_bottom;
				document.getElementById("clip_bottom_units").value = JSON_row.clip_bottom_units;
				document.getElementById("clip_left").value = JSON_row.clip_left;
				document.getElementById("clip_left_units").value = JSON_row.clip_left_units;
				document.getElementById("float").value = JSON_row.float;
				document.getElementById("white_space").value = JSON_row.white_space;
		
				document.getElementById("list_style_type").value = JSON_row.list_style_type;
				document.getElementById("list_style_position").value = JSON_row.list_style_position;
				document.getElementById("list_style_image").value = JSON_row.list_style_image;
		
				document.getElementById("table_layout").value = JSON_row.table_layout;
				document.getElementById("clear").value = JSON_row.clear;
				
				document.getElementById("radius_top_left").value = JSON_row.radius_top_left;
				document.getElementById("radius_top_left_units").value = JSON_row.radius_top_left_units;
				document.getElementById("radius_top_right").value = JSON_row.radius_top_right;
				document.getElementById("radius_top_right_units").value = JSON_row.radius_top_right_units;
				document.getElementById("radius_bottom_right").value = JSON_row.radius_bottom_right;
				document.getElementById("radius_bottom_right_units").value = JSON_row.radius_bottom_right_units;
				document.getElementById("radius_bottom_left").value = JSON_row.radius_bottom_left;
				document.getElementById("radius_bottom_left_units").value = JSON_row.radius_bottom_left_units;
				
				document.getElementById("box_shadow_horizontal").value = JSON_row.box_shadow_horizontal;
				document.getElementById("box_shadow_vertical").value = JSON_row.box_shadow_vertical;
				document.getElementById("box_shadow_blur").value = JSON_row.box_shadow_blur;
				document.getElementById("box_shadow_spread").value = JSON_row.box_shadow_spread;
				document.getElementById("box_shadow_color").value = JSON_row.box_shadow_color;
				if (JSON_row.box_shadow_inset == 1)
					document.getElementById("box_shadow_inset").checked = true;
				else
					document.getElementById("box_shadow_inset").checked = false;
				
				document.getElementById("cursor").value = JSON_row.cursor;
				
				document.getElementById("background_size").value = JSON_row.background_size;
				document.getElementById("background_width").value = JSON_row.background_width;
				document.getElementById("background_width_units").value = JSON_row.background_width_units;
				document.getElementById("background_height").value = JSON_row.background_height;
				document.getElementById("background_height_units").value = JSON_row.background_height_units;
				
				document.getElementById("text_table").style.backgroundColor = "#FFCCCC";
				document.getElementById("background_table").style.backgroundColor = "#CCFFCC";
				document.getElementById("border_table").style.backgroundColor = "#CCCCFF";
				document.getElementById("margin_table").style.backgroundColor = "#FFFFAA";
				document.getElementById("position_table").style.backgroundColor = "#FFAAFF";
				document.getElementById("background_img_table").style.backgroundColor = "#AAFFFF";
				document.getElementById("list_table").style.backgroundColor = "#FFBB99";
				document.getElementById("box_shadow_table").style.backgroundColor = "#99BBFF";
				
				UpdateImage(1);
				UpdateImage(2);
			}
			var heading_str = document.getElementById("goto_class").value;
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			heading_str = heading_str.replace("PERIOD", ".");
			heading_str = heading_str.replace("POUND", "#");
			heading_str = heading_str.replace("SPACE", " ");
			heading_str = heading_str.replace("COMMA", ",");
			document.getElementById("class_heading").innerHTML = heading_str;
				
			enable_disable_controls(0);
		}
	}
	
	var queryString = "?class_table=" + "<?php echo $class_table; ?>" + "&css_table=" + "<?php echo $css_table; ?>" + "&class=" + class_name;
//		alert (queryString);
	ajaxRequest.open("GET", "populate_css_edit_form.php" + queryString, true);
	ajaxRequest.send(null);
	
	document.getElementById("goto_class").value = class_name;
}

////////////////////////////////////////////////////////////////////////////////////

function UpdateCSS()
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, false);

		params = "submit_action=Update";
		params = params + "&style_sheet=<? echo $style_sheet; ?>";
		params = params + "&class=" + document.getElementById("goto_class").value;
		if (document.getElementById("use_table_data").checked == true) params = params + "&use_table_data=1";
		else params = params + "&use_table_data=0";
		params = params + "&font=" + document.getElementById("font").value;
		params = params + "&font2=" + document.getElementById("font2").value;
		params = params + "&font3=" + document.getElementById("font3").value;
		params = params + "&font_size=" + document.getElementById("font_size").value;
		params = params + "&text_color=" + document.getElementById("text_color").value;
		params = params + "&align=" + document.getElementById("align").value;
		params = params + "&vertical_align=" + document.getElementById("vertical_align").value;
		params = params + "&display=" + document.getElementById("display").value;
		params = params + "&weight=" + document.getElementById("weight").value;
		params = params + "&font_stretch=" + document.getElementById("font_stretch").value;
		if (document.getElementById("italic").checked == true) params = params + "&italic=1";
		else params = params + "&italic=0";
		if (document.getElementById("underline").checked == true) params = params + "&underline=1";
		else params = params + "&underline=0";
		if (document.getElementById("overline").checked == true)	params = params + "&overline=1";
		else params = params + "&overline=0";
		if (document.getElementById("blink").checked == true) params = params + "&blink=1";
		else params = params + "&blink=0";
		if (document.getElementById("linethrough").checked == true) params = params + "&linethrough=1";
		else params = params + "&linethrough=0";
		if (document.getElementById("oblique").checked == true) params = params + "&oblique=1";
		else params = params + "&oblique=0";
		if (document.getElementById("small_caps").checked == true) params = params + "&small_caps=1";
		else params = params + "&small_caps=0";
		if (document.getElementById("no_text_decoration").checked == true) params = params + "&no_text_decoration=1";
		else params = params + "&no_text_decoration=0";
		params = params + "&line_height=" + document.getElementById("line_height").value;
		params = params + "&line_height_units=" + document.getElementById("line_height_units").value;
		
		if (document.getElementById("shadow").checked == true) params = params + "&shadow=1";
		else params = params + "&shadow=0";
		params = params + "&shadow_color=" + document.getElementById("shadow_color").value;
		params = params + "&shadow_x_offset=" + document.getElementById("shadow_x_offset").value;
		params = params + "&shadow_y_offset=" + document.getElementById("shadow_y_offset").value;
		params = params + "&shadow_blur=" + document.getElementById("shadow_blur").value;
		
		params = params + "&bkgd_color=" + document.getElementById("bkgd_color").value;
		params = params + "&bkgd_opacity=" + document.getElementById("bkgd_opacity").value;
		params = params + "&border=" + document.getElementById("border").value;
		params = params + "&border_color=" + document.getElementById("border_color").value;
		params = params + "&border_style=" + document.getElementById("border_style").value;
		params = params + "&outline_style=" + document.getElementById("outline_style").value;
		params = params + "&border_collapse=" + document.getElementById("border_collapse").value;
		if (document.getElementById("border_top").checked == true) var border_top = 8;
		else var border_top = 0;
		if (document.getElementById("border_bottom").checked == true) var border_bottom = 4;
		else var border_bottom = 0;
		if (document.getElementById("border_left").checked == true) var border_left = 2;
		else var border_left = 0;
		if (document.getElementById("border_right").checked == true) var border_right = 1;
		else var border_right = 0;
		var border_sides = border_top | border_bottom | border_left | border_right;
		params = params + "&border_sides=" + border_sides;
		params = params + "&padding_top=" + document.getElementById("padding_top").value;
		params = params + "&padding_right=" + document.getElementById("padding_right").value;
		params = params + "&padding_bottom=" + document.getElementById("padding_bottom").value;
		params = params + "&padding_left=" + document.getElementById("padding_left").value;
		
		params = params + "&margin_top=" + document.getElementById("margin_top").value;
		params = params + "&margin_right=" + document.getElementById("margin_right").value;
		params = params + "&margin_left=" + document.getElementById("margin_left").value;
		params = params + "&margin_bottom=" + document.getElementById("margin_bottom").value;
		params = params + "&margin_top_units=" + document.getElementById("margin_top_units").value;
		if (document.getElementById("margin_top_auto").checked == true) params = params + "&margin_top_auto=1";
		else params = params + "&margin_top_auto=0";
		params = params + "&margin_right_units=" + document.getElementById("margin_right_units").value;
		if (document.getElementById("margin_right_auto").checked == true) params = params + "&margin_right_auto=1";
		else params = params + "&margin_right_auto=0";
		params = params + "&margin_left_units=" + document.getElementById("margin_left_units").value;
		if (document.getElementById("margin_left_auto").checked == true) params = params + "&margin_left_auto=1";
		else params = params + "&margin_left_auto=0";
		params = params + "&margin_bottom_units=" + document.getElementById("margin_bottom_units").value;
		if (document.getElementById("margin_bottom_auto").checked == true) params = params + "&margin_bottom_auto=1";
		else params = params + "&margin_bottom_auto=0";
		params = params + "&width=" + document.getElementById("width").value;
		params = params + "&width_units=" + document.getElementById("width_units").value;
		params = params + "&width_prefix=" + document.getElementById("width_prefix").value;
		params = params + "&height=" + document.getElementById("height").value;
		params = params + "&height_units=" + document.getElementById("height_units").value;
		params = params + "&height_prefix=" + document.getElementById("height_prefix").value;
		
		params = params + "&position=" + document.getElementById("position").value;
		params = params + "&position_left=" + document.getElementById("position_left").value;
		params = params + "&position_left_units=" + document.getElementById("position_left_units").value;
		params = params + "&position_top=" + document.getElementById("position_top").value;
		params = params + "&position_top_units=" + document.getElementById("position_top_units").value;
		params = params + "&position_right=" + document.getElementById("position_right" ).value;
		params = params + "&position_right_units=" + document.getElementById("position_right_units").value;
		params = params + "&position_bottom=" + document.getElementById("position_bottom").value;
		params = params + "&position_bottom_units=" + document.getElementById("position_bottom_units").value;
		params = params + "&z_index=" + document.getElementById("z_index").value;
		params = params + "&overflow=" + document.getElementById("overflow").value;
		params = params + "&clip_top=" + document.getElementById("clip_top").value;
		params = params + "&clip_top_units=" + document.getElementById("clip_top_units").value;
		params = params + "&clip_right=" + document.getElementById("clip_right").value;
		params = params + "&clip_right_units=" + document.getElementById("clip_right_units").value;
		params = params + "&clip_bottom=" + document.getElementById("clip_bottom").value;
		params = params + "&clip_bottom_units=" + document.getElementById("clip_bottom_units").value;
		params = params + "&clip_left=" + document.getElementById("clip_left").value;
		params = params + "&clip_left_units=" + document.getElementById("clip_left_units").value;
		params = params + "&float=" + document.getElementById("float").value;
		params = params + "&white_space=" + document.getElementById("white_space").value;

		params = params + "&background_image=" + document.getElementById("background_image").value;
		params = params + "&background_attachment=" + document.getElementById("background_attachment").value;
		params = params + "&background_repeat=" + document.getElementById("background_repeat").value;
		params = params + "&background_position=" + document.getElementById("background_position").value;
		params = params + "&background_position_x=" + document.getElementById("background_position_x").value;
		params = params + "&background_position_y=" + document.getElementById("background_position_y").value;
		params = params + "&background_position_units=" + document.getElementById("background_position_units").value;
		
		params = params + "&list_style_type=" + document.getElementById("list_style_type").value;
		params = params + "&list_style_position=" + document.getElementById("list_style_position").value;
		params = params + "&list_style_image=" + document.getElementById("list_style_image").value;
		
		params = params + "&table_layout=" + document.getElementById("table_layout").value;
		params = params + "&clear=" + document.getElementById("clear").value;
		
		params = params + "&radius_top_left=" + document.getElementById("radius_top_left").value;
		params = params + "&radius_top_left_units=" + document.getElementById("radius_top_left_units").value;
		params = params + "&radius_top_right=" + document.getElementById("radius_top_right").value;
		params = params + "&radius_top_right_units=" + document.getElementById("radius_top_right_units").value;
		params = params + "&radius_bottom_right=" + document.getElementById("radius_bottom_right").value;
		params = params + "&radius_bottom_right_units=" + document.getElementById("radius_bottom_right_units").value;
		params = params + "&radius_bottom_left=" + document.getElementById("radius_bottom_left").value;
		params = params + "&radius_bottom_left_units=" + document.getElementById("radius_bottom_left_units").value;
		
		params = params + "&box_shadow_horizontal=" + document.getElementById("box_shadow_horizontal").value;
		params = params + "&box_shadow_vertical=" + document.getElementById("box_shadow_vertical").value;
		params = params + "&box_shadow_blur=" + document.getElementById("box_shadow_blur").value;
		params = params + "&box_shadow_spread=" + document.getElementById("box_shadow_spread").value;
		params = params + "&box_shadow_color=" + document.getElementById("box_shadow_color").value;
		if (document.getElementById("box_shadow_inset").checked == true) params = params + "&box_shadow_inset=1";
		else params = params + "&box_shadow_inset=0";
		
		params = params + "&cursor=" + document.getElementById("cursor").value;
		
		params = params + "&background_size=" + document.getElementById("background_size").value;
		params = params + "&background_width=" + document.getElementById("background_width").value;
		params = params + "&background_width_units=" + document.getElementById("background_width_units").value;
		params = params + "&background_height=" + document.getElementById("background_height").value;
		params = params + "&background_height_units=" + document.getElementById("background_height_units").value;
		
//			alert(params);
		
		xmlhttp.send(params);
	}
}
</script>

</head>

<body id="workspace_body">
<div align="center" id="css_editor_div">
<table border="0" width="95%">
 <tr>
  <td align="left">
    <div class="button_heading_sub_level_1" id="edit_styles_heading"><div class="button_heading_text_sub_level_1">Edit Styles</div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
    
    <a name="top_anchor"></a>
  </td>
  <td align="right">
  	Change Style Sheet: 
  </td>
  <td align="left">
  	<form name="frmChangeStyleSheet" id="frmChangeStyleSheet" action="edit_css.php" method="post" enctype="multipart/form-data">
  	<select name="style_sheet" id="style_sheet" onChange="document.getElementById('frmChangeStyleSheet').submit();">
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_style_sheet = $row['name'];
		$tmp_description = $row['description'];
		if ($tmp_style_sheet == $style_sheet)
			echo "		<option value='$tmp_style_sheet' selected>$tmp_description</option>\n";
		else
			echo "		<option value='$tmp_style_sheet'>$tmp_description</option>\n";
	}
?>
    </select>
    </form>
  </td>
  <td align="right">
    <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'>Add/Delete Custom Style</span></div>
  </td>
 </tr>
</table>

<table width="95%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
   <form action="save_css.php" method="post" enctype="multipart/form-data" name="frm_site_styles" id="frm_site_styles">
     <table width="100%" border="1"><tr><td>
	  <table width="100%" border="0" cellspacing="1" cellpadding="1">
	  	<tr>
		  <td>
		    <table width="100%" border="0">
			  <tr>
		        <td><h3 id="class_heading">&nbsp;</h3></td>
		        <td>Use Settings Below: <input type="checkbox" name="use_table_data" id="use_table_data" value="1" onClick="enable_disable_controls(1);"></td>
                <td>
                Go to:
                <div id="goto_class_div" style="display:inline;">
                  <select name="goto_class" id="goto_class" onChange="PopulateForm(this);">
                    <option value=''>-not selected-</option>
                    <?php
				$goto_class = $_REQUEST['goto_class'];
				$search = array("PERIOD", "POUND", "SPACE", "COMMA");
				$replace = array(".", "#", " ", ",");
				$goto_class_cmp = str_replace($search, $replace, $goto_class);
				if ($class_sort_method == 1)
					$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `class`";
				else
					$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `sort_order`";
				$result = $bwb_dbh->query($query);
				while ($row = $result->fetch(PDO::FETCH_ASSOC))
				{
					$tmp_class = $row['class'];
					$tmp_desc = $row['description'];
					$tmp_class_val = str_replace($replace, $search, $tmp_class);
					if ($tmp_class == $goto_class_cmp)
						echo "<option value='$tmp_class_val' selected='selected'>$tmp_class ----- $tmp_desc</option>\n";
					else
						echo "<option value='$tmp_class_val'>$tmp_class ----- $tmp_desc</option>\n";
				}
		?>
                  </select>
                  </div>
                  
                  <span class="small_message">Sort alphabetically</span> <input type="checkbox" id="sort_alpha" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
                  </td>
                  <td align="right">
                  <div class='button_console_save' style="width:110px;" onClick="UpdateCSS();"><span class='button_console_text_w_icon'>Update</span></div>
                  </td>
		      </tr>
			</table>
		  </td>
	    </tr>
	    <tr>
		  <td>
		  
		    <table border="1" width="100%" id="text_table">
		      <tr>
			    <td>
				  <table border="0" width="100%">
				    <tr>
					  <td colspan="8" class="bold">Text</td>
				    </tr>
				    <tr>
					  <td align="right">Font: </td>
					  <td colspan="3">
					      <select name="font" id="font">
                          	<option value='-not selected-'>-not selected-</option>
					      <?php
						  $fonts = array();
						  $query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						  $result = $bwb_dbh->query($query);
						  while ($row = $result->fetch(PDO::FETCH_ASSOC))
							$fonts[$row['font']] = $row['websafe'];
						  
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
                          
                           <select name="font2" id="font2">
                           	<option value='-not selected-'>-not selected-</option>
					      <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
                          
                           <select name="font3" id="font3">
                           	<option value='-not selected-'>-not selected-</option>
					      <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
					  </td>
					  <td align="right">Font Size: </td>
					  <td><input name="font_size" type="text" id="font_size" value="" size="6" /> px</td>					
					  <td align="right">Color: </td>
					  <td>
					      <input name="text_color" type="text" id="text_color" value="" size="10" onBlur="CheckColorString(this);" /> 
					      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'text_color');">#RRGGBB</a></span>
					  </td>
				    </tr>
				    <tr>
					  <td align="right">&nbsp;</td>
					  <td class="small_message" valign="top">&radic; = websafe</td>
					  <td align="right">Align: </td>
					  <td>
					      <font size="1">
					      <select name="align" id="align">
						  <option value="-not selected-">-not selected-</option>
                          <option value="left">Left</option>
                          <option value="center">Center</option>
                          <option value="right">Right</option>
                          <option value="justify">Justify</option>
                          </select>
					      </font>
					  </td>
					  <td align="right">Vertical Align: </td>
					  <td>
					      <select name="vertical_align" id="vertical_align">
						  <option value="-not selected-">-not selected-</option>
					      <option value="baseline">Baseline</option>
					      <option value="sub">Sub</option>
					      <option value="super">Super</option>
					      <option value="top">Top</option>
					      <option value="text-top">Text Top</option>
					      <option value="middle">Middle</option>
					      <option value="bottom">Bottom</option>
					      <option value="text-bottom">Text Bottom</option>              
					      </select>
				      </td>
					  <td align="right">White Space: </td>
					  <td>
                      	<select name="white_space" id="white_space">
					     <option value='-not selected-'>-not selected-</option>
					     <option value='normal'>Normal</option>
                         <option value='nowrap'>No Wrap</option>
                         <option value='pre'>Pre</option>
                         <option value='pre-line'>Pre-Line</option>
                         <option value='pre-wrap'>Pre-Wrap</option>
                         <option value='inherit'>Inherit</option>
					     </select>
                      </td>
				    </tr>
					<tr>
					  <td align="right">Weight: </td>
					  <td>
					      <select name="weight" id="weight">
					   <option value="-not selected-">-not selected-</option>
					   <option value="normal">Normal</option>
					   <option value="bold">Bold</option>
					   <option value="bolder">Bolder</option>
					   <option value="lighter">Lighter</option>
					   <option value="100">100</option>
					   <option value="200">200</option>
					   <option value="300">300</option>
					   <option value="400">400</option>
					   <option value="500">500</option>
					   <option value="600">600</option>
					   <option value="700">700</option>
					   <option value="800">800</option>
					   <option value="900">900</option>
					   </select>
					  </td>
					  <td align="right">Font Stretch:</td>
					  <td>
					   <select name="font_stretch" id="font_stretch">
					   <option value="-not selected-">-not selected-</option>
					   <option value="normal">Normal</option>
					   <option value="wider">Wider</option>
					   <option value="narrower">Narrower</option>
					   <option value="ultra-condensed">Ultra-Condensed</option>
					   <option value="extra-condensed">Extra-Condensed</option>
					   <option value="condensed">Condensed</option>
					   <option value="semi-condensed">Semi-Condensed</option>
					   <option value="semi-expanded">Semi-Expanded</option>
					   <option value="expanded">Expanded</option>
					   <option value="extra-expanded">Extra-Expanded</option>
					   <option value="ultra-expanded">Ultra-Expanded</option>
					   </select>
					  </td>  
					  <td align="right">Line Height: </td>
					  <td colspan="2" >
					   <input name="line_height" type="text" id="line_height" value="" size="6">
                       <select name="line_height_units" id="line_height_units" onChange="CheckLineHeight(this);">
						    <option value="0">Normal</option>
						    <option value="1">Multiplier</option>
                            <option value="2">px</option>
                            <option value="3">%</option>
                            <option value="4">Inherit</option>
						</select>
					  </td>
					  <td class="small_message" align="right" valign="bottom">Click &quot;None&quot; only to explicitly enforce no text decoration.</td>
					</tr>
				    <tr>
					  <td colspan="8">
					    <table border="0" width="100%">
					      <tr>
						    <td align="center">
							   Italic: 
							   <input name="italic" type="checkbox" id="italic" value="1" />
						    </td>
						    <td align="center">
						       Underline: 
						       <input name="underline" type="checkbox" id="underline" value="1" />
						    </td>
						    <td align="center">
						       Overline: 
						       <input name="overline" type="checkbox" id="overline" value="1" />
						    </td>
						    <td align="center">
						       Blink: 
						       <input name="blink" type="checkbox" id="blink" value="1" />
						    </td>
						    <td align="center">
						       Linethrough: 
						       <input name="linethrough" type="checkbox" id="linethrough" value="1" />
						    </td>
						    <td align="center">
						       Oblique: 
						       <input name="oblique" type="checkbox" id="oblique" value="1" />
						    </td>
						    <td align="center">
						       Small Caps: 
						       <input name="small_caps" type="checkbox" id="small_caps" value="1" />
						    </td>
                            <td align="center">
						       None: 
						       <input name="no_text_decoration" type="checkbox" id="no_text_decoration" value="1" onChange="text_decoration_none_clicked();" />
						    </td>
						  </tr>
					    </table>
                        <table border="0" width="100%">
                          <tr>
                             <td align="center">
                                Shadow:
                                <input name="shadow" type="checkbox" id="shadow" value="1" onClick="enable_disable_shadow();" /> 
                            </td>
                            <td align="center">
                                Color: 
                                  <input name="shadow_color" type="text" id="shadow_color" value="" size="10" onBlur="CheckColorString(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'shadow_color');">#RRGGBB</a></span>						  </td>
                            <td align="center">
                                X-Offset: 
                                  <input name="shadow_x_offset" type="text" id="shadow_x_offset" value="" size="10" /> 
                                  px
                           </td>
                           <td align="center">
                                Y-Offset: 
                                  <input name="shadow_y_offset" type="text" id="shadow_y_offset" value="" size="10" /> 
                                  px
                           </td>
                           <td align="center">
                                Blur: 
                                  <input name="shadow_blur" type="text" id="shadow_blur" value="" size="10" /> 
                                  px
                           </td>
                         </tr>
                       </table>
					  </td>
				    </tr>
			      </table>
			    </td>
			   </tr>
             </table>
			 
	       </td>
	     </tr>
	     <tr>
	       <td>
		   
		     <table border="1" width="100%" id="background_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="4" class="bold">Background</td>
                       <td colspan="2" class="bold" style="border-left:medium #666666 double; padding-left:3px;">Table Layout</td>
                       <td colspan="2" class="bold"  style="border-left:medium #666666 double; padding-left:3px;">Cursor</td>
				     </tr>
				     <tr>
					   <td align="right">Background Color: </td>
					   <td>
					     <input name="bkgd_color" type="text" id="bkgd_color" value="" size="10" onBlur="CheckColorString(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'bkgd_color');"> #RRGGBB</a></span>
					   </td>					  
					   <td align="right">Opacity: </td>
					   <td>
					     <input name="bkgd_opacity" type="text" id="bkgd_opacity" value="" size="10" /> % 
					   </td>
					   <td align="right"  style="border-left:medium #666666 double;">Table Layout:</td>
					   <td>
                       <select name="table_layout" id="table_layout">
					     <option value="-not selected-">-not selected-</option>
                         <option value="auto">Auto</option>
                         <option value="fixed">Fixed</option>
					   </select>
                       </td>
                       <td align="right" style="border-left:medium #666666 double;">Cursor: </td>
					   <td>
                       <select name="cursor" id="cursor">
					     <option value="-not selected-">-not selected-</option>
                         <option value="pointer">Pointer</option>
                         <option value="crosshair">Crosshair</option>
                         <option value="default">Default</option>
                         <option value="wait">Wait</option>
                         <option value="help">Help</option>
                         <option value="none">None</option>
                         <option value="alias">Alias</option>
                         <option value="all-scroll">All Scroll</option>
                         <option value="auto">Auto</option>
                         <option value="cell">Cell</option>
                         <option value="context-menu">Context Menu</option>
                         <option value="col-resize">Column Resize</option>
                         <option value="row-resize">Row Resize</option>
                         <option value="copy">Copy</option>
                         <option value="move">Move</option>
                         <option value="no-drop">No-Drop</option>
                         <option value="not-allowed">Not Allowed</option>
                         <option value="progress">Progress</option>
                         <option value="text">Text</option>
                         <option value="vertical-text">Vertical Text</option>
                         <option value="e-resize">East-Resize</option>
                         <option value="ew-resize">East-West Resize</option>
                         <option value="n-resize">North Resize</option>
                         <option value="ne-resize">North-East Resize</option>
                         <option value="nesw-resize">North-East-South-West Resize</option>
                         <option value="ns-resize">North-South Resize</option>
                         <option value="nw-resize">North-West Resize</option>
                         <option value="nwse-resize">North-West-South-East Resize</option>
                         <option value="s-resize">South Resize</option>
                         <option value="se-resize">South-East Resize</option>
                         <option value="sw-resize">South-West Resize</option>
                         <option value="w-resize">West Resize</option>
                         <option value="zoom-in">Zoom In</option>
                         <option value="zoom-out">Zoom Out</option>
                         <option value="inherit">Inherit</option>
					   </select>
					   </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
         <tr>
	       <td>
		   
		     <table border="1" width="100%" id="border_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Border</td>
				     </tr>
				     <tr>
					   <td align="right">Border: </td>
					   <td>
					     <input name="border" type="text" id="border" value="" size="6" onChange="CheckBorderParams(this);" /> px
					   </td>					  
					   <td align="right">Border Color: </td>
					   <td>
					     <input name="border_color" type="text" id="border_color" value="" size="10" onBlur="CheckColorString(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'border_color');"> #RRGGBB</a></span>
                         </td>
					   <td align="right">Border Style: </td>
					   <td>
                       <select name="border_style" id="border_style" onChange="CheckBorderParams(this);">
					     <option value="-not selected-">-not selected-</option>
                         <option value="none">None</option>
					     <option value="hidden">Hidden</option>
                         <option value="dotted">Dotted</option>
                         <option value="dashed">Dashed</option>
                         <option value="solid">Solid</option>
                         <option value="double">Double</option>
                         <option value="groove">Groove</option>
                         <option value="ridge">Ridge</option>
                         <option value="inset">Inset</option>
                         <option value="outset">Outset</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>
					   <td align="right">Outline Style: </td>
					   <td>
                       <select name="outline_style" id="outline_style">
					     <option value="-not selected-">-not selected-</option>
                         <option value="none">None</option>
                         <option value="dotted">Dotted</option>
                         <option value="dashed">Dashed</option>
                         <option value="solid">Solid</option>
                         <option value="double">Double</option>
                         <option value="groove">Groove</option>
                         <option value="ridge">Ridge</option>
                         <option value="inset">Inset</option>
                         <option value="outset">Outset</option>
                         <option value="inherit">Inherit</option>
					     </select>
					   </td>
                       <td align="right">Border Collapse: </td>
					   <td>
                       <select name="border_collapse" id="border_collapse">
					     <option value="-not selected-">-not selected-</option>
                         <option value="collapse">Collapse</option>
                         <option value="separate">Separate</option>
                         <option value="inherit">Inherit</option>
					     </select>
					   </td>
				     </tr>
                  </table>
                  <table width="100%" border="0">
                     <tr>
                       <td>Top: <input name="border_top" type="checkbox" id="border_top" value="1" /> </td>
                       <td>Bottom: <input name="border_bottom" type="checkbox" id="border_bottom" value="1" /> </td>
                       <td>Left: <input name="border_left" type="checkbox" id="border_left" value="1" /> </td>
                       <td>Right: <input name="border_right" type="checkbox" id="border_right" value="1" /> </td>
					   <td align="right" class="bold">Padding</td>
					   <td align="right">
                       Top:</td>					  
					   <td>
                       <input name="padding_top" type="text" id="padding_top" value="" size="6"> px
                       </td>
					   <td align="right">Right:</td>
					   <td>
                       <input name="padding_right" type="text" id="padding_right" value="" size="6"> px
                       </td>
					   <td align="right">Bottom:</td>
					   <td>
                       <input name="padding_bottom" type="text" id="padding_bottom" value="" size="6"> px
                       </td>
					   <td align="right">Left:</td>
                       <td>
                       <input name="padding_left" type="text" id="padding_left" value="" size="6"> px
                       </td>
				     </tr>
                  </table>
                  <table  width="100%" border="0">
                     <tr>
					   <td align="right" class="bold">Radius</td>
					   <td align="right">
                       Top Left: </td>					  
					   <td>
                       <input type="text" name="radius_top_left" id="radius_top_left" value="" size="6">
                       <select name="radius_top_left_units" id="radius_top_left_units">
                        <option value="0">px</option>
                        <option value="1">%</option>
                       </select> 
                       </td>
					   <td align="right">Top Right: </td>
					   <td>
                       <input type="text" name="radius_top_right" id="radius_top_right" value="" size="6">
                       <select name="radius_top_right_units" id="radius_top_right_units">
                        <option value="0">px</option>
                        <option value="1">%</option>
                       </select> 
                       </td>
					   <td align="right">Bottom Right: </td>
					   <td>
                       <input type="text" name="radius_bottom_right" id="radius_bottom_right" value="" size="6">
                       <select name="radius_bottom_right_units" id="radius_bottom_right_units">
                        <option value="0">px</option>
                        <option value="1">%</option>
                       </select> 
                       </td>
					   <td align="right">Bottom Left: </td>
                       <td>
                       <input type="text" name="radius_bottom_left" id="radius_bottom_left" value="" size="6">
                       <select name="radius_bottom_left_units" id="radius_bottom_left_units">
                        <option value="0">px</option>
                        <option value="1">%</option>
                       </select> 
                       </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
	     <tr>
	       <td>
			 
	         <table border="1" width="100%" id="margin_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="4" class="bold">Margin </td>
                       <td colspan="4" align="center"><span class="small_message">Click &quot;Auto&quot; only to explicitly enforce auto margin.</span></td>
                       <td colspan="2" style="border-left:medium #666666 double; padding-left:3px;"><span class="bold">Size</span></td>
				     </tr>
				     <tr>
					   <td align="right">Top: </td>
					   <td>
						  <input name="margin_top" type="text" id="margin_top" value="" size="6" />
						  <select name="margin_top_units" id="margin_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select> 
                       </td>					  
					   <td align="right">Right: </td>
					   <td>
					     <input name="margin_right" type="text" id="margin_right" value="" size="6" /> 				
                         <select name="margin_right_units" id="margin_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Left: </td>
					   <td>
					     <input name="margin_left" type="text" id="margin_left" value="" size="6"/>
                         	<select name="margin_left_units" id="margin_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select> 
					   </td>
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="margin_bottom" type="text" id="margin_bottom" value="" size="6" />
                         <select name="margin_bottom_units" id="margin_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
                       <td align="right" style="border-left:medium #666666 double;">Width: </td>
					   <td>
					     <input name="width" type="text" id="width" value="" size="6" />
					     <select name="width_units" id="width_units">
                          <option value="0">px</option>
                          <option value="1">%</option>
					     </select>
                         <select name="width_prefix" id="width_prefix">
                          <option value="-not selected-"></option>
                          <option value="min">Min</option>
                          <option value="max">Max</option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                     	<td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_top_auto" type="checkbox" id="margin_top_auto" value="1" onChange="margin_auto_clicked('top')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_right_auto" type="checkbox" id="margin_right_auto" value="1" onChange="margin_auto_clicked('right')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_left_auto" type="checkbox" id="margin_left_auto" value="1" onChange="margin_auto_clicked('left')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        Auto: 
                        <input name="margin_bottom_auto" type="checkbox" id="margin_bottom_auto" value="1" onChange="margin_auto_clicked('bottom')" />
                        </td>
                        <td align="right" style="border-left:medium #666666 double;">Height: </td>
					   <td>
					     <input name="height" type="text" id="height" value="" size="6" />
                         <select name="height_units" id="height_units">
                          <option value="0">px</option>
                          <option value="1">%</option>
					     </select>
                         <select name="height_prefix" id="height_prefix">
                          <option value="-not selected-"></option>
                          <option value="min">Min</option>
                          <option value="max">Max</option>
					     </select>
					   </td>
                     </tr>
			       </table>
                   
                </td>
               </tr>
              </table>
                   
               <table border="1" width="100%" id="position_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Position</td>
				     </tr>
				     <tr>
                       <td align="right">Positioning: </td>
					   <td><select name="position" id="position">
                         <option value="-not selected-">-not selected-</option>
					     <option value="absolute">Absolute</option>
					     <option value="fixed">Fixed</option>
                         <option value="relative">Relative</option>
                         <option value="static">Static</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>
					   <td align="right">Left: </td>
					   <td>
						  <input name="position_left" type="text" id="position_left" value="" size="6" />
						  <select name="position_left_units" id="position_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
                        </td>					  
					   <td align="right">Top: </td>
					   <td>
					     <input name="position_top" type="text" id="position_top" value="" size="6" />
                         <select name="position_top_units" id="position_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Right: </td>
					   <td>
					     <input name="position_right" type="text" id="position_right" value="" size="6" />
                         <select name="position_right_units" id="position_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="position_bottom" type="text" id="position_bottom" value="" size="6" />
                         <select name="position_bottom_units" id="position_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
				     </tr>
                     <tr>
                       <td align="right">Display: </td>
					   <td>
                       <select name="display" id="display">
						  <option value="-not selected-">-not selected-</option>
					      <option value="none">None</option>
					      <option value="inline">Inline</option>
					      <option value="block">Block</option>
                          <option value="inline-block">Inline-Block</option>
					      <option value="list-item">List Item</option>
					      <option value="run-in">Run In</option>
					      <option value="compact">Compact</option>
					      <option value="marker">Marker</option>
					      <option value="table">Table</option>
					      <option value="inline-table">Inline Table</option>
					      <option value="table-row-group">Table Row Group</option>
					      <option value="table-footer-group">Table Footer Group</option>
					      <option value="table-row">Table Row</option>
					      <option value="table-column-group">Table Column Group</option>
					      <option value="table-column">Table Column</option>
					      <option value="table-cell">Table Cell</option>
					      <option value="table-caption">Table Caption</option>
					      </select>
                       </td>
					   <td align="right">Z Index:</td>
					   <td>
                       <input name="z_index" type="text" id="z_index" value="" size="6" />
                        </td>					  
					   <td align="right">Overflow:</td>
					   <td>
                       <select name="overflow" id="overflow">
					     <option value="-not selected-">-not selected-</option>
                         <option value="visible">Visible</option>
					     <option value="hidden">Hidden</option>
                         <option value="scroll">Scroll</option>
                         <option value="auto">Auto</option>
                         <option value="inherit">Inherit</option>
					     </select>
                       </td>					
					   <td align="right">Float: </td>
					   <td>
                       <select name="float" id="float">
					     <option value='-not selected-'>-not selected-</option>
                         <option value='left'>Left</option>
                         <option value='right'>Right</option>
                         <option value='none'>None</option>
                         <option value='inherit'>Inherit</option>
					     </select>
                       </td>
					   <td align="right">Clear: </td>
					   <td>
                       <select name="clear" id="clear">
					     <option value="-not selected-">-not selected-</option>
                         <option value="left">Left</option>
                         <option value="right">Right</option>
                         <option value="both">Both</option>
                         <option value="none">None</option>
                         <option value="inherit">Inherit</option>
					   </select>
                       </td>
				     </tr>
                     <tr>
                       <td>&nbsp;</td>
					   <td align="right">Clipping:</td>
					   <td align="right">Top: </td>
					   <td>
						  <input name="clip_top" type="text" id="clip_top" value="" size="6" />
						  <select name="clip_top_units" id="clip_top_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
                        </td>					  
					   <td align="right">Right: </td>
					   <td>
					     <input name="clip_right" type="text" id="clip_right" value="" size="6" /> 				
                         <select name="clip_right_units" id="clip_right_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>					
					   <td align="right">Bottom: </td>
					   <td>
					     <input name="clip_bottom" type="text" id="clip_bottom" value="" size="6" /> 					
                         <select name="clip_bottom_units" id="clip_bottom_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
					   <td align="right">Left: </td>
					   <td>
					     <input name="clip_left" type="text" id="clip_left" value="" size="6" /> 				
                         <select name="clip_left_units" id="clip_left_units">
						    <option value="0">px</option>
						    <option value="1">%</option>
						    </select>
					   </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>
             
             <table border="1" width="100%" id="background_img_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold">Background Image</td>
				     </tr>
				     <tr>
					   <td align="right">Image: </td>
					   <td align="right" width="110">
                       <div id='preview1'><img alt='photo' src='/manage/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img1' /></div>
                       </td>					  
					   <td align="left" colspan="2">
                       <input type='file' name='file_browse1' id='file_browse1' onChange="upload_index=1; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse1&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=http://<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=http://<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview1','&lt;br /&gt;&lt;img src=\'/wizard/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/wizard/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>				
					   <td align="right">Attachment:</td>
					   <td><select name="background_attachment" id="background_attachment">
                         <option value="-not selected-">-not selected-</option>
                         <option value="fixed">Fixed</option>
					     <option value="scroll">Scrolling</option>
					     </select></td>
					   <td align="right">Repeat:</td>
					   <td><select name="background_repeat" id="background_repeat">
					     <option value="-not selected-">-not selected-</option>
                         <option value="repeat">Repeat</option>
					     <option value="repeat-x">Repeat Horizontally</option>
					     <option value="repeat-y">Repeat Vertically</option>
					     <option value="no-repeat">No Repeat</option>
					     </select></td>
                       <td align="right">&nbsp;</td>
					   <td>&nbsp;</td>
				     </tr>
                     <tr>
					   <td align="center" colspan="4">
                       
                       	<!-- <input type="file" name="browse_image" id="browse_image" />	-->
                        <select name="background_image" id="background_image" onChange="UpdateImage(1);">
                       		<option value='-not selected-'>-not selected-</option>
                       <?php
					   $file_arr = array();
					   
					   	if ($handle = opendir($path)) 
						{
							/* This is the correct way to loop over the directory. */
							while (false !== ($file = readdir($handle)))
							{
								if (($file != ".") && ($file != "..") && ($file != "tn") && ($file != "gallery") && ($file != "lightbox") && ($file != "orig"))
								{
									if (is_dir($path . "/" . $file))
									{
										$path2 = $path . "/" . $file;
										if ($handle2 = opendir($path2))
										{
											while (false !== ($file2 = readdir($handle2)))
											{
												if (($file2 != ".") && ($file2 != "..") && ($file2 != "tn") && ($file2 != "gallery") && ($file2 != "lightbox") && ($file2 != "orig"))
													$file_arr[] = $file . "/" . $file2;
											}
											closedir($handle2);
										}
									}
									else
										$file_arr[] = $file;
								}
							}
							closedir($handle);
							
							sort($file_arr);
							foreach($file_arr as $file)
							{
								if ($background_image == $file)
									echo "      <option value='$file' selected='selected'>$file</option>\n";
								else
									echo "      <option value='$file'>$file</option>\n";
							}
					    } 
                       ?>
					     </select>
                       </td>
                       <td colspan="6">
                       <table border="1" width="100%">
                       <tr>
                       <td>
                       <table border="0" width="100%">
                       <tr>
                           <td align="right">Position:</td>
                           <td><select name="background_position" id="background_position" onChange="enable_disable_background_positions();">
                             <option value="-not selected-">-not selected-</option>
                             <option value="top left">top left</option>
                             <option value="top center">top center</option>
                             <option value="top right">top right</option>
                             <option value="center left">center left</option>
                             <option value="center center">center center</option>
                             <option value="center right">center right</option>
                             <option value="bottom left">bottom left</option>
                             <option value="bottom center">bottom center</option>
                             <option value="bottom right">bottom right</option>
                             <option value="xpos ypos">xpos ypos</option>
                             </select></td>
                           <td align="right">X:</td>
                           <td><input name="background_position_x" type="text" id="background_position_x" value="" size="6" /></td>
                           <td align="right">Y:</td>
                           <td><input name="background_position_y" type="text" id="background_position_y" value="" size="6" /></td>
                           <td>
                             <select name="background_position_units" id="background_position_units">
                               <option value="0">px</option>
                               <option value="1">%</option>
                             </select>
                           </td>
                        </tr>
                       </table>
                       
                       </td>       
                      </tr>
			       </table>
		
			     </td>
			   </tr>
                <tr>
                  <td colspan="3">&nbsp;</td>
                  <td colspan="7">
                    <table border="1" width="100%"><tr><td>
                    <table border="0" width="100%">
                      <tr>
                        <td align="right">Size:</td>
                        <td>
                        <select name="background_size" id="background_size" onChange="enable_disable_background_sizes();">
                         <option value="-not selected-">-not selected-</option>
                         <option value="scale">Scale</option>
                         <option value="cover">Cover</option>
                         <option value="contain">Contain</option>
                        </select>
                        </td>
                        <td align="right">Width:</td>
                        <td><input name="background_width" type="text" id="background_width" value="" size="6" /></td>
                        <td>
                         <select name="background_width_units" id="background_width_units">
                           <option value="0">px</option>
                           <option value="1">%</option>
                         </select>
                        </td>
                        <td align="right">Height:</td>
                        <td><input name="background_height" type="text" id="background_height" value="" size="6" /></td>
                        <td>
                          <select name="background_height_units" id="background_height_units">
                           <option value="0">px</option>
                           <option value="1">%</option>
                         </select>
                        </td>
                      </tr>
                    </table> 
                    </td></tr></table>
                  </td>
                </tr>
	         </table>
			 
	       </td>
	     </tr>
	   </table>
       
       <table border="1" width="100%" id="list_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="8" class="bold">List</td>
				     </tr>
				     <tr>
                       <td align="right">Type: </td>
					   <td><select name="list_style_type" id="list_style_type">
					     <option value="-not selected-">-not selected-</option>
					     <option value="none">None</option>
					     <option value="disc">Disc</option>
					     <option value="circle">Circle</option>
					     <option value="square">Square</option>
					     <option value="decimal">Decimal</option>
					     <option value="decimal-leading-zero">Decimal Leading Zero</option>
					     <option value="lower-roman">Lower Roman</option>
					     <option value="upper-roman">Upper Roman</option>
					     <option value="lower-alpha">Lower Alpha</option>
					     <option value="upper-alpha">Upper Alpha</option>
					     <option value="lower-greek">Lower Greek</option>
					     <option value="lower-latin">Lower Latin</option>
					     <option value="upper-latin">Upper Latin</option>
					     <option value="hebrew">Hebrew</option>
					     <option value="armenian">Armenian</option>
					     <option value="gorgian">Georgian</option>
					     <option value="cjk-ideographic">CJK-Ideographic</option>
					     <option value="hiragana">Hiragana</option>
					     <option value="katakana">Katakana</option>
					     <option value="hiragana-iroha">Hiragana Iroha</option>
					     <option value="katakana-iroha">Katakana Iroha </option>
					     </select>
                       </td>
					   <td align="right">Position: </td>
					   <td><select name="list_style_position" id="list_style_position">
					     <option value="-not selected-">-not selected-</option>
					     <option value="inside">Inside</option>
					     <option value="outside">Outside</option>
					     <option value="inherit">Inherit</option>
					     </select></td>					  
					   <td align="right">Image: </td>
					   <td align="right" width="110">
                       <div id='preview2'><img alt='photo' src='/manage/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img2' /></div>
                       </td>					
					   <td>
                       <input type='file' name='file_browse2' id='file_browse2' onChange="upload_index=2; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse2&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=http://<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=http://<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview2','&lt;br /&gt;&lt;img src=\'/wizard/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/wizard/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>
					   <td>
                       	<select name="list_style_image" id="list_style_image" onChange="UpdateImage(2);">
					     <option value='-not selected-'>-not selected-</option>
					   <?php
						foreach($file_arr as $file)
						{
							if ($list_style_image == $file)
								echo "      <option value='$file' selected='selected'>$file</option>\n";
							else
								echo "      <option value='$file'>$file</option>\n";
						}
                       ?>
					     </select>
                       </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>

			<table border="1" width="100%" id="box_shadow_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="12">Box Shadow</td>
                  </tr>
                  <tr>
                    <td align="right">Horizontal Offset: </td>
                    <td><input type="text" name="box_shadow_horizontal" id="box_shadow_horizontal" value="" size="6" /></td>
                    <td align="right">Vertical Offset: </td>
                    <td><input type="text" name="box_shadow_vertical" id="box_shadow_vertical" value="" size="6" /></td>
                    <td align="right">Blur: </td>
                    <td><input type="text" name="box_shadow_blur" id="box_shadow_blur" value="" size="6" /></td>
                    <td align="right">Spread: </td>
                    <td><input type="text" name="box_shadow_spread" id="box_shadow_spread" value="" size="6" /></td>
                    <td align="right">Color: </td>
                    <td><input type="text" name="box_shadow_color" id="box_shadow_color" value="" size="6" onBlur="CheckColorString(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'box_shadow_color');">#RRGGBB</a></span></td>
                    <td align="right">Inset: </td>
                    <td><input type="checkbox" name="box_shadow_inset" id="box_shadow_inset" value="1" /></td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
             
	 </td></tr></table>
     </td>
     <tr><td align="center">
     <table width="100%">
       <tr>
     	<td align="center">
            <div class='button_console_preview' style="width:110px;" onClick="SubmitForm('Preview');"><span class='button_console_text_w_icon'>Preview</span></div>
            <input type="hidden" name="MAX_FILE_SIZE" value="500000" />
            <input type="hidden" name="browse_image_control" value="file_browse1"/>
            <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
            <input type="hidden" name="show_class_editor" value="<?php echo $show_class_editor; ?>" />
            <input type="hidden" name="class" id="goto_class" value="<?php echo $goto_class; ?>"/>
            <input type="hidden" name="submit_action" id="submit_action" />
        </td>
        <td align="center" width="70%">&nbsp;
        	
        </td>
        <td align="center">
            <div class='button_console_save' style="width:110px;" onClick="UpdateCSS();"><span class='button_console_text_w_icon'>Update</span></div>
        </td>
       </tr>
      </table>
      </td></tr></table>
      </form>
	 
	   <table width="100%" border="0" cellspacing="1" cellpadding="1"> 
       <?php
	   		if (($show_class_editor == 1) || ($style_sheet == "site"))
			{
		?>
	     <tr>
          <?php
	   		if ($style_sheet == "site")
			{
		  ?>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadBrowserResetParams();"><span class='button_console_text'>Load Browser Reset CSS</span></div>
           </td>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadCenterParams();"><span class='button_console_text'>Setup For Centered Pages</span></div>
           </td>
           <td>
                <div class='button_console' style="width:200px;" onClick="LoadStickyFooterParams();"><span class='button_console_text'>Setup For Sticky Footer</span></div>
           </td>
           <?php
			}
		 
	   		if ($show_class_editor == 1)
			{
		   ?>
		 	<td align="center">
            <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'>Add/Delete Custom Style</span></div>
            </td>
          <?php
			}
		  ?>
		 </tr>
         <?php
			}
		?>
       </table>

	 </td>
   </tr>
</table>
<a name="bottom_anchor"></a>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	enable_disable_controls(0);
	HidePopupMsg();
	
<?php
if ($goto_class)
	echo "	PopulateForm(document.getElementById('goto_class'));\n";
?>
</script>
</body>
</html>