<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/09	ELL
// Revised: 11/11/09	ELL
// Added options for proportional item widths.
// Modified: 10/7/2010		ELL
// Added text align.
// Modified: 2/4/2012	ELL
// Added selection for having sub menus collapse and expand.  Default is to collapse and expand.  New option is to show always expanded.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 6/19/2013	ELL
// Added separate text alignment for sub menus.
// Revised: 12/16/2013	ELL
// Modified menu location buttons to only suggest entries.  Added bottom and right offsets as well as manually
// editted positioning.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#css_menu_parameters_heading	{	width:370px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:330px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script src="js/edit_css_menu_params.js" language="javascript" type="text/javascript"></script>

</head>

<body id="workspace_body">

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="css_menu_parameters_heading"><div class="button_heading_text_sub_level_1">CSS Menu Parameters Quick-Setup Editor</div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="40%">
Select a menu to add items to:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
</select>
</td>
</tr>
</table>

<?php
	if (($menu == "-not selected-") || ($menu == ""))
	{
		echo "Please select a menu to edit menu items.";
		exit;
	}
	else
		$suffix = substr($menu, 4);
	
	$menu_source  = "menu" . $suffix . "_items" ;
	
	$menu_css_table = $menu . "_css" ;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["display"] == "inline")
		$orientation = "horizontal";
	else
		$orientation = "vertical";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["display"] == "table-cell")
		$orientation = "horizontal";
	else
		$orientation = "vertical";
	if (!is_null($row["width"]))
		$top_level_item_width = $row["width"];
	else
		$top_level_item_width = -1;
	$top_level_item_width_units = $row["width_units"];
	if (!is_null($row["line_height"]))
		$top_level_item_height = $row["line_height"];
	else
		$top_level_item_height = -1;
	$top_level_item_height_units = $row["line_height_units"];
	
	if (!is_null($row["padding_top"]))
		$top_level_padding_top = $row["padding_top"];
	else
		$top_level_padding_top = 2;
	if (!is_null($row["padding_right"]))
		$top_level_padding_right = $row["padding_right"];
	else
		$top_level_padding_right = 8;
	if (!is_null($row["padding_bottom"]))
		$top_level_padding_bottom = $row["padding_bottom"];
	else
		$top_level_padding_bottom = 2;
	if (!is_null($row["padding_left"]))
		$top_level_padding_left = $row["padding_left"];
	else
		$top_level_padding_left = 8;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li>ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["margin_top"]))
		$sub_level_offset_top = $row["margin_top"];
	elseif ($orientation == "horizontal")
		$sub_level_offset_top = 0;
	else
		$sub_level_offset_top = 20;
	if (!is_null($row["margin_left"]))
		$sub_level_offset_left = $row["margin_left"];
	elseif ($orientation == "horizontal")
		$sub_level_offset_left = 140;
	else
		$sub_level_offset_left = 20;
		
	if (!is_null($row["width"]))
		$sub_level_item_width = $row["width"];
	else
		$sub_level_item_width = 140;
	$sub_level_item_width_units = $row["width_units"];
	if (!is_null($row["line_height"]))
		$sub_level_item_height = $row["line_height"];
	else
		$sub_level_item_height = -1;
	$sub_level_item_height_units = $row["line_height_units"];
	
	if (!is_null($row["display"]))
	{
		if ($row["display"] == "none")
			$sub_level_collapse = true;
		else
			$sub_level_collapse = false;
	}
	else
		$sub_level_collapse = true;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["padding_top"]))
		$sub_level_padding_top = $row["padding_top"];
	else
		$sub_level_padding_top = 2;
	if (!is_null($row["padding_right"]))
		$sub_level_padding_right = $row["padding_right"];
	else
		$sub_level_padding_right = 10;
	if (!is_null($row["padding_bottom"]))
		$sub_level_padding_bottom = $row["padding_bottom"];
	else
		$sub_level_padding_bottom = 2;
	if (!is_null($row["padding_top"]))
		$sub_level_padding_left = $row["padding_left"];
	else
		$sub_level_padding_left = 10;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (($row["table_layout"] == "fixed") && ($orientation == "horizontal"))
		$orientation = "horizontal_variable_width";
	elseif ($orientation == "horizontal")
		$orientation = "horizontal_fixed_width";
	if (!is_null($row["width"]))
		$menu_width = $row["width"];
	else
		$menu_width = 100;
	$menu_width_units = $row["width_units"];
	$top_level_text_align = $row["align"];
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.menu_div" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["position_top"]))
		$menu_top = $row["position_top"];
	else
		$menu_top = -1000000;
	if (!is_null($row["position_left"]))
		$menu_left = $row["position_left"];
	else
		$menu_left = -1000000;
	if (!is_null($row["position_bottom"]))
		$menu_bottom = $row["position_bottom"];
	else
		$menu_bottom = -1000000;
	if (!is_null($row["position_right"]))
		$menu_right = $row["position_right"];
	else
		$menu_right = -1000000;
	if (!is_null($row["position"]))
		$position = $row["position"];
	else
		$position = "absolute";
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$sub_level_text_align = $row["align"];
		
	/////////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menus WHERE menu_name = '" . $menu . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$proportional_width_top = $row["proportional"];
	$proportional_width_sub = $row["proportional_sub"];
?>

<form name="frm_menu_params" id="frm_menu_params" action="save_css_menu_params.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td>
		<table width="100%" class="layout_box_table" cellspacing="1" cellpadding="1">
        <tr>
        	<td class="bold" colspan="9">Menu Layout and Origin (from upper left of page) </td>
        </tr>
        <tr>
            <td width="25%">
            Menu Location:<br>
              <input type="radio" name="MenuLocationGroup" value="header" id="MenuLocationGroup_0" onChange="PreloadLocationDefaults('header');" />
              Header<br>	
              <input type="radio" name="MenuLocationGroup" value="top" id="MenuLocationGroup_1" onChange="PreloadLocationDefaults('top');" />
              Top<br>
              <input type="radio" name="MenuLocationGroup" value="left" id="MenuLocationGroup_2" onChange="PreloadLocationDefaults('left');" />
              Left<br>
                <input type="radio" name="MenuLocationGroup" value="right" id="MenuLocationGroup_3" onChange="PreloadLocationDefaults('right');" />
              Right<br>
              <input type="radio" name="MenuLocationGroup" value="bottom" id="MenuLocationGroup_4" onChange="PreloadLocationDefaults('bottom');" />
              Bottom<br>
                <input type="radio" name="MenuLocationGroup" value="footer" id="MenuLocationGroup_5" onChange="PreloadLocationDefaults('footer');" />
              Footer<br>
                <span class="extra_small_message">Note: Selecting any of the above locations does not assign menu to one of these areas. It merely highlights this form with the typical settings for the selected area.</span>
            </td>
            <td valign="top">
            Orientation:<br>
              <span id="vertical">
              <input type="radio" name="OrientationGroup" value="vertical" id="OrientationGroup_0" <?php if ($orientation == "vertical") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('vertical');">
              </span>
              Vertical
              <br>
              <span id="horizontal_fixed">
              <input type="radio" name="OrientationGroup" value="horizontal_fixed_width" id="OrientationGroup_1" <?php if ($orientation == "horizontal_fixed_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_fixed_width');">
              </span>
              Horizontal (fixed width)
              <br>
              <span id="horizontal_variable">
              <input type="radio" name="OrientationGroup" value="horizontal_variable_width" id="OrientationGroup_2" <?php if ($orientation == "horizontal_variable_width") echo "checked='checked'"; ?> onChange="javascript:LoadOrientationDefaults('horizontal_variable_width');">
              </span>
              Horizontal (variable width)
            </td>
            <td>
                <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                <td colspan="2">Offset: </td>
                </tr>
                <tr>
                <td>Top: </td>
                <td id="offset_top"><input name="menu_top" type="text" id="menu_top" value="<?php echo $menu_top; ?>" size="10" /></td>
                </tr>
                <tr>
                <td>Left: </td>
                <td id="offset_left"><input name="menu_left" type="text" id="menu_left" value="<?php echo $menu_left; ?>" size="10" /></td>
                </tr>
                <tr>
                <td>Bottom: </td>
                <td id="offset_bottom"><input name="menu_bottom" type="text" id="menu_bottom" value="<?php echo $menu_bottom; ?>" size="10" /></td>
                </tr>
                <tr>
                <td>Right: </td>
                <td id="offset_right"><input name="menu_right" type="text" id="menu_right" value="<?php echo $menu_right; ?>" size="10" /></td>
                </tr>
                </table>
            </td>
            <td valign="top">
            Menu Width:<br>
            <input name="menu_width" type="text" id="menu_width" value="<?php echo $menu_width; ?>" size="10" />
              <select name="menu_width_units" id="menu_width_units">
                <option value="0" <?php if ($menu_width_units == 0) echo "selected='selected'"; ?>>px</option>
                <option value="1" <?php if ($menu_width_units == 1) echo "selected='selected'"; ?>>%</option>
              </select>
              <br/><br/>Positioning:<br/>
              <span id="absolute">
              <input type="radio" name="PositionGroup" value="absolute" id="PositionGroup_0" <?php if ($position != "relative") echo "checked='checked'"; ?> />
              </span>
              Absolute<br>
              <span id="relative">
               <input type="radio" name="PositionGroup" value="relative" id="PositionGroup_1" <?php if ($position == "relative") echo "checked='checked'"; ?> />
               </span>
              Relative<br>
              </td>
      </tr>
      </table>
      
      <table width="100%" class="layout_box_table" cellspacing="1" cellpadding="1">
	  <tr>
	    <td class="bold">&nbsp;</td>
	    </tr>
      </table>
      
       </td>
      </tr>
      <tr>
      <td>
      
      <table width="100%" class="layout_box_table">
	  <tr>
		 <td class="bold">Menu Item Size and Padding</td>
	  </tr>
	  <tr>
      <td>
      <table width="100%" class="layout_box_table">
      <tr>
		<td align="right">Width: </td>
		<td>
          <input name="top_level_item_width" type="text" id="top_level_item_width" value="<?php echo $top_level_item_width; ?>" size="10" />
          
		  <select name="top_level_item_width_units" id="top_level_item_width_units">
		   <option value="0" <?php if ($top_level_item_width_units == 0) echo "selected='selected'"; ?>>px</option>
           <option value="1" <?php if ($top_level_item_width_units == 1) echo "selected='selected'"; ?>>%</option>
		  </select>
 
        	<input name="proportional_width_top" type="checkbox" value="1" <?php if ($proportional_width_top == 1) echo " checked='checked'"; ?>>
        	Proportional
        </td>
		<td align="right">Height: </td>
		<td align="left">
        	<input name="top_level_item_height" type="text" id="top_level_item_height" value="<?php echo $top_level_item_height; ?>" size="10" />
        
               <select name="top_level_item_height_units" id="top_level_item_height_units">
                <option value="2" <?php if ($top_level_item_height_units == 2) echo "selected='selected'"; ?>>px</option>
                <option value="3" <?php if ($top_level_item_height_units == 3) echo "selected='selected'"; ?>>%</option>
               </select>
		</td>
        <td align="right">Text Alignment: </td>
		<td align="left">
               <select name="top_level_text_align" id="top_level_text_align">
                <option value="-not selected-">-not selected-</option>
                <option value="left" <?php if ($top_level_text_align == "left") echo "selected='selected'"; ?>>Left</option>
                <option value="center" <?php if ($top_level_text_align == "center") echo "selected='selected'"; ?>>Center</option>
                <option value="right" <?php if ($top_level_text_align == "right") echo "selected='selected'"; ?>>Right</option>
                <option value="justify" <?php if ($top_level_text_align == "justify") echo "selected='selected'"; ?>>Justify</option>
               </select>
		</td>
        </tr>
        </table>
        
        </td>
	  </tr>
      <tr>
      <td>
      <table width="100%" class="layout_box_table">
      <tr>
        <td align="center" class="bold">Padding</td>
        <td align="right">Top: </td>
        <td>
            <input name="top_level_padding_top" type="text" id="top_level_padding_top" value="<?php echo $top_level_padding_top; ?>" size="10">
         </td>
         <td align="right">Right: </td>
         <td>
          <input name="top_level_padding_right" type="text" id="top_level_padding_right" value="<?php echo $top_level_padding_right; ?>" size="10"> 
         </td>
         <td align="right">Bottom: </td>
         <td>
          <input name="top_level_padding_bottom" type="text" id="top_level_padding_bottom" value="<?php echo $top_level_padding_bottom; ?>" size="10"> 
         </td>
         <td align="right">Left: </td>
         <td>
          <input name="top_level_padding_left" type="text" id="top_level_padding_left" value="<?php echo $top_level_padding_left; ?>" size="10">
         </td>
         </tr>
        </table> 
       </td>
      </tr> 
      </table>
      
      <table width="100%" class="layout_box_table">
	  <tr><td>&nbsp;</td></tr>
	 </table>
	</td>
  </tr>
  <tr>
    <td>
	  <table class="layout_box_table" width="100%"  cellspacing="1" cellpadding="1">
		<tr>  
		  <td colspan="6" class="bold">Sub Menu Positioning</td>
		  </tr>
		  <tr>
		    <td align="right">Offset from Top: </td>
		    <td><input name="sub_level_offset_top" type="text" id="sub_level_offset_top" value="<?php echo $sub_level_offset_top; ?>" size="10" /></td>
		    <td align="right">Offset from Left: </td>
		    <td><input name="sub_level_offset_left" type="text" id="sub_level_offset_left" value="<?php echo $sub_level_offset_left; ?>" size="10" /></td>
            <td align="right">Collapse and Expand: </td>
            <td>
            <input name="sub_level_collapse" id="$sub_level_collapse" type="checkbox" value="1" <?php if ($sub_level_collapse) echo "checked"; ?>>
            </td>
		    </tr>
		  <tr><td colspan="6">&nbsp;</td></tr>
	  </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
		  <tr>
		    <td class="bold">Sub Menu Item Size and Padding</td>
		    </tr>
		  <tr>
          <td>
          <table width="100%" class="layout_box_table">
           <tr>
		    <td align="right">Width: </td>
		    <td>
              <input name="sub_level_item_width" type="text" id="sub_level_item_width" value="<?php echo $sub_level_item_width; ?>" size="10" />
		      <select name="sub_level_item_width_units" id="sub_level_item_width_units">
		       <option value="0" <?php if ($sub_level_item_width_units == 0) echo "selected='selected'"; ?>>px</option>
                <option value="1" <?php if ($sub_level_item_width_units == 1) echo "selected='selected'"; ?>>%</option>
		        </select>
 
                <input name="proportional_width_sub" type="checkbox" value="1" <?php if ($proportional_width_sub == 1) echo " checked='checked'"; ?>>
                Proportional
            </td>
		    <td align="right">Height: </td>
		    <td align="left"><input name="sub_level_item_height" type="text" id="sub_level_item_height" value="<?php echo $sub_level_item_height; ?>" size="10" />
		      <select name="sub_level_item_height_units" id="font_<?php echo $tagid; ?>5">
		        <option value="2" <?php if ($sub_level_item_height_units == 2) echo "selected='selected'"; ?>>px</option>
                <option value="3" <?php if ($sub_level_item_height_units == 3) echo "selected='selected'"; ?>>%</option>
		        </select>
                </td>
                 <td align="right">Text Alignment: </td>
				<td align="left">
               <select name="sub_level_text_align" id="sub_level_text_align">
                <option value="-not selected-">-not selected-</option>
                <option value="left" <?php if ($sub_level_text_align == "left") echo "selected='selected'"; ?>>Left</option>
                <option value="center" <?php if ($sub_level_text_align == "center") echo "selected='selected'"; ?>>Center</option>
                <option value="right" <?php if ($sub_level_text_align == "right") echo "selected='selected'"; ?>>Right</option>
                <option value="justify" <?php if ($sub_level_text_align == "justify") echo "selected='selected'"; ?>>Justify</option>
               </select>
				</td>
               </tr>
              </table>
             </td>
		    </tr>
		  <tr>
		    <td>
            <table width="100%" class="layout_box_table">
      <tr>
        <td align="center" class="bold">Padding</td>
        <td align="right">Top: </td>
        <td>
            <input name="sub_level_padding_top" type="text" id="sub_level_padding_top" value="<?php echo $sub_level_padding_top; ?>" size="10">
         </td>
         <td align="right">Right: </td>
         <td>
          <input name="sub_level_padding_right" type="text" id="sub_level_padding_right" value="<?php echo $sub_level_padding_right; ?>" size="10"> 
         </td>
         <td align="right">Bottom: </td>
         <td>
          <input name="sub_level_padding_bottom" type="text" id="sub_level_padding_bottom" value="<?php echo $sub_level_padding_bottom; ?>" size="10"> 
         </td>
         <td align="right">Left: </td>
         <td>
          <input name="sub_level_padding_left" type="text" id="sub_level_padding_left" value="<?php echo $sub_level_padding_left; ?>" size="10">
         </td>
         </tr>
        </table> 
            </td>
		    </tr>
		  <tr><td>&nbsp;</td></tr>
	   </table>
	</td>
  </tr>
</table>

<table width="90%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_save' style="width:110px;" onClick="document.getElementById('frm_menu_params').submit();"><span class='button_console_text_w_icon'>Update</span></div>
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
		</td>
	  </tr>
</table>
</form>
</div>

</body>
</html>