<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/22/09	ELL
// Added checkboxes for selecting proportional spacing.
// Revined: 1/9/2011	ELL
// Modified to allow multiple JavaScript Menus.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 5/15/2013	ELL
// Added submenu item height.


	include ("check_session.php");
	
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#js_menu_parameters_heading	{	width:390px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:350px;
	height:31px;
	width:31px;
	z-index:100;
}
</style>

<script language="javascript" type="text/javascript">
function SelectMenu(menu)
{
	var url = "edit_js_menu_params.php?menu=" + menu;
	window.location.href = url;
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_menu_params", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}
</script>
</head>

<body id="workspace_body">

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="js_menu_parameters_heading"><div class="button_heading_text_sub_level_1">JavaScript Menu Size and Orientation Editor</div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="40%">
Select a menu to add items to:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_type` = 1";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
?>
</select>
</td>
</tr>
</table>
<?php
if (($menu == "-not selected-") || ($menu == ""))
{
	echo "Please select a menu to edit menu items.";
	exit;
}
else
{
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu_params WHERE menu_name = '$menu'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["main_item_height"]))
		$main_item_height = $row["main_item_height"];
	else
		$main_item_height = 20;
		
	if (!is_null($row["main_item_width"]))
		$main_item_width = $row["main_item_width"];
	else
		$main_item_width = 90;
		
	if (!is_null($row["origin_top"]))
		$origin_top = $row["origin_top"];
	else
		$origin_top = 200;
		
	if (!is_null($row["origin_left"]))
		$origin_left = $row["origin_left"];
	else
		$origin_left = 28;
		
	if (!is_null($row["sub_menu_origin_top"]))
		$sub_menu_origin_top = $row["sub_menu_origin_top"];
	else
		$sub_menu_origin_top = 18;
		
	if (!is_null($row["sub_menu_origin_left"]))
		$sub_menu_origin_left = $row["sub_menu_origin_left"];
	else
		$sub_menu_origin_left = 10;
		
	if (!is_null($row["main_item_top_offset"]))
		$main_item_top_offset = $row["main_item_top_offset"];
	else
		$main_item_top_offset = 0;
		
	if (!is_null($row["main_item_left_offset"]))
		$main_item_left_offset = $row["main_item_left_offset"];
	else
		$main_item_left_offset = 90;
		
	if (!is_null($row["sub_item_top_offset"]))
		$sub_item_top_offset = $row["sub_item_top_offset"];
	else
		$sub_item_top_offset = 20;
		
	if (!is_null($row["sub_item_left_offset"]))
		$sub_item_left_offset = $row["sub_item_left_offset"];
	else
		$sub_item_left_offset = 0;
		
	if (!is_null($row["sub_item_width"]))
		$sub_item_width = $row["sub_item_width"];
	else
		$sub_item_width = 110;
		
	if (!is_null($row["sub_item_height"]))
		$sub_item_height = $row["sub_item_height"];
	else
		$sub_item_height = 20;
		
	if (!is_null($row["sub_left_offset_from_main"]))
		$sub_left_offset_from_main = $row["sub_left_offset_from_main"];
	else
		$sub_left_offset_from_main = 30;
		
	if (!is_null($row["hide_delay"]))
		$hide_delay = $row["hide_delay"];
	else
		$hide_delay = 200;
		
	if (!is_null($row["proportional_width"]))
		$proportional_width = $row["proportional_width"];
	else
		$proportional_width = 0;
	
	if (!is_null($row["proportional_sub_width"]))
		$proportional_sub_width = $row["proportional_sub_width"];
	else
		$proportional_sub_width = 0;
}
?>
<form name="frm_menu_params" id="frm_menu_params" action="save_js_menu_params.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td>
		<table width="100%" class="layout_box_table" cellspacing="1" cellpadding="1">
	  <tr>
		 <td colspan="4" class="bold">Menu Item Size</td>
	  </tr>
	  <tr>
		<td align="right">Height: </td>
		<td><input name="main_item_height" type="text" id="main_item_height" value="<?php echo $main_item_height; ?>" /></td>
		<td align="right">Width: </td>
		<td align="left">
        	<table><tr>
            	<td><input name="main_item_width" type="text" id="main_item_width" value="<?php echo $main_item_width; ?>" /></td>
                <td>&nbsp;&nbsp;&nbsp;</td>
                <td align="right">Proportional Sizing: </td>
                <td><input name="proportional_width" type="checkbox" id="proportional_width" value="1" <?php if($proportional_width == 1) echo "checked='checked'"; ?> /></td>
            </tr></table>
		</td>
	  </tr>
	  <tr><td colspan="4">&nbsp;</td></tr>
	 </table>
	</td>
  </tr>
  <tr>
    <td>
	  <table class="layout_box_table" width="100%"  cellspacing="1" cellpadding="1">
		<tr>  
			 <td colspan="4" class="bold">Menu Origin (from upper left of page) </td>
		  </tr>
		  <tr>
			<td align="right">Offset from Top: </td>
			<td><input name="origin_top" type="text" id="origin_top" value="<?php echo $origin_top; ?>" /></td>
			<td align="right">Offset from Left: </td>
			<td><input name="origin_left" type="text" id="origin_left" value="<?php echo $origin_left; ?>" /></td>
		  </tr>
		  <tr><td colspan="4">&nbsp;</td></tr>
	  </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
		  <tr>
			 <td colspan="4" class="bold">Sub Menu Origin (from upper left of Main Menu)</td>
		  </tr>
		  <tr>
			<td align="right">Offset from Top: </td>
			<td><input name="sub_menu_origin_top" type="text" id="sub_menu_origin_top" value="<?php echo $sub_menu_origin_top; ?>" /></td>
			<td align="right">Offset from Left: </td>
			<td><input name="sub_menu_origin_left" type="text" id="sub_menu_origin_left" value="<?php echo $sub_menu_origin_left; ?>" /></td>
		  </tr>
		  <tr><td colspan="4">&nbsp;</td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td colspan="4"><span class="bold">Menu Item Offset</span> Note: for vertical
				 menu set Offset from Left to 0. For horizontal menu set Offset
		     from Top to 0.</td>
		  </tr>
		  <tr>
			<td align="right">Offset from Top: </td>
			<td><input name="main_item_top_offset" type="text" id="main_item_top_offset" value="<?php echo $main_item_top_offset; ?>" /></td>
			<td align="right">Offset from Left: </td>
			<td><input name="main_item_left_offset" type="text" id="main_item_left_offset" value="<?php echo $main_item_left_offset; ?>" /></td>
		  </tr>
		  <tr><td colspan="4">&nbsp;</td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td colspan="4" class="bold">Sub Menu Item Offset and Size</td>
		  </tr>
		  <tr>
			<td align="right">Offset from Top: </td>
			<td><input name="sub_item_top_offset" type="text" id="sub_item_top_offset" value="<?php echo $sub_item_top_offset; ?>" /></td>
			<td align="right">Offset from Left: </td>
			<td><input name="sub_item_left_offset" type="text" id="sub_item_left_offset" value="<?php echo $sub_item_left_offset; ?>" /></td>
		  </tr>
		  <tr>
			<td align="right">Sub Menu Item Width: </td>
            <td align="left">
                <table><tr>
                    <td><input type="text" name="sub_item_width" id="sub_item_width" value="<?php echo $sub_item_width; ?>" /></td>
                    <td>&nbsp;&nbsp;&nbsp;</td>
                    <td align="right">Proportional Sizing: </td>
                    <td><input type="checkbox" name="proportional_sub_width" id="proportional_sub_width" value="1" <?php if($proportional_sub_width == 1) echo "checked='checked'"; ?> /></td>
                </tr></table>
			</td>
			<td align="right">Offset from Left of Top Menu: </td>
			<td><input type="text" name="sub_left_offset_from_main" id="sub_left_offset_from_main" value="<?php echo $sub_left_offset_from_main; ?>" /></td>
		  </tr>
		  <tr>
			<td align="right">Sub Menu Item Height: </td>
			<td><input type="text" name="sub_item_height" id="sub_item_height" value="<?php echo $sub_item_height; ?>" /></td>
			<td align="right">Hide delay after Mouse Out (mSec): </td>
			<td><input type="text" name="hide_delay" id="hide_delay" value="<?php echo $hide_delay; ?>" /></td>
		  </tr>
	   </table>
	</td>
  </tr>
</table>

<table width="90%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_save' style="width:110px;" onClick="document.getElementById('frm_menu_params').submit();"><span class='button_console_text_w_icon'>Update</span></div>
          <input type="hidden" name="menu" id="menu" value="<?php echo $menu; ?>" />
		</td>
	  </tr>
</table>
</form>
</div>

</body>
</html>