<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 14/14/2013
//
	
	include ("check_session.php");
	
	$enable_file_manager = $_SESSION['enable_file_manager'];
	if ($enable_file_manager != "100")
		header("Location: /index.php");
		
	include ("lib/copy_dir.php");
	
	//////////////////////////////////////
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	//////////////////////////////////////////
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</script>
</head>
<body>
<h2>Installing update....</h2>
<?php
	
	if (is_uploaded_file($_FILES['update_file']['tmp_name']))
	{	
		$source = $_FILES['update_file']['tmp_name'];
		$file_name = $_FILES['update_file']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		
		if (!( (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "zip") == 0) || (strcasecmp($file_ext, "tar") == 0) ))
		{
			echo "Only gzipped tar files or zipped files are allowed to be uploaded, i.e. 'plugin.tgz' or 'plugin.tar.gz' or 'plugin.zip'.  Please click <a href='upload_update.php'>here</a> and try again.";
			exit;
		}
		
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . "/" . $file_name;
		move_uploaded_file( $source, $destination );
		$source = $destination;
		
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		// Note: phar->decompress removes the all of the file name after the FIRST dot "." then appends the ".tar"
			$tar_source =  $document_root . "/" . $file_parts[0] . ".tar";
		
		$destination = $document_root . "/tmp";
		if (!file_exists($destination))
			mkdir($destination, 0755);
		else
		{
			$bkup = $destination . date('YmdHis', time());
			rename($destination, $bkup);
			mkdir($destination, 0755);
		}
		
		echo "Extracting files...<br><br>\n";
		// Extract contents of archive to disk
		if (strcasecmp($file_ext, "zip") == 0)
		{
			$zip = new ZipArchive;
			$res = $zip->open($source);
			if ($res === TRUE) {
			  $zip->extractTo($destination);
			  $zip->close();
			} else {
			  echo "There was an error extracting the files from your zip file.  Click <a href='upload_update.php'>here</a> to try again.";
			  exit;
			}
		}
		elseif ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0))
		{
			// decompress from gz
			try {
				$p = new PharData($source);
				$p->decompress(".tar"); // creates /path/to/my.tar
			} catch (Exception $e) {
				echo "There was an error extracting the files from your tar.gz file.  Click <a href='upload_update.php'>here</a> to try again.<br/>$e";
				exit;
			}
		}
		
		// unarchive from the tar
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		{
			try {
				$phar = new PharData($tar_source);
				$phar->extractTo($destination, null, true);
			} catch (Exception $e) {
				echo "There was an error extracting the files from your tar file.  Click <a href='upload_update.php'>here</a> to try again.<br/>$e";
				exit;
			}
		}

		// Copy files to correct folders.
		echo "Copying files...<br><br>\n";
		$extracted_source = $document_root . "/tmp";
		$destination = $document_root;
		copydir($extracted_source, $destination, 0755, true);
		unlink($source);
		unlink($tar_source);
		
		// Run template SQL
		$sql_file = "SQL/upgrade.sql";
		include ("run_sql_file.php");
		
		unlink($document_root . "/SQL/upgrade.sql");
		if (file_exists($document_root . "/SQL/_notes"))
			unlink($document_root . "/SQL/_notes");
		rmdir($document_root . "/SQL");
		
		$_SESSION['button_group'] = "other_functions";
		$_SESSION['button'] = "btn_users_site_options";
?>
		<h2>Update installation is comlplete.</h2>
        <p>Click <a href="main.php" target="_top">here</a> to refresh the main menu.</p>

<?php
	}
	else
		echo "There was an error uploading the file.  Click <a href='upload_plugin.php'>here</a> to try again.";
?>