/////////////////////////////////////////////
// Admin Function Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/30/2013	ELL
// 
// 
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function DeleteConfirm(delete_mode)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	
	if (delete_mode == "blog")
	{
		var list = document.getElementById('selectBlogToDelete');
		var blog = list.options[list.selectedIndex].innerHTML;
		popup_msg.popup_msg_cell = "Are your sure you want to delete <b>" + blog + "</b>?";
		document.getElementById("popup_button_2_span").onclick = function() { DeleteBlog(); };
	}
	else if (delete_mode == "recall_plugin")
	{
		var list = document.getElementById('recall_plugin');
		var plugin_name = list.options[list.selectedIndex].innerHTML;
		var plugin_name_arr = plugin_name.split("-");
		plugin_name = plugin_name_arr[0];
		popup_msg.popup_msg_cell = "Are your sure you want to recall the <b>" + plugin_name + "</b> plugin?";
		document.getElementById("popup_button_2_span").onclick = function() { RecallPlugin(); };
	}
	else	// page
	{
		popup_msg.popup_msg_cell = "Are your sure you want to delete the <b>" + document.getElementById("selectPageToDelete").value + "</b> page?";
		document.getElementById("popup_button_2_span").onclick = function() { DeletePage(); };
	}
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	popup_msg.ShowPopupMsg();
}

function RecallPlugin()
{
	var plugin_id = document.getElementById("recall_plugin").value;
	HidePopupMsg();
	var url = "recall_plugin.php?plugin_id=" + plugin_id;
	window.location = url;
}

function ActivateDeactivate(activate)
{
	window.location='activate_deactivate_site.php?activate=' + activate;
}

function ShowPrunePageEditBkupTable()
{
	document.getElementById("recall_plugin_div").style.display = "none";
	document.getElementById("prune_page_backup_table_div").style.display = "block";
	document.getElementById("prune_page_backup_table_div").style.position = "absolute";
	document.getElementById("prune_page_backup_table_div").style.top = "120px";
	document.getElementById("prune_page_backup_table_div").style.left = "350px";
}

function ShowRecallPlugin()
{
	document.getElementById("prune_page_backup_table_div").style.display = "none";
	document.getElementById("recall_plugin_div").style.display = "block";
	document.getElementById("recall_plugin_div").style.position = "absolute";
	document.getElementById("recall_plugin_div").style.top = "260px";
	document.getElementById("recall_plugin_div").style.left = "350px";
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#admin_functions", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}