////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/19/2011	ELL
//

function CheckColorString(textbox)
{
	var color_str = textbox.value;
	// If blank then don't waist time checking.  Nothing is OK.
	if ((color_str == "") || (color_str == "-not set-"))
		return;
		
	// Check for # and prepend if necessary.
	if (color_str.substring(0, 1) != "#")
		color_str = "#" + color_str;
	
	// Check for correct number of digits.
	if (!((color_str.length == 4) || (color_str.length == 7)))
		alert("The hex color code you added does not have the correct number of digits.  It should contain either 3 or 6 digits, 0-9, A-F.");
		
	// Check that all digits are valid hex characters.
	if (!IsHexChars(color_str))
		alert("A hex color string can contain only the following characters: 0123456789ABCDEF.  Please revise your color entry.");
		
	// Update control.
	textbox.value = color_str;
}

function IsHexChars(strString)
{
	var strValidChars = "#0123456789ABCDEFabcdef";
	var strChar;
	var blnResult = true;

	if (strString.length == 0) return false;	// Checked above. Should never occur.
	
	//  test strString consists of valid characters listed above
	for (i = 0; i < strString.length && blnResult == true; i++)
	{
		strChar = strString.charAt(i);
		if (strValidChars.indexOf(strChar) == -1)
		{
			blnResult = false;
		}
	}
	return blnResult;
}