////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/10/2013	ELL
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/16/2014	ELL
// Added modal color tinting of grouping tables to make it easier to find controls and to make enabled=disabled obvious.
// Revised: 2/18/2014	ELL
// Fixed bug with center site button and sticky footers button that got broke when submit_action was implemented inplace of the submit button.
// Revised 2/20/2014	ELL
// Added checking for correct parameters selected for border and line height.
// Revised: 3/5/2014	ELL
// Replaced image uploader with "AJAX" image uploader.
// Revised: 8/27/2014	ELL
// Added switch between alpha and user-defined sort for class list.
// Revised: 12/28/2014	ELL
// Added thumbnail checking with switch to actual image if no thumb.
// Revised: 12/30/2014	ELL
// Added browser CSS reset button.


var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function popupcolorpicker(form_name, field_name)
{
	var start_color = document.getElementById(field_name).value;
	if (start_color == "")
		start_color = "-not set-";
	else
		start_color = start_color.replace("#", "");
	
	var URL = "colorpicker.php?form_name=" + form_name + "&field_name=" + field_name + "&source_page=edit_css.php&start_color=" + start_color;
	
	window.open (URL, "colorpicker", "alwaysRaised=0,dependent=1,menubar=0,resizable=0,width=450,height=350,scrollbars=0,location=0");
}

function enable_disable_controls(ShowMessage)
{	
	if (document.getElementById("use_table_data").checked == true)
	{
		document.getElementById("font").disabled = false;
		document.getElementById("font2").disabled = false;
		document.getElementById("font3").disabled = false;
		document.getElementById("font_size").disabled = false;
		document.getElementById("text_color").disabled = false;
		document.getElementById("align").disabled = false;
		document.getElementById("vertical_align").disabled = false;
		document.getElementById("display").disabled = false;
		document.getElementById("weight").disabled = false;
		document.getElementById("font_stretch").disabled = false;
		document.getElementById("italic").disabled = false;
		document.getElementById("underline").disabled = false;
		document.getElementById("overline").disabled = false;
		document.getElementById("blink").disabled = false;
		document.getElementById("linethrough").disabled = false;
		document.getElementById("oblique").disabled = false;
		document.getElementById("small_caps").disabled = false;
		document.getElementById("no_text_decoration").disabled = false;
		document.getElementById("shadow").disabled = false;
		document.getElementById("line_height").disabled = false;
		document.getElementById("line_height_units").disabled = false;
		
		document.getElementById("bkgd_color").disabled = false;
		document.getElementById("bkgd_opacity").disabled = false;
		document.getElementById("border").disabled = false;
		document.getElementById("border_color").disabled = false;
		document.getElementById("border_style").disabled = false;
		document.getElementById("outline_style").disabled = false;
		document.getElementById("border_collapse").disabled = false;
		document.getElementById("border_top").disabled = false;
		document.getElementById("border_bottom").disabled = false;
		document.getElementById("border_left").disabled = false;
		document.getElementById("border_right").disabled = false;
		document.getElementById("padding_top").disabled = false;
		document.getElementById("padding_right").disabled = false;
		document.getElementById("padding_bottom").disabled = false;
		document.getElementById("padding_left").disabled = false;

		document.getElementById("width").disabled = false;
		document.getElementById("width_units").disabled = false;
		document.getElementById("width_prefix").disabled = false;
		document.getElementById("height").disabled = false;
		document.getElementById("height_units").disabled = false;
		document.getElementById("height_prefix").disabled = false;
		document.getElementById("background_image").disabled = false;
		document.getElementById("file_browse1").disabled = false;
		document.getElementById("background_attachment").disabled = false;
		document.getElementById("background_repeat").disabled = false;
		document.getElementById("background_position").disabled = false;
		
		document.getElementById("margin_top_auto").disabled = false;
		document.getElementById("margin_right_auto").disabled = false;
		document.getElementById("margin_left_auto").disabled = false;
		document.getElementById("margin_bottom_auto").disabled = false;
		
		document.getElementById("position").disabled = false;
		document.getElementById("position_left").disabled = false;
		document.getElementById("position_left_units").disabled = false;
		document.getElementById("position_top").disabled = false;
		document.getElementById("position_top_units").disabled = false;
		document.getElementById("position_right").disabled = false;
		document.getElementById("position_right_units").disabled = false;
		document.getElementById("position_bottom").disabled = false;
		document.getElementById("position_bottom_units").disabled = false;
		document.getElementById("z_index").disabled = false;
		document.getElementById("overflow").disabled = false;
		document.getElementById("clip_top").disabled = false;
		document.getElementById("clip_top_units").disabled = false;
		document.getElementById("clip_right").disabled = false;
		document.getElementById("clip_right_units").disabled = false;
		document.getElementById("clip_bottom").disabled = false;
		document.getElementById("clip_bottom_units").disabled = false;
		document.getElementById("clip_left").disabled = false;
		document.getElementById("clip_left_units").disabled = false;
		document.getElementById("float").disabled = false;
		document.getElementById("white_space").disabled = false;
		
		document.getElementById("list_style_type").disabled = false;
		document.getElementById("list_style_position").disabled = false;
		document.getElementById("list_style_image").disabled = false;
		document.getElementById("file_browse2").disabled = false;
		
		document.getElementById("table_layout").disabled = false;
		document.getElementById("clear").disabled = false;
		
		document.getElementById("radius_top_left").disabled = false;
		document.getElementById("radius_top_left_units").disabled = false;
		document.getElementById("radius_top_right").disabled = false;
		document.getElementById("radius_top_right_units").disabled = false;
		document.getElementById("radius_bottom_right").disabled = false;
		document.getElementById("radius_bottom_right_units").disabled = false;
		document.getElementById("radius_bottom_left").disabled = false;
		document.getElementById("radius_bottom_left_units").disabled = false;
		
		document.getElementById("box_shadow_horizontal").disabled = false;
		document.getElementById("box_shadow_vertical").disabled = false;
		document.getElementById("box_shadow_blur").disabled = false;
		document.getElementById("box_shadow_spread").disabled = false;
		document.getElementById("box_shadow_color").disabled = false;
		document.getElementById("box_shadow_inset").disabled = false;
		
		document.getElementById("cursor").disabled = false;
		
		document.getElementById("background_size").disabled = false;
		
		enable_disable_shadow();
		margin_auto_clicked("top");
		margin_auto_clicked("bottom");
		margin_auto_clicked("left");
		margin_auto_clicked("right");
		enable_disable_background_positions();
		enable_disable_background_sizes();
		
		document.getElementById("text_table").style.backgroundColor = "#FFCCCC";
		document.getElementById("background_table").style.backgroundColor = "#CCFFCC";
		document.getElementById("border_table").style.backgroundColor = "#CCCCFF";
		document.getElementById("margin_table").style.backgroundColor = "#FFFFAA";
		document.getElementById("position_table").style.backgroundColor = "#FFAAFF";
		document.getElementById("background_img_table").style.backgroundColor = "#AAFFFF";
		document.getElementById("list_table").style.backgroundColor = "#FFBB99";
		document.getElementById("box_shadow_table").style.backgroundColor = "#99BBFF";
	}
	else
	{
		document.getElementById("font").disabled = true;
		document.getElementById("font2").disabled = true;
		document.getElementById("font3").disabled = true;
		document.getElementById("font_size").disabled = true;
		document.getElementById("text_color").disabled = true;
		document.getElementById("align").disabled = true;
		document.getElementById("vertical_align").disabled = true;
		document.getElementById("display").disabled = true;
		document.getElementById("weight").disabled = true;
		document.getElementById("font_stretch").disabled = true;
		document.getElementById("italic").disabled = true;
		document.getElementById("underline").disabled = true;
		document.getElementById("overline").disabled = true;
		document.getElementById("blink").disabled = true;
		document.getElementById("linethrough").disabled = true;
		document.getElementById("oblique").disabled = true;
		document.getElementById("small_caps").disabled = true;
		document.getElementById("no_text_decoration").disabled = true;
		document.getElementById("shadow").disabled = true;
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
		document.getElementById("line_height").disabled = true;
		document.getElementById("line_height_units").disabled = true;
		
		document.getElementById("bkgd_color").disabled = true;
		document.getElementById("bkgd_opacity").disabled = true;
		document.getElementById("border").disabled = true;
		document.getElementById("border_color").disabled = true;
		document.getElementById("border_style").disabled = true;
		document.getElementById("outline_style").disabled = true;
		document.getElementById("border_collapse").disabled = true;
		document.getElementById("border_top").disabled = true;
		document.getElementById("border_bottom").disabled = true;
		document.getElementById("border_left").disabled = true;
		document.getElementById("border_right").disabled = true;
		document.getElementById("padding_top").disabled = true;
		document.getElementById("padding_right").disabled = true;
		document.getElementById("padding_bottom").disabled = true;
		document.getElementById("padding_left").disabled = true;
		
		document.getElementById("margin_top").disabled = true;
		document.getElementById("margin_right").disabled = true;
		document.getElementById("margin_left").disabled = true;
		document.getElementById("margin_bottom").disabled = true;
		document.getElementById("width").disabled = true;
		document.getElementById("width_units").disabled = true;
		document.getElementById("width_prefix").disabled = true;
		document.getElementById("height").disabled = true;
		document.getElementById("height_units").disabled = true;
		document.getElementById("height_prefix").disabled = true;
		document.getElementById("background_image").disabled = true;
		document.getElementById("file_browse1").disabled = true;
		document.getElementById("background_attachment").disabled = true;
		document.getElementById("background_repeat").disabled = true;
		document.getElementById("background_position").disabled = true;
		document.getElementById("background_position_x").disabled = true;
		document.getElementById("background_position_y").disabled = true;
		document.getElementById("background_position_units").disabled = true;
		
		document.getElementById("margin_top_units").disabled = true;
		document.getElementById("margin_top_auto").disabled = true;
		document.getElementById("margin_right_units").disabled = true;
		document.getElementById("margin_right_auto").disabled = true;
		document.getElementById("margin_left_units").disabled = true;
		document.getElementById("margin_left_auto").disabled = true;
		document.getElementById("margin_bottom_units").disabled = true;
		document.getElementById("margin_bottom_auto").disabled = true;
		
		document.getElementById("position").disabled = true;
		document.getElementById("position_left").disabled = true;
		document.getElementById("position_left_units").disabled = true;
		document.getElementById("position_top").disabled = true;
		document.getElementById("position_top_units").disabled = true;
		document.getElementById("position_right").disabled = true;
		document.getElementById("position_right_units").disabled = true;
		document.getElementById("position_bottom").disabled = true;
		document.getElementById("position_bottom_units").disabled = true;
		document.getElementById("z_index").disabled = true;
		document.getElementById("overflow").disabled = true;
		document.getElementById("clip_top").disabled = true;
		document.getElementById("clip_top_units").disabled = true;
		document.getElementById("clip_right").disabled = true;
		document.getElementById("clip_right_units").disabled = true;
		document.getElementById("clip_bottom").disabled = true;
		document.getElementById("clip_bottom_units").disabled = true;
		document.getElementById("clip_left").disabled = true;
		document.getElementById("clip_left_units").disabled = true;
		document.getElementById("float").disabled = true;
		document.getElementById("white_space").disabled = true;
		
		document.getElementById("list_style_type").disabled = true;
		document.getElementById("list_style_position").disabled = true;
		document.getElementById("list_style_image").disabled = true;
		document.getElementById("file_browse2").disabled = true;
		
		document.getElementById("table_layout").disabled = true;
		document.getElementById("clear").disabled = true;
		
		document.getElementById("radius_top_left").disabled = true;
		document.getElementById("radius_top_left_units").disabled = true;
		document.getElementById("radius_top_right").disabled = true;
		document.getElementById("radius_top_right_units").disabled = true;
		document.getElementById("radius_bottom_right").disabled = true;
		document.getElementById("radius_bottom_right_units").disabled = true;
		document.getElementById("radius_bottom_left").disabled = true;
		document.getElementById("radius_bottom_left_units").disabled = true;
		
		document.getElementById("box_shadow_horizontal").disabled = true;
		document.getElementById("box_shadow_vertical").disabled = true;
		document.getElementById("box_shadow_blur").disabled = true;
		document.getElementById("box_shadow_spread").disabled = true;
		document.getElementById("box_shadow_color").disabled = true;
		document.getElementById("box_shadow_inset").disabled = true;
		
		document.getElementById("cursor").disabled = true;
		
		document.getElementById("background_size").disabled = true;
		document.getElementById("background_width").disabled = true;
		document.getElementById("background_width_units").disabled = true;
		document.getElementById("background_height").disabled = true;
		document.getElementById("background_height_units").disabled = true;
		
		document.getElementById("text_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("background_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("border_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("margin_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("position_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("background_img_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("list_table").style.backgroundColor = "#D9D9D9";
		document.getElementById("box_shadow_table").style.backgroundColor = "#D9D9D9";
	}
	if (ShowMessage == 1)
	{
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = "Click 'Update' to commit changes.";
		popup_msg.popup_timeout = -1;
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 500;
		popup_msg.popup_timeout = 6000;
		popup_msg.ShowPopupMsg();
	}
}

function text_decoration_none_clicked()
{
	if (document.getElementById("no_text_decoration").checked == true)
	{
		document.getElementById("underline").checked = false;
		document.getElementById("overline").checked = false;
		document.getElementById("blink").checked = false;
		document.getElementById("linethrough").checked = false;
	}
}

function margin_auto_clicked(side)
{
	var margin_auto_control_name = "margin_" + side + "_auto";
	var margin_control_name = "margin_" + side;
	var margin_units_control_name = "margin_" + side + "_units";
	
	if (document.getElementById(margin_auto_control_name).checked == true)
	{
		document.getElementById(margin_control_name).disabled = true;
		document.getElementById(margin_units_control_name).disabled = true;
	}
	else
	{
		document.getElementById(margin_control_name).disabled = false;
		document.getElementById(margin_units_control_name).disabled = false;
	}
}

function enable_disable_shadow()
{
	if (document.getElementById("shadow").checked == true)
	{
		document.getElementById("shadow_color").disabled = false;
		document.getElementById("shadow_x_offset").disabled = false;
		document.getElementById("shadow_y_offset").disabled = false;
		document.getElementById("shadow_blur").disabled = false;
	}
	else
	{
		document.getElementById("shadow_color").disabled = true;
		document.getElementById("shadow_x_offset").disabled = true;
		document.getElementById("shadow_y_offset").disabled = true;
		document.getElementById("shadow_blur").disabled = true;
	}
}

function enable_disable_background_positions()
{
	if (document.getElementById("background_position").value == "xpos ypos")
	{
		document.getElementById("background_position_x").disabled = false;
		document.getElementById("background_position_y").disabled = false;
		document.getElementById("background_position_units").disabled = false;
	}
	else
	{
		document.getElementById("background_position_x").disabled = true;
		document.getElementById("background_position_y").disabled = true;
		document.getElementById("background_position_units").disabled = true;
	}
}

function enable_disable_background_sizes()
{
	if (document.getElementById("background_size").value == "scale")
	{
		document.getElementById("background_width").disabled = false;
		document.getElementById("background_width_units").disabled = false;
		document.getElementById("background_height").disabled = false;
		document.getElementById("background_height_units").disabled = false;
	}
	else
	{
		document.getElementById("background_width").disabled = true;
		document.getElementById("background_width_units").disabled = true;
		document.getElementById("background_height").disabled = true;
		document.getElementById("background_height_units").disabled = true;
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
				popup_msg.status_msg = "Update complete: " + xmlhttp.responseText;
			else
				popup_msg.status_msg = "Update complete";
			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = "Update ready to send...";
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = "Update sent";
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = "Updating...";
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////
function LoadBrowserResetParams()
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=html";
		params = params + "&use_table_data=1";
		params = params + "&margin_top=0";
		params = params + "&margin_top_units=0";
		params = params + "&margin_right=0";
		params = params + "&margin_right_units=0";
		params = params + "&margin_left=0";
		params = params + "&margin_left_units=0";
		params = params + "&margin_bottom=0";
		params = params + "&margin_bottom_units=0";
		params = params + "&padding_top=0";
		params = params + "&padding_right=0";
		params = params + "&padding_left=0";
		params = params + "&padding_bottom=0";
		params = params + "&border=0";
		params = params + "&border_sides=15";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}

	var msg = "Your CSS has been setup to reset browsers by setting all of the margins, paddings and borders for the HTML element to 0.";
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 3000);
}

////////////////////////////////////////////////////////////////////////////////////
function LoadCenterParams()
{
	alert("We will now load styles with settings that will cause your website to appear centered with a fixed width.");
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&align=center";
		params = params + "&bkgd_color=#111111";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}

	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&align=left";
		params = params + "&bkgd_color=#FFFFFF";
		params = params + "&position=relative";
		params = params + "&width=900";
		params = params + "&width_units=0";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&margin_left_auto=1";
		params = params + "&margin_right_auto=1";
		params = params + "&margin_top=0";
		params = params + "&margin_top_units=0";
		params = params + "&submit_action=Update";
		
		xmlhttp2.send(params);
	}
		
	var msg = "Your site has been centered.  You may want to revise the 'body' width, the 'body' background color, and the '#wrap' backgound color to your needs.";
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 5000);
}

//////////////////////////////////////////////////////////////////////////////////////
function LoadStickyFooterParams()
{
	alert("We will now load styles with settings that will cause the footer of your web pages to 'stick' to the bottom of your browser window.");
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=body";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&submit_action=Update";
		
		xmlhttp.send(params);
	}
	
	var xmlhttp2;
	xmlhttp2 = getXmlHttpRequestObject();
	if (xmlhttp2.readyState == 4 || xmlhttp2.readyState == 0)
	{
		xmlhttp2.open("POST","save_css.php",true);
		xmlhttp2.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp2 = UpdateMessage(xmlhttp2);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=#wrap";
		params = params + "&use_table_data=1";
		params = params + "&height=100";
		params = params + "&height_units=1";
		params = params + "&height_prefix=min";
		params = params + "&overflow=auto";
		params = params + "&padding_bottom=50";
		params = params + "&padding_bottom_units=0";
		params = params + "&position=relative";
		params = params + "&submit_action=Update";
		
		xmlhttp2.send(params);
	}
	
	var xmlhttp3;
	xmlhttp3 = getXmlHttpRequestObject();
	if (xmlhttp3.readyState == 4 || xmlhttp3.readyState == 0)
	{
		xmlhttp3.open("POST","save_css.php",true);
		xmlhttp3.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp3 = UpdateMessage(xmlhttp3);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=html";
		params = params + "&use_table_data=1";
		params = params + "&height=94";
		params = params + "&height_units=1";
		params = params + "&submit_action=Update";
		
		xmlhttp3.send(params);
	}
	
	var xmlhttp4;
	xmlhttp4 = getXmlHttpRequestObject();
	if (xmlhttp4.readyState == 4 || xmlhttp4.readyState == 0)
	{
		xmlhttp4.open("POST","save_css.php",true);
		xmlhttp4.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp4 = UpdateMessage(xmlhttp4);

		params = "submit=Update";
		params = params + "&quick_setup=1";
		params = params + "&style_sheet=site";
		params = params + "&class=footer";
		params = params + "&use_table_data=1";
		params = params + "&width=100";
		params = params + "&width_units=1";
		params = params + "&height=50";
		params = params + "&height_units=0";
		params = params + "&margin_top=-50";
		params = params + "&margin_top_units=0";
		params = params + "&margin_bottom_auto=1";
		params = params + "&position=relative";
		params = params + "&position_bottom=0";
		params = params + "&position_bottom_units=0";
		params = params + "&clear=both";
		params = params + "&bkgd_color=#DDDDDD";
		params = params + "&align=center";
		params = params + "&submit_action=Update";
		
		xmlhttp4.send(params);
	}
		
	var msg = "Your footer will now stick to the bottom of the browser window.  You may also want to revise the 'footer' height and the background color to your needs. Be sure to set the footer's margin top to the same but negative of the footer's height.";
	mTimer2 = setTimeout(function() { DisplayFinalMsg(msg) }, 5000);
}

function DisplayFinalMsg(msg)
{
	popup_msg.status_msg = msg;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.left_offset = 250;
	popup_msg.msg_width = 600;
	popup_msg.ShowPopupMsg();
}

//////////////////////////////////////////////////////////////////////////////////////
function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_css", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////
function SubmitForm(submit_action)
{
	document.getElementById('submit_action').value = submit_action;
	document.getElementById('frm_site_styles').submit();
}

///////////////////////////////////////////////////////////////////////////////////////
function CheckBorderParams(element)
{
	if ((element.value != '-not selected-') && (element.value != '') && (element.value != 0))
	{
		var msg = '';
		
		if ((!document.getElementById('border_top').checked) && (!document.getElementById('border_bottom').checked) && (!document.getElementById('border_left').checked) && (!document.getElementById('border_right').checked))
			msg = "It appears that you are trying to setup a border, but you don't have any sides selected.  You must check at least one of the boxes labeled <b>Top</b>, <b>Bottom</b>, <b>Left</b> or <b>Right</b>.";
			
		if (document.getElementById('border_style').value == "-not selected-")
			msg = msg + "<br/><br/>You must specify a <b>border style</b> in order for a border to display.";
			
		if (msg != '')
		{
			popup_msg.popup_msg_type = 2;
			popup_msg.status_msg = msg;
			popup_msg.popup_timeout = -1;
			popup_msg.top_offset = 0;
			popup_msg.left_offset = 250;
			popup_msg.msg_width = 600;
			popup_msg.popup_timeout = 10000;
			popup_msg.ShowPopupMsg();
		}
	}
}

function CheckLineHeight(element)
{
	if (((element.value == 0) || (element.value == 4)) && (document.getElementById('line_height').value != -1) && (document.getElementById('line_height').value != '-not set-') && (document.getElementById('line_height').value != ''))
	{
		popup_msg.popup_msg_type = 2;
			popup_msg.status_msg = "You have selected <b>Normal</b> or <b>Inherit</b> for your line height, yet you have a positive number set for line height. Note that the number you have selected will be ignored.  If you want to set a line height, choose <b>Bultiplyer</b>, <b>%</b> or <b>px</b> instead.";
			popup_msg.popup_timeout = -1;
			popup_msg.top_offset = 0;
			popup_msg.left_offset = 250;
			popup_msg.msg_width = 600;
			popup_msg.popup_timeout = 10000;
			popup_msg.ShowPopupMsg();
	}
}

////////////////////////////////////////////////////////////////////////////
var RefreshTimer;
function RunPostAjaxUploadScript()
{
	// Called by ajaxupload.js.  You may use this function to automatically perform actions
	// after your file has uploaded.

	var filename_ctl;
	var preview_ctl;
	var image_select_ctl;
	var jq_filename_ctl = "";
	var jq_filenam_obj;
	
	filename_ctl = "file_browse" + upload_index;
	preview_ctl = "preview" + upload_index;
	
	var image_select_ctl;
	switch(upload_index)
	{
	case 1:
		image_select_ctl = "background_image";
		break;
	case 2:
		image_select_ctl = "list_style_image";
		break;
	default:
		image_select_ctl = "-not found-";
	}
	
	document.getElementById('frmChangeStyleSheet').action = "edit_css.php";
	document.getElementById('frmChangeStyleSheet').target = "_self";

	var file_element = document.getElementById(filename_ctl);
	if (file_element != null)
	{
		var preview_element = document.getElementById(preview_ctl).getElementsByTagName('IMG');
		if (preview_element[0] != null)
		{
			var photo_path_tn = preview_element[0].getAttribute("src");
			var photo_path = photo_path_tn.replace("/tn", "");
//				alert(photo_path);
			
			if (photo_path.indexOf('loading.gif') > -1)
			{
				RefreshTimer = setTimeout(function(){TryFileNameMoveAgain()}, 1000);
				return;
			}
			else if (photo_path != '')
			{
//				alert(photo_path);
				var photo_path_arr = photo_path.split("/");
				var last_el = photo_path_arr.length - 1;
				if (image_select_ctl != "-not found-")
				{
					var image_select_el = document.getElementById(image_select_ctl);
					var option = document.createElement("option");
					option.text = photo_path_arr[last_el];
					image_select_el.add(option, image_select_el[0]);
					image_select_el.selectedIndex = 0;
				}
			}
		}
//			alert(file_element.value);
		file_element.value = '';
		
		jq_filename_ctl = "#" + filename_ctl;
		jq_filenam_obj = $(jq_filename_ctl);
		jq_filenam_obj.replaceWith( jq_filenam_obj.clone( true ) );
	}
}

function TryFileNameMoveAgain()
{
	clearTimeout(RefreshTimer);
	RunPostAjaxUploadScript();
}

///////////////////////////////////////////////////////////////////////////////////////
function UpdateImage(i)
{
	var image_select_ctl;
	var html;
	switch(i)
	{
	case 1:
		image_select_ctl = "background_image";
		break;
	case 2:
		image_select_ctl = "list_style_image";
		break;
	default:
		image_select_ctl = "-not found-";
	}

	var preview_ctl = "preview" + i;
	var photo_img = "photo_img" + i;
	
	if (image_select_ctl != "-not found-")
	{
		var image = document.getElementById(image_select_ctl).value;
		var image_path = "../" + image_dir_path + "/" + image;
		var image_path_tn = "../" + image_tn_dir_path + "/" + image;
		
		if (image != "-not selected-")	{
			html = "<img src='" + image_path_tn + "' border='0' width='104' height='104' style='cursor:default;' onClick=\"window.open('" + image_path + "','view_photo" + i + "','menubar=0,resizable=0,width=600,height=600,location=0,status=0,scrollbars=1,toolbar=0,directories=0');\" onMouseOver=\"this.style.cursor='pointer';\" id='" + photo_img + "'  />";
			var mImageTimer = setTimeout("CheckBkgndImage('" + image_path + "', '" + photo_img + "');", 2000);
		}
		else	{
			html = "<img alt='photo' src='/manage/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img" + i + "' />";
		}
		
		document.getElementById(preview_ctl).innerHTML = html;
	}
}

function CheckBkgndImage(image_path, photo_img)
{
	if ((document.getElementById(photo_img).naturalWidth == 0) || (document.getElementById(photo_img).naturalWidth == 'undefined'))
		document.getElementById(photo_img).src = image_path;
}

///////////////////////////////////////////////////////////////////////////////////////////
function ChangeSort(bAlpha)
{
	var sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;
	var goto_class = document.getElementById('goto_class').value;
	if (goto_class == "")
		goto_class = 0;
	var style_sheet = document.getElementById('style_sheet').value;
	
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Sorting class list...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();

	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","sort_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage2(xmlhttp);

		params = "sort_alpha=" + sort_alpha;
		params = params + "&goto_class=" + goto_class;
		params = params + "&style_sheet=" + style_sheet;
	
		xmlhttp.send(params);
	}
}

function UpdateMessage2(xmlhttp)
{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				document.getElementById("goto_class_div").innerHTML = xmlhttp.responseText;
				popup_msg.status_msg = "Sort complete";
			}
			popup_msg.popup_timeout = 1000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = "Query ready to send...";
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = "Query sent";
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = "Sorting...";
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}