/////////////////////////////////////////////
// Edit Custom CSS /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/1/2014	ELL
// Revised: 7/29/2014	ELL
// Converted save functions to JQuery AJAX operations.
// Revised: 10/19/2014	ELL
// Converted editor for simple text area to CKEditor is source view.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.

var mTimer;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_custom", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////
function LoadCSS()
{
	$.post( "get_custom_css.php", { custom_site_css_table: custom_site_css_table } ).done(CompleteLoadCSS) ;
}
function CompleteLoadCSS(data)
{
//	alert(data);
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var custom_css = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	$.post( "save_custom_css.php", { custom_css: custom_css, action: action, custom_site_css_table: custom_site_css_table, style_sheet: style_sheet } ).done(CompleteSave) ;
}

function CompleteSave(data)	{
	if (data == "Preview")
		window.location = "preview_css.php?style_sheet=" + style_sheet + "&custom=1";
	else
	{
		popup_msg.status_msg = data;
	//	alert(data);
		popup_msg.popup_timeout = 2000;
		popup_msg.ShowPopupMsg();
		saved = true;
		window.parent.SetWorkSavedNotSaved(saved);
		bwb_ckeditor.resetDirty();
	}
}

function RevertConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Are you sure you want to revert the <b>" + style_sheet + "</b> css?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { Revert(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}
function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Reverting to last published version...";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	$.post( "revert_custom_css.php", { custom_site_css_table: custom_site_css_table } ).done(CompleteRevert) ;
}
function CompleteRevert(data)	{
	if (data == "No draft found")
		popup_msg.status_msg = data;
	else	{
		popup_msg.status_msg = "Revert completed";
		CKEDITOR.instances['editorContainer'].setData(data);
	}
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Your CSS is not saved.  Do you want to save your changes?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	Save('Save');
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

	var editorWidth = mainWidth - menuWidth;
	var editorHeight = mainHeight - headerHeight - 58;

	CKEDITOR.instances['editorContainer'].resize(editorWidth, editorHeight);
	
	tableWidth = editorWidth - 50;
	sTableWidth = tableWidth.toString() + "px";
	document.getElementById("btn_table").style.width = sTableWidth;
}