<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/20/2013	ELL
// New main.php created for version 5 of the BWB.
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 12/22/2013	ELL
// Added ability to check for saved wokspace data and prompt user for action.
// Revised: 3/12/2013	ELL
// Fixed pesky bug with buttons locking up.
// Revised: 4/3/2014	ELL
// Added button for installing plugins into existing pages.
// Revised: 4/14/2014	ELL
// Added ability to present plugin buttons to bloggers and restricted users if plugin access set to blogger or restricted.
// Revised: 11/17/2014	ELL
// Added new button for editing files.
	
	include ("check_session.php");
	
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'EnableWizard'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$enable_wizard = $row['option_value'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'RunWizardLocal'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$wiz_mode = $row['option_value'];
	
	if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
		$website_file_path = "/index.php";
	elseif (BWB_BASE_DIR == '')
		$website_file_path = "/" . BWB_WEBPAGE_DIR . "/";
	elseif (BWB_WEBPAGE_DIR == '')
		$website_file_path = "/" . BWB_BASE_DIR . "/";
	else
		$website_file_path = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";
		
	/////////// Determine Plugin Buttons ///////////////////////////
	function custom_inArray($needle, $haystack) {
	// $needle is string, but elements of array $haystack are also arrays.  If any element in array element
	// matches string, return true, otherwise false.
		foreach ($haystack as $value) {
			if (in_array($needle, $value)) {
				return true;
			}
		}
		return false;
	}

	if ($access_level == "blogger")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE (AccessLevel='blogger') AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "restricted")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted')) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted') OR (AccessLevel='user')) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "power_user")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='blogger') OR (AccessLevel='restricted') OR (AccessLevel='user') OR (AccessLevel='power_user')) AND (deployed=1) ORDER BY sort_order";
	elseif ($access_level == "admin")
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE deployed=1 ORDER BY sort_order";
		
	$plugin_buttons = array();
	$plugin_css = array();
	$result = $bwb_dbh->query($query);
	if (($result->rowCount() < 1) && (($access_level == "restricted") || ($access_level == "blogger")))
		$show_other = false;
	else
		$show_other = true;
	$i = 0;
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$console_path = $row['console_path'];
		if (isset($console_path) && ($console_path != ""))
		{
			$console_link_text = $row['console_link_text'];
			$console_link_image = $row['console_link_image'];
			$console_link_image_mo = $row['console_link_image_mo'];
			$console_link_image_down = $row['console_link_image_down'];
//				if (!in_array($console_path, $plugin_buttons, true))
			if (!custom_inArray($console_path, $plugin_buttons))
			{
				$button_string = "<div class=\"button_top_level\" id=\"btn_custom_" . $i . "\" title=\"" . $console_link_text . "\" onClick=\"SetWorkspaceLocation('" . $console_path . "', this);\"><span class=\"button_text_top_level\">" . $console_link_text . "</span></div>\n";
				
				$css_string = "#btn_custom_" . $i . "	{	background-image:url(" . $console_link_image . ");	}\n";
				$css_string .= "#btn_custom_" . $i . ":hover	{	background-image:url(" . $console_link_image_mo . ");	}\n";
				$css_string .= "#btn_custom_" . $i . ".down	{	background-image:url(" . $console_link_image_down . ");	}\n";
				
				$plugin_buttons[$console_link_text] = array($console_path, $button_string);
				$plugin_css[$console_link_text] = array($console_path, $css_string);
				$i++;
			}
		}
	}
	$plugin_button_cnt = count($plugin_buttons);
?>
<!doctype html>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="stylesheet" href="manager.css" type="text/css">

<style type="text/css">
<?php
	if ($plugin_css)
	{
		foreach ($plugin_css as $key => $value)
			echo $value[1];
	}
?>
#help_button	{
	display:block;
	position:absolute;
	top:10px;
	right:12px;
}

.help_button_main	{
	width:30px;
	height:30px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/help.png);
}
.help_button_main:hover	{
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 0px 1px;
	background-image:url(images/help_mo.png);
	cursor:pointer;
}
</style>

<script language="javascript" type="text/javascript" src="js/ajax.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/main.js"></script>

<script language="JavaScript"  type="text/javascript">

function InitializePage()
{
//	alert(browser + " " + browser_version);
//	alert("document.body.clientWidth: " + document.body.clientWidth);
//	alert("document.body.clientHeight: " + document.body.clientHeight);
//	alert("window.innerWidth: " + window.innerWidth);
//	alert("window.innerHeight: " + window.innerHeight);
	SetAccessLevel();
	ExpandCollapseMenus();
	ResizeWorkspace();
	
<?php
	if (isset($_SESSION['button_group']) && isset($_SESSION['button']))
	{
		$button_group = $_SESSION['button_group'];
		$button = $_SESSION['button'];
		echo "function SetPreviousBtnState()	{\n";
		echo "	ExpandCollapseMenus('$button_group');\n";
		echo "	var btn_el = document.getElementById('$button');\n";
		echo "	SetBtnDown(btn_el);\n";
		echo "	btn_el.click();\n";
		echo "}\n";
		echo "	var timer = setTimeout(function() { SetPreviousBtnState(); }, 2000);\n";
		unset($_SESSION['button_group']);
		unset($_SESSION['button']);
	}
?>
}

function ResizeWorkspace()
{
	if ((browser == "Explorer") && (browser_version <= 7))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		// Roughly 440 pixels added to client height with menus expaned that also needs to be subtracted off.
		document.getElementById("workspace").height = document.body.clientHeight - workspace_top_expanded - 440;
		document.getElementById("workspace").style.top = "145px";
		document.getElementById("btn_horizontal_expand_collapse_menus").style.top = "145px";
	}
	else if ((browser == "Explorer") && (browser_version == 8))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		// Roughly 440 pixels added to client height with menus expaned that also needs to be subtracted off.
		document.getElementById("workspace").height = document.body.clientHeight - workspace_top_expanded - 410;
	}
	else if ((browser == "Explorer") && (browser_version > 8))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		document.getElementById("workspace").height = window.innerHeight - workspace_top_expanded - 10;
	}
	else // if ((browser == "Firefox") || (browser == "Opera") || (browser == "Safari") || (browser == "Chrome"))
	{
		document.getElementById("workspace").width = document.body.clientWidth - workspace_left_expanded;
		document.getElementById("workspace").height = window.innerHeight - workspace_top_expanded - 20;
	}
//	alert("document.getElementById('workspace').height: " + document.getElementById("workspace").height);
}
	
var access_level = '<?php echo $access_level; ?>';
var enable_wizard = '<?php echo $enable_wizard; ?>';


<?php
	if (isset($plugin_button_cnt))
		echo "	var plugin_button_cnt = $plugin_button_cnt;\n";
	else
		echo "	var plugin_button_cnt = 0;\n";
		
	if ($show_other)
		echo "	var show_other = true;\n";
	else
		echo "	var show_other = false;\n";
	
?>

</script>
</head>

<body onLoad="InitializePage();" class="main">

<div id="logo_div">
<img src="images/Breeze_header_logo.png" border="0" alt="Breeze Website Builder" style="margin-top:-10px; margin-left:-10px;" onClick="CollapseHeader();" />
</div>

<div class="help_button_main" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div>

<div id="header_divider" onClick="ExpandHeader();">
	<span class="header_divider_text">BREEZE WEBSITE BUILDING MODULE
  <div id="bwb_version">
		<?php include ("version.php"); ?>
	</div>
    </span>
</div>

<img src="images/icon_collapse-column.png" border="0" onClick="HorizontalExpandCollapseMenuClick();" id="btn_horizontal_expand_collapse_menus" />
<div id="view_buttons">
<div id="content_functions">
<div class="button_heading_top_level" id="btn_heading_content" title="CONTENT" onClick="ExpandCollapseMenus('content_functions');"><div class="button_heading_text_top_level">CONTENT</div></div>
<div class="button_top_level" id="btn_edit_content" title="Edit Content" onClick="SetWorkspaceLocation('edit_page_select.php', this);"><span class="button_text_top_level">Edit Content</span></div>
<div class="button_top_level" id="btn_create_page" title="Create Page" onClick="SetWorkspaceLocation('create_page_select.php', this);"><span class="button_text_top_level">Create Page</span></div>
<div class="button_top_level" id="btn_manage_border_areas" title="Manage Border Areas" onClick="SetWorkspaceLocation('manage_border_area_select.php', this);"><span class="button_text_top_level">Manage Border Areas</span></div>
<div class="button_top_level" id="btn_manage_images" title="Manage Images" onClick="SetWorkspaceLocation('/kfm/index.php?startup_folder=<?php echo BWB_IMAGE_DIR; ?>', this);"><span class="button_text_top_level" >Manage Images</span></div>
<div class="button_top_level" id="btn_preview_published_site" title="Preview Published Site" onClick="SetWorkspaceLocation('<?php echo $website_file_path; ?>', this);"><span class="button_text_top_level">Preview Published Site</span></div>
<div class="button_top_level" id="btn_manage_edit_blog" title="Manage | Edit Blog" onClick="SetWorkspaceLocation('edit_blog_select.php', this);"><span class="button_text_top_level">Manage | Edit Blog</span></div>
<div class="button_top_level" id="btn_edit_file" title="Edit File" onClick="SetWorkspaceLocation('edit_file_select.php', this);"><span class="button_text_top_level">Edit File</span></div>
</div>

<div id="menu_functions">
<div class="button_heading_top_level" id="btn_heading_menu" title="MENUS" onClick="ExpandCollapseMenus('menu_functions');"><div class="button_heading_text_top_level">MENUS</div></div>
<div class="button_top_level" id="btn_edit_menu_items" title="Edit Menus" onClick="SetWorkspaceLocation('edit_menu_items.php', this);"><span class="button_text_top_level">Edit Menus</span></div>
<div class="button_top_level" id="btn_manage_menu_assignments" title="Manage Menu Assignments" onClick="SetWorkspaceLocation('manage_menu.php', this);"><span class="button_text_top_level">Manage Menu Assignments</span></div>
<div class="button_top_level" id="btn_edit_css_menu_params" title="Edit CSS-Menu Parameters" onClick="SetWorkspaceLocation('edit_css_menu_params.php', this);"><span class="button_text_top_level">Edit CSS-Menu Parameters</span></div>
<div class="button_top_level" id="btn_edit_css_menu_styles" title="Edit CSS-Menu Styles" onClick="SetWorkspaceLocation('edit_css_menu_styles.php', this);"><span class="button_text_top_level" >Edit CSS-Menu Styles</span></div>
<div class="button_top_level" id="btn_edit_js_menu_params" title="Edit JavaScript-Menu Parameters" onClick="SetWorkspaceLocation('edit_js_menu_params.php', this);"><span class="button_text_top_level">Edit JS-Menu Parameters</span></div>
<div class="button_top_level" id="btn_edit_js_menu_styles" title="Edit JavaScript-Menu Styles" onClick="SetWorkspaceLocation('edit_js_menu_styles.php', this);"><span class="button_text_top_level">Edit JS-Menu Styles</span></div>
</div>

<div id="style_functions">
<div class="button_heading_top_level" id="btn_heading_style" title="STYLES and HEAD CONTENT" onClick="ExpandCollapseMenus('style_functions');"><div class="button_heading_text_top_level" style="letter-spacing:-1px">STYLES &amp; HEAD CONTENT</div></div>
<div class="button_top_level" id="btn_edit_styles" title="Edit Styles" onClick="SetWorkspaceLocation('edit_css_select.php', this);"><span class="button_text_top_level">Edit Styles</span></div>
<div class="button_top_level" id="btn_edit_head_code" title="Edit Head Code" onClick="SetWorkspaceLocation('edit_head_select.php', this);"><span class="button_text_top_level">Edit Head Code</span></div>
<div class="button_top_level" id="btn_manage_head_code" title="Manage Head Code" onClick="SetWorkspaceLocation('manage_head.php', this);"><span class="button_text_top_level">Manage Head Code</span></div>
<div class="button_top_level" id="btn_edit_favicon" title="Edit Favicon" onClick="SetWorkspaceLocation('edit_favicon.php', this);"><span class="button_text_top_level">Edit Favicon</span></div>
</div>

<div id="page_functions">
<div class="button_heading_top_level" id="btn_heading_page" title="PAGE MANAGEMENT" onClick="ExpandCollapseMenus('page_functions');"><div class="button_heading_text_top_level">PAGE MANAGEMENT</div></div>
<div class="button_top_level" id="btn_edit_page_titles" title="Edit Page Titles" onClick="SetWorkspaceLocation('edit_title_select.php', this);"><span class="button_text_top_level">Edit Page Titles</span></div>
<div class="button_top_level" id="btn_edit_meta_tags" title="Edit Meta Tags" onClick="SetWorkspaceLocation('edit_meta_tags.php', this);"><span class="button_text_top_level">Edit Meta Tags</span></div>
<div class="button_top_level" id="btn_delete_page" title="Delete Page or Blog" onClick="SetWorkspaceLocation('delete_page_select.php', this);"><span class="button_text_top_level">Delete Page or Blog</span></div>
<div class="button_top_level" id="btn_copy_rename_page" title="Copy or Rename Pages" onClick="SetWorkspaceLocation('copy_rename_page_select.php', this);"><span class="button_text_top_level">Copy or Rename Pages</span></div>
<div class="button_top_level" id="btn_restore_page" title="Restore Page" onClick="SetWorkspaceLocation('restore_page_select.php', this);"><span class="button_text_top_level">Restore Page</span></div>
<div class="button_top_level" id="btn_add_plugin_to_page" title="Install Plugin Into Page" onClick="SetWorkspaceLocation('add_plugin_to_page_select.php', this);"><span class="button_text_top_level">Install Plugin Into Page</span></div>
<div class="button_top_level" id="btn_manage_page_access" title="Manage Page Access" onClick="SetWorkspaceLocation('manage_page_access.php', this);"><span class="button_text_top_level">Manage Page Access</span></div>
</div>

<div id="other_functions">
<div class="button_heading_top_level" id="btn_heading_site" title="SITE MANAGEMENT" onClick="ExpandCollapseMenus('other_functions');"><div class="button_heading_text_top_level">SITE MANAGEMENT</div></div>
<div id="plugin_buttons_div">
<?php
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $key => $value)
			echo $value[1];
	}
?>
</div>

<?php
	if (($access_level != "blogger") && ($access_level != "restricted"))
	{
		if ($enable_wizard == 1)
		{
			if ($wiz_mode == 1)
				echo "<div class=\"button_top_level\" id=\"btn_show_wizard\" title=\"Re-run Wizard\" onClick=\"SetWorkspaceLocation('run_wizard_confirm.php', this);\"><span class=\"button_text_top_level\">Re-run Wizard</span></div>\n";
			else
				echo "<div class=\"button_top_level\" id=\"btn_show_wizard\" title=\"Upload Template\" onClick=\"SetWorkspaceLocation('upload_template_confirm.php', this);\"><span class=\"button_text_top_level\">Upload Template</span></div>\n";
		}
?>

<div class="button_top_level" id="btn_users_site_options" title="Manage Users and Site Options" onClick="SetWorkspaceLocation('admin_function_select.php', this);"><span class="button_text_top_level">Manage Users &amp; Site Options</span></div>
</div>
<?php } // access_level > restricted and blogger ?>
</div>

<div id="access_level">Access Level: <span class="access_level"><?php echo $access_level; ?></span></div>
<div id="username"> Welcome <?php if (($first_name != "") || ($last_name != "")) echo $first_name . " " . $last_name; else echo $userid; ?></div>

<div class="button_heading_top_level logout" id="btn_logout" onClick="window.location='index.php';"><span class="button_heading_text_top_level logout">LOGOUT</span></div>


<iframe src="dashboard.php" name="workspace" id="workspace" scrolling="auto" frameborder="0" style="overflow-x:scroll;"></iframe>


<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
//alert(browser + " " + browser_version);

HidePopupMsg();
</script>
</body>
</html>
