<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/13/2013	ELL
// 
//
	include ("check_session.php");
	
	function custom_inArray($needle, $haystack) {
	// $needle is string, but elements of array $haystack are also arrays.  If any element in array element
	// matches string, return true, otherwise false.
		foreach ($haystack as $value) {
			if (in_array($needle, $value)) {
				return true;
			}
		}
		return false;
	}
	
	if ($access_level != "restricted")
	{
		if ($access_level == "user")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='restricted') OR (AccessLevel='user')) AND (deployed=1)";
		elseif ($access_level == "power_user")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE ((AccessLevel='restricted') OR (AccessLevel='user') OR (AccessLevel='power_user')) AND (deployed=1)";
		elseif ($access_level == "admin")
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugins WHERE deployed=1";
			
		$plugin_buttons = array();
		$plugin_css = array();
		$result = $bwb_dbh->query($query);
		$i = 0;
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$console_path = $row['console_path'];
			if (isset($console_path) && ($console_path != ""))
			{
				$console_link_text = $row['console_link_text'];
				$console_link_image = $row['console_link_image'];
				$console_link_image_mo = $row['console_link_image_mo'];
				$console_link_image_down = $row['console_link_image_down'];
				
				if (!custom_inArray($console_path, $plugin_buttons))
				{
					$button_string = "<div class=\"button_top_level\" id=\"btn_custom_" . $i . "\" title=\"" . $console_link_text . "\" onClick=\"workspace.location='" . $console_path . "'; SetBtnDown(this);\"><span class=\"button_text_top_level\">" . $console_link_text . "</span></div>\n";
					
					$css_string = "#btn_custom_" . $i . "	{	background-image:url(" . $console_link_image . "); height:0px;	}\n";
					$css_string .= "#btn_custom_" . $i . ":hover	{	background-image:url(" . $console_link_image_mo . ");	}\n";
					$css_string .= "#btn_custom_" . $i . ".down	{	background-image:url(" . $console_link_image_down . ");	}\n";
					
					$plugin_buttons[$console_link_text] = array($console_path, $button_string);
					$plugin_css[$console_link_text] = array($console_path, $css_string);
					$i++;
				}
			}
		}
		$plugin_button_cnt = count($plugin_buttons);
	}
	
	if ($plugin_css)
	{
		foreach ($plugin_css as $key => $value)
		{
			echo $delim . $value[1];
		}
	}
	echo ":::";
	
	if ($plugin_buttons)
	{
		foreach ($plugin_buttons as $key => $value)
			echo $value[1];
	}
	
	echo ":::" . $plugin_button_cnt;
?>