<?php
/////////////////////////////////////////////
// Upload Template /////
////////////////////////////////////////////////////////////////////////
//	Breeze Website Builder
//	Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
//	For licensing, see license.txt.
//	Created: 10/2/2011	ELL
//	Revised: 2/10/2012	ELL
//  Added table prefix handling.  Added references to images folder configuration.
// 	Revised: 4/9/2013	ELL
//  Added call out of SQL file name and changed reference to sql file run module.
//
// 
//
	include ("check_session.php");
	include ("lib/archive.php");
	include ("lib/copy_dir.php");
	
	//////////////////////////////////////
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	//////////////////////////////////////////
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</script>
</head>
<body>
<h2>Building site with template....<br />
&nbsp;&nbsp;When completed, scroll to bottom to continue.</h2>
<?php
	if (is_uploaded_file($_FILES['template_file']['tmp_name']))
	{	
		$source = $_FILES['template_file']['tmp_name'];
		$file_name = $_FILES['template_file']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		if (!((strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "gz") == 0)))
		{
			echo "Only gzipped tar files are allowed to be uploaded, i.e. 'template_105.tgz' or 'template_26.tar.gz'.  Please click <a href='browse_template.php'>here</a> and try again.";
			exit;
		}
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . "/" . $file_name;
		move_uploaded_file( $source, $destination );
		
		$delete_all_pages = $_POST['delete_all_pages'];
		
		if ($delete_all_pages == 1)
		{
			$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "page_data";
			$cnt = $bwb_dbh->exec($query);
		}
		
		// Open template gzip file and extract tar. 
		$template_gzip = new gzip_file($destination);
		// Set to overwrite existing files
		$template_gzip->set_options(array('overwrite' => 1, 'basedir' => $document_root));
		// Extract contents of archive to disk
		$template_gzip->extract_files();
		
		// Move base folder.
		$dir_handle = opendir($document_root) or die("Unable to open document root.");
		while ($file = readdir($dir_handle)) 
		{
			if($file!="." && $file!=".." && is_dir("$document_root/$file") && !(strpos($file, "tmp")===false))
				$old = $document_root . "/" . $file;
		}
		closedir($dir_handle);
		$new = $document_root . "/tmp";
		if (file_exists($new))	// If tmp folder already exists, back it up.
		{
			$bkup = $new . date('YmdHis', time());
			rename($new, $bkup);
		}
		rename($old, $new);
		
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		if (BWB_WEBPAGE_DIR == '')
			$website_dir = '';
		else
			$website_dir = "/" . BWB_WEBPAGE_DIR;
		
		// Copy files to correct folders.
		echo "Copying user files...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/";
		$destination = $document_root . $userfiles . "/";
		copydir($source, $destination);
		echo "Copying pages...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/file/";
		$destination = $document_root . $userfiles . $website_dir ."/";
		copydir($source, $destination);
		echo "Copying images...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/image/";
		$destination = $document_root . $userfiles . "/" . BWB_IMAGE_DIR . "/";
		copydir($source, $destination);
		echo "Copying css...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/css/";
		$destination = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/";
		copydir($source, $destination);
		echo "Copying media...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/media/";
		$destination = $document_root . $userfiles . "/" . BWB_MEDIA_DIR . "/";
		copydir($source, $destination);
		echo "Copying flash...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/flash/";
		$destination = $document_root . $userfiles . "/" . BWB_FLASH_DIR . "/";
		copydir($source, $destination);
		echo "Copying scripts...<br><br>\n";
		$source = $document_root . "/tmp/userfiles/scripts/";
		$destination = $document_root . $userfiles . "/" . BWB_SCRIPTS_DIR . "/";
		copydir($source, $destination);
		echo "Copying XML...<br><br>\n";
		$source = $document_root . "/tmp/ckeditor/";
		$destination = $document_root . "/ckeditor/";
		copydir($source, $destination);
		
		// Run template SQL
		$sql_file = "template.sql";
		include ("run_sql_file.php");
		
		/////////////////////////////////////////////////////////////////////////////////////
		// Build new site.css file in case user selected custom background colors or images.
		$site_css_table = "site_css";
		$css_file = "site.css";
		$custom_site_css_table = "custom_site_css";
		$class_table = "site_classes";
		include ("build_css_string.php");
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo "Could not rename $file_name to $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
		$result = (fputs($fh, $css_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
		
?>
		<h2>Template installation is comlplete.</h2>
        <h2>Click <a href="/manage/main.php?mode=wizard" target="_parent">here</a> to continue.</h2>

<?php
	}
	else
		echo "There was an error uploading the file.  Click <a href='browse_template.php'>here</a> to try again.";
?>
</body>
</html>