CREATE TABLE `bwb_version` (
`version` VARCHAR( 32 ) NOT NULL ,
PRIMARY KEY ( `version` )
) ENGINE = MYISAM ;

INSERT INTO `bwb_version` (`version`) VALUES ('5.4.54');


CREATE TABLE IF NOT EXISTS `bwb_access_levels` (
  `access_level` varchar(64) NOT NULL,
  PRIMARY KEY  (`access_level`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_access_levels` (`access_level`) VALUES
('admin'),
('power_user'),
('restricted'),
('user');


CREATE TABLE IF NOT EXISTS `bwb_blogs` (
  `id` bigint(20) NOT NULL auto_increment,
  `post` longtext,
  `page_name` varchar(255) NOT NULL,
  `owner` varchar(255) default NULL,
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `page_name` varchar(255) default NULL,
  `post` longtext,
  `owner` varchar(255) default NULL,
  `revised` datetime default NULL,
  `deleted` datetime default NULL,
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_blogs_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `blog_id` bigint(20) NOT NULL,
  `post` longtext,
  `revised` datetime default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;



CREATE TABLE IF NOT EXISTS `bwb_blog_classes` (
  `class` varchar(128) NOT NULL,
  `description` varchar(255) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  `subclass_sort_order` int(11) NOT NULL default '0',
  `custom` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_blog_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('.blog_subject', 'Blog Subject', 10, 0, 0),
('.blog_timestamp', 'Blog Timestamp', 20, 0, 0),
('.blog_message', 'Blog Message', 30, 0, 0),
('.blog_author', 'Blog Author', 40, 0, 0),
('.blog_hr', 'Blog Horizontal Rule', 50, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_blog_css` (
  `class` varchar(128) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_blog_css` (`class`, `use_table_data`, `font`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `font_stretch`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `height`, `height_units`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`) VALUES
('.blog_subject', 1, '-not selected-', -1, '-not set-', -1, -1, -1, -1, '-not selected-', 0, 0, 0, 0, 0, '-not selected-', 0, 0, 0, 0, '-not set-', 0, 0, 0, '-not selected-', '-not selected-', -1, 0, '-not set-', -1, -1, '-not set-', '-not selected-', '-not selected-', '-not selected-', 0, -1000000, 0, 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, '-not selected-', -1, 0, -1, 0, '-not selected-', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, '-not selected-', NULL, -1, 0, -1, 0, -1, 0, -1, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', 0, 0, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', '-not selected-', '-not selected-'),
('.blog_timestamp', 1, '-not selected-', 10, '-not set-', -1, -1, -1, -1, '-not selected-', 0, 0, 0, 0, 0, '-not selected-', 0, 0, 0, 0, '-not set-', 0, 0, 0, '-not selected-', '-not selected-', -1, 0, '-not set-', -1, -1, '-not set-', '-not selected-', '-not selected-', '-not selected-', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, 'inline-block', -1, 0, -1, 0, 'relative', -1000000, 0, -40, 0, -1000000, 0, -1000000, 0, -1000000, '-not selected-', NULL, -1, 0, -1, 0, -1, 0, -1, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', 0, 0, 0, '-not selected-', '-not selected-', '-not selected-', 'right', '-not selected-', '-not selected-'),
('.blog_message', 1, '-not selected-', -1, '-not set-', -1, -1, -1, -1, '-not selected-', 0, 0, 0, 0, 0, '-not selected-', 0, 0, 0, 0, '-not set-', 0, 0, 0, '-not selected-', '-not selected-', -1, 0, '-not set-', -1, -1, '-not set-', '-not selected-', '-not selected-', '-not selected-', 0, -1000000, 0, 0, 5, 0, 0, 5, 0, 0, -1000000, 0, 0, '-not selected-', -1, 0, -1, 0, '-not selected-', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, '-not selected-', NULL, -1, 0, -1, 0, -1, 0, -1, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', 0, 0, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', '-not selected-', '-not selected-'),
('.blog_author', 1, '-not selected-', -1, '-not set-', -1, -1, -1, -1, '-not selected-', 0, 0, 0, 0, 0, '-not selected-', 0, 0, 0, 0, '-not set-', 0, 0, 0, '-not selected-', '-not selected-', -1, 0, '-not set-', -1, -1, '-not set-', '-not selected-', '-not selected-', '-not selected-', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, '-not selected-', -1, 0, -1, 0, '-not selected-', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, '-not selected-', NULL, -1, 0, -1, 0, -1, 0, -1, 0, '-not selected-', '-not selected-', '-not selected-', '-not selected-', 0, 0, 0, '-not selected-', '-not selected-', '-not selected-', 'right', '-not selected-', '-not selected-');


CREATE TABLE IF NOT EXISTS `bwb_captcha` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `challenge` varchar(255) NOT NULL,
  `response` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=96 ;

INSERT INTO `bwb_captcha` (`id`, `challenge`, `response`) VALUES
(7, 'captcha1.png', 'KY5Y'),
(8, 'captcha2.png', 'thtmxs'),
(9, 'captcha3.png', '12444'),
(10, 'captcha4.png', 'gousme'),
(11, 'captcha5.png', 'methro'),
(12, 'captcha6.png', '8AJPRPHV'),
(13, 'captcha7.png', '7W3I'),
(14, 'captcha8.png', 'Pne6F'),
(15, 'captcha9.png', '8BVM'),
(16, 'captcha10.png', 'PhfK8'),
(17, 'captcha11.png', '0K9XB'),
(18, 'captcha12.png', '28iVW'),
(19, 'captcha13.png', 'k4ez'),
(20, 'captcha14.png', 'jw62k'),
(21, 'captcha15.png', 'FH2DE'),
(22, 'captcha16.png', 'gwprp'),
(23, 'captcha17.png', '4D7YS'),
(24, 'captcha18.png', 'e5hb'),
(25, 'captcha19.png', 'xmqki'),
(26, 'captcha20.png', '6ne3'),
(27, 'captcha21.png', 'XDHYN'),
(28, 'captcha22.png', 'q98p'),
(29, 'captcha23.png', 'HRAI'),
(30, 'captcha24.png', '4R3A'),
(31, 'captcha25.png', 'ZYPEB'),
(32, 'captcha26.png', 'N65X'),
(33, 'captcha27.png', 'DYZB2'),
(34, 'captcha28.png', '4ZUDA'),
(35, 'captcha29.png', '243424'),
(36, 'captcha30.png', 'DOGY'),
(37, 'captcha31.png', 'TICA'),
(38, 'captcha32.png', 'AKOF'),
(39, 'captcha33.png', 'IXYCO'),
(40, 'captcha34.png', 'Ministry'),
(41, 'captcha35.png', 'Tried'),
(42, 'captcha36.png', 'ZSf69'),
(43, 'captcha37.png', 'CS6T5'),
(44, 'captcha38.png', 'SXGPT'),
(45, 'captcha39.png', '5GC6R'),
(46, 'captcha40.png', '5S4UG'),
(47, 'captcha41.png', 'RJ28Q'),
(48, 'captcha42.png', '4P3X4'),
(49, 'captcha43.png', 'NOW'),
(50, 'captcha44.png', 'lengrat&'),
(51, 'captcha45.png', 'ideas'),
(52, 'captcha46.png', 'is easy'),
(53, 'captcha47.png', 'just'),
(54, 'captcha48.png', 'use'),
(55, 'captcha49.png', 'Captcha'),
(56, 'captcha50.png', 'Code'),
(57, 'captcha51.png', 'fhrc'),
(58, 'captcha52.png', 'cralsist'),
(59, 'captcha53.png', 'unrexc'),
(60, 'captcha54.png', 'vohte'),
(61, 'captcha55.png', 'dutne'),
(62, 'captcha56.png', 'sondted'),
(63, 'captcha57.png', 'pliaom'),
(64, 'captcha58.png', 'unbadnar'),
(65, 'captcha59.png', 'aphxleci'),
(66, 'captcha60.png', 'tegunt'),
(67, 'captcha61.png', 'ejuje'),
(68, 'captcha62.png', 'unnedou'),
(69, 'captcha63.png', 'vedsho'),
(70, 'captcha64.png', 'trapperb'),
(71, 'captcha65.png', 'wans'),
(72, 'captcha66.png', 'py8894'),
(73, 'captcha67.png', '4TEF'),
(74, 'captcha68.png', 'leopard'),
(75, 'captcha69.png', 'Marks'),
(76, 'captcha70.png', 'nsuldGW'),
(77, 'captcha71.png', 'natural'),
(78, 'captcha72.png', 'Brook'),
(79, 'captcha73.png', 'Reports'),
(80, 'captcha74.png', 'overlooks'),
(81, 'captcha75.png', 'inquiry'),
(82, 'captcha76.png', 'storsce'),
(83, 'captcha77.png', 'Theretr'),
(84, 'captcha78.png', 'them'),
(85, 'captcha79.png', 'urethras'),
(86, 'captcha80.png', 'Mr blocked'),
(88, 'captcha82.png', 'rehiring it'),
(89, 'captcha83.png', 'G5RRP'),
(90, 'captcha84.png', 'KK3J6'),
(91, 'captcha85.png', 'F64FE'),
(92, 'captcha86.png', 'BSXJY'),
(93, 'captcha87.png', 'WZHWR'),
(94, 'captcha88.png', 'VHMB2'),
(95, 'captcha89.png', 'polthed'),
(96, 'captcha11.png', '9K9XB'),
(97, 'captcha11.png', 'QK9XB'),
(98, 'captcha8.png', 'PNe6f'),
(99, 'captcha10.png', 'Phfk8'),
(100, 'captcha10.png', 'phfK8'),
(101, 'captcha10.png', 'phfk8'),
(102, 'captcha12.png', '28ivw'),
(103, 'captcha14.png', 'jw62K'),
(104, 'captcha19.png', 'xmqKi'),
(105, 'captcha19.png', 'xmgki'),
(106, 'captcha19.png', 'xmgKi'),
(107, 'captcha28.png', 'AZUDA'),
(108, 'captcha36.png', 'zsf69'),
(109, 'captcha44.png', 'lencrat&'),
(110, 'captcha44.png', 'lenerat&'),
(111, 'captcha48.png', 'usa'),
(112, 'captcha51.png', 'flirc'),
(113, 'captcha54.png', 'valite'),
(114, 'captcha55.png', 'dultne'),
(115, 'captcha56.png', 'sonated'),
(116, 'captcha57.png', 'plicrom'),
(117, 'captcha58.png', 'unbachar'),
(118, 'captcha61.png', 'ejujle'),
(119, 'captcha65.png', 'wrans'),
(120, 'captcha76.png', 'Storsce'),
(121, 'captcha10.png', 'PhfKB'),
(122, 'captcha10.png', 'PhfkB'),
(123, 'captcha10.png', 'phfKB'),
(124, 'captcha10.png', 'phfkB');


CREATE TABLE `bwb_custom_site_css` (
  `custom_css` longtext,
  `revised` DATETIME NULL
) ;


CREATE TABLE `bwb_custom_site_mobile_css` (
  `custom_css` longtext,
  `revised` DATETIME NULL
) ;


CREATE TABLE `bwb_custom_site_css_preview` (
  `custom_css` longtext,
  `revised` DATETIME NULL
) ;


CREATE TABLE IF NOT EXISTS `bwb_fonts` (
  `font` varchar(255) NOT NULL default '',
  `websafe` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`font`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_fonts` (`font`, `websafe`) VALUES
('Alba', 0),
('Algerian', 0),
('Arial', 1),
('Arial Rounded MT Bold', 0),
('Bangle', 0),
('Baskerville Old Face', 0),
('Bodini MT', 0),
('Britannic Bold', 0),
('Broadway', 0),
('Comic Sans MS', 1),
('Edwardian Script ITC', 0),
('Geneva', 0),
('Helvetica', 1),
('Helvetica Neue', 0),
('Rockwell Condensed', 0),
('Tahoma', 1),
('Vivaldi', 0),
('Times New Roman', 1),
('Verdana', 1),
('Papyrus', 0),
('Garamond', 0),
('Bradley Hand ITC', 0),
('Brush Script MT', 0),
('BRADDON', 0),
('Amaze', 0),
('Bookman Old Style', 0),
('Century Gothic', 0),
('Cooper Black', 0),
('Courier New', 1),
('Elephant', 0),
('Engravers MT', 0),
('Franklin Gothic Book', 0),
('Georgia', 1),
('sans-serif', 1),
('serif', 1),
('monospace', 1),
('cursive', 1),
('fantasy', 1),
('Trebuchet MS', 1),
('Lucida Sans', 1),
('Arial Black', 1),
('Courier', 1),
('Impact', 1),
('Charcoal', 1),
('Lucida Console', 1),
('Monaco', 1),
('Lucida Sans Unicode', 1),
('Lucida Grande', 1),
('Palatino Linotype', 1),
('Book Antiqua', 1),
('Palatino', 1),
('Symbol', 1),
('Webdings', 1),
('Wingdings', 1),
('Zapf Dingbats', 1),
('New York', 1),
('MS Serif', 1),
('Felix', 0),
('Felix Titling', 0),
('Monotype Corsiva', 0),
('Rage Italic', 0),
('Agency FB', 0),
('Haettenschweiler', 0),
('Forte', 0),
('Lucida Calligraphy', 0),
('Lucida Handwriting', 0),
('Magneto', 0),
('Mistral', 0),
('Old English Text MT', 0),
('Short Hand', 0),
('Stencil', 0),
('Westminster', 0),
('Berlin Sans FB', 0),
('BalloonEFDropShadow', 0),
('Tempus Sans ITC', 0),
('Pussycat', 0),
('Script MT Bold', 0),
('Calibri', 0),
('Ravie', 0),
('Open Sans', 0);


CREATE TABLE `bwb_head` (
  `id` int(11) NOT NULL auto_increment,
  `head_name` varchar(255) default NULL,
  `head_content` longtext,
  `plugins` VARCHAR(64) NULL,
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_head` (`id`, `head_name`, `head_content`, `revised`) VALUES
(1, 'head', '<STYLE TYPE=\\"text/css\\">\r\n.pagebreak { page-break-after: always;}\r\n</STYLE>\r\n\r\n', '0000-00-00 00:00:00');


CREATE TABLE IF NOT EXISTS `bwb_login_attempts` (
  `id` bigint(20) NOT NULL auto_increment,
  `UserID` varchar(50) NOT NULL,
  `IP` varchar(32) NOT NULL,
  `AttemptTimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Success` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_menus` (
  `menu_name` varchar(64) NOT NULL,
  `description` varchar(255) default NULL,
  `proportional` tinyint(4) NOT NULL default '0',
  `proportional_sub` tinyint(4) NOT NULL default '0',
  `menu_type` INT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`menu_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menus` (`menu_name`, `description`, `proportional`, `proportional_sub`, `menu_type`) VALUES
('menu1', 'CSS Menu 1', 0, 0, 0),
('menu2', 'JavaScript Menu 1', 0, 0, 1);


CREATE TABLE IF NOT EXISTS `bwb_menu_assignments` (
  `menu_name` varchar(64) NOT NULL,
  `border_area` varchar(64) NOT NULL,
  PRIMARY KEY  (`menu_name`,`border_area`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu1_classes` (
  `class` varchar(64) NOT NULL,
  `description` varchar(64) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  `subclass_sort_order` int(11) NOT NULL default '0',
  `custom` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menu1_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('.menu_div1', 'Menu Position', 150, 0, 0),
('.top_level_ul1', 'Top Level UL', 160, 0, 0),
('.top_level_li1', 'Top Level LI', 170, 0, 0),
('.top_level_li1 A:visited', 'Top Level LI Visited', 175, 0, 0),
('.top_level_li1 A:hover', 'Top Level LI Hover', 176, 0, 0),
('.top_level_li1 A:visited:hover', 'Top Level LI Visited:Hover', 177, 0, 0),
('.top_level_a1', 'Top Level A', 180, 0, 0),
('.top_level_a1 A:link', 'Top Level A Link', 190, 0, 0),
('.top_level_a1 A:hover', 'Top Level A Hover', 200, 0, 0),
('.top_level_a1 A:visited', 'Top Level A Visited', 210, 0, 0),
('.top_level_a1 A:active', 'Top Level A Active', 220, 0, 0),
('.sub_level_1_ul1', 'Sub Level 1 UL', 230, 0, 0),
('.sub_level_1_li1', 'Sub Level 1 LI', 240, 0, 0),
('.sub_level_1_li1 A:visited', 'Sub Level 1 LI Visited', 245, 0, 0),
('.sub_level_1_li1 A:hover', 'Sub Level 1 LI Hover', 246, 0, 0),
('.sub_level_1_li1 A:visited:hover', 'Sub Level 1 LI Visited:Hover', 247, 0, 0),
('.sub_level_1_a1', 'Sub Level 1 A', 250, 0, 0),
('.sub_level_1_a1 A:link', 'Sub Level 1 A Link', 260, 0, 0),
('.sub_level_1_a1 A:hover', 'Sub Level 1 A Hover', 270, 0, 0),
('.sub_level_1_a1 A:visited', 'Sub Level 1 A Visited', 280, 0, 0),
('.sub_level_1_a1 A:active', 'Sub Level 1 A Active', 290, 0, 0),
('.sub_level_2_ul1', 'Sub Level 2 UL', 300, 0, 0),
('.sub_level_2_li1', 'Sub Level 2 LI', 310, 0, 0),
('.sub_level_2_li1 A:visited', 'Sub Level 2 LI Visited', 315, 0, 0),
('.sub_level_2_li1 A:hover', 'Sub Level 2 LI Hover', 316, 0, 0),
('.sub_level_2_li1 A:visited:hover', 'Sub Level 2 LI Visited:Hover', 317, 0, 0),
('.sub_level_2_a1', 'Sub Level 2 A', 320, 0, 0),
('.sub_level_2_a1 A:link', 'Sub Level 2 A Link', 330, 0, 0),
('.sub_level_2_a1 A:hover', 'Sub Level 2 A Hover', 340, 0, 0),
('.sub_level_2_a1 A:visited', 'Sub Level 2 A Visited', 350, 0, 0),
('.sub_level_2_a1 A:active', 'Sub Level 2 A Active', 360, 0, 0),
('ul.nav1', 'Menu Font', 100, 0, 0),
('ul.nav1 li:hover, .nav1 ul li a:hover', 'Hover Attributes', 28, 0, 0),
('.nav1 a', 'URL Attributes', 110, 0, 0),
('ul.nav1, .nav1 ul', 'Menu Attributes, Horizontal On/Off  ', 10, 0, 0),
('ul.nav1>li', 'Top Level Item Size and Padding', 40, 0, 0),
('ul.nav1 li>ul', 'Sub Menu Size and Position', 50, 0, 0),
('ul.nav1 li:hover>ul', 'Show Sub Menu on Hover', 60, 0, 0),
('.nav1 ul li a', 'Sub Menu Padding', 70, 0, 0),
('ul.nav1 li:active, .nav1 ul li a:active', 'Active Attributes', 90, 0, 0),
('ul.nav1, .nav1 ul, .nav1 ul li a', 'Menu Attributes, Mouse Out', 80, 0, 0),
('.nav1 a:link', 'Link Attributes', 120, 0, 0),
('.nav1 a:visited', 'Link Visited Attributes', 130, 0, 0),
('.nav1 a:hover', 'Link Hover Attributes', 140, 0, 0),
('.top_level_li1 A', 'Top Level LI A', 370, 0, 0),
('.top_level_down1', 'Top Level Down State', 380, 0, 0),
('.sub_level_1_down1', 'Sub Level 1 Down State', 390, 0, 0),
('.sub_level_2_down1', 'Sub Level 2 Down State', 400, 0, 0);

INSERT INTO `bwb_menu1_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('.m0l0iout1', 'Top Level Mouse Out', -120, 0, 0),
('.m0l0iover1', 'Top Level Mouse Over', -110, 0, 0),
('.m0l0oout1', 'Top Level Background Mouse Out', -100, 0, 0),
('.m0l0oover1', 'Top Level Background Mouse Over', -90, 0, 0),
('.m0l1iout1', 'Sub Level 1 Mouse Out', -80, 0, 0),
('.m0l1iover1', 'Sub Level 1 Mouse Over', -70, 0, 0),
('.m0l1oout1', 'Sub Level 1 Background Mouse Out', -60, 0, 0),
('.m0l1oover1', 'Sub Level 1 Background Mouse Over', -50, 0, 0),
('.m0l2iout1', 'Sub Level 2 Mouse Out', -40, 0, 0),
('.m0l2iover1', 'Sub Level 2 Mouse Over', -30, 0, 0),
('.m0l2oout1', 'Sub Level 2 Background Mouse Out', -20, 0, 0),
('.m0l2oover1', 'Sub Level 2 Background Mouse Over', -10, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_menu2_classes` (
  `class` varchar(64) NOT NULL,
  `description` varchar(64) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  `subclass_sort_order` int(11) NOT NULL default '0',
  `custom` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menu2_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('.menu_div2', 'Menu Position', 150, 0, 0),
('.top_level_ul2', 'Top Level UL', 160, 0, 0),
('.top_level_li2', 'Top Level LI', 170, 0, 0),
('.top_level_li2 A:visited', 'Top Level LI Visited', 175, 0, 0),
('.top_level_li2 A:hover', 'Top Level LI Hover', 176, 0, 0),
('.top_level_li2 A:visited:hover', 'Top Level LI Visited:Hover', 177, 0, 0),
('.top_level_a2', 'Top Level A', 180, 0, 0),
('.top_level_a2 A:link', 'Top Level A Link', 190, 0, 0),
('.top_level_a2 A:hover', 'Top Level A Hover', 200, 0, 0),
('.top_level_a2 A:visited', 'Top Level A Visited', 210, 0, 0),
('.top_level_a2 A:active', 'Top Level A Active', 220, 0, 0),
('.sub_level_1_ul2', 'Sub Level 1 UL', 230, 0, 0),
('.sub_level_1_li2', 'Sub Level 1 LI', 240, 0, 0),
('.sub_level_1_li2 A:visited', 'Sub Level 1 LI Visited', 245, 0, 0),
('.sub_level_1_li2 A:hover', 'Sub Level 1 LI Hover', 246, 0, 0),
('.sub_level_1_li2 A:visited:hover', 'Sub Level 1 LI Visited:Hover', 247, 0, 0),
('.sub_level_1_a2', 'Sub Level 1 A', 250, 0, 0),
('.sub_level_1_a2 A:link', 'Sub Level 1 A Link', 260, 0, 0),
('.sub_level_1_a2 A:hover', 'Sub Level 1 A Hover', 270, 0, 0),
('.sub_level_1_a2 A:visited', 'Sub Level 1 A Visited', 280, 0, 0),
('.sub_level_1_a2 A:active', 'Sub Level 1 A Active', 290, 0, 0),
('.sub_level_2_ul2', 'Sub Level 2 UL', 300, 0, 0),
('.sub_level_2_li2', 'Sub Level 2 LI', 310, 0, 0),
('.sub_level_2_li2 A:visited', 'Sub Level 2 LI Visited', 315, 0, 0),
('.sub_level_2_li2 A:hover', 'Sub Level 2 LI Hover', 316, 0, 0),
('.sub_level_2_li2 A:visited:hover', 'Sub Level 2 LI Visited:Hover', 317, 0, 0),
('.sub_level_2_a2', 'Sub Level 2 A', 320, 0, 0),
('.sub_level_2_a2 A:link', 'Sub Level 2 A Link', 330, 0, 0),
('.sub_level_2_a2 A:hover', 'Sub Level 2 A Hover', 340, 0, 0),
('.sub_level_2_a2 A:visited', 'Sub Level 2 A Visited', 350, 0, 0),
('.sub_level_2_a2 A:active', 'Sub Level 2 A Active', 360, 0, 0),
('ul.nav2', 'Menu Font', 100, 0, 0),
('ul.nav2 li:hover, .nav1 ul li a:hover', 'Hover Attributes', 28, 0, 0),
('.nav2 a', 'URL Attributes', 110, 0, 0),
('ul.nav2, .nav1 ul', 'Menu Attributes, Horizontal On/Off  ', 10, 0, 0),
('ul.nav2>li', 'Top Level Item Size and Padding', 40, 0, 0),
('ul.nav2 li>ul', 'Sub Menu Size and Position', 50, 0, 0),
('ul.nav2 li:hover>ul', 'Show Sub Menu on Hover', 60, 0, 0),
('.nav2 ul li a', 'Sub Menu Padding', 70, 0, 0),
('ul.nav2 li:active, .nav1 ul li a:active', 'Active Attributes', 90, 0, 0),
('ul.nav2, .nav1 ul, .nav1 ul li a', 'Menu Attributes, Mouse Out', 80, 0, 0),
('.nav2 a:link', 'Link Attributes', 120, 0, 0),
('.nav2 a:visited', 'Link Visited Attributes', 130, 0, 0),
('.nav2 a:hover', 'Link Hover Attributes', 140, 0, 0),
('.top_level_li2 A', 'Top Level LI A', 370, 0, 0),
('.top_level_down2', 'Top Level Down State', 380, 0, 0),
('.sub_level_1_down2', 'Sub Level 1 Down State', 390, 0, 0),
('.sub_level_2_down2', 'Sub Level 2 Down State', 400, 0, 0);

INSERT INTO `bwb_menu2_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('.m0l0iout2', 'Top Level Mouse Out', -120, 0, 0),
('.m0l0iover2', 'Top Level Mouse Over', -110, 0, 0),
('.m0l0oout2', 'Top Level Background Mouse Out', -100, 0, 0),
('.m0l0oover2', 'Top Level Background Mouse Over', -90, 0, 0),
('.m0l1iout2', 'Sub Level 1 Mouse Out', -80, 0, 0),
('.m0l1iover2', 'Sub Level 1 Mouse Over', -70, 0, 0),
('.m0l1oout2', 'Sub Level 1 Background Mouse Out', -60, 0, 0),
('.m0l1oover2', 'Sub Level 1 Background Mouse Over', -50, 0, 0),
('.m0l2iout2', 'Sub Level 2 Mouse Out', -40, 0, 0),
('.m0l2iover2', 'Sub Level 2 Mouse Over', -30, 0, 0),
('.m0l2oout2', 'Sub Level 2 Background Mouse Out', -20, 0, 0),
('.m0l2oover2', 'Sub Level 2 Background Mouse Over', -10, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_menu1_css` (
  `class` varchar(64) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu2_css` (
  `class` varchar(64) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu1_item_classes` (
  `class` varchar(64) NOT NULL,
  `description` varchar(64) default NULL,
  `sort_order` int(11) default NULL,
  `subclass_sort_order` int(11) default NULL,
  `custom` tinyint(4) default NULL,
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu2_item_classes` (
  `class` varchar(64) NOT NULL,
  `description` varchar(64) default NULL,
  `sort_order` int(11) default NULL,
  `subclass_sort_order` int(11) default NULL,
  `custom` tinyint(4) default NULL,
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu1_item_css` (
  `class` varchar(64) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_menu2_item_css` (
  `class` varchar(64) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE `bwb_menu1_items` (
  `ID` int(11) NOT NULL auto_increment,
  `item_text` varchar(64) NOT NULL default '',
  `level` int(11) default NULL,
  `URL` varchar(255) default NULL,
  `target` varchar(32) default NULL,
  `name` VARCHAR( 64 ) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
)  AUTO_INCREMENT=1 ;

CREATE TABLE `bwb_menu2_items` (
  `ID` int(11) NOT NULL auto_increment,
  `item_text` varchar(64) NOT NULL default '',
  `level` int(11) default NULL,
  `URL` varchar(255) default NULL,
  `target` varchar(32) default NULL,
  `name` VARCHAR( 64 ) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_menu_items_preview` (
  `ID` int(11) NOT NULL auto_increment,
  `item_text` varchar(64) NOT NULL default '',
  `level` int(11) default NULL,
  `URL` varchar(255) default NULL,
  `target` varchar(32) default NULL,
  `name` VARCHAR( 64 ) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_menu_params` (
  `menu_name` varchar(64) NOT NULL,
  `main_item_height` int(11) NOT NULL default '0',
  `main_item_width` int(11) NOT NULL default '0',
  `origin_top` int(11) NOT NULL default '0',
  `origin_left` int(11) NOT NULL default '0',
  `sub_menu_origin_top` int(11) NOT NULL default '0',
  `sub_menu_origin_left` int(11) NOT NULL default '0',
  `main_item_top_offset` int(11) NOT NULL default '0',
  `main_item_left_offset` int(11) NOT NULL default '0',
  `sub_item_top_offset` int(11) NOT NULL default '0',
  `sub_item_left_offset` int(11) NOT NULL default '0',
  `sub_item_width` int(11) NOT NULL default '0',
  `sub_item_height` int(11) NOT NULL default '0',
  `sub_left_offset_from_main` int(11) NOT NULL default '0',
  `hide_delay` int(11) NOT NULL default '0',
  `proportional_width` tinyint(4) NOT NULL default '0',
  `proportional_sub_width` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`menu_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_menu_params` (`menu_name`, `main_item_height`, `main_item_width`, `origin_top`, `origin_left`, `sub_menu_origin_top`, `sub_menu_origin_left`, `main_item_top_offset`, `main_item_left_offset`, `sub_item_top_offset`, `sub_item_left_offset`, `sub_item_width`, `sub_item_height`, `sub_left_offset_from_main`, `hide_delay`, `proportional_width`, `proportional_sub_width`) VALUES
('menu', 20, 90, 200, 28, 18, 10, 0, 90, 20, 0, 110, 20, 30, 200, 0, 0);


CREATE TABLE IF NOT EXISTS `bwb_menu_styles_preview` (
  `class` varchar(64) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `font_stretch` varchar(32) default NULL,
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE `bwb_meta_tags` (
  `page_name` varchar(255) NOT NULL default '',
  `owner` varchar(255) default NULL,
  `author` varchar(255) default NULL,
  `lanquage` varchar(255) default NULL,
  `copyright` varchar(255) default NULL,
  `description` longtext,
  `abstract` longtext,
  `keywords` longtext,
  `subject` longtext,
  `robots_index` tinyint(4) default NULL,
  `robots_follow` tinyint(4) default NULL,
  `robots_revisit` int(11) default NULL,
  PRIMARY KEY  (`page_name`)
) ;

CREATE TABLE `bwb_meta_tags_template` (
  `id` int(11) NOT NULL auto_increment,
  `meta_tags_template` longtext NOT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

INSERT INTO `bwb_meta_tags_template` (`id`, `meta_tags_template`) VALUES
(1, '<?php\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "meta_tags WHERE page_name = ''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$owner = $row["owner"];\r\n		$author = $row["author"];\r\n		$lanquage = $row["lanquage"];\r\n		$copyright = $row["copyright"];\r\n		$description = $row["description"];\r\n		$abstract = $row["abstract"];\r\n		$keywords = $row["keywords"];\r\n		$subject = $row["subject"];\r\n		$robots_index = $row["robots_index"];\r\n		$robots_follow = $row["robots_follow"];\r\n		$robots_revisit = $row["robots_revisit"];\r\n		\r\n		if ($lanquage)\r\n			echo "<META HTTP-EQUIV=\\"LANGUAGE\\" CONTENT=\\"$lanquage\\">\\r\\n";\r\n		if ($owner)\r\n			echo "<meta name=\\"OWNER\\" content=\\"$owner\\">\\r\\n";\r\n		if ($author)\r\n			echo "<META NAME=\\"AUTHOR\\" CONTENT=\\"$author\\">\\r\\n";\r\n			\r\n		if (($robots_index == 1) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 1) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"INDEX, NOFOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 1))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, FOLLOW\\">\\r\\n";\r\n		elseif (($robots_index == 0) && ($robots_follow == 0))\r\n			echo "<META NAME=\\"ROBOTS\\" CONTENT=\\"NOINDEX, NOFOLLOW\\">\\r\\n";\r\n	\r\n		if ($robots_revisit)\r\n			echo "<META NAME=\\"REVISIT-AFTER\\" CONTENT=\\"$robots_revisit days\\">\\r\\n";\r\n		if ($copyright)\r\n			echo "<META NAME=\\"COPYRIGHT\\" CONTENT=\\"$copyright\\">\\r\\n";\r\n		if ($description)\r\n			echo "<META NAME=\\"DESCRIPTION\\" CONTENT=\\"$description\\">\\r\\n";\r\n		if ($abstract)\r\n			echo "<META NAME=\\"ABSTACT\\" CONTENT=\\"$abstract\\">\\r\\n";\r\n		if ($keywords)\r\n			echo "<META NAME=\\"KEYWORDS\\" CONTENT=\\"$keywords\\">\\r\\n";\r\n		if ($subject)\r\n			echo "<META NAME=\\"SUBJECT\\" CONTENT=\\"$subject\\">\\r\\n";\r\n\r\n	}\r\n?>');



CREATE TABLE IF NOT EXISTS `bwb_options` (
  `id` int(11) NOT NULL auto_increment,
  `option_name` varchar(63) NOT NULL default '',
  `option_string` varchar(255) NOT NULL default '',
  `option_value` varchar(63) NOT NULL default '',
  `option_image` varchar(255) default NULL,
  `data_type` int(11) NOT NULL default '0',
  `sort_order` int(11) NOT NULL default '0',
  `dropdown_sort_order` int(11) NOT NULL default '0',
  `refresh_main` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_options` (`id`, `option_name`, `option_string`, `option_value`, `option_image`, `data_type`, `sort_order`, `dropdown_sort_order`, `refresh_main`) VALUES
(3, 'Template', 'Template', 'top_bottom_left_right', 'top_bottom_left_right.jpg', 0, 5, 5, 0),
(4, 'Template', 'Template', 'top_left_right', 'top_left_right.jpg', 0, 5, 25, 0),
(5, 'Template', 'Template', 'top', 'top.jpg', 0, 5, 40, 0),
(6, 'Template', 'Template', 'top_left', 'top_left.jpg', 0, 5, 35, 0),
(7, 'Template', 'Template', 'basic', 'basic.jpg', 0, 5, 50, 0),
(8, 'Template', 'Template', 'top_bottom', 'top_bottom.jpg', 0, 5, 30, 0),
(9, 'Template', 'Template', 'left', 'left.jpg', 0, 5, 45, 0),
(10, 'Template', 'Template', 'top_bottom_left', 'top_bottom_left.jpg', 0, 5, 20, 0),
(11, 'Template', 'Template', 'top_bottom_left_right_alt', 'top_bottom_left_right_alt.jpg', 0, 5, 10, 0),
(21, 'Template', 'Template', 'top_bottom_left_right_alt2', 'top_bottom_left_right_alt2.jpg', 0, 5, 15, 0),
(24, 'ForcePageNameToLowerCase', 'Force Page Name To Lower Case', '0', NULL, 2, 50, 0, 0),
(26, 'EnableWizard', 'Enable Wizard', '1', NULL, 2, 20, 0, 1),
(28, 'RunWizardLocal', 'Run Wizard Local (Check only if template repository and Breeze installation are on same server.)', '0', NULL, 2, 20, 0, 1),
(29, 'EnableFileManager', 'Enable File Manager for Restricted Users', '0', NULL, 2, 30, 0, 0),
(30, 'ActivateNewUsersAutomatically', 'Activate New Users Automatically', '0', NULL, 2, 40, 0, 0),
(32, 'UseTableStructure', 'Use Table Structure', '1', NULL, 2, 10, 0, 0),
(33, 'UseTableStructureMobile', 'Use Table Structure on Mobile', '0', NULL, 2, 15, 0, 0),
(34, 'CreateAcctLinkTxt', 'Create Account Link Text', 'Create Account', NULL, 1, 100, 0, 0),
(35, 'LoginLinkTxt', 'Login Link Text', 'Login', NULL, 1, 110, 0, 0),
(36, 'MyAcctLinkTxt', 'My Account Link Text', 'My Account', NULL, 1, 120, 0, 0),
(37, 'LogoutLinkTxt', 'Logout Link Text', 'Logout', NULL, 1, 130, 0, 0),
(38, 'CreateAcctLink', 'Create Account Link', 'create_account.php', NULL, 1, 140, 0, 0),
(39, 'LoginLink', 'Login Link', 'login.php', NULL, 1, 150, 0, 0),
(40, 'MyAcctLink', 'My Account Link', 'my_account.php', NULL, 1, 160, 0, 0),
(42, 'LogoutRedirectOverride', 'Logout Redirect Override', '', NULL, 1, 135, 0, 0),
(45, 'CodeMirrorTheme', 'Editor Source View Theme', 'default', 'default.jpg', 0, 160, 10, 0),
(46, 'CodeMirrorTheme', 'Editor Source View Theme', '3024-day', '3024-day.jpg', 0, 170, 20, 0),
(47, 'CodeMirrorTheme', 'Editor Source View Theme', '3024-night', '3024-night.jpg', 0, 170, 20, 0),
(48, 'CodeMirrorTheme', 'Editor Source View Theme', 'ambiance', 'ambiance.jpg', 0, 180, 30, 0),
(49, 'CodeMirrorTheme', 'Editor Source View Theme', 'base16-dark', 'base16-dark.jpg', 0, 190, 40, 0),
(50, 'CodeMirrorTheme', 'Editor Source View Theme', 'base16-light', 'base16-light.jpg', 0, 200, 50, 0),
(51, 'CodeMirrorTheme', 'Editor Source View Theme', 'blackboard', 'blackboard.jpg', 0, 210, 60, 0),
(52, 'CodeMirrorTheme', 'Editor Source View Theme', 'cobalt', 'cobalt.jpg', 0, 220, 70, 0),
(53, 'CodeMirrorTheme', 'Editor Source View Theme', 'eclipse', 'eclipse.jpg', 0, 230, 80, 0),
(54, 'CodeMirrorTheme', 'Editor Source View Theme', 'elegant', 'elegant.jpg', 0, 240, 90, 0),
(55, 'CodeMirrorTheme', 'Editor Source View Theme', 'erlang-dark', 'erlang-dark.jpg', 0, 250, 100, 0),
(56, 'CodeMirrorTheme', 'Editor Source View Theme', 'lesser-dark', 'lesser-dark.jpg', 0, 270, 110, 0),
(57, 'CodeMirrorTheme', 'Editor Source View Theme', 'mbo', 'mbo.jpg', 0, 280, 120, 0),
(58, 'CodeMirrorTheme', 'Editor Source View Theme', 'mdn-like', 'mdn-like.jpg', 0, 290, 130, 0),
(59, 'CodeMirrorTheme', 'Editor Source View Theme', 'midnight', 'midnight.jpg', 0, 300, 140, 0),
(60, 'CodeMirrorTheme', 'Editor Source View Theme', 'monokai', 'monokai.jpg', 0, 310, 150, 0),
(61, 'CodeMirrorTheme', 'Editor Source View Theme', 'neat', 'neat.jpg', 0, 320, 160, 0),
(62, 'CodeMirrorTheme', 'Editor Source View Theme', 'neo', 'neo.jpg', 0, 330, 170, 0),
(63, 'CodeMirrorTheme', 'Editor Source View Theme', 'night', 'night.jpg', 0, 340, 180, 0),
(64, 'CodeMirrorTheme', 'Editor Source View Theme', 'paraiso-dark', 'paraiso-dark.jpg', 0, 350, 190, 0),
(65, 'CodeMirrorTheme', 'Editor Source View Theme', 'paraiso-light', 'paraiso-light.jpg', 0, 360, 200, 0),
(66, 'CodeMirrorTheme', 'Editor Source View Theme', 'pastel-on-dark', 'pastel-on-dark.jpg', 0, 370, 210, 0),
(67, 'CodeMirrorTheme', 'Editor Source View Theme', 'rubyblue', 'rubyblue.jpg', 0, 380, 220, 0),
(68, 'CodeMirrorTheme', 'Editor Source View Theme', 'solarized dark', 'solarized-dark.jpg', 0, 390, 230, 0),
(69, 'CodeMirrorTheme', 'Editor Source View Theme', 'solarized light', 'solarized-light.jpg', 0, 400, 240, 0),
(70, 'CodeMirrorTheme', 'Editor Source View Theme', 'the-matrix', 'the-matrix.jpg', 0, 410, 250, 0),
(71, 'CodeMirrorTheme', 'Editor Source View Theme', 'tomorrow-night-bright', 'tomorrow-night-bright.jpg', 0, 420, 260, 0),
(72, 'CodeMirrorTheme', 'Editor Source View Theme', 'tomorrow-night-eighties', 'tomorrow-night-eighties.jpg', 0, 430, 270, 0),
(73, 'CodeMirrorTheme', 'Editor Source View Theme', 'twilight', 'twilight.jpg', 0, 440, 280, 0),
(74, 'CodeMirrorTheme', 'Editor Source View Theme', 'vibrant-ink', 'vibrant-ink.jpg', 0, 450, 290, 0),
(75, 'CodeMirrorTheme', 'Editor Source View Theme', 'xq-dark', 'xq-dark.jpg', 0, 460, 300, 0),
(76, 'CodeMirrorTheme', 'Editor Source View Theme', 'xq-light', 'xq-light.jpg', 0, 470, 310, 0),
(77, 'CodeMirrorTheme', 'Editor Source View Theme', 'zenburn', 'zenburn.jpg', 0, 480, 320, 0);


CREATE TABLE `bwb_options_selected` (
  `option_name` varchar(63) NOT NULL default '0',
  `option_value` varchar(63) default NULL,
  PRIMARY KEY  (`option_name`)
) ;

INSERT INTO `bwb_options_selected` (`option_name`, `option_value`) VALUES
('EnableWizard', '1'),
('EnableFileManager', '0'),
('CreateAcctLinkTxt', 'Create Account'),
('CreateAcctLink', 'create_account.php'),
('ActivateNewUsersAutomatically', '0'),
('ForcePageNameToLowerCase', '1'),
('LoginLink', 'login.php'),
('LoginLinkTxt', 'Login'),
('LogoutLinkTxt', 'Logout'),
('MyAcctLink', 'my_account.php'),
('MyAcctLinkTxt', 'My Account'),
('RunWizardLocal', '0'),
('Template', 'top_bottom_left_right'),
('UseTableStructure', '1'),
('UseTableStructureMobile', '0'),
('LogoutRedirectOverride', ''),
('CodeMirrorTheme', 'rubyblue');


CREATE TABLE `bwb_page_cache` (
  `id` int(11) NOT NULL default '0',
  `tmp_page_data` longtext,
  PRIMARY KEY  (`id`)
) ;


CREATE TABLE `bwb_page_data` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `use_table_structure` TINYINT NOT NULL DEFAULT '0',
  `use_table_structure_mobile` TINYINT NOT NULL DEFAULT '0',
  `restricted` TINYINT NOT NULL DEFAULT '0',
  `login_required` TINYINT NOT NULL DEFAULT '0',
  `user_table` VARCHAR(64) NULL,
  `AccessLevel` VARCHAR(64) NULL,
  `login_page` VARCHAR(255) NULL,
  `show_login_links` TINYINT NOT NULL DEFAULT '0',
  `plugins` VARCHAR(64) NULL,
  `disable_site_styles` TINYINT NOT NULL DEFAULT '0',
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_page_data_bkup` (
  `ID` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `revised` DATETIME NULL DEFAULT NULL,
  `deleted` DATETIME NULL DEFAULT NULL,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;


CREATE TABLE `bwb_page_data_special` (
  `id` int(11) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `plugins` VARCHAR(64) NULL,
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `revised` DATETIME NULL DEFAULT NULL,
  PRIMARY KEY  (`id`)
)  AUTO_INCREMENT=1 ;

CREATE TABLE IF NOT EXISTS `bwb_page_data_draft` (
  `id` bigint(20) NOT NULL auto_increment,
  `page_name` varchar(255) default NULL,
  `page_content` longtext,
  `revised` datetime default NULL,
  `source` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

INSERT INTO `bwb_page_data_special` (`id`, `page_name`, `page_content`) VALUES (1, 'top', 'Top'),
 (2, 'bottom', 'Bottom'),
 (3, 'left', 'Left'),
 (4, 'right', 'Right'),
 (5, 'header', ''),
 (6, 'footer', '');


CREATE TABLE `bwb_page_titles` (
  `page_name` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`page_name`)
) ;


CREATE TABLE IF NOT EXISTS `bwb_plugins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `category` VARCHAR(255) DEFAULT NULL,
  `style_sheet` varchar(64) DEFAULT NULL,
  `style_sheet_description` varchar(255) DEFAULT NULL,
  `class_sql` longtext,
  `css_sql` longtext,
  `head_code` longtext,
  `head_html` longtext,
  `header_code` longtext,
  `header_html` longtext,
  `top_code` longtext,
  `top_html` longtext,
  `left_code` longtext,
  `left_html` longtext,
  `content_code` longtext,
  `content_html` longtext,
  `right_code` longtext,
  `right_html` longtext,
  `bottom_code` longtext,
  `bottom_html` longtext,
  `footer_code` longtext,
  `footer_html` longtext,
  `console_path` varchar(255) DEFAULT NULL,
  `console_link_text` varchar(128) DEFAULT NULL,
  `console_link_image` varchar(255) DEFAULT NULL,
  `console_link_image_mo` varchar(255) DEFAULT NULL,
  `console_link_image_down` varchar(255) DEFAULT NULL,
  `help_path` varchar(255) DEFAULT NULL,
  `plugin_sql` longtext,
  `AccessLevel` varchar(20) DEFAULT NULL,
  `deployed` tinyint(4) NOT NULL DEFAULT '0',
  `available` tinyint(4) NOT NULL DEFAULT '1',
  `disable_site_styles` tinyint(4) NOT NULL DEFAULT '0',
  `sort_order` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=30 ;

INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(1, 'Events Grid', 'Table of events from top oldest to bottom newest.', 'Calendars and Events', 'calendar', 'Calendar and Event Styles', 'INSERT INTO `bwb_calendar_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.events_div'', ''Surrounding Event Grid Div'', 10, 0, 0),\r\n(''.events_table'', ''Event Table'', 20, 0, 0),\r\n(''.events_tr_head'', ''Event Grid Header Row'', 30, 0, 0),\r\n(''.events_td_head'', ''Event Grid Header Cells'', 40, 0, 0),\r\n(''.events_tr'', ''Event Grid Rows'', 50, 0, 0),\r\n(''.events_td'', ''Event Grid Cells'', 60, 0, 0),\r\n(''.calendar_div'', ''Surrounding Calendar Grid Div'', 70, 0, 0),\r\n(''.calendar_table'', ''Calendar Grid Table'', 80, 0, 0),\r\n(''.calendar_tr_head'', ''Calendar Grid Month Header Row'', 90, 0, 0),\r\n(''.calendar_td_head'', ''Calendar Grid Month Header Cells'', 100, 0, 0),\r\n(''.calendar_tr_head2'', ''Calendar Grid Days Header Row'', 110, 0, 0),\r\n(''.calendar_td_head2'', ''Calendar Grid Days Header Cells'', 120, 0, 0),\r\n(''.calendar_tr'', ''Calendar Grid Rows'', 130, 0, 0),\r\n(''.calendar_td'', ''Calendar Grid Cells'', 140, 0, 0),\r\n(''.calendar_td_head a'', ''Calendar Grid Month Header Cells A'', 150, 0, 0),\r\n(''.calendar_td_head a:link'', ''Calendar Grid Month Header Cells A:Link'', 160, 0, 0),\r\n(''.calendar_td_head a:hover'', ''Calendar Grid Month Header Cells A:Hover'', 170, 0, 0),\r\n(''.calendar_td_head a:visited'', ''Calendar Grid Month Header Cells A:Visited'', 180, 0, 0),\r\n(''.calendar_td a'', ''Calendar Grid Cells A'', 190, 0, 0),\r\n(''.calendar_td a:link'', ''Calendar Grid Cells A:Link'', 200, 0, 0),\r\n(''.calendar_td a:hover'', ''Calendar Grid Cells A:Hover'', 210, 0, 0),\r\n(''.calendar_td a:visited'', ''Calendar Grid Cells A:Visited'', 220, 0, 0),\r\n(''.events_td a'', ''Event Grid Cells A'', 61, 0, 0),\r\n(''.events_td a:link'', ''Event Grid Cells A:Link'', 62, 0, 0),\r\n(''.events_td a:hover'', ''Event Grid Cells A:Hover'', 63, 0, 0),\r\n(''.events_td a:visited'', ''Event Grid Cells A:Visited'', 64, 0, 0),\r\n(''.calendar_hebrew'', ''Calendar Hebrew Text'', 240, 0, 0),\r\n(''.calendar_hebrew_header'', ''Calendar Hebrew Header Text'', 230, 0, 0);', 'INSERT INTO `bwb_calendar_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.events_tr_head'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#3e51b7'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_tr_head'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#3e51b7'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#CDCCF4'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_tr_head2'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#CDCCF4'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFDDDD'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_hebrew'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000088'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_hebrew_header'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFF00'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#8900F2'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head2'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#B49CFC'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#8900F2'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n///////////// Schedule Code ///////////////////////////////////////////\r\n// Breeze Website Builder\r\n// Copyright: Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.\r\n// Last revised: 6/15/2007\r\n// Revised: 9/10/2008  Added active flag.	ELL\r\n// Revised: 8/1/2009  ELL\r\n// Added class hooks for styling.\r\n// Revised: 3/25/2010	ELL\r\n// Combined standard and hebrew calendars into one.  Setting show_hebrew = 1 causes calendar to show Hebrew dates.\r\n// Revised: 9/1/2010	ELL\r\n// Added show_past switch to show or hide past dates.  Past dates will now be hidden by default.  Set show_past=1 to override default.\r\n// Revised: 2/6/2012	ELL\r\n// Added table prefix option.\r\n// Revised: 7/6/2012	ELL\r\n// Added filtering by users and groups.\r\n// Revised: 4/24/2014	ELL\r\n// Added ability to set target for event URL.\r\n//\r\n	\r\n	$show_hebrew = $_REQUEST[''show_hebrew''];\r\n	if (!isset($show_hebrew)) $show_hebrew = 0;\r\n	$show_past = $_REQUEST[''show_past''];\r\n	if (!isset($show_past)) $show_past = 0;\r\n	$events_user_table = $_REQUEST[''user_table''];\r\n	$events_UserID = $_REQUEST[''UserID''];\r\n	$events_AccessLevel = $_REQUEST[''AccessLevel''];\r\n	$use_logged_in_credentials = $_REQUEST[''use_logged_in_credentials''];\r\n	if ($_REQUEST[''descending''])\r\n		$descending = "DESC";\r\n	\r\n	$where = " WHERE (`Active` = 1)";\r\n	$today = date("Y-m-d");\r\n	if ($show_past != 1)\r\n		$where .= " AND (EventDateSort >= ''$today'')";\r\n	\r\n	if ($use_logged_in_credentials)\r\n	{\r\n		if ($events_user_table)\r\n			$where .= " AND (user_table = ''$user_table'')";\r\n		if ($events_UserID)\r\n			$where .= " AND (UserID = ''$UserID'')";\r\n		if ($events_AccessLevel)\r\n			$where .= " AND (AccessLevel = ''$AccessLevel'')";\r\n	}\r\n	else\r\n	{\r\n		if (($events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND ((user_table = ''$events_user_table'') AND ((UserID = ''$events_UserID'') OR (AccessLevel = ''$events_AccessLevel'')))";\r\n		elseif (($events_user_table) && (!$events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'')";\r\n		elseif ((!$events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (UserID = ''$events_UserID'')";\r\n		elseif ((!$events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND (AccessLevel = ''$events_AccessLevel'')";\r\n		elseif (($events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'') AND (UserID = ''$events_UserID'')";\r\n		elseif (($events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'') AND (AccessLevel = ''$events_AccessLevel'')";\r\n		elseif ((!$events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND ((UserID = ''$events_UserID'') OR (AccessLevel = ''$events_AccessLevel''))";\r\n	}\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "schedule" . $where . " ORDER BY `EventDateSort`";\r\n	if ($descending) $query .= " $descending";\r\n	\r\n	$result = $bwb_dbh->query($query);\r\n	$num_results = $result->rowCount();\r\n	echo "<div align=''center'' class=''events_div''>\\n";\r\n	echo "<table class=''events_table''>\\n";\r\n	echo "<tr bgcolor=''#CCCCCC'' class=''events_tr_head''>\\n";\r\n	echo "<td class=''events_td_head''><b>Description</b></td>\\n";\r\n	echo "<td class=''events_td_head''><b>Date</b></td>\\n";\r\n	echo "<td class=''events_td_head''><b>Start Time</b></td>\\n";\r\n	echo "<td class=''events_td_head''><b>End Time</b></td>\\n";\r\n	if ($show_hebrew == 1)\r\n		echo "<td class=''events_td_head''><b>Hebrew Date</b></td>\\n";\r\n	echo "</tr>\\n";\r\n	for ($i = 0; $i < $num_results; $i++)\r\n	{\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	\r\n		$Description = $row["Description"];\r\n		$EventDate = $row["EventDate"];\r\n		$StartTime = $row["StartTime"];\r\n		$EndTime = $row["EndTime"];\r\n		$URL = $row["URL"];\r\n		$target = $row["target"];\r\n		$Description = stripslashes($Description);\r\n		$EventDate = stripslashes($EventDate);\r\n		$StartTime = stripslashes($StartTime);\r\n		$EndTime = stripslashes($EndTime);\r\n		$URL = stripslashes($URL);\r\n		$target = stripslashes($target);\r\n		\r\n		if ($show_hebrew == 1)\r\n		{\r\n			list($month, $day, $year) = split(''[/.-]'', $EventDate);\r\n			// Get Jewish date\r\n			$julian_date = gregoriantojd($month, $day, $year);\r\n			$jewishdate = jdtojewish($julian_date);\r\n			// Find the Jewish calendar date and parse out the day and year values\r\n			list ($jc_month, $jc_day, $jc_year) = explode (''/'', $jewishdate);\r\n			// Find the Jewish calendar month name\r\n			$jc_month = jdmonthname ($julian_date, 4);\r\n			$HebrewDate = "$jc_day $jc_month";\r\n		}\r\n		\r\n		if ($bgclr == "#DDDDDD")\r\n			$bgclr = "#EEEEEE";\r\n		else\r\n			$bgclr = "#DDDDDD";\r\n		\r\n		echo "<tr bgcolor=''$bgclr'' class=''events_tr''>\\n";\r\n		if ($URL)\r\n			echo "<td valign=''top'' class=''events_td''><a href=''$URL'' target=''$target''>$Description</a></td>\\n";\r\n		else\r\n			echo "<td valign=''top'' class=''events_td''>$Description</td>\\n";\r\n			\r\n		echo "<td valign=''top'' class=''events_td''>$EventDate</td>\\n";\r\n		echo "<td valign=''top'' class=''events_td''>$StartTime</td>\\n";\r\n		echo "<td valign=''top'' class=''events_td''>$EndTime</td>\\n";\r\n		if ($show_hebrew == 1)\r\n			echo "<td valign=''top'' class=''events_td''>$HebrewDate</td>\\n";\r\n		echo "</tr>\\n";\r\n	}\r\n	echo "</table>\\n";\r\n	echo "</div>\\n";\r\n	/////////////////////////////////////////////////////////////////////////\r\n?>', '<span style="color: rgb(255, 0, 0);">{*** delete *** \r\n<p>The events grid is not edited here. To add events to the events grid, go back to the main menu and click the <b><em>Revise Schedule</em></b> button.  The change the look and colors of your events grid, Click the <b><em>Edit Styles</em></b> button and select <b><em>Calendar and Event Styles</em></b>.</p>\r\n</span>\r\n<p><span style="color: rgb(255, 0, 0);">You can pass parameters in the URL to this page to control certain aspects of this events grid. For instance, sending <strong>show_past=1</strong> will cause the events grid to show dates that are in the past. By default, only events on this day or later will be displayed. As an extra bonus, you can also display Hebrew dates by sending <strong>show_hebrew=1</strong>.</span></p>\r\n<span style="color: rgb(255, 0, 0);">\r\n\r\n<p>You may also setup events to be private to a single user or to a group. To do that, add the following parameters to your URL:<strong> user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong>. You may also add <strong>use_logged_in_credentials</strong> to your URL and set its value to <strong>1</strong>. If you send <strong>use_logged_in_credentials</strong>, then the variabless <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> which of the credentials are used from the logged-in session to filter the events using and <strong>AND</strong> comparator. i.e. if <strong>user_table</strong> and <strong>UserID</strong> are set, then all events with the user <strong>UserID</strong> from the table <strong>user_table</strong> will be selected, but <u>not</u> the same <strong>UserID</strong> from <u>another</u> <strong>user_table</strong>. The formula for this is:</p>\r\n</span>\r\n<p><span style="color: rgb(255, 0, 0);">(<strong>user_table</strong>) AND (<strong>UserID)</strong> AND (<strong>AccessLevel</strong>) where any one or two of these variables may be ommitted.</span></p>\r\n<span style="color: rgb(255, 0, 0);">\r\n<p>An example of a  complete URL might be:</p>\r\n</span>\r\n<p><span style="color: rgb(255, 0, 0);">events.php?show_past=1&amp;user_table=1&amp;AccessLevel=1&amp;UserID=1</span></p>\r\n\r\n<p><span style="color: rgb(255, 0, 0);">If <strong>use_logged_in_credentials</strong> is not set, then <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are handled in a different manner. Instead, the values passed in these variables are to be used explicitly, and not those of any logged in session. They are also combined somewhat differently. i.e., if all three variables <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then all events assigned to users of user ID <strong>UserID</strong>, and all users of access level <strong>AccessLevel</strong> from and only from the user table user_table will be shown. If only <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then events assigned to user <strong>UserID</strong>, or with access level <strong>AccessLevel</strong> will be selected reguardless of which user table they may be in. The  formula is:</span></p><span style="color: rgb(255, 0, 0);">\r\n<p> (<strong>user_table</strong>) AND ((<strong>UserID</strong> OR (<strong>AccessLevel</strong>)) where any one or two of these variables may be ommitted.</p>\r\n<p>If for some reason you desire to display your events grid from lastest at the to to oldest at the bottom, simple add<strong> descending=1</strong> to your URL. An example of a complete URL might be:</p>\r\n<p>events.php?user_table=accounts_form&amp;AccessLevel=user&amp;UserID=Joe&amp;descending=1</p>\r\n\r\n*** delete *** }</span>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/edit_schedule.php', 'Revise Schedule', 'images/icon_Edit-Events.png', 'images/icon_Edit-Events_mo.png', 'images/icon_Edit-Events_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#events_grid', NULL, 'user', 0, 1, 0, 10),
(12, 'MP3 Audio Player, Standard', 'Premiumbeat music player, for single of multiple tracks', 'Audio', NULL, NULL, NULL, NULL, '<?php\r\n	echo "<script language=\\"JavaScript\\" type=\\"text/JavaScript\\">\\n";\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$scripts_dir = "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir = "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_BASE_DIR ."/" . BWB_CSS_DIR . "/";\r\n	}\r\n	\r\n	if (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$scripts_dir_rel = BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir_rel = "../" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = "../" . BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = "../" . BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = "../" .BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = "../" . BWB_CSS_DIR . "/";\r\n	}\r\n		\r\n	echo "	var scripts_dir = ''" . $scripts_dir . "'';\\n";\r\n	echo "	var flash_dir = ''" . $flash_dir . "'';\\n";\r\n	echo "	var media_dir = ''" . $media_dir . "'';\\n";\r\n	echo "	var image_dir = ''" . $image_dir . "'';\\n";\r\n	echo "	var css_dir = ''" . $css_dir . "'';\\n";\r\n	\r\n	echo "	var scripts_dir_rel = ''" . $scripts_dir_rel . "'';\\n";\r\n	echo "	var flash_dir_rel = ''" . $flash_dir_rel . "'';\\n";\r\n	echo "	var media_dir_rel = ''" . $media_dir_rel . "'';\\n";\r\n	echo "	var image_dir_rel = ''" . $image_dir_rel . "'';\\n";\r\n	echo "	var css_dir_rel = ''" . $css_dir_rel . "'';\\n";\r\n	echo "</script>\\n\\n";\r\n\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$playlist_path = $doc_root . "/" . BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$playlist_path = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = "../" . BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	\r\n	// Build xml playlist string.\r\n	$playlist = "<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n\\n";\r\n	$playlist .= "<playlist>\\n";\r\n	$indent = "   ";\r\n	$srch = array(".mp3", ".MP3", ".Mp3");\r\n	if ($handle = opendir("$playlist_path")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != ".."))\r\n			{\r\n				if (!(stripos($file, ".mp3") === false))\r\n				{\r\n					$title = str_replace($srch, "", $file);\r\n					$playlist .= $indent . "<item>\\n";\r\n					$playlist .= $indent . $indent . "<title>" . $title . "</title>\\n";\r\n					$playlist .= $indent . $indent . "<artist></artist>\\n";\r\n					$playlist .= $indent . $indent . "<path>" . $playlist_path_rel . $file . "</path>\\n";\r\n					$playlist .= $indent . "</item>\\n";\r\n				}\r\n			}\r\n		}\r\n		closedir($handle);\r\n	}\r\n	$playlist .= "</playlist>\\n";\r\n	\r\n	// Save xml playlist.\r\n	$file_name = $playlist_path . "/playlist.xml";\r\n	\r\n	// Delete old file.\r\n	if (file_exists($file_name))\r\n	{\r\n		if (!unlink($file_name))\r\n			echo "Could not delete old playlist.<br>";\r\n	}\r\n	\r\n	// Create new file.\r\n	$fh = fopen($file_name, ''x'') or die("Can''t create $file_name: $php_errormsg");\r\n	$result = (fputs($fh, $playlist));\r\n	fclose($fh) or die($php_errormsg);\r\n	@chmod($file_name, 0755);\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalMusicPlayer.swf" height="86" id="player1" type="application/x-shockwave-flash" width="225">\r\n<param name="movie" id="movie" value="../flash/OriginalMusicPlayer.swf" />\r\n<param name="FlashVars" id="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> \r\n</div>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n// Note:  This probably only works in Opera.  You may need to manually change the data path to player1.\r\n	var player_path = flash_dir_rel + "OriginalMusicPlayer.swf";\r\n	document.getElementById("player1").setAttribute("data", player_path);\r\n	document.getElementById("movie").value = player_path;\r\n	var media_path = "mediaPath=" + media_dir_rel + "sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999";\r\n	document.getElementById("FlashVars").value = media_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, 0, 1, 0, 65);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(3, 'Calendar Grid', 'Monthly Calendar Grid, includes Hebrew as well as Gregorian.', 'Calendars and Events', 'calendar', 'Calendar and Event Styles', 'INSERT INTO `bwb_calendar_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.events_div'', ''Surrounding Event Grid Div'', 10, 0, 0),\r\n(''.events_table'', ''Event Table'', 20, 0, 0),\r\n(''.events_tr_head'', ''Event Grid Header Row'', 30, 0, 0),\r\n(''.events_td_head'', ''Event Grid Header Cells'', 40, 0, 0),\r\n(''.events_tr'', ''Event Grid Rows'', 50, 0, 0),\r\n(''.events_td'', ''Event Grid Cells'', 60, 0, 0),\r\n(''.calendar_div'', ''Surrounding Calendar Grid Div'', 70, 0, 0),\r\n(''.calendar_table'', ''Calendar Grid Table'', 80, 0, 0),\r\n(''.calendar_tr_head'', ''Calendar Grid Month Header Row'', 90, 0, 0),\r\n(''.calendar_td_head'', ''Calendar Grid Month Header Cells'', 100, 0, 0),\r\n(''.calendar_tr_head2'', ''Calendar Grid Days Header Row'', 110, 0, 0),\r\n(''.calendar_td_head2'', ''Calendar Grid Days Header Cells'', 120, 0, 0),\r\n(''.calendar_tr'', ''Calendar Grid Rows'', 130, 0, 0),\r\n(''.calendar_td'', ''Calendar Grid Cells'', 140, 0, 0),\r\n(''.calendar_td_head a'', ''Calendar Grid Month Header Cells A'', 150, 0, 0),\r\n(''.calendar_td_head a:link'', ''Calendar Grid Month Header Cells A:Link'', 160, 0, 0),\r\n(''.calendar_td_head a:hover'', ''Calendar Grid Month Header Cells A:Hover'', 170, 0, 0),\r\n(''.calendar_td_head a:visited'', ''Calendar Grid Month Header Cells A:Visited'', 180, 0, 0),\r\n(''.calendar_td a'', ''Calendar Grid Cells A'', 190, 0, 0),\r\n(''.calendar_td a:link'', ''Calendar Grid Cells A:Link'', 200, 0, 0),\r\n(''.calendar_td a:hover'', ''Calendar Grid Cells A:Hover'', 210, 0, 0),\r\n(''.calendar_td a:visited'', ''Calendar Grid Cells A:Visited'', 220, 0, 0),\r\n(''.events_td a'', ''Event Grid Cells A'', 61, 0, 0),\r\n(''.events_td a:link'', ''Event Grid Cells A:Link'', 62, 0, 0),\r\n(''.events_td a:hover'', ''Event Grid Cells A:Hover'', 63, 0, 0),\r\n(''.events_td a:visited'', ''Event Grid Cells A:Visited'', 64, 0, 0),\r\n(''.calendar_hebrew'', ''Calendar Hebrew Text'', 240, 0, 0),\r\n(''.calendar_hebrew_header'', ''Calendar Hebrew Header Text'', 230, 0, 0);', 'INSERT INTO `bwb_calendar_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.events_tr_head'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#3e51b7'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_tr_head'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#3e51b7'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#CDCCF4'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_tr_head2'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#CDCCF4'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFDDDD'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_hebrew'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000088'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_hebrew_header'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFF00'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#FFFFFF'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#8900F2'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.calendar_td_head2'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#B49CFC'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#8900F2'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.events_td a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#442C8C'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', '''', -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n///////////// Calendar Code ///////////////////////////////////////////\r\n// Breeze Website Builder\r\n// Copyright: Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.\r\n// Revised: 6/15/2007\r\n// Revised: 8/6/2007	Added pagebreak div.\r\n// Revised: 9/10/2008  Added active flag.	ELL\r\n// Revised: 8/1/2009  ELL\r\n// Added class hooks for styling.\r\n// Revised: 3/25/2010	ELL\r\n// Added ability to scroll thru months on a single calendar grid.  Added switch to go back and forth betmeen \r\n// showing all grids as before, or using new single grid with nav links on top. Default is new single grid view.\r\n// Combined standard and hebrew calendars into one.  Setting show_hebrew = 1 causes calendar to show Hebrew dates.\r\n// Revised: 6/1/2010	ELL\r\n// Modified to go to this (as in now) month if going to calender first time.  (No forwards/backwards clicked yet.)\r\n// Revised: 9/1/2010	ELL\r\n// Added show_past switch to show or hide past dates.  Past dates will now be hidden by default.  Set show_past=1 to override default.\r\n// Revised: 2/6/2012	ELL\r\n// Added table prefix option.\r\n// Revised: 7/7/2012	ELL\r\n// Added filtering by users and groups.\r\n// Revised: 4/24/2014	ELL\r\n// Added ability to set target for event URL.\r\n	\r\n	$month_count = 0;\r\n	$month = array();\r\n	$day = array();\r\n	$year = array();\r\n	$Description = array();\r\n	$EventDate = array();\r\n	$StartTime = array();\r\n	$EndTime = array();\r\n    $URL = array();\r\n	$target = array();\r\n	\r\n	$curr_mth = $_REQUEST[''curr_mth''];\r\n	if (!isset($curr_mth)) $curr_mth = 0;\r\n	$mth_change = $_REQUEST[''mth_change''];\r\n	$show_all = $_REQUEST[''show_all''];\r\n	if (!isset($show_all)) $show_all = 0;\r\n	$show_hebrew = $_REQUEST[''show_hebrew''];\r\n	if (!isset($show_hebrew)) $show_hebrew = 0;\r\n	$script_name = getenv(''SCRIPT_FILENAME'');\r\n	$pos = strrpos("$script_name", "/");\r\n	$script_name = substr($script_name, ($pos + 1));\r\n	$show_past = $_REQUEST[''show_past''];\r\n	if (!isset($show_past)) $show_past = 0;\r\n	$events_user_table = $_REQUEST[''user_table''];\r\n	$events_UserID = $_REQUEST[''UserID''];\r\n	$events_AccessLevel = $_REQUEST[''AccessLevel''];\r\n	$use_logged_in_credentials = $_REQUEST[''use_logged_in_credentials''];\r\n	\r\n	$where = " WHERE (`Active` = 1)";\r\n	$today = date("Y-m-d");\r\n	if ($show_past != 1)\r\n		$where .= " AND (EventDateSort >= ''$today'')";\r\n	\r\n	if ($use_logged_in_credentials)\r\n	{\r\n		if ($events_user_table)\r\n			$where .= " AND (user_table = ''$user_table'')";\r\n		if ($events_UserID)\r\n			$where .= " AND (UserID = ''$UserID'')";\r\n		if ($events_AccessLevel)\r\n			$where .= " AND (AccessLevel = ''$AccessLevel'')";\r\n	}\r\n	else\r\n	{\r\n		if (($events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND ((user_table = ''$events_user_table'') AND ((UserID = ''$events_UserID'') OR (AccessLevel = ''$events_AccessLevel'')))";\r\n		elseif (($events_user_table) && (!$events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'')";\r\n		elseif ((!$events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (UserID = ''$events_UserID'')";\r\n		elseif ((!$events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND (AccessLevel = ''$events_AccessLevel'')";\r\n		elseif (($events_user_table) && ($events_UserID) && (!$events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'') AND (UserID = ''$events_UserID'')";\r\n		elseif (($events_user_table) && (!$events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND (user_table = ''$events_user_table'') AND (AccessLevel = ''$events_AccessLevel'')";\r\n		elseif ((!$events_user_table) && ($events_UserID) && ($events_AccessLevel))\r\n			$where .= " AND ((UserID = ''$events_UserID'') OR (AccessLevel = ''$events_AccessLevel''))";\r\n	}\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "schedule" . $where . " ORDER BY `EventDateSort`";\r\n	\r\n	$result = $bwb_dbh->query($query);\r\n	$num_results = $result->rowCount();\r\n\r\n	for ($i = 0; $i < $num_results; $i++)\r\n	{\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$Description[$i] = stripslashes($row["Description"]);\r\n		$EventDate[$i] = $row["EventDate"];\r\n		$StartTime[$i] = $row["StartTime"];\r\n		$EndTime[$i] = $row["EndTime"];\r\n		$URL[$i] = $row["URL"];\r\n		$target[$i] = $row["target"];\r\n		list($month[$i], $day[$i], $year[$i]) = split(''[/.-]'', $EventDate[$i]);\r\n		if ($month[$i] != $month[$i-1])\r\n			$month_count++; \r\n	}\r\n\r\n	//////////////////////////////////////////////////\r\n	if ($show_all != 1)\r\n	{\r\n		if (isset($mth_change))\r\n		{\r\n			switch($mth_change)	{\r\n				case -1:\r\n					$curr_mth = $curr_mth - 1;\r\n					if ($curr_mth < 0)\r\n						$curr_mth = 0;\r\n					break;\r\n				case 1:\r\n					$curr_mth = $curr_mth + 1;\r\n					if ($curr_mth > $month_count - 1)\r\n						$curr_mth = $month_count - 1;\r\n					break;\r\n				case -10:\r\n					$curr_mth = 0;\r\n					break;\r\n				case 10:\r\n					$curr_mth = $month_count - 1;\r\n					break;\r\n			}\r\n		}\r\n		else\r\n		{\r\n			// If $curr_mth not set, then first time. Need to default to this month and set $curr_mth which is just index into months\r\n			// by count of total valid months.  If this month is not one of the valid months, then got to first valid month.\r\n			$m = 0;\r\n			$this_month = date("n");\r\n			$valid_mth_found = false;\r\n			for ($k = 0; $k < $month_count; $k++)\r\n			{				\r\n				$grid_month = $month[$m];\r\n				if($grid_month != $this_month)\r\n				{\r\n					while($month[$m] == $grid_month)\r\n						$m++;\r\n					continue;\r\n				}\r\n				else\r\n				{\r\n					$curr_mth = $k;\r\n					$valid_mth_found = true;\r\n					break;\r\n				}\r\n			}\r\n			if (!$valid_mth_found)\r\n				$curr_mth = 0;\r\n		}\r\n	}\r\n\r\n$m = 0;\r\nfor ($k = 0; $k < $month_count; $k++)\r\n{\r\n	$grid_month = $month[$m];\r\n	$current_year = $year[$m];\r\n	if(($show_all != 1) && ($k != $curr_mth))\r\n	{\r\n		while($month[$m] == $grid_month)\r\n			$m++;\r\n		continue;\r\n	}\r\n	$start_timestamp = mktime(0, 0, 0, $month[$m], 1, $year[$m]);\r\n	$on_the_1st_day_of_week = date("w", $start_timestamp) + 1;	// 1 = Sunday, 7 = Saturday\r\n	$days_in_month = date("t", $start_timestamp);\r\n	$month_name = date("F", $start_timestamp);\r\n	$year_string = date("Y", $start_timestamp);\r\n	\r\n	if ($show_hebrew == 1)\r\n	{\r\n		// Get Jewish date\r\n		$julian_date = gregoriantojd($grid_month, 1, $current_year);\r\n		$jewishdate = jdtojewish($julian_date);\r\n		// Find the Jewish calendar date and parse out the day and year values\r\n		list ($jc_month, $jc_day, $jc_year) = explode (''/'', $jewishdate);\r\n		// Get Jewish month name\r\n		$jc_month_string = jdmonthname ($julian_date, 4);\r\n		// Get second Jewish date\r\n		$julian_date_2 = gregoriantojd($grid_month, $days_in_month, $current_year);\r\n		$jewishdate_2 = jdtojewish($julian_date_2);\r\n		// Find the Jewish calendar date and parse out the day and year values\r\n		list ($jc_month_2, $jc_day_2, $jc_year_2) = explode (''/'', $jewishdate_2);\r\n		// Get Jewish month name\r\n		$jc_month_string_2 = jdmonthname ($julian_date_2, 4);\r\n		// In case this month spans the Jewish year, make year adjustment for heading.\r\n		if ($jc_year != $jc_year_2)\r\n			$jc_year = $jc_year . " - " . $jc_year_2;\r\n	}\r\n?>\r\n\r\n<DIV CLASS="pagebreak">\r\n<div class="calendar_div">\r\n<table border="1" class="calendar_table">\r\n<tr bgcolor="#CCCCCC" class="calendar_tr_head">\r\n	<td colspan="7">\r\n    <table width="100%" border="0">\r\n    	<tr>\r\n        <?php if ($show_all != 1) {	?>\r\n        	<td align="left" class="calendar_td_head">\r\n            <?php if ($curr_mth > 0) echo "<a href=''$script_name?mth_change=-10&curr_mth=$curr_mth&show_hebrew=$show_hebrew'' title=''First''>"; ?>\r\n            <b><font size="4">&lt;&lt;</font></b>\r\n			<?php if ($curr_mth > 0) echo "</a>"; ?>\r\n            </td>\r\n            <td align="left" class="calendar_td_head">\r\n            <?php if ($curr_mth > 0) echo "<a href=''$script_name?mth_change=-1&curr_mth=$curr_mth&show_hebrew=$show_hebrew'' title=''Previous''>"; ?>\r\n            <b><font size="4">&lt;</font></b>\r\n            <?php if ($curr_mth > 0) echo "</a>"; ?>\r\n            </td>\r\n        <?php } ?>\r\n    		<td align="center" class="calendar_td_head">\r\n            <a <?php if ($show_all == 1) echo "href=''$script_name?show_all=0&curr_mth=$k&show_hebrew=$show_hebrew'' title=''Show Current Month Only''"; else echo "href=''$script_name?show_all=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew'' title=''Show All Months''"; ?>><b><font size="4">\r\n			<?php if ($show_hebrew != 1) echo "$month_name, $year_string"; else echo "$month_name, $year_string<br><span class=''calendar_hebrew_header''>$jc_month_string - $jc_month_string_2, $jc_year</span>"; ?>\r\n            </font></b></a>\r\n            </td>\r\n        <?php if ($show_all != 1) {	?>\r\n            <td align="right" class="calendar_td_head">\r\n            <?php if ($curr_mth < $month_count - 1) echo "<a href=''$script_name?mth_change=1&curr_mth=$curr_mth&show_hebrew=$show_hebrew'' title=''Next''>"; ?>\r\n            <b><font size="4">&gt;</font></b>\r\n            <?php if ($curr_mth < $month_count - 1) echo "</a>"; ?>\r\n            </td>\r\n            <td align="right" class="calendar_td_head">\r\n            <?php if ($curr_mth < $month_count - 1) echo "<a href=''$script_name?mth_change=10&curr_mth=$curr_mth&show_hebrew=$show_hebrew'' title=''Last''>"; ?>\r\n            <b><font size="4">&gt;&gt;</font></b>\r\n            <?php if ($curr_mth < $month_count -1 ) echo "</a>"; ?>\r\n            </td>\r\n         <?php } ?>\r\n    	</tr>\r\n    </table>\r\n    </td>\r\n</tr>\r\n<tr bgcolor="#CCCCCC" class="calendar_tr_head2">\r\n	<td align="center" width="100" class="calendar_td_head2"><b>S</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>M</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>T</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>W</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>T</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>F</b></td>\r\n	<td align="center" width="100" class="calendar_td_head2"><b>S</b></td>\r\n</tr>\r\n<tr class="calendar_tr">\r\n\r\n<?php\r\n	$got_1st_day = false;\r\n	$got_last_day = false;\r\n	$j = 1;\r\n	for ($i = 1; $i < 43; $i++)\r\n	{\r\n		if ($i == $on_the_1st_day_of_week)\r\n			$got_1st_day = true;\r\n\r\n		echo " <td height=''100'' align=''left'' valign=''top'' class=''calendar_td''>";\r\n		if (($got_1st_day == true) && ($got_last_day == false))\r\n		{\r\n			if ($show_hebrew == 1)\r\n			{\r\n				// Get Jewish date\r\n				$julian_date = gregoriantojd($grid_month, $j, $current_year);\r\n				$jewishdate = jdtojewish($julian_date);\r\n				// Find the Jewish calendar date and parse out the day and year values\r\n				list ($jc_month, $jc_day, $jc_year) = explode (''/'', $jewishdate);\r\n				// Find the Jewish calendar month name\r\n				$jc_month = jdmonthname ($julian_date, 4);\r\n				echo "$j &nbsp;&nbsp;&nbsp; <span class=''calendar_hebrew''>$jc_day $jc_month</span>";	// Print day.\r\n			}\r\n			else\r\n				echo $j;	// Print day.\r\n			/////////////////////////////////////////////////////////\r\n			// Print event if one exists for this day.\r\n			while (($day[$m] == $j) && ($month[$m] == $grid_month))\r\n			{\r\n				if ($EndTime[$m] == "")\r\n					$EndTimeStr = "";\r\n				else\r\n					$EndTimeStr = "- $EndTime[$m]";\r\n				if ($URL[$m])\r\n					echo "<br><br><font size=''2''><a href=''$URL[$m]'' target=''$target[$m]''>$Description[$m]<br>$StartTime[$m] $EndTimeStr</a></font>";\r\n				else\r\n					echo "<br><br><font size=''2''>$Description[$m]<br>$StartTime[$m] $EndTimeStr</font>";\r\n				$m++;\r\n			}\r\n			/////////////////////////////////////////////////////////\r\n			$j++;\r\n			if ($j > $days_in_month)\r\n				$got_last_day = true;\r\n		}\r\n		else\r\n			echo "&nbsp;";\r\n\r\n		echo "</td>";\r\n\r\n		if (($i == 35) && ($got_last_day == true))	//All done, don''t need another row.\r\n			$i = 50;\r\n		else if (!($i % 7))	//If Saturday, start new row.\r\n			echo "</tr><tr>";\r\n	}\r\n?>\r\n\r\n</tr>\r\n</table>\r\n<br>\r\n</div>\r\n</DIV>\r\n\r\n<?php\r\n}	//month count\r\n/////////////////////////////////////////////////////////////////////////////////////\r\n?>', '<span style="color: rgb(255, 0, 0);">{*** delete *** \r\n<p>The calender is not edited here. To add events to the calendar, go back to the main menu and click the <b><em>Revise Schedule</em></b> button.  The change the look and colors of your calendar, Click the <b><em>Edit Styles</em></b> button and select <b><em>Calendar and Event Styles</em></b>.</p>\r\n</span>\r\n<p><span style="color: rgb(255, 0, 0);">You can pass parameters in the URL to this page to control certain aspects of this calendar grid. For instance, sending <strong>show_past=1</strong> will cause the events grid to show dates that are in the past. By default, only events on this day or later will be displayed. As an extra bonus, you can also display Hebrew dates by sending <strong>show_hebrew=1</strong>.</span></p>\r\n<p style="color: rgb(255, 0, 0);">By default, the calendar grid shows one calendar grid for one month with navigation links across the top to display other months across the top. Clicking on the month/year in the header toggles the view between displaying only one month and all of the months that contain events. Showing all of the months is particularly useful of the user would like to print the entire calendar with all months that contain events. You may make all-months view the default by adding <strong>show_all=1</strong> to the link to the calendar page. i.e. <strong>calendar.php?show_all=1</strong></p>\r\n\r\n<p><span style="color: rgb(255, 0, 0);">You may also setup events to be private to a single user or to a group. To do that, add the following parameters to your URL:<strong> user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong>. You may also add <strong>use_logged_in_credentials</strong> to your URL and set its value to <strong>1</strong>. If you send <strong>use_logged_in_credentials</strong>, then the variabless <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> which of the credentials are used from the logged-in session to filter the events using and <strong>AND</strong> comparator. i.e. if <strong>user_table</strong> and <strong>UserID</strong> are set, then all events with the user <strong>UserID</strong> from the table <strong>user_table</strong> will be selected, but <u>not</u> the same <strong>UserID</strong> from <u>another</u> <strong>user_table</strong>. The formula for this is:</span></p>\r\n<p><span style="color: rgb(255, 0, 0);">(<strong>user_table</strong>) AND (<strong>UserID)</strong> AND (<strong>AccessLevel</strong>) where any one or two of these variables may be ommitted.</span></p>\r\n<p><span style="color: rgb(255, 0, 0);">An example of a  complete URL might be:</span></p>\r\n<p><span style="color: rgb(255, 0, 0);">calendar.php?show_past=1&amp;user_table=1&amp;AccessLevel=1&amp;UserID=1</span></p>\r\n<p><span style="color: rgb(255, 0, 0);">If <strong>use_logged_in_credentials</strong> is not set, then <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are handled in a different manner. Instead, the values passed in these variables are to be used explicitly, and not those of any logged in session. They are also combined somewhat differently. i.e., if all three variables <strong>user_table</strong>, <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then all events assigned to users of user ID <strong>UserID</strong>, and all users of access level <strong>AccessLevel</strong> from and only from the user table user_table will be shown. If only <strong>UserID</strong>, and <strong>AccessLevel</strong> are passed, then events assigned to user <strong>UserID</strong>, or with access level <strong>AccessLevel</strong> will be selected reguardless of which user table they may be in. The  formula is:</span></p>\r\n<p><span style="color: rgb(255, 0, 0);"> (<strong>user_table</strong>) AND ((<strong>UserID</strong> OR (<strong>AccessLevel</strong>)) where any one or two of these variables may be ommitted.</span></p>\r\n<p><span style="color: rgb(255, 0, 0);"> An example of a complete URL might be:</span></p>\r\n<p><span style="color: rgb(255, 0, 0);">calendar.php?show_hebrew=1&amp;user_table=accounts_form&amp;AccessLevel=user&amp;UserID=Joe</span></p>\r\n<span style="color: rgb(255, 0, 0);"> *** delete *** }</span>', NULL, NULL, NULL, NULL, NULL, NULL, './plugins/edit_schedule.php', 'Revise Schedule', 'images/icon_Edit-Events.png', 'images/icon_Edit-Events_mo.png', 'images/icon_Edit-Events_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#calendar_grid', NULL, 'user', 0, 1, 0, 20);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(13, 'MP3 Audio Player, Mini', 'Premiumbeat music player', 'Audio', NULL, NULL, NULL, NULL, NULL, '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/LWMusicPlayer.swf" height="21" id="player1" type="application/x-shockwave-flash" width="65">\r\n<param name="movie" value="../flash/LWMusicPlayer.swf" />\r\n<param name="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> \r\n</div>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, 0, 1, 0, 70),
(14, 'Flash Video Player', 'JW Player', 'Video', NULL, NULL, NULL, NULL, '<?php\r\n	echo "<script language=\\"JavaScript\\" type=\\"text/JavaScript\\">\\n";\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$scripts_dir = "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir = "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_BASE_DIR ."/" . BWB_CSS_DIR . "/";\r\n	}\r\n	\r\n	if (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$scripts_dir_rel = BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir_rel = "../" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = "../" . BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = "../" . BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = "../" .BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = "../" . BWB_CSS_DIR . "/";\r\n	}\r\n		\r\n	echo "	var scripts_dir = ''" . $scripts_dir . "'';\\n";\r\n	echo "	var flash_dir = ''" . $flash_dir . "'';\\n";\r\n	echo "	var media_dir = ''" . $media_dir . "'';\\n";\r\n	echo "	var image_dir = ''" . $image_dir . "'';\\n";\r\n	echo "	var css_dir = ''" . $css_dir . "'';\\n";\r\n	\r\n	echo "	var scripts_dir_rel = ''" . $scripts_dir_rel . "'';\\n";\r\n	echo "	var flash_dir_rel = ''" . $flash_dir_rel . "'';\\n";\r\n	echo "	var media_dir_rel = ''" . $media_dir_rel . "'';\\n";\r\n	echo "	var image_dir_rel = ''" . $image_dir_rel . "'';\\n";\r\n	echo "	var css_dir_rel = ''" . $css_dir_rel . "'';\\n";\r\n	echo "</script>\\n\\n";\r\n	$swfobject_path = $scripts_dir . "swfobject.js";\r\n	echo "<script type=\\"text/javascript\\" src=\\"" . $swfobject_path . "\\"></script>\\n";\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\nvar player_path = flash_dir + "player.swf";\r\nvar so = new SWFObject(player_path,"mpl","360","288","9");\r\nso.addParam("allowscriptaccess","always");\r\nso.addParam("allowfullscreen","true");\r\n\r\nvar flv_path = media_dir + "sample.flv";\r\nvar image_path = image_dir + "sample.jpg";\r\nso.addParam("flashvars","author=Me&description=My Video&file=" + flv_path + "&title=My Video&autostart=false&stretching=exactfit&image=" + image_path);\r\n\r\nso.write("my_video_div");\r\n</script>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\nvar player_path = flash_dir + "player.swf";\r\nvar so = new SWFObject(player_path,"mpl","360","288","9");\r\nso.addParam("allowscriptaccess","always");\r\nso.addParam("allowfullscreen","true");\r\n\r\nvar flv_path = media_dir + "sample.flv";\r\nvar image_path = image_dir + "sample.jpg";\r\nso.addParam("flashvars","author=Me&description=My Video&file=" + flv_path + "&title=My Video&autostart=false&stretching=exactfit&image=" + image_path);\r\n\r\nso.write("my_video_div");\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#flash_video', NULL, NULL, 0, 1, 0, 90),
(15, 'Simple Slide Show', 'Simple Slide Show with no navigation controls', 'Slideshows', NULL, NULL, NULL, NULL, '<?php\r\n	echo "<script language=\\"JavaScript\\" type=\\"text/JavaScript\\">\\n";\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$scripts_dir = "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir = "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_BASE_DIR ."/" . BWB_CSS_DIR . "/";\r\n	}\r\n	\r\n	if (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$scripts_dir_rel = BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir_rel = "../" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = "../" . BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = "../" . BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = "../" .BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = "../" . BWB_CSS_DIR . "/";\r\n	}\r\n		\r\n	echo "	var scripts_dir = ''" . $scripts_dir . "'';\\n";\r\n	echo "	var flash_dir = ''" . $flash_dir . "'';\\n";\r\n	echo "	var media_dir = ''" . $media_dir . "'';\\n";\r\n	echo "	var image_dir = ''" . $image_dir . "'';\\n";\r\n	echo "	var css_dir = ''" . $css_dir . "'';\\n";\r\n	\r\n	echo "	var scripts_dir_rel = ''" . $scripts_dir_rel . "'';\\n";\r\n	echo "	var flash_dir_rel = ''" . $flash_dir_rel . "'';\\n";\r\n	echo "	var media_dir_rel = ''" . $media_dir_rel . "'';\\n";\r\n	echo "	var image_dir_rel = ''" . $image_dir_rel . "'';\\n";\r\n	echo "	var css_dir_rel = ''" . $css_dir_rel . "'';\\n";\r\n	echo "</script>\\n\\n";\r\n?>', '<script type="text/javascript">\r\n// Opacity and Fade in script.\r\n// Script copyright (C) 2008 http://www.cryer.co.uk/.\r\n// Script is free to use provided this copyright header is included.\r\nfunction SetOpacity(object,opacityPct)\r\n{\r\n  // IE.\r\n  object.style.filter = "alpha(opacity=" + opacityPct + ")";\r\n  // Old mozilla and firefox\r\n  object.style.MozOpacity = opacityPct/100;\r\n  // Everything else.\r\n  object.style.opacity = opacityPct/100;\r\n}\r\n\r\nfunction ChangeOpacity(id,msDuration,msStart,fromO,toO)\r\n{\r\n  var element=document.getElementById(id);\r\n  var opacity = element.style.opacity * 100;\r\n  var msNow = (new Date()).getTime();\r\n  opacity = fromO + (toO - fromO) * (msNow - msStart) / msDuration;\r\n  if (opacity<0) \r\n    SetOpacity(element,0)\r\n  else if (opacity>100)\r\n    SetOpacity(element,100)\r\n  else\r\n  {\r\n    SetOpacity(element,opacity);\r\n    element.timer = window.setTimeout("ChangeOpacity(''" + id + "''," + msDuration + "," + msStart + "," + fromO + "," + toO + ")",1);\r\n  }\r\n}\r\n\r\nfunction FadeIn(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout("ChangeOpacity(''" + id + "'',1000," + startMS + ",0,100)",1);\r\n}\r\n\r\nfunction FadeOut(id)\r\n{\r\n  var element=document.getElementById(id);\r\n  if (element.timer) window.clearTimeout(element.timer); \r\n  var startMS = (new Date()).getTime();\r\n  element.timer = window.setTimeout("ChangeOpacity(''" + id + "'',1000," + startMS + ",100,0)",1);\r\n}\r\n\r\nfunction FadeInImage(foregroundID,newImage,backgroundID)\r\n{\r\n  var foreground=document.getElementById(foregroundID);\r\n  if (backgroundID)\r\n  {\r\n    var background=document.getElementById(backgroundID);\r\n    if (background)\r\n    {\r\n      background.style.backgroundImage = ''url('' + foreground.src + '')'';\r\n      background.style.backgroundRepeat = ''no-repeat'';\r\n    }\r\n  }\r\n  SetOpacity(foreground,0);\r\n  foreground.src = newImage;\r\n  if (foreground.timer) window.clearTimeout(foreground.timer); \r\n  var startMS = (new Date()).getTime();\r\n  foreground.timer = window.setTimeout("ChangeOpacity(''" + foregroundID + "'',1000," + startMS + ",0,100)",10);\r\n}\r\n\r\n</script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<script type="text/javascript">\r\nvar last_image = 1;\r\nvar image_cnt = 2;\r\nvar img_width = "500px";\r\nvar img_height = "366px";\r\nvar delay = 7000;\r\n\r\nfunction ChangeImage()\r\n{\r\n   var base_image_name = "slide";\r\n   var image_str;\r\n\r\n   last_image++;\r\n\r\n   image_str = image_dir + base_image_name + last_image + ".jpg";\r\n   FadeInImage("image_banner", image_str, "image_banner_bkg");\r\n   \r\n   if (last_image == image_cnt)\r\n      last_image = 0;\r\n\r\n   mTimer = setTimeout(ChangeImage, delay);\r\n}\r\n\r\nmTimer = setTimeout(ChangeImage, delay);\r\n  \r\n</script>\r\n\r\n<div id="image_banner_bkg" style="background-image: url("../image/slide1.jpg");">\r\n <img id="image_banner" src="/userfiles/image/slide1.jpg" style="border-width: 0px; border-style: solid; margin: 0px;" />	\r\n</div>\r\n\r\n<script type="text/javascript">\r\ndocument.getElementById("image_banner").style.width = img_width;\r\ndocument.getElementById("image_banner").style.height = img_height;\r\ndocument.getElementById("image_banner_bkg").style.width = img_width;\r\n</script>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n	var start_image_path_rel = image_dir_rel + "slide1.jpg";\r\n	var start_image_path = image_dir + "slide1.jpg";\r\n	document.getElementById("image_banner_bkg").setAttribute("url", start_image_path);\r\n	document.getElementById("image_banner").src = start_image_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#slide_show', NULL, NULL, 0, 1, 0, 50);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(10, 'Lightbox Photo Gallery', 'Lightbox Photo Gallery', 'Photo Galleries', NULL, NULL, NULL, NULL, '<?php\r\n	echo "<script language=\\"JavaScript\\" type=\\"text/JavaScript\\">\\n";\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$scripts_dir = "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir = "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_BASE_DIR ."/" . BWB_CSS_DIR . "/";\r\n	}\r\n	\r\n	if (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$scripts_dir_rel = BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir_rel = "../" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = "../" . BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = "../" . BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = "../" .BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = "../" . BWB_CSS_DIR . "/";\r\n	}\r\n		\r\n	echo "	var scripts_dir = ''" . $scripts_dir . "'';\\n";\r\n	echo "	var flash_dir = ''" . $flash_dir . "'';\\n";\r\n	echo "	var media_dir = ''" . $media_dir . "'';\\n";\r\n	echo "	var image_dir = ''" . $image_dir . "'';\\n";\r\n	echo "	var css_dir = ''" . $css_dir . "'';\\n";\r\n	\r\n	echo "	var scripts_dir_rel = ''" . $scripts_dir_rel . "'';\\n";\r\n	echo "	var flash_dir_rel = ''" . $flash_dir_rel . "'';\\n";\r\n	echo "	var media_dir_rel = ''" . $media_dir_rel . "'';\\n";\r\n	echo "	var image_dir_rel = ''" . $image_dir_rel . "'';\\n";\r\n	echo "	var css_dir_rel = ''" . $css_dir_rel . "'';\\n";\r\n	echo "</script>\\n\\n";\r\n	$prototype_path = $scripts_dir . "prototype.js";\r\n	$scriptaculous_path = $scripts_dir . "scriptaculous.js?load=effects,builder";\r\n	$lightbox_path = $scripts_dir . "lightbox.js";\r\n	$css_path = $css_dir_rel . "lightbox.css";\r\n	echo "<script type=\\"text/javascript\\" src=\\"" . $prototype_path . "\\"></script>\\n";\r\n	echo "<script type=\\"text/javascript\\" src=\\"" . $scriptaculous_path . "\\"></script>\\n";\r\n	echo "<script type=\\"text/javascript\\" src=\\"" . $lightbox_path . "\\"></script>\\n\\n";\r\n	echo "<link rel=\\"stylesheet\\" href=\\"" . $css_path . "\\" type=\\"text/css\\" media=\\"screen\\" />";\r\n?>', '', NULL, NULL, NULL, NULL, NULL, NULL, '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$full_gallery_path_fs = $doc_root . "/" .BWB_IMAGE_DIR . "/gallery/fs";\r\n		\r\n		$gallery_path_fs = BWB_IMAGE_DIR . "/gallery/fs";\r\n		$gallery_path_tn = BWB_IMAGE_DIR . "/gallery/tn";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$full_gallery_path_fs = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_IMAGE_DIR . "/gallery/fs";\r\n		\r\n		$gallery_path_fs = "../" . BWB_IMAGE_DIR . "/gallery/fs";\r\n		$gallery_path_tn = "../" . BWB_IMAGE_DIR . "/gallery/tn";\r\n	}\r\n	\r\n	$srch = array(".jpg", ".JPG", ".Jpg", ".gif", ".GIF", ".Gif", ".png", ".PNG", ".Png");\r\n	if ($handle = opendir("$full_gallery_path_fs")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != ".."))\r\n			{\r\n				$alt = str_replace($srch, "", $file);\r\n				echo "<a href=''" . $gallery_path_fs . "/" . $file . "'' rel=''lightbox[group]''><img src=''" . $gallery_path_tn . "/" . $file . "'' alt=''" . $alt . "'' border=''0'' /></a>\\n";\r\n			}\r\n		}\r\n		closedir($handle);\r\n	}\r\n?>', '<a href="../image/sample1.jpg" rel="lightbox" title="my caption"><img src="../image/sample1_tn.jpg" alt="" border="0" /></a>\r\n<br>\r\n<br>\r\n<a href="../image/sample1.jpg" rel="lightbox[group]"><img src="../image/sample1_tn.jpg" alt="" border="0" /></a>\r\n<a href="../image/sample2.jpg" rel="lightbox[group]"><img src="../image/sample2_tn.jpg" alt="" border="0" /></a>\r\n<a href="../image/sample3.jpg" rel="lightbox[group]"><img src="../image/sample3_tn.jpg" alt="" border="0" /></a>\r\n<br>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#photo_gallery', NULL, NULL, 0, 1, 0, 40),
(16, 'MP3 Audio Player, Thin', 'Premiumbeat music player', 'Audio', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalThinMusicPlayer.swf" height="21" id="player1" type="application/x-shockwave-flash" width="220">\r\n<param name="movie" value="../flash/OriginalThinMusicPlayer.swf" />\r\n<param name="FlashVars" value="mediaPath=../media/sample.mp3&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object> ', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, 0, 1, 0, 75),
(17, 'MP3 Audio Player, Deluxe', 'Premiumbeat music player, for multiple tracks with menu', 'Audio', NULL, NULL, NULL, NULL, '<?php\r\n	echo "<script language=\\"JavaScript\\" type=\\"text/JavaScript\\">\\n";\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$scripts_dir = "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir = "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir = "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/";\r\n		$media_dir = "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/";\r\n		$image_dir = "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/";\r\n		$css_dir = "/" . BWB_BASE_DIR ."/" . BWB_CSS_DIR . "/";\r\n	}\r\n	\r\n	if (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$scripts_dir_rel = BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = BWB_CSS_DIR . "/";\r\n	}\r\n	else\r\n	{\r\n		$scripts_dir_rel = "../" . BWB_SCRIPTS_DIR . "/";\r\n		$flash_dir_rel = "../" . BWB_FLASH_DIR . "/";\r\n		$media_dir_rel = "../" . BWB_MEDIA_DIR . "/";\r\n		$image_dir_rel = "../" .BWB_IMAGE_DIR . "/";\r\n		$css_dir_rel = "../" . BWB_CSS_DIR . "/";\r\n	}\r\n		\r\n	echo "	var scripts_dir = ''" . $scripts_dir . "'';\\n";\r\n	echo "	var flash_dir = ''" . $flash_dir . "'';\\n";\r\n	echo "	var media_dir = ''" . $media_dir . "'';\\n";\r\n	echo "	var image_dir = ''" . $image_dir . "'';\\n";\r\n	echo "	var css_dir = ''" . $css_dir . "'';\\n";\r\n	\r\n	echo "	var scripts_dir_rel = ''" . $scripts_dir_rel . "'';\\n";\r\n	echo "	var flash_dir_rel = ''" . $flash_dir_rel . "'';\\n";\r\n	echo "	var media_dir_rel = ''" . $media_dir_rel . "'';\\n";\r\n	echo "	var image_dir_rel = ''" . $image_dir_rel . "'';\\n";\r\n	echo "	var css_dir_rel = ''" . $css_dir_rel . "'';\\n";\r\n	echo "</script>\\n\\n";\r\n	\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$playlist_path = $doc_root . "/" . BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	else\r\n	{\r\n		$needle = "/" . BWB_BASE_DIR . "/";\r\n		$doc_root_arr = explode($needle, $doc_root);\r\n		$path_start = $doc_root_arr[0];\r\n		$playlist_path = $path_start . "/" . BWB_BASE_DIR . "/" .BWB_MEDIA_DIR . "/playlist";\r\n		\r\n		$playlist_path_rel = "../" . BWB_MEDIA_DIR . "/playlist/";\r\n	}\r\n	\r\n	// Build xml playlist string.\r\n	$playlist = "<?xml version=\\"1.0\\" encoding=\\"utf-8\\"?>\\n\\n";\r\n	$playlist .= "<playlist>\\n";\r\n	$indent = "   ";\r\n	$srch = array(".mp3", ".MP3", ".Mp3");\r\n	if ($handle = opendir("$playlist_path")) \r\n	{\r\n		while (false !== ($file = readdir($handle)))\r\n		{\r\n			if (($file != ".") && ($file != ".."))\r\n			{\r\n				if (!(stripos($file, ".mp3") === false))\r\n				{\r\n					$title = str_replace($srch, "", $file);\r\n					$playlist .= $indent . "<item>\\n";\r\n					$playlist .= $indent . $indent . "<title>" . $title . "</title>\\n";\r\n					$playlist .= $indent . $indent . "<artist></artist>\\n";\r\n					$playlist .= $indent . $indent . "<path>" . $playlist_path_rel . $file . "</path>\\n";\r\n					$playlist .= $indent . "</item>\\n";\r\n				}\r\n			}\r\n		}\r\n		closedir($handle);\r\n	}\r\n	$playlist .= "</playlist>\\n";\r\n	\r\n	// Save xml playlist.\r\n	$file_name = $playlist_path . "/playlist.xml";\r\n	\r\n	// Delete old file.\r\n	if (file_exists($file_name))\r\n	{\r\n		if (!unlink($file_name))\r\n			echo "Could not delete old playlist.<br>";\r\n	}\r\n	\r\n	// Create new file.\r\n	$fh = fopen($file_name, ''x'') or die("Can''t create $file_name: $php_errormsg");\r\n	$result = (fputs($fh, $playlist));\r\n	fclose($fh) or die($php_errormsg);\r\n	@chmod($file_name, 0755);\r\n?>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<p align="center"><b>My MP3</b></p>\r\n\r\n<div align="center">\r\n<object allowfullscreen="true" allowscriptaccess="always" data="../flash/OriginalMusicPlayerPlaylist.swf" height="250" id="player1" type="application/x-shockwave-flash" width="260">\r\n<param name="movie" id="movie" value="../flash/OriginalMusicPlayerPlaylist.swf" />\r\n<param name="FlashVars" id="FlashVars" value="playlistXmlPath=../media/playlist/playlist.xml&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999" />\r\n</object>\r\n</div>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n// Note:  This probably only works in Opera.  You may need to manually change the data path to player1.\r\n	var player_path = flash_dir_rel + "OriginalMusicPlayerPlaylist.swf";\r\n	document.getElementById("player1").setAttribute("data", player_path);\r\n	document.getElementById("movie").value = player_path;\r\n	var playlist_path = "playlistXmlPath=" + media_dir_rel + "playlist/playlist.xml&firstColor=0000&secondColor=000000&backColor=ffffff&strokeColor=999999";\r\n	document.getElementById("FlashVars").value = playlist_path;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mp3_players', NULL, NULL, 0, 1, 0, 80);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(18, 'Login Form', 'Login form with hidden password reset form that appears upon request.', 'User Access Forms', 'mail_form', 'Mail Form Styles', 'INSERT INTO `bwb_mail_form_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.mail_form_table'', ''Mail Form Table'', 10, 0, 0),\r\n(''.mail_form_td'', ''Mail Form Table Cell'', 20, 0, 0),\r\n(''.mail_form_td_field_title'', ''Mail Form Cell for Field Title'', 30, 0, 0),\r\n(''.mail_form_large_text'', ''Mail Form Text'', 40, 0, 0),\r\n(''.mail_form_small_text'', ''Mail Form Text (small)'', 50, 0, 0),\r\n(''.mail_form_div'', ''Mail Form Div'', 5, 0, 0),\r\n(''.btn_div'', ''Submit Button'', 60, 0, 0),\r\n(''.btn_txt'', ''Submit Button Text'', 70, 0, 0),\r\n(''.link_div'', ''User Account Link'', 80, 0, 0),\r\n(''.link_div a:link'', ''User Account Link Link'', 82, 0, 0),\r\n(''.link_div a:visited'', ''User Account Lisk Visited'', 84, 0, 0),\r\n(''.link_div a:hover'', ''User Account Link Hover'', 86, 0, 0),\r\n(''.link_div a:active'', ''User Account Link Active'', 88, 0, 0),\r\n(''.link_txt'', ''User Account Link Text'', 90, 0, 0),\r\n(''#form_div_btn'', ''Form Submit Button'', 100, 0, 0),\r\n(''#form_btn_txt'', ''Form Submit Button Text'', 110, 0, 0),\r\n(''#login_logout'', ''Login Logout Div'', 120, 0, 0),\r\n(''#logout_div_btn'', ''Logout Button'', 130, 0, 0),\r\n(''#logout_btn_txt'', ''Logout Button Text'', 140, 0, 0),\r\n(''#create_acct_div_btn'', ''Create Account Button'', 150, 0, 0),\r\n(''#create_acct_btn_txt'', ''Create Account Button Text'', 160, 0, 0),\r\n(''#generate_pass_div_btn'', ''Generate Password Button'', 150, 0, 0),\r\n(''#generate_pass_btn_txt'', ''Generate Password Button Text'', 170, 0, 0),\r\n(''#login_div_btn'', ''Login Button'', 180, 0, 0),\r\n(''#login_btn_txt'', ''Login Button Text'', 190, 0, 0),\r\n(''#reset_pass_div_btn'', ''Reset Password Button'', 200, 0, 0),\r\n(''#reset_pass_btn_txt'', ''Reset Password Button Text'', 210, 0, 0),\r\n(''#my_account_div_btn'', ''My Account Button'', 220, 0, 0),\r\n(''#my_account_btn_txt'', ''My Account Button Text'', 230, 0, 0),\r\n(''.form_submit_error_txt'', ''Form Submit Error Text'', 240, 0, 0),\r\n(''.field_highlight'', ''Form Submit Field Highlight'', 250, 0, 0);', 'INSERT INTO `bwb_mail_form_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.mail_form_table'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 1, ''#eeeeee'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 1, -1000000, 0, 1, -1000000, 0, 0, ''-not selected-'', 90, 1, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_td'', 1, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_large_text'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_small_text'', 1, ''-not selected-'', NULL, NULL, 12, ''-not set-'', -1, -1, -1, -1, ''normal'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_div'', 0, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_td_field_title'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 150, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_logout'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 160, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_div'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 3, 6, 3, 6, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFFFF'', -1, 2, ''#888888'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 100, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 2, 2, 2, 1, ''#888888'', 0, 5, 0, 5, 0, 5, 0, 5, 0, ''pointer'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_txt'', 1, ''Arial'', ''Verdana'', ''sans-serif'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_btn_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#form_div_btn'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#create_acct_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#my_account_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_txt'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000055'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:active'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#550000'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.form_submit_error_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 18, ''#ff0000'', -1, -1, -1, -1, ''-not selected-'', 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFF88'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.field_highlight'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 3, ''#FF0000'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', '<?php\r\n	include_once($captcha_includes_path);\r\n	\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n?>', '<script>\r\nfunction OnShowPasswordReset()\r\n{\r\n}\r\n</script>', '', NULL, NULL, NULL, NULL, NULL, NULL, '<div id="ErrEmail" style="display:none;" class="form_submit_error_txt">\r\n    You must fill in the email address. Please try again.\r\n</div>\r\n<div id="ErrBadEmail" style="display: none;" class="form_submit_error_txt">\r\n    The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id="ErrCaptcha" style="display: none;" class="form_submit_error_txt">\r\n    Your CAPTCHA entry is incorrect. Please try again.\r\n</div>\r\n<div id="ErrBadPassword" style=" display:none;" class="form_submit_error_txt">\r\n    The password you entered is incorrect. Please try again.\r\n</div>\r\n<div id="ErrBadUser" style="display:none;" class="form_submit_error_txt">\r\n    The username you entered was not found in our system. Please check it and try again.\r\n</div>\r\n<div id="ErrAccessLevel" style="display:none;" class="form_submit_error_txt">\r\n    Your account does not have the required access level to access this page. Please contact the system administrator.\r\n</div>\r\n<div id="ErrNotActive" style="display:none;" class="form_submit_error_txt">\r\n    Your account has not been activated. Please contact the system administrator\r\n</div>\r\n<div id="PasswordReset" style="display:none;" class="form_submit_error_txt">\r\n    A new password has been sent to the email address you provided. Please use it to login.\r\n</div>\r\n            \r\n<form name="frmLoginForm" id="frmLoginForm" method="post" action="/php/login_verify.php">\r\n  <div class="mail_form_div" id="login_form">\r\n    <table class="mail_form_table">\r\n        <tbody>\r\n			<tr><td colspan="2" class="mail_form_td_field_title"><span class="mail_form_large_text">Enter your user ID and password to login.</span></td></tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">User ID: </span></td>\r\n              <td class="mail_form_td"><input type="text" name="userid" id="userid" size="50" /></td>\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Password: </span></td>\r\n                <td class="mail_form_td">\r\n                <input type="password" name="password_input" id="password_input" size="50" onKeyDown="checkForEnter(event);" />\r\n                <input type="hidden" name="password" id="password" />\r\n                </td>\r\n            </tr>\r\n			<tr>\r\n            	<td colspan="2" align="center">\r\n                <div id="login_div_btn" class="btn_div" onClick="SubmitLogin();"><span id="login_btn_txt" class="btn_txt">Submit</span></div>\r\n				<input type="hidden" name="redirect" id="redirect" />\r\n                <input type="hidden" name="user_table" id="user_table" value="accounts" />\r\n                <input type="hidden" name="AccessLevel" id="AccessLevel" />\r\n                <input id="alt_go_back" name="alt_go_back" type="hidden" />\r\n			    <input id="redirect_err_to_src" name="redirect_err_to_src" type="hidden" value="1" />\r\n                </td>\r\n            </tr>\r\n            <tr>\r\n              <td colspan="2" align="center"><span class="mail_form_small_text" onclick="ShowPasswordReset();">Click <u style="cursor:pointer;">here</u> if you forgot your password.</span></td></tr>\r\n        </tbody>\r\n    </table>\r\n  </div>\r\n</form>\r\n\r\n<form name="frmResetPassword" id="frmResetPassword" method="post" action="/php/reset_password.php">\r\n  <div class="mail_form_div" id="reset_password_form" style="display:none;" >\r\n    <table class="mail_form_table">\r\n        <tbody>\r\n			<tr><td colspan="2" class="mail_form_td_field_title"><span class="mail_form_large_text">Enter your email address to reset your password.  Your new temporary password will be sent to your email.</span></td></tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Email: </span></td>\r\n              <td class="mail_form_td"><input type="text" name="email" id="email" size="50" /></td>\r\n            </tr>\r\n           <tr id="recaptcha_row">\r\n            	<td align="center" colspan="2" id="recaptcha_td">\r\n                  <script type="text/javascript" src="http://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT" id="recaptcha_script"></script>\r\n				  <noscript>\r\n					 <iframe src="http://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT"\r\n						 height="300" width="500" frameborder="0" id="captcha_iframe"></iframe><br>\r\n					 <textarea name="recaptcha_challenge_field" rows="3" cols="40">\r\n					 </textarea>\r\n					 <input type="hidden" name="recaptcha_response_field" id="recaptcha_response_field" value="manual_challenge">\r\n				  </noscript>\r\n               </td>\r\n            </tr>\r\n            <tr id="wscaptcha_row">\r\n                <td class="mail_form_td_field_title" style="vertical-align: bottom;" colspan="2" align="center">\r\n                  <table>\r\n                  <tr>\r\n                  <td width="200">\r\n                  <img alt="wspcaptcha" border="0" id="wspcaptcha" src="wspcaptcha.php" /> \r\n                  </td>\r\n                  <td valign="bottom" align="left" width="100%">\r\n                  <a href="javascript:void(0);" onclick="document.getElementById(''wspcaptcha'').src=''wspcaptcha.php?t=''+(new Date()).getTime(); return false;">\r\n                  <img alt="Reload" border="0" src="/images/reload.gif" /></a>\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td_field_title" style="vertical-align: bottom;" colspan="2">\r\n                  <input name="wsp_code" id="wsp_code" style="width:120px;" type="text" value="" class="text_box" />\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td" colspan="2">\r\n                  Type in the letters you see <span class="mail_form_large_text"><span class="required_fields"><b>*</b></span></span>\r\n                  </td>\r\n                  </table>\r\n                </td>\r\n            </tr>\r\n            <tr id="mollomcaptcha_row">\r\n            	<td align="center" colspan="2">\r\n                  <div id="mollom_captcha">&nbsp;</div>\r\n                  <input type="hidden" name="mollom_session" id="mollom_session" />\r\n                  <input type="text" name="captcha_response_field" id="captcha_response_field" size="10" value="" autocomplete="off" />\r\n                  <span class="mail_form_small_text">Type the characters you see in this picture</span>\r\n               </td>\r\n            </tr>\r\n			<tr>\r\n            	<td colspan="2" align="center">\r\n                <div id="reset_pass_div_btn" class="btn_div" onClick="document.getElementById(''frmResetPassword'').submit();"><span id="reset_pass_btn_txt" class="btn_txt">Submit</span></div>\r\n				<input type="hidden" name="redirect" id="redirect2" />\r\n                <input type="hidden" name="user_table" id="user_table2" value="accounts" />\r\n                <input type="hidden" name="subject" id="subject" value="Password Reset Request" />\r\n                <input type="hidden" name="reply_to" id="reply_to" />\r\n                <input type="hidden" name="from" id="from" />\r\n                <input type="hidden" name="html" id="html" value="1" />\r\n                <input type="hidden" name="use_captcha" id="use_captcha" value="1" />\r\n			    <input type="hidden" name="captcha_type" id="captcha_type" value="recaptcha" />\r\n                <input id="alt_go_back2" name="alt_go_back" type="hidden" />\r\n			    <input id="redirect_err_to_src2" name="redirect_err_to_src" type="hidden" value="1" />\r\n                <input id="email_link_page" name="email_link_page" type="hidden" />\r\n                </td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n  </div>\r\n</form>\r\n\r\n<div align="center" class="warning_text" id="javascript_warning">WARNING: JavaScript must be enabled to use this system. Please turn on JavaScipt in your browser.</div>', NULL, NULL, NULL, NULL, '<?php\r\n	include_once($captcha_includes_path2);\r\n	\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n?>', '', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#login_form', NULL, NULL, 0, 1, 0, 37);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(20, 'Change Password Form', 'Change Password Form.', 'User Access Forms', 'mail_form', 'Mail Form Styles', 'INSERT INTO `bwb_mail_form_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.mail_form_table'', ''Mail Form Table'', 10, 0, 0),\r\n(''.mail_form_td'', ''Mail Form Table Cell'', 20, 0, 0),\r\n(''.mail_form_td_field_title'', ''Mail Form Cell for Field Title'', 30, 0, 0),\r\n(''.mail_form_large_text'', ''Mail Form Text'', 40, 0, 0),\r\n(''.mail_form_small_text'', ''Mail Form Text (small)'', 50, 0, 0),\r\n(''.mail_form_div'', ''Mail Form Div'', 5, 0, 0),\r\n(''.btn_div'', ''Submit Button'', 60, 0, 0),\r\n(''.btn_txt'', ''Submit Button Text'', 70, 0, 0),\r\n(''.link_div'', ''User Account Link'', 80, 0, 0),\r\n(''.link_div a:link'', ''User Account Link Link'', 82, 0, 0),\r\n(''.link_div a:visited'', ''User Account Lisk Visited'', 84, 0, 0),\r\n(''.link_div a:hover'', ''User Account Link Hover'', 86, 0, 0),\r\n(''.link_div a:active'', ''User Account Link Active'', 88, 0, 0),\r\n(''.link_txt'', ''User Account Link Text'', 90, 0, 0),\r\n(''#form_div_btn'', ''Form Submit Button'', 100, 0, 0),\r\n(''#form_btn_txt'', ''Form Submit Button Text'', 110, 0, 0),\r\n(''#login_logout'', ''Login Logout Div'', 120, 0, 0),\r\n(''#logout_div_btn'', ''Logout Button'', 130, 0, 0),\r\n(''#logout_btn_txt'', ''Logout Button Text'', 140, 0, 0),\r\n(''#create_acct_div_btn'', ''Create Account Button'', 150, 0, 0),\r\n(''#create_acct_btn_txt'', ''Create Account Button Text'', 160, 0, 0),\r\n(''#generate_pass_div_btn'', ''Generate Password Button'', 150, 0, 0),\r\n(''#generate_pass_btn_txt'', ''Generate Password Button Text'', 170, 0, 0),\r\n(''#login_div_btn'', ''Login Button'', 180, 0, 0),\r\n(''#login_btn_txt'', ''Login Button Text'', 190, 0, 0),\r\n(''#reset_pass_div_btn'', ''Reset Password Button'', 200, 0, 0),\r\n(''#reset_pass_btn_txt'', ''Reset Password Button Text'', 210, 0, 0),\r\n(''#my_account_div_btn'', ''My Account Button'', 220, 0, 0),\r\n(''#my_account_btn_txt'', ''My Account Button Text'', 230, 0, 0),\r\n(''.form_submit_error_txt'', ''Form Submit Error Text'', 240, 0, 0),\r\n(''.field_highlight'', ''Form Submit Field Highlight'', 250, 0, 0);', 'INSERT INTO `bwb_mail_form_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.mail_form_table'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 1, ''#eeeeee'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 1, -1000000, 0, 1, -1000000, 0, 0, ''-not selected-'', 90, 1, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_td'', 1, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_large_text'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_small_text'', 1, ''-not selected-'', NULL, NULL, 12, ''-not set-'', -1, -1, -1, -1, ''normal'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_div'', 0, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_td_field_title'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 150, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_logout'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 160, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_div'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 3, 6, 3, 6, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFFFF'', -1, 2, ''#888888'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 100, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 2, 2, 2, 1, ''#888888'', 0, 5, 0, 5, 0, 5, 0, 5, 0, ''pointer'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_txt'', 1, ''Arial'', ''Verdana'', ''sans-serif'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_btn_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#form_div_btn'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#create_acct_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#my_account_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_txt'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000055'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:active'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#550000'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.form_submit_error_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 18, ''#ff0000'', -1, -1, -1, -1, ''-not selected-'', 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFF88'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.field_highlight'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 3, ''#FF0000'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', '', '<script language="javascript" type="text/javascript">\r\nfunction GeneratePassword()\r\n{\r\n	var password = "";\r\n	var password_length = rand(6,10);\r\n	var i;\r\n	var assci_segment;\r\n	\r\n	for (i = 0; i < password_length; i++)\r\n	{\r\n		assci_segment = rand(1,3);\r\n		if (assci_segment == 1)\r\n			password = password + String.fromCharCode(rand(48,57));	// numeric\r\n		else if (assci_segment == 2)\r\n			password = password + String.fromCharCode(rand(65,90));	// alpha upper case\r\n		else\r\n			password = password + String.fromCharCode(rand(97,122));	// alpha lower case\r\n	}\r\n	password = password.replace(''I'', ''i'');\r\n	password = password.replace(''O'', ''o'');\r\n	password = password.replace(''l'', ''L'');\r\n	\r\n	document.getElementById(''password'').value = password;\r\n	document.getElementById(''password_confirm'').value = password;\r\n		\r\n	return password;\r\n}\r\n\r\n// Equivalent to PHP rand(min, max);\r\nfunction rand ( n, m )\r\n{\r\n  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );\r\n}\r\n</script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<form name="frmChangePasswordForm" id="frmChangePasswordForm" method="post" action="/php/change_password.php">\r\n  <div class="mail_form_div">\r\n    <table class="mail_form_table">\r\n        <tbody>\r\n			<tr>\r\n			  <td class="mail_form_td_field_title"><span class="mail_form_large_text">Password, Confirm: </span></td>\r\n			  <td class="mail_form_td">\r\n              	<input type="text" name="password" id="password" />\r\n                <input type="text" name="password_confirm" id="password_confirm" />\r\n              </td>\r\n              <td>\r\n                <div id="generate_pass_div_btn" class="btn_div" onClick="GeneratePassword();"><span id="generate_pass_btn_txt" class="btn_txt">Generate Password</span></div>\r\n              </td>\r\n		  </tr>\r\n          <tr>\r\n          	<td align="center" colspan="3">\r\n            <div id="reset_pass_div_btn" class="btn_div" onClick="document.getElementById(''frmChangePasswordForm'').submit();"><span id="reset_pass_btn_txt" class="btn_txt">Submit</span></div>\r\n            </td>\r\n          </tr>\r\n        </tbody>\r\n    </table>\r\n    <input type="hidden" name="redirect" id="redirect" value="/change_password_return.php" />\r\n    <input type="hidden" name="UserID" id="UserID" />\r\n    <input type="hidden" name="user_table" id="user_table" />\r\n    <input type="hidden" name="subject" id="subject" value="Change Password" />\r\n    <input type="hidden" name="from" id="from" value="changepasswordform@example.com" />\r\n    <input type="hidden" name="html" id="html" value="1" />\r\n  </div>\r\n</form>', NULL, NULL, NULL, NULL, NULL, '<script language="JavaScript" type="text/JavaScript">\r\n	var php_path_rel = php_dir_rel + "change_password.php";\r\n	if (document.getElementById("frmChangePasswordForm").action == "")\r\n		document.getElementById("frmChangePasswordForm").action = php_path_rel;\r\n	\r\n	var redirect_path = document.getElementById("redirect").value;\r\n	if (redirect_path == "")\r\n		redirect_path = redirect;\r\n	var redirect_path_arr = redirect_path.split("/");\r\n	var redirect_file = "";\r\n	for(var i in redirect_path_arr)\r\n	{\r\n		if ((redirect_path_arr[i].indexOf(".php")) > 0)\r\n			redirect_file = redirect_path_arr[i];\r\n	}\r\n	redirect_path = webpage_dir + redirect_file;\r\n	document.getElementById("redirect").value = redirect_path;\r\n	\r\n	if (document.getElementById("user_table").value == "")\r\n		document.getElementById("user_table").value = user_table;\r\n	document.getElementById("UserID").value = userid;\r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#password_change_form', NULL, NULL, 0, 1, 0, 38),
(21, 'Blog Template', 'Template used for blogging.  This plugin is used automatically when the blog button is clicked.', NULL, 'blog', 'Blog Styles', 'INSERT INTO `bwb_blog_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.blog_subject'', ''Blog Subject'', 10, 0, 0),\r\n(''.blog_timestamp'', ''Blog Timestamp'', 20, 0, 0),\r\n(''.blog_message'', ''Blog Message'', 30, 0, 0),\r\n(''.blog_author'', ''Blog Author'', 40, 0, 0),\r\n(''.blog_hr'', ''Blog Horizontal Rule'', 50, 0, 0);', 'INSERT INTO `bwb_blog_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.blog_subject'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog_timestamp'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 10, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''inline-block'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''relative'', -1000000, 0, -40, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog_message'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, 5, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.blog_author'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3 class="blog_subject">Subject</h3> <div class="blog_timestamp">mm/dd/yyyy hh:ii:ss PM</div>\r\n<p class="blog_message">Message</p>\r\n<div class="blog_author">Username</div>\r\n<br />\r\n<hr class="blog_hr" />', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 0, 0, 200),
(22, 'HTML Contact Return Message', 'Page template for HTML contact return message.', 'Contact Forms', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Request for Information</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for inquiring about our services.  Someone will get back to you shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Contact Response Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mail_form', NULL, NULL, 0, 1, 1, 32),
(23, 'HTML Account Create Return Message', 'Page template for HTML account create return message.', 'User Access Forms', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Creation of New Account</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Thank you for signing up with our company.  Your request for an account will be reviewed by our staff shortly.</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, 0, 1, 1, 35),
(24, 'HTML New Account Welcome Message', 'Page template for HTML new account welcome message.', 'User Access Forms', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<h3>Account Approved</h3>\r\n<p>Hello [FIRST_NAME] [LAST_NAME],</p>\r\n<p>Your account has been activated.  You can now login and access your account. Your user ID is [USER_ID] and your password is [PASSWORD].</p>\r\n<p>Best regards,<br/>\r\nThe Account Management Team</p>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', NULL, NULL, 0, 1, 1, 36);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(26, 'Contact/Mail Form with CAPTCHA', 'Contact/Mail Form with CAPTCHA, auto-table creation and custom response email and return page.', 'Contact Forms', 'mail_form', 'Mail Form Styles', 'INSERT INTO `bwb_mail_form_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.mail_form_table'', ''Mail Form Table'', 10, 0, 0),\r\n(''.mail_form_td'', ''Mail Form Table Cell'', 20, 0, 0),\r\n(''.mail_form_td_field_title'', ''Mail Form Cell for Field Title'', 30, 0, 0),\r\n(''.mail_form_large_text'', ''Mail Form Text'', 40, 0, 0),\r\n(''.mail_form_small_text'', ''Mail Form Text (small)'', 50, 0, 0),\r\n(''.mail_form_div'', ''Mail Form Div'', 5, 0, 0),\r\n(''.btn_div'', ''Submit Button'', 60, 0, 0),\r\n(''.btn_txt'', ''Submit Button Text'', 70, 0, 0),\r\n(''.link_div'', ''User Account Link'', 80, 0, 0),\r\n(''.link_div a:link'', ''User Account Link Link'', 82, 0, 0),\r\n(''.link_div a:visited'', ''User Account Lisk Visited'', 84, 0, 0),\r\n(''.link_div a:hover'', ''User Account Link Hover'', 86, 0, 0),\r\n(''.link_div a:active'', ''User Account Link Active'', 88, 0, 0),\r\n(''.link_txt'', ''User Account Link Text'', 90, 0, 0),\r\n(''#form_div_btn'', ''Form Submit Button'', 100, 0, 0),\r\n(''#form_btn_txt'', ''Form Submit Button Text'', 110, 0, 0),\r\n(''#login_logout'', ''Login Logout Div'', 120, 0, 0),\r\n(''#logout_div_btn'', ''Logout Button'', 130, 0, 0),\r\n(''#logout_btn_txt'', ''Logout Button Text'', 140, 0, 0),\r\n(''#create_acct_div_btn'', ''Create Account Button'', 150, 0, 0),\r\n(''#create_acct_btn_txt'', ''Create Account Button Text'', 160, 0, 0),\r\n(''#generate_pass_div_btn'', ''Generate Password Button'', 150, 0, 0),\r\n(''#generate_pass_btn_txt'', ''Generate Password Button Text'', 170, 0, 0),\r\n(''#login_div_btn'', ''Login Button'', 180, 0, 0),\r\n(''#login_btn_txt'', ''Login Button Text'', 190, 0, 0),\r\n(''#reset_pass_div_btn'', ''Reset Password Button'', 200, 0, 0),\r\n(''#reset_pass_btn_txt'', ''Reset Password Button Text'', 210, 0, 0),\r\n(''#my_account_div_btn'', ''My Account Button'', 220, 0, 0),\r\n(''#my_account_btn_txt'', ''My Account Button Text'', 230, 0, 0),\r\n(''.form_submit_error_txt'', ''Form Submit Error Text'', 240, 0, 0),\r\n(''.field_highlight'', ''Form Submit Field Highlight'', 250, 0, 0);', 'INSERT INTO `bwb_mail_form_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.mail_form_table'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 1, ''#eeeeee'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 1, -1000000, 0, 1, -1000000, 0, 0, ''-not selected-'', 90, 1, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_td'', 1, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_large_text'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_small_text'', 1, ''-not selected-'', NULL, NULL, 12, ''-not set-'', -1, -1, -1, -1, ''normal'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_div'', 0, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_td_field_title'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 150, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_logout'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 160, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_div'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 3, 6, 3, 6, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFFFF'', -1, 2, ''#888888'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 100, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 2, 2, 2, 1, ''#888888'', 0, 5, 0, 5, 0, 5, 0, 5, 0, ''pointer'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_txt'', 1, ''Arial'', ''Verdana'', ''sans-serif'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_btn_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#form_div_btn'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#create_acct_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#my_account_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_txt'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000055'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:active'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#550000'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.form_submit_error_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 18, ''#ff0000'', -1, -1, -1, -1, ''-not selected-'', 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFF88'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.field_highlight'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 3, ''#FF0000'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', '<?php\r\n	include_once($captcha_includes_path);\r\n?>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id="ErrRequired" style="display: none;" class="form_submit_error_txt">\r\n    A required field has not been filled in. Please try again.\r\n</div>\r\n<div id="ErrEmail" style="display: none;" class="form_submit_error_txt">\r\n    Your email is blank or doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n<div id="ErrDuplicate" style="display: none;" class="form_submit_error_txt">\r\n    The email address you entered already exists in our system. Please try again.\r\n</div>\r\n<div id="ErrBadEmail" style="display: none;" class="form_submit_error_txt">\r\n    The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id="ErrCaptcha" style="display: none;" class="form_submit_error_txt">\r\n    The Captcha you entered does not match. Please try again.\r\n</div>\r\n            \r\n<form name="frmMailForm" id="frmMailForm" method="post" action="/php/formmail.php">\r\n  <div class="mail_form_div">\r\n    <table class="mail_form_table">\r\n        <tbody>\r\n\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Name (First, Last):</span></td>\r\n              <td class="mail_form_td"><input type="text" name="first_name" id="first_name" />\r\n                <input type="text" name="last_name" id="last_name" /> <span class="mail_form_large_text" style="color:#F00;"><b>* *</b></span></td>\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Address:\r\n              </span></td>\r\n                <td class="mail_form_td"><input name="address" type="text" id="address" size="50" /></td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">&nbsp;\r\n              </span></td>\r\n                <td class="mail_form_td"><input name="address2" type="text" id="address2" size="50" /></td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">City, State ZIP:\r\n                </span></td>\r\n              <td class="mail_form_td"><input name="city" type="text" id="city" />\r\n                , <select name="state" id="state" size="1">\r\n		<option >-not selected-</option>\r\n		<option value="Alabama" >Alabama</option>\r\n		<option value="Alaska" >Alaska</option>\r\n		<option value="Arizona" >Arizona</option>\r\n		<option value="Arkansas" >Arkansas</option>\r\n		<option value="California" >California</option>\r\n		<option value="Colorado" >Colorado</option>\r\n		<option value="Connecticut" >Connecticut</option>\r\n		<option value="Delaware" >Delaware</option>\r\n		<option value="Dist of Columbia" >Dist of Columbia</option>\r\n		<option value="Florida" >Florida</option>\r\n		<option value="Georgia" >Georgia</option>\r\n		<option value="Hawaii" >Hawaii</option>\r\n		<option value="Idaho" >Idaho</option>\r\n		<option value="Illinois" >Illinois</option>\r\n		<option value="Indiana" >Indiana</option>\r\n		<option value="Iowa" >Iowa</option>\r\n		<option value="Kansas" >Kansas</option>\r\n		<option value="Kentucky" >Kentucky</option>\r\n		<option value="Louisiana" >Louisiana</option>\r\n		<option value="Maine" >Maine</option>\r\n		<option value="Maryland" >Maryland</option>\r\n		<option value="Massachusetts" >Massachusetts</option>\r\n		<option value="Michigan" >Michigan</option>\r\n		<option value="Minnesota" >Minnesota</option>\r\n		<option value="Mississippi" >Mississippi</option>\r\n		<option value="Missouri" >Missouri</option>\r\n		<option value="Montana" >Montana</option>\r\n		<option value="Nebraska" >Nebraska</option>\r\n		<option value="Nevada" >Nevada</option>\r\n		<option value="New Hampshire" >New Hampshire</option>\r\n		<option value="New Jersey" >New Jersey</option>\r\n		<option value="New Mexico" >New Mexico</option>\r\n		<option value="New York" >New York</option>\r\n		<option value="North Carolina" >North Carolina</option>\r\n		<option value="North Dakota" >North Dakota</option>\r\n		<option value="Ohio" >Ohio</option>\r\n		<option value="Oklahoma" >Oklahoma</option>\r\n		<option value="Oregon" >Oregon</option>\r\n		<option value="Pennsylvania" >Pennsylvania</option>\r\n		<option value="Rhode Island" >Rhode Island</option>\r\n		<option value="South Carolina" >South Carolina</option>\r\n		<option value="South Dakota" >South Dakota</option>\r\n		<option value="Tennessee" >Tennessee</option>\r\n		<option value="Texas" >Texas</option>\r\n		<option value="Utah" >Utah</option>\r\n		<option value="Vermont" >Vermont</option>\r\n		<option value="Virginia" >Virginia</option>\r\n		<option value="Washington" >Washington</option>\r\n		<option value="West Virginia" >West Virginia</option>\r\n		<option value="Wisconsin" >Wisconsin</option>\r\n		<option value="Wyoming" >Wyoming</option>\r\n	</select> <input name="zip" type="text" id="zip" size="10">\r\n\r\n				\r\n			  </td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n			</tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Email:</span></td>\r\n                <td class="mail_form_td"><input name="email" type="text" id="email" size="50" /> <span class="mail_form_large_text" style="color:#F00;"><b>*</b></span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Email Confirm:</span></td>\r\n                <td class="mail_form_td"><input name="email_confirm" type="text" id="email_confirm" size="50" /> <span class="mail_form_large_text" style="color:#F00;"><b>*</b></span></td>\r\n\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Home Phone:</span></td>\r\n                <td class="mail_form_td"><input type="text" name="home_phone" id="home_phone" /><input type="radio" value="home" name="preferred_phone" id="preferred_phone[0]" /><span class="mail_form_small_text"> Preferred Phone</span></td>\r\n\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Work Phone:</span></td>\r\n                <td class="mail_form_td"><input type="text" name="work_phone" id="work_phone" /><input type="radio" value="work" name="preferred_phone" id="preferred_phone[1]" /><span class="mail_form_small_text"> Preferred Phone</span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Cell Phone:</span></td>\r\n\r\n                <td class="mail_form_td"><input type="text" name="cell_phone" id="cell_phone" /><input type="radio" value="cell" name="preferred_phone" id="preferred_phone[2]" /><span  class="mail_form_small_text"> Preferred Phone</span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Best time to call:\r\n                </span></td>\r\n                <td class="mail_form_td"><input type="radio" name="best_time" id="best_time[0]" value="day" /><span class="mail_form_large_text">Day</span> <input type="radio" name="best_time" id="best_time[1]" value="evening" /><span class="mail_form_large_text">Evening</span></td>\r\n\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Comments:</span></td>\r\n\r\n                <td class="mail_form_td"><textarea name="comments" id="comments" rows="5" cols="50"></textarea></td>\r\n            </tr>\r\n            <tr id="recaptcha_row">\r\n            	<td>&nbsp;</td>\r\n            	<td id="recaptcha_td">\r\n                  <script type="text/javascript" src="http://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT" id="recaptcha_script"></script>\r\n				  <noscript>\r\n					 <iframe src="http://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT"\r\n						 height="300" width="500" frameborder="0" id="captcha_iframe"></iframe><br>\r\n					 <textarea name="recaptcha_challenge_field" rows="3" cols="40">\r\n					 </textarea>\r\n					 <input type="hidden" name="recaptcha_response_field" id="recaptcha_response_field" value="manual_challenge">\r\n				  </noscript>\r\n               </td>\r\n            </tr>\r\n            <tr id="wscaptcha_row">\r\n                <td>&nbsp;</td>\r\n                <td class="mail_form_td_field_title" style="vertical-align: bottom;">\r\n                  <table>\r\n                  <tr>\r\n                  <td width="200">\r\n                  <img alt="wspcaptcha" border="0" id="wspcaptcha" src="wspcaptcha.php" /> \r\n                  </td>\r\n                  <td valign="bottom" align="left" width="100%">\r\n                  <a href="javascript:void(0);" onclick="document.getElementById(''wspcaptcha'').src=''wspcaptcha.php?t=''+(new Date()).getTime(); return false;">\r\n                  <img alt="Reload" border="0" src="/images/reload.gif" /></a>\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td_field_title" style="vertical-align: bottom;" colspan="2">\r\n                  <input name="wsp_code" id="wsp_code" style="width:120px;" type="text" value="" class="text_box" />\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td" colspan="2">\r\n                  Type in the letters you see <span class="mail_form_large_text"><span class="required_fields"><b>*</b></span></span>\r\n                  </td>\r\n                  </table>\r\n                </td>\r\n            </tr>\r\n            <tr id="mollomcaptcha_row">\r\n            	<td>&nbsp;</td>\r\n            	<td align="left">\r\n                  <div id="mollom_captcha">&nbsp;</div>\r\n                  <input type="hidden" name="mollom_session" id="mollom_session" />\r\n                  <input type="text" name="captcha_response_field" id="captcha_response_field" size="10" value="" autocomplete="off" />\r\n                  <span class="mail_form_small_text">Type the characters you see in this picture</span>\r\n               </td>\r\n            </tr>\r\n			<tr>\r\n            	<td colspan="2">\r\n                  <table width="100%" border="0"><tr>\r\n                    <td align="right" width="55%">\r\n                    <div id="form_div_btn" class="btn_div" onClick="document.getElementById(''frmMailForm'').submit();"><span id="form_btn_txt" class="btn_txt">Submit</span></div>\r\n                    </td>\r\n                    <td align="right"><span style="color:#F00;"><span class="mail_form_large_text"><b>*</b></span> <span class="mail_form_small_text">required fields</span></span></td>\r\n                  </tr></table>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n    <input type="hidden" name="redirect" id="redirect" value="/contact_return.php" />\r\n    <input type="hidden" name="subject" id="subject" value="Information Request" />\r\n    <input type="hidden" name="from" id="from" value="contactform@example.com" />\r\n    <input type="hidden" name="recipient" id"recipient" value="recipient@example.com" />\r\n    <input type="hidden" name="email_required" id="email_required" value="1" />\r\n    <input type="hidden" name="required_fields" id="required_fields" value="first_name,last_name" />\r\n    <input type="hidden" name="html_message_page" id="html_message_page" value="contact_return_message" />\r\n    <input type="hidden" name="table_name" id="table_name" value="contacts" />\r\n    <input type="hidden" name="use_captcha" id="use_captcha" value="1" />\r\n    <input type="hidden" name="captcha_type" id="captcha_type" value="recaptcha" />\r\n    <input id="alt_go_back" name="alt_go_back" type="hidden" />\r\n    <input id="redirect_err_to_src" name="redirect_err_to_src" type="hidden" value="1" />\r\n  </div>\r\n</form>', NULL, NULL, NULL, NULL, '<?php\r\n	include_once($captcha_includes_path2);\r\n?>', '<script language="JavaScript" type="text/JavaScript">\r\n	var php_path_rel = php_dir_rel + "formmail.php";\r\n	if (document.getElementById("frmMailForm").action == "")\r\n		document.getElementById("frmMailForm").action = php_path_rel;\r\n	\r\n	var redirect_path = document.getElementById("redirect").value;\r\n	if (redirect_path == "")\r\n		redirect_path = redirect;\r\n	var redirect_path_arr = redirect_path.split("/");\r\n	var redirect_file = "";\r\n	for(var i in redirect_path_arr)\r\n	{\r\n		if ((redirect_path_arr[i].indexOf(".php")) > 0)\r\n			redirect_file = redirect_path_arr[i];\r\n	}\r\n	redirect_path = webpage_dir + redirect_file;\r\n	document.getElementById("redirect").value = redirect_path;\r\n	\r\n	var alt_go_back = webpage_dir + this_page;\r\n	if (document.getElementById("alt_go_back").value == "")\r\n		document.getElementById("alt_go_back").value = alt_go_back;\r\n		\r\n	document.getElementById("recaptcha_row").style.display = "none";\r\n	document.getElementById("wscaptcha_row").style.display = "none";\r\n	document.getElementById("mollomcaptcha_row").style.display = "none";\r\n	if (document.getElementById("use_captcha").value == 1)\r\n	{\r\n		if (document.getElementById("captcha_type").value == "recaptcha")\r\n			document.getElementById("recaptcha_row").style.display = "table-row";\r\n		else if (document.getElementById("captcha_type").value == "wscaptcha")\r\n			document.getElementById("wscaptcha_row").style.display = "table-row";\r\n		else if (document.getElementById("captcha_type").value == "mollom")\r\n			document.getElementById("mollomcaptcha_row").style.display = "table-row";\r\n	}\r\n\r\n	\r\n	//////////////////////////////////////////////////////////////////////////////////////////////\r\n	function ReadGetVar(variable)\r\n	{\r\n		var query = window.location.search.substring(1);\r\n		var vars = query.split("&");\r\n		for (var i=0;i<vars.length;i++) {\r\n		   var pair = vars[i].split("=");\r\n		   if(pair[0] == variable)	{\r\n			   return pair[1];\r\n		   }\r\n		}\r\n		return("");\r\n	}\r\n	\r\n	function replaceAll(txt, search_str, replace_str) {\r\n  		return txt.replace(new RegExp(search_str, ''g''),replace_str);\r\n	}\r\n	\r\n	// Go thru all forms and get all elements and check for go-back values to re-populate.\r\n	var frm_cnt = document.forms.length;\r\n	var el_cnt = 0;\r\n	var el;\r\n	for (i = 0; i < frm_cnt; i++)\r\n	{\r\n		el_cnt = document.forms[i].elements.length;\r\n		for (j = 0; j < el_cnt; j++)\r\n		{\r\n			el = document.forms[i].elements[j];\r\n			if ((el.type == "text") && (el.name != "password") && (el.name != "password_confirm"))	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.value = replaceAll(tmp, "%20", " ");\r\n			}\r\n			else if (el.type == "textarea")	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.innerHTML = replaceAll(tmp, "%20", " ");\r\n			}\r\n			else if (el.type == "checkbox")	{\r\n				if (ReadGetVar(el.name) != "")\r\n					el.checked = true;\r\n			}\r\n			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.value = replaceAll(tmp, "%20", " ");\r\n			}\r\n		}\r\n	}\r\n	\r\n	//////////////////////////////////////////////////////////////////////////////////////////\r\n	var err = ReadGetVar("err");\r\n	var field;\r\n\r\n	if ((err != undefined) && (err != ""))\r\n	{\r\n		if (err == "required")	{\r\n			document.getElementById("ErrRequired").style.display = "block";\r\n			field = ReadGetVar("field");\r\n			document.getElementById(field).focus();\r\n			document.getElementById(field).className = "field_highlight";\r\n		}\r\n		else if(err == "email")	{\r\n			document.getElementById("ErrEmail").style.display="block";\r\n			document.getElementById("email").focus();\r\n			document.getElementById("email").className = "field_highlight";\r\n			document.getElementById("email_confirm").className = "field_highlight";\r\n		}\r\n		else if(err == "bad_email")	{\r\n			document.getElementById("ErrBadEmail").style.display="block";\r\n			document.getElementById("email").focus();\r\n			document.getElementById("email").className = "field_highlight";\r\n		}\r\n		else if(err == "duplicate")	{\r\n			document.getElementById("ErrDuplicate").style.display="block";\r\n			field = ReadGetVar("field");\r\n			document.getElementById(field).focus();\r\n			document.getElementById(field).className = "field_highlight";\r\n		}\r\n		else if(err == "captcha")	{\r\n			document.getElementById("ErrCaptcha").style.display="block";\r\n			var captcha_type = document.getElementById("captcha_type").value;\r\n			if (captcha_type == "recaptcha")\r\n				document.getElementById("recaptcha_td").className = "field_highlight";\r\n			else if (captcha_type == "wscaptcha")\r\n				document.getElementById("wsp_code").className = "field_highlight";\r\n			else if (captcha_type == "mollom")\r\n				document.getElementById("captcha_response_field").className = "field_highlight";\r\n		}\r\n	}\r\n		\r\n</script>', './plugins/edit_form_recipients.php', 'Edit Form Recipients', 'images/icon_Edit-Email.png', 'images/icon_Edit-Email_mo.png', 'images/icon_Edit-Email_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#mail_form', 'CREATE TABLE IF NOT EXISTS `form_recipients` (\r\n  `page_name` varchar(255) NOT NULL,\r\n  `recipient` varchar(255) NOT NULL,\r\n  PRIMARY KEY (`page_name`)\r\n) ENGINE=MyISAM DEFAULT CHARSET=latin1;', NULL, 0, 1, 0, 31);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(27, 'Account Creation Form', 'Account Creation Form with user ID and password fields, auto-table creation, CAPTCHA, and custom response email and return page.', 'User Access Forms', 'mail_form', 'Mail Form Styles', 'INSERT INTO `bwb_mail_form_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''.mail_form_table'', ''Mail Form Table'', 10, 0, 0),\r\n(''.mail_form_td'', ''Mail Form Table Cell'', 20, 0, 0),\r\n(''.mail_form_td_field_title'', ''Mail Form Cell for Field Title'', 30, 0, 0),\r\n(''.mail_form_large_text'', ''Mail Form Text'', 40, 0, 0),\r\n(''.mail_form_small_text'', ''Mail Form Text (small)'', 50, 0, 0),\r\n(''.mail_form_div'', ''Mail Form Div'', 5, 0, 0),\r\n(''.btn_div'', ''Submit Button'', 60, 0, 0),\r\n(''.btn_txt'', ''Submit Button Text'', 70, 0, 0),\r\n(''.link_div'', ''User Account Link'', 80, 0, 0),\r\n(''.link_div a:link'', ''User Account Link Link'', 82, 0, 0),\r\n(''.link_div a:visited'', ''User Account Lisk Visited'', 84, 0, 0),\r\n(''.link_div a:hover'', ''User Account Link Hover'', 86, 0, 0),\r\n(''.link_div a:active'', ''User Account Link Active'', 88, 0, 0),\r\n(''.link_txt'', ''User Account Link Text'', 90, 0, 0),\r\n(''#form_div_btn'', ''Form Submit Button'', 100, 0, 0),\r\n(''#form_btn_txt'', ''Form Submit Button Text'', 110, 0, 0),\r\n(''#login_logout'', ''Login Logout Div'', 120, 0, 0),\r\n(''#logout_div_btn'', ''Logout Button'', 130, 0, 0),\r\n(''#logout_btn_txt'', ''Logout Button Text'', 140, 0, 0),\r\n(''#create_acct_div_btn'', ''Create Account Button'', 150, 0, 0),\r\n(''#create_acct_btn_txt'', ''Create Account Button Text'', 160, 0, 0),\r\n(''#generate_pass_div_btn'', ''Generate Password Button'', 150, 0, 0),\r\n(''#generate_pass_btn_txt'', ''Generate Password Button Text'', 170, 0, 0),\r\n(''#login_div_btn'', ''Login Button'', 180, 0, 0),\r\n(''#login_btn_txt'', ''Login Button Text'', 190, 0, 0),\r\n(''#reset_pass_div_btn'', ''Reset Password Button'', 200, 0, 0),\r\n(''#reset_pass_btn_txt'', ''Reset Password Button Text'', 210, 0, 0),\r\n(''#my_account_div_btn'', ''My Account Button'', 220, 0, 0),\r\n(''#my_account_btn_txt'', ''My Account Button Text'', 230, 0, 0),\r\n(''.form_submit_error_txt'', ''Form Submit Error Text'', 240, 0, 0),\r\n(''.field_highlight'', ''Form Submit Field Highlight'', 250, 0, 0);', 'INSERT INTO `bwb_mail_form_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n(''.mail_form_table'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 1, ''#eeeeee'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 1, -1000000, 0, 1, -1000000, 0, 0, ''-not selected-'', 90, 1, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_td'', 1, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_large_text'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.mail_form_small_text'', 1, ''-not selected-'', NULL, NULL, 12, ''-not set-'', -1, -1, -1, -1, ''normal'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_div'', 0, ''-not selected-'', NULL, NULL, -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', NULL, NULL, NULL, 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, '''', -1, 0, '''', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, -1, -1, -1, -1, -1, -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not set-'', NULL, NULL, NULL, NULL, -1000000, -1000000, -1, -1000000, NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''.mail_form_td_field_title'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''left'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 150, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_logout'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 160, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_div'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 3, 6, 3, 6, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFFFF'', -1, 2, ''#888888'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 100, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 2, 2, 2, 1, ''#888888'', 0, 5, 0, 5, 0, 5, 0, 5, 0, ''pointer'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.btn_txt'', 1, ''Arial'', ''Verdana'', ''sans-serif'', 14, ''-not set-'', -1, -1, -1, -1, ''bold'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_btn_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#form_div_btn'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#create_acct_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#login_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#my_account_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#logout_div_btn'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 5, 0, 0, 10, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''right'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_txt'', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:link'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:visited'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000000'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:hover'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#000055'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.link_div a:active'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''#550000'', -1, -1, -1, -1, ''-not selected-'', 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.form_submit_error_txt'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', 18, ''#ff0000'', -1, -1, -1, -1, ''-not selected-'', 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''center'', ''-not selected-'', -1, -1, ''#FFFF88'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''.field_highlight'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, 3, ''#FF0000'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', '<?php\r\n	include_once($captcha_includes_path);\r\n?>', '<script language="javascript" type="text/javascript">\r\nfunction GeneratePassword()\r\n{\r\n	var password = "";\r\n	var password_length = rand(6,10);\r\n	var i;\r\n	var assci_segment;\r\n	\r\n	for (i = 0; i < password_length; i++)\r\n	{\r\n		assci_segment = rand(1,3);\r\n		if (assci_segment == 1)\r\n			password = password + String.fromCharCode(rand(48,57));	// numeric\r\n		else if (assci_segment == 2)\r\n			password = password + String.fromCharCode(rand(65,90));	// alpha upper case\r\n		else\r\n			password = password + String.fromCharCode(rand(97,122));	// alpha lower case\r\n	}\r\n	password = password.replace(''I'', ''i'');\r\n	password = password.replace(''O'', ''o'');\r\n	password = password.replace(''l'', ''L'');\r\n	\r\n	document.getElementById(''password'').value = password;\r\n	document.getElementById(''password_confirm'').value = password;\r\n		\r\n	return password;\r\n}\r\n\r\n// Equivalent to PHP rand(min, max);\r\nfunction rand ( n, m )\r\n{\r\n  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );\r\n}\r\n</script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<div id="ErrRequired" style="display: none;" class="form_submit_error_txt">\r\n    A required field has not been filled in. Please try again.\r\n</div>\r\n<div id="ErrEmail" style="display: none;" class="form_submit_error_txt">\r\n    Your email is blank or doesn&#39;t match the confirm. Please try again.\r\n</div>\r\n<div id="ErrDuplicate" style="display: none;" class="form_submit_error_txt">\r\n    The email address you entered already exists in our system. Please try again.\r\n</div>\r\n<div id="ErrBadEmail" style="display: none;" class="form_submit_error_txt">\r\n    The email address you entered is not a valid email address. Please try again.\r\n</div>\r\n<div id="ErrTooShort" style="display: none;" class="form_submit_error_txt">\r\n    Your password must be at least 8 characters long and contain a mix of letters and numbers (or special characters) Please try again.\r\n</div>\r\n<div id="ErrTooWeak" style="display: none;" class="form_submit_error_txt">\r\n    Your password must be at least 8 characters long and contain a mix of letters and numbers (or special characters) Please try again.\r\n</div>\r\n<div id="ErrNoMatch" style="display: none;" class="form_submit_error_txt">\r\n    Your password is blank or does not match the confirmation password. Please try again.\r\n</div>\r\n<div id="ErrCaptcha" style="display: none;" class="form_submit_error_txt">\r\n    The Captcha you entered does not match. Please try again.\r\n</div>\r\n            \r\n<form name="frmAccountCreateForm" id="frmAccountCreateForm" method="post" action="/php/formmail.php">\r\n  <div class="mail_form_div">\r\n    <table class="mail_form_table">\r\n        <tbody>\r\n\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Name (First, Last):</span></td>\r\n              <td class="mail_form_td"><input type="text" name="first_name" id="first_name" />\r\n                <input type="text" name="last_name" id="last_name" /> <span class="mail_form_large_text" style="color:#F00;"><b>* *</b></span></td>\r\n            </tr>\r\n			<tr>\r\n			  <td class="mail_form_td_field_title"><span class="mail_form_large_text">User ID: </span></td>\r\n			  <td class="mail_form_td"><input type="text" name="UserID" id="UserID" />\r\n              <span class="mail_form_large_text" style="color:#F00;"><b> *</b></span></td>\r\n		  </tr>\r\n			<tr>\r\n			  <td class="mail_form_td_field_title"><span class="mail_form_large_text">Password, Confirm: </span></td>\r\n			  <td class="mail_form_td"><input type="text" name="password" id="password" /> <input type="text" name="password_confirm" id="password_confirm" />\r\n              <span class="mail_form_large_text" style="color:#F00;"><b>* *</b></span>\r\n                <div id="generate_pass_div_btn" class="btn_div" onClick="GeneratePassword();"><span id="generate_pass_btn_txt" class="btn_txt">Generate Password</span></div>\r\n              </td>\r\n		  </tr>\r\n			<tr>\r\n			  <td class="mail_form_td_field_title">&nbsp;</td>\r\n			  <td class="mail_form_td">&nbsp;</td>\r\n		  </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Address:\r\n              </span></td>\r\n                <td class="mail_form_td"><input name="address" type="text" id="address" size="50" /></td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">&nbsp;\r\n              </span></td>\r\n                <td class="mail_form_td"><input name="address2" type="text" id="address2" size="50" /></td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">City, State ZIP:\r\n                </span></td>\r\n              <td class="mail_form_td"><input name="city" type="text" id="city" />\r\n                , <select name="state" id="state" size="1">\r\n		<option >-not selected-</option>\r\n		<option value="Alabama" >Alabama</option>\r\n		<option value="Alaska" >Alaska</option>\r\n		<option value="Arizona" >Arizona</option>\r\n		<option value="Arkansas" >Arkansas</option>\r\n		<option value="California" >California</option>\r\n		<option value="Colorado" >Colorado</option>\r\n		<option value="Connecticut" >Connecticut</option>\r\n		<option value="Delaware" >Delaware</option>\r\n		<option value="Dist of Columbia" >Dist of Columbia</option>\r\n		<option value="Florida" >Florida</option>\r\n		<option value="Georgia" >Georgia</option>\r\n		<option value="Hawaii" >Hawaii</option>\r\n		<option value="Idaho" >Idaho</option>\r\n		<option value="Illinois" >Illinois</option>\r\n		<option value="Indiana" >Indiana</option>\r\n		<option value="Iowa" >Iowa</option>\r\n		<option value="Kansas" >Kansas</option>\r\n		<option value="Kentucky" >Kentucky</option>\r\n		<option value="Louisiana" >Louisiana</option>\r\n		<option value="Maine" >Maine</option>\r\n		<option value="Maryland" >Maryland</option>\r\n		<option value="Massachusetts" >Massachusetts</option>\r\n		<option value="Michigan" >Michigan</option>\r\n		<option value="Minnesota" >Minnesota</option>\r\n		<option value="Mississippi" >Mississippi</option>\r\n		<option value="Missouri" >Missouri</option>\r\n		<option value="Montana" >Montana</option>\r\n		<option value="Nebraska" >Nebraska</option>\r\n		<option value="Nevada" >Nevada</option>\r\n		<option value="New Hampshire" >New Hampshire</option>\r\n		<option value="New Jersey" >New Jersey</option>\r\n		<option value="New Mexico" >New Mexico</option>\r\n		<option value="New York" >New York</option>\r\n		<option value="North Carolina" >North Carolina</option>\r\n		<option value="North Dakota" >North Dakota</option>\r\n		<option value="Ohio" >Ohio</option>\r\n		<option value="Oklahoma" >Oklahoma</option>\r\n		<option value="Oregon" >Oregon</option>\r\n		<option value="Pennsylvania" >Pennsylvania</option>\r\n		<option value="Rhode Island" >Rhode Island</option>\r\n		<option value="South Carolina" >South Carolina</option>\r\n		<option value="South Dakota" >South Dakota</option>\r\n		<option value="Tennessee" >Tennessee</option>\r\n		<option value="Texas" >Texas</option>\r\n		<option value="Utah" >Utah</option>\r\n		<option value="Vermont" >Vermont</option>\r\n		<option value="Virginia" >Virginia</option>\r\n		<option value="Washington" >Washington</option>\r\n		<option value="West Virginia" >West Virginia</option>\r\n		<option value="Wisconsin" >Wisconsin</option>\r\n		<option value="Wyoming" >Wyoming</option>\r\n	</select> <input name="zip" type="text" id="zip" size="10">\r\n\r\n				\r\n				</td>\r\n\r\n            </tr>\r\n			<tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n			</tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Email:</span></td>\r\n                <td class="mail_form_td"><input name="email" type="text" id="email" size="50" />\r\n                  <span class="mail_form_large_text" style="color:#F00;"><b> *</b></span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Email Confirm:</span></td>\r\n                <td class="mail_form_td"><input name="email_confirm" type="text" id="email_confirm" size="50" /> <span class="mail_form_large_text" style="color:#F00;"><b>*</b></span></td>\r\n\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Home Phone:</span></td>\r\n                <td class="mail_form_td"><input type="text" name="home_phone" id="home_phone" /><input type="radio" value="home" name="preferred_phone" id="preferred_phone[0]" /><span class="mail_form_small_text"> Preferred Phone</span></td>\r\n\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Work Phone:</span></td>\r\n                <td class="mail_form_td"><input type="text" name="work_phone" id="work_phone" /><input type="radio" value="work" name="preferred_phone" id="preferred_phone[1]" /><span class="mail_form_small_text"> Preferred Phone</span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Cell Phone:</span></td>\r\n\r\n                <td class="mail_form_td"><input type="text" name="cell_phone" id="cell_phone" /><input type="radio" value="cell" name="preferred_phone" id="preferred_phone[2]" /><span  class="mail_form_small_text"> Preferred Phone</span></td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title"><span class="mail_form_large_text">Best time to call:\r\n                </span></td>\r\n                <td class="mail_form_td"><input type="radio" name="best_time" id="best_time[0]" value="day" /><span class="mail_form_large_text">Day</span> <input type="radio" name="best_time" id="best_time[1]" value="evening" /><span class="mail_form_large_text">Evening</span></td>\r\n\r\n            </tr>\r\n            <tr id="recaptcha_row">\r\n            	<td>&nbsp;</td>\r\n            	<td id="recaptcha_td">\r\n                  <script type="text/javascript" src="http://www.google.com/recaptcha/api/challenge?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT" id="recaptcha_script"></script>\r\n				  <noscript>\r\n					 <iframe src="http://www.google.com/recaptcha/api/noscript?k=6LeGudMSAAAAAOkRJtut9PVOFIxedHgutbY-i1XT"\r\n						 height="300" width="500" frameborder="0" id="captcha_iframe"></iframe><br>\r\n					 <textarea name="recaptcha_challenge_field" rows="3" cols="40">\r\n					 </textarea>\r\n					 <input type="hidden" name="recaptcha_response_field" id="recaptcha_response_field" value="manual_challenge">\r\n				  </noscript>\r\n               </td>\r\n            </tr>\r\n            <tr id="wscaptcha_row">\r\n                <td>&nbsp;</td>\r\n                <td class="mail_form_td_field_title" style="vertical-align: bottom;">\r\n                  <table>\r\n                  <tr>\r\n                  <td width="200">\r\n                  <img alt="wspcaptcha" border="0" id="wspcaptcha" src="wspcaptcha.php" /> \r\n                  </td>\r\n                  <td valign="bottom" align="left" width="100%">\r\n                  <a href="javascript:void(0);" onclick="document.getElementById(''wspcaptcha'').src=''wspcaptcha.php?t=''+(new Date()).getTime(); return false;">\r\n                  <img alt="Reload" border="0" src="/images/reload.gif" /></a>\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td_field_title" style="vertical-align: bottom;" colspan="2">\r\n                  <input name="wsp_code" style="width:120px;" type="text" value="" class="text_box" />\r\n                  </td>\r\n                  </tr>\r\n                  <tr>\r\n                  <td class="mail_form_td" colspan="2">\r\n                  Type in the letters you see <span class="mail_form_large_text"><span class="required_fields"><b>*</b></span></span>\r\n                  </td>\r\n                  </table>\r\n                </td>\r\n            </tr>\r\n            <tr id="mollomcaptcha_row">\r\n            	<td>&nbsp;</td>\r\n            	<td align="left">\r\n                  <div id="mollom_captcha">&nbsp;</div>\r\n                  <input type="hidden" name="mollom_session" id="mollom_session" />\r\n                  <input type="text" name="captcha_response_field" id="captcha_response_field" size="10" value="" autocomplete="off" />\r\n                  <span class="mail_form_small_text">Type the characters you see in this picture</span>\r\n               </td>\r\n            </tr>\r\n            <tr>\r\n                <td class="mail_form_td_field_title" colspan="2">&nbsp;</td>\r\n            </tr>\r\n			<tr>\r\n            	<td colspan="2">\r\n                  <table width="100%" border="0"><tr>\r\n                    <td align="right" width="55%">\r\n                    <div id="create_acct_div_btn" class="btn_div" onClick="document.getElementById(''frmAccountCreateForm'').submit();"><span id="create_acct_btn_txt" class="btn_txt">Submit</span></div>\r\n                    </td>\r\n                    <td align="right"><span style="color:#F00;"><span class="mail_form_large_text"><b>*</b></span> <span class="mail_form_small_text">required fields</span></span></td>\r\n                  </tr></table>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n    <input type="hidden" name="redirect" id="redirect" value="/account_create_return.php" />\r\n    <input type="hidden" name="subject" id="subject" value="Create Account" />\r\n    <input type="hidden" name="from" id="from" value="accountcreateform@example.com" />\r\n    <input type="hidden" name="recipient" id="recipient" value="recipient@example.com" />\r\n    <input type="hidden" name="email_required" id="email_required" value="1" />\r\n    <input type="hidden" name="password_required" id="password_required" value="1" />\r\n    <input type="hidden" name="required_fields" id="required_fields" value="first_name,last_name,UserID" />\r\n    <input type="hidden" name="html_message_page" id="html_message_page" value="account_create_return_message" />\r\n    <input type="hidden" name="table_name" id="table_name" value="accounts" />\r\n    <input type="hidden" name="AccessLevel" id="AccessLevel" />\r\n    <input type="hidden" name="use_captcha" id="use_captcha" value="1" />\r\n    <input type="hidden" name="captcha_type" id="captcha_type" value="recaptcha" />\r\n    <input id="alt_go_back" name="alt_go_back" type="hidden" />\r\n    <input id="redirect_err_to_src" name="redirect_err_to_src" type="hidden" value="1" />\r\n  </div>\r\n</form>', NULL, NULL, NULL, NULL, '<?php\r\n	include_once($captcha_includes_path2);\r\n?>', '<script language="JavaScript" type="text/JavaScript">\r\n	var php_path_rel = php_dir_rel + "formmail.php";\r\n	if (document.getElementById("frmAccountCreateForm").action == "")\r\n		document.getElementById("frmAccountCreateForm").action = php_path_rel;\r\n		\r\n	var redirect_path = document.getElementById("redirect").value;\r\n	if (redirect_path == "")\r\n		redirect_path = redirect;\r\n	var redirect_path_arr = redirect_path.split("/");\r\n	var redirect_file = "";\r\n	for(var i in redirect_path_arr)\r\n	{\r\n		if ((redirect_path_arr[i].indexOf(".php")) > 0)\r\n			redirect_file = redirect_path_arr[i];\r\n	}\r\n	redirect_path = webpage_dir + redirect_file;\r\n	document.getElementById("redirect").value = redirect_path;\r\n		\r\n	var alt_go_back = webpage_dir + this_page;\r\n	if (document.getElementById("alt_go_back").value == "")\r\n		document.getElementById("alt_go_back").value = alt_go_back;\r\n		\r\n	document.getElementById("recaptcha_row").style.display = "none";\r\n	document.getElementById("wscaptcha_row").style.display = "none";\r\n	document.getElementById("mollomcaptcha_row").style.display = "none";\r\n	if (document.getElementById("use_captcha").value == 1)\r\n	{\r\n		if (document.getElementById("captcha_type").value == "recaptcha")\r\n			document.getElementById("recaptcha_row").style.display = "table-row";\r\n		else if (document.getElementById("captcha_type").value == "wscaptcha")\r\n			document.getElementById("wscaptcha_row").style.display = "table-row";\r\n		else if (document.getElementById("captcha_type").value == "mollom")\r\n			document.getElementById("mollomcaptcha_row").style.display = "table-row";\r\n	}\r\n\r\n		\r\n	//////////////////////////////////////////////////////////////////////////////////////////////\r\n	function ReadGetVar(variable)\r\n	{\r\n		var query = window.location.search.substring(1);\r\n		var vars = query.split("&");\r\n		for (var i=0;i<vars.length;i++) {\r\n		   var pair = vars[i].split("=");\r\n		   if(pair[0] == variable)	{\r\n			   return pair[1];\r\n		   }\r\n		}\r\n		return("");\r\n	}\r\n	\r\n	function replaceAll(txt, search_str, replace_str) {\r\n  		return txt.replace(new RegExp(search_str, ''g''),replace_str);\r\n	}\r\n	\r\n	// Go thru all forms and get all elements and check for go-back values to re-populate.\r\n	var frm_cnt = document.forms.length;\r\n	var el_cnt = 0;\r\n	var el;\r\n	var tmp;\r\n	for (i = 0; i < frm_cnt; i++)\r\n	{\r\n		el_cnt = document.forms[i].elements.length;\r\n		for (j = 0; j < el_cnt; j++)\r\n		{\r\n			el = document.forms[i].elements[j];\r\n			if ((el.type == "text") && (el.name != "password") && (el.name != "password_confirm"))	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.value = replaceAll(tmp, "%20", " ");\r\n			}\r\n			else if (el.type == "textarea")	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.innerHTML = replaceAll(tmp, "%20", " ");\r\n			}\r\n			else if (el.type == "checkbox")	{\r\n				if (ReadGetVar(el.name) != "")\r\n					el.checked = true;\r\n			}\r\n			else if ((el.type == "select-one") || (el.type == "select-multiple"))	{\r\n				tmp = ReadGetVar(el.name);\r\n				el.value = replaceAll(tmp, "%20", " ");\r\n			}\r\n		}\r\n	}\r\n	\r\n	//////////////////////////////////////////////////////////////////////////////////////////\r\n	var err = ReadGetVar("err");\r\n\r\n	if ((err != undefined) && (err != ""))\r\n	{\r\n		if (err == "too_short")	{\r\n			document.getElementById("ErrTooShort").style.display = "block";\r\n			document.getElementById("password").focus();\r\n			document.getElementById("password").className = "field_highlight";\r\n		}\r\n		else if (err == "too_weak") {\r\n			document.getElementById("ErrTooWeak").style.display = "block";\r\n			document.getElementById("password").focus();\r\n			document.getElementById("password").className = "field_highlight";\r\n		}\r\n		else if (err == "no_match")	{\r\n			document.getElementById("ErrNoMatch").style.display = "block";\r\n			document.getElementById("password").focus();\r\n			document.getElementById("password").className = "field_highlight";\r\n			document.getElementById("password_confirm").className = "field_highlight";\r\n		}\r\n		else if (err == "required")	{\r\n			document.getElementById("ErrRequired").style.display = "block";\r\n			field = ReadGetVar("field");\r\n			document.getElementById(field).className = "field_highlight";\r\n		}\r\n		else if(err == "email")	{\r\n			document.getElementById("ErrEmail").style.display="block";\r\n			document.getElementById("email").focus();\r\n			document.getElementById("email").className = "field_highlight";\r\n			document.getElementById("email_confirm").className = "field_highlight";\r\n		}\r\n		else if(err == "bad_email")	{\r\n			document.getElementById("ErrBadEmail").style.display="block";\r\n			document.getElementById("email").focus();\r\n			document.getElementById("email").className = "field_highlight";\r\n		}\r\n		else if(err == "duplicate")	{\r\n			document.getElementById("ErrDuplicate").style.display="block";\r\n			field = ReadGetVar("field");\r\n			document.getElementById(field).className = "field_highlight";\r\n		}\r\n		else if(err == "captcha")	{\r\n			document.getElementById("ErrCaptcha").style.display="block";\r\n			if (captcha_type == "recaptcha")\r\n				document.getElementById("recaptcha_td").className = "field_highlight";\r\n			else if (captcha_type == "wscaptcha")\r\n				document.getElementById("wsp_code").className = "field_highlight";\r\n			else if (captcha_type == "mollom")\r\n				document.getElementById("captcha_response_field").className = "field_highlight";\r\n		}\r\n	}\r\n	\r\n	////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n	function ShowPasswordReset()\r\n	{ \r\n		document.getElementById("reset_password_form").style.display="inline";\r\n		\r\n		if ((document.getElementById("captcha_type").value == "recaptcha") && (document.getElementById("use_captcha").value == 1))\r\n		{\r\n			var captcha_challange_url = "http://www.google.com/recaptcha/api/challenge?k=" + recaptcha_public_key;\r\n			var oldScript = document.getElementById("recaptcha_script");\r\n			var script = document.createElement("tmp");        \r\n			script.setAttribute("type","text/javascript");                \r\n			script.setAttribute("id","recaptcha_script");\r\n			script.setAttribute("src",captcha_challange_url);\r\n			\r\n			if (oldScript == null) {               \r\n				document.body.appendChild(script);\r\n			} else {\r\n				document.body.replaceChild(script, oldScript);\r\n			}\r\n		}\r\n	}\r\n</script>', './plugins/edit_form_recipients.php', 'Edit Form Recipients', 'images/icon_Edit-Email.png', 'images/icon_Edit-Email_mo.png', 'images/icon_Edit-Email_mo.png', 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#account_creation_form', 'CREATE TABLE IF NOT EXISTS `form_recipients` (\r\n  `page_name` varchar(255) NOT NULL,\r\n  `recipient` varchar(255) NOT NULL,\r\n  PRIMARY KEY (`page_name`)\r\n) ENGINE=MyISAM DEFAULT CHARSET=latin1;', NULL, 0, 1, 0, 34);
INSERT INTO `bwb_plugins` (`id`, `name`, `description`, `category`, `style_sheet`, `style_sheet_description`, `class_sql`, `css_sql`, `head_code`, `head_html`, `header_code`, `header_html`, `top_code`, `top_html`, `left_code`, `left_html`, `content_code`, `content_html`, `right_code`, `right_html`, `bottom_code`, `bottom_html`, `footer_code`, `footer_html`, `console_path`, `console_link_text`, `console_link_image`, `console_link_image_mo`, `console_link_image_down`, `help_path`, `plugin_sql`, `AccessLevel`, `deployed`, `available`, `disable_site_styles`, `sort_order`) VALUES
(25, 'Horizontal Scrolling Slideshow', 'Horizontal Scrolling Slideshow (Works with pictures or text)', 'Slideshows', 'scrolling_slideshow', 'Scrolling Slideshow Styles', 'INSERT INTO `bwb_scrolling_slideshow_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES\r\n(''#slideshow'', ''Slideshow Div'', 10, 0, 0),\r\n(''#slideshow ul'', ''Slideshow UL'', 20, 0, 0),\r\n(''#slideshow ul:after'', ''Slideshow UL:after'', 30, 0, 0),\r\n(''#slideshow .slides'', ''Slideshow Slides'', 40, 0, 0),\r\n(''#slideshow .slides ul'', ''Slideshow Slides UL'', 50, 0, 0),\r\n(''#slideshow .slides li'', ''Slideshow Slides LI'', 60, 0, 0),\r\n(''#slideshow .slides h2'', ''Slideshow Slides H2'', 70, 0, 0),\r\n(''#slideshow .slides-nav'', ''Slideshow Slides Navigation'', 80, 0, 0),\r\n(''#slideshow .slides-nav li'', ''Slideshow Slides Navigation LI'', 90, 0, 0),\r\n(''#slideshow .slides-nav li a'', ''Slideshow Slides Navigation LI Link'', 100, 0, 0),\r\n(''#slideshow .slides-nav li.on'', ''Slideshow Slides Navigation Tab'', 110, 0, 0),\r\n(''#slideshow .slides-nav li.on a'', ''Slideshow Slides Navigation Tab Link'', 120, 0, 0),\r\n(''#prev'', ''Previous Slide Nav Div'', 130, 500, 1),\r\n(''#prev:hover'', ''Previous Slide Nav Div Hover'', 135, 500, 1),\r\n(''#next'', ''Next Slide Nav Div'', 140, 500, 1),\r\n(''#next:hover'', ''Next Slide Nav Div Hover'', 145, 500, 1),\r\n(''#pause'', ''Pause Slideshow Nav Div'', 150, 500, 1),\r\n(''#pause:hover'', ''Pause Slideshow Nav Div Hover'', 155, 500, 1),\r\n(''#resume'', ''Resume Slideshow Nav Div'', 160, 500, 1),\r\n(''#resume:hover'', ''Resume Slideshow Nav Div Hover'', 165, 500, 1);', 'INSERT INTO `bwb_scrolling_slideshow_css` (`class`, `use_table_data`, `font`, `font2`, `font3`, `font_size`, `text_color`, `padding_top`, `padding_right`, `padding_bottom`, `padding_left`, `weight`, `italic`, `underline`, `overline`, `blink`, `linethrough`, `letter_spacing`, `letter_spacing_units`, `oblique`, `small_caps`, `no_text_decoration`, `shadow`, `shadow_color`, `shadow_x_offset`, `shadow_y_offset`, `shadow_blur`, `align`, `vertical_align`, `line_height`, `line_height_units`, `bkgd_color`, `bkgd_opacity`, `border`, `border_color`, `border_style`, `outline_style`, `border_collapse`, `border_sides`, `margin_top`, `margin_top_units`, `margin_top_auto`, `margin_right`, `margin_right_units`, `margin_right_auto`, `margin_left`, `margin_left_units`, `margin_left_auto`, `margin_bottom`, `margin_bottom_units`, `margin_bottom_auto`, `display`, `width`, `width_units`, `width_prefix`, `height`, `height_units`, `height_prefix`, `position`, `position_left`, `position_left_units`, `position_top`, `position_top_units`, `position_right`, `position_right_units`, `position_bottom`, `position_bottom_units`, `z_index`, `overflow`, `clip`, `clip_top`, `clip_top_units`, `clip_right`, `clip_right_units`, `clip_bottom`, `clip_bottom_units`, `clip_left`, `clip_left_units`, `background_image`, `background_attachment`, `background_repeat`, `background_position`, `background_position_x`, `background_position_y`, `background_position_units`, `list_style_type`, `list_style_position`, `list_style_image`, `float`, `white_space`, `table_layout`, `clear`, `box_shadow_horizontal`, `box_shadow_vertical`, `box_shadow_blur`, `box_shadow_spread`, `box_shadow_color`, `box_shadow_inset`, `radius_top_left`, `radius_top_left_units`, `radius_top_right`, `radius_top_right_units`, `radius_bottom_right`, `radius_bottom_right_units`, `radius_bottom_left`, `radius_bottom_left_units`, `cursor`, `background_size`, `background_width`, `background_width_units`, `background_height`, `background_height_units`) VALUES\r\n('''', 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, -1000000, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#next'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''none'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#pause'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''none'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#prev'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''none'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#resume'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''none'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, ''#eeeeee'', -1, 1, ''#dddddd'', ''solid'', ''-not selected-'', ''-not selected-'', 15, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 960, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, -1, 0, -1, 0),\r\n(''#slideshow .slides'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 960, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''hidden'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides h2'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides li'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 20, 20, 20, 20, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 920, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides ul'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', 2880, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides-nav'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#dddddd'', -1, 2, ''#cccccc'', ''solid'', ''-not selected-'', ''-not selected-'', 8, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides-nav li'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 8, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''left'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides-nav li a'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 15, 20, 15, 20, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''none'', ''-not selected-'', 8, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''block'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides-nav li.on'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#eeeeee'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 8, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow .slides-nav li.on a'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''#eeeeee'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 8, -4, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', -1, 0, ''-not selected-'', ''relative'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow ul'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', 0, 0, 0, 0, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', -1, 0, ''-not selected-'', 1, 1, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''none'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0),\r\n(''#slideshow ul:after'', 1, ''-not selected-'', ''-not selected-'', ''-not selected-'', -1, ''-not set-'', -1, -1, -1, -1, ''-not selected-'', 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, ''-not set-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, -1, ''-not set-'', -1, -1, ''-not set-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, -1000000, 0, 0, ''block'', -1, 0, ''-not selected-'', 0, 0, ''-not selected-'', ''-not selected-'', -1000000, 0, -1000000, 0, -1000000, 0, -1000000, 0, -1000000, ''-not selected-'', NULL, -1, 0, -1, 0, -1, 0, -1, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', 0, 0, 0, ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', ''-not selected-'', -1000000, -1000000, -1, -1000000, ''-not set-'', 0, 0, 0, 0, 0, 0, 0, 0, 0, ''-not selected-'', ''-not selected-'', -1, 0, -1, 0);', NULL, '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.2.6/jquery.min.js"></script>\r\n<script type="text/javascript" src="scripts/jquery.cycle.js"></script>\r\n<script type="text/javascript" src="scripts/slideshow.js"></script>', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '<style type="text/css">\r\n#slideshow ul:after {  \r\ncontent: ".";  \r\nclear: both;  \r\nvisibility: hidden;\r\n}  \r\n</style>\r\n<div id="prev">&lt;</div>\r\n<div id="slideshow">  \r\n    <div class="slides">  \r\n        <ul>  \r\n            <li id="slide-one">  \r\n                <img src="images/sample1.jpg" width="920" height="160" alt="slide 1" />  \r\n            </li>  \r\n            <li id="slide-two">\r\n            	<h2>Slides can contain images or text.</h2>\r\n                <p>  \r\n                    Lorem ipsum dolor sit amet, consectetur adipiscing elit.  \r\n                    Donec pretium arcu non velit. Phasellus adipiscing auctor  \r\n                    lorem. Curabitur in urna ut purus consequat sollicitudin.  \r\n                    Phasellus ut diam. Cras magna libero, tempor id, venenatis  \r\n                    sit amet, venenatis et, dui.  \r\n                </p>  \r\n                <p>  \r\n                    Nam ac nibh sit amet augue ultricies sagittis. Donec sit  \r\n                    amet nunc. Vivamus lacinia, nisi ac tincidunt commodo, purus  \r\n                    nisi condimentum urna, sit amet molestie odio dolor non lectus.  \r\n                    Cum sociis natoque penatibus et magnis dis parturient montes,  \r\n                    nascetur ridiculus mus.  \r\n                </p>  \r\n            </li>  \r\n            <li id="slide-three">  \r\n                <img src="images/sample2.jpg" width="920" height="160" alt="slide 3" />\r\n            </li>  \r\n        </ul>  \r\n    </div>  \r\n    <ul class="slides-nav">  \r\n        <li><a href="#slide-one">Slide one</a></li>  \r\n        <li><a href="#slide-two">Slide two</a></li>  \r\n        <li><a href="#slide-three">Slide three</a></li>  \r\n    </ul>  \r\n</div>\r\n<div id="prev">&gt;</div>\r\n<div id="pause">||</div>\r\n<div id="resume">--&gt;</div>', NULL, NULL, NULL, NULL, NULL, '<script language="javascript" type="text/javascript">\r\n    $(function() {  \r\n        // add a "js" class to the body  \r\n        $("body").addClass("js");  \r\n        // initialise the slideshow when the DOM is ready  \r\n        $slideshow.init();  \r\n    });  \r\n</script>', NULL, NULL, NULL, NULL, NULL, 'http://breezewebsitebuilder.com/docs/cms/help.html#plugins#horizontal_scrolling', NULL, NULL, 0, 1, 0, 55);


CREATE TABLE IF NOT EXISTS `bwb_plugin_categories` (
  `category` varchar(255) NOT NULL,
  `parent_category` varchar(255) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`category`,`parent_category`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO `bwb_plugin_categories` (`category`, `parent_category`, `sort_order`) VALUES
('Calendars and Events', '', 20),
('Contact Forms', 'Forms', 10),
('Forms', '', 10),
('Multimedia', '', 50),
('Audio', 'Multimedia', 10),
('Newsletter Signup Forms', 'Forms', 20),
('Photo Galleries', '', 30),
('Shopping Carts', '', 60),
('Slideshows', '', 40),
('User Access Forms', 'Forms', 30),
('Video', 'Multimedia', 20);


CREATE TABLE `bwb_schedule` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Description` longtext NOT NULL,
  `EventDate` varchar(50) default NULL,
  `StartTime` varchar(20) default NULL,
  `EndTime` varchar(20) default NULL,
  `HebrewDate` varchar(50) default NULL,
  `URL` varchar(255) default NULL,
  `target` VARCHAR(32) default NULL,
  `EventDateSort` datetime default NULL,
  `Active` tinyint(4) NOT NULL default '1',
  `user_table` VARCHAR( 64 ) NULL ,
  `UserID` VARCHAR( 64 ) NULL ,
  `AccessLevel` VARCHAR( 64 ) NULL ,
  PRIMARY KEY  (`ID`)
)  AUTO_INCREMENT=1 ;


CREATE TABLE IF NOT EXISTS `bwb_site_classes` (
  `class` varchar(128) NOT NULL,
  `description` varchar(255) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  `subclass_sort_order` int(11) NOT NULL default '0',
  `custom` tinyint(4) NOT NULL default '0',
  `browser_reset` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_site_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('#wrap', 'ID for div that surrounds entire page (part of template)', 500, 500, 0),
('#content_td', 'ID for table cell that surrounds content area (part of template)', 510, 500, 0),
('#content_div', 'ID for div that surrounds content area (part of template)', 520, 500, 0),
('#top_td', 'ID for table cell that surrounds top area (part of template)', 530, 500, 0),
('#top_div', 'ID for div that surrounds top area (part of template)', 540, 500, 0),
('#bottom_td', 'ID for table cell that surrounds bottom area (part of template)', 550, 500, 0),
('#bottom_div', 'ID for div that surrounds bottom area (part of template)', 560, 500, 0),
('#left_td', 'ID for table cell that surrounds left area (part of template)', 570, 500, 0),
('#left_div', 'ID for div that surrounds left area (part of template)', 580, 500, 0),
('#right_td', 'ID for table cell that surrounds right area (part of template)', 590, 500, 0),
('#right_div', 'ID for div that surrounds right area (part of template)', 600, 500, 0),
('.basic', 'Class for body style override on basic template pages (part of basic template)', 630, 500, 0),
('.popup_msg_div', 'Class for popup message div (part of system)', 635, 500, 0),
('.popup_msg_table', 'Class for popup message table (part of system)', 640, 500, 0),
('.popup_msg_td_top', 'Class for popup message top (part of system)', 645, 500, 0),
('.popup_msg_td_bottom', 'Class for popup message bottom (part of system)', 650, 500, 0),
('.popup_msg_button', 'Class for popup message button (part of system)', 655, 500, 0),
('body', 'body', 1000, 50, 0),
('table', 'table', 1005, 55, 0),
('thead', 'table header content group', 1010, 60, 0),
('tbody', 'table body content group', 1015, 65, 0),
('tfoot', 'table footer content group', 1020, 70, 0),
('caption', 'table caption', 1025, 75, 0),
('tr', 'table row', 1030, 80, 0),
('th', 'table header cell', 1035, 85, 0),
('td', 'table cell', 1040, 90, 0),
('colgroup', 'table column group', 1045, 95, 0),
('col', 'table column', 1050, 100, 0),
('p', 'paragraph', 1055, 105, 0),
('h1', 'header 1', 1060, 110, 0),
('h2', 'header 2', 1065, 115, 0),
('h3', 'header 3', 1070, 120, 0),
('h4', 'header 4', 1075, 125, 0),
('a:link', 'hyperlink, unvisited', 1080, 130, 0),
('a:visited', 'hyperlink, visited', 1085, 135, 0),
('a:hover', 'hyperlink, mouse over', 1090, 140, 0),
('a:active', 'hyperlink, clicked on', 1095, 145, 0),
('ul', 'un-ordered list', 1100, 150, 0),
('ol', 'ordered list', 1115, 155, 0),
('li', 'list item', 1120, 160, 0),
('hr', 'horizontal rule', 1125, 165, 0),
('blockquote', 'blockquote', 1130, 170, 0),
('div', 'div', 1135, 175, 0),
('span', 'span', 1140, 180, 0),
('header', 'HTML5 header tag', 1145, 185, 0),
('footer', 'HTML5 footer tag', 1150, 190, 0),
('address', 'Address Block', 1155, 195, 0),
('form', 'Form', 1160, 200, 0),
('fieldset', 'Form Fieldset', 1165, 205, 0),
('legend', 'Form Legend', 1170, 210, 0),
('input', 'Input Field', 1175, 215, 0),
('label', 'Input Field Label', 1180, 220, 0),
('dl', 'Definition List', 1185, 225, 0),
('dt', 'Definition Term', 1190, 230, 0),
('dd', 'Definition Description', 1195, 235, 0),
('iframe', 'Inline Frame', 1200, 240, 0),
('img', 'Image', 1205, 245, 0),
('html', 'Entire HTML Document', 1210, 250, 0);

UPDATE `bwb_site_classes` SET `browser_reset` = '1' WHERE `class` = 'html';


CREATE TABLE IF NOT EXISTS `bwb_site_css` (
  `class` varchar(128) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_site_mobile_classes` (
  `class` varchar(128) NOT NULL,
  `description` varchar(255) default NULL,
  `sort_order` int(11) NOT NULL default '0',
  `subclass_sort_order` int(11) NOT NULL default '0',
  `custom` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_site_mobile_classes` (`class`, `description`, `sort_order`, `subclass_sort_order`, `custom`) VALUES
('#wrap', 'ID for div that surrounds entire page (part of template)', 500, 500, 0),
('#content_td', 'ID for table cell that surrounds content area (part of template)', 510, 500, 0),
('#content_div', 'ID for div that surrounds content area (part of template)', 520, 500, 0),
('#top_td', 'ID for table cell that surrounds top area (part of template)', 530, 500, 0),
('#top_div', 'ID for div that surrounds top area (part of template)', 540, 500, 0),
('#bottom_td', 'ID for table cell that surrounds bottom area (part of template)', 550, 500, 0),
('#bottom_div', 'ID for div that surrounds bottom area (part of template)', 560, 500, 0),
('#left_td', 'ID for table cell that surrounds left area (part of template)', 570, 500, 0),
('#left_div', 'ID for div that surrounds left area (part of template)', 580, 500, 0),
('#right_td', 'ID for table cell that surrounds right area (part of template)', 590, 500, 0),
('#right_div', 'ID for div that surrounds right area (part of template)', 600, 500, 0),
('.basic', 'Class for body style override on basic template pages (part of basic template)', 630, 500, 0),
('.popup_msg_div', 'Class for popup message div (part of system)', 635, 500, 0),
('.popup_msg_table', 'Class for popup message table (part of system)', 640, 500, 0),
('.popup_msg_td_top', 'Class for popup message top (part of system)', 645, 500, 0),
('.popup_msg_td_bottom', 'Class for popup message bottom (part of system)', 650, 500, 0),
('.popup_msg_button', 'Class for popup message button (part of system)', 655, 500, 0),
('body', 'body', 1000, 50, 0),
('table', 'table', 1005, 55, 0),
('thead', 'table header content group', 1010, 60, 0),
('tbody', 'table body content group', 1015, 65, 0),
('tfoot', 'table footer content group', 1020, 70, 0),
('caption', 'table caption', 1025, 75, 0),
('tr', 'table row', 1030, 80, 0),
('th', 'table header cell', 1035, 85, 0),
('td', 'table cell', 1040, 90, 0),
('colgroup', 'table column group', 1045, 95, 0),
('col', 'table column', 1050, 100, 0),
('p', 'paragraph', 1055, 105, 0),
('h1', 'header 1', 1060, 110, 0),
('h2', 'header 2', 1065, 115, 0),
('h3', 'header 3', 1070, 120, 0),
('h4', 'header 4', 1075, 125, 0),
('a:link', 'hyperlink, unvisited', 1080, 130, 0),
('a:visited', 'hyperlink, visited', 1085, 135, 0),
('a:hover', 'hyperlink, mouse over', 1090, 140, 0),
('a:active', 'hyperlink, clicked on', 1095, 145, 0),
('ul', 'un-ordered list', 1100, 150, 0),
('ol', 'ordered list', 1115, 155, 0),
('li', 'list item', 1120, 160, 0),
('hr', 'horizontal rule', 1130, 165, 0),
('blockquote', 'blockquote', 1140, 165, 0),
('div', 'div', 1150, 170, 0),
('header', 'HTML5 header tag', 1160, 175, 0),
('footer', 'HTML5 footer tag', 1170, 180, 0),
('html', 'Entire HTML Document', 1180, 185, 0);


CREATE TABLE IF NOT EXISTS `bwb_site_mobile_css` (
  `class` varchar(128) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_site_css_preview` (
  `class` varchar(128) NOT NULL,
  `use_table_data` tinyint(4) NOT NULL default '0',
  `font` varchar(255) NOT NULL default '',
  `font2` varchar(255) default NULL,
  `font3` varchar(255) default NULL,
  `font_size` int(11) NOT NULL default '-1',
  `text_color` varchar(32) NOT NULL default '',
  `padding_top` int(11) NOT NULL default '-1',
  `padding_right` int(11) NOT NULL default '-1',
  `padding_bottom` int(11) NOT NULL default '-1',
  `padding_left` int(11) NOT NULL default '-1',
  `weight` varchar(32) NOT NULL default 'normal',
  `italic` tinyint(4) NOT NULL default '0',
  `underline` tinyint(4) NOT NULL default '0',
  `overline` tinyint(4) NOT NULL default '0',
  `blink` tinyint(4) NOT NULL default '0',
  `linethrough` tinyint(4) NOT NULL default '0',
  `letter_spacing` int(11) NOT NULL default '0',
  `letter_spacing_units` tinyint(4) NOT NULL default '-1',
  `oblique` tinyint(4) NOT NULL default '0',
  `small_caps` tinyint(4) NOT NULL default '0',
  `no_text_decoration` tinyint(4) NOT NULL default '0',
  `shadow` tinyint(4) NOT NULL default '0',
  `shadow_color` varchar(32) default NULL,
  `shadow_x_offset` int(11) NOT NULL default '0',
  `shadow_y_offset` int(11) NOT NULL default '0',
  `shadow_blur` int(11) NOT NULL default '0',
  `align` varchar(32) default NULL,
  `vertical_align` varchar(32) default NULL,
  `line_height` double NOT NULL default '-1',
  `line_height_units` tinyint(4) NOT NULL default '-1',
  `bkgd_color` varchar(32) NOT NULL default '',
  `bkgd_opacity` int(11) NOT NULL default '-1',
  `border` int(11) NOT NULL default '-1',
  `border_color` varchar(32) NOT NULL default '',
  `border_style` varchar(32) default NULL,
  `outline_style` varchar(32) default NULL,
  `border_collapse` varchar(32) default NULL,
  `border_sides` tinyint(4) NOT NULL default '15',
  `margin_top` int(11) default '-1000000',
  `margin_top_units` tinyint(11) NOT NULL default '0',
  `margin_top_auto` tinyint(4) NOT NULL default '0',
  `margin_right` int(11) default '-1000000',
  `margin_right_units` tinyint(4) NOT NULL default '0',
  `margin_right_auto` tinyint(4) NOT NULL default '0',
  `margin_left` int(11) default '-1000000',
  `margin_left_units` tinyint(4) NOT NULL default '0',
  `margin_left_auto` tinyint(4) NOT NULL default '0',
  `margin_bottom` int(11) default '-1000000',
  `margin_bottom_units` tinyint(4) NOT NULL default '0',
  `margin_bottom_auto` tinyint(4) NOT NULL default '0',
  `display` varchar(32) default NULL,
  `width` int(11) default '-1',
  `width_units` tinyint(4) default '0',
  `width_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `height` int(11) default '-1',
  `height_units` tinyint(4) NOT NULL default '0',
  `height_prefix` VARCHAR( 16 ) NOT NULL DEFAULT '',
  `position` varchar(32) default NULL,
  `position_left` int(11) NOT NULL default '-1000000',
  `position_left_units` tinyint(4) NOT NULL default '0',
  `position_top` int(11) NOT NULL default '-1000000',
  `position_top_units` tinyint(4) NOT NULL default '0',
  `position_right` int(11) NOT NULL default '-1000000',
  `position_right_units` tinyint(4) NOT NULL default '0',
  `position_bottom` int(11) NOT NULL default '-1000000',
  `position_bottom_units` tinyint(4) NOT NULL default '0',
  `z_index` int(11) NOT NULL default '-1000000',
  `overflow` varchar(32) default NULL,
  `clip` varchar(64) default NULL,
  `clip_top` int(11) NOT NULL default '-1',
  `clip_top_units` tinyint(4) NOT NULL default '-1',
  `clip_right` int(11) NOT NULL default '-1',
  `clip_right_units` tinyint(4) NOT NULL default '-1',
  `clip_bottom` int(11) NOT NULL default '-1',
  `clip_bottom_units` tinyint(4) NOT NULL default '-1',
  `clip_left` int(11) NOT NULL default '-1',
  `clip_left_units` tinyint(4) NOT NULL default '-1',
  `background_image` varchar(255) default NULL,
  `background_attachment` varchar(32) default NULL,
  `background_repeat` varchar(32) default NULL,
  `background_position` varchar(32) default NULL,
  `background_position_x` int(11) default '0',
  `background_position_y` int(11) default '0',
  `background_position_units` tinyint(4) default '0',
  `list_style_type` varchar(64) default NULL,
  `list_style_position` varchar(32) default NULL,
  `list_style_image` varchar(255) default NULL,
  `float` varchar(32) default NULL,
  `white_space` varchar(32) default NULL,
  `table_layout` varchar(32) default NULL,
  `clear` VARCHAR( 32 ) default NULL,
  `box_shadow_horizontal` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_vertical` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_blur` INT NOT NULL DEFAULT '-1',
  `box_shadow_spread` INT NOT NULL DEFAULT '-1000000',
  `box_shadow_color` VARCHAR ( 32 ) DEFAULT NULL,
  `box_shadow_inset` TINYINT NOT NULL DEFAULT '0',
  `radius_top_left` INT NOT NULL DEFAULT '0',
  `radius_top_left_units` TINYINT NOT NULL DEFAULT '0',
  `radius_top_right` INT NOT NULL DEFAULT '0',
  `radius_top_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_right` INT NOT NULL DEFAULT '0',
  `radius_bottom_right_units` TINYINT NOT NULL DEFAULT '0',
  `radius_bottom_left` INT NOT NULL DEFAULT '0',
  `radius_bottom_left_units` TINYINT NOT NULL DEFAULT '0',
  `cursor` VARCHAR( 32 ) DEFAULT NULL,
  `background_size` VARCHAR( 32 ) NULL DEFAULT NULL ,
  `background_width` INT NOT NULL DEFAULT '-1',
  `background_width_units` TINYINT NOT NULL DEFAULT '0',
  `background_height` INT NOT NULL DEFAULT '-1',
  `background_height_units` TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (`class`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


CREATE TABLE IF NOT EXISTS `bwb_style_sheets` (
  `name` varchar(64) NOT NULL,
  `description` varchar(255) default NULL,
  `show_class_editor` tinyint(4) NOT NULL default '0',
  `show_custom_styles` tinyint(4) NOT NULL default '0',
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_style_sheets` (`name`, `description`, `show_class_editor`, `show_custom_styles`, `sort_order`) VALUES
('site', 'Site Styles', 1, 1, 10),
('site_mobile', 'Mobile Site Styles', 1, 1, 15),
('blog', 'Blog Styles', 0, 0, 40),
('menu1', 'CSS Menu 1 Styles', 0, 0, 50),
('menu1_item', 'CSS Menu 1 Item Styles', 0, 0, 60),
('menu2', 'JavaScript Menu 1 Styles', 0, 0, 70),
('menu2_item', 'JavaScript Menu 1 Item Styles', 0, 0, 80);


CREATE TABLE IF NOT EXISTS `bwb_template` (
  `template_name` varchar(63) NOT NULL default '',
  `page_template` longtext,
  PRIMARY KEY  (`template_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_template` (`template_name`, `page_template`) VALUES
('top_bottom_left_right', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top = stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''bottom''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$bottom = $row["page_content"];\r\n	$bottom = stripslashes($bottom);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left = stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''right''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$right = $row["page_content"];\r\n	$right = stripslashes($right);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header = stripslashes($header);\r\n\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer = stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr><td style="padding:0px;" colspan="3" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div">\r\n  <!--top_code-->\r\n  <?php echo $top; ?>\r\n  <?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td></tr>\r\n  	<tr>\r\n    <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    <div class="left_div" id="left_div">\r\n    <!--left_code-->\r\n    <?php $border_area = "left"; include ($menu_script_path); ?>\r\n    <?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n 	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n    <td style="vertical-align:top; padding:0px;" class="right_td" id="right_td">\r\n<?php }	?>\r\n    <div class="right_div" id="right_div">\r\n    <!--right_code-->\r\n    <?php $border_area = "right"; include ($menu_script_path); ?>\r\n    <?php echo $right; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n  <tr><td style="padding:0px;" colspan="3" class="bottom_td" id="bottom_td">\r\n<?php }	?>\r\n  <div class="bottom_div" id="bottom_div">\r\n  <!--bottom_code-->\r\n  <?php $border_area = "bottom"; include ($menu_script_path); ?>\r\n  <?php echo $bottom; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n  </td></tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('top', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr>\r\n    <td style="padding:0px;" class="top_td" id="top_td">\r\n<?php }	?>\r\n    <div class="top_div" id="top_div"><?php echo $top; ?>\r\n    <!--top_code-->\r\n    <?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n</td>\r\n  </tr><tr>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">	\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n	</div>\r\n<?php	if ($use_table_structure == 1)	{	?> \r\n    </td>\r\n  </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n"\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('basic', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n		\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	\r\n	include($is_mobile_path);\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body class="basic">\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n\r\n<?php echo $page_content_arr[0]; ?>\r\n<!--content_code-->\r\n<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('left', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr>\r\n    <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    <div class="left_div" id="left_div">\r\n    <!--left_code-->\r\n    <?php $border_area = "left"; include ($menu_script_path); ?>\r\n    <?php echo $left; ?>\r\n    </div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>');
INSERT INTO `bwb_template` (`template_name`, `page_template`) VALUES
('top_bottom', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''bottom''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$bottom = $row["page_content"];\r\n	$bottom= stripslashes($bottom);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr><td style="padding:0px;" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div">\r\n  <!--top_code-->\r\n  <?php echo $top; ?>\r\n  <?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td></tr>\r\n      <tr>\r\n        <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n        <div class="content_div" id="content_div">\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->	\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n  <tr><td style="padding:0px;" class="bottom_td" id="bottom_td">\r\n<?php }	?>\r\n  <div class="bottom_div" id="bottom_div">\r\n  <!--bottom_code-->\r\n  <?php $border_area = "bottom"; include ($menu_script_path); ?>\r\n  <?php echo $bottom; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n  </td></tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('top_left', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr><td style="padding:0px;" colspan="2" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div">\r\n  <!--top_code-->\r\n  <?php echo $top; ?>\r\n<?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td></tr>\r\n  <tr>\r\n    <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    <div class="left_div" id="left_div">\r\n    <!--left_code-->\r\n<?php $border_area = "left"; include ($menu_script_path); ?>\r\n<?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->	\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('top_left_right', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''right''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$right = $row["page_content"];\r\n	$right= stripslashes($right);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr><td style="padding:0px;" colspan="3" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div">\r\n  <!--top_code-->\r\n  <?php echo $top; ?>\r\n<?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td></tr>\r\n  <tr>\r\n    <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    <div class="left_div" id="left_div">\r\n    <!--left_code-->\r\n<?php $border_area = "left"; include ($menu_script_path); ?>\r\n<?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">\r\n<?php echo $page_content_arr[0]; ?>\r\n<!--content_code-->\r\n<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n 	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n    <td style="vertical-align:top; padding:0px;" class="right_td" id="right_td">\r\n<?php }	?>\r\n    <div class="right_div" id="right_div">\r\n    <!--right_code-->\r\n<?php $border_area = "right"; include ($menu_script_path); ?>\r\n<?php echo $right; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td>\r\n  </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('top_bottom_left', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''bottom''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$bottom = $row["page_content"];\r\n	$bottom= stripslashes($bottom);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr><td style="padding:0px;" colspan="2" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div">\r\n  <!--top_code-->\r\n  <?php echo $top; ?>\r\n  <?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n	</td></tr>\r\n  	<tr>\r\n    <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    <div class="left_div" id="left_div">\r\n    <!--left_code-->\r\n    <?php $border_area = "left"; include ($menu_script_path); ?>\r\n    <?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n    <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n    <div class="content_div" id="content_div">\r\n	<?php echo $page_content_arr[0]; ?>\r\n	<!--content_code-->	\r\n	<?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n	</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n  <tr><td style="padding:0px;" colspan="2" class="bottom_td" id="bottom_td">\r\n<?php }	?>\r\n  <div class="bottom_div" id="bottom_div">\r\n  <!--bottom_code-->\r\n  <?php $border_area = "bottom"; include ($menu_script_path); ?>\r\n  <?php echo $bottom; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n  </td></tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>');
INSERT INTO `bwb_template` (`template_name`, `page_template`) VALUES
('top_bottom_left_right_alt', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''bottom''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$bottom = $row["page_content"];\r\n	$bottom= stripslashes($bottom);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''right''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$right = $row["page_content"];\r\n	$right= stripslashes($right);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n  <tr>\r\n  	<td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n    	<div class="left_div" id="left_div">\r\n    	<!--left_code-->\r\n        <?php $border_area = "left"; include ($menu_script_path); ?>\r\n        <?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n     </td>\r\n	<td style="vertical-align:top; padding:0px;">\r\n		<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n			<tr>\r\n                <td style="padding:0px;" class="top_td" id="top_td">\r\n<?php }	?>\r\n                <div class="top_div" id="top_div">\r\n                <!--top_code-->\r\n				<?php echo $top; ?>\r\n                <?php $border_area = "top"; include ($menu_script_path); ?>\r\n                </div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n                </td>\r\n			</tr>\r\n			<tr>\r\n                 <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n                 <div class="content_div" id="content_div">\r\n				<?php echo $page_content_arr[0]; ?>\r\n				<!--content_code-->\r\n                <?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n                 </div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n                 </td>\r\n			</tr>\r\n			<tr>\r\n                <td style="padding:0px;" class="bottom_td" id="bottom_td">\r\n<?php }	?>\r\n                <div class="bottom_div" id="bottom_div">\r\n                <!--bottom_code-->\r\n                <?php $border_area = "bottom"; include ($menu_script_path); ?>\r\n				<?php echo $bottom; ?>\r\n                </div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n                </td>\r\n			</tr>\r\n		</table>\r\n	</td>\r\n    <td style="vertical-align:top; padding:0px;" class="right_td" id="right_td">\r\n<?php }	?>\r\n    <div class="right_div" id="right_div">\r\n    <!--right_code-->\r\n    <?php $border_area = "right"; include ($menu_script_path); ?>\r\n    <?php echo $right; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n    </td>\r\n  </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>'),
('top_bottom_left_right_alt2', '<?php\r\n	$doc_root = getenv(''DOCUMENT_ROOT'');\r\n	$db_connect_file = $doc_root . "/connect/db_connect.php";\r\n	$bwb_config_path = $doc_root . "/connect/config.php";\r\n	include($db_connect_file);\r\n	include($bwb_config_path);\r\n	\r\n	if (BWB_WEBPAGE_DIR == "")\r\n		$rel_path = "";\r\n	else\r\n		$rel_path = "../";\r\n	$menu_script_path = $rel_path . BWB_SCRIPTS_DIR . "/menu_gen.php";\r\n	$login_links_path = $rel_path . BWB_SCRIPTS_DIR . "/login_links.php";\r\n	$captcha_includes_path = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes.php";\r\n	$captcha_includes_path2 = $rel_path . BWB_SCRIPTS_DIR . "/captcha_includes2.php";\r\n	$is_mobile_path = $rel_path . BWB_SCRIPTS_DIR . "/is_mobile.php";\r\n	\r\n	if ((BWB_WEBPAGE_DIR == "") && (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "";\r\n	elseif ((BWB_WEBPAGE_DIR == "") || (BWB_BASE_DIR == ""))\r\n		$rel_root_path = "../";\r\n	else\r\n		$rel_root_path = "../../";\r\n	\r\n	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$page_content = $row["page_content"];\r\n	$page_content= stripslashes($page_content);\r\n	$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n	$login_required = $row[''login_required''];\r\n	$user_table = $row[''user_table''];\r\n	$AccessLevel = $row[''AccessLevel''];\r\n	$login_page = $row[''login_page''];\r\n	$show_login_links = $row[''show_login_links''];\r\n	$use_table_structure = $row[''use_table_structure''];\r\n	$use_table_structure_mobile = $row[''use_table_structure_mobile''];\r\n	\r\n	include($is_mobile_path);\r\n	if ($is_mobile === true)\r\n		$use_table_structure = $use_table_structure_mobile;\r\n	\r\n	session_start();\r\n	$userid = $_SESSION[''pub_userid''];\r\n	$curr_session = md5(session_id());\r\n	\r\n	$show_login = false;\r\n	if ($login_required == 1)\r\n	{\r\n		if ((!$userid) || (!$curr_session))\r\n			$show_login = true;\r\n		else\r\n		{\r\n			if (!isset($user_table) || ($user_table == ""))	{\r\n				echo "This page requires user access; however, the user table is not defined.  Please contact your system administrator.";\r\n				exit;\r\n			}\r\n			$query = "SELECT * FROM `" . $user_table . "` WHERE `UserID`=''$userid''";\r\n			$result = $bwb_dbh->query($query);\r\n			if ($result->rowCount() < 1)\r\n				$show_login = true;\r\n			else\r\n			{\r\n				$row = $result->fetch(PDO::FETCH_ASSOC);\r\n				\r\n				$session = $row[''Session''];\r\n				$ip = $row[''IP''];\r\n				$access_level = $row[''AccessLevel''];\r\n				$curr_ip = $_SERVER[''REMOTE_ADDR''];\r\n				$first_name = $row[''first_name''];\r\n				$last_name = $row[''last_name''];\r\n				\r\n				if (($curr_session != $session) || ($curr_ip != $ip))\r\n					$show_login = true;\r\n				elseif ((!is_null($AccessLevel)) && ($AccessLevel != "") && ($access_level != $AccessLevel))\r\n					$show_login = true;\r\n			}\r\n		}\r\n		if ($show_login === true)\r\n		{\r\n			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name=''" . $login_page . "''";\r\n			$result = $bwb_dbh->query($query);\r\n			$row = $result->fetch(PDO::FETCH_ASSOC);\r\n			$page_content = $row["page_content"];\r\n			$page_content= stripslashes($page_content);\r\n			$page_content_arr = explode("<!-- Page Content Divider -->", $page_content);\r\n		}\r\n	}\r\n	\r\n	$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''xxx''";\r\n	$result = $bwb_dbh->query($query);\r\n	if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_append_''";\r\n		$result = $bwb_dbh->query($query);\r\n		if ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n		{\r\n			$append = $row["title"];\r\n			$append = stripslashes($append);\r\n			$title .= " - " . $append;\r\n		}\r\n	}\r\n	else\r\n	{\r\n		$query = "SELECT title FROM " . BWB_TABLE_PREFIX . "page_titles WHERE page_name=''_default_''";\r\n		$result = $bwb_dbh->query($query);\r\n		$row = $result->fetch(PDO::FETCH_ASSOC);\r\n		$title = $row["title"];\r\n		$title = stripslashes($title);\r\n	}\r\n	\r\n	$query = "SELECT head_content FROM " . BWB_TABLE_PREFIX . "head WHERE head_name=''head''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$head = $row["head_content"];\r\n	$head = stripslashes($head);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''top''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$top = $row["page_content"];\r\n	$top= stripslashes($top);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''bottom''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$bottom = $row["page_content"];\r\n	$bottom= stripslashes($bottom);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''left''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$left = $row["page_content"];\r\n	$left= stripslashes($left);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''right''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$right = $row["page_content"];\r\n	$right= stripslashes($right);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''header''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$header = $row["page_content"];\r\n	$header= stripslashes($header);\r\n	\r\n	$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name=''footer''";\r\n	$result = $bwb_dbh->query($query);\r\n	$row = $result->fetch(PDO::FETCH_ASSOC);\r\n	$footer = $row["page_content"];\r\n	$footer= stripslashes($footer);\r\n?>\r\n\r\n<!doctype html>\r\n<html>\r\n<head>\r\n<title><?php echo $title; ?></title>\r\n<meta charset="utf-8">\r\nzzz\r\n\r\n<!--head_code-->\r\n\r\n<?php\r\n	if ($is_mobile === true)\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site'' ORDER BY sort_order";\r\n	else\r\n		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE `name` <> ''site_mobile'' ORDER BY sort_order";\r\n	$result = $bwb_dbh->query($query);\r\n	while ($row = $result->fetch(PDO::FETCH_ASSOC))\r\n	{\r\n		$name = $row["name"];\r\n		echo "<link rel=\\"stylesheet\\" href=\\"" . $rel_path . BWB_CSS_DIR . "/" . $name . ".css\\" type=\\"text/css\\">\\n";\r\n	}\r\n?>\r\n\r\n<?php echo $head; ?>\r\n\r\n<?php\r\necho "<script>\\n";\r\nif ($is_mobile == true)\r\n	echo "	var is_mobile = true;\\n";\r\nelse\r\n	echo "	var is_mobile = false;\\n";\r\necho "	var user_table = ''$user_table'';\\n";\r\necho "	var AccessLevel = ''$AccessLevel'';\\n";\r\necho "	var userid = ''$userid'';\\n";\r\necho "	var first_name = ''$first_name'';\\n";\r\necho "	var last_name = ''$last_name'';\\n";\r\necho "</script>\\n";\r\n\r\necho "<script>\\n";\r\n$php_dir = "/php/";\r\nif ((BWB_BASE_DIR == '''') && (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	$webpage_dir = "/";\r\n	$php_dir_rel = "php/";\r\n	$webpage_dir_rel = "";\r\n}\r\nelseif ((BWB_BASE_DIR == '''') || (BWB_WEBPAGE_DIR == ''''))\r\n{\r\n	if (BWB_BASE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_WEBPAGE_DIR . "/";\r\n		$webpage_dir_rel = BWB_WEBPAGE_DIR . "/";\r\n	}\r\n	elseif (BWB_WEBPAGE_DIR == '''')\r\n	{\r\n		$webpage_dir = "/" . BWB_BASE_DIR . "/";\r\n		$webpage_dir_rel = BWB_BASE_DIR . "/";\r\n	}\r\n	$php_dir_rel = "../php/";\r\n}\r\nelse\r\n{\r\n	$webpage_dir = "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$webpage_dir_rel = BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";\r\n	$php_dir_rel = "../../php/";\r\n}\r\n$currentFile = $_SERVER["PHP_SELF"];\r\n$parts = Explode(''/'', $currentFile);\r\n$this_page = $parts[count($parts) - 1];\r\n	\r\necho "	var php_dir = ''" . $php_dir . "'';\\n";\r\necho "	var webpage_dir = ''" . $webpage_dir . "'';\\n";\r\necho "	var php_dir_rel = ''" . $php_dir_rel . "'';\\n";\r\necho "	var webpage_dir_rel = ''" . $webpage_dir_rel . "'';\\n";\r\necho "	var this_page = ''" . $this_page . "'';\\n";\r\n\r\nif (isset($_REQUEST[''redirect'']))\r\n	echo "	var redirect = ''" . $webpage_dir . $_REQUEST[''redirect''] . "'';\\n";\r\nelse\r\n	echo "	var redirect = '''';\\n";\r\nif (isset($_REQUEST[''redirect2'']))\r\n	echo "	var redirect2 = ''" . $webpage_dir . $_REQUEST[''redirect2''] . "'';\\n";\r\nelse\r\n	echo "	var redirect2 = '''';\\n";\r\nif (isset($_REQUEST[''redirect3'']))\r\n	echo "	var redirect3 = ''" . $webpage_dir . $_REQUEST[''redirect3''] . "'';\\n";\r\nelse\r\n	echo "	var redirect3 = '''';\\n";\r\n\r\n$captchakeys_file = $doc_root . "/connect/captchakeys.php";\r\ninclude($captchakeys_file);\r\necho "	var recaptcha_public_key = ''" . RECAPTCHA_PUBLIC_KEY . "'';\\n";\r\n\r\nif ($_REQUEST[''login_success''])\r\n	echo "  var login_success = true;\\n";\r\nelse\r\n	echo "  var login_success = false;\\n";\r\n	\r\nif (($userid) && ($curr_session))\r\n	echo "  var logged_in = true;\\n";\r\nelse\r\n	echo "  var logged_in = false;\\n";\r\n\r\necho "</script>\\n\\n";\r\n\r\nif (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/hash.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n</head>\r\n\r\n<body>\r\n<!--header_code-->\r\n<?php\r\nif (isset($header) && ($header != ""))\r\n{\r\n	echo "<header>\\n<div id=''header'' class=''header''>\\n";\r\n	echo $header;\r\n	$border_area = "header"; include ($menu_script_path);\r\n	if ($show_login_links == 2)\r\n		include_once($login_links_path);\r\n	echo "\\n</div>\\n</header>\\n";\r\n}\r\n?>\r\n<div class="wrap" id="wrap">\r\n<?php\r\nif ($show_login_links == 1)\r\n	include_once($login_links_path);\r\n?>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n<table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n <tr>\r\n  <td style="padding:0px;" class="top_td" id="top_td">\r\n<?php }	?>\r\n  <div class="top_div" id="top_div"><?php echo $top; ?>\r\n  <!--top_code-->\r\n  <?php $border_area = "top"; include ($menu_script_path); ?>\r\n</div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n  </td>\r\n </tr>\r\n <tr>\r\n  <td style="padding:0px;">\r\n   <table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n    <tr>\r\n     <td style="vertical-align:top; padding:0px;" class="left_td" id="left_td">\r\n<?php }	?>\r\n     <div class="left_div" id="left_div">\r\n     <!--left_code-->\r\n     <?php $border_area = "left"; include ($menu_script_path); ?>\r\n     <?php echo $left; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n     </td>\r\n     <td style="padding:0px;">\r\n      <table style="width:100%; padding:0px; border-width:0px; border-style:none; border-spacing:0px; border-collapse:collapse; margin:0px;">\r\n       <tr>\r\n        <td style="vertical-align:top; padding:0px;" class="content_td" id="content_td">\r\n<?php }	?>\r\n        <div class="content_div" id="content_div">\r\n	     <?php echo $page_content_arr[0]; ?>\r\n		 <!--content_code-->\r\n         <?php if (isset($page_content_arr[1])) echo $page_content_arr[1]; ?>\r\n        </div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n        </td>\r\n       </tr>\r\n       <tr>\r\n        <td style="padding:0px;" class="bottom_td" id="bottom_td">\r\n<?php }	?>\r\n        <div class="bottom_div" id="bottom_div">\r\n        <!--bottom_code-->\r\n        <?php $border_area = "bottom"; include ($menu_script_path); ?>\r\n        <?php echo $bottom; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n        </td>\r\n       </tr>\r\n      </table>\r\n     </td>\r\n     <td style="vertical-align:top; padding:0px;" class="right_td" id="right_td">\r\n<?php }	?>\r\n     <div class="right_div" id="right_div">\r\n     <!--right_code-->\r\n     <?php $border_area = "right"; include ($menu_script_path); ?>\r\n     <?php echo $right; ?></div>\r\n<?php	if ($use_table_structure == 1)	{	?>\r\n     </td>\r\n    </tr>      \r\n   </table>\r\n  </td>\r\n </tr>\r\n</table>\r\n<?php }	?>\r\n</div>\r\n<!--footer_code-->\r\n<?php if (($login_required == 1) && ($show_login === true))	{\r\n	include_once($captcha_includes_path2);\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt.js'' type=''text/javascript''> </script>\\n\\n";\r\n	echo "<script language=''javascript'' src=''" . $rel_path . BWB_SCRIPTS_DIR . "/acct_mgmt_custom.js'' type=''text/javascript''> </script>\\n\\n";\r\n}\r\n?>\r\n<?php\r\nif (isset($footer) && ($footer != ""))\r\n{\r\n	echo "<footer>\\n<div id=''footer'' class=''footer''>\\n";\r\n	echo $footer;\r\n	$border_area = "footer"; include ($menu_script_path);\r\n	echo "\\n</div></footer>\\n";\r\n}\r\ninclude_once($rel_root_path . "breeze_copywrite.html");\r\n?>\r\n</body>\r\n</html>');


CREATE TABLE IF NOT EXISTS `bwb_users` (
  `UserID` varchar(50) NOT NULL default '',
  `password` varchar(255) NOT NULL,
  `AccessLevel` varchar(20) NOT NULL,
  `Session` varchar(32) NOT NULL,
  `IP` varchar(16) NOT NULL,
  `email` VARCHAR(255) NULL,
  `first_name` VARCHAR(128) NULL,
  `last_name` VARCHAR(128) NULL,
  PRIMARY KEY  (`UserID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `bwb_users` (`UserID`, `password`, `AccessLevel`, `Session`, `IP`) VALUES
('admin', '000000000077757B', 'admin', '9e682eb66bd4cd460497adf2480aa0d1', '98.140.148.200'),
('user', '00000000747474', 'user', '9e682eb66bd4cd460497adf2480aa0d1', '98.140.148.200'),
('power_user', '000000000000000000007A7E7E', 'power_user', '9e682eb66bd4cd460497adf2480aa0d1', '98.140.148.200'),
('restricted', '000000000000000000007A7E7E', 'restricted', '33fd06253be3c9e0a145ee5373b83dcd', '98.140.148.200'),
('blogger', '00000000000000797B79', 'blogger', '33fd06253be3c9e0a145ee5373b83dcd', '98.140.148.200');
