<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/28/2013	ELL
// Modified: 10/14/2014	ELL
// Added grouping of plugins by category and sub categories.
// 
	
	include ("check_session.php");
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Create Page Select</title>

<link rel="stylesheet" href="manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

.vertical_scroll_div	{
	max-height:450px;
	overflow-y:auto;
	overflow-x:hidden;
}

#selections_div	{
	display:block;
	position:absolute;
	top:60px;
	left:300px;
}

.selection_div	{
	height:33px;
	font-family:Arial, Helvetica, sans-serif;
}

#create_btn	{
	width:150px;
	display:block;
	position:absolute;
	top:170px;
	left:30px;
	z-index:1;
}

#template_pic_div	{
	display:block;
	position:absolute;
	top:0px;
	left:220px;
}
</style>

<script language="javascript" type="text/javascript" src="js/create_page_select.js"></script>
<script language="javascript" type="text/javascript" src="js/fix_on_mouse_out.js"></script>

<script language="javascript" type="text/javascript">
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `sort_order`";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo "var layouts = new Array($num_results);\n";
	echo "var images = new Array($num_results);\n";
	for ($i = 0; $i < $num_results; $i++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$option_value = $row["option_value"];
		$option_image = $row["option_image"];
		echo "layouts[$i] = \"$option_value\";\n";
		echo "images[$i] = \"$option_image\";\n";
	}

	$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `available` = 1";
	$result = $bwb_dbh->query($query);
	$plugin_cnt = $result->rowCount();
	echo "var plugins = new Array();\n";
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		echo "plugins[" . $row['id'] . "] = '" . $row['name'] . "';\n";
	}
?>
</script>

</head>

<body id="workspace_body">

<div id="sub_level_1_buttons">
	<div class="button_heading_sub_level_1" id="create_page_heading" onclick="ShowSelections();"><div class="button_heading_text_sub_level_1">Create Page</div><div class="help_button" id="help_button" onMouseOver="OpenHelpList();" onclick="OpenHelpWindow('create');">&nbsp;</div></div>
	
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowEnterPageName();" id="enter_page_name_btn"><span class='button_text_sub_level_1'>Enter Name of Page</span></div>
    
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowPlugins();" id="add_plugin_btn"><span class='button_text_sub_level_1'>Add Plugin</span></div>
    
    <div class='button_sub_level_1' style='width:258px;' onClick="ShowSelectLayout();" id="select_layout_btn"><span class='button_text_sub_level_1'>Select Layout</span></div>
</div>
		<form name="frmCreatePage" id="frmCreatePage" method="post" action="create_page.php">
        
        <input name="createPage" type="text" id="createPage" style="width:300px; display:none;" onblur="SelectPageName();" onkeyup="CheckPageName(this.value);" />
        
        <div id="select_layout_div" style="display:none;">

          <?php
		  	$query2 = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options_selected` WHERE `option_name` = 'Template'";
			$result2 = $bwb_dbh->query($query2);
			$row2 = $result2->fetch(PDO::FETCH_ASSOC);
			$option_value_selected = $row2["option_value"];
		
		  	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "options` WHERE `option_name` = 'Template' ORDER BY `sort_order`";
			$result = $bwb_dbh->query($query);
			$i = 0;
			$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
			while ($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$option_value = $row["option_value"];				
			 	
				if ($option_value_selected == $option_value)
					echo "<div class='button_sub_level_1 down_sub' id='layout_select$i' style='width:200px;$top_border_style' onClick=\"UpdateTemplateImage($i);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
				else
					echo "<div class='button_sub_level_1' id='layout_select$i' style='width:200px;$top_border_style' onClick=\"UpdateTemplateImage($i);\"><span class='button_text_sub_level_1'>$option_value</span></div>\n";
				$top_border_style = "";
				$i++;
			}
			?>

     <input type="hidden" id="template_name" name="template_name" value="<?php echo $option_value_selected; ?>" />
     
     <div id="template_pic_div"><img id="template_pic_edit" src="images/<?php echo $option_value_selected; ?>.jpg" border="0"></div>
     </div>
            
            <div id="select_plugin_div" class="vertical_scroll_div" style="display:none;">
          <?php
			$cat_id = 0;
			$parent_cat_id = 0;
			$i = 0;
			$j = 0;
			$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
			
		  	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (parent_category IS NULL) OR (parent_category = '') ORDER BY sort_order";
			$result = $bwb_dbh->query($query);
			while($row = $result->fetch(PDO::FETCH_ASSOC))
			{
				$category = $row['category'];
				$parent_cat_id = $cat_id;
				echo "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;$top_border_style' onClick=\"SelectPluginCategory($cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$category</span></div>\n";
				$j++;
				$top_border_style = "";
				
				$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$category') ORDER BY `sort_order`";
				$result3 = $bwb_dbh->query($query);
				$num_results = $result3->rowCount();
				if ($num_results > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}
				
				$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
				while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
				{
					$id = $row3["id"];
					$plugin_name = $row3["name"];
					$description = $row3["description"];
					if ($description != "")
						$description = " - " . $description;
						
					echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i);\"><span class='button_text_sub_level_1'>$plugin_name$description</span></div>\n";
					$i++;
					$top_border_style = "";
				}
				if ($num_results > 0)
					echo "</div>\n";
					
				$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "plugin_categories WHERE (parent_category = '$category') ORDER BY sort_order";
				$result2 = $bwb_dbh->query($query);
				if ($result2->rowCount() > 0)	{
					echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
					$cat_id++;
				}

				while($row2 = $result2->fetch(PDO::FETCH_ASSOC))
				{
					$sub_category = $row2['category'];
					echo "<div id='cat_select$j' class='button_sub_level_1' style='width:258px;' onClick=\"SelectPluginCategory($cat_id, $parent_cat_id);\"><span class='button_text_sub_level_1'>$sub_category</span></div>\n";
					$j++;
					
					$query = "SELECT `id`, `name`, `description` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE (`available` = 1) AND (`category` = '$sub_category') ORDER BY `sort_order`";
					$result3 = $bwb_dbh->query($query);
					$num_results = $result3->rowCount();
					if ($num_results > 0)	{
						echo "<div style='margin-left:20px; display:none;' id='div_$cat_id'>\n";
						$cat_id++;
					}
					
					$top_border_style = "border-top-width:1px;border-top-color:#585858;border-top-style:solid;";
					while($row3 = $result3->fetch(PDO::FETCH_ASSOC))
					{
						$id = $row3["id"];
						$plugin_name = $row3["name"];
						$description = $row3["description"];
						if ($description != "")
							$description = " - " . $description;
						
						echo "<div id='plugin_select$i' class='button_sub_level_1' style='width:99%;$top_border_style' onClick=\"SelectPlugin('$id', $i);\"><span class='button_text_sub_level_1'>$plugin_name$description</span></div>\n";
						$i++;
						$top_border_style = "";
					}
					if ($num_results > 0)
						echo "</div>\n";
				}
				if ($result2->rowCount() > 0)
					echo "</div>\n";
			}
			
            ?>
            <div class='button_console_delete' style="width:258px; display:none;" onClick="ClearPlugin();" id="clear_plugin_btn"><span class='button_console_text_w_icon'>Clear Plugin</span></div>
            <input type="hidden" name="plugin" id="plugin" value="-not selected-" />
            <input type="hidden" name="plugin_cnt" id="plugin_cnt" value="<?php echo $plugin_cnt; ?>" />
            <input type="hidden" name="cat_cnt" id="cat_cnt" value="<?php echo $cat_id; ?>" />
            </div>
            
            <div id="selections_div">
            <div id="selected_page_name" class="selection_div">&lsaquo;&mdash; <em>(required)</em></div>
            <div id="selected_plugin" class="selection_div">&lsaquo;&mdash; <em>(optional)</em></div>
            <img id="template_pic" src="images/<?php echo $option_value_selected; ?>.jpg" border="0">
            </div>
           
        <div class='button_console_add_disabled' onClick="document.getElementById('frmCreatePage').submit();" id="create_btn"><span class='button_console_text_w_icon'>Create</span></div>
        
          <input type="hidden" name="mode" value="create" />
	  </form>


	<div id="help_list" style="display:none;" onMouseOut="fixOnMouseOut(this, event, 'CloseHelpList();');">
    	<div id='help_list_close_btn'><img src='images/close-button.png' alt='Close' onClick="document.getElementById('help_list').style.display='none';" style='cursor:pointer;' /></div>
    	<span onClick="window.open('http://breezewebsitebuilder.com/docs/cms/help.html#create', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'>Creating a Page</span><br />
		<hr /><span onClick="window.open('http://breezewebsitebuilder.com/docs/cms/help.html#plugins', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'>Plugins</span><br />
		<hr /><span onClick="window.open('http://breezewebsitebuilder.com/docs/cms/help.html#start', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'>Selecting Page Layout</span><br />
        <hr /><span onClick="window.open('http://breezewebsitebuilder.com/docs/cms/help.html#create_page_tips', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');" style='cursor:pointer'>Helpful Tips</span>
    </div>
</body>
</html>