<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 11/13/2013
// Modified: 3/22/2014	ELL
// Added graceful handling of allow_url_fopen not set.
// 
	
	include ("check_session.php");
	
	if (BWB_REQUIRE_SSL == 1)
		$http = "https://";
	else
		$http = "http://";
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<link rel="stylesheet" href="manager.css" type="text/css">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}
/*
body	{
	background-image:url(images/Breeze_logo_large_lt-gray.png);
	background-repeat:no-repeat;
	background-position:center;
	background-attachment:fixed;
}
*/
.install_files_warning	{
	color:#Ff0000;
	font-size:18px
}
.download_button	{
	display:inline;
	background-color:#585858;
	color:#FFFFFF;
	padding-top:5px;
	padding-bottom:5px;
	padding-left:15px;
	padding-right:15px;
}
.download_button:hover	{	
	cursor:pointer;
	background-color:#A6A6A6;
	color:#2C2C2C;
}
</style>

<script language="javascript" type="text/javascript">
	function OpenHelpWindow()
	{
		window.open("<?php echo $http; ?>breezewebsitebuilder.com/docs/cms/help.html#dashboard", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
	}
</script>

</head>
<body id="workspace_body">

<div class="button_heading_sub_level_1" id="dashboard_heading"><div class="button_heading_text_sub_level_1">Dashboard</div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>

<p>Welcome <?php echo $userid;	?> to the Breeze Website Builder&#8482;.  Click on any of the menu headings on the left to access the system tools for building your website.</p>

<?php
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$install_file = $document_root . "/install/do_install.php";
	$run_sql_file = $document_root . "/install/run_sql_install.php";
	if (file_exists($install_file) || file_exists($run_sql_file))
	{
?>
	<p class="install_files_warning"><b>WARNING!!!</b> Your installation folder is still present on the server.  Your site could easily be compromised.  Please click <a href="delete_install.php"><b>here</b></a> to delete the <b><em>install</em></b> and <b><em>SQL</em></b> folders from your server.</p>
<?php
	}
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "version`";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$version = $row["version"];
	
	if ((ini_get("allow_url_fopen") == 1) || (ini_get("allow_url_fopen") === true) || (strtolower(ini_get("allow_url_fopen")) == "on"))
	{
		$url = $http . 'breezewebsitebuilder.com/breeze_version.php';
		$latest_version = file_get_contents($url);
			
		if ($version == $latest_version)
			echo "The latest version of the Breeze Website Builder&#8482; is installed: Version: $version<br />\n";
		elseif ($version > $latest_version)
			echo "You are currently running beta version $version of the Breeze Website Builder&#8482;.  The current stable release is $latest_version.<br />\n";
		else
		{
			$url = $http . 'breezewebsitebuilder.com/download_page.php?last_id=dashboard#updates';
			echo "Version $version of the Breeze Website Builder&#8482; is installed.  The latest version is $latest_version.  Click <span class='download_button' onClick=\"window.open('$url');\"> Download </span>&nbsp;to download the latest version.<br />\n";
			echo "<div style='padding-top:5px;'>\n";
			if ($access_level == "admin")
				echo "After downloading update, click <span class='download_button' onClick=\"parent.workspace.location='upload_update.php';\"> here </span> to install the update.<br />\n";
			else
				echo "You will need to be logged in as an administrator to install the update.  Contact your system administrator to update your system.<br />\n";
			echo "</div>\n";
		}
	}
	else
	{
		echo "Version $version of the Breeze Website Builder&#8482; is installed. <span class='extra_small_message'><br />Note: We cannot compare your version with the latest version because the PHP directive <b><i>allow_url_fopen</i></b> is turned off.  To have this dashboard check your version and provide you with links to updates, you will need to set <b><i>allow_url_fopen</i></b> to <b><i>1</i></b> in your <b><i>php.ini</i></b> file.</span><br />\n";
	}
	
?>


<p>Page count: 
<?php 
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo $num_results;
?>
</p>
<p>Blog count: 
<?php 
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "blogs ORDER BY revised";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	echo $num_results;
?>
</p>

<iframe src="<?php echo $http; ?>breezewebsitebuilder.com/news.php?license=<?php echo BWB_SN; ?>&version=<?php echo $version; ?>" id="announcements_frame" scrolling="no"></iframe>

</body>
</html>