<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created : 11/16/2014
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Revised: 1/22/2015	ELL
// Updated CKEditor from version 4.4.5 to version 4.4.6.
	
	include ("check_session.php");
		
	$file_name = $_REQUEST['file_name'];
	$folder = $_REQUEST['folder'];
	$file_parts = explode(".", strrev($file_name));
	$ext = strrev($file_parts[0]);
	
	if ($folder == "pages")
	{
		$_SESSION['last_file_edited'] = $file_name;
		if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
			$path = $document_root . "/" . $file_name;
		elseif (BWB_BASE_DIR == '')
			$path = $document_root . "/" . BWB_WEBPAGE_DIR . "/" . $file_name;
		else
			$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/" . $file_name;
	}
	elseif ($folder == "scripts")
	{
		$_SESSION['last_script_edited'] = $file_name;
		if (BWB_BASE_DIR == '')
			$path = $document_root . "/" . BWB_SCRIPTS_DIR . "/" . $file_name;
		else
			$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/" . $file_name;
	}
	elseif ($folder == "php")	{
		$_SESSION['last_php_edited'] = $file_name;
		$path = $document_root . "/php/" . $file_name;
	}

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CodeMirrorTheme'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))	{
		$CodeMirrorTheme = $row['option_value'];
		if (strpos($CodeMirrorTheme, "solarized") !== false)
			$CodeMirrorCSS = "solarized";
		else
			$CodeMirrorCSS = $row['option_value'];
	}
	else	{
		$CodeMirrorTheme = "rubyblue";
		$CodeMirrorCSS = "rubyblue";
	}
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="../ckeditor/plugins/codemirror/theme/<?php echo $CodeMirrorCSS; ?>.css">

<script type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/edit_file.js"></script>
<script language="javascript" type="text/javascript" src="../ckeditor/ckeditor.js"></script>

<script>
	var file_name = "<?php echo $file_name; ?>";
	var folder = "<?php echo $folder; ?>";
	
	var saved = true;
 
	var browser = BrowserDetect.browser;
	var browser_version = BrowserDetect.version;
</script>

</head>

<body id="workspace_body">
<div style='text-align:center;'>
<form name="frmEditHead" id="frmEditHead" action="save_head.php" method="post">

	<div style="height:93%; width:100%;" id="editorContainer" name="editorContainer"></div>

	<script type="text/javascript" language="javascript">
    //<![CDATA[
		CKEDITOR_BASEPATH = '../ckeditor/';
		
		CKEDITOR.replace( 'editorContainer', { contentsCss : ['/ckeditor/contents.css'] });

		CKEDITOR.config.extraPlugins = 'codemirror';
		CKEDITOR.config.skin = 'kama';
		CKEDITOR.config.allowedContent = true;
		
		CKEDITOR.config.toolbarGroups = [
    { name: 'document',    groups: [ 'mode', 'document', 'doctools' ] },
    { name: 'editing',     groups: [ 'find', 'selection' ] },
    { name: 'tools' },
    { name: 'others' },
    { name: 'about' }
];
		
	CKEDITOR.config.removePlugins = 'newpage,print,templates,showblocks';
	CKEDITOR.config.removeButtons = 'Source';
	
	var editorElem = document.getElementById("editorContainer");
	CKEDITOR.config.width = '99%';

	if ((browser == "Explorer") && (browser_version <= 7))
		CKEDITOR.config.height = document.body.clientHeight - 169;
	else if ((browser == "Opera") && (browser_version < 13))
		CKEDITOR.config.height = window.innerHeight - 144;
	else if ((browser == "Explorer") && (browser_version == 8))
		CKEDITOR.config.height = document.body.clientHeight - 144;
	else
		CKEDITOR.config.height = editorElem.clientHeight - 74;
	CKEDITOR.config.resize_enabled = false;

	CKEDITOR.config.startupMode = 'source';

		
	CKEDITOR.config.codemirror = {
		 // Set this to the theme you wish to use (codemirror themes)
		theme: '<?php echo $CodeMirrorTheme; ?>',
		// Whether or not you want Brackets to automatically close themselves
		autoCloseBrackets: true,
		 // Whether or not you want tags to automatically close themselves
		autoCloseTags: true,
		 // Whether or not to automatically format code should be done when the editor is loaded
		autoFormatOnStart: true, 
		// Whether or not to automatically format code which has just been uncommented
		autoFormatOnUncomment: true,
		// Whether or not to continue a comment when you press Enter inside a comment block
		continueComments: true,
		 // Whether or not you wish to enable code folding (requires 'lineNumbers' to be set to 'true')
		enableCodeFolding: true,
		// Whether or not to enable code formatting
		enableCodeFormatting: true,
		// Whether or not to enable search tools, CTRL+F (Find), CTRL+SHIFT+F (Replace), CTRL+SHIFT+R (Replace All), CTRL+G (Find Next), CTRL+SHIFT+G (Find Previous)
		enableSearchTools: true,
		// Whether or not to highlight all matches of current word/selection
		highlightMatches: true,
		 // Whether, when indenting, the first N*tabSize spaces should be replaced by N tabs
		indentWithTabs: false,
		 // Whether or not you want to show line numbers
		lineNumbers: true,
		// Whether or not you want to use line wrapping
		lineWrapping: true,
		 // Define the language specific mode 'htmlmixed' for html  including (css, xml, javascript), 'application/x-httpd-php' for php mode including html, or 'text/javascript' for using java script only 
		//mode: 'htmlmixed',
<?php
	if (($ext == "php") || ($ext == "inc"))
		echo "		mode: 'application/x-httpd-php',\n";
	elseif ($ext == "js")
		echo "		mode: 'text/javascript',\n";
	elseif (($ext == "html") || ($ext == "htm"))
		echo "		mode: 'htmlmixed',\n";
	elseif ($ext == "css")
		echo "		mode: 'text/css',\n";
	elseif (($ext == "c") || ($ext == "cc"))
		echo "		mode: 'text/x-csrc',\n";
	elseif ($ext == "cpp")
		echo "		mode: 'text/x-c++src',\n";
	elseif (($ext == "java") || ($ext == "class"))
		echo "		mode: 'text/x-java',\n";
	elseif (($ext == "pl") || ($ext == "perl") || ($ext == "cgi"))
		echo "		mode: 'text/x-perl',\n";
	elseif (($ext == "py") || ($ext == "pyc") || ($ext == "pym") || ($ext == "pyo") || ($ext == "pyw") || ($ext == "rpy"))
		echo "		mode: 'text/x-python',\n";
	elseif (($ext == "rb") || ($ext == "rhtml") || ($ext == "rjs"))
		echo "		mode: 'text/x-ruby',\n";
	elseif ($ext == "sql")
		echo "		mode: 'text/x-mysql',\n";
	elseif ($ext == "xml")
		echo "		mode: 'application/xml',\n";
	else
		echo "		mode: 'htmlmixed',\n";
?>
		// Whether or not you want to highlight matching braces
		matchBrackets: true,
		// Whether or not you want to highlight matching tags
		matchTags: true,
		// Whether or not to show the showAutoCompleteButton   button on the toolbar
		showAutoCompleteButton: true,
		 // Whether or not to show the comment button on the toolbar
		showCommentButton: true,
		// Whether or not to show the format button on the toolbar
		showFormatButton: true,
		 // Whether or not to show the search Code button on the toolbar
		showSearchButton: true,
		 // Whether or not to show Trailing Spaces
		showTrailingSpace: true,
		// Whether or not to show the uncomment button on the toolbar
		showUncommentButton: true,
		 // Whether or not to highlight the currently active line
		styleActiveLine: true,
		// "Whether or not to use Beautify for auto formatting
		useBeautify: false
	};
		
	var bwb_ckeditor = CKEDITOR.instances['editorContainer'];

	function somethingChanged()	{
		if ( bwb_ckeditor.checkDirty() )
		{
			saved = false;
			window.parent.SetWorkSavedNotSaved(saved);
			try	{
				bwb_ckeditor.commands.save.enable();
			}
			catch(err)	{
				err = 0;
			}
		}
	}

	function somethingHappened(e)	{
//			alert(e.data.name);
		if ( bwb_ckeditor.checkDirty() )
			window.parent.SetWorkSavedNotSaved(true);
			
		if (e.data.name == "newpage")
		{
			e.data.command = null;
			//ClearContent();
		}
		else if (e.data.name == "preview")
		{
			e.data.command = null;
//				Save('Preview');
		}
		else if (e.data.name == "save")
		{
			e.data.command = null;
			Save('Save');
			try	{
				bwb_ckeditor.commands.save.disable();
			}
			catch(err)	{
				err = 0;
			}
			bwb_ckeditor.resetDirty();
		}
		else if (e.data.name == "source")
		{
			e.data.command = null;
		}
	}

	LoadFile();
	
	bwb_ckeditor.on( 'saveSnapshot', function(e) { somethingChanged(); });
	bwb_ckeditor.on( 'beforeCommandExec', function(e) { somethingHappened(e); });
	
//]]>
</script>
 
  <table width="90%" align="center" id="btn_table"><tr>
  <td align="left" class="medium_message" width="9%">
  <span id="page_name_label">File Name:<br /><?php echo $file_name; ?></span>
  </td>
<?php if ($folder == "pages")	{	?>
  <td align="center">
  <div class='button_console_preview' style="width:110px;" onClick="Preview();"><span class='button_console_text_w_icon'>Preview</span></div>
  </td>
<?php }	?>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="Save('save');"><span class='button_console_text_w_icon'>Save</span></div>
  </td>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="ShowSaveAsMsg();"><span class='button_console_text_w_icon'>Save As</span></div>
  </td>
  <td align="center">
  <div class='button_console_save' style="width:110px;" onClick="Save('publish');"><span class='button_console_text_w_icon'>Publish</span></div>
  </td>
   <td align="center">
  <div class='button_console_cancel' style="width:110px;" onClick="RevertConfirm();"><span class='button_console_text_w_icon'>Revert</span></div>
  </td>
  <td align="center">
  <div class='button_console_delete' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'>Delete</span></div>
  </td>
  <td align="center">
  <div class='button_console_preview' style="width:110px;" onClick="window.open('<?php echo $path; ?>', '_blank');"><span class='button_console_text_w_icon'>See File</span></div>
  </td>
  <td align="right" width="10%"><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></td>
  </tr></table>
      
</form>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="JavaScript"  type="text/javascript">
	HidePopupMsg();
	mTimer3 = setTimeout("LoadFile();", 1500);
	mTimer = setTimeout("bwb_ckeditor.commands.save.disable(); saved = true; window.parent.SetWorkSavedNotSaved(true);", 4000);
	mTimerCheckDirty = setInterval("somethingChanged();", 8000);
	
	if (document.body.scrollWidth > document.body.clientWidth)
		CKEDITOR.config.height = CKEDITOR.config.height - 40;
</script>

</body>
</html>
