<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/9/2013
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
//
	
	include ("check_session.php");
	
	$enable_file_manager = $_SESSION['enable_file_manager'];
	if ($enable_file_manager != "100")
		header("Location: /index.php");
		
	include ("lib/copy_dir.php");
	
	//////////////////////////////////////
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	//////////////////////////////////////////
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</script>
</head>
<body>
<h2>Installing plugin....</h2>
<?php
	
	if (is_uploaded_file($_FILES['plugin_file']['tmp_name']))
	{	
		$source = $_FILES['plugin_file']['tmp_name'];
		$file_name = $_FILES['plugin_file']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		if (!((strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "zip") == 0) || (strcasecmp($file_ext, "tar") == 0)))
		{
			echo "Only zipped files or gzipped tar files are allowed to be uploaded, i.e. 'plugin.zip' or 'plugin.tgz' or 'plugin.tar.gz'.  Please click <a href='upload_plugin.php'>here</a> and try again.";
			exit;
		}
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . "/" . $file_name;
		move_uploaded_file( $source, $destination );
		$source = $destination;
		
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		// Note: phar->decompress removes the all of the file name after the FIRST dot "." then appends the ".tar"
			$tar_source =  $document_root . "/" . $file_parts[0] . ".tar";
		
		$destination = $document_root . "/tmp";
		if (!file_exists($destination))
			mkdir($destination, 0755);
		else
		{
			$bkup = $destination . date('YmdHis', time());
			rename($destination, $bkup);
			mkdir($destination, 0755);
		}
		
		echo "Extracting files...<br><br>\n";
		// Extract contents of archive to disk
		if (strcasecmp($file_ext, "zip") == 0)
		{
			$zip = new ZipArchive;
			$res = $zip->open($source);
			if ($res === TRUE) {
			  $zip->extractTo($destination);
			  $zip->close();
			} else {
			  echo "There was an error extracting the files from your zip file.  Click <a href='upload_plugin.php'>here</a> to try again.";
			  exit;
			}
		}
		elseif ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0))
		{
			// decompress from gz
			try {
				$p = new PharData($source);
				$p->decompress(".tar"); // creates /path/to/my.tar
			} catch (Exception $e) {
				echo "There was an error extracting the files from your tar.gz file.  Click <a href='upload_plugin.php'>here</a> to try again.<br/>$e";
				exit;
			}
		}
		
		// unarchive from the tar
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		{
			try {
				$phar = new PharData($tar_source);
				$phar->extractTo($destination, null, true);
			} catch (Exception $e) {
				echo "There was an error extracting the files from your tar file.  Click <a href='upload_plugin.php'>here</a> to try again.<br/>$e";
				exit;
			}
		}
			
		// Copy files to correct folders.
		echo "Copying files...<br><br>\n";
		$extracted_source = $document_root . "/tmp";
		$destination = $document_root;
		copydir($extracted_source, $destination, 0755, true);
		unlink($document_root . "/plugin.sql");
		unlink($source);
		unlink($tar_source);
		
		// Run template SQL
		$sql_file = "plugin.sql";
		include ("run_sql_file.php");
		
		$_SESSION['button_group'] = "other_functions";
		$_SESSION['button'] = "btn_users_site_options";	
?>
		<h2>Plugin installation is comlplete.</h2>
        <p>Click <a href="main.php" target="_top">here</a> to add new plugin button to menu.</p>

<?php
	}
	else
		echo "There was an error uploading the file.  Click <a href='upload_plugin.php'>here</a> to try again.";
?>