/////////////////////////////////////////////
// Add Plugin To Page Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Modified: 10/15/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 11/9/2014	ELL
// Fix bugs with not being able to select plugin.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#install_plugin_into_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function SelectPage(page_name, i)
{
	document.getElementById('page_name').value = page_name;
	
	var page_name_select_ctl = "";
	var page_cnt = document.getElementById('page_cnt').value;
	for (var n = 0; n <page_cnt; n++)
	{
		page_name_select_ctl = "page_name_select" + n;
		document.getElementById(page_name_select_ctl).className = "button_sub_level_1";
	}
	page_name_select_ctl = "page_name_select" + i;
	document.getElementById(page_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById('selected_page').innerHTML = "<b><em>" + page_name + "</em></b> page selected";
	CheckForm();
}

function SelectPlugin(plugin, i)
{
	document.getElementById('plugin').value = plugin;
	
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n <plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		try	{
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
		} 	catch(e)	{	e = 0;	}
	}
	plugin_name_select_ctl = "plugin_select" + i;
	document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById('selected_plugin').innerHTML = "<b><em>" + plugins[plugin] + "</em></b> plugin selected";
	CheckForm();
}

function SelectPluginCategory(cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_id_str = "div_" + cat_id;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			try	{
				document.getElementById(cat_div_str).style.display = "none";
			} 	catch(e)	{	e = 0;	}
			cat_select = "cat_select" + i;
			try	{
				document.getElementById(cat_select).className = "button_sub_level_1";
			} 	catch(e)	{	e = 0;	}
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	try	{
		document.getElementById(cat_id_str).style.display = "block";
	} 	catch(e)	{	e = 0;	}
}

function CheckForm()
{
	if ((document.getElementById('page_name').value != "") && (document.getElementById('plugin').value != ""))
		document.getElementById("install_plugin_btn").className = "button_console_add";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}