/////////////////////////////////////////////
// Edit Custom CSS /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 1/1/2014	ELL
// Revised: 10/20/2014	ELL
// Converted editor for simple text area to CKEditor is source view.
// Revised: 11/21/2014	ELL
// Added delete head.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Added "Save As"

var mTimer;

var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_head", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////
function LoadHead()
{
	$.post( "get_head.php", { head_name: head_name } ).done(CompleteLoadHead) ;
}
function CompleteLoadHead(data)
{
//	alert(data);
	CKEDITOR.instances['editorContainer'].setData(data);
}

function Save(action)
{
	var head_content = CKEDITOR.instances['editorContainer'].getData();
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	$.post( "save_head.php", { head_name: head_name, head_content: head_content, action: action } ).done(CompleteSave) ;
}
function CompleteSave(data)	{
	popup_msg.status_msg = data;
//	alert(data);
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	saved = true;
	window.parent.SetWorkSavedNotSaved(saved);
	bwb_ckeditor.resetDirty();
}

function RevertConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Are you sure you want to revert the <b>" + head_name + "</b> head?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { Revert(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}
function Revert()
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Reverting to last published version...";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	$.post( "revert_head.php", { head_name: head_name } ).done(CompleteRevert) ;
}
function CompleteRevert(data)
{
	if (data == "No draft found")
		popup_msg.status_msg = data;
	else	{
		popup_msg.status_msg = "Revert completed";
		CKEDITOR.instances['editorContainer'].setData(data);
	}
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

function Preview()
{
	var head_content = CKEDITOR.instances['editorContainer'].getData();

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Preparing preview...";
	popup_msg.popup_timeout = 2000;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	$.post( "preview_head_init.php", { head_content: head_content }, function(data){ document.getElementById("StatusMsg").innerHTML = data; }, "text" ) ;
	
	var preview_page_string = "preview_page.php?page_name=" + head_name + "&special=2&mode=0&blog_id=0";
	window.open(preview_page_string, "Preview", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=900,width=1000");
}

function DisplayNotSavedMessage(btn)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Your CSS is not saved.  Do you want to save your changes?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { SaveBeforeMain(); };
	document.getElementById("popup_button_1_span").onclick = function () { DoMainMenuAction(); };
}

function SaveBeforeMain()
{
	Save('Save');
	var mTimer2 = setTimeout('DoMainMenuAction();', 5000);
}

function DoMainMenuAction()
{
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.DoNextClick();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_msg_cell = "Are you sure you want to delete the <b>" + head_name + "</b> head?";
	popup_msg.popup_button_2_span = "Yes";
	popup_msg.popup_button_1_span = "No";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteHead(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

function DeleteHead()
{
	HidePopupMsg();
	var url = "delete_head.php?head_name=" + head_name + "&redirect=edit_head_select.php";
	window.location = url;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function ShowSaveAsMsg()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.popup_msg_type = 4;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.popup_prompt_cell = "Save as: head_";		
	popup_msg.popup_button_2_span = "Cancel";
	popup_msg.popup_button_1_span = "OK";
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { HidePopupMsg(); };
	document.getElementById("popup_button_1_span").onclick = function () { SaveAs(); };
}

function SaveAs()
{
	var old_head_name = head_name;
	var new_head_name = document.getElementById("popup_prompt_textbox").value;
	if ((new_head_name == null) || (new_head_name == ""))
	{
		alert("Head name cannot be blank. Please enter a head name and try again.");
		return;
	}
	new_head_name = "head_" + new_head_name;
	
	var head_exists;
	$.post( "check_head_exists.php", { head_name: new_head_name }, function(data){ head_exists = data; }, "text" ) ;
		
	if (head_exists == "1")
		alert("Head " + new_head_name + " already exists. Please go back to the main menu to copy and rename your heads.");
	else
	{
		head_name = new_head_name;
	
		var cnt;
		$.post( "copy_head.php", { old_head_name: old_head_name, new_head_name: new_head_name }, function(data){ cnt = data; }, "text" ) ;
		document.getElementById("page_name_label").innerHTML = new_head_name;
		Save('publish');
	}
	
	HidePopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

	var editorWidth = mainWidth - menuWidth;
	var editorHeight = mainHeight - headerHeight - 58;

	CKEDITOR.instances['editorContainer'].resize(editorWidth, editorHeight);
	
	tableWidth = editorWidth - 50;
	sTableWidth = tableWidth.toString() + "px";
	document.getElementById("btn_table").style.width = sTableWidth;
}