<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
//
function resize_image($filename, $width, $height, $destfile, $messageflag)
{
    $image = imagecreatefromjpeg($filename);
    if (!$image)
		return 0;

    list($width_orig, $height_orig) = getimagesize($filename);

    if ($width_orig < $width && $height_orig < $height)
    {
		if ($messageflag != 1)
			echo "ORIGINAL IMAGE $filename SIZE ($width_orig, $height_orig) IS TOO SMALL!<br>";
		if ($filename == $destfile)
			return 1;
		else
			return copy($filename, $destfile);
    }
	
    if (($width / $width_orig) * $height_orig > $height) {
		$width = ($height / $height_orig) * $width_orig;
    } else {
		$height = ($width / $width_orig) * $height_orig;
    }

    // Resample
    $image_p = imagecreatetruecolor($width, $height);
    imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);

    // Output
    imagejpeg($image_p, $destfile, 80);	// quality 80
    @chmod($destfile, 0644);
    return 1;
}

function crop_image($filename, $crop_percent, $destfile, $crop_area)
{		
	// Create original image
	$origimg = imagecreatefromjpeg($filename);
	if (!$origimg)
		return 0;
		
	// Get the original size
    list($width_orig, $height_orig) = getimagesize($filename);
	
	if (($crop_area == "center") || ($crop_area == ""))
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	else if ($crop_area == "top")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartY = round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
	}
	else if ($crop_area == "bottom")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartY = $height_orig - $cropH - round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartY = $height_orig - $cropH - round($height_orig * ($crop_percent/100));
			$cropStartX = round($width_orig/2 - $cropH/2);
		}
	}
	else if ($crop_area == "left")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	else if ($crop_area == "right")
	{
		//Crop to percent of smallest dimension.
		if ($width_orig > $height_orig)	//height dominated
		{
			$cropH = round($height_orig * ((100 - 2 * $crop_percent)/100));
			$cropW = $cropH;	//square crop
			$cropStartX = $width_orig - $cropW - round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
		else	//width dominated
		{
			$cropW = round($width_orig * ((100 - 2 * $crop_percent)/100));
			$cropH = $cropW;	//square crop
			$cropStartX = $width_orig - $cropW - round($width_orig * ($crop_percent/100));
			$cropStartY = round($height_orig/2 - $cropW/2);
		}
	}
	
	// Create image to store cropped image in.
	$cropimg = imagecreatetruecolor($cropW,$cropH);
	
	// Crop
	imagecopyresized($cropimg, $origimg, 0, 0, $cropStartX, $cropStartY, $cropW, $cropH, $cropW, $cropH);

    // Output
    imagejpeg($cropimg, $destfile, 80);	// quality 80
    @chmod($destfile, 0644);
    return 1;
}
?>