<?php
/////////////////////////////////////////////
// Manage Page Access Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 6/28/2012	ELL
// Revised: 2/12/2013	ELL
// Added paging to user table.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 11/6/2014	ELL
// Overhauled individual user management areas at bottom as AJAX functions.
// 
// 
//
	include ("check_session.php");
	
	$last_user_table = $_SESSION['last_user_table'];
	$last_user = $_SESSION['last_user'];
	$last_access_level = $_SESSION['last_access_level'];
	
	$username_pass_change = $_REQUEST['user_name'];
	$password_pass_change = $_REQUEST['password'];
	$new_username = $_REQUEST['new_username'];
	$new_user_access_level = $_REQUEST['access_level'];
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#manage_restricted_pages_users_heading	{	width:400px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:350px;
	height:31px;
	width:31px;
	z-index:100;
}
#add_fields_to_table_btn	{
	width:230px;
	height:60px;
}
#assign_message_page_to_user_table_btn	{
	width:230px;
	height:60px;
}
#add_access_level_btn	{	width:110px;	}
#remove_access_level_btn	{	width:110px;	}
#generate_password_btn	{	width:170px;	}
#add_user_btn	{	width:110px;	}
#generate_password_btn2	{	width:170px;	}
#change_password_btn	{	width:180px;	}
#delete_user_btn	{	width:110px;	}
#edit_user_btn		{	width:110px;	}
</style>

<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/ajax.js"></script>
<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<script type="text/javascript" src="js/manage_page_access.js"></script>

<script language="javascript" type="text/javascript">

var pages = new Array();
var tables = new Array();
var access_levels = new Array();
var login_pages = new Array();
var bgclr = "#eeeeee";
var update_page_table_mode = 0;
<?php echo "var last_user_table = '$last_user_table';\n"; ?>
<?php echo "var last_user = '$last_user';\n"; ?>
<?php echo "var last_access_level = '$last_access_level';\n"; ?>
var access_level_add = "-not set-";
var access_level_remove = "-not set-";

<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_name = $row["page_name"];
		echo "pages[$j] = '$page_name';\n";
	}
	echo "var page_cnt = $j;\n\n";
	
	$query = "SHOW TABLES";
	$result = $bwb_dbh->query($query);
	$tmp_table = "";
	$j = 0;
	$tables = array();
	$rows = $result->fetchAll(PDO::FETCH_NUM);
	foreach ($rows as $row)
	{
	
		$tmp_table = $row[0];
		if ((substr($tmp_table, 0, strlen(BWB_TABLE_PREFIX)) != BWB_TABLE_PREFIX) || (BWB_TABLE_PREFIX == ""))
		{
			echo "tables[$j] = '" . $tmp_table . "';\n";
			$tables[$j] = $tmp_table;
			$j++;
		}
	}
	echo "var table_cnt = $j;\n\n";
	$table_cnt = $j;
	
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "access_levels";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$access_level = $row["access_level"];
		echo "access_levels[$j] = '$access_level';\n";
	}
	echo "var access_level_cnt = $j;\n\n";
	
	
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name LIKE '%login%'";
	$result = $bwb_dbh->query($query);
	$num_results = $result->rowCount();
	for ($j = 0; $j < $num_results; $j++)
	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$login_page = $row["page_name"];
		echo "login_pages[$j] = '$login_page';\n";
	}
	echo "var login_page_cnt = $j;\n\n";
?>

</script>

</head>

<body id="workspace_body">
<br>
<div align="center">
<table width="95%" border="0"><tr>
<td>
<div class="button_heading_sub_level_1" id="manage_restricted_pages_users_heading"><div class="button_heading_text_sub_level_1">Manage Restricted Pages &amp; Website Users</div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
</tr></table>

<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
  <div id="PageRestrictionsTable">
	&nbsp;
  </div>
  <input type="hidden" name="nCount" id="nCount" />
  </td></tr></table>
  <br />
  
<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" class="layout_box_table">
  <tr>
    <td class="sub_title">Approve Access to Users</td>
     <td align="right" class='header_row'><b>Table:</b>&nbsp;</td>
    <td>
    <select name="user_table_for_users_table" id="user_table_for_users_table" onChange="RetrieveUserLists(this.value, true);">
    	<option>-not selected-</option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
  </tr>
  
  <tr>
    <td colspan="3">  
     <table border="0" width="95%" align="center">
      <tr id="user_nav_row_top">
        <td width="25%" align="center">
         <img src="./images/First.gif" id="first_top" border="0" onClick="moveFirst();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Previous.gif" id="prev_top" border="0" onClick="movePrev();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Next.gif" id="next_top" border="0" onClick="moveNext();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Last.gif" id="last_top" border="0" onClick="moveLast();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
  
  <tr>
  	<td colspan="3"><div id="UsersTable">&nbsp;</div></td>
  </tr>
  
  <tr>
    <td colspan="3">  
     <table border="0" width="95%" align="center">
      <tr id="user_nav_row_bot">
        <td width="25%" align="center">
         <img src="./images/First.gif" id="first_bot" border="0" onClick="moveFirst();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Previous.gif" id="prev_bot" border="0" onClick="movePrev();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Next.gif" id="next_bot" border="0" onClick="moveNext();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
        <td width="25%" align="center">
          <img src="./images/Last.gif" id="last_bot" border="0" onClick="moveLast();" style="cursor:default;" onMouseOver="this.style.cursor='pointer';" />
        </td>
      </tr>
    </table>
    </td>
  </tr>
  
</table>
</td></tr></table>
  <br />
  
<table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title">User Table Setup</td>
  </tr>
  <tr>
    <td align="right">Table:&nbsp;</td>
    <td>
    <select name="user_table_for_fields" id="user_table_for_fields" onChange="RetrieveUserLists(this.value);">
      <option>-not selected-</option>
      <?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
    <td>
    <div class='button_console_add' id="add_fields_to_table_btn" onClick="AddFieldsToTable();"><span class='button_console_text_w_icon'>Add User Login<br>Fields to Table</span></div>
    </td>
    <td align="right"> Message Page: </td>
     <td>
    <select name="welcome_message_page" id="welcome_message_page">
      <option>-not selected-</option>
<?php
	$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name LIKE '%message%' ORDER BY page_name";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row["page_name"];
		echo "<option value='" . $page_name . "'>" . $page_name . "</option>";
	}
?>
    </select>
    </td>
    <td>
    <div class='button_console_edit' id="assign_message_page_to_user_table_btn" onClick="AssignWelcomeMessagePageToTable();"><span class='button_console_text_w_icon'>Assign Welcome Message<br>Page to User Table</span></div>
    </td>
  </tr>
  </table>
  </td></tr></table>
  <br />
  
  <table width="95%" border="1" cellspacing="0" cellpadding="5"><tr><td>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title">Access Levels</td>
  </tr>
  <tr>
    <td align="right">
    <input type="text" name="access_level_add" id="access_level_add" />&nbsp;
    </td>
    <td>
    <div class='button_console_add' id="add_access_level_btn" onClick="AddRemoveAccessLevel('add');"><span class='button_console_text_w_icon'>Add</span></div>
    </td>
    <td align="right">
    <div id="AccessLevelRemoveDiv">
    <select name="access_level_remove" id="access_level_remove">
    <option>-not selected-</option>
	<option value="restricted">Restricted</option>
    <option value="user">User</option>
    <option value="power_user">Power User</option>
    <option value="admin">Admin</option>
    </select>
    </div>
    </td>
    <td>
    <div class='button_console_delete' id="remove_access_level_btn" onClick="DeleteAccessLevelConfirm();"><span class='button_console_text_w_icon'>Remove</span></div>
    </td>
  </tr>
  </table>
  </td></tr></table>
  <br />
  <hr style="width:95%;" />
  <p class="extra_small_message">Users are typically added through the form(s) created for the website.  The forms below are included to allow addition of users through the Breeze Website Builder backend by site administrators and power users.</p>
  
  <table width="95%" class="group_box_table"><tr><td>
<form name="formAddUser" id="formAddUser" method="post" action="add_user.php">
<table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="9" class="sub_title">Add User</td>
  </tr>
  <tr>
    <td align="right">User Name: </td>
    <td><input type="text" name="user_name" id="user_name_new_user"></td>
    <td align="right" width="150">Password: </td>
    <td> <input type="text" name="password" id="password_new_user"></td>
    <td>
    	 <div class='button_console_generate_password' id="generate_password_btn" onClick="GeneratePassword('new');"><span class='button_console_text_w_icon'>Generate Password</span></div>
    </td>
    <td align="right">Access Level: </td>
    <td>
    <div id="AccessLevelAddUserDiv">
    <select name="selectAccessLevel" id="selectAccessLevelNewUser">
    <option value="blogger">Blogger</option>
	<option value="restricted">Restricted</option>
    <option value="user">User</option>
    <option value="power_user" selected>Power User</option>
    <option value="admin">Admin</option>
    </select>
    </div>
    </td>
    <td align="right">Table: </td>
    <td>
    <select name="table" id="table_new_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
  </tr>
  <tr>
  	<td colspan="9" align="center">
    <table width="90%"><tr>
    <td align="right">Email:</td>
    <td><input type="text" name="email" id="email_new_user" /></td>
	<td align="right">Name <span class="small_message">(first, last)</span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_new_user" />
    	<input type="text" name="last_name" id="last_name_new_user" />
        <span class="small_message">(optional)</span>
    </td>
    </tr></table>
    </td>
  </tr>
  <tr>
    <td colspan="9" align="center">
    <div class='button_console_add' id="add_user_btn" onClick="AddUser();"><span class='button_console_text_w_icon'>Add</span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br />
 
  <table width="95%" class="group_box_table"><tr><td>
  <form name="formChangePassword" id="formChangePassword" method="post" action="change_password.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="7" class="sub_title">Change Password</td>
  </tr>
  <tr>
  	<td align="right">Table: </td>
    <td>
    <select name="table" id="table_existing_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right">User Name: </td>
    <td>
    <div id="UsersChangePassword">
    <select name="selectUserName" id="selectUserNameExistingUser">
    <option value="-not selected-">-not selected-</option>
    </select>
    </div>
    </td>
    <td align="right">New Password: </td>
    <td width="150">
    	<input type="text" name="password" id="password_existing_user">
    </td>
    <td>
        <div class='button_console_generate_password' id="generate_password_btn2" onClick="GeneratePassword('existing');"><span class='button_console_text_w_icon'>Generate Password</span></div>
	</td>
  </tr>
  <tr><td colspan="7">&nbsp;</td></tr>
  <tr>
    <td colspan="7" align="center">
    <div class='button_console_edit' id="change_password_btn" onClick="ChangePassword();"><span class='button_console_text_w_icon'>Change Password</span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  
  <br>
  <table width="95%" class="group_box_table"><tr><td>
	<form name="formModifyUser" id="formModifyUser" method="post" action="modify_user.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title">Modify User</td>
  </tr>
  <tr>
    <td align="right">Table: </td>
    <td>
    <select name="table" id="table_edit" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right">User Name: </td>
    <td>
    <div id="UsersEdit">
    <select name="selectUserName" id="selectUserNameEdit" onChange="GetUser(this.value);">
    <option value="-not selected-">-not selected-</option>
    </select>
    </div>
    </td>
    <td align="right">Access Level: </td>
    <td>
    <div id="AccessLevelEditUserDiv">
    <select name="selectAccessLevel" id="selectAccessLevelEdit">
    <option value="blogger">Blogger</option>
	<option value="restricted">Restricted</option>
    <option value="user">User</option>
    <option value="power_user" selected>Power User</option>
    <option value="admin">Admin</option>
    </select>
    </td>
  </tr>
  <tr>
    <td align="right" colspan="3">Email:</td>
    <td><input type="text" name="email" id="email_edit" /></td>
	<td align="right">Name <span class="small_message">(first, last)</span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_edit" />
        <input type="text" name="last_name" id="last_name_edit" />
    </td>
  </tr>
  <tr><td colspan="6">&nbsp;</td></tr>
  <tr>
    <td colspan="6" align="center">
    <div class='button_console_edit' id="edit_user_btn" onClick="ModifyUser();"><span class='button_console_text_w_icon'>Update</span></div>
    </td>
  </tr>
</table>
</form>
  </td></tr></table>
  <br>

  <table width="95%" class="group_box_table"><tr><td>

  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title">Delete User</td>
  </tr>
  <tr>
  	<td align="right">Table: </td>
    <td>
    <select name="table" id="table_delete_user" onChange="RetrieveUserLists(this.value);">
    <option value="-not selected-">-not selected-</option>
<?php
	for ($i = 0; $i < $table_cnt; $i++)
	{
		if ($tables[$i] == $last_user_table)
			echo "<option value='" . $tables[$i] . "' selected='selected'>" . $tables[$i] . "</option>";
		else
			echo "<option value='" . $tables[$i] . "'>" . $tables[$i] . "</option>";
	}
?>
    </select>
    </td>
    <td align="right">User Name: </td>
    <td>
    <div id="UsersDelete">
      <select name="selectUserName" id="selectUserNameDelete">
        <option value="-not selected-">-not selected-</option>
      </select>
    </div>
    </td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center">
    <div class='button_console_delete' id="delete_user_btn" onClick="DeleteUserConfirm();"><span class='button_console_text_w_icon'>Delete</span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language='javascript' type='text/javascript'>
   RetrievePages();
   RetrieveAccessLevels(0);
   if (document.getElementById("user_table_for_fields").value != "")
	last_user_table = document.getElementById("user_table_for_fields").value;
   if (last_user_table != "")
   	RetrieveUserLists(last_user_table);
   else
   	ShowHidePageBtns();
	
	HidePopupMsg();
	
<?php	if (isset($username_pass_change) && ($username_pass_change != ""))	{	?>
	function ShowNewUserLogin()
	{
		clearTimeout(tTimer);
<?php
	echo "var username_pass_change = '$username_pass_change';";
	echo "var password_pass_change = '$password_pass_change';";
?>
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = "The password for <b>" + username_pass_change + "</b> has been changed to <b>" + password_pass_change + "</b>.";
		popup_msg.ShowPopupMsg();
	}
	tTimer = setTimeout("ShowNewUserLogin();", 4000);
<?php	}	?>
<?php	if (isset($new_username) && ($new_username != "")) {	?>
	function ShowNewUserLogin()
	{
		clearTimeout(tTimer);
<?php
	echo "var new_username = '$new_username';";
	echo "var password_pass_change = '$password_pass_change';";
	echo "var new_user_access_level = '$new_user_access_level';";
?>
		popup_msg.top_offset = 100;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = "New user <b>" + new_username + "</b> has been created with password <b>" + password_pass_change + "</b> and an access level of <b>" + new_user_access_level + "</b>.";
		popup_msg.ShowPopupMsg();
	}
	tTimer = setTimeout("ShowNewUserLogin();", 4000);
<?php	}	?>
</script>
</body>
</html>
