<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010		ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Added file extension checking to ensure that only images are allowed to be uploaded.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 2/9/2012	ELL
// Added table prefix handling.  Added references to CSS folder configurations.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear and min/max prefix for width and height.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/18/2014	ELL
// Fixed bug with center site button and sticky footers button that got broke when submit_action was implemented inplace of the submit button.
// Revised: 3/5/2014	ELL
// Removed obsolete image Upload as this in now done with "AJAX" image uploader.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
//
//
	include ("check_session.php");
		
	$style_sheet = $_REQUEST['style_sheet'];
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	$css_file = $style_sheet . ".css";
	$show_class_editor = $_REQUEST['show_class_editor'];
	
	include ("build_sql_string.php");

	$submit_action = $_REQUEST['submit_action'];
	if ($submit_action == "Update")
	{
		$site_css_table = $css_table;
		if ($style_sheet == "site_mobile")
			$custom_site_css_table = "custom_site_mobile_css";
		else
			$custom_site_css_table = "custom_site_css";
	}
	elseif ($submit_action == "Preview")
	{
		$site_css_table = "site_css_preview";
		$custom_site_css_table = "custom_site_css_preview";
		
		//Start by deleting all old data in table.
		$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "site_css_preview";
		$cnt = $bwb_dbh->exec($query);
		
		//Get data from live table and move to preview table.
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $css_table. "`";
		$result = $bwb_dbh->query($query);
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$class = $row["class"];
			$sub_class_of = $row["sub_class_of"];
			$use_table_data = $row["use_table_data"];
			$font = $row["font"];
			$font2 = $row["font2"];
			$font3 = $row["font3"];
			$font_size = $row["font_size"];
			$text_color = $row["text_color"];
			$padding_top = $row["padding_top"];
			$padding_right = $row["padding_right"];
			$padding_bottom = $row["padding_bottom"];
			$padding_left = $row["padding_left"];
			$weight = $row["weight"];
			$italic = $row["italic"];
			$underline = $row["underline"];
			$overline = $row["overline"];
			$blink = $row["blink"];
			$linethrough = $row["linethrough"];
			//$font_stretch = $row["font_stretch"];
			$letter_spacing = $row["letter_spacing"];
			$letter_spacing_units = $row["letter_spacing_units"];
			$oblique = $row["oblique"];
			$small_caps = $row["small_caps"];
			$no_text_decoration = $row["no_text_decoration"];
			$shadow = $row["shadow"];
			$shadow_color = $row["shadow_color"];
			$shadow_x_offset = $row["shadow_x_offset"];
			$shadow_y_offset = $row["shadow_y_offset"];
			$shadow_blur = $row["shadow_blur"];
			$line_height = $row["line_height"];
			$line_height_units = $row["line_height_units"];
			
			$align = $row["align"];
			$vertical_align = $row["vertical_align"];
			$display = $row["display"];
			
			$bkgd_color = $row["bkgd_color"];
			$bkgd_opacity = $row["bkgd_opacity"];
			$border = $row["border"];
			$border_color = $row["border_color"];
			$border_style = $row["border_style"];
			$outline_style = $row["outline_style"];
			$border_collapse = $row["border_collapse"];
			$border_sides = $row["border_sides"];
			
			$margin_top = $row["margin_top"];
			$margin_right = $row["margin_right"];
			$margin_left = $row["margin_left"];
			$margin_bottom = $row["margin_bottom"];
			$margin_top_units = $row["margin_top_units"];
			$margin_top_auto = $row["margin_top_auto"];
			$margin_right_units = $row["margin_right_units"];
			$margin_right_auto = $row["margin_right_auto"];
			$margin_left_units = $row["margin_left_units"];
			$margin_left_auto = $row["margin_left_auto"];
			$margin_bottom_units = $row["margin_bottom_units"];
			$margin_bottom_auto = $row["margin_bottom_auto"];
			$width = $row["width"];
			$width_units = $row["width_units"];
			$width_prefix = $row["width_prefix"];
			$height = $row["height"];
			$height_units = $row["height_units"];
			$height_prefix = $row["height_prefix"];
			
			$background_image = $row["background_image"];
			$background_attachment = $row["background_attachment"];
			$background_repeat = $row["background_repeat"];
			$background_position = $row["background_position"];
			$background_position_x = $row["background_position_x"];
			$background_position_y = $row["background_position_y"];
			$background_position_units = $row["background_position_units"];
			
			$position = $row["position"];
			$position_left = $row["position_left"];
			$position_left_units = $row["position_left_units"];
			$position_top = $row["position_top"];
			$position_top_units = $row["position_top_units"];
			$position_right = $row["position_right"];
			$position_right_units = $row["position_right_units"];
			$position_bottom = $row["position_bottom"];
			$position_bottom_units = $row["position_bottom_units"];
			$z_index = $row["z_index"];
			$overflow = $row["overflow"];
			$clip_top = $row["clip_top"];
			$clip_top_units = $row["clip_top_units"];
			$clip_right = $row["clip_right"];
			$clip_right_units = $row["clip_right_units"];
			$clip_bottom = $row["clip_bottom"];
			$clip_bottom_units = $row["clip_bottom_units"];
			$clip_left = $row["clip_left"];
			$clip_left_units = $row["clip_left_units"];
			$float = $row["float"];
			$white_space = $row["white_space"];
			
			$list_style_type = $row["list_style_type"];
			$list_style_position = $row["list_style_position"];
			$list_style_image = $row["list_style_image"];
			
			$table_layout = $row["table_layout"];
			$clear = $row["clear"];
			
			$radius_top_left = $row["radius_top_left"];
			$radius_top_left_units = $row["radius_top_left_units"];
			$radius_top_right = $row["radius_top_right"];
			$radius_top_right_units = $row["radius_top_right_units"];
			$radius_bottom_right = $row["radius_bottom_right"];
			$radius_bottom_right_units = $row["radius_bottom_right_units"];
			$radius_bottom_left = $row["radius_bottom_left"];
			$radius_bottom_left_units = $row["radius_bottom_left_units"];
			
			$box_shadow_horizontal = $row["box_shadow_horizontal"];
			$box_shadow_vertical = $row["box_shadow_vertical"];
			$box_shadow_blur = $row["box_shadow_blur"];
			$box_shadow_spread = $row["box_shadow_spread"];
			$box_shadow_color = $row["box_shadow_color"];
			$box_shadow_inset = $row["box_shadow_inset"];
			
			$cursor = $row["cursor"];
			
			$background_size = $row["background_size"];
			$background_width = $row["background_width"];
			$background_width_units = $row["background_width_units"];
			$background_height = $row["background_height"];
			$background_height_units = $row["background_height_units"];

			//Insert new data into table.
		$insert_key = "class='" . $class . "', ";
		
		$query2 = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, "INSERT INTO", "", $insert_key, $use_table_data, $font, $font2, $font3, $font_size, $text_color, $padding_top, $padding_right, $padding_bottom, $padding_left, $weight, $italic,
		$underline, $overline, $blink, $linethrough, $letter_spacing, $letter_spacing_units, $oblique, $small_caps, $no_text_decoration, $shadow, $shadow_color, $shadow_x_offset,
		$shadow_y_offset, $shadow_blur, $line_height, $line_height_units, $align, $vertical_align, $bkgd_color, $bkgd_opacity, $border, $border_color,
		$border_style, $outline_style, $border_collapse, $border_sides, $margin_top, $margin_top_units, $margin_top_auto, $margin_right, $margin_right_units,
		$margin_right_auto, $margin_left, $margin_left_units, $margin_left_auto, $margin_bottom, $margin_bottom_units, $margin_bottom_auto,
		$display, $width, $width_units, $width_prefix, $height, $height_units, $height_prefix,
		$position, $position_left, $position_left_units, $position_top, $position_top_units,
		$position_right, $position_right_units, $position_bottom, $position_bottom_units, $z_index, $overflow,
		$clip_top, $clip_top_units, $clip_right, $clip_right_units, $clip_bottom, $clip_bottom_units, $clip_left, $clip_left_units,
		$background_image, $background_attachment, $background_repeat, $background_position, $background_position_x, $background_position_y,
		$background_position_units, $list_style_type, $list_style_position, $list_style_image, $float, $white_space, $table_layout, $clear, 
		$box_shadow_horizontal, $box_shadow_vertical, $box_shadow_blur, $box_shadow_spread, $box_shadow_color, $box_shadow_inset, $radius_top_left,
		$radius_top_left_units, $radius_top_right, $radius_top_right_units, $radius_bottom_right, $radius_bottom_right_units, $radius_bottom_left, $radius_bottom_left_units, $cursor, $background_size, $background_width, $background_width_units, $background_height, $background_height_units);
		 
		 	$cnt = $bwb_dbh->exec($query2);
		} // end while
	}

	$class = $_REQUEST['class'];
	$search = array("PERIOD", "POUND", "SPACE", "COMMA");
	$replace = array(".", "#", " ", ",");
	$class = str_replace($search, $replace, $class);
			
	if ($_POST["use_table_data"]) $use_table_data = $_POST["use_table_data"];
	else $use_table_data = 0;
	if ($_POST["font"]) $font = $_POST["font"];
	else $font = "-not selected-";
	if ($_POST["font2"]) $font2 = $_POST["font2"];
	else $font2 = "-not selected-";
	if ($_POST["font3"]) $font3 = $_POST["font3"];
	else $font3 = "-not selected-";
	if ($_POST["font_size"]) $font_size = $_POST["font_size"];
	else $font_size = -1;
	if ($_POST["text_color"]) $text_color = $_POST["text_color"];
	else $text_color = "-not set-";
	if (is_numeric($_POST["padding_top"])) $padding_top = $_POST["padding_top"];
	else $padding_top = -1;
	if (is_numeric($_POST["padding_right"])) $padding_right = $_POST["padding_right"];
	else $padding_right = -1;
	if (is_numeric($_POST["padding_bottom"])) $padding_bottom = $_POST["padding_bottom"];
	else $padding_bottom = -1;
	if (is_numeric($_POST["padding_left"])) $padding_left = $_POST["padding_left"];
	else $padding_left = -1;
	if ($_POST["weight"]) $weight = $_POST["weight"];
	else $weight = "-not selected-";
	if ($_POST["italic"]) $italic = $_POST["italic"];
	else $italic = 0;
	if ($_POST["underline"]) $underline = $_POST["underline"];
	else $underline = 0;
	if ($_POST["overline"]) $overline = $_POST["overline"];
	else $overline = 0;
	if ($_POST["blink"]) $blink = $_POST["blink"];
	else $blink = 0;
	if ($_POST["linethrough"]) $linethrough = $_POST["linethrough"];
	else $linethrough = 0;
//	if ($_POST["font_stretch"]) $font_stretch = $_POST["font_stretch"];
//	else $font_stretch = "-not selected-";
	if (is_numeric($_POST["letter_spacing"])) $letter_spacing = $_POST["letter_spacing"];
	else $letter_spacing = -1000000;
	if (is_numeric($_POST["letter_spacing_units"])) $letter_spacing_units = $_POST["letter_spacing_units"];
	else $letter_spacing_units = -1;
	if ($_POST["oblique"]) $oblique = $_POST["oblique"];
	else $oblique = 0;
	if ($_POST["small_caps"]) $small_caps = $_POST["small_caps"];
	else $small_caps = 0;
	if ($_POST["no_text_decoration"]) $no_text_decoration = $_POST["no_text_decoration"];
	else $no_text_decoration = 0;
	if ($_POST["shadow"]) $shadow = $_POST["shadow"];
	else $shadow = 0;
	if ($_POST["shadow_color"]) $shadow_color = $_POST["shadow_color"];
	else $shadow_color = "-not set-";
	if ($_POST["shadow_x_offset"]) $shadow_x_offset = $_POST["shadow_x_offset"];
	else $shadow_x_offset = 0;
	if ($_POST["shadow_y_offset"]) $shadow_y_offset = $_POST["shadow_y_offset"];
	else $shadow_y_offset = 0;
	if ($_POST["shadow_blur"]) $shadow_blur = $_POST["shadow_blur"];
	else $shadow_blur = 0;
	if (is_numeric($_POST["line_height"])) $line_height = $_POST["line_height"];
	else $line_height = -1;
	if (is_numeric($_POST["line_height_units"])) $line_height_units = $_POST["line_height_units"];
	else $line_height_units = -1;
	
	if ($_POST["align"]) $align = $_POST["align"];
	else $align = "-not selected-";
	if ($_POST["vertical_align"]) $vertical_align = $_POST["vertical_align"];
	else $vertical_align = "-not selected-";
	if ($_POST["bkgd_color"]) $bkgd_color = $_POST["bkgd_color"];
	else $bkgd_color = "-not set-";
	if (is_numeric($_POST["bkgd_opacity"])) $bkgd_opacity = $_POST["bkgd_opacity"];
	else $bkgd_opacity = -1;
	if (is_numeric($_POST["border"])) $border = $_POST["border"];
	else $border = -1;
	if ($_POST["border_color"]) $border_color = $_POST["border_color"];
	else $border_color = "-not set-";
	if ($_POST["border_style"]) $border_style = $_POST["border_style"];
	else $border_style = "-not selected-";
	if ($_POST["outline_style"]) $outline_style = $_POST["outline_style"];
	else $outline_style = "-not selected-";
	if ($_POST["border_collapse"]) $border_collapse = $_POST["border_collapse"];
	else $border_collapse = "-not selected-";
	if (is_numeric($_POST["border_sides"])) $border_sides = $_POST["border_sides"];
	else $border_sides = 15;
	
	if ($_POST["display"]) $display = $_POST["display"];
	else $display = "-not selected-";
	if (is_numeric($_POST["width"])) $width = $_POST["width"];
	else $width = -1;
	if ($_POST["width_units"]) $width_units = $_POST["width_units"];
	else $width_units = 0;
	if ($_POST["width_prefix"]) $width_prefix = $_POST["width_prefix"];
	else $width_prefix = "";
	if (is_numeric($_POST["height"])) $height = $_POST["height"];
	else $height = -1;
	if ($_POST["height_units"]) $height_units = $_POST["height_units"];
	else $height_units = 0;
	if ($_POST["height_prefix"]) $height_prefix = $_POST["height_prefix"];
	else $height_prefix = "";
	if ($_POST["background_image"]) $background_image = $_POST["background_image"];
	else $background_image = "-not selected-";
	if ($_POST["background_attachment"]) $background_attachment = $_POST["background_attachment"];
	else $background_attachment = "-not selected-";
	if ($_POST["background_repeat"]) $background_repeat = $_POST["background_repeat"];
	else $background_repeat = "-not selected-";
	if ($_POST["background_position"]) $background_position = $_POST["background_position"];
	else $background_position = "-not selected-";
	if ($_POST["background_position_x"]) $background_position_x = $_POST["background_position_x"];
	else $background_position_x = 0;
	if ($_POST["background_position_y"]) $background_position_y = $_POST["background_position_y"];
	else $background_position_y = 0;
	if ($_POST["background_position_units"]) $background_position_units = $_POST["background_position_units"];
	else $background_position_units = 0;
	
	if (is_numeric($_POST["margin_top"])) $margin_top = $_POST["margin_top"];
	else $margin_top = -1000000;
	if (is_numeric($_POST["margin_right"])) $margin_right = $_POST["margin_right"];
	else $margin_right = -1000000;
	if (is_numeric($_POST["margin_left"])) $margin_left = $_POST["margin_left"];
	else $margin_left = -1000000;
	if (is_numeric($_POST["margin_bottom"])) $margin_bottom = $_POST["margin_bottom"];
	else $margin_bottom = -1000000;
	if ($_POST["margin_top_units"]) $margin_top_units = $_POST["margin_top_units"];
	else $margin_top_units = 0;
	if ($_POST["margin_top_auto"]) $margin_top_auto = $_POST["margin_top_auto"];
	else $margin_top_auto = 0;
	if ($_POST["margin_right_units"]) $margin_right_units = $_POST["margin_right_units"];
	else $margin_right_units = 0;
	if ($_POST["margin_right_auto"]) $margin_right_auto = $_POST["margin_right_auto"];
	else $margin_right_auto = 0;
	if ($_POST["margin_left_units"]) $margin_left_units = $_POST["margin_left_units"];
	else $margin_left_units = 0;
	if ($_POST["margin_left_auto"]) $margin_left_auto = $_POST["margin_left_auto"];
	else $margin_left_auto = 0;
	if ($_POST["margin_bottom_units"]) $margin_bottom_units = $_POST["margin_bottom_units"];
	else $margin_bottom_units = 0;
	if ($_POST["margin_bottom_auto"]) $margin_bottom_auto = $_POST["margin_bottom_auto"];
	else $margin_bottom_auto = 0;
	
	if ($_POST["position"]) $position = $_POST["position"];
	else $position = "-not selected-";
	if (is_numeric($_POST["position_left"])) $position_left = $_POST["position_left"];
	else $position_left = -1000000;
	if ($_POST["position_left_units"]) $position_left_units = $_POST["position_left_units"];
	else $position_left_units = 0;
	if (is_numeric($_POST["position_top"])) $position_top = $_POST["position_top"];
	else $position_top = -1000000;
	if ($_POST["position_top_units"]) $position_top_units = $_POST["position_top_units"];
	else $position_top_units = 0;
	if (is_numeric($_POST["position_right"])) $position_right = $_POST["position_right"];
	else $position_right = -1000000;
	if ($_POST["position_right_units"]) $position_right_units = $_POST["position_right_units"];
	else $position_right_units = 0;
	if (is_numeric($_POST["position_bottom"])) $position_bottom = $_POST["position_bottom"];
	else $position_bottom = -1000000;
	if ($_POST["position_bottom_units"]) $position_bottom_units = $_POST["position_bottom_units"];
	else $position_bottom_units = 0;
	if (is_numeric($_POST["z_index"])) $z_index = $_POST["z_index"];
	else $z_index = -1000000;
	if ($_POST["overflow"]) $overflow = $_POST["overflow"];
	else $overflow = "-not selected-";
	if (is_numeric($_POST["clip_top"])) $clip_top = $_POST["clip_top"];
	else $clip_top = -1;
	if (is_numeric($_POST["clip_top_units"])) $clip_top_units = $_POST["clip_top_units"];
	else $clip_top_units = -1;
	if (is_numeric($_POST["clip_right"])) $clip_right = $_POST["clip_right"];
	else $clip_right = -1;
	if (is_numeric($_POST["clip_right_units"])) $clip_right_units = $_POST["clip_right_units"];
	else $clip_right_units = -1;
	if (is_numeric($_POST["clip_bottom"])) $clip_bottom = $_POST["clip_bottom"];
	else $clip_bottom = -1;
	if (is_numeric($_POST["clip_bottom_units"])) $clip_bottom_units = $_POST["clip_bottom_units"];
	else $clip_bottom_units = -1;
	if (is_numeric($_POST["clip_left"])) $clip_left = $_POST["clip_left"];
	else $clip_left = -1;
	if (is_numeric($_POST["clip_left_units"])) $clip_left_units = $_POST["clip_left_units"];
	else $clip_left_units = -1;
	if ($_POST["float"]) $float = $_POST["float"];
	else $float = "-not selected-";
	if ($_POST["white_space"]) $white_space = $_POST["white_space"];
	else $white_space = "-not selected-";
	
	if ($_POST["list_style_type"]) $list_style_type = $_POST["list_style_type"];
	else $list_style_type = "-not selected-";
	if ($_POST["list_style_position"]) $list_style_position = $_POST["list_style_position"];
	else $list_style_position = "-not selected-";
	if ($_POST["list_style_image"]) $list_style_image = $_POST["list_style_image"];
	else $list_style_image = "-not selected-";
	
	if ($_POST["table_layout"]) $table_layout = $_POST["table_layout"];
	else $table_layout = "-not selected-";
	if ($_POST["clear"]) $clear = $_POST["clear"];
	else $clear = "-not selected-";

	if ($_POST["radius_top_left"]) $radius_top_left = $_POST["radius_top_left"];
	else $radius_top_left = 0;
	if ($_POST["radius_top_left_units"]) $radius_top_left_units = $_POST["radius_top_left_units"];
	else $radius_top_left_units = 0;
	if ($_POST["radius_top_right"]) $radius_top_right = $_POST["radius_top_right"];
	else $radius_top_right = 0;
	if ($_POST["radius_top_right_units"]) $radius_top_right_units = $_POST["radius_top_right_units"];
	else $radius_top_right_units = 0;
	if ($_POST["radius_bottom_right"]) $radius_bottom_right = $_POST["radius_bottom_right"];
	else $radius_bottom_right = 0;
	if ($_POST["radius_bottom_right_units"]) $radius_bottom_right_units = $_POST["radius_bottom_right_units"];
	else $radius_bottom_right_units = 0;
	if ($_POST["radius_bottom_left"]) $radius_bottom_left = $_POST["radius_bottom_left"];
	else $radius_bottom_left = 0;
	if ($_POST["radius_bottom_left_units"]) $radius_bottom_left_units = $_POST["radius_bottom_left_units"];
	else $radius_bottom_left_units = 0;
	
	if ($_POST["box_shadow_horizontal"]) $box_shadow_horizontal = $_POST["box_shadow_horizontal"];
	else $box_shadow_horizontal = -1000000;
	if ($_POST["box_shadow_vertical"]) $box_shadow_vertical = $_POST["box_shadow_vertical"];
	else $box_shadow_vertical = -1000000;
	if ($_POST["box_shadow_blur"]) $box_shadow_blur = $_POST["box_shadow_blur"];
	else $box_shadow_blur = -1;
	if ($_POST["box_shadow_spread"]) $box_shadow_spread = $_POST["box_shadow_spread"];
	else $box_shadow_spread = -1000000;
	if ($_POST["box_shadow_color"]) $box_shadow_color = $_POST["box_shadow_color"];
	else $box_shadow_color = "-not set-";
	if ($_POST["box_shadow_inset"]) $box_shadow_inset = $_POST["box_shadow_inset"];
	else $box_shadow_inset = 0;
	
	if ($_POST["cursor"]) $cursor = $_POST["cursor"];
	else $cursor = "-not selected-";
	
	if ($_POST["background_size"]) $background_size = $_POST["background_size"];
	else $background_size = "-not selected-";
	if ($_POST["background_width"]) $background_width = $_POST["background_width"];
	else $background_width = -1;
	if ($_POST["background_width_units"]) $background_width_units = $_POST["background_width_units"];
	else $background_width_units = 0;
	if ($_POST["background_height"]) $background_height = $_POST["background_height"];
	else $background_height = -1;
	if ($_POST["background_height_units"]) $background_height_units = $_POST["background_height_units"];
	else $background_height_units = 0;
	
	$query = "SELECT `use_table_data` FROM " . BWB_TABLE_PREFIX . $site_css_table . " WHERE `class` = '" . $class . "'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	
	if (($_POST['quick_setup'] == 1) && ($row_count > 0))
	{
		$fields = array("align", "vertical_align", "bkgd_color", "position", "position_bottom", "position_bottom_units", "position_top", "position_top_units", "position_right", "position_right_units", "position_left", "position_left_units", "width", "width_units", "width_prefix", "height", "height_units", "height_prefix", "margin_left","margin_left_units", "margin_left_auto", "margin_right", "margin_right_units", "margin_right_auto", "margin_top", "margin_top_units", "margin_top_auto", "margin_bottom", "margin_bottom_units", "margin_bottom_auto", "overflow", "display", "clear", "background_size", "background_width", "background_width_units", "background_height", "background_height_units", "border", "border_sides", "padding_top", "padding_right", "padding_bottom", "padding_left");
		
		$query = "UPDATE `" . BWB_TABLE_PREFIX . $site_css_table . "` SET `use_table_data`=1, ";
		$delim = "";
		foreach ($_POST as $key => $val)
		{
			if (in_array($key, $fields))
			{
				$query .= $delim . "`" . $key . "`='" . $val . "'";
				$delim = ", ";
			}
		}
		$query .= " WHERE `class` = '" . $class . "'";
	}
	elseif ($row_count > 0)
	{
		//Update class record.
		$condition = "`class` = '" . $class . "'";
		
		$query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, "UPDATE", $condition, "", $use_table_data, $font, $font2, $font3, $font_size, $text_color, $padding_top, $padding_right, $padding_bottom, $padding_left, $weight, $italic,
		$underline, $overline, $blink, $linethrough, $letter_spacing, $letter_spacing_units, $oblique, $small_caps, $no_text_decoration, $shadow, $shadow_color, $shadow_x_offset,
		$shadow_y_offset, $shadow_blur, $line_height, $line_height_units, $align, $vertical_align, $bkgd_color, $bkgd_opacity, $border, $border_color,
		$border_style, $outline_style, $border_collapse, $border_sides, $margin_top, $margin_top_units, $margin_top_auto, $margin_right, $margin_right_units,
		$margin_right_auto, $margin_left, $margin_left_units, $margin_left_auto, $margin_bottom, $margin_bottom_units, $margin_bottom_auto,
		$display, $width, $width_units, $width_prefix, $height, $height_units, $height_prefix,
		$position, $position_left, $position_left_units, $position_top, $position_top_units,
		$position_right, $position_right_units, $position_bottom, $position_bottom_units, $z_index, $overflow,
		$clip_top, $clip_top_units, $clip_right, $clip_right_units, $clip_bottom, $clip_bottom_units, $clip_left, $clip_left_units,
		$background_image, $background_attachment, $background_repeat, $background_position, $background_position_x, $background_position_y,
		$background_position_units, $list_style_type, $list_style_position, $list_style_image, $float, $white_space, $table_layout, $clear,
		$box_shadow_horizontal, $box_shadow_vertical, $box_shadow_blur, $box_shadow_spread, $box_shadow_color, $box_shadow_inset, $radius_top_left,
		$radius_top_left_units, $radius_top_right, $radius_top_right_units, $radius_bottom_right, $radius_bottom_right_units, $radius_bottom_left, $radius_bottom_left_units, $cursor, $background_size, $background_width, $background_width_units, $background_height, $background_height_units);
	}
	else
	{
		//Insert new data into table.
		$insert_key = "class='" . $class . "', ";
		
		 $query = BuildSQLString(BWB_TABLE_PREFIX . $site_css_table, "INSERT INTO", "", $insert_key, $use_table_data, $font, $font2, $font3, $font_size, $text_color, $padding_top, $padding_right, $padding_bottom, $padding_left, $weight, $italic,
		$underline, $overline, $blink, $linethrough, $letter_spacing, $letter_spacing_units, $oblique, $small_caps, $no_text_decoration, $shadow, $shadow_color, $shadow_x_offset,
		$shadow_y_offset, $shadow_blur, $line_height, $line_height_units, $align, $vertical_align, $bkgd_color, $bkgd_opacity, $border, $border_color,
		$border_style, $outline_style, $border_collapse, $border_sides, $margin_top, $margin_top_units, $margin_top_auto, $margin_right, $margin_right_units,
		$margin_right_auto, $margin_left, $margin_left_units, $margin_left_auto, $margin_bottom, $margin_bottom_units, $margin_bottom_auto,
		$display, $width, $width_units, $width_prefix, $height, $height_units, $height_prefix, 
		$position, $position_left, $position_left_units, $position_top, $position_top_units,
		$position_right, $position_right_units, $position_bottom, $position_bottom_units, $z_index, $overflow,
		$clip_top, $clip_top_units, $clip_right, $clip_right_units, $clip_bottom, $clip_bottom_units, $clip_left, $clip_left_units,
		$background_image, $background_attachment, $background_repeat, $background_position, $background_position_x, $background_position_y,
		$background_position_units, $list_style_type, $list_style_position, $list_style_image, $float, $white_space, $table_layout, $clear,
		$box_shadow_horizontal, $box_shadow_vertical, $box_shadow_blur, $box_shadow_spread, $box_shadow_color, $box_shadow_inset, $radius_top_left,
		$radius_top_left_units, $radius_top_right, $radius_top_right_units, $radius_bottom_right, $radius_bottom_right_units, $radius_bottom_left, $radius_bottom_left_units, $cursor, $background_size, $background_width, $background_width_units, $background_height, $background_height_units);
	}
//	echo $query;
	$cnt = $bwb_dbh->exec($query);


	/////////////////////////////////////////////
	// Build string for site.css file /////
	
	include("build_css_string.php");
			

	////////////////////////////////////////////////////////
	/// Write menu items to menu.css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if ($submit_action == "Update")
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	else
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////////////////
	// Add custom styles to CKEditor style list. ///////////
	if ($submit_action == "Update")	// Do only if really committing to saving styles.
	{
		// Build string for fckstyles.xml file /////
		include("build_jason_style_string.php");
		
		// Rename styles.js file for backup
		$file_name = $document_root . "/ckeditor/styles.js";
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo "Could not rename $file_name to $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
		$result = (fputs($fh, $jason_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}
	
	//////////////////////////////////////////////////////////
	// Goto Preview. /////////////////////
	if ($submit_action == "Preview")
		header("Location: preview_css.php?style_sheet=$style_sheet&goto_class=$class");	
		
?>
