<?php
////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
//
// Re-write menu_items.js with new references.
// Build string for menu_items.js file /////
// Revised: 1/9/2011	ELL
// Added ability to work with multiple JavaScript menus.
// Revised: 2/10/2012	ELL
// Added table prefix handling.  Added references to script folder configuration.
//
	include_once("check_session.php");
	
	$menu_items_string = "var MENU" . $suffix . "_ITEMS = [\n";
	$previous_level = 0;
	$indent = '   ';
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_items ORDER BY sort_order";
	$result = $bwb_dbh->query($query);
	while ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$item_text = $row["item_text"];
		$level = $row["level"];
		$URL = $row["URL"];
		$target = $row["target"];
		
		$item_text = stripslashes($item_text);
		$URL = stripslashes($URL);
		$target = stripslashes($target);
			
		if ($previous_level == $level)
		{
			if ($URL || ($URL != ''))
				$menu_items_string .= $indent . "['$item_text', '$URL', {'tw' : '$target'}],\n";
			else
				$menu_items_string .= $indent . "['$item_text', null , null],\n";
		}
		elseif ($previous_level < $level)	//Nesting
		{
			$menu_items_string = substr_replace($menu_items_string, '', -3, 1);
			$indent .= "   ";
			if ($URL || ($URL != ''))
				$menu_items_string .= $indent . "['$item_text', '$URL', {'tw' : '$target'}],\n";
			else
				$menu_items_string .= $indent . "['$item_text', null , null],\n";
		}
		elseif ($previous_level > $level)	//Un-nesting
		{
			$menu_items_string = substr_replace($menu_items_string, '', -2, 1);
			$unnest = $previous_level - $level;
			for ($i = 0; $i < $unnest; $i++)
			{
				$indent = substr_replace($indent, '', -3, 3);
				$menu_items_string .= $indent . "],\n";
			}
			if ($URL || ($URL != ''))
				$menu_items_string .= $indent . "['$item_text', '$URL', {'tw' : '$target'}],\n";
			else
				$menu_items_string .= $indent . "['$item_text', null , null],\n";
		}
		
		$previous_level = $level;
	}	// While menu items found
	
	if ($level > 0)	//Un-nest end if necessary
	{
		$menu_items_string = substr_replace($menu_items_string, '', -2, 1);
		for ($i = 0; $i < $level; $i++)
		{
			$indent = substr_replace($indent, '', -3, 3);
			$menu_items_string .= $indent . "],\n";
		}
	}
			
	$menu_items_string = substr_replace($menu_items_string, '', -2, 1);
	$menu_items_string .= "];\n";
	
	////////////////////////////////////////////////////////
	/// Write menu items to menu_items.js file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;		
	$file_name = $document_root . $userfiles . "/" . BWB_SCRIPTS_DIR . "/menu" . $suffix . "_items.js";

	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0755);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $menu_items_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0755);
?>