<?php
/////////////////////////////////////////////
// Users Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 4/9/2010	ELL
// Added more access levels.  Levels are now admin, power_user, user and restricted.
// Revised: 12/9/2010	ELL
// Added password generator.
// Revised: 2/10/2012	ELL
// Added table prefix handling.
// Revised: 11/16/2012	ELL
// Added checking for SSL and prompting if not SSL.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 10/28/2014	ELL
// Added modify user to change access level and revise added fields email, first_name and last_name.
// Complete overhaul to switch from form posts to AJAX.
// 
//
	include ("check_session.php");
?>
<html>
<head>
<title>Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#generate_password_btn	{	width:170px;	}
#add_user_btn	{	width:110px;	}
#generate_password_btn2	{	width:170px;}
#change_password_btn	{	width:180px;	}
#delete_user_btn	{	width:110px;	}
#edit_user_btn		{	width:110px;	}
</style>

<script type="text/javascript" src="js/mouse_position.js"></script>
<script type="text/javascript" src="js/popup_msg.js"></script>
<script type="text/javascript" src="js/json2.js"></script>
<script type="text/javascript" src="js/jquery-1.11.1.min.js"></script>
<script type="text/javascript" src="js/users.js"></script>

</head>

<body onLoad="GetUsers();" id="workspace_body">
<br>
<div align="center">
<table width="80%"><tr><td>
<div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1">Manage Users</div><div class="button_heading_help" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td></tr></table>
<?php
	if ($_SERVER["HTTPS"] != "on")
	{
		 $pageURL .= "https://";
		 if ($_SERVER["SERVER_PORT"] != "80")
		  	$pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
		 else
		 	$pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
			
		 echo "<p class='warning_text' align='justify' style='width:80%;'><b>WARNING:</b> You are viewing this console with an unencrypted connection.  If you are adding users or changing passwords it is recommended that you use an encrypted connection.  To switch to an encrypted connection, click <b><a href='$pageURL'>here</a></b>.  <br /><span class='extra_small_message'>Note: The SSL certificate may not be valid.  If this is the case, just accept the certificate anyway and continue to the encrypted connection.  Also, some servers do not have SSL certificates installed, so it might not be possible to view this console encrypted.  If clicking on the link does not work just click the back button.</span></p>\n";
	}
?>
<table width="80%" class="group_box_table"><tr><td>
<form name="formAddUser" id="formAddUser" method="post" action="add_user.php">
<table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="7" class="sub_title">Add User</td>
  </tr>
  <tr>
    <td align="right">User Name: </td>
    <td><input type="text" name="user_name" id="user_name_new_user"></td>
    <td align="right" width="150">Password: </td>
    <td> <input type="text" name="password" id="password_new_user"></td>
    <td>
    	 <div class='button_console_generate_password' id="generate_password_btn" onClick="GeneratePassword('new');"><span class='button_console_text_w_icon'>Generate Password</span></div>
    </td>
    <td align="right">Access Level: </td>
    <td><select name="selectAccessLevel" id="selectAccessLevelNewUser">
    <option value="blogger">Blogger</option>
	<option value="restricted">Restricted</option>
    <option value="user">User</option>
    <option value="power_user" selected>Power User</option>
    <option value="admin">Admin</option>
    </select></td>
  </tr>
  <tr>
  	<td colspan="7" align="center">
    <table width="90%"><tr>
    <td align="right">Email:</td>
    <td><input type="text" name="email" id="email_new_user" /></td>
	<td align="right">Name <span class="small_message">(first, last)</span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_new_user" />
    	<input type="text" name="last_name" id="last_name_new_user" />
        <span class="small_message">(optional)</span>
    </td>
    </tr></table>
    </td>
  </tr>
  <tr>
    <td colspan="7" align="center">
    <div class='button_console_add' id="add_user_btn" onClick="AddUser();"><span class='button_console_text_w_icon'>Add</span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br>
  <table width="80%" class="group_box_table"><tr><td>
  <form name="formChangePassword" id="formChangePassword" method="post" action="change_password.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="5" class="sub_title">Change Password</td>
  </tr>
  <tr>
    <td align="right">User Name: </td>
    <td>
    <select name="selectUserName" id="selectUserNameExistingUser">
    <option value="-not selected-">-not selected-</option>
    </select>
    </td>
    <td align="right">New Password: </td>
    <td width="150">
    	<input type="text" name="password" id="password_existing_user">
    </td>
    <td>
        <div class='button_console_generate_password' id="generate_password_btn2" onClick="GeneratePassword('existing');"><span class='button_console_text_w_icon'>Generate Password</span></div>
	</td>
  </tr>
  <tr><td colspan="5">&nbsp;</td></tr>
  <tr>
    <td colspan="5" align="center">
    <div class='button_console_edit' id="change_password_btn" onClick="ChangePassword();"><span class='button_console_text_w_icon'>Change Password</span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br>
  <table width="80%" class="group_box_table"><tr><td>
	<form name="formModifyUser" id="formModifyUser" method="post" action="modify_user.php">
  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title">Modify User</td>
  </tr>
  <tr>
    <td align="right">User Name: </td>
    <td>
    <select name="selectUserName" id="selectUserNameEdit" onChange="GetUser(this.value);">
    <option value="-not selected-">-not selected-</option>
    </select>
    </td>
    <td align="right">Access Level: </td>
    <td><select name="selectAccessLevel" id="selectAccessLevelEdit">
    <option value="blogger">Blogger</option>
	<option value="restricted">Restricted</option>
    <option value="user">User</option>
    <option value="power_user" selected>Power User</option>
    <option value="admin">Admin</option>
    </select></td>
  </tr>
  <tr>
    <td align="right">Email:</td>
    <td><input type="text" name="email" id="email_edit" /></td>
	<td align="right">Name <span class="small_message">(first, last)</span>:</td>
    <td>
    	<input type="text" name="first_name" id="first_name_edit" />
        <input type="text" name="last_name" id="last_name_edit" />
    </td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center">
    <div class='button_console_edit' id="edit_user_btn" onClick="ModifyUser();"><span class='button_console_text_w_icon'>Update</span></div>
    </td>
  </tr>
</table>
</form>
  </td></tr></table>
  
  <br>
  <table width="80%" class="group_box_table"><tr><td>

  <table width="100%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="2" class="sub_title">Delete User</td>
  </tr>
  <tr>
    <td align="right">User Name: </td>
    <td>
    <select name="selectUserName" id="selectUserNameDelete">
    <option value="-not selected-">-not selected-</option>
    </select>
    </td>
  </tr>
  <tr><td colspan="2">&nbsp;</td></tr>
  <tr>
    <td colspan="2" align="center">
    <div class='button_console_delete' id="delete_user_btn" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'>Delete</span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>
</body>
</html>
