INSERT INTO zen_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('Show Split Tax Lines', 'SHOW_SPLIT_TAX_CHECKOUT', 'false', 'If multiple tax rates apply, show each rate as a separate line at checkout', '1', '22', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());

TRUNCATE TABLE zen_whos_online;
TRUNCATE TABLE zen_db_cache;
TRUNCATE TABLE zen_sessions;

DELETE FROM zen_paypal_session WHERE expiry < unix_timestamp();

UPDATE zen_banners set banners_url = 'http://www.zen-cart.com/partners/payment' where banners_url = 'http://www.zen-cart.com/index.php?main_page=infopages&pages_id=30';
DELETE from zen_banners where banners_url like'%sashbox%';

DELETE FROM zen_countries where countries_iso_code_2 = 'FX' or countries_iso_code_3 = 'FXX';
DELETE FROM zen_countries where countries_iso_code_2 = 'ZR' or countries_iso_code_3 = 'ZAR';
UPDATE zen_countries SET countries_name = 'Serbia', countries_iso_code_2 = 'RS', countries_iso_code_3 = 'SRB' where countries_iso_code_3 = 'YUG';
UPDATE zen_countries SET countries_name = 'Timor-Leste', countries_iso_code_2 = 'TL', countries_iso_code_3 = 'TLS' where countries_iso_code_3 = 'TMP';
UPDATE zen_countries SET countries_name = 'Moldova' where countries_iso_code_3 = 'MDA';
UPDATE zen_countries SET countries_name = 'Macao' where countries_iso_code_3 = 'MAC';
UPDATE zen_countries SET countries_iso_code_3 = 'ROU' where countries_iso_code_3 = 'ROM';

update zen_orders set cc_cvv = '' where cc_cvv != '' and orders_status != 1;

UPDATE zen_configuration SET configuration_value = 'production' where configuration_key = 'MODULE_SHIPPING_USPS_SERVER';

ALTER TABLE zen_authorizenet CHANGE transaction_id transaction_id bigint(20) default NULL;
ALTER TABLE zen_paypal CHANGE COLUMN notify_version notify_version varchar(6) NOT NULL default '';

ALTER TABLE zen_orders_products ADD INDEX idx_prod_id_orders_id_zen (products_id,orders_id);
ALTER TABLE zen_orders ADD INDEX idx_cust_id_orders_id_zen (customers_id,orders_id);

CREATE TABLE zen_counter_history_clean as 
SELECT * FROM zen_counter_history WHERE 1 GROUP BY startdate;
DROP TABLE zen_counter_history;
RENAME TABLE zen_counter_history_clean 
TO zen_counter_history;

ALTER TABLE zen_counter_history ADD PRIMARY KEY(startdate);

delete from zen_media_to_products where media_id not in (
SELECT media_id
FROM zen_media_manager);
delete from zen_media_clips where media_id not in (
SELECT media_id
FROM zen_media_manager);

DELETE from zen_record_company_info where record_company_id in (
SELECT record_company_id 
FROM zen_record_company where record_company_image like '%.php');
DELETE FROM zen_record_company where record_company_image like '%.php';


INSERT INTO zen_project_version_history (project_version_key, project_version_major, project_version_minor, project_version_patch, project_version_date_applied, project_version_comment)
SELECT project_version_key, project_version_major, project_version_minor, project_version_patch1 as project_version_patch, project_version_date_applied, project_version_comment
FROM zen_project_version;

UPDATE zen_project_version SET project_version_major='1', project_version_minor='3.9h', project_version_patch1='', project_version_patch1_source='', project_version_patch2='', project_version_patch2_source='', project_version_comment='Version Update 1.3.8->1.3.9h', project_version_date_applied=now() WHERE project_version_key = 'Zen-Cart Main';
UPDATE zen_project_version SET project_version_major='1', project_version_minor='3.9h', project_version_patch1='', project_version_patch1_source='', project_version_patch2='', project_version_patch2_source='', project_version_comment='Version Update 1.3.8->1.3.9h', project_version_date_applied=now() WHERE project_version_key = 'Zen-Cart Database';


ALTER TABLE `zen_products` 
	ADD COLUMN `products_ready_to_ship` tinyint(2) unsigned   NOT NULL,
	ADD COLUMN `products_length` varchar(10) DEFAULT NULL,
    ADD COLUMN `products_width` varchar(10) DEFAULT NULL,
    ADD COLUMN `products_height` varchar(10) DEFAULT NULL,
	ADD COLUMN `products_packaging` CHAR( 50 ) NOT NULL;

DROP TABLE IF EXISTS `zen_packaging`;
CREATE TABLE IF NOT EXISTS `zen_packaging` (
  `package_id` int(11) NOT NULL auto_increment,
  `package_name` varchar(64) NOT NULL default '',
  `package_description` varchar(255) NOT NULL default '',
  `package_length` decimal(6,2) NOT NULL default '5.00',
  `package_width` decimal(6,2) NOT NULL default '5.00',
  `package_height` decimal(6,2) NOT NULL default '5.00',
  `package_empty_weight` decimal(6,2) NOT NULL default '0.00',
  `package_max_weight` decimal(6,2) NOT NULL default '50.00',
  `package_cost` int(5) NOT NULL default '0',
  PRIMARY KEY  (`package_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=0;

INSERT INTO zen_packaging (package_name, package_description, package_length, package_width, package_height, package_empty_weight, package_max_weight, package_cost) VALUES ('Standard Case','Case box 18 x 18 x 12','18','18','12','.2','25','1.00');


ALTER TABLE zen_products CHANGE products_weight products_weight DOUBLE NOT NULL DEFAULT '0';
UPDATE zen_products SET products_weight=ROUND(`products_weight`,5);
ALTER TABLE zen_products_attributes CHANGE products_attributes_weight products_attributes_weight DOUBLE NOT NULL DEFAULT '0';
UPDATE zen_products_attributes SET products_attributes_weight=ROUND(`products_attributes_weight`,5);
