<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 8/1/2009	ELL
// Added ability to operate using different class tables.  This was done to give the ability
// to style calendar grids and event grids without adding 14 more classes to the site style list.
// Renamed from delete_tag.php to delete_class.php.
// Added feed thru to show/hide custom styles.
// Revised: 9/15/2009	ELL
// Added removal of class from CSS table as well.  Otherwise, style sheet will continue to contain this style even
// though you cannot edit it.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
//
	include ("check_session.php");

	$class = $_REQUEST['class'];
	$search = array("PERIOD", "POUND", "SPACE", "COMMA");
	$replace = array(".", "#", " ", ",");
	$class = str_replace($search, $replace, $class);
	$style_sheet = $_REQUEST['style_sheet'];
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	
	// Go ahead and delete tag from class table.
	$query = "DELETE FROM `" . BWB_TABLE_PREFIX . $class_table . "` WHERE `class` = '$class'";
	$cnt = $bwb_dbh->exec($query);
	
	// Also remove tag from tag from css table.
	$query = "DELETE FROM `" . BWB_TABLE_PREFIX . $css_table . "` WHERE `class` = '$class'";
	$cnt = $bwb_dbh->exec($query);
	
	// Build new CSS string without deleted class.
	$site_css_table = $css_table;
	if ($style_sheet == "site_mobile")
		$custom_site_css_table = "custom_site_mobile_css";
	else
		$custom_site_css_table = "custom_site_css";
	include("build_css_string.php");
	
	////////////////////////////////////////////////////////
	/// Write new css file /////////////
	//Test to see if file already exists.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if ($submit_action == "Update")
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
	else
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo "Could not rename $file_name to $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	/////////////////////////////////////////////////////////
	// Add custom styles to CKEditor style list. ///////////
	if ($submit_action == "Update")	// Do only if really committing to saving styles.
	{
		// Build string for fckstyles.xml file /////
		include("build_jason_style_string.php");
		
		// Rename styles.js file for backup
		$file_name = $document_root . "/ckeditor/styles.js";
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo "Could not rename $file_name to $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die("Can't create $file_name: $php_errormsg");
		$result = (fputs($fh, $jason_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}
	
	header("Location: classes.php?style_sheet=$style_sheet&show_class_editor=1");
	
?>
