<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 8/3/2009	ELL
// Added ability to operate using different class tables and different CSS tables.  This was done to give the ability
// to style calendar grids and event grids without adding 14 more classes to the site style list.
// Added switch to turn off custom styles.
// Added feed thru for show/hide class editor.
// Revised: 8/24/2009	ELL
// Added copability for working with new AJAX CSS editor with working with one class block at a time.
// Fixed various pre-exing bugs with propper display of custom styles.
// Removed switch to turn off custom styles as this is now in main menu.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
//
	include ("check_session.php");
	
	$style_sheet = $_REQUEST['style_sheet'];
	$class_table = $style_sheet . "_classes";
	$show_class_editor = $_REQUEST['show_class_editor'];
	$goto_class = $_REQUEST['goto_class'];
	$custom = $_REQUEST['custom'];
	
	if (BWB_BASE_DIR == '')
		$userfiles = '..';
	else
		$userfiles = "../" . BWB_BASE_DIR;
		
	$preview_css_file = $userfiles . "/" . BWB_CSS_DIR . "/site_preview.css";
	
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>EB Content Manager</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="<?php echo $preview_css_file; ?>" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
<?php
	if ($custom == 1)
	{
		$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "custom_site_css_preview`";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		if ($row["custom_css"])
		{
			echo "\n<style type='text/css' >\n";
			echo $row["custom_css"];
			echo "\n</style>\n";
		}
	}
?>
</head>

<body>
<br>Body Text<br>
<p>Paragraph</p>
<h1>Header 1</h1>
<h2>Header 2</h2>
<h3>Header 3</h3>
<br><a href="">Body Text Link</a><br>
<p><a href="">Paragraph Link</a></p>
<h1><a href="">Header 1 Link</a></h1>
<h2><a href="">Header 2 Link</a></h2>
<h3><a href="">Header 3 Link</a></h3>
<br>
<table width="80%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
	Table
    <p>Paragraph in Table</p>
	<h1>Header 1 in Table</h1>
	<h2>Header 2 in Table</h2>
	<h3>Header 3 in Table</h3>
	<a href="">Table Link</a>
    <p><a href="">Paragraph in Table Link</a></p>
	<h1><a href="">Header 1 in Table Link</a></h1>
	<h2><a href="">Header 2 in Table Link</a></h2>
	<h3><a href="">Header 3 in Table Link</a></h3>
	</td>
	<td>
	<ul>Un-ordered List in Table
	<li>Un-ordered List Item 1</li>
	<li>Un-ordered List Item 2</li>
	</ul>
	<br><br>
	<ul>Ordered List in Table
	<li>Ordered List Item 1</li>
	<li>Ordered List Item 2</li>
	</ul>
	</td>
  </tr>
</table>
<br><br>
<ul>Un-ordered List
<li>Un-ordered List Item 1</li>
<li>Un-ordered List Item 2</li>
</ul>
<br><br>
<ul>Ordered List
<li>Ordered List Item 1</li>
<li>Ordered List Item 2</li>
</ul>
<br><br>

<?php		
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` WHERE `custom` = 1 ORDER BY `sort_order`";
	if ($result = $bwb_dbh->query($query))
	{
		$num_results = $result->rowCount();
		for ($i = 0; $i < $num_results; $i++)
		{
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$class = $row["class"];
			$class_name = str_replace(".", "", $class);
			$class_name = str_replace("#", "", $class_name);
			$description = $row["description"];
			echo "<div class=\"$class_name\">$class $description style</div>\n";
		}
	}
?>
<br><br>
<table width="80">
  <tr>
  	<td align="center">
	  <form>
	  <input type="button" name="Back" value="Exit Without Saving Changes" onClick="window.location.href='<?php if ($custom == 1) { ?>edit_custom_css.php?style_sheet=<?php echo $style_sheet; } else { ?>edit_css.php?style_sheet=<?php echo $style_sheet; ?>&goto_class=<?php echo $goto_class; } ?>';">
	  </form>
	</td>
	<td align="center">
	  <form action="save_css_from_preview.php" method="post" name="frmSaveAndEditCSS" id="frmSaveAndEditCSS">
	    <input type="submit" value="Save Changes" name="submit">
        <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
        <input type="hidden" name="show_class_editor" value="<?php echo $show_class_editor; ?>" />
        <input type="hidden" name="goto_class" value="<?php echo $goto_class; ?>" />
        <input type="hidden" name="custom" value="<?php echo $custom; ?>" />
	  </form>
	</td>
  </tr>
</table>
</body>
</html>
