<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	3/9/2013	ELL
// Revised: 5/14/2013	ELL
// Added prepend and postpend for header and footer.
// Revised: 5/23/2013	ELL
// Changed header and footer prepend and postpend to HTML 5 tags.
// Revised: 9/24/2013	ELL
// Added ability to specify blog header area within a page such that blog page may have header content before the blogs.
// Added content sensitive help for relevant plugins.
// Revised: 9/21/2014	ELL
// Upgraded CKEditor for 4.0.2 to 4.4.4.
// Revised: 11/6/2014	ELL
// Added save to backup everytime save or publish is clicked.

	include ("check_session.php");
		
	$action = $_POST['action'];
	$sValue = stripslashes( $_POST['sValue'] ) ;
	//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//	$fh = fopen ('debug.html' , 'w');
//	fwrite($fh, $sValue);
	//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
	
	$page_name = $_REQUEST['page_name'];
	$blog_id = $_REQUEST['blog_id'];
	$special = $_REQUEST['special'];	//Flag to tell if editing special page (header, footer, side panel...).
	$mode = $_REQUEST['mode'];
	$disable_site_styles = $_REQUEST['disable_site_styles'];
	
	if ($mode == "blog")
	{
		$_SESSION['last_blog_edited'] = $blog_id;
		$_SESSION['last_page_edited'] = $page_name;
		$special = 0;
	}
	elseif (!isset($special))
	{
		$_SESSION['last_page_edited'] = $page_name;
		$special = 0;
	}
	else
		$_SESSION['last_border_edited'] = $page_name;
	
	$encap_delim = "<!-- WYSIWYG Encapsulation. Modify HTML inside of these comments only.  All code outside of these comments is discarded. -->";
	if ($mode == "blog")
	{
		$post_locate_string = "<!-- Post locate string for blog ID " . $blog_id . ". Do not remove this line. -->";
		$blog_encap_delim = "<!-- Blog header encapsulation.  Blogs are entered after this comment. Do not remove this line. -->";
	}
	
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if (BWB_WEBPAGE_DIR == '')
		$website_folder = '';
	else
		$website_folder = "/" . BWB_WEBPAGE_DIR;
	
if ($disable_site_styles != 1)
{
	if ((isset($sValue)) && ($sValue != ""))
	{
		$sValue_arr = explode($encap_delim, $sValue);
		$sValue = $sValue_arr[1];
		//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//		$spacer = "\n\n----------------------------------------------\n\n\n\n";
//		fwrite($fh, $spacer . $sValue_arr[0]);
//		fwrite($fh, $spacer . $sValue);
//		fwrite($fh, $spacer . $sValue_arr[2]);
		//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
		
		// Because of unpredictable behavior as to where CKeditor allows added on content for new pages, need to dig content out of top of page.
		if ( (substr($page_name, 0, 6) != "header") && (substr($page_name, 0, 6) != "footer") )
		{
			$sValue_arr[0] = str_replace("<div class='wrap' id='wrap'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"wrap\" id=\"wrap\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='wrap' class='wrap'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"wrap\" class=\"wrap\">", "", $sValue_arr[0], $count);

			if (strpos($sValue_arr[0], "<table style='height:100%; width:100%'>") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<table style='height:100%; width:100%'>"), strlen("<table style='height:100%; width:100%'>"));
			if (strpos($sValue_arr[0], "<table style=\"height:100%; width:100%\">") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<table style=\"height:100%; width:100%\">"), strlen("<table style=\"height:100%; width:100%\">"));
			if (strpos($sValue_arr[0], "<table style='width:100%; height:100%'>") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<table style='width:100%; height:100%'>"), strlen("<table style='width:100%; height:100%'>"));
			if (strpos($sValue_arr[0], "<table style=\"width:100%; height:100%\">") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<table style=\"width:100%; height:100%\">"), strlen("<table style=\"width:100%; height:100%\">"));
			if (strpos($sValue_arr[0], "<tbody>") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<tbody>"), strlen("<tbody>"));
			if (strpos($sValue_arr[0], "<tr>") !== false)
				$sValue_arr[0] = substr_replace($sValue_arr[0], "", strpos($sValue_arr[0], "<tr>"), strlen("<tr>"));
		}
		if (($special != 1) || ($mode == "blog"))
		{	
			// no semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' class='content_td' id='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" class=\"content_td\" id=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='content_td' id='content_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"content_td\" id=\"content_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class='content_div' id='content_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"content_div\" id=\"content_div\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' id='content_td' class='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" id=\"content_td\" class=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='content_td' class='content_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"content_td\" class=\"content_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='content_div' class='content_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"content_div\" class=\"content_div\">", "", $sValue_arr[0], $count);
			
			// semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' class='content_td' id='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" class=\"content_td\" id=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='content_td' id='content_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"content_td\" id=\"content_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' id='content_td' class='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" id=\"content_td\" class=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='content_td' class='content_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"content_td\" class=\"content_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			
			// semicolon, space
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' class='content_td' id='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" class=\"content_td\" id=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='content_td' id='content_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"content_td\" id=\"content_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' id='content_td' class='content_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" id=\"content_td\" class=\"content_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='content_td' class='content_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"content_td\" class=\"content_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);

			$sValue_arr[0] = str_replace("<td>", "", $sValue_arr[0], $count);
		}
		elseif (substr($page_name, 0, 3) == "top")
		{
			// no semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' class='top_td' id='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" class=\"top_td\" id=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='top_td' id='top_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"top_td\" id=\"top_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='top_td' id='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"top_td\" id=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class='top_div' id='top_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"top_div\" id=\"top_div\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' id='top_td' class='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" id=\"top_td\" class=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='top_td' class='top_td' style='vertical-align:top'", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"top_td\" class=\"top_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='top_td' class='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"top_td\" class=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='top_div' class='top_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"top_div\" class=\"top_div\">", "", $sValue_arr[0], $count);
			
			// semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' class='top_td' id='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" class=\"top_td\" id=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='top_td' id='top_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"top_td\" id=\"top_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' id='top_td' class='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" id=\"top_td\" class=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='top_td' class='top_td' style='vertical-align:top;'", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"top_td\" class=\"top_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			
			// semicolon, space
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' class='top_td' id='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" class=\"top_td\" id=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='top_td' id='top_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"top_td\" id=\"top_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' id='top_td' class='top_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" id=\"top_td\" class=\"top_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='top_td' class='top_td' style='vertical-align: top;'", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"top_td\" class=\"top_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
		}
		elseif (substr($page_name, 0, 6) == "bottom")
		{
			// no semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' class='bottom_td' id='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" class=\"bottom_td\" id=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='bottom_td' id='bottom_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"bottom_td\" id=\"bottom_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='bottom_td' id='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"bottom_td\" id=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class='bottom_div' id='bottom_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"bottom_div\" id=\"bottom_div\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' id='bottom_td' class='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" id=\"bottom_td\" class=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='bottom_td' class='bottom_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"bottom_td\" class=\"bottom_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='bottom_td' class='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"bottom_td\" class=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='bottom_div' class='bottom_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"bottom_div\" class=\"bottom_div\">", "", $sValue_arr[0], $count);
			
			// semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' class='bottom_td' id='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" class=\"bottom_td\" id=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='bottom_td' id='bottom_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"bottom_td\" id=\"bottom_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' id='bottom_td' class='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" id=\"bottom_td\" class=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='bottom_td' class='bottom_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"bottom_td\" class=\"bottom_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			
			// semicolon, space
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' class='bottom_td' id='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" class=\"bottom_td\" id=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='bottom_td' id='bottom_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"bottom_td\" id=\"bottom_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' id='bottom_td' class='bottom_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" id=\"bottom_td\" class=\"bottom_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='bottom_td' class='bottom_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"bottom_td\" class=\"bottom_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
		}
		elseif (substr($page_name, 0, 4) == "left")
		{
			// no semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' class='left_td' id='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" class=\"left_td\" id=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='left_td' id='left_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"left_td\" id=\"left_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class='left_div' id='left_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"left_div\" id=\"left_div\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' id='left_td' class='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" id=\"left_td\" class=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='left_td' class='left_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"left_td\" class=\"left_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='left_div'> class='left_div'", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"left_div\" class=\"left_div\">", "", $sValue_arr[0], $count);
			
			// semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' class='left_td' id='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" class=\"left_td\" id=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='left_td' id='left_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"left_td\" id=\"left_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' id='left_td' class='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" id=\"left_td\" class=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='left_td' class='left_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"left_td\" class=\"left_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			
			// semicolon, space
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' class='left_td' id='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" class=\"left_td\" id=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='left_td' id='left_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"left_td\" id=\"left_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' id='left_td' class='left_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" id=\"left_td\" class=\"left_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='left_td' class='left_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"left_td\" class=\"left_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
		}
		elseif (substr($page_name, 0, 5) == "right")
		{
			// no semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' class='right_td' id='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" class=\"right_td\" id=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='right_td' id='right_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"right_td\" id=\"right_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class='right_div' id='right_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div class=\"right_div\" id=\"right_div\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top' id='right_td' class='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top\" id=\"right_td\" class=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='right_td' class='right_td' style='vertical-align:top'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"right_td\" class=\"right_td\" style=\"vertical-align:top\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id='right_div' class='right_div'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<div id=\"right_div\" class=\"right_div\">", "", $sValue_arr[0], $count);
			
			// semicolon, no space
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' class='right_td' id='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" class=\"right_td\" id=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='right_td' id='right_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"right_td\" id=\"right_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align:top;' id='right_td' class='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align:top;\" id=\"right_td\" class=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='right_td' class='right_td' style='vertical-align:top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"right_td\" class=\"right_td\" style=\"vertical-align:top;\">", "", $sValue_arr[0], $count);
			
			// semicolon, space
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' class='right_td' id='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" class=\"right_td\" id=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class='right_td' id='right_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td class=\"right_td\" id=\"right_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style='vertical-align: top;' id='right_td' class='right_td'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td style=\"vertical-align: top;\" id=\"right_td\" class=\"right_td\">", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id='right_td' class='right_td' style='vertical-align: top;'>", "", $sValue_arr[0], $count);
			$sValue_arr[0] = str_replace("<td id=\"right_td\" class=\"right_td\" style=\"vertical-align: top;\">", "", $sValue_arr[0], $count);
		}
		elseif (substr($page_name, 0, 6) == "header")
			$sValue_arr[0] = str_replace("<header>", "", $sValue_arr[0], $count);
		elseif (substr($page_name, 0, 6) == "footer")
			$sValue_arr[0] = str_replace("<footer>", "", $sValue_arr[0], $count);

		$sValue_arr[0] = trim($sValue_arr[0]);
		$sValue = $sValue_arr[0]. $sValue;
		//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//		fwrite($fh, $spacer . $sValue_arr[0]);
//		fwrite($fh, $spacer . $sValue);
		//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
		
		// Because of unpredictable behavior as to where CKeditor allows added on content for new pages, need to dig content out of bottom of page.
		// Note: The order with which items are replaced is very important.  Note that the string is being worked on from the end as the order is reversed.
		$sValue_arr[2] = trim($sValue_arr[2]);
		if (isset($sValue_arr[2]) && ($sValue_arr[2] != ""))
		{
			$sValue_arr[2] = strrev($sValue_arr[2]);
			// Search for extraneous paragraphs that CKEditor adds to the bottom from time to time.
			$pos = strpos($sValue_arr[2], ">", 0);
			if (substr($sValue_arr[2], $pos + 1, 1) == "p")	// Found pesky paragraph.  Nuke it!!!
			{
				if (strpos($sValue_arr[2], ">p/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">p/<"), strlen(">p/<"));
				if (strpos($sValue_arr[2], ";psbn&") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ";psbn&"), strlen(";psbn&"));
				if (strpos($sValue_arr[2], ">p<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">p<"), strlen(">p<"));
			}
			if ( (substr($page_name, 0, 6) != "header") && (substr($page_name, 0, 6) != "footer") )
			{
				if (strpos($sValue_arr[2], ">vid/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">vid/<"), strlen(">vid/<"));
				if (strpos($sValue_arr[2], ">elbat/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">elbat/<"), strlen(">elbat/<"));
				if (strpos($sValue_arr[2], ">ydobt/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">ydobt/<"), strlen(">ydobt/<"));
				if (strpos($sValue_arr[2], ">rt/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">rt/<"), strlen(">rt/<"));
				if (strpos($sValue_arr[2], ">dt/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">dt/<"), strlen(">dt/<"));
				if (strpos($sValue_arr[2], ">vid/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">vid/<"), strlen(">vid/<"));
			}
			elseif (substr($page_name, 0, 6) == "header")
			{
				if (strpos($sValue_arr[2], ">redaeh/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">redaeh/<"), strlen(">redaeh/<"));
			}
			elseif (substr($page_name, 0, 6) == "footer")
			{
				if (strpos($sValue_arr[2], ">retoof/<") !== false)
					$sValue_arr[2] = substr_replace($sValue_arr[2], "", strpos($sValue_arr[2], ">retoof/<"), strlen(">retoof/<"));
			}
				
			$sValue_arr[2] = strrev($sValue_arr[2]);
			$sValue_arr[2] = trim($sValue_arr[2]);
			$sValue .= $sValue_arr[2];
			//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//			fwrite($fh, $spacer . $sValue_arr[2]);
//			fwrite($fh, $spacer . $sValue);
//			fclose($fh);
			//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
		}
		else	// Somehow CKEditor editer removed separator comment, or stuck bottom stuff to be removed above separator.
		{		// Need to trim out end structures from main content.
			$sValue = strrev($sValue);
			if ( (substr($page_name, 0, 6) != "header") && (substr($page_name, 0, 6) != "footer") )
			{
				if (strpos($sValue, ">vid/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">vid/<"), strlen(">vid/<"));
				if (strpos($sValue, ">elbat/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">elbat/<"), strlen(">elbat/<"));
				if (strpos($sValue, ">ydobt/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">ydobt/<"), strlen(">ydobt/<"));
				if (strpos($sValue, ">rt/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">rt/<"), strlen(">rt/<"));
				if (strpos($sValue, ">dt/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">dt/<"), strlen(">dt/<"));
				if (strpos($sValue, ">vid/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">vid/<"), strlen(">vid/<"));
			}
			elseif (substr($page_name, 0, 6) == "header")
			{
				if (strpos($sValue, ">redaeh/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">redaeh/<"), strlen(">redaeh/<"));
			}
			elseif (substr($page_name, 0, 6) == "footer")
			{
				if (strpos($sValue, ">retoof/<") !== false)
					$sValue = substr_replace($sValue, "", strpos($sValue, ">retoof/<"), strlen(">retoof/<"));
			}
			
			$sValue = strrev($sValue);
			$sValue = trim($sValue);
			//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
//			fwrite($fh, $spacer . "bottom not found");
//			fwrite($fh, $spacer . $sValue);
//			fclose($fh);
			//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%//
		}
	}
}	// if not disable_site_styles
	
	$page_name = addslashes($page_name);
	$sValue = addslashes($sValue);
	$today = date("Y-m-d H:i:s");
	
	if ($mode == "blog")
	{
		$query = "SELECT blog_id FROM " . BWB_TABLE_PREFIX . "blogs_draft WHERE blog_id='$blog_id'";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)	
			$query = "UPDATE " . BWB_TABLE_PREFIX . "blogs_draft SET post='$sValue', revised='$today' WHERE blog_id='$blog_id'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "blogs_draft SET blog_id='$blog_id', post='$sValue', revised='$today'";

		$cnt = $bwb_dbh->exec($query);
		
		$query = "TRUNCATE " . BWB_TABLE_PREFIX . "page_data_draft";
		$count = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "blogs_bkup SET blog_id='$blog_id', page_name='$page_name', post='$sValue', `owner`='$userid', revised='$today'";
		$cnt = $bwb_dbh->exec($query);
	}
	else
	{
		$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name='$page_name'";
		$result = $bwb_dbh->query($query);
		if ($result->rowCount() > 0)	
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_draft SET page_content='$sValue', revised='$today', `source`=$special WHERE page_name='$page_name'";
		else
			$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_draft SET page_name='$page_name', page_content='$sValue', revised='$today', `source`=$special";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$page_name', page_content='$sValue', revised='$today', `source`=$special";
		$cnt = $bwb_dbh->exec($query);
	}
	
	// If Publish clicked then save page and stay in editor.
	if ($action == "publish")
	{
		$page_name = addslashes($page_name);
		$sValue = addslashes($sValue);
		$today = date("Y-m-d H:i:s");
		
		if ($special == 1)
		{
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name='$page_name'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data_special SET page_content='$sValue', revised='$today' WHERE page_name='$page_name'";
			else
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_special SET page_name='$page_name', page_content='$sValue', revised='$today'";
		}
		elseif ($mode == "blog")
		{
			$query = "SELECT `id` FROM " . BWB_TABLE_PREFIX . "blogs WHERE `id`='$blog_id'";
			$result = $bwb_dbh->query($query);
			$row_cnt = $result->rowCount();
			
			if ($row_cnt > 0)
			{
				$query = "UPDATE " . BWB_TABLE_PREFIX . "blogs SET post='$sValue', revised='$today' WHERE id='$blog_id'";
				$cnt = $bwb_dbh->exec($query);
			}
			else
			{
				echo "ERROR: Did not find existing blog with ID $blog_id.  Inserting new blog.<br>";
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "blogs SET post='$sValue', page_name='$page_name', owner='$userid', revised='$today'";
				$cnt = $bwb_dbh->exec($query);
			}
			$query = "SELECT page_content FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='" . $page_name . "'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() < -1)
			{
				echo "ERROR: Can't find page content for page $pagename.<br/>";
				$page_content_append = "";
			}
			else
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_content_append = $row['page_content'];
				$page_content_prepend = "";
				// Look for blog dilimiters and split content.
				$page_content_append_arr = explode($blog_encap_delim, $page_content_append, 2);
				if (count($page_content_append_arr) > 1)
				{
					$page_content_prepend = $page_content_append_arr[0];
					$page_content_append = $page_content_append_arr[1];
				}
			}
			if ($row_cnt > 0)
			{
				// Find existing post from page content, remove and replace with new.
				if (strpos($page_content_append, $post_locate_string) !== false)
				{
					$page_content_arr = explode($post_locate_string, $page_content_append);
					$page_content_w_blog = $page_content_prepend . $page_content_arr[0] . $sValue . $page_content_arr[2]; 
				}
				else
					$page_content_w_blog = $page_content_prepend . $sValue . $page_content_append;
			}
			else
				$page_content_w_blog = $page_content_prepend . $sValue . $page_content_append;	// Prepend page with new post and publish.
			$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data SET page_content='$page_content_w_blog', revised='$today' WHERE page_name='$page_name'";	
		}
		else
		{
			$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
			$result = $bwb_dbh->query($query);
			if ($result->rowCount() > 0)
				$query = "UPDATE " . BWB_TABLE_PREFIX . "page_data SET page_content='$sValue', revised='$today' WHERE page_name='$page_name'";
			else
				$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data SET page_name='$page_name', page_content='$sValue', revised='$today'";
		}
			
		$cnt = $bwb_dbh->exec($query);
	}
	
	
	if ($cnt > 0)
		echo "Update complete";
	else
		echo "Update failed";
	
?>
