<?php
// FormMailer, copyright 2007-2011, EB Dynamics, Inc., Ed Lemmers
// For licensing, see license.txt.
//
// This module may be customized to your needs, however, the design is intended to cover all
// form mailing needs without modification by directing this module through hidden fields
// from within your form.  Having said that, we know there will always be something else that
// is required, but we think this module should do a good job of handling most situations
// without modification.
error_reporting (E_ALL ^ E_NOTICE);

// Modify the line below for your particular website.  This will eliminate attacks from remote servers.
//$referers = array('www.example.com', 'example.com');
$server_name = $_SERVER['SERVER_NAME'];
$server_name_www = "www." . $server_name;
$referers = array($server_name_www, $server_name);


// Module for performaing actual email operation.
include("mime_mail.inc");
// DB connection for retrieving HTML message format for message back to inquirer, etc.
include("../connect/db_connect.php");
include("../connect/config.php");
include("clean_var.php");
// List of key fields to ignore (not customer data, but rather configuration hidden fields).
include("ignore_fields.php");

// If alternate go back specified, then use that if any errors.  This is usefule if sending page session expires if back button is used.
if ($_POST['alt_go_back'])
{
	$go_back = $_POST['alt_go_back'];
	$delim = "?";
	foreach($_POST as $key => $val)
	{
		if (!in_array($key, $ignore_fields))
		{
			if ((strpos($key, "password") === false) && (isset($val) && ($val != "")))
			{
				$go_back .= $delim . $key . "=" . $val;
				$delim = "&";
			}
		}
	}
}
else
	$go_back = "javascript:history.go(-1);";


// Used in conjunciton with $referers to eliminate atacks from remote servers.
$valid_env = array('REMOTE_HOST', 'REMOTE_ADDR', 'REMOTE_USER', 'HTTP_USER_AGENT');

// Add additional ignore fields from hidden ingore_fields element on form to ingore_field list.
$post_ignore_fields = $_POST['ignore_fields'];
$additional_ignore_fields = explode(",", $post_ignore_fields);
foreach ($additional_ignore_fields as $val)	{
	$ignore_fields[] = trim($val);
}

// List of longtext type fields.
$longtext_fields = array("comments", "note", "notes", "suggestions", "feedback", "question", "questions");

// Add additional longtext type fields from hidden longtext_fields element on form to longtext_fields list.
$post_longtext_fields = $_POST['longtext_fields'];
$additional_longtext_fields = explode(",", $post_longtext_fields);
foreach ($additional_longtext_fields as $val)	{
	$longtext_fields[] = trim($val);
}

// From hidden fields to direct mail to site manager and forward page to desired message, etc.
// "recipient", "redirect" and "subject" are required.  If "from" is left blank then the 'from' 
// will show as "Mail Request Form <email>".  If "html" is left blank, then the message will
// default to text.
// If desired, you may repalec the @ simbol with 5 plus signs in your mail form.  This will prenvent robots from harvesting your email
// until this technique gains popularity.
$referer = $_SERVER['HTTP_REFERER'];
$referer_arr = explode("/", $referer);
$page_name = $referer_arr[count($referer_arr)-1];
$page_name = str_replace(".php", "", $page_name);
$query = "SELECT * FROM form_recipients WHERE page_name = :page_name";
$stmt = $bwb_dbh->prepare($query);
$stmt->execute(array(':page_name' => $page_name));
if ($stmt->rowCount() > 0)	{
	$row = $stmt->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT);
	$recipient = $row['recipient'];
}
else	{
	$recipient = $_POST['recipient'];
	$recipient = str_replace("+++++", "@", $recipient);
}

$redirect = $_POST['redirect'];
$subject = $_POST['subject'];
$reply_to = $_POST['reply_to'];
$from = $_POST['from'];
if ($_POST['html'])
	$html = 1;	// html
else
	$html = 0;	// text
if ($_POST['no_mime'])
	$no_mime = 1;	// Certain servers can't handle mime messages such as GoDaddy hosting.
else
	$no_mime = 0;
if ($_POST['octet_stream'])
	$octet_stream = 1;	// If adding attachments, then it might be necessary to set the content type to application/octet-stream.
else
	$octet_stream = 0;
if ($_POST['html_msg_as_text'])
	$html_msg_as_text = 1;	// Override to send HTML message to form user as text instead.
else
	$html_msg_as_text = 0;
	
// Special flag to denote that 'email' is a required field.  If 'email' is required here, 'email_confirm'
// will also be required.  If you do not need email confirm, then add "email" to the 'required_fields'
// string on your form instead.
$email_required = $_POST['email_required'];

// Special flag to denote that 'password' is a required field.  If 'password' is required here,
// 'password_confirm' will also be required.
$password_required = $_POST['password_required'];
$password_length = $_POST['password_length'];
$password_strength = $_POST['password_strength'];

// Flag to switch redirect back to form instead of displaying error message from this module.  Set to 1 to send errors back to form.
$redirect_err_to_src = $_POST['redirect_err_to_src'];

// You may specify which fields are required to be filled in.  Use a comma "," to separate fields.
$required_fields = $_POST['required_fields'];
if ($required_fields)
{
	$required_field_array = explode(",", $required_fields);
	foreach ($required_field_array as $value)
	{
		if (!$_POST[$value])
		{
			$err_code = "required&field=$value";
			$err_msg = "The '$value' field has not been filled in.  Please fill in this field.";
			DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
		}	
	}
}

// Information from user input.  Possible expected fields that may require special handling.
$email	= trim($_POST['email']);
$email_confirm = trim($_POST['email_confirm']);
$password	= trim($_POST['password']);
$password_confirm = trim($_POST['password_confirm']);
$use_email_as_userid = $_POST['use_email_as_userid'];

// If email required flag is sent, then verify that 'email' has been filled in and 'email_confirm'
// matches 'email'.
if (((!$email) || ($email != $email_confirm)) && $email_required)
{
	$err_code = "email";
	$err_msg = "Your email is blank or does not match the confirm.  Please fill in your email address.";
	DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
}

// If password required flag is sent, then verify that 'password' has been filled in and 'password_confirm'
// matches 'password'.
if (((!$password) || ($password != $password_confirm)) && $password_required)
{
	$err_code = "no_match";
	$err_msg = "Your password is blank or does not match the confirm.  Please fill in your password.";
	DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
}
// Verify password length is at least password_length long.
if (isset($password) && isset($password_length))
{
	if (strlen($password) < $password_length)
	{
		$err_code = "too_short";
		$err_msg = "Your password is too short.  Please fill in a password of at least $password_length characters long.";
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	}
}
// Verify password meets strength requirements.
if (isset($password) && isset($password_strength))
{
	$pass_strength_err = false;
	
	if ($password_strength == "medium")
	{
		if (!preg_match('/[A-Za-z]/', $password) || !preg_match('/[0-9]/', $password))
		{
			$pass_strength_err = true;
			$err_msg = "Your password is too weak.  Please fill in a password contaning both letters and numbers.";
		}
	}
	if ($password_strength == "high")
	{
		$symbols = array('~','!','@','#','\$','%','^','&','*','(',')','[',']','{','}','?','+','=','-','_','/','|','\\','.',',','<','>',',',"'",'"',':',';');
		if (!preg_match('/[A-Za-z]/', $password) || !preg_match('/[0-9]/', $password) || (strpos_a($password, $symbols) < 0))
		{
			$pass_strength_err = true;
			$err_msg = "Your password is too weak.  Please fill in a password contaning letters, numbers and symbols.";
		}
	}
	
	if ($pass_strength_err === true)
	{
		$err_code = "too_weak&password_strength=" . $password_strength;
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	}
}

// Check email address to make sure it is not bogus.
if ($email_required)
{
	if (!check_email_address($email))
	{
		$err_code = "bad_email";
		$err_msg = "The email address $email is not valid.  Please go back and type your email address again.";
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	}
}

// Check referers to make sure SPAM bot is not trying to brake in.
if (!check_referer($referers))
{
	$err = "You do not appear to be a valid.  If this is in error, go back and try again.<br />\n<a href='$go_back'>Click here</a> to return to the previous page, or use your 'Back' button.";
	$button_label = "OK";
	include("error_msg.php");
	exit;
}

///////////////////////////////////////
if ($_POST['use_captcha'])
{
	$captcha_err = false;
	
	if (!isset($_POST['captcha_type']) || ($_POST['captcha_type'] == "recaptcha"))
	{
	  include("../connect/captchakeys.php");
	  require_once('recaptchalib.php');
	  $resp = recaptcha_check_answer (RECAPTCHA_PRIVATE_KEY,
									$_SERVER["REMOTE_ADDR"],
									$_POST["recaptcha_challenge_field"],
									$_POST["recaptcha_response_field"]);
	
	  if (!$resp->is_valid) {
			// Verification code is incorrect.
			$captcha_err = true;
		}
	}
	elseif ($_POST['captcha_type'] == "wscaptcha")	// Requires purchase of PHP Captcha from http://webspamprotect.com/
	{
		require_once("wspcaptchalib.php");
		if (!WSP_CheckCAPTCHA()) {
			// Verification code is incorrect.
			$captcha_err = true;
		}
	}
	elseif ($_POST['captcha_type'] == "mollom")	// Requires acquisition of public and private keys from http://mollom.com
	{
		require_once("mollom.php");
		include("../connect/captchakeys.php");
		
		$captcha_response_field = $_POST['captcha_response_field'];
		$mollom_session = $_POST['mollom_session'];
		
		// Set keys from connect/captchakeys.php
		Mollom::setPublicKey(MOLLOM_PUBLIC_KEY);
		Mollom::setPrivateKey(MOLLOM_PRIVATE_KEY);
		
		$servers = Mollom::getServerList();
		Mollom::setServerList($servers);
	
		try
		{
			if (!Mollom::checkCaptcha($mollom_session, $captcha_response_field))	{
				$captcha_err = true;
			}
		}
		catch (Exception $e)
		{
			$err = "Error accessing Mollom CAPTCHA.  Please <a href='$go_back'>go back</a> and try again.<br />$e";
			$button_label = "OK";
			include("error_msg.php");
			
			exit;
		}
	}
	
	if ($captcha_err === true)
	{
		$err_code = "captcha";
		$err_msg = "Your CAPTCHA entry is incorrect.";
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	}
}
///////////////////////////////////////

// In many instances, it is desirable to use the email address as the user ID.
if (isset($use_email_as_userid))
	$_POST['UserID'] = $email;

//Mail fields to recipient.
$mail = new mime_mail;

if ($from)
	$from_email = "$from";
else
	$from_email = "Mail Request Form <$email>";
	
$to_email = $recipient;
//$cc_email = "ed@ebdynamics.com";	//for testing

	
if ($html == 1)
	$lf = "<br>";
else
	$lf = "\n";

$msg = $_POST;
foreach ( $msg as $key => $value )
{
	// If a phone number is found, then check for robot attacks.
	if ((strpos($key, "phone") > -1) && ($key != "preferred_phone"))
	{
		if (!CheckPhoneField($value))
		{
			header("Location: $redirect");
			exit;
		}
	}
	
	if ((!in_array($key, $ignore_fields)) && ($key != "subject"))
		$msg = $msg."$lf".$key.": ".$value;
}
$msg = str_replace( "Array", "", $msg );
if ($html == 1)
	$msg = "<b>$subject</b>$lf" . $msg;
else
	$msg = "$subject$lf" . $msg;

/////////// Check for robots by counting URLs. ////////////////////
$http_cnt = 0;
$pos = stripos($msg, "http");
if ($pos !== false)
{
	$http_cnt++;
	$pos2 = stripos($msg, "http", $pos + 1);
	if ($pos2 !== false)
		$http_cnt++;
}
if ($http_cnt > 1)
{
	header("Location: $redirect");
	exit;
}
/////////// Check for robots by counting URLs. ////////////////////

$mail->from = $from_email;
$mail->to = $to_email;
$mail->cc = $cc_email;
$mail->replyto = $reply_to;
$mail->subject = $subject;
$mail->body = $msg;
$mail->html = $html;
$mail->no_mime = $no_mime;
$mail->octet_stream = $octet_stream;

$mail->send();

//$email_ext = substr($to_email, strlen($to_email) - 8);
//if ($email_ext == "@aol.com")	// AOL emails
//	mail($to_email, $subject, $msg);

/////////////////////////////////////////////////////////////////////////
// Pipe data to table.  Create table if it does not exist.
// But first clean entire POST var array:
foreach ($_POST as $key => $value)
	$_POST[$key] = CleanVar($value);
	
$title = $_POST['title'];
$first_name = $_POST['first_name'];
$last_name = $_POST['last_name'];
$status = $_POST['status'];
$phone_work = $_POST['phone_work'];
$phone_fax = $_POST['phone_fax'];
$phone_home = $_POST['phone_home'];
$phone_mobile = $_POST['phone_mobile'];
$primary_address_street = $_POST['primary_address_street'];
$primary_address_city = $_POST['primary_address_city'];
$primary_address_state = $_POST['primary_address_state'];
$primary_address_postalcode = $_POST['primary_address_postalcode'];
$primary_address_country = $_POST['primary_address_country'];
$account_name = $_POST['account_name'];
$lead_source = $_POST['lead_source'];
$description = $_POST['description'];
	
$query = "SELECT * FROM sugarcrm_connect";
$result = $bwb_dbh->query($query);
$row = $result->fetch(PDO::FETCH_ASSOC);
$website = $row["website"];
$sugarcrm_folder = $row["sugarcrm_folder"];
$username = $row["username"];
$password = $row["password"];
$sugar_service_api_ver = $row["sugar_service_api_ver"];

$url = $website . "/" . $sugarcrm_folder . "/service/" . $sugar_service_api_ver . "/soap.php?wsdl";

//require NuSOAP
require_once("./nusoap/nusoap.php");

//retrieve WSDL
$soapclient = new nusoap_client($url, 'wsdl');

//display errors
$err = $soapclient->getError();
if ($err)
{
	echo '<h2>Constructor error</h2><pre>' . $err . '</pre>';
	echo '<h2>Debug</h2><pre>' . htmlspecialchars($soapclient->getDebug(), ENT_QUOTES) . '</pre>';
	exit();
}

//login -------------------------------------------------------
	 
$login_parameters = array('user_auth' => array('user_name' => $username, 'password' => $password), 'application_name' => 'Lead Collection');
	 
$login_result = $soapclient->call('login', $login_parameters);

//get session id
$session_id =  $login_result['id'];


$user_guid = $soapclient->call('get_user_id', array('session' => $session_id));

$query = "leads.id in (SELECT email_addr_bean_rel.bean_id FROM email_addr_bean_rel JOIN email_addresses ON (email_addresses.id = email_addr_bean_rel.email_address_id) WHERE email_addr_bean_rel.deleted=0 AND email_addresses.email_address LIKE '" . $email . "%' AND leads.first_name='" . $first_name . "' AND leads.last_name='" . $last_name . "')";

$get_entry_params = array('session' => $session_id,
	'module_name' => 'Leads',
  'query' => $query,
  'deleted' => 0,
  'select_fields' => "id"
);
$result = $soapclient->call('get_entry_list', $get_entry_params);


$count = $result['result_count'];
$id = $result['entry_list']['0']['name_value_list'][3]['value'];
	
$field_pairs = array();
if ($count > 0)
	$field_pairs[] = array('name'=>'id','value' => $id);
if (isset($title) && ($title != ''))
	$field_pairs[] = array('name'=>'title','value' => $title);
if (isset($first_name) && ($first_name != ''))
	$field_pairs[] = array('name'=>'first_name','value' => $first_name);
if (isset($last_name) && ($last_name != ''))
	$field_pairs[] = array('name'=>'last_name','value' => $last_name);
if (isset($status) && ($status != ''))
	$field_pairs[] = array('name'=>'status','value' => $status);
if (isset($phone_work) && ($phone_work != ''))
	$field_pairs[] = array('name'=>'phone_work','value' => $phone_work);
if (isset($phone_fax) && ($phone_fax != ''))
	$field_pairs[] = array('name'=>'phone_fax','value' => $phone_fax);
if (isset($phone_home) && ($phone_home != ''))
	$field_pairs[] = array('name'=>'phone_home','value' => $phone_home);
if (isset($phone_mobile) && ($phone_mobile != ''))
	$field_pairs[] = array('name'=>'phone_mobile','value' => $phone_mobile);
if (isset($primary_address_street) && ($primary_address_street != ''))
	$field_pairs[] = array('name'=>'primary_address_street','value' => $primary_address_street);
if (isset($primary_address_city) && ($primary_address_city != ''))
	$field_pairs[] = array('name'=>'primary_address_city','value' => $primary_address_city);
if (isset($primary_address_state) && ($primary_address_state != ''))
	$field_pairs[] = array('name'=>'primary_address_state','value' => $primary_address_state);
if (isset($primary_address_postalcode) && ($primary_address_postalcode != ''))
	$field_pairs[] = array('name'=>'primary_address_postalcode','value' => $primary_address_postalcode);
if (isset($primary_address_country) && ($primary_address_country != ''))
	$field_pairs[] = array('name'=>'primary_address_country','value' => $primary_address_country);
if (isset($account_name) && ($account_name != ''))
	$field_pairs[] = array('name'=>'account_name','value' => $account_name);
if (isset($lead_source) && ($lead_source != ''))
	$field_pairs[] = array('name'=>'lead_source','value' => $lead_source);
if (isset($description) && ($description != ''))
	$field_pairs[] = array('name'=>'description','value' => $description);
if (isset($email) && ($email != ''))
	$field_pairs[] = array('name'=>'email1','value' => $email);
if (isset($user_guid) && ($user_guid != ''))
	$field_pairs[] = array('name'=>'assigned_user_id','value' => $user_guid);
	
if (isset($_POST['custom_fields']) && ($_POST['custom_fields'] != ""))
{
	$custom_fields = explode(",", $_POST['custom_fields']);
	foreach ($custom_fields as $key => $field_name)
	{
		if (isset($_POST['field_name']) && ($_POST['field_name'] != ''))
			$field_pairs[] = array('name' => $field_name, 'value' => $_POST['field_name']);
	}
}

$set_entry_params = array('session' => $session_id, 'module_name' => 'Leads', 'name_value_list' => $field_pairs);
 
$result = $soapclient->call('set_entry', $set_entry_params);

$logout_params = array (
  'session' => $session_id
); // LogoutArray

$soapclient->call('logout', $logout_params);


/////////////////////////////////////////////////////////////////////////
// Send HTML message to inquirer if message is setup.
$html_message_page = $_POST['html_message_page'];
if (isset($html_message_page) && ($html_message_page != ""))
{
	$mail = new mime_mail;
	
	$first_name = $_POST['first_name'];
	$last_name = $_POST['last_name'];
	if (isset($_POST['UserID']))
		$userid = $_POST['UserID'];
	elseif (isset($_POST['userid']))
		$userid = $_POST['userid'];
	else
		$userid = "";
	if (isset($_POST['user_defined_placeholders']) && ($_POST['user_defined_placeholders'] != ""))
	{
		$user_defined_placeholders_str = $_POST['user_defined_placeholders'];
		$user_defined_placeholders_arr = explode(",", $user_defined_placeholders_str);
		$user_defined_placeholders = array();
		foreach ($user_defined_placeholders_arr as $placeholder_pair)
		{
			$placeholder_pair_arr = explode(":", $placeholder_pair);
			$user_defined_placeholders[$placeholder_pair_arr[0]] = $placeholder_pair_arr[1];
		}
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name = '". $html_message_page . "'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$html_msg = stripslashes($row["page_content"]);
		////////////////// Process Conditional Content First /////////////////
		include("return_msg_cond_proc.php");
		//////////////////////////////////////////////////////////////////////
		$html_msg = str_replace("[FIRST_NAME]", $first_name, $html_msg);
		$html_msg = str_replace("[LAST_NAME]", $last_name, $html_msg);
		$html_msg = str_replace("[USER_ID]", $userid, $html_msg);
		$html_msg = str_replace("[PASSWORD]", $password, $html_msg);
		$html_msg = str_replace("[EMAIL]", $email, $html_msg);
		if (isset($user_defined_placeholders) && ($user_defined_placeholders != ""))
		{
			foreach ($user_defined_placeholders as $placeholder_str => $placeholder_field)
			{
				$html_msg = str_replace($placeholder_str, $_POST[$placeholder_field], $html_msg);
			}
		}
		
		$mail->from = $from;
		$mail->to = $email;
		$mail->replyto = $reply_to;
		$mail->subject = $subject;
		$mail->body = $html_msg;
		if ($html_msg_as_text == 1)
			$mail->html = 0;
		else
			$mail->html = 1;
		$mail->no_mime = $no_mime;
		$mail->octet_stream = $octet_stream;
		
		$mail->send();
		
//		$email_ext = substr($email, strlen($email) - 8);
//		if ($email_ext == "@aol.com")	// AOL emails
//			mail($email, $subject, $html_msg);
	}
}

/////////////////////////////////////////////////////////////////////////
// If data stored in table, then pass along last id to next page.
if (isset($table_name) && ($table_name != ""))
{
	if (strpos($redirect, "?") > 0)
		$redirect .= "&last_id=" . $last_id;
	else
		$redirect .= "?last_id=" . $last_id;
}
	
// Go to desired next page.
header("Location: $redirect");
exit;

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// Check for valid emails. //////////////////////////////////////////////
function check_email_address($email) {
// First, we check that there's one @ symbol, and that the lengths are right
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
		// Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
		return false;
	}
	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
		return false;
		}
	}
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) {
			return false; // Not enough parts to domain
		 }
		for ($i = 0; $i < sizeof($domain_array); $i++) {
			 if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
				return false;
			 }
		}
	 }
	 return true;
}

/****************************************************************
 * check_referer() breaks up the enviromental variable		*
 * HTTP_REFERER by "/" and then checks to see if the second	*
 * member of the array (from the explode) matches any of the	*
 * domains listed in the $referers array (declaired at top)	*
 ****************************************************************/

function check_referer($referers)
{
	global $errors;
	if (count($referers)) {
		if (getenv('HTTP_REFERER')) {
			$temp = explode('/', getenv('HTTP_REFERER'));
			$found = false;
			while (list(,$stored_referer) = each($referers)) {
				if (eregi('^' . $stored_referer . '$', $temp[2]))
					$found = true;
			}
			if (!$found) {
				$errors[] = '1|You are coming from an unauthorized domain.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
				error_log('[PHPFormMail] Illegal Referer. (' . getenv('HTTP_REFERER') . ')', 0);
			}
			return $found;
		} else {
			$errors[] = '0|Sorry, but I cannot figure out who sent you here.  Your browser is not sending an HTTP_REFERER.  This could be caused by a firewall or browser that removes the HTTP_REFERER from each HTTP request you submit.';
			error_log('[PHPFormMail] HTTP_REFERER not defined. Browser: ' . getenv('HTTP_USER_AGENT') . '; Client IP: ' . getenv('REMOTE_ADDR') . '; Request Method: ' . getenv('REQUEST_METHOD') . ';', 0);
			return false;
		}
	} else {
		$errors[] = '1|There are no referers defined.  All submissions will be denied.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
		error_log('[PHPFormMail] You have no referers defined.  All submissions will be denied.', 0);
		return false;
	}
}

///////////////////////////////////////////////////////////////
// Check all phone numbers for valid charecters.
function CheckPhoneField($number)
{
	$formats = array('###-###-####', '####-###-###',
                 '(###) ###-###', '(###)###-###', '####-####-####',
                 '##-###-####-####', '####-####', '###-###-###',
                 '#####-###-###', '##########',
				 '#-###-###-####', '#-####-###-###',
                 '# (###) ###-###', '#(###)###-###', '#-####-####-####',
                 '#-##-###-####-####', '#-####-####', '#-###-###-###',
                 '#-#####-###-###', '###########',
				 '##-###-###-####', '##-####-###-###',
                 '##-####-####-####',
                 '##-##-###-####-####', '##-####-####', '##-###-###-###',
                 '##-#####-###-###', '############');
	
	if (strlen($number) == 0)
		return true;	// Don't worry about blank phone numbers here.
		
	if ( preg_match("/^[A-Za-z]$/", $number) )
		return false;	// If any letters are found, then most likely bogus junk found.
		
	// + and _ are OK, -so remove for testing.
	$ignore_chars = array("+", "_");
	$number = str_replace($ignore_chars, "", $number);
	// . is used inplace of - many times, so just replace.
	$number = str_replace(".", "-", $number);
		
	$format = trim(preg_replace("/[0-9]/", "#", $number));
	return (in_array($format, $formats)) ? true : false;
}

/////////////////////////////////
function doEncrypt($Data, $Key)
{
// encrypting  a[] with key k[] into e[]
// a[] = array to be encrypted
// k[] = key of truly random gibberish
// e[] = encrypted data

	for( $i = 0; $i < strlen($Data); $i++)
	{
		$c = substr($Data, $i, 1);
		$a[$i] = ord($c);
	}
	
	for( $i = 0; $i < strlen($Data); $i++)
	{
		if ($i < strlen($Key))
		{
			$c = substr($Key, $i, 1);
			$k[$i] = ord($c);
		}
		else
			$k[$i] = 65 + $i;
	}
	
	for ( $i=0; $i < strlen($Data); $i++ )
   	{
   		$e[$i] = $k[$i] ^ $a[$i];
   	}
	
	$encrypted = "";
	for ( $i = 0; $i < strlen($Data); $i++ )
	{
		$encrypted = $encrypted. decToHex($e[$i]);
	}
	return($encrypted);
	
}

function decToHex($dec)
{
	$hexStr = "0123456789ABCDEF";
	$low = $dec % 16;
	$high = ($dec - $low)/16;
	$hex = "";
	$hex = substr($hexStr, $high, 1) . substr($hexStr, $low, 1);
	return $hex;
}

/////////////////////////////////////////////////////////////
function strpos_a($haystack, $needle)
{
     if (is_array($needle)) {
         foreach ($needle as $need) {
               if (strpos($haystack, $need) !== false) {
                       return (strpos($haystack, $need));
               }
         }
     }else {
          if (strpos($haystack, $need) !== false) {
                       return (strpos($haystack, $need));
          }
     }

     return false;
}

/////////////////////////////////////////////////////////////
function DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back)
{
	if (($redirect_err_to_src == 1) && ($go_back != "javascript:history.go(-1);"))
	{
		if (strpos($go_back, "?") === false)
			$go_back .= "?err=" . $err_code;
		else
			$go_back .= "&err=" . $err_code;
			
		header("Location: $go_back");
	}
	else
	{
		$err = $err_msg . "<br />\n<a href='$go_back'>Click here</a> to return to the previous page, or use your 'Back' button.";
		$button_label = "OK";
		include("error_msg.php");
	}
	exit;
}

?>