<?php
// Reset Password, copyright 2012, EB Dynamics, Inc., Ed Lemmers
// For licensing, see license.txt.
// Revised: 3/25/2013	ELL
// Security enhancements for PDO.
// Revised 9/10/2014	BAK
// Added link back to website to a page as denfined by the 'email_link_page' hidden field.
//
// 
$server_name = $_SERVER['SERVER_NAME'];
$server_name_www = "www." . $server_name;
$referers = array($server_name_www, $server_name);


// Module for performaing actual email operation.
include("mime_mail.inc");
// DB connection for retrieving HTML message format for message back to inquirer, etc.
include("../connect/db_connect.php");
include("../connect/config.php");
include("generate_password.php");
include("../connect/captchakeys.php");
include("clean_var.php");
include("ignore_fields.php");

// If alternate go back specified, then use that if any errors.  This is usefule if sending page session expires if back button is used.
if ($_POST['alt_go_back'])
{
	$go_back = $_POST['alt_go_back'];
	$delim = "?";
	foreach($_POST as $key => $val)
	{
		if (!in_array($key, $ignore_fields))
		{
			if ((strpos($key, "password") === false) && (isset($val) && ($val != "")))
			{
				$go_back .= $delim . $key . "=" . $val;
				$delim = "&";
			}
		}
	}
}
else
	$go_back = "javascript:history.go(-1);";

$email = $_POST['email'];
$redirect = $_POST['redirect'];
$user_table = CleanVar($_POST['user_table']);
$subject = $_POST['subject'];
$reply_to = $_POST['reply_to'];
$from = $_POST['from'];

if (isset($_POST['redirect_err_to_src']) && ($_POST['redirect_err_to_src'] != ""))
	$redirect_err_to_src = 1;
else
	$redirect_err_to_src = 0;

if ($_POST['html'])
	$html = $_POST['html'];	// html
else
	$html = 0;	// text
	
if ($_POST['no_mime'])
	$no_mime = 1;	// Certain servers can't handle mime messages such as GoDaddy hosting.
else
	$no_mime = 0;

if ($_POST['use_captcha'])
{
	if (!isset($_POST['captcha_type']) || ($_POST['captcha_type'] == "recaptcha"))
	{
		require_once('recaptchalib.php');
		$resp = recaptcha_check_answer (RECAPTCHA_PRIVATE_KEY,
									$_SERVER["REMOTE_ADDR"],
									$_POST["recaptcha_challenge_field"],
									$_POST["recaptcha_response_field"]);
	
	  if (!$resp->is_valid) {
		// What happens when the CAPTCHA was entered incorrectly
		$err_msg = "The CAPTCHA wasn't entered correctly. Go <a href='$go_back'>back</a> and try it again.<br />(reCAPTCHA said: " . $resp->error . ")";
		$err_code = "captcha";
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	  }
	}
	elseif ($_POST['captcha_type'] == "wscaptcha")	// Requires purchase of PHP Captcha from http://webspamprotect.com/
	{
		require_once("wspcaptchalib.php");
		if (!WSP_CheckCAPTCHA()) {
			// Verification code is incorrect.
			$err_msg = "Your CAPTCHA entry is incorrect.  Please <a href='$go_back'>go back</a> and try again.";
			$err_code = "captcha";
			DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
		}
	}
	elseif ($_POST['captcha_type'] == "mollom")	// Requires acquisition of public and private keys from http://mollom.com
	{
		require_once("mollom.php");
		include("../connect/captchakeys.php");
		
		$captcha_response_field = $_POST['captcha_response_field'];
		$mollom_session = $_POST['mollom_session'];
		
		// Set keys from connect/captchakeys.php
		Mollom::setPublicKey(MOLLOM_PUBLIC_KEY);
		Mollom::setPrivateKey(MOLLOM_PRIVATE_KEY);
		
		$servers = Mollom::getServerList();
		Mollom::setServerList($servers);
	
		try
		{
			if (!Mollom::checkCaptcha($mollom_session, $captcha_response_field))	{
				$captcha_err = true;
			}
		}
		catch (Exception $e)
		{
			$err = "Error accessing Mollom CAPTCHA.  Please <a href='$go_back'>go back</a> and try again.<br />$e";
			$button_label = "OK";
			include("error_msg.php");
			
			exit;
		}
	}
	
	if ($captcha_err === true)
	{
		$err_code = "captcha";
		$err_msg = "Your CAPTCHA entry is incorrect.  Please <a href='$go_back'>go back</a> and try again.<br />";
		DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
	}
}

	
// Used in conjunciton with $referers to eliminate atacks from remote servers.
$valid_env = array('REMOTE_HOST', 'REMOTE_ADDR', 'REMOTE_USER', 'HTTP_USER_AGENT');

if (!isset($email) || ($email == ""))
{
	$err_msg = "The email address is blank.  Please go back and enter your email address.<br />\n<a href='$go_back'>Click here</a> to return to the previous page, or use your 'Back' button.";
	$err_code = "blank_email";
	DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
}


if (!check_email_address($email))
{
	$err_msg = "The email address $email is not valid.  Please go back and type your email address again.<br />\n<a href='$go_back'>Click here</a> to return to the previous page, or use your 'Back' button.";
	$err_code = "bad_email";
	DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
}

// Check referers to make sure SPAM bot is not trying to brake in.
if (!check_referer($referers))
{
	$err = "You do not appear to be a valid.  If this is in error, go back and try again.<br />\n<a href='$go_back'>Click here</a> to return to the previous page, or use your 'Back' button.";
	$button_label = "OK";
	include("error_msg.php");
	exit;
}

if (!isset($user_table) || ($user_table == ""))
{
	$err = "User table is blank.  Please contact your webmaster to have a user table assigned to this page.";
	$button_label = "OK";
	include("error_msg.php");
	exit;
}

// Get user ID from users table by email.
$query = "SELECT * FROM $user_table WHERE email = :email";
try {
	$stmt = $bwb_dbh->prepare($query);
} catch (PDOException $e) {
	echo $e->getMessage();
}
try {
	$stmt->execute(array(':email' => $email));
} catch (PDOException $e) {
	echo $e->getMessage();
}
$num_results = $stmt->rowCount();
$row = $stmt->fetch(PDO::FETCH_ASSOC, PDO::FETCH_ORI_NEXT);

if ($num_results < 1)
{
	$err_msg = "No user was found for the email " . $email . " that you presented.  Please click <a href='$go_back'>Click here</a> to re-enter your email address.";
	$err_code = "bad_email";
	DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back);
}
$UserID = $row['UserID'];

// Create new password.
$password = GeneratePassword();
// Insert salt into password.
$pos = rand(0, (strlen($password)-1) );
$pass1 = substr($password, 0, $pos);
$pass2 = substr($password, $pos);
$salted_pass = $pass1 . BWB_PUB_SALT . $pass2;
// Encrypt password.
$encrypt_password = doEncrypt($salted_pass, $UserID);
// Update user table with new password.
$query = "UPDATE `" . $user_table . "` SET `password`='" . $encrypt_password . "' WHERE `UserID`='" . $UserID . "'";
$cnt = $bwb_dbh->exec($query);


//Mail fields to recipient.
$mail = new mime_mail;

$content_type = "application/octet-stream";

if ($from)
	$from_email = "$from";
else
	$from_email = "Password Reset Form <$email>";
	
$to_email = $email;
//$cc_email = "ed@ebdynamics.com";	//for testing

	
if ($html == 1)
	$lf = "<br>";
else
	$lf = "\n";
	
$protocol  = empty($_SERVER['HTTPS']) ? 'http' : 'https';
$port      = $_SERVER['SERVER_PORT'];
$disp_port = ($protocol == 'http' && $port == 80 || $protocol == 'https' && $port == 443) ? '' : ":$port";
$domain    = $_SERVER['SERVER_NAME'];
$protocol_String  = "$protocol://{$domain}{$disp_port}";

if ($_POST['email_link_page'])
	$email_link_page = $_POST['email_link_page'];	// setting for filename for user to open from link in email, set in form
else
	$email_link_page = "index.php";	//if not set in the form, default to the home page

if ($html == 1)
{
	$msg = "<b>To return to our website,  click here: </b>  " . "<a href=\"" . $protocol_String . "/" . $email_link_page . "\">RETURN</a>";
	$msg = "Your user name is <b>" . $UserID  . "</b> and your temporary password is <b>" . $password . "</b>" . $lf . $lf . $msg;
	$msg = "<b>$subject</b>" . $lf . $msg;
}
else
{
	$msg = "To return to our website, go to this web address: www." . $protocol_String . "/" . $email_link_page;
	$msg = "Your user name is " . $UserID  . " and your temporary password is " . $password . $lf . $msg;
	$msg = $subject . $lf . $msg;
}

$mail->from = $from_email;
$mail->to = $to_email;
$mail->cc = $cc_email;
$mail->replyto = $reply_to;
$mail->subject = $subject;
$mail->body = $msg;
$mail->html = $html;
$mail->no_mime = $no_mime;

$mail->send();

//$email_ext = substr($to_email, strlen($to_email) - 8);
//if ($email_ext == "@aol.com")	// AOL emails
//	mail($to_email, $subject, $msg);



// Go to desired next page.
header("Location: $redirect");
exit;

/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
// Check for valid emails. //////////////////////////////////////////////
function check_email_address($email) {
// First, we check that there's one @ symbol, and that the lengths are right
	if (!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) {
		// Email invalid because wrong number of characters in one section, or wrong number of @ symbols.
		return false;
	}
	// Split it into sections to make life easier
	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) {
		return false;
		}
	}
	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
		$domain_array = explode(".", $email_array[1]);
		if (sizeof($domain_array) < 2) {
			return false; // Not enough parts to domain
		 }
		for ($i = 0; $i < sizeof($domain_array); $i++) {
			 if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
				return false;
			 }
		}
	 }
	 return true;
}

/****************************************************************
 * check_referer() breaks up the enviromental variable		*
 * HTTP_REFERER by "/" and then checks to see if the second	*
 * member of the array (from the explode) matches any of the	*
 * domains listed in the $referers array (declaired at top)	*
 ****************************************************************/

function check_referer($referers)
{
	global $errors;
	if (count($referers)) {
		if (getenv('HTTP_REFERER')) {
			$temp = explode('/', getenv('HTTP_REFERER'));
			$found = false;
			while (list(,$stored_referer) = each($referers)) {
				if (preg_match('/^' . $stored_referer . '$/i', $temp[2]))
					$found = true;
			}
			if (!$found) {
				$errors[] = '1|You are coming from an unauthorized domain.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
				error_log('[PHPFormMail] Illegal Referer. (' . getenv('HTTP_REFERER') . ')', 0);
			}
			return $found;
		} else {
			$errors[] = '0|Sorry, but I cannot figure out who sent you here.  Your browser is not sending an HTTP_REFERER.  This could be caused by a firewall or browser that removes the HTTP_REFERER from each HTTP request you submit.';
			error_log('[PHPFormMail] HTTP_REFERER not defined. Browser: ' . getenv('HTTP_USER_AGENT') . '; Client IP: ' . getenv('REMOTE_ADDR') . '; Request Method: ' . getenv('REQUEST_METHOD') . ';', 0);
			return false;
		}
	} else {
		$errors[] = '1|There are no referers defined.  All submissions will be denied.  Please read the manual section titled &quot;<a href="' . MANUAL . '#setting_up" target="_blank">Setting Up the PHPFormMail Script</a>&quot;.';
		error_log('[PHPFormMail] You have no referers defined.  All submissions will be denied.', 0);
		return false;
	}
}

/////////////////////////////////
function doEncrypt($Data, $Key)
{
// encrypting  a[] with key k[] into e[]
// a[] = array to be encrypted
// k[] = key of truly random gibberish
// e[] = encrypted data

	for( $i = 0; $i < strlen($Data); $i++)
	{
		$c = substr($Data, $i, 1);
		$a[$i] = ord($c);
	}
	
	for( $i = 0; $i < strlen($Data); $i++)
	{
		if ($i < strlen($Key))
		{
			$c = substr($Key, $i, 1);
			$k[$i] = ord($c);
		}
		else
			$k[$i] = 65 + $i;
	}
	
	for ( $i=0; $i < strlen($Data); $i++ )
   	{
   		$e[$i] = $k[$i] ^ $a[$i];
   	}
	
	$encrypted = "";
	for ( $i = 0; $i < strlen($Data); $i++ )
	{
		$encrypted = $encrypted. decToHex($e[$i]);
	}
	return($encrypted);
	
}

function decToHex($dec)
{
	$hexStr = "0123456789ABCDEF";
	$low = $dec % 16;
	$high = ($dec - $low)/16;
	$hex = "";
	$hex = substr($hexStr, $high, 1) . substr($hexStr, $low, 1);
	return $hex;
}

/////////////////////////////////////////////////////////////
function DisplayError($redirect_err_to_src, $err_msg, $err_code, $go_back)
{
	if (($redirect_err_to_src == 1) && ($go_back != "javascript:history.go(-1);"))
	{
		if (strpos($go_back, "?") === false)
			$go_back .= "?err=" . $err_code . "&show_password_reset=1";
		else
			$go_back .= "&err=" . $err_code . "&show_password_reset=1";
			
		header("Location: $go_back");
	}
	else
	{
		$err = $err_msg;
		$button_label = "OK";
		include("error_msg.php");
	}
	exit;
}

?>