<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/10/2016	ELL
// 
// 
// 
	include ("check_session.php");
	include ("lib/archive.php");
	
	$password = $_REQUEST['password'];
	
	//////////////////////////////////////
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	$cur_ts = date('YmdHis', time());
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	ini_set('memory_limit','256M');
	//////////////////////////////////////////
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Breeze Website Builder</title>

<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</head>
<body>
<center>
<img src="theme/<?php echo $theme; ?>/images/uploading.gif" alt="<?php echo BACKUP_RESTORE_CREATING_BACKUP_PLEASE_WAIT_MSG; ?>" id="uploading_gif" style="margin-top:50px;" />
<?php

	if (!is_dir($document_root . "/backup"))	{
		if (!mkdir($document_root . "/backup"))
		die(BACKUP_RESTORE_ERROR_CREATING_FOLDER_ERR . " backup " . FOLDER_WORD . ".");
	}
		
	if (file_exists($document_root . "/backup/backup.sql"))
		unlink($document_root . "/backup/backup.sql");
	
	echo "\n<br /><br />\n<div id='dumping_msg'>" . BACKUP_RESTORE_DUMPING_DATABASE . "</div><br /><br />\n";
	// Dump database.
	$command = "mysqldump --user=$db_username --password=$db_password --host=$hostname --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "users --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "version --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "custom_site_css_preview --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "login_attempts --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "menu_items_preview --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "menu_styles_preview --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "meta_tags_template --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "options --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "page_cache --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "site_css_preview --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "template --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "blogs_draft --ignore-table=$bwb_database." . BWB_TABLE_PREFIX . "page_data_draft $bwb_database > $document_root/backup/backup.sql";
	exec($command);
	
	// Standardize table prefix to allow restoring of site in any account.  (Note: Sites with blank table prefixes can only be restored to an account with table prefix set to blank.
	if ((BWB_TABLE_PREFIX != "bwb_") && (BWB_TABLE_PREFIX != ""))
	{
		$filename = $document_root . "/backup/backup.sql";
		$handle = fopen($filename, "r");
		$contents = fread($handle, filesize($filename));
		fclose($handle);
		
		$contents = str_replace(BWB_TABLE_PREFIX, "bwb_", $contents);
		$handle = fopen($filename, "w");
		if (fwrite($handle, $contents) === FALSE) {
			echo BACKUP_RESTORE_ERROR_ERROR_WRITING_FILE_ERR . " <b>" . $filename . "</b>.";
			exit;
		}
		fclose($handle);
	}
	
	echo "<div id='zipping_msg'>" . BACKUP_RESTORE_ZIPPING_FILES . "</div><br /><br />\n";
	// Collect all possible user-created/modified files for archiving.
	$tmp_dir = $document_root . "/tmp" . $cur_ts;
	if (!mkdir($tmp_dir))
		die(BACKUP_RESTORE_ERROR_CREATING_FOLDER_ERR . " tmp " . FOLDER_WORD . ".");
	
	mkdir($tmp_dir . "/images");
	mkdir($tmp_dir . "/css");
	mkdir($tmp_dir . "/flash");
	mkdir($tmp_dir . "/media");
	mkdir($tmp_dir . "/scripts");
	mkdir($tmp_dir . "/files");
	mkdir($tmp_dir . "/php");
	mkdir($tmp_dir . "/fonts");
	if (BWB_BASE_DIR == "")
	{
		$command = "cp -r " . $document_root . "/" . BWB_IMAGE_DIR . "/* " . $tmp_dir . "/images";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_CSS_DIR . "/* " . $tmp_dir . "/css";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_FLASH_DIR . "/* " . $tmp_dir . "/flash";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_MEDIA_DIR . "/* " . $tmp_dir . "/media";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_SCRIPTS_DIR . "/* " . $tmp_dir . "/scripts";
		exec($command);
		if (BWB_WEBPAGE_DIR != "")
			$command = "cp " . $document_root . "/" . BWB_WEBPAGE_DIR . "/* " . $tmp_dir . "/files";
		else
			$command = "cp " . $document_root . "/* " . $tmp_dir . "/files";
		exec($command);
	}
	else
	{
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/* " . $tmp_dir . "/images";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_CSS_DIR . "/* " . $tmp_dir . "/css";
		exec($command);
		$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_FLASH_DIR . "/* " . $tmp_dir . "/flash";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_MEDIA_DIR . "/* " . $tmp_dir . "/media";
		exec($command);
		$command = "cp -r " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/* " . $tmp_dir . "/scripts";
		exec($command);
		if (BWB_WEBPAGE_DIR != "")
			$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/* " . $tmp_dir . "/files";
		else
			$command = "cp " . $document_root . "/" . BWB_BASE_DIR . "/* " . $tmp_dir . "/files";
		exec($command);
	}
	if (defined("BWB_LIB_DIR"))
		$command = "cp -r " . $document_root . "/" . BWB_LIB_DIR . "/* " . $tmp_dir . "/php";
	else
		$command = "cp -r " . $document_root . "/php/* " . $tmp_dir . "/php";
	exec($command);
	if (defined("BWB_FONTS_DIR") && file_exists($document_root . "/" . BWB_FONTS_DIR))	{
		$command = "cp " . $document_root . "/" . BWB_FONTS_DIR . "/* " . $tmp_dir . "/fonts";
		exec($command);
	}
	
	$command = "cp " . $document_root . "/backup/backup.sql " . $tmp_dir;
	exec($command);
	
	
	$file_name = $document_root . "/backup/backup_" . $cur_ts . ".tgz";
	$tgz_file = new gzip_file($file_name);
	// Set compression level to 1 (lowest)
	$tgz_file->set_options(array('basedir' => $document_root, 'overwrite' => 1, 'level' => 1));
	// Add entire tmp directory and all subdirectories
	$tmp_dir_rel = "tmp" . $cur_ts;
	$tgz_file->add_files(array($tmp_dir_rel));
	// Create .tgz file
	$tgz_file->create_archive();
	// Check for errors (you can check for errors at any point)
	if (count($tgz_file->errors) > 0)
		print (ERROR_CAPS_WORD); // Process errors here
	else
	{
?>
		<h1><?php echo BACKUP_RESTORE_BACKUP_COMPLETE_MSG; ?></h1>
		<p><?php echo BACKUP_RESTORE_BACKUP_READY_FOR_DOWNLOAD_1_MSG . " " . CLICK_WORD . " <a href='../backup/backup_$cur_ts.tgz'><b>" . HERE_WORD . "</b></a> " . BACKUP_RESTORE_BACKUP_READY_FOR_DOWNLOAD_2_MSG; ?></p>

		<h2>- <?php echo OR_CAP_WORD; ?> -</h2>
        
        <div class="button_console" style="width:360px;" onClick="window.location='backup_restore.php?password=<?php echo $password; ?>';"><span class='button_console_text'><?php echo CLICK_WORD . " " . HERE_WORD . " " . BACKUP_RESTORE_RETURN_TO_MSG ; ?></span></div>
    
<?php
	}
	// Delete tmp folder to reclaim space.
	$command = "rm -r -f " . $tmp_dir;
	exec($command);
?>
</center>
<script>
	document.getElementById("uploading_gif").style.display = "none";
    document.getElementById("dumping_msg").style.display = "none";
    document.getElementById("zipping_msg").style.display = "none";
</script>
</body>
</html>