<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 11/12/2008	ELL
// Fixed bug with custom tags using "#" instead of ".".
// Revised: 7/30/2009	ELL
// Added section for defining class/subclass relationships.
// Revised: 8/1/2009	ELL
// Added ability to operate using different class tables and different CSS tables.  This was done to give the ability
// to style calendar grids and event grids without adding 14 more classes to the site style list.
// Renamed from tags.php to classes.php.
// Added feed thru to show/hide custom styles.
// Revised: 8/25/2009	ELL
// Removed feed thru to show/hide custom styles as no longer need with new design of having completely separate area for doing custom CSS.
// Revised: 2/7/2012	ELL
// Added table prefix handling.
// Revised: 5/29/2012	ELL
// Added ability to revise class descriptions.
// Revised: 2/13/2013	ELL
// Added class/ID dropdown for automatically prefixing class string.
// Revised: 2/18/2013	ELL
// Added checkbox for creating link set.
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 12/27/2014	ELL
// Added 'hover' subclass.
// Revised: 2/13/2015	ELL
// Added class selector operators.
// Added comprehensive range of selectors.
// Added alpha sorting of classes.
// Revised: 4/28/2015	ELL
// Added copy class function.
// Revised: 5/5/2015	ELL
// Replaced JavaScript AJAX with JQuery AJAX.
// Converted from form post to (JQuery) AJAX.
// Added style-sheet switching.
// 
	include ("check_session.php");
		
	$style_sheet = $_REQUEST['style_sheet'];
	$class_table = $style_sheet . "_classes";
	$last_class_edited = $_SESSION['last_class_edited'];
	if (isset($_GET['class_sort_method']))	{
		$class_sort_method = $_GET['class_sort_method'];
		$_SESSION['class_sort_method'] = $class_sort_method;
	}
	elseif (isset($_SESSION['class_sort_method']))
		$class_sort_method = $_SESSION['class_sort_method'];
	else
		$class_sort_method = 0;
?>
<!DOCTYPE html>
<html>
<head>
<title>Class Editor | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

#copy_rename_btn	{	width:130px;	}

#copy_radio_btn	{	
	width:130px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px 1px;
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Copy_Pg.png);
}
#copy_radio_btn:hover	{	
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Copy_Pg_mo.png);
}
#rename_radio_btn	{
	width:130px;
	background-attachment:scroll;
	background-repeat:no-repeat;
	background-position: 5px 1px;
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Edit-Content.png);
}
#rename_radio_btn:hover	{
	background-image:url(theme/<?php echo $theme; ?>/images/icon_Edit-Content_mo.png);
}
</style>

<script src="js/json2.js"></script>
<script src="js/mouse_position.js"></script>
<script src="js/popup_msg.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/classes.js"></script>

<script>
<?php
	echo "var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "var CLASSES_STARTING_POPULATE_MSG = \"" . CLASSES_STARTING_POPULATE_MSG . "\";\n";
	echo "var CLASSES_DELETE_CLASS_CONFIRM_1_MSG = \"" . CLASSES_DELETE_CLASS_CONFIRM_1_MSG . "\";\n";
	echo "var CLASSES_DELETE_CLASS_CONFIRM_2_MSG = \"" . CLASSES_DELETE_CLASS_CONFIRM_2_MSG . "\";\n";
	echo "var CLASSES_DESCRIPTION_NOT_FOUND_MSG = \"" . CLASSES_DESCRIPTION_NOT_FOUND_MSG . "\";\n";
	echo "var CLASSES_DESCRIPTION_FOUND_MSG = \"" . CLASSES_DESCRIPTION_FOUND_MSG . "\";\n";
	echo "var CLASSES_COULD_NOT_UPDATE_DESCRIPTION_MSG = \"" . CLASSES_COULD_NOT_UPDATE_DESCRIPTION_MSG . "\";\n";
	echo "var CLASSES_DESCRIPTION_UPDATED_MSG = \"" . CLASSES_DESCRIPTION_UPDATED_MSG . "\";\n";
	echo "var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
	echo "var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
	echo "var QUERY_COMPLETE = \"" . QUERY_COMPLETE . "\";\n";
	echo "var QUERY_COMPLETE_NO_RECORD_FOUND = \"" . QUERY_COMPLETE_NO_RECORD_FOUND . "\";\n";
	echo "var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "var CLASSES_COPY_FROM_CLASS_BLANK_ERR = \"" . CLASSES_COPY_FROM_CLASS_BLANK_ERR . "\";\n";
	echo "var CLASSES_COPY_TO_CLASS_BLANK_ERR = \"" . CLASSES_COPY_TO_CLASS_BLANK_ERR . "\";\n";
	echo "var CLASSES_COPY_CLASS_COMPLETE_MSG = \"" . CLASSES_COPY_CLASS_COMPLETE_MSG . "\";\n";
	echo "var CLASSES_COPY_CLASS_ERR = \"" . CLASSES_COPY_CLASS_ERR . "\";\n";
	echo "var CLASSES_COPY_CLASS_TO_CLASS_ALREADY_EXISTS_ERR = \"" . CLASSES_COPY_CLASS_TO_CLASS_ALREADY_EXISTS_ERR . "\";\n";
	echo "var CLASSES_SET_CLASS_SORT_ORDER = \"" . CLASSES_SET_CLASS_SORT_ORDER . "\";\n";
	echo "var CLASSES_CLASS_DESCRIPTION = \"" . CLASSES_CLASS_DESCRIPTION . "\";\n";
	echo "var SORT_ORDER = \"" . SORT_ORDER . "\";\n";
	echo "var CUSTOM_WORD = \"" . CUSTOM_WORD . "\";\n";
	echo "var UPDATE_WORD = \"" . UPDATE_WORD . "\";\n";
	echo "var CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG = \"" . CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG . "\";\n";
	echo "var CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR = \"" . CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR . "\";\n";
	echo "var CLASSES_ADD_CLASS_COMPLETE_MSG = \"" . CLASSES_ADD_CLASS_COMPLETE_MSG . "\";\n";
	echo "var CLASSES_DEFINE_SUBCLASS_COMPLETE_MSG = \"" . CLASSES_DEFINE_SUBCLASS_COMPLETE_MSG . "\";\n";
	echo "var CLASSES_DEFINE_SUBCLASS_DEFINE_ERR = \"" . CLASSES_DEFINE_SUBCLASS_DEFINE_ERR . "\";\n";
	echo "var CLASSES_DELETE_CLASS_COMPLETE_MSG = \"" . CLASSES_DELETE_CLASS_COMPLETE_MSG . "\";\n";
	echo "var CLASSES_NO_CUSTOM_CLASSES_DEFINED = \"" . CLASSES_NO_CUSTOM_CLASSES_DEFINED . "\";\n";
?>

var style_sheet = '<?php echo $style_sheet; ?>';

</script>
</head>

<body onLoad="GetClassLists();">
<div align="center">
<table width="85%" border="0"><tr>
<td>
	<div class="button_heading_sub_level_1" id="add_delete_custom_style_heading"><div class="button_heading_text_sub_level_1"><?php echo CLASSES_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow('classes');">&nbsp;</div></div>
</td>
<td align="center">
<form name="frmChangeStyleSheet" id="frmChangeStyleSheet" action="classes.php" method="post" enctype="multipart/form-data">
  	<select name="style_sheet" id="style_sheet" onChange="document.getElementById('frmChangeStyleSheet').submit();">
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_style_sheet = $row['name'];
		$tmp_description = $row['description'];
		if ($tmp_style_sheet == $style_sheet)
			echo "		<option value='$tmp_style_sheet' selected>$tmp_description</option>\n";
		else
			echo "		<option value='$tmp_style_sheet'>$tmp_description</option>\n";
	}
?>
    </select>
    </form>
</td>
<td align="right">
  <div class='button_console_go_back' style="width:210px;" onClick="window.location.href='edit_css.php?style_sheet=<?php echo $style_sheet; ?>'"><span class='button_console_text_w_icon'><?php echo CLASSES_BACK_TO_EDIT_CSS; ?></span></div>
</td></tr></table>

<table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
<form name="formAddTag" id="formAddTag" method="post" action="add_class.php">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title" style="padding-left:5px;"><?php echo CLASSES_ADD_CLASS; ?></td>
  </tr>
  <tr>
    <td align="right">
    	<select name="class_prefix" id="class_prefix">
            <option value="." selected="selected"><?php echo CLASS_WORD; ?>:</option>
            <option value="#"><?php echo ID_WORD; ?>:</option>
            <option value=""><?php echo _NONE_WORD; ?></option>
        </select>
    </td>
    <td><input type="text" name="class" id="class" /></td>
    <td align="right"><?php echo DESCRIPTION_WORD; ?>:&nbsp;</td>
    <td><input type="text" name="description" id="description"></td>
    <td align="right"><?php echo SORT_ORDER; ?>:&nbsp;</td>
    <td><input type="text" name="sort_order" value="100"></td>
  </tr>
  <tr><td colspan="6">&nbsp;<input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
  <input type="hidden" name="show_class_editor" value="1" />
  <span class="small_message"><?php echo CLASSES_CLASS_ID_NOTE; ?></span></td></tr>
  <tr>
    <td width="10%">&nbsp;</td>
    <td colspan="4" align="center" style="padding-bottom:10px;">
    <div class='button_console_add' style="width:110px;" onClick="AddClass();"><span class='button_console_text_w_icon'><?php echo ADD_WORD; ?></span></div>
    </td>
  	<td width="10%" align="center">&nbsp;
    
  	</td>
  </tr>
  </table>
  </form>
  </td></tr></table>
<br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
<form name="formDefineSubclass" id="formDefineSubclass" method="post" action="define_sub_class.php">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="6" class="sub_title" style="padding-left:5px;"><?php echo CLASSES_CREATE_SUB_CLASS; ?></td>
  </tr>
  <tr>
    <td align="right"><?php echo CLASS_WORD; ?>:&nbsp;</td>
    <td id="class_td">&nbsp;
		
    </td>
    <td align="center">
    <select name="operator" id="operator" style="visibility:hidden;">
    	<option " "> </option>
        <option ", ">,</option>
        <option " &gt; ">&gt;</option>
        <option " + ">+</option>
        <option " ~ ">~</option>
    </select>
    </td>
    <td align="right" id="subclass_heading_td"><?php echo SUBCLASS_WORD; ?>:&nbsp;</td>
    <td>
    <div id="subclass_div">
		&nbsp;
    </div>
    <span style="visibility:hidden;" id="selector_param_span">(<input type="text" id="selector_param" name="selector_param" />)</span>
    </td>
    <td>
    	<input type="checkbox" name="create_link_set" id="create_link_set" onClick="EnableDisableSubclass(this.checked);" value="1" />
        <?php echo CLASSES_CREATE_LINK_SET; ?>
    </td>
  </tr>
  <tr>
  	<td colspan="2" align="center">
    	<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_create" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
    </td>
    <td align="center"><div class="help_button_sm" id="help_button_operator" onClick="OpenHelpWindow('css_operator');" style="visibility:hidden;">&nbsp;</div></td>
    <td>&nbsp;</td>
    <td align="center">
	    <div class="help_button_sm" id="help_button_selector" onClick="OpenHelpWindow('css_selector');">&nbsp;</div>
    </td>
  	<td align="center">
      <div class="help_button_sm" onClick="OpenHelpWindow('create_link_set');">&nbsp;</div>
      <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
      <input type="hidden" name="show_class_editor" value="1" />
    </td>
  </tr>
  <tr>
    <td colspan="6" align="center" style="padding-bottom:10px;">
    <div class='button_console_add' style="width:110px;" onClick="DefineSubClass();"><span class='button_console_text_w_icon'><?php echo CREATE_WORD; ?></span></div>
    </td>
  </tr>
  </table>
  </form>
  </td></tr></table>
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title" style="padding-left:5px;"><?php echo CLASSES_DELETE_CLASS; ?></td>
  </tr>
  <tr>
  	<td>&nbsp;</td>
    <td align="right"><?php echo CLASSES_CLASS_DESCRIPTION; ?>:&nbsp;</td>
    <td>
    <div id="class_delete_div">
		&nbsp;
    </div>
    <span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_delete" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
    </td>
    <td>&nbsp;</td>
  </tr>
  <tr><td colspan="4">&nbsp;</td></tr>
  <tr>
    <td colspan="4" align="center" style="padding-bottom:10px;">
    <div class='button_console_delete' style="width:110px;" onClick="DeleteConfirm();"><span class='button_console_text_w_icon'><?php echo EDITOR_DELETE; ?></span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="4" class="sub_title" style="padding-left:5px;"><?php echo CLASSES_EDIT_CLASS_DESCRIPTION; ?></td>
  </tr>
  <tr>
  	<td align="right"><?php echo CLASS_WORD; ?>:&nbsp;</td>
    <td>
    <div id="class_edit_div">
		&nbsp;
    </div>
    <span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_edit" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
    </td>
    <td align="right"><?php echo DESCRIPTION_WORD; ?>:&nbsp;</td>
    <td><input type="text" name="description_edit" id="description_edit" /></td>
  </tr>
  <tr>
    <td colspan="4" align="center" style="padding-bottom:10px;">
    <div class='button_console_save' style="width:110px;" onClick="UpdateDescription();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
    </td>
  </tr>
</table>

  </td></tr></table>
  
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>

  <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tr>
    <td colspan="8" class="sub_title" style="padding-left:5px;"><?php echo CLASSES_COPY_CLASS; ?></td>
  </tr>
  <tr>
  	<td align="center">
    	<div class="radio_button" id="copy_radio_btn" onClick="document.getElementById('copy_mode[0]').checked = true; EnableDisableStyleSheetSelection(document.getElementById('copy_mode[0]').value);">
        <span class='radio_button_text'><?php echo COPY_WORD; ?></span>
        <input name="copy_mode" id="copy_mode[0]" type="radio" value="copy" checked="checked" />
        </div>
        <?php echo OR_WORD; ?> 
        <div class="radio_button" id="rename_radio_btn" onClick="document.getElementById('copy_mode[1]').checked = true; EnableDisableStyleSheetSelection(document.getElementById('copy_mode[1]').value);">
        <span class='radio_button_text'><?php echo RENAME_WORD; ?></span>
        <input name="copy_mode" id="copy_mode[1]" type="radio" value="rename" />
        </div>
    </td>
  	<td align="right"><?php echo CLASSES_FROM_CLASS; ?>:&nbsp;</td>
    <td id="copy_from_class_td">&nbsp;
		
    </td>
    <td style="text-align:right; width:90px;"><?php echo CLASSES_TO_CLASS; ?>:&nbsp;</td>
    <td style="text-align:right; width:90px;">
        <select name="copy_to_class_prefix" id="copy_to_class_prefix">
            <option value="." selected="selected"><?php echo CLASS_WORD; ?>:</option>
            <option value="#"><?php echo ID_WORD; ?>:</option>
            <option value=""><?php echo _NONE_WORD; ?></option>
        </select>
    </td>
    <td><input type="text" name="copy_to_class" id="copy_to_class" onKeyUp="CheckClassNames();" onSelect="CheckClassNames();" /></td>
    <td align="right">
  	<span id="to_style_sheet_label"><?php echo CLASSES_TO_STYLE_SHEET; ?>: </span>
    </td>
    <td align="left">
      <select name="to_style_sheet" id="to_style_sheet">
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_style_sheet = $row['name'];
		$tmp_description = $row['description'];
		if ($tmp_style_sheet == $style_sheet)
			echo "		<option value='$tmp_style_sheet' selected>$tmp_description</option>\n";
		else
			echo "		<option value='$tmp_style_sheet'>$tmp_description</option>\n";
	}
?>
      </select>
  </tr>
  <tr>
  	<td colspan="2">&nbsp;</td>
  	<td>
    	<span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha_copy" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
    </td>
    <td colspan="5">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="8" align="center" style="padding-bottom:10px;">
      <div class="button_console_edit_disabled" id="copy_rename_btn" onClick="CopyClass();">
        <span class='button_console_text_w_icon'><?php echo COPY_RENAME_PAGE_COPY_RENAME_BTN; ?></span>
      </div>
    </td>
  </tr>
</table>

  </td></tr></table>
  
  <br>
  <table width="85%" border="1" cellspacing="0" cellpadding="0"><tr><td>
  <form name="formSortTags" id="formSortTags" method="post" action="set_class_sort_order.php">
  <div id="class_sort_div">
  	&nbsp;
  </div>
  </form>
  </td></tr></table>
  <br>
  <table width="80%" border="0" cellspacing="0" cellpadding="0">
  <tr>
  <td align="right">
  <div class='button_console_go_back' style="width:210px;" onClick="window.location.href='edit_css.php?style_sheet=<?php echo $style_sheet; ?>&goto_class=<?php echo $last_class_edited; ?>'"><span class='button_console_text_w_icon'><?php echo CLASSES_BACK_TO_EDIT_CSS; ?></span></div>
  </td>
  </tr>
</table>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>
</body>
</html>
