<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 12/14/2015
	
	include ("check_session.php");
	include ("lib/build_css_string.php");

	$style_sheet = $_POST['style_sheet'];

	// Create new classes table.
	$query = "DROP TABLE IF EXISTS " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_classes";
	$cnt = $bwb_dbh->exec($query);

	$query = "CREATE TABLE " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_classes SELECT * FROM " . BWB_TABLE_PREFIX . $style_sheet . "_classes";
	$cnt = $bwb_dbh->exec($query);
	
	$query = "ALTER TABLE `" . BWB_TABLE_PREFIX . $style_sheet . "_mobile_classes` ADD PRIMARY KEY (`class`)";
	$cnt = $bwb_dbh->exec($query);
	
	// Create new css table.
	$query = "DROP TABLE IF EXISTS " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_css";
	$cnt = $bwb_dbh->exec($query);
	
	$query = "CREATE TABLE " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_css SELECT * FROM " . BWB_TABLE_PREFIX . $style_sheet . "_css";
	$cnt = $bwb_dbh->exec($query);
	
	$query = "ALTER TABLE `" . BWB_TABLE_PREFIX . $style_sheet . "_mobile_css` ADD PRIMARY KEY (`class`)";
	$cnt = $bwb_dbh->exec($query);
	
	// Copy custon site CSS if site.css.
	if ($style_sheet == "site")	{
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "custom_site_css";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$custom_css = $row['custom_css'];
		
		$query = "TRUNCATE TABLE " . BWB_TABLE_PREFIX . "custom_site_mobile_css";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "custom_site_mobile_css SET custom_css = '" . $custom_css . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	
	// Add to style sheets if new/non-existing mobile style sheet.
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets WHERE name = '" . $style_sheet . "_mobile'";
	$result = $bwb_dbh->query($query);
	if ($result->rowCount() < 1)	{
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$description = $row['description'] . " Mobile";
		$show_class_editor = $row['show_class_editor'];
		$show_custom_styles = $row['show_custom_styles'];
		$sort_order = $row['sort_order'] + 1;

		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "style_sheets SET `name` = '" . $style_sheet . "_mobile', `description` = " . $description . "', show_class_editor = '" . $show_class_editor . "', show_custom_styles = '" . $show_custom_styles . "', sort_order = '" . $sort_order . "'";
		$cnt = $bwb_dbh->exec($query);
	}
	/////////////////////////////////////////////
	// Build string for site.css file /////
	$css_string = BuildCSSString(BWB_TABLE_PREFIX . $style_sheet . "_mobile_css", BWB_TABLE_PREFIX . $style_sheet . "_mobile_classes", $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");
			
	//Test to see if file already exists.
	$css_file = $style_sheet . "_mobile.css";
	
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
		
	if (file_exists($file_name))
	{
		$bkup_file_name = $file_name . time();
		if (!rename($file_name, $bkup_file_name))
			echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
		@chmod($bkup_file_name, 0644);
	}
	
	// Create file.
	$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
	$result = (fputs($fh, $css_string));
	fclose($fh) or die($php_errormsg);
	@chmod($file_name, 0644);
	
	////////////////////////////////////////////////////////////
	// Create new item tables if menu style sheet.
	if (strpos($style_sheet, "menu") !== false)
	{
		// Create new classes table.
		$query = "DROP TABLE IF EXISTS " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_classes";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "CREATE TABLE " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_classes SELECT * FROM " . BWB_TABLE_PREFIX . $style_sheet . "_item_classes";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "ALTER TABLE `" . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_classes` ADD PRIMARY KEY (`class`)";
		$cnt = $bwb_dbh->exec($query);
		
		// Create new css table.
		$query = "DROP TABLE IF EXISTS " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_css";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "CREATE TABLE " . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_css SELECT * FROM " . BWB_TABLE_PREFIX . $style_sheet . "_item_css";
		$cnt = $bwb_dbh->exec($query);
		
		$query = "ALTER TABLE `" . BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_css` ADD PRIMARY KEY (`class`)";
		$cnt = $bwb_dbh->exec($query);
		
		/////////////////////////////////////////////
		// Build string for site.css file /////
		$css_string = BuildCSSString(BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_css", BWB_TABLE_PREFIX . $style_sheet . "_mobile_item_classes", $bwb_dbh, BWB_BASE_DIR, BWB_IMAGE_DIR, BWB_TABLE_PREFIX . "fonts");
				
		//Test to see if file already exists.
		$css_file = $style_sheet . "_mobile_item.css";
		
		$document_root = $_SERVER['DOCUMENT_ROOT'];
		if (BWB_BASE_DIR == '')
			$userfiles = '';
		else
			$userfiles = "/" . BWB_BASE_DIR;
			
		$file_name = $document_root . $userfiles . "/" . BWB_CSS_DIR . "/" . $css_file;
			
		if (file_exists($file_name))
		{
			$bkup_file_name = $file_name . time();
			if (!rename($file_name, $bkup_file_name))
				echo EDIT_CSS_COULD_NOT_RENAME_1_ERR . " $file_name " . EDIT_CSS_COULD_NOT_RENAME_2_ERR . " $bkup_file_name.<br>";
			@chmod($bkup_file_name, 0644);
		}
		
		// Create file.
		$fh = fopen($file_name, 'x') or die(EDIT_CSS_CANT_CREATE_ERR . " $file_name: $php_errormsg");
		$result = (fputs($fh, $css_string));
		fclose($fh) or die($php_errormsg);
		@chmod($file_name, 0644);
	}
	
	if ($cnt === false)
		echo -1;
	else
		echo $style_sheet;
?>
