<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 10/12/2010	ELL
// Changed timestamping of `revised` field due to change from VARCHAR to DATETIME in table structure.
// Revised: 1/13/2012	ELL
// Added deletion of draft copies as well.
// Revised: 2/8/2012	ELL
// Added table prefix handling. Added reference to user files folder constant.
// Revised: 11/20/2014	ELL
// Added "redirect", "folder" and separated "page_name" from "file_name" such that this module can be used in more than one place.
// Revised: 3/26/2016	ELL
// Fixed bug where delete file, then re-create file and file cache is loaded instead of file.
//
	include ("check_session.php");

	$page_name = $_GET['page_name'];
	$file_name = $_GET['file_name'];
	$folder = $_GET['folder'];
	$redirect = $_GET['redirect'];
	
	if ($folder == "pages")
	{
		// Before we go any farther, back this puppy up!
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$page_content = addslashes(stripslashes($row["page_content"]));
		$revised = $row["revised"];
		$today = date("Y-m-d H:i:s");
		$query = "INSERT INTO " . BWB_TABLE_PREFIX . "page_data_bkup SET page_name='$page_name', page_content='$page_content', revised='$revised', deleted='$today'";
		$cnt = $bwb_dbh->exec($query);
		
		// Now go ahead and delete page record from table.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name = '$page_name'";
		$cnt = $bwb_dbh->exec($query);
		// And remove draft while you are at it.
		$query = "DELETE FROM " . BWB_TABLE_PREFIX . "page_data_draft WHERE page_name = '$page_name' AND `source`=0";
		$cnt = $bwb_dbh->exec($query);
	}
	
	// And delete actual page.
	$document_root = $_SERVER['DOCUMENT_ROOT'];
	if ($folder == "pages")
	{
		if ((BWB_BASE_DIR == '') && (BWB_WEBPAGE_DIR == ''))
			$path = $document_root . "/";
		elseif (BWB_BASE_DIR == '')
			$path = $document_root . "/" . BWB_WEBPAGE_DIR . "/";
		else
			$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_WEBPAGE_DIR . "/";
	}
	elseif ($folder == "scripts")
	{
		if (BWB_BASE_DIR == '')
			$path = $document_root . "/" . BWB_SCRIPTS_DIR . "/";
		else
			$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_SCRIPTS_DIR . "/";
	}
	elseif ($folder == "php")
		$path = $document_root . "/php/";
	else
	{
		echo "Error: no folder specified";
		exit;
	}
	
	if (file_exists($path . $file_name))
	{
		// Backup file just in case.
		$source = $path . $file_name;
		$dest = $path . "." . $file_name . time();
		copy($source, $dest);
	
		// Delete file.
		$fh = fopen($path . $file_name, 'w') or die("Can't open $path: $php_errormsg");
		fclose($fh) or die($php_errormsg);
		unlink($path . $file_name);
	}
	
	// Delete cache file.
	$save_file_path = $path . "." . $file_name . "_save";
	if (file_exists($save_file_path))
	{
		$fh = fopen($save_file_path, 'w') or die("Can't open $path: $php_errormsg");
		fclose($fh) or die($php_errormsg);
		unlink($save_file_path);
	}
	
	header("Location: $redirect");
	
?>
