<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Re-engineered: 4/23/2010	ELL
// Revised: 6/22/2010	ELL
// Modified so that upload image brings form back to class that was selected.
// Revised: 8/30/2010	ELL
// Fixed bug with handling # in HTML by using string replace. Replace ("#", ",", ".", " ") with ("POUND", "COMMA", "PERIOD", "SPACE").
// Revised: 9/28/2010	ELL
// Fixed bug with shadow parameters not loading into editor.
// Revised: 10/7/2010	ELL
// Added selection of top, bottom, right, left for border style assignment, each independently selectable.
// Revised: 11/9/2010	ELL
// Changed centering to modify #wrap instead of .wrap.  Part of switching 
// Revised: 11/10/2010	ELL
// Added persistence of style sheet selected.
// Revised: 2/3/2011	ELL
// Added sorting of image file list.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.  Added reference to user files folder constant.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear, min/max prefix for width and height and sticky footer setup button.
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/27/2013	ELL
// Added ability to change style sheet from this module.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/1/2014	ELL
// Fixed bug with preview and uploading images.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 2/16/2014	ELL
// Added modal color tinting of grouping tables to make it easier to find controls and to make enabled=disabled obvious.
// Revised 2/20/2014	ELL
// Added checking for correct parameters selected for border and line height.
// Revised: 3/3/2014	ELL
// Replaced image uploader with "AJAX" image uploader.
// Revised: 8/27/2014	ELL
// Added switch between alpha and user-defined sort for class list.
// Revised: 12/27/2014	ELL
// Added drilling down one more directory level for building background image list.
// Revised: 12/30/2014	ELL
// Added browser CSS reset button.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added "initial" throughout.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Added full compliment of length units to existing unit fields.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Added button to go to Manage Custom Fonts console.
// Revised: 9/21/2015	ELL
// Added text-indent attribute.
// Revised: 1/19/2016	ELL
// Overhauled preview to use popup page.
// Revised: 3/25/2016	ELL
// Replace numeric placeholders of -1 and -1000000 for not set with "-not set".  Added code to clear "-not set-" when user wants to type
// and code to re-apply "-not set-" when user clears the field.
// 
//
	include ("check_session.php");

	
	$style_sheet = $_REQUEST['style_sheet'];
	$_SESSION['last_style_sheet_edited'] = $style_sheet;
	$class_table = $style_sheet . "_classes";
	$css_table = $style_sheet . "_css";
	
	if (isset($_REQUEST['goto_class']))
		$goto_class = $_REQUEST['goto_class'];
	elseif (isset($_SESSION['last_class_edited']))
		$goto_class = $_SESSION['last_class_edited'];
	
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets` WHERE `name` = '" . $style_sheet . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	$show_class_editor = $row["show_class_editor"];
	
	$class_sort_method = $_SESSION['class_sort_method'];
		
?>
<!DOCTYPE HTML>
<html>
<head>
<title>Editing <?php echo $style_sheet; ?> CSS | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:215px;
	height:31px;
	width:31px;
	z-index:100;
}

#page_select_div	{
	left: 50px;
}
</style>

<script language="javascript" type="text/javascript" src="js/json2.js"></script>
<script language="javascript" type="text/javascript" src="js/ajax.js"> </script>
<script language="javascript" type="text/javascript" src="js/jquery.min.js"></script>
<script language="javascript" type="text/javascript" src="js/ajaxupload.js"></script>

<script language="javascript" type="text/javascript" src="js/check_color_str.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>

<script language="javascript" type="text/javascript" src="js/edit_css.js"></script>

<script language="javascript" type="text/javascript">
////////////////////////////////////////////////////////////////////////////////////
var upload_index;

<?php
echo "	var theme = '$theme';\n\n";

$document_root = $_SERVER['DOCUMENT_ROOT'];
if (BWB_REQUIRE_SSL == 1)
	$http = "https://";
else
	$http = "http://";
$http_host = $http . $_SERVER['HTTP_HOST'];

if (BWB_BASE_DIR == '')
{
	$path = $document_root . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_IMAGE_DIR . "/tn";
}
else
{
	$path = $document_root . "/" . BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR;
	$image_tn_dir_path = BWB_BASE_DIR . "/" . BWB_IMAGE_DIR . "/tn";
}
							
echo "var image_dir_path = '$image_dir_path';\n";
echo "var image_tn_dir_path = '$image_tn_dir_path';\n\n";

if (!is_dir($path . "/tn"))
		mkdir($path . "/tn", 0755);
		
echo "var EDIT_CSS_CLICK_UPDATE_TO_COMMIT_MSG = \"" . EDIT_CSS_CLICK_UPDATE_TO_COMMIT_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_COMPLETE_MSG = \"" . EDIT_CSS_UPDATE_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_READY_TO_SEND_MSG = \"" . EDIT_CSS_UPDATE_READY_TO_SEND_MSG . "\";\n";
echo "var EDIT_CSS_UPDATE_SENT_MSG = \"" . EDIT_CSS_UPDATE_SENT_MSG . "\";\n";
echo "var EDIT_CSS_UPDATING_MSG = \"" . EDIT_CSS_UPDATING_MSG . "\";\n";
echo "var EDIT_CSS_RESET_BROWSER_CSS_COMPLETE_MSG = \"" . EDIT_CSS_RESET_BROWSER_CSS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_CENTERED_PAGES_CSS_ALERT_MSG = \"" . EDIT_CSS_LOAD_CENTERED_PAGES_CSS_ALERT_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_CENTERED_PAGES_CSS_COMPLETE_MSG = \"" . EDIT_CSS_LOAD_CENTERED_PAGES_CSS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_FOOTERS_ALERT_MSG = \"" . EDIT_CSS_LOAD_STICKY_FOOTERS_ALERT_MSG . "\";\n";
echo "var EDIT_CSS_LOAD_STICKY_FOOTERS_COMPLETE_MSG = \"" . EDIT_CSS_LOAD_STICKY_FOOTERS_COMPLETE_MSG . "\";\n";
echo "var EDIT_CSS_BORDER_REQUIREMENTS_MSG = \"" . EDIT_CSS_BORDER_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_BORDER_REQUIREMENTS_STYLE_ADENDUM_MSG = \"" . EDIT_CSS_BORDER_REQUIREMENTS_STYLE_ADENDUM_MSG . "\";\n";
echo "var EDIT_CSS_LETTER_SPACING_REQUIREMENTS_MSG = \"" . EDIT_CSS_LETTER_SPACING_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_LINE_HEIGHT_REQUIREMENTS_MSG = \"" . EDIT_CSS_LINE_HEIGHT_REQUIREMENTS_MSG . "\";\n";
echo "var EDIT_CSS_SORTING_CLASS_LIST_MSG = \"" . EDIT_CSS_SORTING_CLASS_LIST_MSG . "\";\n";
echo "var EDIT_CSS_SORT_COMPLETE = \"" . EDIT_CSS_SORT_COMPLETE . "\";\n";
echo "var EDIT_CSS_SORTING_MSG = \"" . EDIT_CSS_SORTING_MSG . "\";\n";
echo "var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
echo "var QUERY_READY_TO_SEND = \"" . QUERY_READY_TO_SEND . "\";\n";
echo "var QUERY_SENT = \"" . QUERY_SENT . "\";\n";
echo "var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
echo "var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
echo "var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
?>

function PopulateForm(class_select)
{
	var class_index = class_select.selectedIndex;
	var class_name = class_select.options[class_index].value;
	var ajaxRequest;
	ajaxRequest = getXmlHttpRequestObject();

	// Create a function that will receive data sent from the server
	ajaxRequest.onreadystatechange = function(){
		if(ajaxRequest.readyState == 4){
			var row = ajaxRequest.responseText;
//				alert(row);
			if (row == "-no data-")
			{
				document.getElementById("use_table_data").checked = false;
			
				document.getElementById("font").value = "-not selected-";
				document.getElementById("font2").value = "-not selected-";
				document.getElementById("font3").value = "-not selected-";
				document.getElementById("font_size").value = _NOT_SET_;
				document.getElementById("font_size").className = "not_set";
				document.getElementById("font_size_units").value = "px";
				document.getElementById("text_color").value = _NOT_SET_;
				document.getElementById("text_color").className = "not_set";
				document.getElementById("align").value = "-not selected-";
				document.getElementById("vertical_align").value = "-not selected-";
				document.getElementById("display").value = "-not selected-";
				document.getElementById("weight").value = "-not selected-";
				document.getElementById("letter_spacing").value = _NOT_SET_;
				document.getElementById("letter_spacing").className = "not_set";
				document.getElementById("letter_spacing_units").value = -1;
				document.getElementById("italic").checked = false;
				document.getElementById("underline").checked = false;
				document.getElementById("overline").checked = false;
				document.getElementById("blink").checked = false;
				document.getElementById("linethrough").checked = false;
				document.getElementById("oblique").checked = false;
				document.getElementById("small_caps").checked = false;
				document.getElementById("no_text_decoration").checked = false;
				document.getElementById("line_height").value = _NOT_SET_;
				document.getElementById("line_height").className = "not_set";
				document.getElementById("line_height_units").value = -1;
				document.getElementById("text_indent").value = _NOT_SET_;
				document.getElementById("text_indent").className = "not_set";
				document.getElementById("text_indent_units").value = -1;
				
				document.getElementById("shadow").checked = false;
				document.getElementById("shadow_color").value = _NOT_SET_;
				document.getElementById("shadow_color").className = "not_set";
				document.getElementById("shadow_x_offset").value = _NOT_SET_;
				document.getElementById("shadow_x_offset").className = "not_set";
				document.getElementById("shadow_y_offset").value = _NOT_SET_;
				document.getElementById("shadow_y_offset").className = "not_set";
				document.getElementById("shadow_blur").value = _NOT_SET_;
				document.getElementById("shadow_blur").className = "not_set";
		
				document.getElementById("bkgd_color").value = _NOT_SET_;
				document.getElementById("bkgd_color").className = "not_set";
				document.getElementById("bkgd_transparent").checked = false;
				document.getElementById("bkgd_opacity").value = _NOT_SET_;
				document.getElementById("bkgd_opacity").className = "not_set";
				document.getElementById("border").value = _NOT_SET_;
				document.getElementById("border").className = "not_set";
				document.getElementById("border_units").value = 0;
				document.getElementById("border_color").value = _NOT_SET_;
				document.getElementById("border_color").className = "not_set";
				document.getElementById("border_style").value = "-not selected-";
				document.getElementById("outline_style").value = "-not selected-";
				document.getElementById("border_collapse").value = "-not selected-";
				document.getElementById("border_top").value = 1;
				document.getElementById("border_bottom").value = 1;
				document.getElementById("border_left").value = 1;
				document.getElementById("border_right").value = 1;
				document.getElementById("padding_top").value = _NOT_SET_;
				document.getElementById("padding_top").className = "not_set";
				document.getElementById("padding_right").value = _NOT_SET_;
				document.getElementById("padding_right").className = "not_set";
				document.getElementById("padding_bottom").value = _NOT_SET_;
				document.getElementById("padding_bottom").className = "not_set";
				document.getElementById("padding_left").value = _NOT_SET_;
				document.getElementById("padding_left").className = "not_set";
				document.getElementById("padding_top_units").value = 0;
				document.getElementById("padding_right_units").value = 0;
				document.getElementById("padding_bottom_units").value = 0;
				document.getElementById("padding_left_units").value = 0;

				document.getElementById("width").value = _NOT_SET_;
				document.getElementById("width").className = "not_set";
				document.getElementById("width_units").value = 0;
				document.getElementById("width_prefix").value = "-not selected-";
				document.getElementById("height").value = _NOT_SET_;
				document.getElementById("height").className = "not_set";
				document.getElementById("height_units").value = 0;
				document.getElementById("height_prefix").value = "-not selected-";
				document.getElementById("background_image").value = "-not selected-";
				document.getElementById("background_attachment").value = "-not selected-";
				document.getElementById("background_repeat").value = "-not selected-";
				document.getElementById("background_position").value = "-not selected-";
				document.getElementById("background_position_x").value = 0;
				document.getElementById("background_position_y").value = 0;
				document.getElementById("background_position_units").value = 0;
				
				document.getElementById("margin_top").value = _NOT_SET_;
				document.getElementById("margin_top").className = "not_set";
				document.getElementById("margin_right").value = _NOT_SET_;
				document.getElementById("margin_right").className = "not_set";
				document.getElementById("margin_left").value = _NOT_SET_;
				document.getElementById("margin_left").className = "not_set";
				document.getElementById("margin_bottom").value = _NOT_SET_;
				document.getElementById("margin_bottom").className = "not_set";
				document.getElementById("margin_top_auto").checked = false;
				document.getElementById("margin_right_auto").checked = false;
				document.getElementById("margin_left_auto").checked = false;
				document.getElementById("margin_bottom_auto").checked = false;
		
				document.getElementById("position").value = "-not selected-";
				document.getElementById("position_left").value = _NOT_SET_;
				document.getElementById("position_left").className = "not_set";
				document.getElementById("position_left_units").value = 0;
				document.getElementById("position_top").value = _NOT_SET_;
				document.getElementById("position_top").className = "not_set";
				document.getElementById("position_top_units").value = 0;
				document.getElementById("position_right").value = _NOT_SET_;
				document.getElementById("position_right").className = "not_set";
				document.getElementById("position_right_units").value = 0;
				document.getElementById("position_bottom").value = _NOT_SET_;
				document.getElementById("position_bottom").className = "not_set";
				document.getElementById("position_bottom_units").value = 0;
				document.getElementById("z_index").value = _NOT_SET_;
				document.getElementById("z_index").className = "not_set";
				document.getElementById("overflow").value = "-not selected-";
				document.getElementById("overflow_x").value = "-not selected-";
				document.getElementById("overflow_y").value = "-not selected-";
				document.getElementById("clip_top").value = _NOT_SET_;
				document.getElementById("clip_top").className = "not_set";
				document.getElementById("clip_top_units").value = -1;
				document.getElementById("clip_right").value = _NOT_SET_;
				document.getElementById("clip_right").className = "not_set";
				document.getElementById("clip_right_units").value = -1;
				document.getElementById("clip_bottom").value = _NOT_SET_;
				document.getElementById("clip_bottom").className = "not_set";
				document.getElementById("clip_bottom_units").value = -1;
				document.getElementById("clip_left").value = _NOT_SET_;
				document.getElementById("clip_left").className = "not_set";
				document.getElementById("clip_left_units").value = -1;
				document.getElementById("float").value = "-not selected-";
				document.getElementById("white_space").value = "-not selected-";
		
				document.getElementById("list_style_type").value = "-not selected-";
				document.getElementById("list_style_position").value = "-not selected-";
				document.getElementById("list_style_image").value = "-not selected-";
		
				document.getElementById("table_layout").value = "-not selected-";
				document.getElementById("clear").value = "-not selected-";
				
				document.getElementById("radius_top_left").value = _NOT_SET_;
				document.getElementById("radius_top_left").className = "not_set";
				document.getElementById("radius_top_left_units").value = 0;
				document.getElementById("radius_top_right").value = _NOT_SET_;
				document.getElementById("radius_top_right").className = "not_set";
				document.getElementById("radius_top_right_units").value = 0;
				document.getElementById("radius_bottom_right").value = _NOT_SET_;
				document.getElementById("radius_bottom_right").className = "not_set";
				document.getElementById("radius_bottom_right_units").value = 0;
				document.getElementById("radius_bottom_left").value = _NOT_SET_;
				document.getElementById("radius_bottom_left").className = "not_set";
				document.getElementById("radius_bottom_left_units").value = 0;
				
				document.getElementById("box_shadow_horizontal").value = _NOT_SET_;
				document.getElementById("box_shadow_horizontal").className = "not_set";
				document.getElementById("box_shadow_vertical").value = _NOT_SET_;
				document.getElementById("box_shadow_vertical").className = "not_set";
				document.getElementById("box_shadow_blur").value = _NOT_SET_;
				document.getElementById("box_shadow_blur").className = "not_set";
				document.getElementById("box_shadow_spread").value = _NOT_SET_;
				document.getElementById("box_shadow_spread").className = "not_set";
				document.getElementById("box_shadow_color").value = _NOT_SET_;
				document.getElementById("box_shadow_color").className = "not_set";
				document.getElementById("box_shadow_inset").checked = false;
				
				document.getElementById("cursor").value = "-not selected-";
				
				document.getElementById("background_size").value = "-not selected-";
				document.getElementById("background_width").value = _NOT_SET_;
				document.getElementById("background_width").className = "not_set";
				document.getElementById("background_width_units").value = 0;
				document.getElementById("background_height").value = _NOT_SET_;
				document.getElementById("background_height").className = "not_set";
				document.getElementById("background_height_units").value = 0;
				
				document.getElementById("text_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("background_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("border_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("margin_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("position_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("background_img_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("list_table").style.backgroundColor = "#D9D9D9";
				document.getElementById("box_shadow_table").style.backgroundColor = "#D9D9D9";
				
				document.getElementById("visibility").value = "-not selected-";
				
				var html = "<img alt='photo' src='/manage/theme/" + theme + "/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img1' />";
				document.getElementById("preview1").innerHTML = html;
				html = "<img alt='photo' src='/manage/theme/" + theme + "/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img2' />";
				document.getElementById("preview2").innerHTML = html;
			}
			else
			{
				var JSON_row = JSON.parse(row);

				if (JSON_row.use_table_data == 1)
					document.getElementById("use_table_data").checked = true;
				else
					document.getElementById("use_table_data").checked = false;
				document.getElementById("font").value = JSON_row.font;
				document.getElementById("font2").value = JSON_row.font2;
				document.getElementById("font3").value = JSON_row.font3;
				if (JSON_row.font_size == -1)	{
					document.getElementById("font_size").value = _NOT_SET_;
					document.getElementById("font_size").className = "not_set";
				}
				else	{
					document.getElementById("font_size").value = JSON_row.font_size;
					document.getElementById("font_size").className = "";
				}
				document.getElementById("font_size_units").value = JSON_row.font_size_units;
				document.getElementById("text_color").value = JSON_row.text_color;
				if (JSON_row.text_color == _NOT_SET_)
					document.getElementById("text_color").className = "not_set";
				else
					document.getElementById("text_color").className = "";
				document.getElementById("align").value = JSON_row.align;
				document.getElementById("vertical_align").value = JSON_row.vertical_align;
				document.getElementById("display").value = JSON_row.display;
				document.getElementById("weight").value = JSON_row.weight;
				if (JSON_row.letter_spacing == -1000000)	{
					document.getElementById("letter_spacing").value = _NOT_SET_;
					document.getElementById("letter_spacing").className = "not_set";
				}
				else	{
					document.getElementById("letter_spacing").value = JSON_row.letter_spacing;
					document.getElementById("letter_spacing").className = "";
				}
				document.getElementById("letter_spacing_units").value = JSON_row.letter_spacing_units;
				if (JSON_row.italic == 1)
					document.getElementById("italic").checked = true;
				else
					document.getElementById("italic").checked = false;
				if (JSON_row.underline == 1)
					document.getElementById("underline").checked = true;
				else
					document.getElementById("underline").checked = false;
				if (JSON_row.overline == 1)
					document.getElementById("overline").checked = true;
				else
					document.getElementById("overline").checked = false;
				if (JSON_row.blink == 1)
					document.getElementById("blink").checked = true;
				else
					document.getElementById("blink").checked = false;
				if (JSON_row.linethrough == 1)
					document.getElementById("linethrough").checked = true;
				else
					document.getElementById("linethrough").checked = false;
				if (JSON_row.oblique == 1)
					document.getElementById("oblique").checked = true;
				else
					document.getElementById("oblique").checked = false;
				if (JSON_row.small_caps == 1)
					document.getElementById("small_caps").checked = true;
				else
					document.getElementById("small_caps").checked = false;
				if (JSON_row.no_text_decoration == 1)
					document.getElementById("no_text_decoration").checked = true;
				else
					document.getElementById("no_text_decoration").checked = false;
				if (JSON_row.line_height == -1)	{
					document.getElementById("line_height").value = _NOT_SET_;
					document.getElementById("line_height").className = "not_set";
				}
				else	{
					document.getElementById("line_height").value = JSON_row.line_height;
					document.getElementById("line_height").className = "";
				}
				document.getElementById("line_height_units").value = JSON_row.line_height_units;
				if (JSON_row.text_indent == -1000000)	{
					document.getElementById("text_indent").value = _NOT_SET_;
					document.getElementById("text_indent").className = "not_set";
				}
				else	{
					document.getElementById("text_indent").value = JSON_row.text_indent;
					document.getElementById("text_indent").className = "";
				}
				document.getElementById("text_indent_units").value = JSON_row.text_indent_units;
				
				if (JSON_row.shadow == 1)
					document.getElementById("shadow").checked = true;
				else
					document.getElementById("shadow").checked = false;
				document.getElementById("shadow_color").value = JSON_row.shadow_color;
				if (JSON_row.shadow_color == _NOT_SET_)
					document.getElementById("shadow_color").className = "not_set";
				else
					document.getElementById("shadow_color").className = "";
				if (JSON_row.shadow_x_offset == 0)	{
					document.getElementById("shadow_x_offset").className = "not_set";
					document.getElementById("shadow_x_offset").value = _NOT_SET_;
				}
				else	{
					document.getElementById("shadow_x_offset").className = "";
					document.getElementById("shadow_x_offset").value = JSON_row.shadow_x_offset;
				}
				if (JSON_row.shadow_y_offset == 0)	{
					document.getElementById("shadow_y_offset").className = "not_set";
					document.getElementById("shadow_y_offset").value = _NOT_SET_;
				}
				else	{
					document.getElementById("shadow_y_offset").className = "";
					document.getElementById("shadow_y_offset").value = JSON_row.shadow_y_offset;
				}
				if (JSON_row.shadow_blur == 0)	{
					document.getElementById("shadow_blur").className = "not_set";
					document.getElementById("shadow_blur").value = _NOT_SET_;
				}
				else	{
					document.getElementById("shadow_blur").className = "";
					document.getElementById("shadow_blur").value = JSON_row.shadow_blur;
				}
		
				document.getElementById("bkgd_color").value = JSON_row.bkgd_color;
				if (JSON_row.bkgd_color == _NOT_SET_)
					document.getElementById("bkgd_color").className = "not_set";
				else
					document.getElementById("bkgd_color").className = "";
				if (JSON_row.bkgd_transparent == 1)
					document.getElementById("bkgd_transparent").checked = true;
				else
					document.getElementById("bkgd_transparent").checked = false;
				if (JSON_row.bkgd_opacity == -1)	{
					document.getElementById("bkgd_opacity").value = _NOT_SET_;
					document.getElementById("bkgd_opacity").className = "not_set";
				}
				else	{
					document.getElementById("bkgd_opacity").value = JSON_row.bkgd_opacity;
					document.getElementById("bkgd_opacity").className = "";
				}
				if (JSON_row.border == -1)	{
					document.getElementById("border").value = _NOT_SET_;
					document.getElementById("border").className = "not_set";
				}
				else	{
					document.getElementById("border").value = JSON_row.border;
					document.getElementById("border").className = "";
				}
				document.getElementById("border_units").value = JSON_row.border_units;
				document.getElementById("border_color").value = JSON_row.border_color;
				if (JSON_row.border_color == _NOT_SET_)
					document.getElementById("border_color").className = "not_set";
				else
					document.getElementById("border_color").className = "";
				document.getElementById("border_style").value = JSON_row.border_style;
				document.getElementById("outline_style").value = JSON_row.outline_style;
				document.getElementById("border_collapse").value = JSON_row.border_collapse;
				if ((JSON_row.border_sides & 8) == 8)
					document.getElementById("border_top").checked = true;
				else
					document.getElementById("border_top").checked = false;
				if ((JSON_row.border_sides & 4) == 4)
					document.getElementById("border_bottom").checked = true;
				else
					document.getElementById("border_bottom").checked = false;
				if ((JSON_row.border_sides & 2) == 2)
					document.getElementById("border_left").checked = true;
				else
					document.getElementById("border_left").checked = false;
				if ((JSON_row.border_sides & 1) == 1)
					document.getElementById("border_right").checked = true;
				else
					document.getElementById("border_right").checked = false;
				if (JSON_row.padding_top == -1)	{
					document.getElementById("padding_top").value = _NOT_SET_;
					document.getElementById("padding_top").className = "not_set";
				}
				else	{
					document.getElementById("padding_top").value = JSON_row.padding_top;
					document.getElementById("padding_top").className = "";
				}
				if (JSON_row.padding_right == -1)	{
					document.getElementById("padding_right").value = _NOT_SET_;
					document.getElementById("padding_right").className = "not_set";
				}
				else	{
					document.getElementById("padding_right").value = JSON_row.padding_right;
					document.getElementById("padding_right").className = "";
				}
				if (JSON_row.padding_bottom == -1)	{
					document.getElementById("padding_bottom").value = _NOT_SET_;
					document.getElementById("padding_bottom").className = "not_set";
				}
				else	{
					document.getElementById("padding_bottom").value = JSON_row.padding_bottom;
					document.getElementById("padding_bottom").className = "";
				}
				if (JSON_row.padding_left == -1)	{
					document.getElementById("padding_left").value = _NOT_SET_;
					document.getElementById("padding_left").className = "not_set";
				}
				else	{
					document.getElementById("padding_left").value = JSON_row.padding_left;
					document.getElementById("padding_left").className = "";
				}
				document.getElementById("padding_top_units").value = JSON_row.padding_top_units;
				document.getElementById("padding_right_units").value = JSON_row.padding_right_units;
				document.getElementById("padding_bottom_units").value = JSON_row.padding_bottom_units;
				document.getElementById("padding_left_units").value = JSON_row.padding_left_units;

				if (JSON_row.width == -1)	{
					document.getElementById("width").value = _NOT_SET_;
					document.getElementById("width").className = "not_set";
				}
				else	{
					document.getElementById("width").value = JSON_row.width;
					document.getElementById("width").className = "";
				}
				document.getElementById("width_units").value = JSON_row.width_units;
				document.getElementById("width_prefix").value = JSON_row.width_prefix;
				if (JSON_row.height == -1)	{
					document.getElementById("height").value = _NOT_SET_;
					document.getElementById("height").className = "not_set";
				}
				else	{
					document.getElementById("height").value = JSON_row.height;
					document.getElementById("height").className = "";
				}
				document.getElementById("height_units").value = JSON_row.height_units;
				document.getElementById("height_prefix").value = JSON_row.height_prefix;
				document.getElementById("background_image").value = JSON_row.background_image;
				document.getElementById("background_attachment").value = JSON_row.background_attachment;
				document.getElementById("background_repeat").value = JSON_row.background_repeat;
				document.getElementById("background_position").value = JSON_row.background_position;
				if (JSON_row.background_position_x == 0)	{
					document.getElementById("background_position_x").value = _NOT_SET_;
					document.getElementById("background_position_x").className = "not_set";
				}
				else	{
					document.getElementById("background_position_x").value = JSON_row.background_position_x;
					document.getElementById("background_position_x").className = "";
				}
				if (JSON_row.background_position_y == 0)	{
					document.getElementById("background_position_y").value = _NOT_SET_;
					document.getElementById("background_position_y").className = "not_set";
				}
				else	{
					document.getElementById("background_position_y").value = JSON_row.background_position_y;
					document.getElementById("background_position_y").className = "";
				}
				document.getElementById("background_position_units").value = JSON_row.background_position_units;
		
				if (JSON_row.margin_top == -1000000)	{
					document.getElementById("margin_top").value = _NOT_SET_;
					document.getElementById("margin_top").className = "not_set";
				}
				else	{
					document.getElementById("margin_top").value = JSON_row.margin_top;
					document.getElementById("margin_top").className = "";
				}
				if (JSON_row.margin_right == -1000000)	{
					document.getElementById("margin_right").value = _NOT_SET_;
					document.getElementById("margin_right").className = "not_set";
				}
				else	{
					document.getElementById("margin_right").value = JSON_row.margin_right;
					document.getElementById("margin_right").className = "";
				}
				if (JSON_row.margin_left == -1000000)	{
					document.getElementById("margin_left").value = _NOT_SET_;
					document.getElementById("margin_left").className = "not_set";
				}
				else	{
					document.getElementById("margin_left").value = JSON_row.margin_left;
					document.getElementById("margin_left").className = "";
				}
				if (JSON_row.margin_bottom == -1000000)	{
					document.getElementById("margin_bottom").value = _NOT_SET_;
					document.getElementById("margin_bottom").className = "not_set";
				}
				else	{
					document.getElementById("margin_bottom").value = JSON_row.margin_bottom;
					document.getElementById("margin_bottom").className = "";
				}
				if (JSON_row.margin_top_auto == 1)
					document.getElementById("margin_top_auto").checked = true;
				else
					document.getElementById("margin_top_auto").checked = false;
				if (JSON_row.margin_right_auto == 1)
					document.getElementById("margin_right_auto").checked = true;
				else
					document.getElementById("margin_right_auto").checked = false;
				if (JSON_row.margin_left_auto == 1)
					document.getElementById("margin_left_auto").checked = true;
				else
					document.getElementById("margin_left_auto").checked = false;
				if (JSON_row.margin_bottom_auto == 1)
					document.getElementById("margin_bottom_auto").checked = true;
				else
					document.getElementById("margin_bottom_auto").checked = false;
		
				document.getElementById("position").value = JSON_row.position;
				if (JSON_row.position_left == -1000000)	{
					document.getElementById("position_left").value = _NOT_SET_;
					document.getElementById("position_left").className = "not_set";
				}
				else	{
					document.getElementById("position_left").value = JSON_row.position_left;
					document.getElementById("position_left").className = "";
				}
				document.getElementById("position_left_units").value = JSON_row.position_left_units;
				if (JSON_row.position_top == -1000000)	{
					document.getElementById("position_top").value = _NOT_SET_;
					document.getElementById("position_top").className = "not_set";
				}
				else	{
					document.getElementById("position_top").value = JSON_row.position_top;
					document.getElementById("position_top").className = "";
				}
				document.getElementById("position_top_units").value = JSON_row.position_top_units;
				if (JSON_row.position_right == -1000000)	{
					document.getElementById("position_right").value = _NOT_SET_;
					document.getElementById("position_right").className = "not_set";
				}
				else	{
					document.getElementById("position_right").value = JSON_row.position_right;
					document.getElementById("position_right").className = "";
				}
				document.getElementById("position_right_units").value = JSON_row.position_right_units;
				if (JSON_row.position_bottom == -1000000)	{
					document.getElementById("position_bottom").value = _NOT_SET_;
					document.getElementById("position_bottom").className = "not_set";
				}
				else	{
					document.getElementById("position_bottom").value = JSON_row.position_bottom;
					document.getElementById("position_bottom").className = "";
				}
				document.getElementById("position_bottom_units").value = JSON_row.position_bottom_units;
				if (JSON_row.z_index == -1000000)	{
					document.getElementById("z_index").value = _NOT_SET_;
					document.getElementById("z_index").className = "not_set";
				}
				else	{
					document.getElementById("z_index").value = JSON_row.z_index;
					document.getElementById("z_index").className = "";
				}
				document.getElementById("overflow").value = JSON_row.overflow;
				document.getElementById("overflow_x").value = JSON_row.overflow_x;
				document.getElementById("overflow_y").value = JSON_row.overflow_y;
				if (JSON_row.clip_top == -1)	{
					document.getElementById("clip_top").value = _NOT_SET_;
					document.getElementById("clip_top").className = "not_set";
				}
				else	{
					document.getElementById("clip_top").value = JSON_row.clip_top;
					document.getElementById("clip_top").className = "";
				}
				document.getElementById("clip_top_units").value = JSON_row.clip_top_units;
				if (JSON_row.clip_right == -1)	{
					document.getElementById("clip_right").value = _NOT_SET_;
					document.getElementById("clip_right").className = "not_set";
				}
				else	{
					document.getElementById("clip_right").value = JSON_row.clip_right;
					document.getElementById("clip_right").className = "";
				}
				document.getElementById("clip_right_units").value = JSON_row.clip_right_units;
				if (JSON_row.clip_bottom == -1)	{
					document.getElementById("clip_bottom").value = _NOT_SET_;
					document.getElementById("clip_bottom").className = "not_set";
				}
				else	{
					document.getElementById("clip_bottom").value = JSON_row.clip_bottom;
					document.getElementById("clip_bottom").className = "";
				}
				document.getElementById("clip_bottom_units").value = JSON_row.clip_bottom_units;
				if (JSON_row.clip_left == -1)	{
					document.getElementById("clip_left").value = _NOT_SET_;
					document.getElementById("clip_left").className = "not_set";
				}
				else	{
					document.getElementById("clip_left").value = JSON_row.clip_left;
					document.getElementById("clip_left").className = "";
				}
				document.getElementById("clip_left_units").value = JSON_row.clip_left_units;
				document.getElementById("float").value = JSON_row.float;
				document.getElementById("white_space").value = JSON_row.white_space;
		
				document.getElementById("list_style_type").value = JSON_row.list_style_type;
				document.getElementById("list_style_position").value = JSON_row.list_style_position;
				document.getElementById("list_style_image").value = JSON_row.list_style_image;
		
				document.getElementById("table_layout").value = JSON_row.table_layout;
				document.getElementById("clear").value = JSON_row.clear;
				
				if (JSON_row.radius_top_left == 0)	{
					document.getElementById("radius_top_left").value = _NOT_SET_;			
					document.getElementById("radius_top_left").className = "not_set";
				}
				else	{
					document.getElementById("radius_top_left").value = JSON_row.radius_top_left;			
					document.getElementById("radius_top_left").className = "";
				}
				document.getElementById("radius_top_left_units").value = JSON_row.radius_top_left_units;
				if (JSON_row.radius_top_right == 0)	{
					document.getElementById("radius_top_right").value = _NOT_SET_;			
					document.getElementById("radius_top_right").className = "not_set";
				}
				else	{
					document.getElementById("radius_top_right").value = JSON_row.radius_top_right;			
					document.getElementById("radius_top_right").className = "";
				}
				document.getElementById("radius_top_right_units").value = JSON_row.radius_top_right_units;
				if (JSON_row.radius_bottom_right == 0)	{
					document.getElementById("radius_bottom_right").value = _NOT_SET_;			
					document.getElementById("radius_bottom_right").className = "not_set";
				}
				else	{
					document.getElementById("radius_bottom_right").value = JSON_row.radius_bottom_right;			
					document.getElementById("radius_bottom_right").className = "";
				}
				document.getElementById("radius_bottom_right_units").value = JSON_row.radius_bottom_right_units;
				if (JSON_row.radius_bottom_left == 0)	{
					document.getElementById("radius_bottom_left").value = _NOT_SET_;			
					document.getElementById("radius_bottom_left").className = "not_set";
				}
				else	{
					document.getElementById("radius_bottom_left").value = JSON_row.radius_bottom_left;			
					document.getElementById("radius_bottom_left").className = "";
				}
				document.getElementById("radius_bottom_left_units").value = JSON_row.radius_bottom_left_units;
				
				if (JSON_row.box_shadow_horizontal == -1000000)	{
					document.getElementById("box_shadow_horizontal").value = _NOT_SET_;
					document.getElementById("box_shadow_horizontal").className = "not_set";
				}
				else	{
					document.getElementById("box_shadow_horizontal").value = JSON_row.box_shadow_horizontal;
					document.getElementById("box_shadow_horizontal").className = "";
				}
				if (JSON_row.box_shadow_vertical == -1000000)	{
					document.getElementById("box_shadow_vertical").value = _NOT_SET_;
					document.getElementById("box_shadow_vertical").className = "not_set";
				}
				else	{
					document.getElementById("box_shadow_vertical").value = JSON_row.box_shadow_vertical;
					document.getElementById("box_shadow_vertical").className = "";
				}
				if (JSON_row.box_shadow_blur == -1)	{
					document.getElementById("box_shadow_blur").value = _NOT_SET_;
					document.getElementById("box_shadow_blur").className = "not_set";
				}
				else	{
					document.getElementById("box_shadow_blur").value = JSON_row.box_shadow_blur;
					document.getElementById("box_shadow_blur").className = "";
				}
				if (JSON_row.box_shadow_spread == -1000000)	{
					document.getElementById("box_shadow_spread").value = _NOT_SET_;
					document.getElementById("box_shadow_spread").className = "not_set";
				}
				else	{
					document.getElementById("box_shadow_spread").value = JSON_row.box_shadow_spread;
					document.getElementById("box_shadow_spread").className = "";
				}
				document.getElementById("box_shadow_color").value = JSON_row.box_shadow_color;
				if (JSON_row.box_shadow_color == _NOT_SET_)
					document.getElementById("box_shadow_color").className = "not_set";
				else
					document.getElementById("box_shadow_color").className = "";
				if (JSON_row.box_shadow_inset == 1)
					document.getElementById("box_shadow_inset").checked = true;
				else
					document.getElementById("box_shadow_inset").checked = false;
				
				document.getElementById("cursor").value = JSON_row.cursor;
				
				document.getElementById("background_size").value = JSON_row.background_size;
				if (JSON_row.background_width == -1)	{
					document.getElementById("background_width").value = _NOT_SET_;
					document.getElementById("background_width").className = "not_set";
				}
				else	{
					document.getElementById("background_width").value = JSON_row.background_width;
					document.getElementById("background_width").className = "";
				}
				document.getElementById("background_width_units").value = JSON_row.background_width_units;
				if (JSON_row.background_height == -1)	{
					document.getElementById("background_height").value = _NOT_SET_;
					document.getElementById("background_height").className = "not_set";
				}
				else	{
					document.getElementById("background_height").value = JSON_row.background_height;
					document.getElementById("background_height").className = "";
				}
				document.getElementById("background_height_units").value = JSON_row.background_height_units;
				
				document.getElementById("visibility").value = JSON_row.visibility;
				
				document.getElementById("text_table").style.backgroundColor = "#FFCCCC";
				document.getElementById("background_table").style.backgroundColor = "#CCFFCC";
				document.getElementById("border_table").style.backgroundColor = "#CCCCFF";
				document.getElementById("margin_table").style.backgroundColor = "#FFFFAA";
				document.getElementById("position_table").style.backgroundColor = "#FFAAFF";
				document.getElementById("background_img_table").style.backgroundColor = "#AAFFFF";
				document.getElementById("list_table").style.backgroundColor = "#FFBB99";
				document.getElementById("box_shadow_table").style.backgroundColor = "#99BBFF";
				
				UpdateImage(1);
				UpdateImage(2);
			}
			var heading_str = document.getElementById("goto_class").value;
			heading_str = heading_str.replace(/PERIOD/g, ".");
			heading_str = heading_str.replace(/POUND/g, "#");
			heading_str = heading_str.replace(/SPACE/g, " ");
			heading_str = heading_str.replace(/COMMA/g, ",");
			heading_str = heading_str.replace(/GREATERTHAN/g, "&gt;");
			heading_str = heading_str.replace(/PLUS/g, "+");
			heading_str = heading_str.replace(/TILDA/g, "~");
			document.getElementById("class_heading").innerHTML = heading_str;
				
			enable_disable_controls(0);
		}
	}
	
	var queryString = "?class_table=" + "<?php echo $class_table; ?>" + "&css_table=" + "<?php echo $css_table; ?>" + "&class=" + class_name;
//		alert (queryString);
	ajaxRequest.open("GET", "populate_css_edit_form.php" + queryString, true);
	ajaxRequest.send(null);
	
	document.getElementById("goto_class").value = class_name;
}

////////////////////////////////////////////////////////////////////////////////////

function UpdateCSS(submit_action, show_preview)
{
	var params = "";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = "Starting update...";
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
		
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","save_css.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, show_preview);
		params = "submit_action=" + submit_action;
		params = params + "&style_sheet=<? echo $style_sheet; ?>";
		params = params + "&class=" + document.getElementById("goto_class").value;
		if (document.getElementById("use_table_data").checked == true) params = params + "&use_table_data=1";
		else params = params + "&use_table_data=0";
		params = params + "&font=" + document.getElementById("font").value;
		params = params + "&font2=" + document.getElementById("font2").value;
		params = params + "&font3=" + document.getElementById("font3").value;
		params = params + "&font_size=" + document.getElementById("font_size").value;
		params = params + "&font_size_units=" + document.getElementById("font_size_units").value;
		params = params + "&text_color=" + document.getElementById("text_color").value;
		params = params + "&align=" + document.getElementById("align").value;
		params = params + "&vertical_align=" + document.getElementById("vertical_align").value;
		params = params + "&display=" + document.getElementById("display").value;
		params = params + "&weight=" + document.getElementById("weight").value;
		params = params + "&letter_spacing=" + document.getElementById("letter_spacing").value;
		params = params + "&letter_spacing_units=" + document.getElementById("letter_spacing_units").value;
		if (document.getElementById("italic").checked == true) params = params + "&italic=1";
		else params = params + "&italic=0";
		if (document.getElementById("underline").checked == true) params = params + "&underline=1";
		else params = params + "&underline=0";
		if (document.getElementById("overline").checked == true)	params = params + "&overline=1";
		else params = params + "&overline=0";
		if (document.getElementById("blink").checked == true) params = params + "&blink=1";
		else params = params + "&blink=0";
		if (document.getElementById("linethrough").checked == true) params = params + "&linethrough=1";
		else params = params + "&linethrough=0";
		if (document.getElementById("oblique").checked == true) params = params + "&oblique=1";
		else params = params + "&oblique=0";
		if (document.getElementById("small_caps").checked == true) params = params + "&small_caps=1";
		else params = params + "&small_caps=0";
		if (document.getElementById("no_text_decoration").checked == true) params = params + "&no_text_decoration=1";
		else params = params + "&no_text_decoration=0";
		params = params + "&line_height=" + document.getElementById("line_height").value;
		params = params + "&line_height_units=" + document.getElementById("line_height_units").value;
		params = params + "&text_indent=" + document.getElementById("text_indent").value;
		params = params + "&text_indent_units=" + document.getElementById("text_indent_units").value;
		
		if (document.getElementById("shadow").checked == true) params = params + "&shadow=1";
		else params = params + "&shadow=0";
		params = params + "&shadow_color=" + document.getElementById("shadow_color").value;
		params = params + "&shadow_x_offset=" + document.getElementById("shadow_x_offset").value;
		params = params + "&shadow_y_offset=" + document.getElementById("shadow_y_offset").value;
		params = params + "&shadow_blur=" + document.getElementById("shadow_blur").value;
		
		params = params + "&bkgd_color=" + document.getElementById("bkgd_color").value;
		if (document.getElementById("bkgd_transparent").checked == true) params = params + "&bkgd_transparent=1";
		else params = params + "&bkgd_transparent=0";
		params = params + "&bkgd_opacity=" + document.getElementById("bkgd_opacity").value;
		params = params + "&border=" + document.getElementById("border").value;
		params = params + "&border_units=" + document.getElementById("border_units").value;
		params = params + "&border_color=" + document.getElementById("border_color").value;
		params = params + "&border_style=" + document.getElementById("border_style").value;
		params = params + "&outline_style=" + document.getElementById("outline_style").value;
		params = params + "&border_collapse=" + document.getElementById("border_collapse").value;
		if (document.getElementById("border_top").checked == true) var border_top = 8;
		else var border_top = 0;
		if (document.getElementById("border_bottom").checked == true) var border_bottom = 4;
		else var border_bottom = 0;
		if (document.getElementById("border_left").checked == true) var border_left = 2;
		else var border_left = 0;
		if (document.getElementById("border_right").checked == true) var border_right = 1;
		else var border_right = 0;
		var border_sides = border_top | border_bottom | border_left | border_right;
		params = params + "&border_sides=" + border_sides;
		params = params + "&padding_top=" + document.getElementById("padding_top").value;
		params = params + "&padding_right=" + document.getElementById("padding_right").value;
		params = params + "&padding_bottom=" + document.getElementById("padding_bottom").value;
		params = params + "&padding_left=" + document.getElementById("padding_left").value;
		params = params + "&padding_top_units=" + document.getElementById("padding_top_units").value;
		params = params + "&padding_right_units=" + document.getElementById("padding_right_units").value;
		params = params + "&padding_bottom_units=" + document.getElementById("padding_bottom_units").value;
		params = params + "&padding_left_units=" + document.getElementById("padding_left_units").value;
		
		params = params + "&margin_top=" + document.getElementById("margin_top").value;
		params = params + "&margin_right=" + document.getElementById("margin_right").value;
		params = params + "&margin_left=" + document.getElementById("margin_left").value;
		params = params + "&margin_bottom=" + document.getElementById("margin_bottom").value;
		params = params + "&margin_top_units=" + document.getElementById("margin_top_units").value;
		if (document.getElementById("margin_top_auto").checked == true) params = params + "&margin_top_auto=1";
		else params = params + "&margin_top_auto=0";
		params = params + "&margin_right_units=" + document.getElementById("margin_right_units").value;
		if (document.getElementById("margin_right_auto").checked == true) params = params + "&margin_right_auto=1";
		else params = params + "&margin_right_auto=0";
		params = params + "&margin_left_units=" + document.getElementById("margin_left_units").value;
		if (document.getElementById("margin_left_auto").checked == true) params = params + "&margin_left_auto=1";
		else params = params + "&margin_left_auto=0";
		params = params + "&margin_bottom_units=" + document.getElementById("margin_bottom_units").value;
		if (document.getElementById("margin_bottom_auto").checked == true) params = params + "&margin_bottom_auto=1";
		else params = params + "&margin_bottom_auto=0";
		params = params + "&width=" + document.getElementById("width").value;
		params = params + "&width_units=" + document.getElementById("width_units").value;
		params = params + "&width_prefix=" + document.getElementById("width_prefix").value;
		params = params + "&height=" + document.getElementById("height").value;
		params = params + "&height_units=" + document.getElementById("height_units").value;
		params = params + "&height_prefix=" + document.getElementById("height_prefix").value;
		
		params = params + "&position=" + document.getElementById("position").value;
		params = params + "&position_left=" + document.getElementById("position_left").value;
		params = params + "&position_left_units=" + document.getElementById("position_left_units").value;
		params = params + "&position_top=" + document.getElementById("position_top").value;
		params = params + "&position_top_units=" + document.getElementById("position_top_units").value;
		params = params + "&position_right=" + document.getElementById("position_right" ).value;
		params = params + "&position_right_units=" + document.getElementById("position_right_units").value;
		params = params + "&position_bottom=" + document.getElementById("position_bottom").value;
		params = params + "&position_bottom_units=" + document.getElementById("position_bottom_units").value;
		params = params + "&z_index=" + document.getElementById("z_index").value;
		params = params + "&overflow=" + document.getElementById("overflow").value;
		params = params + "&overflow_x=" + document.getElementById("overflow_x").value;
		params = params + "&overflow_y=" + document.getElementById("overflow_y").value;
		params = params + "&clip_top=" + document.getElementById("clip_top").value;
		params = params + "&clip_top_units=" + document.getElementById("clip_top_units").value;
		params = params + "&clip_right=" + document.getElementById("clip_right").value;
		params = params + "&clip_right_units=" + document.getElementById("clip_right_units").value;
		params = params + "&clip_bottom=" + document.getElementById("clip_bottom").value;
		params = params + "&clip_bottom_units=" + document.getElementById("clip_bottom_units").value;
		params = params + "&clip_left=" + document.getElementById("clip_left").value;
		params = params + "&clip_left_units=" + document.getElementById("clip_left_units").value;
		params = params + "&float=" + document.getElementById("float").value;
		params = params + "&white_space=" + document.getElementById("white_space").value;

		params = params + "&background_image=" + document.getElementById("background_image").value;
		params = params + "&background_attachment=" + document.getElementById("background_attachment").value;
		params = params + "&background_repeat=" + document.getElementById("background_repeat").value;
		params = params + "&background_position=" + document.getElementById("background_position").value;
		params = params + "&background_position_x=" + document.getElementById("background_position_x").value;
		params = params + "&background_position_y=" + document.getElementById("background_position_y").value;
		params = params + "&background_position_units=" + document.getElementById("background_position_units").value;
		
		params = params + "&list_style_type=" + document.getElementById("list_style_type").value;
		params = params + "&list_style_position=" + document.getElementById("list_style_position").value;
		params = params + "&list_style_image=" + document.getElementById("list_style_image").value;
		
		params = params + "&table_layout=" + document.getElementById("table_layout").value;
		params = params + "&clear=" + document.getElementById("clear").value;
		
		params = params + "&radius_top_left=" + document.getElementById("radius_top_left").value;
		params = params + "&radius_top_left_units=" + document.getElementById("radius_top_left_units").value;
		params = params + "&radius_top_right=" + document.getElementById("radius_top_right").value;
		params = params + "&radius_top_right_units=" + document.getElementById("radius_top_right_units").value;
		params = params + "&radius_bottom_right=" + document.getElementById("radius_bottom_right").value;
		params = params + "&radius_bottom_right_units=" + document.getElementById("radius_bottom_right_units").value;
		params = params + "&radius_bottom_left=" + document.getElementById("radius_bottom_left").value;
		params = params + "&radius_bottom_left_units=" + document.getElementById("radius_bottom_left_units").value;
		
		params = params + "&box_shadow_horizontal=" + document.getElementById("box_shadow_horizontal").value;
		params = params + "&box_shadow_vertical=" + document.getElementById("box_shadow_vertical").value;
		params = params + "&box_shadow_blur=" + document.getElementById("box_shadow_blur").value;
		params = params + "&box_shadow_spread=" + document.getElementById("box_shadow_spread").value;
		params = params + "&box_shadow_color=" + document.getElementById("box_shadow_color").value;
		if (document.getElementById("box_shadow_inset").checked == true) params = params + "&box_shadow_inset=1";
		else params = params + "&box_shadow_inset=0";
		
		params = params + "&cursor=" + document.getElementById("cursor").value;
		
		params = params + "&background_size=" + document.getElementById("background_size").value;
		params = params + "&background_width=" + document.getElementById("background_width").value;
		params = params + "&background_width_units=" + document.getElementById("background_width_units").value;
		params = params + "&background_height=" + document.getElementById("background_height").value;
		params = params + "&background_height_units=" + document.getElementById("background_height_units").value;
		
		params = params + "&visibility=" + document.getElementById("visibility").value;
		
//			alert(params);
		
		xmlhttp.send(params);
	}
}
</script>

</head>

<body id="workspace_body">
<div align="center" id="css_editor_div">
<table border="0" width="95%">
 <tr>
  <td align="left">
    <div class="button_heading_sub_level_1" id="edit_styles_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
    
    <a name="top_anchor"></a>
  </td>
  <td align="right">
  	<?php echo EDIT_CSS_CHANGE_STYLE_SHEET; ?>: 
  </td>
  <td align="left">
  	<form name="frmChangeStyleSheet" id="frmChangeStyleSheet" action="edit_css.php" method="post" enctype="multipart/form-data">
  	<select name="style_sheet" id="style_sheet" onChange="document.getElementById('frmChangeStyleSheet').submit();">
<?php
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "style_sheets`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$tmp_style_sheet = $row['name'];
		$tmp_description = $row['description'];
		if ($tmp_style_sheet == $style_sheet)
			echo "		<option value='$tmp_style_sheet' selected>$tmp_description</option>\n";
		else
			echo "		<option value='$tmp_style_sheet'>$tmp_description</option>\n";
	}
?>
    </select>
    </form>
  </td>
  <td align="right">
    <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADD_DELETE_CUSTOM_STYLE_BTN; ?></span></div>
  </td>
 </tr>
</table>

<table width="95%" border="1" cellspacing="0" cellpadding="0">
  <tr>
    <td>
   <form action="save_css.php" method="post" enctype="multipart/form-data" name="frm_site_styles" id="frm_site_styles">
     <table width="100%" border="1"><tr><td>
	  <table width="100%" border="0" cellspacing="1" cellpadding="1">
	  	<tr>
		  <td>
		    <table width="100%" border="0">
			  <tr>
		        <td><h3 id="class_heading">&nbsp;</h3></td>
		        <td><?php echo EDIT_CSS_USE_SETTINGS_BELOW; ?>: <input type="checkbox" name="use_table_data" id="use_table_data" value="1" onClick="enable_disable_controls(1);"></td>
                <td>
                <?php echo EDIT_CSS_GO_TO; ?>:
                <div id="goto_class_div" style="display:inline;">
                  <select name="goto_class" id="goto_class" onChange="PopulateForm(this);">
                    <option value=''><?php echo _NOT_SELECTED_; ?></option>
                    <?php
				$search = array("PERIOD", "POUND", "SPACE", "COMMA", "GREATERTHAN", "GREATERTHAN", "PLUS", "TILDA");
				$replace = array(".", "#", " ", ",", ">", "&gt;", "+", "~");
				$goto_class_cmp = str_replace($search, $replace, $goto_class);
				if ($class_sort_method == 1)
					$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `class`";
				else
					$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . $class_table . "` ORDER BY `sort_order`";
				$result = $bwb_dbh->query($query);
				while ($row = $result->fetch(PDO::FETCH_ASSOC))
				{
					$tmp_class = $row['class'];
					$tmp_desc = $row['description'];
					$tmp_class_val = str_replace($replace, $search, $tmp_class);
					if ($tmp_class == $goto_class_cmp)
						echo "<option value='$tmp_class_val' selected='selected'>$tmp_class ----- $tmp_desc</option>\n";
					else
						echo "<option value='$tmp_class_val'>$tmp_class ----- $tmp_desc</option>\n";
				}
		?>
                  </select>
                  </div>
                  
                  <span class="small_message"><?php echo EDIT_CSS_SORT_ALPHABETICALLY; ?></span> <input type="checkbox" id="sort_alpha" name="sort_alpha" <?php if ($class_sort_method == 1) echo "checked='checked'"; ?> onClick="ChangeSort(this.checked);" />
                  </td>
                  <td align="right">
                  <div class='button_console_save' style="width:110px;" onClick="UpdateCSS('Update', false);"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
                  </td>
		      </tr>
			</table>
		  </td>
	    </tr>
	    <tr>
		  <td>
		  
		    <table border="1" width="100%" id="text_table">
		      <tr>
			    <td>
				  <table border="0" width="100%">
				    <tr>
					  <td colspan="8" class="bold"><?php echo TEXT_WORD; ?></td>
				    </tr>
				    <tr>
					  <td align="right"><?php echo FONT_WORD; ?>: </td>
					  <td colspan="5">
					      <select name="font" id="font">
                          	<option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <?php
						  $fonts = array();
						  $query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						  $result = $bwb_dbh->query($query);
						  while ($row = $result->fetch(PDO::FETCH_ASSOC))
							$fonts[$row['font']] = $row['websafe'];
						  
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
                          
                           <select name="font2" id="font2">
                           	<option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
                          
                           <select name="font3" id="font3">
                           	<option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <?php							
						  foreach ($fonts as $tmp_font => $tmp_websafe)
						  {
							echo "<option value='$tmp_font'";
							echo " style='font-family:$tmp_font;'>$tmp_font";
							if ($tmp_websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						  }
					      ?>
					      </select>
                          <div class='button_console_add_sm' style="width:100px; float:right;" onClick="window.location='manage_custom_fonts.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_sm_icon'><?php echo MANAGE_CUSTOM_FONTS_ADD_FONT; ?></span></div>
					  </td>
					  <td align="right"><?php echo FONT_SIZE; ?>: </td>
					  <td>
                      	<input name="font_size" type="text" id="font_size" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                      	<select name="font_size_units" id="font_size_units" onChange="enable_disable_font_size();">
						    <option value="px">px</option>
						    <option value="em">em</option>
                            <option value="pt">pt</option>
                            <option value="pc">pc</option>
                            <option value="cm">cm</option>
                            <option value="mm">mm</option>
                            <option value="in">in</option>
                            <option value="%">%</option>
                            <option value="rem">rem</option>
                            <option value="vw">vw</option>
                            <option value="vh">vh</option>
                            <option value="vmin">vmin</option>
                            <option value="vmax">vmax</option>
                            <option value="ch">ch</option>
                            <option value="xx-small"><?php echo XX_SMALL_WORD; ?></option>
                            <option value="x-small"><?php echo X_SMALL_WORD; ?></option>
                            <option value="small"><?php echo SMALL_WORD; ?></option>
                            <option value="medium"><?php echo MEDIUM_WORD; ?></option>
                            <option value="large"><?php echo LARGE_WORD; ?></option>
                            <option value="x-large"><?php echo X_LARGE_WORD; ?></option>
                            <option value="xx-large"><?php echo XX_LARGE_WORD; ?></option>
                            <option value="smaller"><?php echo SMALLER_WORD; ?></option>
                            <option value="larger"><?php echo LARGER_WORD; ?></option>
                            <option value="initial"><?php echo INITIAL_LC_WORD; ?></option>
                            <option value="inherit"><?php echo INHERIT_LC_WORD; ?></option>
						</select> 
                      </td>					
					  <td align="right"><?php echo COLOR_WORD; ?>: </td>
					  <td>
					      <input name="text_color" type="text" id="text_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> 
					      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'text_color');"><?php echo RGB_WORD; ?></a></span>
					  </td>
				    </tr>
				    <tr>
					  <td align="right">&nbsp;</td>
					  <td class="small_message" valign="top">&radic; = <?php echo WEBSAFE_WORD; ?></td>
					  <td align="right"><?php echo ALIGN_WORD; ?>: </td>
					  <td>
					      <font size="1">
					      <select name="align" id="align">
						  <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                          <option value="left"><?php echo LEFT_1ST_CAP_WORD; ?></option>
                          <option value="center"><?php echo CENTER_WORD; ?></option>
                          <option value="right"><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                          <option value="justify"><?php echo JUSTIFY_WORD; ?></option>
                          </select>
					      </font>
					  </td>
					  <td align="right"><?php echo VERTICAL_ALIGN; ?>: </td>
					  <td>
					      <select name="vertical_align" id="vertical_align">
						  <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <option value="baseline"><?php echo BASELINE_WORD; ?></option>
					      <option value="sub"><?php echo SUB_WORD; ?></option>
					      <option value="super"><?php echo SUPER_WORD; ?></option>
					      <option value="top"><?php echo TOP_1ST_CAP_WORD; ?></option>
					      <option value="text-top"><?php echo TEXT_TOP; ?></option>
					      <option value="middle"><?php echo MIDDLE_WORD; ?></option>
					      <option value="bottom"><?php echo BOTTOM_1ST_CAP_WORD; ?></option>
					      <option value="text-bottom"><?php echo TEXT_BOTTOM; ?></option>              
					      </select>
				      </td>
                      <td align="right"><?php echo INDENT_WORD; ?>: </td>
                      <td>
                      	<input name="text_indent" type="text" id="text_indent" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="text_indent_units" id="text_indent_units" onChange="CheckFormatOnUnitSelect(this.id, 'text_indent');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                      </td>
					  <td align="right"><?php echo EDIT_CSS_WHITE_SPACE; ?>: </td>
					  <td>
                      	<select name="white_space" id="white_space">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value='normal'><?php echo NORMAL_WORD; ?></option>
                         <option value='nowrap'><?php echo NO_WRAP_WORD; ?></option>
                         <option value='pre'><?php echo PRE_WORD; ?></option>
                         <option value='pre-line'><?php echo PRE_LINE_WORD; ?></option>
                         <option value='pre-wrap'><?php echo PRE_WRAP_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value='inherit'><?php echo INHERIT_WORD; ?></option>
					     </select>
                      </td>
				    </tr>
					<tr>
					  <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
					  <td>
					      <select name="weight" id="weight">
					   <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					   <option value="normal"><?php echo NORMAL_WORD; ?></option>
					   <option value="bold"><?php echo BOLD_WORD; ?></option>
					   <option value="bolder"><?php echo BOLDER_WORD; ?></option>
					   <option value="lighter"><?php echo LIGHTER_WORD; ?></option>
					   <option value="100">100</option>
					   <option value="200">200</option>
					   <option value="300">300</option>
					   <option value="400">400</option>
					   <option value="500">500</option>
					   <option value="600">600</option>
					   <option value="700">700</option>
					   <option value="800">800</option>
					   <option value="900">900</option>
					   </select>
					  </td>
					  <td align="right"><?php echo LETTER_SPACING; ?>:</td>
					  <td colspan="2">
                       <input name="letter_spacing" type="text" id="letter_spacing" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
					   <select name="letter_spacing_units" id="letter_spacing_units" onChange="CheckLetterSpacing(this);">
					    <option value="-1"><?php echo _NOT_SELECTED_; ?></option>
					    <option value="0"><?php echo NORMAL_WORD; ?></option>
					    <option value="1">px</option>
                        <option value="2">%</option>
                        <option value="3">em</option>
                        <option value="4">pt</option>
                        <option value="5">pc</option>
                        <option value="6">cm</option>
                        <option value="7">mm</option>
                        <option value="8">in</option>
                        <option value="9">rem</option>
                        <option value="10">vw</option>
                        <option value="11">vh</option>
                        <option value="12">vmin</option>
                        <option value="13">vmax</option>
                        <option value="14">ch</option>
					    <option value="15"><?php echo INITIAL_WORD; ?></option>
					    <option value="16"><?php echo INHERIT_WORD; ?></option>
					   </select>
					  </td>  
					  <td align="right"><?php echo LINE_HEIGHT; ?>: </td>
					  <td colspan="2" >
					   <input name="line_height" type="text" id="line_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="line_height_units" id="line_height_units" onChange="CheckLineHeight(this);">
                       		<option value="-1"><?php echo _NOT_SELECTED_; ?></option>
						    <option value="0"><?php echo NORMAL_WORD; ?></option>
						    <option value="1">Multiplier</option>
                            <option value="2">px</option>
                            <option value="3">%</option>
                            <option value="4">em</option>
                            <option value="5">pt</option>
                            <option value="6">pc</option>
                            <option value="7">cm</option>
                            <option value="8">mm</option>
                            <option value="9">in</option>
                            <option value="10">rem</option>
                            <option value="11">vw</option>
                            <option value="12">vh</option>
                            <option value="13">vmin</option>
                            <option value="14">vmax</option>
                            <option value="15">ch</option>
                            <option value="16"><?php echo INHERIT_WORD; ?></option>
                            <option value="17"><?php echo INITIAL_WORD; ?></option>
						</select>
					  </td>
					  <td class="small_message" align="right" valign="bottom" colspan="2"><?php echo EDIT_CSS_CLICK_NONE_MSG; ?></td>
					</tr>
				    <tr>
					  <td colspan="10">
					    <table border="0" width="100%">
					      <tr>
						    <td align="center">
							   <?php echo ITALIC_WORD; ?>: 
							   <input name="italic" type="checkbox" id="italic" value="1" />
						    </td>
						    <td align="center">
						       <?php echo UNDERLINE_WORD; ?>: 
						       <input name="underline" type="checkbox" id="underline" value="1" />
						    </td>
						    <td align="center">
						       <?php echo OVERLINE_WORD; ?>: 
						       <input name="overline" type="checkbox" id="overline" value="1" />
						    </td>
						    <td align="center">
						       <?php echo BLINK_WORD; ?>: 
						       <input name="blink" type="checkbox" id="blink" value="1" />
						    </td>
						    <td align="center">
						       <?php echo LINETHROUGH_WORD; ?>: 
						       <input name="linethrough" type="checkbox" id="linethrough" value="1" />
						    </td>
						    <td align="center">
						       <?php echo OBLIQUE_WORD; ?>: 
						       <input name="oblique" type="checkbox" id="oblique" value="1" />
						    </td>
						    <td align="center">
						       <?php echo SMALL_CAPS; ?>: 
						       <input name="small_caps" type="checkbox" id="small_caps" value="1" />
						    </td>
                            <td align="center">
						       <?php echo NONE_WORD; ?>: 
						       <input name="no_text_decoration" type="checkbox" id="no_text_decoration" value="1" onChange="text_decoration_none_clicked();" />
						    </td>
						  </tr>
					    </table>
                        <table border="0" width="100%">
                          <tr>
                             <td align="center">
                                <?php echo SHADOW_WORD; ?>:
                                <input name="shadow" type="checkbox" id="shadow" value="1" onClick="enable_disable_shadow();" /> 
                            </td>
                            <td align="center">
                                <?php echo COLOR_WORD; ?>: 
                                  <input name="shadow_color" type="text" id="shadow_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'shadow_color');"><?php echo RGB_WORD; ?></a></span>						  </td>
                            <td align="center">
                                <?php echo X_OFFSET_WORD; ?>: 
                                  <input name="shadow_x_offset" type="text" id="shadow_x_offset" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                           <td align="center">
                                <?php echo Y_OFFSET_WORD; ?>: 
                                  <input name="shadow_y_offset" type="text" id="shadow_y_offset" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                           <td align="center">
                                <?php echo BLUR_WORD; ?>: 
                                  <input name="shadow_blur" type="text" id="shadow_blur" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                                  px
                           </td>
                         </tr>
                       </table>
					  </td>
				    </tr>
			      </table>
			    </td>
			   </tr>
             </table>
			 
	       </td>
	     </tr>
	     <tr>
	       <td>
		   
		     <table border="1" width="100%" id="background_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="5" class="bold"><?php echo BACKGROUND_WORD; ?></td>
                       <td colspan="2" class="bold" style="border-left:medium #666666 double; padding-left:3px;"><?php echo EDIT_CSS_TABLE_LAYOUT; ?></td>
                       <td colspan="2" class="bold"  style="border-left:medium #666666 double; padding-left:3px;"><?php echo EDIT_CSS_CURSOR; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					   <td>
					     <input name="bkgd_color" type="text" id="bkgd_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'bkgd_color');"> <?php echo RGB_WORD; ?></a></span>
					   </td>
                       <td align="right">
					   	<?php echo TRANSPARENT_WORD; ?>: 
                        <input name="bkgd_transparent" type="checkbox" id="bkgd_transparent" value="1" onChange="enable_disable_background_color();" />
                       </td>
                       
					   <td align="right"><?php echo OPACITY_WORD; ?>: </td>
					   <td>
					     <input name="bkgd_opacity" type="text" id="bkgd_opacity" value="" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> % 
					   </td>
					   <td align="right"  style="border-left:medium #666666 double;"><?php echo EDIT_CSS_TABLE_LAYOUT; ?>:</td>
					   <td>
                       <select name="table_layout" id="table_layout">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="fixed"><?php echo FIXED_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
                       </td>
                       <td align="right" style="border-left:medium #666666 double;">Cursor: </td>
					   <td>
                       <select name="cursor" id="cursor">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="pointer"><?php echo POINTER_WORD; ?></option>
                         <option value="crosshair"><?php echo CROSSHAIR_WORD; ?></option>
                         <option value="default"><?php echo DEFAULT_WORD; ?></option>
                         <option value="wait"><?php echo WAIT_WORD; ?></option>
                         <option value="help"><?php echo HELP_WORD; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="alias"><?php echo ALIAS_WORD; ?></option>
                         <option value="all-scroll"><?php echo EDIT_CSS_ALL_SCROLL; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="cell"><?php echo CELL_WORD; ?></option>
                         <option value="context-menu"><?php echo EDIT_CSS_CONTEXT_MENU; ?></option>
                         <option value="col-resize"><?php echo EDIT_CSS_COLUMN_RESIZE; ?></option>
                         <option value="row-resize"><?php echo EDIT_CSS_ROW_RESIZE; ?></option>
                         <option value="copy"><?php echo COPY_WORD; ?></option>
                         <option value="move"><?php echo MOVE_WORD; ?></option>
                         <option value="no-drop"><?php echo EDIT_CSS_NO_DROP; ?></option>
                         <option value="not-allowed"><?php echo EDIT_CSS_NOT_ALLOWED; ?></option>
                         <option value="progress"><?php echo PROGRESS_WORD; ?></option>
                         <option value="text"><?php echo TEXT_WORD; ?></option>
                         <option value="vertical-text"><?php echo EDIT_CSS_VERTICAL_TEXT; ?></option>
                         <option value="e-resize"><?php echo EDIT_CSS_EAST_RESIZE; ?></option>
                         <option value="ew-resize"><?php echo EDIT_CSS_EAST_WEST_RESIZE; ?></option>
                         <option value="n-resize"><?php echo EDIT_CSS_NORTH_RESIZE; ?></option>
                         <option value="ne-resize"><?php echo EDIT_CSS_NORTH_EAST_RESIZE; ?></option>
                         <option value="nesw-resize"><?php echo EDIT_CSS_NORTH_EAST_SOUTH_WEST_RESIZE; ?></option>
                         <option value="ns-resize"><?php echo EDIT_CSS_NORTH_SOUTH_RESIZE; ?></option>
                         <option value="nw-resize"><?php echo EDIT_CSS_NORTH_WEST_RESIZE; ?></option>
                         <option value="nwse-resize"><?php echo EDIT_CSS_NORTH_WEST_SOUTH_EAST_RESIZE; ?></option>
                         <option value="s-resize"><?php echo EDIT_CSS_SOUTH_RESIZE; ?></option>
                         <option value="se-resize"><?php echo EDIT_CSS_SOUTH_EAST_RESIZE; ?></option>
                         <option value="sw-resize"><?php echo EDIT_CSS_SOUTH_WEST_RESIZE; ?></option>
                         <option value="w-resize"><?php echo EDIT_CSS_WEST_RESIZE; ?></option>
                         <option value="zoom-in"><?php echo EDIT_CSS_ZOOM_IN; ?></option>
                         <option value="zoom-out"><?php echo EDIT_CSS_ZOOM_OUT; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
					   </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
         <tr>
	       <td>
		   
		     <table border="1" width="100%" id="border_table">
			   <tr>
			     <td>
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo BORDER_WORD; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo BORDER_WORD; ?>: </td>
					   <td>
					    <input name="border" type="text" id="border" value="" size="6" onChange="CheckBorderParams(this);" onClick="TextFieldClick(this);" onBlur="TextFieldBlur(this);" />
                      	<select name="border_units" id="border_units" onChange="CheckFormatOnUnitSelect(this.id, 'border');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
					   </td>					  
					   <td align="right"><?php echo BORDER_COLOR; ?>: </td>
					   <td>
					     <input name="border_color" type="text" id="border_color" value="" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                         <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'border_color');"> <?php echo RGB_WORD; ?></a></span>
                         </td>
					   <td align="right"><?php echo BORDER_STYLE; ?>: </td>
					   <td>
                       <select name="border_style" id="border_style" onChange="CheckBorderParams(this);">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="dotted"><?php echo DOTTED_WORD; ?></option>
                         <option value="dashed"><?php echo DASHED_WORD; ?></option>
                         <option value="solid"><?php echo SOLID_WORD; ?></option>
                         <option value="double"><?php echo DOUBLE_WORD; ?></option>
                         <option value="groove"><?php echo GROOVE_WORD; ?></option>
                         <option value="ridge"><?php echo RIDGE_WORD; ?></option>
                         <option value="inset"><?php echo INSET_WORD; ?></option>
                         <option value="outset"><?php echo OUTSET_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo EDIT_CSS_OUTLINE_STYLE; ?>: </td>
					   <td>
                       <select name="outline_style" id="outline_style">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="dotted"><?php echo DOTTED_WORD; ?></option>
                         <option value="dashed"><?php echo DASHED_WORD; ?></option>
                         <option value="solid"><?php echo SOLID_WORD; ?></option>
                         <option value="double"><?php echo DOUBLE_WORD; ?></option>
                         <option value="groove"><?php echo GROOVE_WORD; ?></option>
                         <option value="ridge"><?php echo RIDGE_WORD; ?></option>
                         <option value="inset"><?php echo INSET_WORD; ?></option>
                         <option value="outset"><?php echo OUTSET_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
					   </td>
                       <td align="right"><?php echo EDIT_CSS_BORDER_COLLAPSE; ?>: </td>
					   <td>
                       <select name="border_collapse" id="border_collapse">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="collapse"><?php echo COLLAPSE_WORD; ?></option>
                         <option value="separate"><?php echo SEPARATE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
					   </td>
				     </tr>
                  </table>
                  <table width="100%" border="0">
                     <tr>
                       <td><?php echo TOP_1ST_CAP_WORD; ?>: <input name="border_top" type="checkbox" id="border_top" value="1" /> </td>
                       <td><?php echo BOTTOM_1ST_CAP_WORD; ?>: <input name="border_bottom" type="checkbox" id="border_bottom" value="1" /> </td>
                       <td><?php echo LEFT_1ST_CAP_WORD; ?>: <input name="border_left" type="checkbox" id="border_left" value="1" /> </td>
                       <td><?php echo RIGHT_1ST_CAP_WORD; ?>: <input name="border_right" type="checkbox" id="border_right" value="1" /> </td>
					   <td align="right" class="bold"><?php echo PADDING_WORD; ?></td>
					   <td align="right">
                       <?php echo TOP_1ST_CAP_WORD; ?>:</td>					  
					   <td>
                       <input name="padding_top" type="text" id="padding_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_top_units" id="padding_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_top');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
					   </td>
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>:</td>
					   <td>
                       <input name="padding_right" type="text" id="padding_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_right_units" id="padding_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_right');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>:</td>
					   <td>
                       <input name="padding_bottom" type="text" id="padding_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_bottom_units" id="padding_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_bottom');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>:</td>
                       <td>
                       <input name="padding_left" type="text" id="padding_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="padding_left_units" id="padding_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'padding_left');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                       	</select> 
                       </td>
				     </tr>
                  </table>
                  <table  width="100%" border="0">
                     <tr>
					   <td align="right" class="bold"><?php echo RADIUS_WORD; ?></td>
					   <td align="right">
                       <?php echo EDIT_CSS_TOP_LEFT; ?>: </td>					  
					   <td>
                       <input type="text" name="radius_top_left" id="radius_top_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_top_left_units" id="radius_top_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_top_left');">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_TOP_RIGHT; ?>: </td>
					   <td>
                       <input type="text" name="radius_top_right" id="radius_top_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_top_right_units" id="radius_top_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_top_right');">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_BOTTOM_RIGHT; ?>: </td>
					   <td>
                       <input type="text" name="radius_bottom_right" id="radius_bottom_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_bottom_right_units" id="radius_bottom_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_bottom_right');">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>
                       </select> 
                       </td>
					   <td align="right"><?php echo EDIT_CSS_BOTTOM_LEFT; ?>: </td>
                       <td>
                       <input type="text" name="radius_bottom_left" id="radius_bottom_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);">
                       <select name="radius_bottom_left_units" id="radius_bottom_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'radius_bottom_left');">
                        <option value="0">px</option>
                        <option value="1">%</option>
                        <option value="2">em</option>
                        <option value="3">pt</option>
                        <option value="4">pc</option>
                        <option value="5">cm</option>
                        <option value="6">mm</option>
                        <option value="7">in</option>
                        <option value="8">rem</option>
                        <option value="9">vw</option>
                        <option value="10">vh</option>
                        <option value="11">vmin</option>
                        <option value="12">vmax</option>
                        <option value="13">ch</option>                        
                       </select> 
                       </td>
				     </tr>
			       </table>
			     </td>
			   </tr>
	         </table>
             
           </td>
	     </tr>
	     <tr>
	       <td>
			 
	         <table border="1" width="100%" id="margin_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="4" class="bold"><?php echo MARGIN_WORD; ?> </td>
                       <td colspan="4" align="center"><span class="small_message"><?php echo EDIT_CSS_CLICK_AUTO_MSG; ?></span></td>
                       <td colspan="2" style="border-left:medium #666666 double; padding-left:3px;"><span class="bold"><?php echo SIZE_WORD; ?></span></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="margin_top" type="text" id="margin_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="margin_top_units" id="margin_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_top');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						  </select> 
                       </td>					  
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_right" type="text" id="margin_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="margin_right_units" id="margin_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_right');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						 </select>
					   </td>
                       <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_bottom" type="text" id="margin_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="margin_bottom_units" id="margin_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_bottom');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
						 </select>
					   </td>					
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="margin_left" type="text" id="margin_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         	<select name="margin_left_units" id="margin_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'margin_left');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
					    </select> 
					   </td>
                       <td align="right" style="border-left:medium #666666 double;"><?php echo WIDTH_WORD; ?>: </td>
					   <td>
					     <input name="width" type="text" id="width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					     <select name="width_units" id="width_units" onChange="CheckFormatOnUnitSelect(this.id, 'width');">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
					     </select>
                         <select name="width_prefix" id="width_prefix">
                          <option value="-not selected-" class="not_set"></option>
                          <option value="min"><?php echo MIN_WORD; ?></option>
                          <option value="max"><?php echo MAX_WORD; ?></option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                     	<td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_top_auto" type="checkbox" id="margin_top_auto" value="1" onChange="margin_auto_clicked('top')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_right_auto" type="checkbox" id="margin_right_auto" value="1" onChange="margin_auto_clicked('right')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_bottom_auto" type="checkbox" id="margin_bottom_auto" value="1" onChange="margin_auto_clicked('bottom')" />
                        </td>
                        <td>&nbsp;</td>
                        <td>
                        <?php echo AUTO_WORD; ?>: 
                        <input name="margin_left_auto" type="checkbox" id="margin_left_auto" value="1" onChange="margin_auto_clicked('left')" />
                        </td>
                        <td align="right" style="border-left:medium #666666 double;"><?php echo HEIGHT_WORD; ?>: </td>
					   <td>
					     <input name="height" type="text" id="height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="height_units" id="height_units" onChange="CheckFormatOnUnitSelect(this.id, 'height');">
                          <option value="0">px</option>
                          <option value="1">%</option>
                          <option value="2">em</option>
                          <option value="3">pt</option>
                          <option value="4">pc</option>
                          <option value="5">cm</option>
                          <option value="6">mm</option>
                          <option value="7">in</option>
                          <option value="8">rem</option>
                          <option value="9">vw</option>
                          <option value="10">vh</option>
                          <option value="11">vmin</option>
                          <option value="12">vmax</option>
                          <option value="13">ch</option>
					     </select>
                         <select name="height_prefix" id="height_prefix">
                          <option value="-not selected-" class="not_set"></option>
                          <option value="min"><?php echo MIN_WORD; ?></option>
                          <option value="max"><?php echo MAX_WORD; ?></option>
					     </select>
					   </td>
                     </tr>
			       </table>
                   
                </td>
               </tr>
              </table>
                   
               <table border="1" width="100%" id="position_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo POSITION_WORD; ?></td>
				     </tr>
				     <tr>
                       <td align="right"><?php echo POSITIONING_WORD; ?>: </td>
					   <td><select name="position" id="position">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="absolute"><?php echo ABSOLUTE_WORD; ?></option>
					     <option value="fixed"><?php echo FIXED_WORD; ?></option>
                         <option value="relative"><?php echo RELATIVE_WORD; ?></option>
                         <option value="static"><?php echo STATIC_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="position_left" type="text" id="position_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="position_left_units" id="position_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_left');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
					      </select>
                        </td>					  
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_top" type="text" id="position_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_top_units" id="position_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_top');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
					     </select>
					   </td>					
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_right" type="text" id="position_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_right_units" id="position_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_right');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="position_bottom" type="text" id="position_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                         <select name="position_bottom_units" id="position_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'position_bottom');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
				     </tr>
                     <tr>
                       <td align="right"><?php echo DISPLAY_WORD; ?>: </td>
					   <td>
                       <select name="display" id="display">
						  <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					      <option value="none"><?php echo NONE_WORD; ?></option>
					      <option value="inline"><?php echo INLINE_WORD; ?></option>
					      <option value="block"><?php echo BLOCK_WORD; ?></option>
                          <option value="inline-block"><?php echo EDIT_CSS_INLINE_BLOCK; ?></option>
					      <option value="list-item"><?php echo EDIT_CSS_LIST_ITEM; ?></option>
					      <option value="run-in"><?php echo EDIT_CSS_RUN_IN; ?></option>
					      <option value="compact"><?php echo COMPACT_WORD; ?></option>
					      <option value="marker"><?php echo MARKER_WORD; ?></option>
					      <option value="table"><?php echo TABLE_WORD; ?></option>
					      <option value="inline-table"><?php echo EDIT_CSS_INLINE_TABLE; ?></option>
					      <option value="table-row-group"><?php echo EDIT_CSS_TABLE_ROW_GROUP; ?></option>
					      <option value="table-footer-group"><?php echo EDIT_CSS_TABLE_FOOTER_GROUP; ?></option>
					      <option value="table-row"><?php echo EDIT_CSS_TABLE_ROW; ?></option>
					      <option value="table-column-group"><?php echo EDIT_CSS_TABLE_COLUMN_GROUP; ?></option>
					      <option value="table-column"><?php echo EDIT_CSS_TABLE_COLUMN; ?></option>
					      <option value="table-cell"><?php echo EDIT_CSS_TABLE_CELL; ?></option>
					      <option value="table-caption"><?php echo EDIT_CSS_TABLE_CAPTION; ?></option>
                          <option value="initial"><?php echo INITIAL_WORD; ?></option>
                          <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					      </select>
                       </td>
                       <td align="right"><?php echo VISIBILITY_WORD; ?>: </td>
                       <td>
                       	 <select name="visibility" id="visibility">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
                         <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="collapse"><?php echo COLLAPSE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo EDIT_CSS_Z_INDEX; ?>:</td>
					   <td>
                       <input name="z_index" type="text" id="z_index" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                        </td>					  					
					   <td align="right"><?php echo FLOAT_WORD; ?>: </td>
					   <td colspan="3">
                       <select name="float" id="float">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value='left'><?php echo LEFT_1ST_CAP_WORD; ?></option>
                         <option value='right'><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                         <option value='none'><?php echo NONE_WORD; ?></option>
                         <option value='inherit'><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
				     </tr>
                     <tr>
                     	<td align="right"><?php echo OVERFLOW_WORD; ?>:</td>
					   <td>
                        <select name="overflow" id="overflow" onChange="CheckOverflowLists(this.value, 'xy');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                       </td>
                     	<td align="right"><?php echo OVERFLOW_WORD . "-X"; ?>:</td>
					 	<td>
                        <select name="overflow_x" id="overflow_x" onChange="CheckOverflowLists(this.value, 'x');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                    	</td>
                     	<td align="right"><?php echo OVERFLOW_WORD . "-Y"; ?>:</td>
					 	<td>
                        <select name="overflow_y" id="overflow_y" onChange="CheckOverflowLists(this.value, 'y');">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="visible"><?php echo VISIBLE_WORD; ?></option>
					     <option value="hidden"><?php echo HIDDEN_WORD; ?></option>
                         <option value="scroll"><?php echo SCROLL_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					    </select>
                    	</td>
                        <td align="right"><?php echo EDITOR_CLEAR; ?>: </td>
					   <td colspan="3">
                       <select name="clear" id="clear">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="left"><?php echo LEFT_1ST_CAP_WORD; ?></option>
                         <option value="right"><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                         <option value="both"><?php echo BOTH_WORD; ?></option>
                         <option value="none"><?php echo NONE_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					   </select>
                       </td>
                     </tr>
                     <tr>
					   <td align="right" colspan="2"><?php echo CLIPPING_WORD; ?>:</td>
					   <td align="right"><?php echo TOP_1ST_CAP_WORD; ?>: </td>
					   <td>
						  <input name="clip_top" type="text" id="clip_top" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						  <select name="clip_top_units" id="clip_top_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_top');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
                        </td>					  
					   <td align="right"><?php echo RIGHT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_right" type="text" id="clip_right" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="clip_right_units" id="clip_right_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_right');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
					     </select>
					   </td>					
					   <td align="right"><?php echo BOTTOM_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_bottom" type="text" id="clip_bottom" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 					
                         <select name="clip_bottom_units" id="clip_bottom_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_bottom');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
					   <td align="right"><?php echo LEFT_1ST_CAP_WORD; ?>: </td>
					   <td>
					     <input name="clip_left" type="text" id="clip_left" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 				
                         <select name="clip_left_units" id="clip_left_units" onChange="CheckFormatOnUnitSelect(this.id, 'clip_left');">
						    <option value="0">px</option>
						    <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
	                        <option value="4">pc</option>
    	                    <option value="5">cm</option>
        	                <option value="6">mm</option>
            	            <option value="7">in</option>
                	        <option value="8">rem</option>
                    	    <option value="9">vw</option>
                        	<option value="10">vh</option>
	                        <option value="11">vmin</option>
    	                    <option value="12">vmax</option>
        	                <option value="13">ch</option>
						  </select>
					   </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>
             
             <table border="1" width="100%" id="background_img_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="10" class="bold"><?php echo EDIT_CSS_BACKGROUND_IMAGE; ?></td>
				     </tr>
				     <tr>
					   <td align="right"><?php echo IMAGE_WORD; ?>: </td>
					   <td align="right" width="110">
                       <div id='preview1'><img alt='photo' src='/manage/theme/<?php echo $theme; ?>/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img1' /></div>
                       </td>					  
					   <td align="left" colspan="2">
                       <input type='file' name='file_browse1' id='file_browse1' onChange="upload_index=1; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse1&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview1','&lt;br /&gt;&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>				
					   <td align="right"><?php echo ATTACHMENT_WORD; ?>:</td>
					   <td><select name="background_attachment" id="background_attachment">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="fixed"><?php echo FIXED_WORD; ?></option>
					     <option value="scroll"><?php echo SCROLLING_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>
					   <td align="right"><?php echo REPEAT_WORD; ?>:</td>
					   <td><select name="background_repeat" id="background_repeat">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="repeat"><?php echo REPEAT_WORD; ?></option>
					     <option value="repeat-x"><?php echo EDIT_CSS_REPEAT_HORIZONTALLY; ?></option>
					     <option value="repeat-y"><?php echo EDIT_CSS_REPEAT_VERTICALLY; ?></option>
					     <option value="no-repeat"><?php echo EDIT_CSS_NO_REPEAT; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>
                       <td align="right">&nbsp;</td>
					   <td>&nbsp;</td>
				     </tr>
                     <tr>
					   <td align="center" colspan="4">
                       
                       	<!-- <input type="file" name="browse_image" id="browse_image" />	-->
                        <select name="background_image" id="background_image" onChange="UpdateImage(1);">
                       		<option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                       <?php
					   $file_arr = array();
					   
					   	if ($handle = opendir($path)) 
						{
							/* This is the correct way to loop over the directory. */
							while (false !== ($file = readdir($handle)))
							{
								if (($file != ".") && ($file != "..") && ($file != "tn") && ($file != "gallery") && ($file != "lightbox") && ($file != "orig"))
								{
									if (is_dir($path . "/" . $file))
									{
										$path2 = $path . "/" . $file;
										if ($handle2 = opendir($path2))
										{
											while (false !== ($file2 = readdir($handle2)))
											{
												if (($file2 != ".") && ($file2 != "..") && ($file2 != "tn") && ($file2 != "gallery") && ($file2 != "lightbox") && ($file2 != "orig"))
													$file_arr[] = $file . "/" . $file2;
											}
											closedir($handle2);
										}
									}
									else
										$file_arr[] = $file;
								}
							}
							closedir($handle);
							
							sort($file_arr);
							foreach($file_arr as $file)
							{
								if ($background_image == $file)
									echo "      <option value='$file' selected='selected'>$file</option>\n";
								else
									echo "      <option value='$file'>$file</option>\n";
							}
					    } 
                       ?>
					     </select>
                       </td>
                       <td colspan="6">
                       <table border="1" width="100%">
                       <tr>
                       <td>
                       <table border="0" width="100%">
                       <tr>
                           <td align="right"><?php echo POSITION_WORD; ?>:</td>
                           <td><select name="background_position" id="background_position" onChange="enable_disable_background_positions();">
                             <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                             <option value="top left"><?php echo EDIT_CSS_TOP_LEFT; ?></option>
                             <option value="top center"><?php echo EDIT_CSS_TOP_CENTER; ?></option>
                             <option value="top right"><?php echo EDIT_CSS_TOP_RIGHT; ?></option>
                             <option value="center left"><?php echo EDIT_CSS_CENTER_LEFT; ?></option>
                             <option value="center center"><?php echo EDIT_CSS_CENTER_CENTER; ?></option>
                             <option value="center right"><?php echo EDIT_CSS_CENTER_RIGHT; ?></option>
                             <option value="bottom left"><?php echo EDIT_CSS_BOTTOM_LEFT; ?></option>
                             <option value="bottom center"><?php echo EDIT_CSS_BOTTOM_CENTER; ?></option>
                             <option value="bottom right"><?php echo EDIT_CSS_BOTTOM_RIGHT; ?></option>
                             <option value="xpos ypos"><?php echo EDIT_CSS_XPOS_YPOS; ?></option>
                             <option value="initial"><?php echo INITIAL_WORD; ?></option>
	                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                             </select></td>
                           <td align="right">X:</td>
                           <td><input name="background_position_x" type="text" id="background_position_x" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                           <td align="right">Y:</td>
                           <td><input name="background_position_y" type="text" id="background_position_y" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                           <td>
                             <select name="background_position_units" id="background_position_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_position_x'); CheckFormatOnUnitSelect(this.id, 'background_position_y');">
                               	<option value="0">px</option>
                               	<option value="1">%</option>
                               	<option value="2">em</option>
                                <option value="3">pt</option>
                                <option value="4">pc</option>
                                <option value="5">cm</option>
                                <option value="6">mm</option>
                                <option value="7">in</option>
                                <option value="8">rem</option>
                                <option value="9">vw</option>
                                <option value="10">vh</option>
                                <option value="11">vmin</option>
                                <option value="12">vmax</option>
                                <option value="13">ch</option>
                             </select>
                           </td>
                        </tr>
                       </table>
                       
                       </td>       
                      </tr>
			       </table>
		
			     </td>
			   </tr>
                <tr>
                  <td colspan="3">&nbsp;</td>
                  <td colspan="7">
                    <table border="1" width="100%"><tr><td>
                    <table border="0" width="100%">
                      <tr>
                        <td align="right"><?php echo SIZE_WORD; ?>:</td>
                        <td>
                        <select name="background_size" id="background_size" onChange="enable_disable_background_sizes();">
                         <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                         <option value="scale"><?php echo SCALE_WORD; ?></option>
                         <option value="cover"><?php echo COVER_WORD; ?></option>
                         <option value="contain"><?php echo CONTAIN_WORD; ?></option>
                         <option value="auto"><?php echo AUTO_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
                        </select>
                        </td>
                        <td align="right"><?php echo WIDTH_WORD; ?>:</td>
                        <td><input name="background_width" type="text" id="background_width" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                        <td>
                         <select name="background_width_units" id="background_width_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_width');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                         </select>
                        </td>
                        <td align="right"><?php echo HEIGHT_WORD; ?>:</td>
                        <td><input name="background_height" type="text" id="background_height" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                        <td>
                          <select name="background_height_units" id="background_height_units" onChange="CheckFormatOnUnitSelect(this.id, 'background_height');">
                            <option value="0">px</option>
                            <option value="1">%</option>
                            <option value="2">em</option>
                            <option value="3">pt</option>
                            <option value="4">pc</option>
                            <option value="5">cm</option>
                            <option value="6">mm</option>
                            <option value="7">in</option>
                            <option value="8">rem</option>
                            <option value="9">vw</option>
                            <option value="10">vh</option>
                            <option value="11">vmin</option>
                            <option value="12">vmax</option>
                            <option value="13">ch</option>
                         </select>
                        </td>
                      </tr>
                    </table> 
                    </td></tr></table>
                  </td>
                </tr>
	         </table>
			 
	       </td>
	     </tr>
	   </table>
       
       <table border="1" width="100%" id="list_table">
		       <tr>
			     <td>
				 
			       <table border="0" width="100%">
				     <tr>
					   <td colspan="8" class="bold"><?php echo LIST_WORD; ?></td>
				     </tr>
				     <tr>
                       <td align="right"><?php echo TYPE_WORD; ?>: </td>
					   <td><select name="list_style_type" id="list_style_type">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="none"><?php echo NONE_WORD; ?></option>
					     <option value="disc"><?php echo DISC_WORD; ?></option>
					     <option value="circle"><?php echo CIRCLE_WORD; ?></option>
					     <option value="square"><?php echo SQUARE_WORD; ?></option>
					     <option value="decimal"><?php echo DECIMAL_WORD; ?></option>
					     <option value="decimal-leading-zero"><?php echo EDIT_CSS_DECIMAL_LEADING_ZERO; ?></option>
					     <option value="lower-roman"><?php echo EDIT_CSS_LOWER_ROMAN; ?></option>
					     <option value="upper-roman"><?php echo EDIT_CSS_UPPER_ROMAN; ?></option>
					     <option value="lower-alpha"><?php echo EDIT_CSS_LOWER_ALPHA; ?></option>
					     <option value="upper-alpha"><?php echo EDIT_CSS_UPPER_ALPHA; ?></option>
					     <option value="lower-greek"><?php echo EDIT_CSS_LOWER_GREEK; ?></option>
					     <option value="lower-latin"><?php echo EDIT_CSS_LOWER_LATIN; ?></option>
					     <option value="upper-latin"><?php echo EDIT_CSS_UPPER_LATIN; ?></option>
					     <option value="hebrew"><?php echo HEBREW_WORD; ?></option>
					     <option value="armenian"><?php echo ARMENIAN_WORD; ?></option>
					     <option value="gorgian"><?php echo GORGIAN_WORD; ?></option>
					     <option value="cjk-ideographic"><?php echo EDIT_CSS_CJK_IDEOGRAPHIC; ?></option>
					     <option value="hiragana"><?php echo EDIT_CSS_HIRAGANA; ?></option>
					     <option value="katakana"><?php echo EDIT_CSS_KATAKANA; ?></option>
					     <option value="hiragana-iroha"><?php echo EDIT_CSS_HIRAGANA_IROHA; ?></option>
					     <option value="katakana-iroha"><?php echo EDIT_CSS_KATAKANA_IROHA; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
                         <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select>
                       </td>
					   <td align="right"><?php echo POSITION_WORD; ?>: </td>
					   <td><select name="list_style_position" id="list_style_position">
					     <option value="-not selected-" class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					     <option value="inside"><?php echo INSIDE_WORD; ?></option>
					     <option value="outside"><?php echo OUTSIDE_WORD; ?></option>
                         <option value="initial"><?php echo INITIAL_WORD; ?></option>
					     <option value="inherit"><?php echo INHERIT_WORD; ?></option>
					     </select></td>					  
					   <td align="right"><?php echo IMAGE_WORD; ?>: </td>
					   <td align="right" width="110">
                       <div id='preview2'><img alt='photo' src='/manage/theme/<?php echo $theme; ?>/images/upload_photo_placeholder.jpg' style='width: 104px; height: 104px;' id='photo_img2' /></div>
                       </td>					
					   <td>
                       <input type='file' name='file_browse2' id='file_browse2' onChange="upload_index=2; ajaxUpload(this.form,'/manage/js/ajaxupload.php?filename=file_browse2&amp;maxSize=9999999999&amp;maxW=1024&amp;fullPath=<?php echo $http_host . "/" . $image_dir_path; ?>/&amp;relPath=../../<?php echo $image_dir_path; ?>/&amp;fullPathTN=<?php echo $http_host . "/" . $image_tn_dir_path; ?>/&amp;relPathTN=../../<?php echo $image_tn_dir_path; ?>/&amp;colorR=255&amp;colorG=255&amp;colorB=255&amp;maxH=1000&amp;tnW=104&amp;tnH=104&amp;popupW=600&amp;popupH=600','preview2','&lt;br /&gt;&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/loading.gif\' width=\'104\' height=\'104\' border=\'0\' /&gt;','&lt;img src=\'/manage/theme/<?php echo $theme; ?>/images/error.gif\' width=\'16\' height=\'16\' border=\'0\' /&gt; Error in Upload, check settings and path info in source code.'); return false;" />
                       </td>
					   <td>
                       	<select name="list_style_image" id="list_style_image" onChange="UpdateImage(2);">
					     <option value='-not selected-' class="not_set"><?php echo _NOT_SELECTED_; ?></option>
					   <?php
						foreach($file_arr as $file)
						{
							if ($list_style_image == $file)
								echo "      <option value='$file' selected='selected'>$file</option>\n";
							else
								echo "      <option value='$file'>$file</option>\n";
						}
                       ?>
					     </select>
                       </td>
				     </tr>
			       </table>
		
			     </td>
			   </tr>
	         </table>

			<table border="1" width="100%" id="box_shadow_table">
              <tr>
                <td>
                <table border="0" width="100%">
                  <tr>
                    <td class="bold" colspan="12"><?php echo BOX_SHADOW; ?></td>
                  </tr>
                  <tr>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="box_shadow_horizontal" id="box_shadow_horizontal" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="box_shadow_vertical" id="box_shadow_vertical" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_blur" id="box_shadow_blur" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_spread" id="box_shadow_spread" value="" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    px</td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="box_shadow_color" id="box_shadow_color" value="" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_site_styles', 'box_shadow_color');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="box_shadow_inset" id="box_shadow_inset" value="1" /></td>
                  </tr>
                </table>
                </td>
              </tr>
            </table>
             
	 </td></tr></table>
     </td>
     <tr><td align="center">
     <table width="100%">
       <tr>
     	<td align="center">
            <div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
            <input type="hidden" name="MAX_FILE_SIZE" value="500000" />
            <input type="hidden" name="browse_image_control" value="file_browse1"/>
            <input type="hidden" name="style_sheet" value="<?php echo $style_sheet; ?>" />
            <input type="hidden" name="show_class_editor" value="<?php echo $show_class_editor; ?>" />
            <input type="hidden" name="class" id="goto_class" value="<?php echo $goto_class; ?>"/>
            <input type="hidden" name="submit_action" id="submit_action" />
        </td>
        <td align="center" width="70%">&nbsp;
        	
        </td>
        <td align="center">
            <div class='button_console_save' style="width:110px;" onClick="UpdateCSS('Update', false);"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
        </td>
       </tr>
      </table>
      </td></tr></table>
      </form>
	 
	   <table width="100%" border="0" cellspacing="1" cellpadding="1"> 
       <?php
	   		if (($show_class_editor == 1) || ($style_sheet == "site"))
			{
		?>
	     <tr>
          <?php
	   		if ($style_sheet == "site")
			{
		  ?>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadBrowserResetParams();"><span class='button_console_text'><?php echo EDIT_CSS_LOAD_BROWSER_RESET_CSS_BTN; ?></span></div>
           </td>
           <td align="center">
                <div class='button_console' style="width:200px;" onClick="LoadCenterParams();"><span class='button_console_text'><?php echo EDIT_CSS_SETUP_CENTERED_PAGES_BTN; ?></span></div>
           </td>
           <td>
                <div class='button_console' style="width:200px;" onClick="LoadStickyFooterParams();"><span class='button_console_text'><?php echo EDIT_CSS_SETUP_STICKY_FOOTER_BTN; ?></span></div>
           </td>
           <?php
			}
		 
	   		if ($show_class_editor == 1)
			{
		   ?>
		 	<td align="center">
            <div class='button_console_add' style="width:230px;" onClick="window.location.href='classes.php?style_sheet=<?php echo $style_sheet; ?>';"><span class='button_console_text_w_icon'><?php echo EDIT_CSS_ADD_DELETE_CUSTOM_STYLE_BTN; ?></span></div>
            </td>
          <?php
			}
		  ?>
		 </tr>
         <?php
			}
		?>
       </table>

	 </td>
   </tr>
</table>
<a name="bottom_anchor"></a>
</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	enable_disable_controls(0);
	HidePopupMsg();
	
<?php
if ($goto_class)
	echo "	PopulateForm(document.getElementById('goto_class'));\n";
?>
</script>
</body>
</html>