<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/18/2009	ELL
// Modified: 1/7/2010		ELL
// Changed the way hover text color is handled.  Was able to add separate user-electable sublevel 2 hover text color.
// Revised: 10/7/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 1/10/2011	ELL
// Added preview mode.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 7/21/2013	ELL
// Added background opacity.
// Revised: 3/10/2015	ELL
// Converted deprecated font stretch to letter spacing.
// Revised: 4/5/2015	ELL
// Added font size units.
// Revised: 1/20/2016	ELL
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
//

	include ("check_session.php");
		
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
		
?>
<!DOCTYPE html>
<html>
<head>
<title>Editing <?php echo $menu; ?> CSS Menu Styles | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#css_menu_styles_heading	{	width:350px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:310px;
	height:31px;
	width:31px;
	z-index:100;
}

#page_select_div	{
	left: 250px;
}
</style>

<script type="text/javascript" src="js/check_color_str.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/jquery.min.js"></script>
<script src="js/edit_css_menu_styles.js" language="javascript" type="text/javascript"></script>

<script>
<?php
	echo "	var EDIT_CSS_MENU_STYLES_LETTER_SPACING_MSG = \"" . EDIT_CSS_MENU_STYLES_LETTER_SPACING_MSG . "\";\n";
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG = \"" . EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG . "\";\n";
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR = \"" . EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
?>
</script>

</head>

<body id="workspace_body" onLoad="InitializeForm();">

<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="css_menu_styles_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_CSS_MENU_STYLES_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="40%">
<?php echo EDIT_CSS_MENU_STYLES_SELECT_MENU; ?>:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$got_wrong_menu_type = true;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE menu_type = 0";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)	{
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
			$got_wrong_menu_type = false;
		}
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
	
	if ($got_wrong_menu_type === true)
		$menu = _NOT_SELECTED_;
?>
</select>
</td>
</tr>
</table>

<?php
	if (($menu == _NOT_SELECTED_) || ($menu == ""))
	{
		echo EDIT_CSS_MENU_STYLES_SELECT_MENU_MSG;
		exit;
	}
	else
	{
		$suffix = substr($menu, 4);
		$suffix = str_replace("_mobile", "", $suffix);
	}
	
	$menu_source  = "menu" . $suffix . "_items" ;
	
	$menu_css_table = $menu . "_css" ;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row_count = $result->rowCount();
	if ($row_count < 1)
	{
		echo "CSS menu parameters have not been set.  Please click <a href='edit_css_menu_params.php'>here</a> to setup the CSS menu parameters";
		exit;
	}
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] == -2)
		$load_defaults = 1;
	else
		$load_defaults = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.top_level_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$top_level_font = $row["font"];
	elseif($load_defaults == 1)
		$top_level_font = "Arial";
	else
		$top_level_font = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$top_level_font_size = $row["font_size"];
	else
		$top_level_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$top_level_font_size_units = $row["font_size_units"];
	else
		$top_level_font_size_units = "px";
	if (!is_null($row["weight"])  && ($row["weight"] != ""))
		$top_level_weight = $row["weight"];
	elseif($load_defaults == 1)
		$top_level_weight = "bold";
	else
		$top_level_weight = _NOT_SET_;
	if (!is_null($row["letter_spacing"]))
		$top_level_letter_spacing = $row["letter_spacing"];
	else
		$top_level_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$top_level_letter_spacing_units = $row["letter_spacing_units"];
	else
		$top_level_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$top_level_italic = $row["italic"];
	else
		$top_level_italic = 0;
	if (!is_null($row["underline"]))
		$top_level_underline = $row["underline"];
	else
		$top_level_underline = 0;
	if (!is_null($row["overline"]))
		$top_level_overline = $row["overline"];
	else
		$top_level_overline = 0;
	if (!is_null($row["blink"]))
		$top_level_blink = $row["blink"];
	else
		$top_level_blink = 0;
	if (!is_null($row["oblique"]))
		$top_level_oblique = $row["oblique"];
	else
		$top_level_oblique = 0;
	if (!is_null($row["small_caps"]))
		$top_level_small_caps = $row["small_caps"];
	else
		$top_level_small_caps = 0;
	if (!is_null($row["shadow"]))
		$top_level_shadow = $row["shadow"];
	else
		$top_level_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$top_level_shadow_color = $row["shadow_color"];
	else
		$top_level_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))
		$top_level_shadow_x_offset = $row["shadow_x_offset"];
	else
		$top_level_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))
		$top_level_shadow_y_offset = $row["shadow_y_offset"];
	else
		$top_level_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))
		$top_level_shadow_blur = $row["shadow_blur"];
	else
		$top_level_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$top_level_text_color = "#336699";
	else
		$top_level_text_color = _NOT_SET_;
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_1_font = $row["font"];
	elseif($load_defaults == 1)
		$sub_level_1_font = "Arial";
	else
		$sub_level_1_font = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_1_font_size = $row["font_size"];
	else
		$sub_level_1_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_1_font_size_units = $row["font_size_units"];
	else
		$sub_level_1_font_size_units = "px";
	if (!is_null($row["weight"]))
		$sub_level_1_weight = $row["weight"];
	else
		$sub_level_1_weight = "bold";	
	if (!is_null($row["letter_spacing"]))
		$sub_level_1_letter_spacing = $row["letter_spacing"];
	else
		$sub_level_1_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_1_letter_spacing_units = $row["letter_spacing_units"];
	else
		$sub_level_1_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$sub_level_1_italic = $row["italic"];
	else
		$sub_level_1_italic = 0;
	if (!is_null($row["underline"]))
		$sub_level_1_underline = $row["underline"];
	else
		$sub_level_1_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_1_overline = $row["overline"];
	else
		$sub_level_1_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_1_blink = $row["blink"];
	else
		$sub_level_1_blink = 0;
	if (!is_null($row["oblique"]))
		$sub_level_1_oblique = $row["oblique"];
	else
		$sub_level_1_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_1_small_caps = $row["small_caps"];
	else
		$sub_level_1_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_1_shadow = $row["shadow"];
	else
		$sub_level_1_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_1_shadow_color = $row["shadow_color"];
	else
		$sub_level_1_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))
		$sub_level_1_shadow_x_offset = $row["shadow_x_offset"];
	else
		$sub_level_1_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))
		$sub_level_1_shadow_y_offset = $row["shadow_y_offset"];
	else
		$sub_level_1_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))
		$sub_level_1_shadow_blur = $row["shadow_blur"];
	else
		$sub_level_1_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_1_text_color = "#336699";
	else
		$sub_level_1_text_color = _NOT_SET_;
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_2_a" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["font"]) && ($row["font"] != ""))
		$sub_level_2_font = $row["font"];
	elseif($load_defaults == 1)
		$sub_level_2_font = "Arial";
	else
		$sub_level_2_font = _NOT_SET_;
	if ((!is_null($row["font_size"])) && ($row["font_size"] != -1))
		$sub_level_2_font_size = $row["font_size"];
	else
		$sub_level_2_font_size = _NOT_SET_;
	if (!is_null($row["font_size_units"]))
		$sub_level_2_font_size_units = $row["font_size_units"];
	else
		$sub_level_2_font_size_units = "px";
	if (!is_null($row["weight"]))
		$sub_level_2_weight = $row["weight"];
	else
		$sub_level_2_weight = "bold";
	if (!is_null($row["letter_spacing"]))
		$sub_level_2_letter_spacing = $row["letter_spacing"];
	else
		$sub_level_2_letter_spacing = _NOT_SET_;
	if (!is_null($row["letter_spacing_units"]))
		$sub_level_2_letter_spacing_units = $row["letter_spacing_units"];
	else
		$sub_level_2_letter_spacing_units = "-not selected-";	
	if (!is_null($row["italic"]))
		$sub_level_2_italic = $row["italic"];
	else
		$sub_level_2_italic = 0;
	if (!is_null($row["underline"]))
		$sub_level_2_underline = $row["underline"];
	else
		$sub_level_2_underline = 0;
	if (!is_null($row["overline"]))
		$sub_level_2_overline = $row["overline"];
	else
		$sub_level_2_overline = 0;
	if (!is_null($row["blink"]))
		$sub_level_2_blink = $row["blink"];
	else
		$sub_level_2_blink = 0;
	if (!is_null($row["oblique"]))
		$sub_level_2_oblique = $row["oblique"];
	else
		$sub_level_2_oblique = 0;
	if (!is_null($row["small_caps"]))
		$sub_level_2_small_caps = $row["small_caps"];
	else
		$sub_level_2_small_caps = 0;
	if (!is_null($row["shadow"]))
		$sub_level_2_shadow = $row["shadow"];
	else
		$sub_level_2_shadow = 0;
	if (!is_null($row["shadow_color"]))
		$sub_level_2_shadow_color = $row["shadow_color"];
	else
		$sub_level_2_shadow_color = _NOT_SET_;
	if ((!is_null($row["shadow_x_offset"])) && ($row["shadow_x_offset"] != 0))
		$sub_level_2_shadow_x_offset = $row["shadow_x_offset"];
	else
		$sub_level_2_shadow_x_offset = _NOT_SET_;
	if ((!is_null($row["shadow_y_offset"])) && ($row["shadow_y_offset"] != 0))
		$sub_level_2_shadow_y_offset = $row["shadow_y_offset"];
	else
		$sub_level_2_shadow_y_offset = _NOT_SET_;
	if ((!is_null($row["shadow_blur"])) && ($row["shadow_blur"] != 0))
		$sub_level_2_shadow_blur = $row["shadow_blur"];
	else
		$sub_level_2_shadow_blur = _NOT_SET_;
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_2_text_color = "#336699";
	else
		$sub_level_2_text_color = _NOT_SET_;
		

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.top_level_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$top_level_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$top_level_text_color_hover = "#FFFFFF";
	else
		$top_level_text_color_hover = _NOT_SET_;
		
//////////////////// new /////////////////////////////////////
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_1_text_color_hover = "#FFFFFF";
	else
		$sub_level_1_text_color_hover = _NOT_SET_;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_2_li" . $suffix . " A:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_2_text_color_hover = $row["text_color"];
	elseif($load_defaults == 1)
		$sub_level_2_text_color_hover = "#FFFFFF";
	else
		$sub_level_2_text_color_hover = _NOT_SET_;
//////////////////////////////////////////////////////////////

	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li:hover, .nav" . $suffix . " ul li a:hover'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);

	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_hover = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$top_level_background_color_hover = "#336699";
	else
		$top_level_background_color_hover = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_hover = $row["border_color"];
	else
		$top_level_item_border_color_hover = _NOT_SET_;
		
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul, .nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$sub_level_background_color = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$sub_level_background_color = "#FFFFFF";
	else
		$sub_level_background_color = _NOT_SET_;
		
	
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ">li'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color = $row["bkgd_color"];
	elseif($load_defaults == 1)
		$top_level_background_color = "#FFFFFF";
	else
		$top_level_background_color = _NOT_SET_;
	if ($row["border"] > -1)
		$top_level_item_border_width = $row["border"];
	else
		$top_level_item_border_width = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color = $row["border_color"];
	else
		$top_level_item_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_item_border_top = 1;
		else
			$top_level_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_item_border_bottom = 1;
		else
			$top_level_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_item_border_left = 1;
		else
			$top_level_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_item_border_right = 1;
		else
			$top_level_item_border_right = 0;
	}
	else
	{
		$top_level_item_border_top = 1;
		$top_level_item_border_bottom = 1;
		$top_level_item_border_left = 1;
		$top_level_item_border_right = 1;
	}
		
		
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . ", .nav" . $suffix . " ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$top_level_block_border_width = $row["border"];
	elseif($load_defaults == 1)
		$top_level_block_border_width = 1;
	else
		$top_level_block_border_width = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_block_border_color = $row["border_color"];
	elseif($load_defaults == 1)
		$top_level_block_border_color = "#336699";
	else
		$top_level_block_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$top_level_block_border_top = 1;
		else
			$top_level_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$top_level_block_border_bottom = 1;
		else
			$top_level_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$top_level_block_border_left = 1;
		else
			$top_level_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$top_level_block_border_right = 1;
		else
			$top_level_block_border_right = 0;
	}
	else
	{
		$top_level_block_border_top = 1;
		$top_level_block_border_bottom = 1;
		$top_level_block_border_left = 1;
		$top_level_block_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li>ul'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$sub_level_block_border_width = $row["border"];
	elseif($load_defaults == 1)
		$sub_level_block_border_width = 1;
	else
		$sub_level_block_border_width = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_block_border_color = $row["border_color"];
	elseif($load_defaults == 1)
		$sub_level_block_border_color = "#336699";
	else
		$sub_level_block_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_block_border_top = 1;
		else
			$sub_level_block_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_block_border_bottom = 1;
		else
			$sub_level_block_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_block_border_left = 1;
		else
			$sub_level_block_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_block_border_right = 1;
		else
			$sub_level_block_border_right = 0;
	}
	else
	{
		$sub_level_block_border_top = 1;
		$sub_level_block_border_bottom = 1;
		$sub_level_block_border_left = 1;
		$sub_level_block_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.nav" . $suffix . " ul li a'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["border"] > -1)
		$sub_level_item_border_width = $row["border"];
	else
		$sub_level_item_border_width = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$sub_level_item_border_color = $row["border_color"];
	else
		$sub_level_item_border_color = _NOT_SET_;
	if (!is_null($row["border_sides"]))
	{
		$border_sides = $row["border_sides"];
		if (($border_sides & 8) == 8)
			$sub_level_item_border_top = 1;
		else
			$sub_level_item_border_top = 0;
		if (($border_sides & 4) == 4)
			$sub_level_item_border_bottom = 1;
		else
			$sub_level_item_border_bottom = 0;
		if (($border_sides & 2) == 2)
			$sub_level_item_border_left = 1;
		else
			$sub_level_item_border_left = 0;
		if (($border_sides & 1) == 1)
			$sub_level_item_border_right = 1;
		else
			$sub_level_item_border_right = 0;
	}
	else
	{
		$sub_level_item_border_top = 1;
		$sub_level_item_border_bottom = 1;
		$sub_level_item_border_left = 1;
		$sub_level_item_border_right = 1;
	}
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = 'ul.nav" . $suffix . " li:active, .nav" . $suffix . " ul li a:active'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["text_color"]) && ($row["text_color"] != ""))
		$sub_level_1_text_color_active = $row["text_color"];
	else
		$sub_level_1_text_color_active = _NOT_SET_;
	if (!is_null($row["bkgd_color"]) && ($row["bkgd_color"] != ""))
		$top_level_background_color_active = $row["bkgd_color"];
	else
		$top_level_background_color_active = _NOT_SET_;
	if (!is_null($row["border_color"]) && ($row["border_color"] != ""))
		$top_level_item_border_color_active = $row["border_color"];
	else
		$top_level_item_border_color_active = _NOT_SET_;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.top_level_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_opacity"]) && ($row["bkgd_opacity"] > 0))
		$top_level_background_opacity = $row["bkgd_opacity"];
	else
		$top_level_background_opacity = _NOT_SET_;
		
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . $menu_css_table . " WHERE class = '.sub_level_1_ul" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["bkgd_opacity"]) && ($row["bkgd_opacity"] > 0))
		$sub_level_background_opacity = $row["bkgd_opacity"];
	else
		$sub_level_background_opacity = _NOT_SET_;
?>

<form name="frm_menu_styles" id="frm_menu_styles" action="save_css_menu_styles.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td>
      <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
        <tr>
          <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_FONT; ?></td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo FONT_WORD; ?>:</td>
                <td>
                  <select name="top_level_font" id="top_level_font">
                    <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo " class='not_set'>-not selected-</option>\n";
						  
					 	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $top_level_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					  ?>
                    </select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
                  </td>
                <td align="right"><?php echo SIZE_WORD; ?>: </td>
                <td>
                  <input name="top_level_font_size" type="text" id="top_level_font_size" size="10" value="<?php echo $top_level_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                  <select name="top_level_font_size_units" id="top_level_font_size_units" onChange="enable_disable_font_size('top_level_font_size', 'top_level_font_size_units');">
                    <option value="px"<?php if ($top_level_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
                <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
                <td>
                  <select name="top_level_weight" id="top_level_weight">
                    <option value="-not selected-" <?php if ($top_level_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="normal" <?php if ($top_level_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="bold" <?php if ($top_level_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
                    <option value="bolder" <?php if ($top_level_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
                    <option value="lighter" <?php if ($top_level_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
                    <option value="100" <?php if ($top_level_weight == "100") echo " selected='selected'"; ?>>100</option>
                    <option value="200" <?php if ($top_level_weight == "200") echo " selected='selected'"; ?>>200</option>
                    <option value="300" <?php if ($top_level_weight == "300") echo " selected='selected'"; ?>>300</option>
                    <option value="400" <?php if ($top_level_weight == "400") echo " selected='selected'"; ?>>400</option>
                    <option value="500" <?php if ($top_level_weight == "500") echo " selected='selected'"; ?>>500</option>
                    <option value="600" <?php if ($top_level_weight == "600") echo " selected='selected'"; ?>>600</option>
                    <option value="700" <?php if ($top_level_weight == "700") echo " selected='selected'"; ?>>700</option>
                    <option value="800" <?php if ($top_level_weight == "800") echo " selected='selected'"; ?>>800</option>
                    <option value="900" <?php if ($top_level_weight == "900") echo " selected='selected'"; ?>>900</option>
                    </select>
                  </td>
                <td align="right"><?php echo LETTER_SPACING; ?>:</td>
                <td>
                   <input name="top_level_letter_spacing" type="text" id="top_level_letter_spacing" value="<?php if ($top_level_letter_spacing_units < 3) echo intval($top_level_letter_spacing); else echo $top_level_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="top_level_letter_spacing_units" id="top_level_letter_spacing_units" onChange="CheckLetterSpacing(this, 'top_level_letter_spacing');">
                    <option value="-1"<?php if ($top_level_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($top_level_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($top_level_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($top_level_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($top_level_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($top_level_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($top_level_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($top_level_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($top_level_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($top_level_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($top_level_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($top_level_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($top_level_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($top_level_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($top_level_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($top_level_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($top_level_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($top_level_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td>
            <table width="100%" class="layout_box_table">
              <tr>
                <td align="right"><?php echo ITALIC_WORD; ?>:</td>
                <td>
                  <input name="top_level_italic" type="checkbox" id="top_level_italic" value="1" <?php if ($top_level_italic == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_underline" type="checkbox" id="top_level_underline" value="1" <?php if ($top_level_underline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
                <td>
                  <input name="top_level_overline" type="checkbox" id="top_level_overline" value="1" <?php if ($top_level_overline == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo BLINK_WORD; ?>:</td>
                <td>
                  <input name="top_level_blink" type="checkbox" id="top_level_blink" value="1" <?php if ($top_level_blink == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
                <td>
                  <input name="top_level_oblique" type="checkbox" id="top_level_oblique" value="1" <?php if ($top_level_oblique == 1) echo "checked='checked'"; ?>>
                  </td>
                <td align="right"><?php echo SMALL_CAPS; ?>:</td>
                <td>
                  <input name="top_level_small_caps" type="checkbox" id="top_level_small_caps" value="1" <?php if ($top_level_small_caps == 1) echo "checked='checked'"; ?>>
                  </td>
                </tr>
              </table>
            </td>
          </tr>
        <tr>
          <td align="right" class="small_message"><table class="layout_box_table" width="100%">
            <tr>
              <td align="center"><?php echo SHADOW_WORD; ?>:
                <input name="top_level_shadow" type="checkbox" id="top_level_shadow" value="1" <?php if ($top_level_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
              <td align="center"><?php echo COLOR_WORD; ?>:
                <input name="top_level_shadow_color" type="text" id="top_level_shadow_color" value="<?php echo $top_level_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color');" class="small_message"><?php echo RGB_WORD; ?></a></td>
              <td align="center"><?php echo X_OFFSET_WORD; ?>:
                <input name="top_level_shadow_x_offset" type="text" id="top_level_shadow_x_offset" value="<?php echo $top_level_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
              <td align="center"><?php echo Y_OFFSET_WORD; ?>:
                <input name="top_level_shadow_y_offset" type="text" id="top_level_shadow_y_offset" value="<?php echo $top_level_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
              <td align="center"><?php echo BLUR_WORD; ?>:
                <input name="top_level_shadow_blur" type="text" id="top_level_shadow_blur" value="<?php echo $top_level_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                px </td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
        </table>
      </td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_FONT; ?></td>
		  </tr>
		  <tr>
		    <td><table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo FONT_WORD; ?>:</td>
		        <td>
                <select name="sub_level_1_font" id="sub_level_1_font">
		          <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo " class='not_set'>-not selected-</option>\n";
							
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $sub_level_1_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>  
                </td>
		        <td align="right"><?php echo SIZE_WORD; ?>: </td>
		        <td>
                <input name="sub_level_1_font_size" type="text" id="sub_level_1_font_size" size="10" value="<?php echo $sub_level_1_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          <select name="sub_level_1_font_size_units" id="sub_level_1_font_size_units" onChange="enable_disable_font_size('sub_level_1_font_size', 'sub_level_1_font_size_units');">
                    <option value="px"<?php if ($sub_level_1_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
		        <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
		        <td><select name="sub_level_1_weight" id="sub_level_1_weight">
		          <option value="-not selected-" <?php if ($sub_level_1_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
		          <option value="normal" <?php if ($sub_level_1_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
		          <option value="bold" <?php if ($sub_level_1_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
		          <option value="bolder" <?php if ($sub_level_1_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
		          <option value="lighter" <?php if ($sub_level_1_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
		          <option value="100" <?php if ($sub_level_1_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_1_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_1_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_1_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_1_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_1_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_1_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_1_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_1_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right"><?php echo LETTER_SPACING; ?>:</td>
		        <td> 
                  <input name="sub_level_1_letter_spacing" type="text" id="sub_level_1_letter_spacing" value="<?php if ($sub_level_1_letter_spacing_units < 3) echo intval($sub_level_1_letter_spacing); else echo $sub_level_1_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_1_letter_spacing_units" id="sub_level_1_letter_spacing_units" onChange="CheckLetterSpacing(this, 'sub_level_1_letter_spacing');">
                    <option value="-1"<?php if ($sub_level_1_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_1_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_1_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_1_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_1_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_1_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_1_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_1_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_1_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_1_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_1_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_1_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_1_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_1_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_1_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_1_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_1_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_1_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
                  </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td><table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo ITALIC_WORD; ?>:</td>
		        <td><input name="sub_level_1_italic" type="checkbox" id="sub_level_1_italic" value="1" <?php if ($sub_level_1_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_1_underline" type="checkbox" id="sub_level_1_underline" value="1" <?php if ($sub_level_1_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_1_overline" type="checkbox" id="sub_level_1_overline" value="1" <?php if ($sub_level_1_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo BLINK_WORD; ?>:</td>
		        <td><input name="sub_level_1_blink" type="checkbox" id="sub_level_1_blink" value="1" <?php if ($sub_level_1_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
		        <td><input name="sub_level_1_oblique" type="checkbox" id="sub_level_1_oblique" value="1" <?php if ($sub_level_1_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo SMALL_CAPS; ?>:</td>
		        <td><input name="sub_level_1_small_caps" type="checkbox" id="sub_level_1_small_caps" value="1" <?php if ($sub_level_1_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><table class="layout_box_table" width="100%">
		      <tr>
		        <td align="center"><?php echo SHADOW_WORD; ?>:
		          <input name="sub_level_1_shadow" type="checkbox" id="sub_level_1_shadow" value="1" <?php if ($sub_level_1_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
		        <td align="center"><?php echo COLOR_WORD; ?>:
		          <input name="sub_level_1_shadow_color" type="text" id="sub_level_1_shadow_color" value="<?php echo $sub_level_1_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
<a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color');" class="small_message"><?php echo RGB_WORD; ?></a></td>
		        <td align="center"><?php echo X_OFFSET_WORD; ?>:
		          <input name="sub_level_1_shadow_x_offset" type="text" id="sub_level_1_shadow_x_offset" value="<?php echo $sub_level_1_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo Y_OFFSET_WORD; ?>:
		          <input name="sub_level_1_shadow_y_offset" type="text" id="sub_level_1_shadow_y_offset" value="<?php echo $sub_level_1_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo BLUR_WORD; ?>:
		          <input name="sub_level_1_shadow_blur" type="text" id="sub_level_1_shadow_blur" value="<?php echo $sub_level_1_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td class="bold"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_FONT; ?></td>
		  </tr>
		  <tr>
		    <td><table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo FONT_WORD; ?>:</td>
		        <td>
                  <select name="sub_level_2_font" id="sub_level_2_font">
		          <?php
						echo "<option value='-not selected-'";
						if ($font == "-not selected-")
							echo " selected='selected'";
						echo " class='not_set'>-not selected-</option>\n";
						  
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$tmp_font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$tmp_font' style='font-family:$tmp_font;'";
							if ($tmp_font == $sub_level_2_font)
								echo " selected='selected'";
							echo ">$tmp_font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
				?>
		          </select>
                  <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
                </td>
		        <td align="right"><?php echo SIZE_WORD; ?>: </td>
		        <td>
                <input name="sub_level_2_font_size" type="text" id="sub_level_2_font_size" size="10" value="<?php echo $sub_level_2_font_size; ?>" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          <select name="sub_level_2_font_size_units" id="sub_level_2_font_size_units" onChange="enable_disable_font_size('sub_level_2_font_size', 'sub_level_2_font_size_units');">
                    <option value="px"<?php if ($sub_level_2_font_size_units == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_units == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_units == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_units == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_units == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_units == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_units == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_units == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_units == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_units == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_units == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_units == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_units == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_units == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_units == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_units == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_units == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_units == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_units == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_units == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_units == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_units == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_units == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_units == "initial") echo " selected"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_units == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                </select> 
                </td>
		        <td align="right"><?php echo WEIGHT_WORD; ?>: </td>
		        <td><select name="sub_level_2_weight" id="sub_level_2_weight">
		          <option value="-not selected-" <?php if ($sub_level_2_weight == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
		          <option value="normal" <?php if ($sub_level_2_weight == "normal") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
		          <option value="bold" <?php if ($sub_level_2_weight == "bold") echo " selected='selected'"; ?>><?php echo BOLD_WORD; ?></option>
		          <option value="bolder" <?php if ($sub_level_2_weight == "bolder") echo " selected='selected'"; ?>><?php echo BOLDER_WORD; ?></option>
		          <option value="lighter" <?php if ($sub_level_2_weight == "lighter") echo " selected='selected'"; ?>><?php echo LIGHTER_WORD; ?></option>
		          <option value="100" <?php if ($sub_level_2_weight == "100") echo " selected='selected'"; ?>>100</option>
		          <option value="200" <?php if ($sub_level_2_weight == "200") echo " selected='selected'"; ?>>200</option>
		          <option value="300" <?php if ($sub_level_2_weight == "300") echo " selected='selected'"; ?>>300</option>
		          <option value="400" <?php if ($sub_level_2_weight == "400") echo " selected='selected'"; ?>>400</option>
		          <option value="500" <?php if ($sub_level_2_weight == "500") echo " selected='selected'"; ?>>500</option>
		          <option value="600" <?php if ($sub_level_2_weight == "600") echo " selected='selected'"; ?>>600</option>
		          <option value="700" <?php if ($sub_level_2_weight == "700") echo " selected='selected'"; ?>>700</option>
		          <option value="800" <?php if ($sub_level_2_weight == "800") echo " selected='selected'"; ?>>800</option>
		          <option value="900" <?php if ($sub_level_2_weight == "900") echo " selected='selected'"; ?>>900</option>
		          </select></td>
		        <td align="right"><?php echo LETTER_SPACING; ?>:</td>
		        <td>             
                  <input name="sub_level_2_letter_spacing" type="text" id="sub_level_2_letter_spacing" value="<?php if ($sub_level_2_letter_spacing_units < 3) echo intval($sub_level_2_letter_spacing); else echo $sub_level_2_letter_spacing; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                   <select name="sub_level_2_letter_spacing_units" id="sub_level_2_letter_spacing_units" onChange="CheckLetterSpacing(this, 'sub_level_2_letter_spacing');">
                    <option value="-1"<?php if ($sub_level_2_letter_spacing_units == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                    <option value="0"<?php if ($sub_level_2_letter_spacing_units == "0") echo " selected='selected'"; ?>><?php echo NORMAL_WORD; ?></option>
                    <option value="1"<?php if ($sub_level_2_letter_spacing_units == "1") echo " selected='selected'"; ?>>px</option>
                    <option value="2"<?php if ($sub_level_2_letter_spacing_units == "2") echo " selected='selected'"; ?>>%</option>
                    <option value="3"<?php if ($sub_level_2_letter_spacing_units == "3") echo " selected='selected'"; ?>>em</option>
                    <option value="4"<?php if ($sub_level_2_letter_spacing_units == "4") echo " selected='selected'"; ?>>pt</option>
                    <option value="5"<?php if ($sub_level_2_letter_spacing_units == "5") echo " selected='selected'"; ?>>pc</option>
                    <option value="6"<?php if ($sub_level_2_letter_spacing_units == "6") echo " selected='selected'"; ?>>cm</option>
                    <option value="7"<?php if ($sub_level_2_letter_spacing_units == "7") echo " selected='selected'"; ?>>mm</option>
                    <option value="8"<?php if ($sub_level_2_letter_spacing_units == "8") echo " selected='selected'"; ?>>in</option>
                    <option value="9"<?php if ($sub_level_2_letter_spacing_units == "9") echo " selected='selected'"; ?>>rem</option>
                    <option value="10"<?php if ($sub_level_2_letter_spacing_units == "10") echo " selected='selected'"; ?>>vw</option>
                    <option value="11"<?php if ($sub_level_2_letter_spacing_units == "11") echo " selected='selected'"; ?>>vh</option>
                    <option value="12"<?php if ($sub_level_2_letter_spacing_units == "12") echo " selected='selected'"; ?>>vmin</option>
                    <option value="13"<?php if ($sub_level_2_letter_spacing_units == "13") echo " selected='selected'"; ?>>vmax</option>
                    <option value="14"<?php if ($sub_level_2_letter_spacing_units == "14") echo " selected='selected'"; ?>>ch</option>
                    <option value="15"<?php if ($sub_level_2_letter_spacing_units == "15") echo " selected='selected'"; ?>><?php echo INITIAL_LC_WORD; ?></option>
                    <option value="16"<?php if ($sub_level_2_letter_spacing_units == "16") echo " selected='selected'"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                   </select>
		          </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td><table width="100%" class="layout_box_table">
		      <tr>
		        <td align="right"><?php echo ITALIC_WORD; ?>:</td>
		        <td><input name="sub_level_2_italic" type="checkbox" id="sub_level_2_italic" value="1" <?php if ($sub_level_2_italic == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo UNDERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_2_underline" type="checkbox" id="sub_level_2_underline" value="1" <?php if ($sub_level_2_underline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OVERLINE_WORD; ?>:</td>
		        <td><input name="sub_level_2_overline" type="checkbox" id="sub_level_2_overline" value="1" <?php if ($sub_level_2_overline == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo BLINK_WORD; ?>:</td>
		        <td><input name="sub_level_2_blink" type="checkbox" id="sub_level_2_blink" value="1" <?php if ($sub_level_2_blink == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo OBLIQUE_WORD; ?>:</td>
		        <td><input name="sub_level_2_oblique" type="checkbox" id="sub_level_2_oblique" value="1" <?php if ($sub_level_2_oblique == 1) echo "checked='checked'"; ?>></td>
		        <td align="right"><?php echo SMALL_CAPS; ?>:</td>
		        <td><input name="sub_level_2_small_caps" type="checkbox" id="sub_level_2_small_caps" value="1" <?php if ($sub_level_2_small_caps == 1) echo "checked='checked'"; ?>></td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><table class="layout_box_table" width="100%">
		      <tr>
		        <td align="center"><?php echo SHADOW_WORD; ?>:		          
		          <input name="sub_level_2_shadow" type="checkbox" id="sub_level_2_shadow" value="1" <?php if ($sub_level_2_shadow == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('<?php echo $tagid; ?>');"></td>
		        <td align="center"><?php echo COLOR_WORD; ?>:
		          <input name="sub_level_2_shadow_color" type="text" id="sub_level_2_shadow_color" value="<?php echo $sub_level_2_shadow_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		          <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color');" class="small_message"><?php echo RGB_WORD; ?></a></td>
		        <td align="center"><?php echo X_OFFSET_WORD; ?>:
		          <input name="sub_level_2_shadow_x_offset" type="text" id="sub_level_2_shadow_x_offset" value="<?php echo $sub_level_2_shadow_x_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo Y_OFFSET_WORD; ?>:
		          <input name="sub_level_2_shadow_y_offset" type="text" id="sub_level_2_shadow_y_offset" value="<?php echo $sub_level_2_shadow_y_offset; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        <td align="center"><?php echo BLUR_WORD; ?>:
		          <input name="sub_level_2_shadow_blur" type="text" id="sub_level_2_shadow_blur" value="<?php echo $sub_level_2_shadow_blur; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		          px </td>
		        </tr>
		      </table></td>
		    </tr>
		  <tr>
		    <td align="right" class="small_message"><?php echo EDIT_CSS_MENU_STYLES_UNDERLINE_NOTE; ?></td></tr>
	   </table>
	</td>
  </tr>
  <tr>
    <td>
	   <table class="layout_box_table" width="100%" cellspacing="1" cellpadding="1">
	      <tr>
			 <td colspan="9" class="bold"><?php echo EDIT_CSS_MENU_STYLES_COLORS_BACKGROUND; ?></td>
		  </tr>
		  <tr>
          	<td>&nbsp;</td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_NORMAL_MOUSE_OUT; ?></td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_HOVER_MOUSE_OVER; ?></td>
			<td class="bold"><?php echo EDIT_CSS_MENU_STYLES_ACTIVE_MOUSE_CLICK; ?></td>
			<td class="bold">&nbsp;</td>
            <td align="center" rowspan="8" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_TOP_BORDER_VERTICAL; ?></td>
            <td  align="center" rowspan="8" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_BOTTOM_BORDER_VERTICAL; ?></td>
            <td align="center" rowspan="8" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_LEFT_BORDER_VERTICAL; ?></td>
            <td  align="center" rowspan="8" valign="bottom" class="bold"><?php echo EDIT_CSS_MENU_STYLES_RIGHT_BORDER_VERTICAL; ?></td>
		  </tr>
		  <tr>
			<td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_TEXT_COLOR; ?>: </td>
            <td align="left"><input name="top_level_text_color" type="text" id="top_level_text_color" value="<?php echo $top_level_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color');"><?php echo RGB_WORD; ?>
              
              </a></span></td>
			<td><input name="top_level_text_color_hover" type="text" id="top_level_text_color_hover" value="<?php echo $top_level_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_hover');"><?php echo RGB_WORD; ?></a></span></td>
			<td class="small_message"><?php echo NA_WORD; ?></td>
			<td>&nbsp;</td>
		  </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_1_TEXT_COLOR; ?>: </td>
		    <td align="left"><input name="sub_level_1_text_color" type="text" id="sub_level_1_text_color" value="<?php echo $sub_level_1_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color');"><?php echo RGB_WORD; ?>
		        
		        
		        </a></span></td>
		    <td><input name="sub_level_1_text_color_hover" type="text" id="sub_level_1_text_color_hover" value="<?php echo $sub_level_1_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_hover');"><?php echo RGB_WORD; ?></a></span></td>
		    <td><input name="sub_level_1_text_color_active" type="text" id="sub_level_1_text_color_active" value="<?php echo $sub_level_1_text_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_active');"><?php echo RGB_WORD; ?></a></span></td>
		    <td>&nbsp;</td>
            
		    </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_2_TEXT_COLOR; ?>: </td>
		    <td align="left"><input name="sub_level_2_text_color" type="text" id="sub_level_2_text_color" value="<?php echo $sub_level_2_text_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color');"><?php echo RGB_WORD; ?>
		        
		        </a></span></td>
		    <td><input name="sub_level_2_text_color_hover" type="text" id="sub_level_2_text_color_hover" value="<?php echo $sub_level_2_text_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_hover');"><?php echo RGB_WORD; ?></a></span></td>
		    <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_TOP_LEVEL_NOTE; ?></span></td>
		    <td>&nbsp;</td>
            
		  </tr>
          <tr>
          	<td colspan="4">&nbsp;</td>
            <td><span class="bold"><?php echo OPACITY_WORD; ?></span></td>
          </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_BACKGROUND_COLOR; ?>:</td>
		    <td><input name="top_level_background_color" type="text" id="top_level_background_color" value="<?php echo $top_level_background_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color');"><?php echo RGB_WORD; ?></a></span></td>
		    <td><input name="top_level_background_color_hover" type="text" id="top_level_background_color_hover" value="<?php echo $top_level_background_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_hover');"><?php echo RGB_WORD; ?></a></span></td>
		    <td><input name="top_level_background_color_active" type="text" id="top_level_background_color_active" value="<?php echo $top_level_background_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_background_color_active');"><?php echo RGB_WORD; ?></a></span></td>
		    <td><input name="top_level_background_opacity" type="text" id="top_level_background_opacity" value="<?php echo $top_level_background_opacity; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		    %</td>
            
		    </tr>
		  <tr>
		    <td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_BACKGROUND_COLOR; ?>: </td>
		    <td><input name="sub_level_background_color" type="text" id="sub_level_background_color" value="<?php echo $sub_level_background_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
		      <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_background_color');"><?php echo RGB_WORD; ?></a></span></td>
		    <td class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_TOP_LEVEL_NOTE; ?></td>
		    <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_TOP_LEVEL_NOTE; ?></span></td>
		    <td><input name="sub_level_background_opacity" type="text" id="sub_level_background_opacity" value="<?php echo $sub_level_background_opacity; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
		      %</td>
           
		    </tr>
          <tr>
          	<td colspan="4">&nbsp;</td>
            <td><span class="bold"><?php echo WIDTH_WORD; ?></span></td>
          </tr>
          <tr>
            <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_BLOCK_BORDER_COLOR; ?>:</td>
            <td><input name="top_level_block_border_color" type="text" id="top_level_block_border_color" value="<?php echo $top_level_block_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_block_border_color');"><?php echo RGB_WORD; ?></a></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_NORMAL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><input name="top_level_block_border_width" type="text" id="top_level_block_border_width" value="<?php echo $top_level_block_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
              px</td>
              <td>
              	<input name="top_level_block_border_top" type="checkbox" id="top_level_block_border_top" value="1" <?php if ($top_level_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_bottom" type="checkbox" id="top_level_block_border_bottom" value="1" <?php if ($top_level_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_left" type="checkbox" id="top_level_block_border_left" value="1" <?php if ($top_level_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_block_border_right" type="checkbox" id="top_level_block_border_right" value="1" <?php if ($top_level_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
          </tr>
           <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_BLOCK_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_block_border_color" type="text" id="sub_level_block_border_color" value="<?php echo $sub_level_block_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_block_border_color');"><?php echo RGB_WORD; ?></a></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_NORMAL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo NA_WORD; ?></span></td>
            <td><input name="sub_level_block_border_width" type="text" id="sub_level_block_border_width" value="<?php echo $sub_level_block_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              px</td>
              <td>
              	<input name="sub_level_block_border_top" type="checkbox" id="sub_level_block_border_top" value="1" <?php if ($sub_level_block_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_bottom" type="checkbox" id="sub_level_block_border_bottom" value="1" <?php if ($sub_level_block_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_left" type="checkbox" id="sub_level_block_border_left" value="1" <?php if ($sub_level_block_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_block_border_right" type="checkbox" id="sub_level_block_border_right" value="1" <?php if ($sub_level_block_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
            <tr>
            <td align="right"><?php echo EDIT_CSS_MENU_STYLES_TOP_LEVEL_ITEM_BORDER_COLOR; ?>:</td>
            <td><input name="top_level_item_border_color" type="text" id="top_level_item_border_color" value="<?php echo $top_level_item_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color');"><?php echo RGB_WORD; ?></a></span></td>
            <td><input name="top_level_item_border_color_hover" type="text" id="top_level_item_border_color_hover" value="<?php echo $top_level_item_border_color_hover; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_hover');"><?php echo RGB_WORD; ?></a></span></td>
            <td><input name="top_level_item_border_color_active" type="text" id="top_level_item_border_color_active" value="<?php echo $top_level_item_border_color_active; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_item_border_color_active');"><?php echo RGB_WORD; ?></a></span></td>
            <td><input name="top_level_item_border_width" type="text" id="top_level_item_border_width" value="<?php echo $top_level_item_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              px</td>
              <td>
              	<input name="top_level_item_border_top" type="checkbox" id="top_level_item_border_top" value="1" <?php if ($top_level_item_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_bottom" type="checkbox" id="top_level_item_border_bottom" value="1" <?php if ($top_level_item_border_bottom == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_left" type="checkbox" id="top_level_item_border_left" value="1" <?php if ($top_level_item_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="top_level_item_border_right" type="checkbox" id="top_level_item_border_right" value="1" <?php if ($top_level_item_border_right == 1) echo "checked='checked'"; ?>>
              </td>
          </tr>
           <tr>
          	<td align="right"><?php echo EDIT_CSS_MENU_STYLES_SUB_LEVEL_ITEM_BORDER_COLOR; ?>:</td>
            <td><input name="sub_level_item_border_color" type="text" id="sub_level_item_border_color" value="<?php echo $sub_level_item_border_color; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
              <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_item_border_color');"><?php echo RGB_WORD; ?></a></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_TOP_LEVEL_NOTE; ?></span></td>
            <td><span class="small_message"><?php echo EDIT_CSS_MENU_STYLES_SAME_AS_TOP_LEVEL_NOTE; ?></span></td>
            <td><input name="sub_level_item_border_width" type="text" id="sub_level_item_border_width" value="<?php echo $sub_level_item_border_width; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
              px</td>
              <td>
              	<input name="sub_level_item_border_top" type="checkbox" id="sub_level_item_border_top" value="1" <?php if ($sub_level_item_border_top == 1) echo "checked='checked'"; ?>>
              </td>
              <td><input name="sub_level_item_border_bottom" type="checkbox" id="sub_level_item_border_bottom" value="1" <?php if ($sub_level_item_border_bottom == 1) echo "checked='checked'"; ?>></td>
              <td>
              	<input name="sub_level_item_border_left" type="checkbox" id="sub_level_item_border_left" value="1" <?php if ($sub_level_item_border_left == 1) echo "checked='checked'"; ?>>
              </td>
              <td>
              	<input name="sub_level_item_border_right" type="checkbox" id="sub_level_item_border_right" value="1" <?php if ($sub_level_item_border_right == 1) echo "checked='checked'"; ?>>
              </td>
       	  </tr>
	   </table>
	</td>
  </tr>
</table>
<table width="90%" class="layout_box_table" cellspacing="0" cellpadding="0">
  <tr><td colspan="3">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
          <input type="hidden" name="operation" id="operation" />
		</td>
        <td align="center">
          <div class='button_console_save' style="width:110px;" onClick="SaveMenuStyles();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
		</td>
	  </tr>
</table>
</form>
</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	enable_disable_controls();
	HidePopupMsg();
</script>

</body>
</html>