<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Revised: 9/20/2008
// Modified to allow for no background colors or border.
// Revised: 9/22/2008	ELL
// Added text shadow effects.
// Revised: 11/13/08	ELL
// Fixed bug of not saving data if no shadow selected.  Bug caused by '' in SQL string.  Replaed with '-none-'.
// '-none-' will be captured in build_menu_css_string.php.
// Added GET of source page to allow color picker to populate CSS editor properly. 
// Revised: 1/9/2011	ELL
// Added capability to handle multiple JavaScript Menus.
// Revised: 2/19/2011	ELL
// Added hex color code validation.
// Revised: 2/8/2012	ELL
// Added table prefix handling.
// Revised: 11/8/2012	ELL
// Added injection of current color for initializing color picker.
// Revised: 5/15/2013	ELL
// Added text alignment, box shadow, and independent top, bottom, left, right padding.
// Revised: 4/5/2015	ELL
// Added font size units.
// Converted save operation to AJAX.
// Revamped preview to show actual popup page.
	
	include ("check_session.php");
	
	$menu = $_REQUEST['menu'];
	if (!isset($menu))
		$menu = $_SESSION['last_menu_edited'];
	else
		$_SESSION['last_menu_edited'] = $menu;
	
	$suffix = substr($menu, 4);
	$suffix = str_replace("_mobile", "", $suffix);
?>
<!DOCTYPE html>
<html>
<head>
<title>Editing <?php echo $menu; ?> JS Menu Styles | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<style type="text/css">
#js_menu_styles_heading	{	width:350px;	}
#help_button	{	
	position:relative;
	display:block;
	top:-15px;
	left:310px;
	height:31px;
	width:31px;
	z-index:100;
}

#page_select_div	{
	left: 300px;
}
</style>

<script type="text/javascript" src="js/check_color_str.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/jquery.min.js"></script>
<script src="js/edit_js_menu_styles.js"></script>

<script>
<?php
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG = \"" . EDIT_CSS_MENU_STYLES_SAVE_SUCCESS_MSG . "\";\n";
	echo "	var EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR = \"" . EDIT_CSS_MENU_STYLES_SAVE_FAIL_ERR . "\";\n";
	echo "	var _NOT_SELECTED_ = \"" . _NOT_SELECTED_ . "\";\n";
	echo "	var _NOT_SET_ = \"" . _NOT_SET_ . "\";\n";
?>
</script>

</head>

<body onLoad="InitializeForm();" id="workspace_body">
<div align="center">
<table width="90%" border="0" cellspacing="0" cellpadding="0">
<tr>
<td>
<div class="button_heading_sub_level_1" id="js_menu_styles_heading"><div class="button_heading_text_sub_level_1"><?php echo EDIT_JS_MENU_STYLES_HEADING; ?></div><div class="help_button" id="help_button" onClick="OpenHelpWindow();">&nbsp;</div></div>
</td>
<td class="bold" width="40%">
<?php echo EDIT_JS_MENU_STYLES_SELECT_MENU; ?>:
<select name="selectMenu" id="selectMenu" onChange="javascript:SelectMenu(this.value);">
    <option value="-not selected-"><?php echo _NOT_SELECTED_; ?></option>
<?php
	$got_wrong_menu_type = true;
	$query = "SELECT * FROM `" . BWB_TABLE_PREFIX . "menus` WHERE `menu_type` = 1";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$menu_name = $row['menu_name'];
		$description = $row['description'];
		if ($menu_name == $menu)	{
			echo "<option value='$menu_name' selected='selected'>$description</option>\n";
			$got_wrong_menu_type = false;
		}
		else
			echo "<option value='$menu_name'>$description</option>\n";
	}
	
	if ($got_wrong_menu_type === true)
		$menu = "-not selected-";
?>
</select>
</td>
</tr>
</table>

<?php
if (($menu == "-not selected-") || ($menu == ""))
{
	echo EDIT_JS_MENU_STYLES_SELECT_MENU_MSG;
	exit;
}
else
{	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["align"])) $top_level_align = $row["align"];
	else $top_level_align = "-not selected-";
	if (!is_null($row["vertical_align"])) $top_level_vertical_align = $row["vertical_align"];
	else $top_level_vertical_align = "-not selected-";
	if ($row["font"]) $top_level_font_out = $row["font"];
	else $top_level_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $top_level_font_size_out = $row["font_size"];
	else $top_level_font_size_out = 12;
	if (!is_null($row["font_size_units"])) $top_level_font_size_units_out = $row["font_size_units"];
	else $top_level_font_size_units_out = "px";
	if ($row["text_color"]) $top_level_text_color_out = $row["text_color"];
	else $top_level_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $top_level_padding_top_out = $row["padding_top"];
	else $top_level_padding_top_out = 4;
	if (!is_null($row["padding_right"])) $top_level_padding_right_out = $row["padding_right"];
	else $top_level_padding_right_out = 4;
	if (!is_null($row["padding_bottom"])) $top_level_padding_bottom_out = $row["padding_bottom"];
	else $top_level_padding_bottom_out = 4;
	if (!is_null($row["padding_left"])) $top_level_padding_left_out = $row["padding_left"];
	else $top_level_padding_left_out = 4;
	if ($row["weight"]) $top_level_bold_out = $row["weight"];
	else $top_level_bold_out = "-not selected-";
	if ($row["italic"]) $top_level_italic_out = $row["italic"];
	else $top_level_italic_out = 0;
	if ($row["underline"]) $top_level_underline_out = $row["underline"];
	else $top_level_underline_out = 0;
	if ($row["overline"]) $top_level_overline_out = $row["overline"];
	else $top_level_overline_out = 0;
	if ($row["blink"]) $top_level_blink_out = $row["blink"];
	else $top_level_blink_out = 0;
	if ($row["shadow"]) $top_level_shadow_out = $row["shadow"];
	else $top_level_shadow_out = 0;
	if ($row["shadow_color"]) $top_level_shadow_color_out = $row["shadow_color"];
	else $top_level_shadow_color_out = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $top_level_shadow_x_offset_out = $row["shadow_x_offset"];
	else $top_level_shadow_x_offset_out = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $top_level_shadow_y_offset_out = $row["shadow_y_offset"];
	else $top_level_shadow_y_offset_out = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $top_level_shadow_blur_out = $row["shadow_blur"];
	else $top_level_shadow_blur_out = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $top_level_font_over = $row["font"];
	else $top_level_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $top_level_font_size_over = $row["font_size"];
	else $top_level_font_size_over = 12;
	if (!is_null($row["font_size_units"])) $top_level_font_size_units_over = $row["font_size_units"];
	else $top_level_font_size_units_over = "px";
	if ($row["text_color"]) $top_level_text_color_over = $row["text_color"];
	else $top_level_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $top_level_padding_top_over = $row["padding_top"];
	else $top_level_padding_top_over = 4;
	if (!is_null($row["padding_right"])) $top_level_padding_right_over = $row["padding_right"];
	else $top_level_padding_right_over = 4;
	if (!is_null($row["padding_bottom"])) $top_level_padding_bottom_over = $row["padding_bottom"];
	else $top_level_padding_bottom_over = 4;
	if (!is_null($row["padding_left"])) $top_level_padding_left_over = $row["padding_left"];
	else $top_level_padding_left_over = 4;
	if ($row["weight"]) $top_level_bold_over = $row["weight"];
	else $top_level_bold_over = "-not selected-";
	if ($row["italic"]) $top_level_italic_over = $row["italic"];
	else $top_level_italic_over = 0;
	if (!is_null($row["underline"])) $top_level_underline_over = $row["underline"];
	else $top_level_underline_over = 1;
	if ($row["overline"]) $top_level_overline_over = $row["overline"];
	else $top_level_overline_over = 0;
	if ($row["blink"]) $top_level_blink_over = $row["blink"];
	else $top_level_blink_over = 0;
	if ($row["shadow"]) $top_level_shadow_over = $row["shadow"];
	else $top_level_shadow_over = 0;
	if ($row["shadow_color"]) $top_level_shadow_color_over = $row["shadow_color"];
	else $top_level_shadow_color_over = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $top_level_shadow_x_offset_over = $row["shadow_x_offset"];
	else $top_level_shadow_x_offset_over = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $top_level_shadow_y_offset_over = $row["shadow_y_offset"];
	else $top_level_shadow_y_offset_over = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $top_level_shadow_blur_over = $row["shadow_blur"];
	else $top_level_shadow_blur_over = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $top_level_bkgd_color_out = $row["bkgd_color"];
	else $top_level_bkgd_color_out = _NOT_SET_;
	if (($row["bkgd_opacity"]) && ($row["bkgd_opacity"] != -1)) $top_level_bkgd_opacity_out = $row["bkgd_opacity"];
	else $top_level_bkgd_opacity_out = _NOT_SET_;
	if (!is_null($row["border"])) $top_level_border_out = $row["border"];
	else $top_level_border_out = 1;
	if ($row["border_color"]) $top_level_border_color_out = $row["border_color"];
	else $top_level_border_color_out = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $top_level_box_shadow_horizontal_out = $row["box_shadow_horizontal"];
	else $top_level_box_shadow_horizontal_out = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $top_level_box_shadow_vertical_out = $row["box_shadow_vertical"];
	else $top_level_box_shadow_vertical_out = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $top_level_box_shadow_blur_out = $row["box_shadow_blur"];
	else $top_level_box_shadow_blur_out = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $top_level_box_shadow_spread_out = $row["box_shadow_spread"];
	else $top_level_box_shadow_spread_out = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $top_level_box_shadow_color_out = $row["box_shadow_color"];
	else $top_level_box_shadow_color_out = _NOT_SET_;
	if ($row["box_shadow_inset"]) $top_level_box_shadow_inset_out = $row["box_shadow_inset"];
	else $top_level_box_shadow_inset_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l0oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $top_level_bkgd_color_over = $row["bkgd_color"];
	else $top_level_bkgd_color_over = _NOT_SET_;
	if (!is_null($row["border"])) $top_level_border_over = $row["border"];
	else $top_level_border_over = 1;
	if ($row["border_color"]) $top_level_border_color_over = $row["border_color"];
	else $top_level_border_color_over = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $top_level_box_shadow_horizontal_over = $row["box_shadow_horizontal"];
	else $top_level_box_shadow_horizontal_over = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $top_level_box_shadow_vertical_over = $row["box_shadow_vertical"];
	else $top_level_box_shadow_vertical_over = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $top_level_box_shadow_blur_over = $row["box_shadow_blur"];
	else $top_level_box_shadow_blur_over = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $top_level_box_shadow_spread_over = $row["box_shadow_spread"];
	else $top_level_box_shadow_spread_over = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $top_level_box_shadow_color_over = $row["box_shadow_color"];
	else $top_level_box_shadow_color_over = _NOT_SET_;
	if ($row["box_shadow_inset"]) $top_level_box_shadow_inset_over = $row["box_shadow_inset"];
	else $top_level_box_shadow_inset_over = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["align"])) $sub_level_1_align = $row["align"];
	else $sub_level_1_align = "-not selected-";
	if (!is_null($row["vertical_align"])) $sub_level_1_vertical_align = $row["vertical_align"];
	else $sub_level_1_vertical_align = "-not selected-";
	if ($row["font"]) $sub_level_1_font_out = $row["font"];
	else $sub_level_1_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_1_font_size_out = $row["font_size"];
	else $sub_level_1_font_size_out = 12;
	if (!is_null($row["font_size_units"])) $sub_level_1_font_size_units_out = $row["font_size_units"];
	else $sub_level_1_font_size_units_out = "px";
	if ($row["text_color"]) $sub_level_1_text_color_out = $row["text_color"];
	else $sub_level_1_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_1_padding_top_out = $row["padding_top"];
	else $sub_level_1_padding_top_out = 4;
	if (!is_null($row["padding_right"])) $sub_level_1_padding_right_out = $row["padding_right"];
	else $sub_level_1_padding_right_out = 4;
	if (!is_null($row["padding_bottom"])) $sub_level_1_padding_bottom_out = $row["padding_bottom"];
	else $sub_level_1_padding_bottom_out = 4;
	if (!is_null($row["padding_left"])) $sub_level_1_padding_left_out = $row["padding_left"];
	else $sub_level_1_padding_left_out = 4;
	if ($row["weight"]) $sub_level_1_bold_out = $row["weight"];
	else $sub_level_1_bold_out = "-not selected-";
	if ($row["italic"]) $sub_level_1_italic_out = $row["italic"];
	else $sub_level_1_italic_out = 0;
	if ($row["underline"]) $sub_level_1_underline_out = $row["underline"];
	else $sub_level_1_underline_out = 0;
	if ($row["overline"]) $sub_level_1_overline_out = $row["overline"];
	else $sub_level_1_overline_out = 0;
	if ($row["blink"]) $sub_level_1_blink_out = $row["blink"];
	else $sub_level_1_blink_out = 0;
	if ($row["shadow"]) $sub_level_1_shadow_out = $row["shadow"];
	else $sub_level_1_shadow_out = 0;
	if ($row["shadow_color"]) $sub_level_1_shadow_color_out = $row["shadow_color"];
	else $sub_level_1_shadow_color_out = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $sub_level_1_shadow_x_offset_out = $row["shadow_x_offset"];
	else $sub_level_1_shadow_x_offset_out = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $sub_level_1_shadow_y_offset_out = $row["shadow_y_offset"];
	else $sub_level_1_shadow_y_offset_out = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $sub_level_1_shadow_blur_out = $row["shadow_blur"];
	else $sub_level_1_shadow_blur_out = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_1_font_over = $row["font"];
	else $sub_level_1_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_1_font_size_over = $row["font_size"];
	else $sub_level_1_font_size_over = 12;
	if (!is_null($row["font_size_units"])) $sub_level_1_font_size_units_over = $row["font_size_units"];
	else $sub_level_1_font_size_units_over = "px";
	if ($row["text_color"]) $sub_level_1_text_color_over = $row["text_color"];
	else $sub_level_1_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_1_padding_top_over = $row["padding_top"];
	else $sub_level_1_padding_top_over = 4;
	if (!is_null($row["padding_right"])) $sub_level_1_padding_right_over = $row["padding_right"];
	else $sub_level_1_padding_right_over = 4;
	if (!is_null($row["padding_bottom"])) $sub_level_1_padding_bottom_over = $row["padding_bottom"];
	else $sub_level_1_padding_bottom_over = 4;
	if (!is_null($row["padding_left"])) $sub_level_1_padding_left_over = $row["padding_left"];
	else $sub_level_1_padding_left_over = 4;
	if (!is_null($row["weight"])) $sub_level_1_bold_over = $row["weight"];
	else $sub_level_1_bold_over = "-not selected-";
	if ($row["italic"]) $sub_level_1_italic_over = $row["italic"];
	else $sub_level_1_italic_over = 0;
	if ($row["underline"]) $sub_level_1_underline_over = $row["underline"];
	else $sub_level_1_underline_over = 0;
	if ($row["overline"]) $sub_level_1_overline_over = $row["overline"];
	else $sub_level_1_overline_over = 0;
	if ($row["blink"]) $sub_level_1_blink_over = $row["blink"];
	else $sub_level_1_blink_over = 0;
	if ($row["shadow"]) $sub_level_1_shadow_over = $row["shadow"];
	else $sub_level_1_shadow_over = 0;
	if ($row["shadow_color"]) $sub_level_1_shadow_color_over = $row["shadow_color"];
	else $sub_level_1_shadow_color_over = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $sub_level_1_shadow_x_offset_over = $row["shadow_x_offset_over"];
	else $sub_level_1_shadow_x_offset_over = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $sub_level_1_shadow_y_offset_over = $row["shadow_y_offset"];
	else $sub_level_1_shadow_y_offset_over = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $sub_level_1_shadow_blur_over = $row["shadow_blur"];
	else $sub_level_1_shadow_blur_over = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_1_bkgd_color_out = $row["bkgd_color"];
	else $sub_level_1_bkgd_color_out = _NOT_SET_;
	if (($row["bkgd_opacity"]) && ($row["bkgd_opacity"] != -1)) $sub_level_1_bkgd_opacity_out = $row["bkgd_opacity"];
	else $sub_level_1_bkgd_opacity_out = 85;
	if (!is_null($row["border"])) $sub_level_1_border_out = $row["border"];
	else $sub_level_1_border_out = 1;
	if ($row["border_color"]) $sub_level_1_border_color_out = $row["border_color"];
	else $sub_level_1_border_color_out = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $sub_level_1_box_shadow_horizontal_out = $row["box_shadow_horizontal"];
	else $sub_level_1_box_shadow_horizontal_out = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $sub_level_1_box_shadow_vertical_out = $row["box_shadow_vertical"];
	else $sub_level_1_box_shadow_vertical_out = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $sub_level_1_box_shadow_blur_out = $row["box_shadow_blur"];
	else $sub_level_1_box_shadow_blur_out = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $sub_level_1_box_shadow_spread_out = $row["box_shadow_spread"];
	else $sub_level_1_box_shadow_spread_out = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $sub_level_1_box_shadow_color_out = $row["box_shadow_color"];
	else $sub_level_1_box_shadow_color_out = _NOT_SET_;
	if ($row["box_shadow_inset"]) $sub_level_1_box_shadow_inset_out = $row["box_shadow_inset"];
	else $sub_level_1_box_shadow_inset_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l1oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_1_bkgd_color_over = $row["bkgd_color"];
	else $sub_level_1_bkgd_color_over = _NOT_SET_;
	if (!is_null($row["border"])) $sub_level_1_border_over = $row["border"];
	else $sub_level_1_border_over = 1;
	if ($row["border_color"]) $sub_level_1_border_color_over = $row["border_color"];
	else $sub_level_1_border_color_over = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $sub_level_1_box_shadow_horizontal_over = $row["box_shadow_horizontal"];
	else $sub_level_1_box_shadow_horizontal_over = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $sub_level_1_box_shadow_vertical_over = $row["box_shadow_vertical"];
	else $sub_level_1_box_shadow_vertical_over = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $sub_level_1_box_shadow_blur_over = $row["box_shadow_blur"];
	else $sub_level_1_box_shadow_blur_over = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $sub_level_1_box_shadow_spread_over = $row["box_shadow_spread"];
	else $sub_level_1_box_shadow_spread_over = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $sub_level_1_box_shadow_color_over = $row["box_shadow_color"];
	else $sub_level_1_box_shadow_color_over = _NOT_SET_;
	if ($row["box_shadow_inset"]) $sub_level_1_box_shadow_inset_over = $row["box_shadow_inset"];
	else $sub_level_1_box_shadow_inset_over = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2iout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if (!is_null($row["align"])) $sub_level_2_align = $row["align"];
	else $sub_level_2_align = "-not selected-";
	if (!is_null($row["vertical_align"])) $sub_level_2_vertical_align = $row["vertical_align"];
	else $sub_level_2_vertical_align = "-not selected-";
	if ($row["font"]) $sub_level_2_font_out = $row["font"];
	else $sub_level_2_font_out = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_2_font_size_out = $row["font_size"];
	else $sub_level_2_font_size_out = 12;
	if (!is_null($row["font_size_units"])) $sub_level_2_font_size_units_out = $row["font_size_units"];
	else $sub_level_2_font_size_units_out = "px";
	if ($row["text_color"]) $sub_level_2_text_color_out = $row["text_color"];
	else $sub_level_2_text_color_out = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_2_padding_top_out = $row["padding_top"];
	else $sub_level_2_padding_top_out = 4;
	if (!is_null($row["padding_right"])) $sub_level_2_padding_right_out = $row["padding_right"];
	else $sub_level_2_padding_right_out = 4;
	if (!is_null($row["padding_bottom"])) $sub_level_2_padding_bottom_out = $row["padding_bottom"];
	else $sub_level_2_padding_bottom_out = 4;
	if (!is_null($row["padding_left"])) $sub_level_2_padding_left_out = $row["padding_left"];
	else $sub_level_2_padding_left_out = 4;
	if ($row["weight"]) $sub_level_2_bold_out = $row["weight"];
	else $sub_level_2_bold_out = "-not selected-";
	if ($row["italic"]) $sub_level_2_italic_out = $row["italic"];
	else $sub_level_2_italic_out = 0;
	if ($row["underline"]) $sub_level_2_underline_out = $row["underline"];
	else $sub_level_2_underline_out = 0;
	if ($row["overline"]) $sub_level_2_overline_out = $row["overline"];
	else $sub_level_2_overline_out = 0;
	if ($row["blink"]) $sub_level_2_blink_out = $row["blink"];
	else $sub_level_2_blink_out = 0;
	if ($row["shadow"]) $sub_level_2_shadow_out = $row["shadow"];
	else $sub_level_2_shadow_out = 0;
	if ($row["shadow_color"]) $sub_level_2_shadow_color_out = $row["shadow_color"];
	else $sub_level_2_shadow_color_out = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $sub_level_2_shadow_x_offset_out = $row["shadow_x_offset"];
	else $sub_level_2_shadow_x_offset_out = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $sub_level_2_shadow_y_offset_out = $row["shadow_y_offset"];
	else $sub_level_2_shadow_y_offset_out = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $sub_level_2_shadow_blur_out = $row["shadow_blur"];
	else $sub_level_2_shadow_blur_out = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2iover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["font"]) $sub_level_2_font_over = $row["font"];
	else $sub_level_2_font_over = "Tahoma, Verdana, Geneva, Arial, Helvetica, sans-serif";
	if ($row["font_size"]) $sub_level_2_font_size_over = $row["font_size"];
	else $sub_level_2_font_size_over = 12;
	if (!is_null($row["font_size_units"])) $sub_level_2_font_size_units_over = $row["font_size_units"];
	else $sub_level_2_font_size_units_over = "px";
	if ($row["text_color"]) $sub_level_2_text_color_over = $row["text_color"];
	else $sub_level_2_text_color_over = "#000000";
	if (!is_null($row["padding_top"])) $sub_level_2_padding_top_over = $row["padding_top"];
	else $sub_level_2_padding_top_over = 4;
	if (!is_null($row["padding_right"])) $sub_level_2_padding_right_over = $row["padding_right"];
	else $sub_level_2_padding_right_over = 4;
	if (!is_null($row["padding_bottom"])) $sub_level_2_padding_bottom_over = $row["padding_bottom"];
	else $sub_level_2_padding_bottom_over = 4;
	if (!is_null($row["padding_left"])) $sub_level_2_padding_left_over = $row["padding_left"];
	else $sub_level_2_padding_left_over = 4;
	if (!is_null($row["weight"])) $sub_level_2_bold_over = $row["weight"];
	else $sub_level_2_bold_over = "-not selected-";
	if ($row["italic"]) $sub_level_2_italic_over = $row["italic"];
	else $sub_level_2_italic_over = 0;
	if ($row["underline"]) $sub_level_2_underline_over = $row["underline"];
	else $sub_level_2_underline_over = 0;
	if ($row["overline"]) $sub_level_2_overline_over = $row["overline"];
	else $sub_level_2_overline_over = 0;
	if ($row["blink"]) $sub_level_2_blink_over = $row["blink"];
	else $sub_level_2_blink_over = 0;
	if ($row["shadow"]) $sub_level_2_shadow_over = $row["shadow"];
	else $sub_level_2_shadow_over = 0;
	if ($row["shadow_color"]) $sub_level_2_shadow_color_over = $row["shadow_color"];
	else $sub_level_2_shadow_color_over = _NOT_SET_;
	if (($row["shadow_x_offset"]) && ($row["shadow_x_offset"] != -1000000)) $sub_level_2_shadow_x_offset_over = $row["shadow_x_offset"];
	else $sub_level_2_shadow_x_offset_over = _NOT_SET_;
	if (($row["shadow_y_offset"]) && ($row["shadow_y_offset"] != -1000000)) $sub_level_2_shadow_y_offset_over = $row["shadow_y_offset"];
	else $sub_level_2_shadow_y_offset_over = _NOT_SET_;
	if (($row["shadow_blur"]) && ($row["shadow_blur"] != -1)) $sub_level_2_shadow_blur_over = $row["shadow_blur"];
	else $sub_level_2_shadow_blur_over = _NOT_SET_;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2oout" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_2_bkgd_color_out = $row["bkgd_color"];
	else $sub_level_2_bkgd_color_out = _NOT_SET_;
	if (($row["bkgd_opacity"]) && ($row["bkgd_opacity"] != -1)) $sub_level_2_bkgd_opacity_out = $row["bkgd_opacity"];
	else $sub_level_2_bkgd_opacity_out = _NOT_SET_;
	if (!is_null($row["border"])) $sub_level_2_border_out = $row["border"];
	else $sub_level_2_border_out = 1;
	if ($row["border_color"]) $sub_level_2_border_color_out = $row["border_color"];
	else $sub_level_2_border_color_out = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $sub_level_2_box_shadow_horizontal_out = $row["box_shadow_horizontal"];
	else $sub_level_2_box_shadow_horizontal_out = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $sub_level_2_box_shadow_vertical_out = $row["box_shadow_vertical"];
	else $sub_level_2_box_shadow_vertical_out = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $sub_level_2_box_shadow_blur_out = $row["box_shadow_blur"];
	else $sub_level_2_box_shadow_blur_out = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $sub_level_2_box_shadow_spread_out = $row["box_shadow_spread"];
	else $sub_level_2_box_shadow_spread_out = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $sub_level_2_box_shadow_color_out = $row["box_shadow_color"];
	else $sub_level_2_box_shadow_color_out = _NOT_SET_;
	if ($row["box_shadow_inset"]) $sub_level_2_box_shadow_inset_out = $row["box_shadow_inset"];
	else $sub_level_2_box_shadow_inset_out = 0;
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "menu" . $suffix . "_css WHERE class = '.m0l2oover" . $suffix . "'";
	$result = $bwb_dbh->query($query);
	$row = $result->fetch(PDO::FETCH_ASSOC);
	if ($row["bkgd_color"]) $sub_level_2_bkgd_color_over = $row["bkgd_color"];
	else $sub_level_2_bkgd_color_over = _NOT_SET_;
	if (!is_null($row["border"])) $sub_level_2_border_over = $row["border"];
	else $sub_level_2_border_over = 1;
	if ($row["border_color"]) $sub_level_2_border_color_over = $row["border_color"];
	else $sub_level_2_border_color_over = _NOT_SET_;
	if ((isset($row["box_shadow_horizontal"])) && ($row["box_shadow_horizontal"] != -1000000)) $sub_level_2_box_shadow_horizontal_over = $row["box_shadow_horizontal"];
	else $sub_level_2_box_shadow_horizontal_over = _NOT_SET_;
	if ((isset($row["box_shadow_vertical"])) && ($row["box_shadow_vertical"] != -1000000)) $sub_level_2_box_shadow_vertical_over = $row["box_shadow_vertical"];
	else $sub_level_2_box_shadow_vertical_over = _NOT_SET_;
	if ((isset($row["box_shadow_blur"])) && ($row["box_shadow_blur"] != -1)) $sub_level_2_box_shadow_blur_over = $row["box_shadow_blur"];
	else $sub_level_2_box_shadow_blur_over = _NOT_SET_;
	if ((isset($row["box_shadow_spread"])) && ($row["box_shadow_spread"] != -1000000)) $sub_level_2_box_shadow_spread_over = $row["box_shadow_spread"];
	else $sub_level_2_box_shadow_spread_over = _NOT_SET_;
	if (isset($row["box_shadow_color"])) $sub_level_2_box_shadow_color_over = $row["box_shadow_color"];
	else $sub_level_2_box_shadow_color_over = _NOT_SET_;
	if ($row["box_shadow_inset"]) $sub_level_2_box_shadow_inset_over = $row["box_shadow_inset"];
	else $sub_level_2_box_shadow_inset_over = 0;
}
?>

<form name="frm_menu_styles" id="frm_menu_styles" action="save_js_menu_styles.php" method="post">
<table width="90%" class="group_box_table">
  <tr>
    <td>
		<table width="100%" border="0" cellspacing="1" cellpadding="1" bgcolor="#CCFFFF">
	  <tr>
		 <td class="sub_title" bgcolor="#00FFFF"><?php echo EDIT_JS_MENU_STYLES_TOP_MENU_MENU; ?></td>
	  </tr>
	  <tr><td>
	  
	  
	  
	    
		
	<!--	<table class="group_box_table" width="100%">
		  	<tr><td> -->
            <table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo TEXT_WORD; ?></td>
		     </tr>
             <tr>
             	<td>
                  <table class="layout_box_table" width="100%"><tr>
                  <td align="right"><?php echo ALIGN_WORD; ?>: </td>
                  <td>
                      <select name="top_level_align" id="top_level_align">
                      <option value="-not selected-"<?php if ($top_level_align == "-not selected-") echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                      <option value="left"<?php if ($top_level_align == "left") echo " selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                      <option value="center"<?php if ($top_level_align == "center") echo " selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                      <option value="right"<?php if ($top_level_align == "right") echo " selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                      <option value="justify"<?php if ($top_level_align == "justify") echo " selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
                      </select>
                  </td>
                  <td align="right"><!--Vertical Align:--> </td>
                  <td>
                      <select name="top_level_vertical_align" id="top_level_vertical_align" style="display:none;">
                      <option value="-not selected-"<?php if ($top_level_vertical_align == "-not selected-") echo " selected='selected'"; ?>><?php echo _NOT_SELECTED_; ?></option>
                      <option value="baseline"<?php if ($top_level_vertical_align == "baseline") echo " selected='selected'"; ?>><?php echo BASELINE_WORD; ?></option>
                      <option value="sub"<?php if ($top_level_vertical_align == "sub") echo " selected='selected'"; ?>><?php echo SUB_WORD; ?></option>
                      <option value="super"<?php if ($top_level_vertical_align == "super") echo " selected='selected'"; ?>><?php echo SUPER_WORD; ?></option>
                      <option value="top"<?php if ($top_level_vertical_align == "top") echo " selected='selected'"; ?>><?php echo TOP_1ST_CAP_WORD; ?></option>
                      <option value="text-top"<?php if ($top_level_vertical_align == "text-top") echo " selected='selected'"; ?>><?php echo TEXT_TOP; ?></option>
                      <option value="middle"<?php if ($top_level_vertical_align == "middle") echo " selected='selected'"; ?>><?php echo MIDDLE_WORD; ?></option>
                      <option value="bottom"<?php if ($top_level_vertical_align == "bottom") echo " selected='selected'"; ?>><?php echo BOTTOM_1ST_CAP_WORD; ?></option>
                      <option value="text-bottom"<?php if ($top_level_vertical_align == "text-bottom") echo " selected='selected'"; ?>><?php echo TEXT_BOTTOM; ?></option>              
                      </select>
                  </td>
                  </tr></table>
                </td>
             </tr>
				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="top_level_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $top_level_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="top_level_font_size_out" type="text" id="top_level_font_size_out" value="<?php echo $top_level_font_size_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					<select name="top_level_font_size_units_out" id="top_level_font_size_units_out" onChange="enable_disable_font_size('top_level_font_size_out', 'top_level_font_size_units_out');">
                    <option value="px"<?php if ($top_level_font_size_units_out == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_units_out == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_units_out == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_units_out == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_units_out == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_units_out == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_units_out == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_units_out == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_units_out == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_units_out == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_units_out == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_units_out == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_units_out == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_units_out == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_units_out == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_units_out == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_units_out == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_units_out == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_units_out == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_units_out == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_units_out == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_units_out == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_units_out == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_units_out == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_units_out == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                  </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="top_level_text_color_out" type="text" id="top_level_text_color_out" value="<?php echo $top_level_text_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> 
					<span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_out');"><?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="top_level_padding_top_out" type="text" id="top_level_padding_top_out" value="<?php echo intval($top_level_padding_top_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="top_level_padding_right_out" type="text" id="top_level_padding_right_out" value="<?php echo intval($top_level_padding_right_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="top_level_padding_bottom_out" type="text" id="top_level_padding_bottom_out" value="<?php echo intval($top_level_padding_bottom_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="top_level_padding_left_out" type="text" id="top_level_padding_left_out" value="<?php echo intval($top_level_padding_left_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					px
                  	</td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
							   <?php echo WEIGHT_WORD; ?>:
                              <select name="top_level_bold_out" id="top_level_bold_out">
                               <option value="-not selected-" <?php if ($top_level_bold_out == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($top_level_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($top_level_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($top_level_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($top_level_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($top_level_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($top_level_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($top_level_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($top_level_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($top_level_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($top_level_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($top_level_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($top_level_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($top_level_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="top_level_italic_out" type="checkbox" id="top_level_italic_out" value="1" <?php if ($top_level_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="top_level_underline_out" type="checkbox" id="top_level_underline_out" value="1" <?php if ($top_level_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="top_level_overline_out" type="checkbox" id="top_level_overline_out" value="1" <?php if ($top_level_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="top_level_blink_out" type="checkbox" id="top_level_blink_out" value="1" <?php if ($top_level_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="top_level_shadow_out" type="checkbox" id="top_level_shadow_out" value="1" <?php if ($top_level_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level', 'out');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="top_level_shadow_color_out" type="text" id="top_level_shadow_color_out" value="<?php echo $top_level_shadow_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_out');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="top_level_shadow_x_offset_out" type="text" id="top_level_shadow_x_offset_out" value="<?php echo $top_level_shadow_x_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="top_level_shadow_y_offset_out" type="text" id="top_level_shadow_y_offset_out" value="<?php echo $top_level_shadow_y_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="top_level_shadow_blur_out" type="text" id="top_level_shadow_blur_out" value="<?php echo $top_level_shadow_blur_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="top_level_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $top_level_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="top_level_font_size_over" type="text" id="top_level_font_size_over" value="<?php echo $top_level_font_size_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);"/> 
					<select name="top_level_font_size_units_over" id="top_level_font_size_units_over" onChange="enable_disable_font_size('top_level_font_size_over', 'top_level_font_size_units_over');">
                    <option value="px"<?php if ($top_level_font_size_units_over == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($top_level_font_size_units_over == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($top_level_font_size_units_over == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($top_level_font_size_units_over == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($top_level_font_size_units_over == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($top_level_font_size_units_over == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($top_level_font_size_units_over == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($top_level_font_size_units_over == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($top_level_font_size_units_over == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($top_level_font_size_units_over == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($top_level_font_size_units_over == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($top_level_font_size_units_over == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($top_level_font_size_units_over == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($top_level_font_size_units_over == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($top_level_font_size_units_over == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($top_level_font_size_units_over == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($top_level_font_size_units_over == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($top_level_font_size_units_over == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($top_level_font_size_units_over == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($top_level_font_size_units_over == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($top_level_font_size_units_over == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($top_level_font_size_units_over == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($top_level_font_size_units_over == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($top_level_font_size_units_over == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($top_level_font_size_units_over == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                    </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="top_level_text_color_over" type="text" id="top_level_text_color_over" value="<?php echo $top_level_text_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_text_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="top_level_padding_top_over" type="text" id="top_level_padding_top_over" value="<?php echo intval($top_level_padding_top_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    <input name="top_level_padding_right_over" type="text" id="top_level_padding_right_over" value="<?php echo intval($top_level_padding_right_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    <input name="top_level_padding_bottom_over" type="text" id="top_level_padding_bottom_over" value="<?php echo intval($top_level_padding_bottom_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    <input name="top_level_padding_left_over" type="text" id="top_level_padding_left_over" value="<?php echo intval($top_level_padding_left_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px
                    </td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
                              <?php echo WEIGHT_WORD; ?>:
                              <select name="top_level_bold_over" id="top_level_bold_over">
                               <option value="-not selected-" <?php if ($top_level_bold_over == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($top_level_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($top_level_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($top_level_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($top_level_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($top_level_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($top_level_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($top_level_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($top_level_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($top_level_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($top_level_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($top_level_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($top_level_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($top_level_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="top_level_italic_over" type="checkbox" id="top_level_italic_over" value="1" <?php if ($top_level_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="top_level_underline_over" type="checkbox" id="top_level_underline_over" value="1" <?php if ($top_level_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="top_level_overline_over" type="checkbox" id="top_level_overline_over" value="1" <?php if ($top_level_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="top_level_blink_over" type="checkbox" id="top_level_blink_over" value="1" <?php if ($top_level_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="top_level_shadow_over" type="checkbox" id="top_level_shadow_over" value="1" <?php if ($top_level_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('top_level', 'over');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="top_level_shadow_color_over" type="text" id="top_level_shadow_color_over" value="<?php echo $top_level_shadow_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_shadow_color_over');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="top_level_shadow_x_offset_over" type="text" id="top_level_shadow_x_offset_over" value="<?php echo $top_level_shadow_x_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="top_level_shadow_y_offset_over" type="text" id="top_level_shadow_y_offset_over" value="<?php echo $top_level_shadow_y_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);"/> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="top_level_shadow_blur_over" type="text" id="top_level_shadow_blur_over" value="<?php echo $top_level_shadow_blur_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo BACKGROUND_WORD; ?></td>
		     </tr>
				<tr><td>
                
                <table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="8" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="top_level_bkgd_color_out" type="text" id="top_level_bkgd_color_out" value="<?php echo $top_level_bkgd_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_bkgd_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
					  
					<td align="right"><?php echo OPACITY_WORD; ?>: </td>
					<td><input name="top_level_bkgd_opacity_out" type="text" id="top_level_bkgd_opacity_out" value="<?php echo $top_level_bkgd_opacity_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					%</td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="top_level_border_out" type="text" id="top_level_border_out" value="<?php echo intval($top_level_border_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="top_level_border_color_out" type="text" id="top_level_border_color_out" value="<?php echo $top_level_border_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_border_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
                      </tr>
                    </table>
                      
                     </td> 
				  </tr>
                  <tr>
                  	<td>
                    
                    
                  <table width="100%" class="layout_box_table">
                    <tr>
                    <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_horizontal_out" id="top_level_box_shadow_horizontal_out" value="<?php echo $top_level_box_shadow_horizontal_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_vertical_out" id="top_level_box_shadow_vertical_out" value="<?php echo $top_level_box_shadow_vertical_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_blur_out" id="top_level_box_shadow_blur_out" value="<?php echo $top_level_box_shadow_blur_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_spread_out" id="top_level_box_shadow_spread_out" value="<?php echo $top_level_box_shadow_spread_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_color_out" id="top_level_box_shadow_color_out" value="<?php echo $top_level_box_shadow_color_out; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color_out');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="top_level_box_shadow_inset_out" id="top_level_box_shadow_inset_out" value="1" <?php if ($top_level_box_shadow_inset_out ==1) echo "checked='checked'"; ?> /></td>
                    </tr>
                  </table>
                    
                    
            <!--       </td>
                </tr>
			  </table> -->
             </td>
            </tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="top_level_bkgd_color_over" type="text" id="top_level_bkgd_color_over" value="<?php echo $top_level_bkgd_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_bkgd_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="top_level_border_over" type="text" id="top_level_border_over" value="<?php echo intval($top_level_border_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="top_level_border_color_over" type="text" id="top_level_border_color_over" value="<?php echo $top_level_border_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_border_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
				  </tr>
			</table>
          </td>
        </tr>
        <tr>
          <td>
          
          <table width="100%" class="layout_box_table">
                    <tr>
                    <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_horizontal_over" id="top_level_box_shadow_horizontal_over" value="<?php echo $top_level_box_shadow_horizontal_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_vertical_over" id="top_level_box_shadow_vertical_over" value="<?php echo $top_level_box_shadow_vertical_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_blur_over" id="top_level_box_shadow_blur_over" value="<?php echo $top_level_box_shadow_blur_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_spread_over" id="top_level_box_shadow_spread_over" value="<?php echo $top_level_box_shadow_spread_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="top_level_box_shadow_color_over" id="top_level_box_shadow_color_over" value="<?php echo $top_level_box_shadow_color_over; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'top_level_box_shadow_color_over');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="top_level_box_shadow_inset_over" id="top_level_box_shadow_inset_over" value="1" <?php if ($top_level_box_shadow_inset_over ==1) echo "checked='checked'"; ?> /></td>
                    </tr>
                  </table>
          
          </td>
        </tr>
			
	  </table></td></tr>
	  
	 </table>
	 
	 
	  </td></tr>
	  <tr><td>&nbsp;</td></tr>
	  <tr>
		 <td class="sub_title" bgcolor="#FFFF00"><?php echo EDIT_JS_MENU_STYLES_SUB_LEVEL_1_MENU; ?></td>
	  </tr>
	  <tr><td>
	 
	 
	 
	 <table class="group_box_table" width="100%" bgcolor="#FFFFCC">
		  	<tr><td><table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo TEXT_WORD; ?></td>
		     </tr>
             <tr>
             	<td>
                  <table class="layout_box_table" width="100%"><tr>
                  <td align="right"><?php echo ALIGN_WORD; ?>: </td>
                  <td>
                      <select name="sub_level_1_align" id="sub_level_1_align">
                      <option value="-not selected-"<?php if ($sub_level_1_align == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                      <option value="left"<?php if ($sub_level_1_align == "left") echo " selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                      <option value="center"<?php if ($sub_level_1_align == "center") echo " selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                      <option value="right"<?php if ($sub_level_1_align == "right") echo " selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                      <option value="justify"<?php if ($sub_level_1_align == "justify") echo " selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
                      </select>
                  </td>
                  <td align="right"><!--Vertical Align:--> </td>
                  <td>
                      <select name="sub_level_1_vertical_align" id="sub_level_1_vertical_align" style="display:none;">
                      <option value="-not selected-"<?php if ($sub_level_1_vertical_align == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                      <option value="baseline"<?php if ($sub_level_1_vertical_align == "baseline") echo " selected='selected'"; ?>><?php echo BASELINE_WORD; ?></option>
                      <option value="sub"<?php if ($sub_level_1_vertical_align == "sub") echo " selected='selected'"; ?>><?php echo SUB_WORD; ?></option>
                      <option value="super"<?php if ($sub_level_1_vertical_align == "super") echo " selected='selected'"; ?>><?php echo SUPER_WORD; ?></option>
                      <option value="top"<?php if ($sub_level_1_vertical_align == "top") echo " selected='selected'"; ?>><?php echo TOP_1ST_CAP_WORD; ?></option>
                      <option value="text-top"<?php if ($sub_level_1_vertical_align == "text-top") echo " selected='selected'"; ?>><?php echo TEXT_TOP; ?></option>
                      <option value="middle"<?php if ($sub_level_1_vertical_align == "middle") echo " selected='selected'"; ?>><?php echo MIDDLE_WORD; ?></option>
                      <option value="bottom"<?php if ($sub_level_1_vertical_align == "bottom") echo " selected='selected'"; ?>><?php echo BOTTOM_1ST_CAP_WORD; ?></option>
                      <option value="text-bottom"<?php if ($sub_level_1_vertical_align == "text-bottom") echo " selected='selected'"; ?>><?php echo TEXT_BOTTOM; ?></option>              
                      </select>
                  </td>
                  </tr></table>
                </td>
             </tr>
				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="sub_level_1_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_1_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="sub_level_1_font_size_out" type="text" id="sub_level_1_font_size_out" value="<?php echo $sub_level_1_font_size_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					<select name="sub_level_1_font_size_units_out" id="sub_level_1_font_size_units_out" onChange="enable_disable_font_size('sub_level_1_font_size_out', 'sub_level_1_font_size_units_out');">
                    <option value="px"<?php if ($sub_level_1_font_size_units_out == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_units_out == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_units_out == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_units_out == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_units_out == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_units_out == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_units_out == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_units_out == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_units_out == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_units_out == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_units_out == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_units_out == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_units_out == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_units_out == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_units_out == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_units_out == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_units_out == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_units_out == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_units_out == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_units_out == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_units_out == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_units_out == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_units_out == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_units_out == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_units_out == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                    </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="sub_level_1_text_color_out" type="text" id="sub_level_1_text_color_out" value="<?php echo $sub_level_1_text_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="sub_level_1_padding_top_out" type="text" id="sub_level_1_padding_top_out" value="<?php echo intval($sub_level_1_padding_top_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_1_padding_right_out" type="text" id="sub_level_1_padding_right_out" value="<?php echo intval($sub_level_1_padding_right_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_1_padding_bottom_out" type="text" id="sub_level_1_padding_bottom_out" value="<?php echo intval($sub_level_1_padding_bottom_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_1_padding_left_out" type="text" id="sub_level_1_padding_left_out" value="<?php echo intval($sub_level_1_padding_left_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px
                    </td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
                              <?php echo WEIGHT_WORD; ?>:
                              <select name="sub_level_1_bold_out" id="sub_level_1_bold_out">
                               <option value="-not selected-" <?php if ($sub_level_1_bold_out == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($sub_level_1_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_1_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_1_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_1_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_1_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_1_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_1_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_1_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_1_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_1_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_1_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_1_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_1_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="sub_level_1_italic_out" type="checkbox" id="sub_level_1_italic_out" value="1" <?php if ($sub_level_1_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="sub_level_1_underline_out" type="checkbox" id="sub_level_1_underline_out" value="1" <?php if ($sub_level_1_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="sub_level_1_overline_out" type="checkbox" id="sub_level_1_overline_out" value="1" <?php if ($sub_level_1_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="sub_level_1_blink_out" type="checkbox" id="sub_level_1_blink_out" value="1" <?php if ($sub_level_1_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="sub_level_1_shadow_out" type="checkbox" id="sub_level_1_shadow_out" value="1" <?php if ($sub_level_1_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1', 'out');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="sub_level_1_shadow_color_out" type="text" id="sub_level_1_shadow_color_out" value="<?php echo $sub_level_1_shadow_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_out');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="sub_level_1_shadow_x_offset_out" type="text" id="sub_level_1_shadow_x_offset_out" value="<?php echo $sub_level_1_shadow_x_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="sub_level_1_shadow_y_offset_out" type="text" id="sub_level_1_shadow_y_offset_out" value="<?php echo $sub_level_1_shadow_y_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="sub_level_1_shadow_blur_out" type="text" id="sub_level_1_shadow_blur_out" value="<?php echo $sub_level_1_shadow_blur_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="sub_level_1_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_1_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="sub_level_1_font_size_over" type="text" id="sub_level_1_font_size_over" value="<?php echo $sub_level_1_font_size_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					<select name="sub_level_1_font_size_units_over" id="sub_level_1_font_size_units_over" onChange="enable_disable_font_size('sub_level_1_font_size_over', 'sub_level_1_font_size_units_over');">
                    <option value="px"<?php if ($sub_level_1_font_size_units_over == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_1_font_size_units_over == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_1_font_size_units_over == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_1_font_size_units_over == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_1_font_size_units_over == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_1_font_size_units_over == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_1_font_size_units_over == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_1_font_size_units_over == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_1_font_size_units_over == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_1_font_size_units_over == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_1_font_size_units_over == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_1_font_size_units_over == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_1_font_size_units_over == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_1_font_size_units_over == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_1_font_size_units_over == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_1_font_size_units_over == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_1_font_size_units_over == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_1_font_size_units_over == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_1_font_size_units_over == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_1_font_size_units_over == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_1_font_size_units_over == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_1_font_size_units_over == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_1_font_size_units_over == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_1_font_size_units_over == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_1_font_size_units_over == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                    </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="sub_level_1_text_color_over" type="text" id="sub_level_1_text_color_over" value="<?php echo $sub_level_1_text_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_text_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="sub_level_1_padding_top_over" type="text" id="sub_level_1_padding_top_over" value="<?php echo intval($sub_level_1_padding_top_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
                    <input name="sub_level_1_padding_right_over" type="text" id="sub_level_1_padding_right_over" value="<?php echo intval($sub_level_1_padding_right_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_1_padding_bottom_over" type="text" id="sub_level_1_padding_bottom_over" value="<?php echo intval($sub_level_1_padding_bottom_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_1_padding_left_over" type="text" id="sub_level_1_padding_left_over" value="<?php echo intval($sub_level_1_padding_left_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					px
                    </td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
                               <?php echo WEIGHT_WORD; ?>:
                              <select name="sub_level_1_bold_over" id="sub_level_1_bold_over">
                               <option value="-not selected-" <?php if ($sub_level_1_bold_over == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($sub_level_1_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_1_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_1_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_1_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_1_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_1_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_1_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_1_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_1_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_1_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_1_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_1_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_1_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="sub_level_1_italic_over" type="checkbox" id="sub_level_1_italic_over" value="1" <?php if ($sub_level_1_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="sub_level_1_underline_over" type="checkbox" id="sub_level_1_underline_over" value="1" <?php if ($sub_level_1_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="sub_level_1_overline_over" type="checkbox" id="sub_level_1_overline_over" value="1" <?php if ($sub_level_1_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="sub_level_1_blink_over" type="checkbox" id="sub_level_1_blink_over" value="1" <?php if ($sub_level_1_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="sub_level_1_shadow_over" type="checkbox" id="sub_level_1_shadow_over" value="1" <?php if ($sub_level_1_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_1', 'over');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="sub_level_1_shadow_color_over" type="text" id="sub_level_1_shadow_color_over" value="<?php echo $sub_level_1_shadow_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_shadow_color_over');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="sub_level_1_shadow_x_offset_over" type="text" id="sub_level_1_shadow_x_offset_over" value="<?php echo $sub_level_1_shadow_x_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="sub_level_1_shadow_y_offset_over" type="text" id="sub_level_1_shadow_y_offset_over" value="<?php echo $sub_level_1_shadow_y_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="sub_level_1_shadow_blur_over" type="text" id="sub_level_1_shadow_blur_over" value="<?php echo $sub_level_1_shadow_blur_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo BACKGROUND_WORD; ?></td>
		     </tr>
				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="6" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="sub_level_1_bkgd_color_out" type="text" id="sub_level_1_bkgd_color_out" value="<?php echo $sub_level_1_bkgd_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_bkgd_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo OPACITY_WORD; ?>: </td>
					<td><input name="sub_level_1_bkgd_opacity_out" type="text" id="sub_level_1_bkgd_opacity_out" value="<?php echo $sub_level_1_bkgd_opacity_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					%</td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="sub_level_1_border_out" type="text" id="sub_level_1_border_out" value="<?php echo intval($sub_level_1_border_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="sub_level_1_border_color_out" type="text" id="sub_level_1_border_color_out" value="<?php echo $sub_level_1_border_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_border_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
				  </tr>
				  <tr>
			</table>
            
            </td></tr>
            <tr>
             	<td>
                  <table class="layout_box_table" width="100%">
                  <tr>
	                <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_horizontal_out" id="sub_level_1_box_shadow_horizontal_out" value="<?php echo $sub_level_1_box_shadow_horizontal_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_vertical_out" id="sub_level_1_box_shadow_vertical_out" value="<?php echo $sub_level_1_box_shadow_vertical_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_blur_out" id="sub_level_1_box_shadow_blur_out" value="<?php echo $sub_level_1_box_shadow_blur_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_spread_out" id="sub_level_1_box_shadow_spread_out" value="<?php echo $sub_level_1_box_shadow_spread_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_color_out" id="sub_level_1_box_shadow_color_out" value="<?php echo $sub_level_1_box_shadow_color_out; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color_out');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="sub_level_1_box_shadow_inset_out" id="sub_level_1_box_shadow_inset_out" value="1" <?php if ($sub_level_1_box_shadow_inset_out ==1) echo "checked='checked'"; ?> /></td>
                  </tr>
                </table>
                </td>
             </tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="sub_level_1_bkgd_color_over" type="text" id="sub_level_1_bkgd_color_over" value="<?php echo $sub_level_1_bkgd_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_bkgd_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="sub_level_1_border_over" type="text" id="sub_level_1_border_over" value="<?php echo intval($sub_level_1_border_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="sub_level_1_border_color_over" type="text" id="sub_level_1_border_color_over" value="<?php echo $sub_level_1_border_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_border_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
				  </tr>
			</table>
            
            </td></tr>
            <tr>
             	<td>
                  <table class="layout_box_table" width="100%">
                  <tr>
                    <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_horizontal_over" id="sub_level_1_box_shadow_horizontal_over" value="<?php echo $sub_level_1_box_shadow_horizontal_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_vertical_over" id="sub_level_1_box_shadow_vertical_over" value="<?php echo $sub_level_1_box_shadow_vertical_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_blur_over" id="sub_level_1_box_shadow_blur_over" value="<?php echo $sub_level_1_box_shadow_blur_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_spread_over" id="sub_level_1_box_shadow_spread_over" value="<?php echo $sub_level_1_box_shadow_spread_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_1_box_shadow_color_over" id="sub_level_1_box_shadow_color_over" value="<?php echo $sub_level_1_box_shadow_color_over; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_1_box_shadow_color_over');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="sub_level_1_box_shadow_inset_over" id="sub_level_1_box_shadow_inset_over" value="1" <?php if ($sub_level_1_box_shadow_inset_over ==1) echo "checked='checked'"; ?> /></td>
                  </tr>
                </table>
                </td>
             </tr>

	  </table></td></tr>
	  
	 </table>
	 
	 
	 
	 </td></tr>
	 <tr><td>&nbsp;</td></tr>
	  <tr>
		 <td class="sub_title" bgcolor="#FF00FF"><?php echo EDIT_JS_MENU_STYLES_SUB_LEVEL_2_MENU; ?></td>
	  </tr>
	  <tr><td>
	 
	 
	  
	 
	 <table class="group_box_table" width="100%" bgcolor="#FFCCFF">
		  	<tr><td><table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo TEXT_WORD; ?></td>
		     </tr>
             <tr>
             	<td>
                  <table class="layout_box_table" width="100%"><tr>
                  <td align="right"><?php echo ALIGN_WORD; ?>: </td>
                  <td>
                      <select name="sub_level_2_align" id="sub_level_2_align">
                      <option value="-not selected-"<?php if ($sub_level_2_align == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                      <option value="left"<?php if ($sub_level_2_align == "left") echo " selected='selected'"; ?>><?php echo LEFT_1ST_CAP_WORD; ?></option>
                      <option value="center"<?php if ($sub_level_2_align == "center") echo " selected='selected'"; ?>><?php echo CENTER_WORD; ?></option>
                      <option value="right"<?php if ($sub_level_2_align == "right") echo " selected='selected'"; ?>><?php echo RIGHT_1ST_CAP_WORD; ?></option>
                      <option value="justify"<?php if ($sub_level_2_align == "justify") echo " selected='selected'"; ?>><?php echo JUSTIFY_WORD; ?></option>
                      </select>
                  </td>
                  <td align="right"><!--Vertical Align:--> </td>
                  <td>
                      <select name="sub_level_2_vertical_align" id="sub_level_2_vertical_align" style="display:none;">
                      <option value="-not selected-"<?php if ($sub_level_2_vertical_align == "-not selected-") echo " selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                      <option value="baseline"<?php if ($sub_level_2_vertical_align == "baseline") echo " selected='selected'"; ?>><?php echo BASELINE_WORD; ?></option>
                      <option value="sub"<?php if ($sub_level_2_vertical_align == "sub") echo " selected='selected'"; ?>><?php echo SUB_WORD; ?></option>
                      <option value="super"<?php if ($sub_level_2_vertical_align == "super") echo " selected='selected'"; ?>><?php echo SUPER_WORD; ?></option>
                      <option value="top"<?php if ($sub_level_2_vertical_align == "top") echo " selected='selected'"; ?>><?php echo TOP_1ST_CAP_WORD; ?></option>
                      <option value="text-top"<?php if ($sub_level_2_vertical_align == "text-top") echo " selected='selected'"; ?>><?php echo TEXT_TOP; ?></option>
                      <option value="middle"<?php if ($sub_level_2_vertical_align == "middle") echo " selected='selected'"; ?>><?php echo MIDDLE_WORD; ?></option>
                      <option value="bottom"<?php if ($sub_level_2_vertical_align == "bottom") echo " selected='selected'"; ?>><?php echo BOTTOM_1ST_CAP_WORD; ?></option>
                      <option value="text-bottom"<?php if ($sub_level_2_vertical_align == "text-bottom") echo " selected='selected'"; ?>><?php echo TEXT_BOTTOM; ?></option>              
                      </select>
                  </td>
                  </tr></table>
                </td>
             </tr>
				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="sub_level_2_font_out">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_2_font_out)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="sub_level_2_font_size_out" type="text" id="sub_level_2_font_size_out" value="<?php echo $sub_level_2_font_size_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					<select name="sub_level_2_font_size_units_out" id="sub_level_2_font_size_units_out" onChange="enable_disable_font_size('sub_level_2_font_size_out', 'sub_level_2_font_size_units_out');">
                    <option value="px"<?php if ($sub_level_2_font_size_units_out == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_units_out == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_units_out == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_units_out == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_units_out == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_units_out == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_units_out == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_units_out == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_units_out == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_units_out == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_units_out == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_units_out == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_units_out == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_units_out == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_units_out == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_units_out == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_units_out == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_units_out == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_units_out == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_units_out == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_units_out == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_units_out == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_units_out == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_units_out == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_units_out == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                    </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="sub_level_2_text_color_out" type="text" id="sub_level_2_text_color_out" value="<?php echo $sub_level_2_text_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="sub_level_2_padding_top_out" type="text" id="sub_level_2_padding_top_out" value="<?php echo intval($sub_level_2_padding_top_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_right_out" type="text" id="sub_level_2_padding_right_out" value="<?php echo intval($sub_level_2_padding_right_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_bottom_out" type="text" id="sub_level_2_padding_bottom_out" value="<?php echo intval($sub_level_2_padding_bottom_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_left_out" type="text" id="sub_level_2_padding_left_out" value="<?php echo intval($sub_level_2_padding_left_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					px
                    </td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
                               <?php echo WEIGHT_WORD; ?>:
                              <select name="sub_level_2_bold_out" id="sub_level_2_bold_out">
                               <option value="-not selected-" <?php if ($sub_level_2_bold_out == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($sub_level_2_bold_out == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_2_bold_out == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_2_bold_out == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_2_bold_out == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_2_bold_out == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_2_bold_out == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_2_bold_out == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_2_bold_out == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_2_bold_out == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_2_bold_out == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_2_bold_out == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_2_bold_out == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_2_bold_out == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="sub_level_2_italic_out" type="checkbox" id="sub_level_2_italic_out" value="1" <?php if ($sub_level_2_italic_out == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="sub_level_2_underline_out" type="checkbox" id="sub_level_2_underline_out" value="1" <?php if ($sub_level_2_underline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="sub_level_2_overline_out" type="checkbox" id="sub_level_2_overline_out" value="1" <?php if ($sub_level_2_overline_out == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="sub_level_2_blink_out" type="checkbox" id="sub_level_2_blink_out" value="1" <?php if ($sub_level_2_blink_out == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="sub_level_2_shadow_out" type="checkbox" id="sub_level_2_shadow_out" value="1" <?php if ($sub_level_2_shadow_out == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2', 'out');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="sub_level_2_shadow_color_out" type="text" id="sub_level_2_shadow_color_out" value="<?php echo $sub_level_2_shadow_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_out');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="sub_level_2_shadow_x_offset_out" type="text" id="sub_level_2_shadow_x_offset_out" value="<?php echo $sub_level_2_shadow_x_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="sub_level_2_shadow_y_offset_out" type="text" id="sub_level_2_shadow_y_offset_out" value="<?php echo $sub_level_2_shadow_y_offset_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="sub_level_2_shadow_blur_out" type="text" id="sub_level_2_shadow_blur_out" value="<?php echo $sub_level_2_shadow_blur_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo FONT_WORD; ?>: </td>
					<td>
					<select name="sub_level_2_font_over">
					<?php
						$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "fonts ORDER BY font";
						$result = $bwb_dbh->query($query);
						while ($row = $result->fetch(PDO::FETCH_ASSOC))
						{
							$font = $row['font'];
							$websafe = $row['websafe'];
							echo "<option value='$font' style='font-family:$font;'";
							if ($font == $sub_level_2_font_over)
								echo " selected='selected'";
							echo ">$font";
							if ($websafe == 1)
								echo " &nbsp; &nbsp; &nbsp; &radic;";
							echo "</option>\n";
						}
					?>
					</select>
                    <span class="small_message">&radic; = <?php echo WEBSAFE_WORD; ?></span>
					</td>
					<td align="right"><?php echo FONT_SIZE; ?>: </td>
					<td>
                    <input name="sub_level_2_font_size_over" type="text" id="sub_level_2_font_size_over" value="<?php echo $sub_level_2_font_size_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					<select name="sub_level_2_font_size_units_over" id="sub_level_2_font_size_units_over" onChange="enable_disable_font_size('sub_level_2_font_size_over', 'sub_level_2_font_size_units_over');">
                    <option value="px"<?php if ($sub_level_2_font_size_units_over == "px") echo " selected"; ?>>px</option>
                    <option value="em"<?php if ($sub_level_2_font_size_units_over == "em") echo " selected"; ?>>em</option>
                    <option value="pt"<?php if ($sub_level_2_font_size_units_over == "pt") echo " selected"; ?>>pt</option>
                    <option value="pc"<?php if ($sub_level_2_font_size_units_over == "pc") echo " selected"; ?>>pc</option>
                    <option value="cm"<?php if ($sub_level_2_font_size_units_over == "cm") echo " selected"; ?>>cm</option>
                    <option value="mm"<?php if ($sub_level_2_font_size_units_over == "mm") echo " selected"; ?>>mm</option>
                    <option value="in"<?php if ($sub_level_2_font_size_units_over == "in") echo " selected"; ?>>in</option>
                    <option value="%"<?php if ($sub_level_2_font_size_units_over == "%") echo " selected"; ?>>%</option>
                    <option value="rem"<?php if ($sub_level_2_font_size_units_over == "rem") echo " selected"; ?>>rem</option>
                    <option value="vw"<?php if ($sub_level_2_font_size_units_over == "vw") echo " selected"; ?>>vw</option>
                    <option value="vh"<?php if ($sub_level_2_font_size_units_over == "vh") echo " selected"; ?>>vh</option>
                    <option value="vmin"<?php if ($sub_level_2_font_size_units_over == "vmin") echo " selected"; ?>>vmin</option>
                    <option value="vmax"<?php if ($sub_level_2_font_size_units_over == "vmax") echo " selected"; ?>>vmax</option>
                    <option value="ch"<?php if ($sub_level_2_font_size_units_over == "ch") echo " selected"; ?>>ch</option>
                    <option value="xx-small"<?php if ($sub_level_2_font_size_units_over == "xx-small") echo " selected"; ?>><?php echo XX_SMALL_WORD; ?></option>
                    <option value="x-small"<?php if ($sub_level_2_font_size_units_over == "x-small") echo " selected"; ?>><?php echo X_SMALL_WORD; ?></option>
                    <option value="small"<?php if ($sub_level_2_font_size_units_over == "small") echo " selected"; ?>><?php echo SMALL_WORD; ?></option>
                    <option value="medium"<?php if ($sub_level_2_font_size_units_over == "medium") echo " selected"; ?>><?php echo MEDIUM_WORD; ?></option>
                    <option value="large"<?php if ($sub_level_2_font_size_units_over == "large") echo " selected"; ?>><?php echo LARGE_WORD; ?></option>
                    <option value="x-large"<?php if ($sub_level_2_font_size_units_over == "x-large") echo " selected"; ?>><?php echo X_LARGE_WORD; ?></option>
                    <option value="xx-large"<?php if ($sub_level_2_font_size_units_over == "xx-large") echo " selected"; ?>><?php echo XX_LARGE_WORD; ?></option>
                    <option value="smaller"<?php if ($sub_level_2_font_size_units_over == "smaller") echo " selected"; ?>><?php echo SMALLER_WORD; ?></option>
                    <option value="larger"<?php if ($sub_level_2_font_size_units_over == "larger") echo " selected"; ?>><?php echo LARGER_WORD; ?></option>
                    <option value="initial"<?php if ($sub_level_2_font_size_units_over == "initial") echo " selected"; ?>><?php echo RGB_WORD; ?></option>
                    <option value="inherit"<?php if ($sub_level_2_font_size_units_over == "inherit") echo " selected"; ?>><?php echo INHERIT_LC_WORD; ?></option>
                	</select>
                    </td>
				  </tr>
				  <tr>
					<td align="right"><?php echo COLOR_WORD; ?>: </td>
					<td><input name="sub_level_2_text_color_over" type="text" id="sub_level_2_text_color_over" value="<?php echo $sub_level_2_text_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_text_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo EDIT_JS_MENU_STYLES_PADDING; ?>: </td>
					<td>
                    <input name="sub_level_2_padding_top_over" type="text" id="sub_level_2_padding_top_over" value="<?php echo intval($sub_level_2_padding_top_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_right_over" type="text" id="sub_level_2_padding_right_over" value="<?php echo intval($sub_level_2_padding_right_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_bottom_over" type="text" id="sub_level_2_padding_bottom_over" value="<?php echo intval($sub_level_2_padding_bottom_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
                    <input name="sub_level_2_padding_left_over" type="text" id="sub_level_2_padding_left_over" value="<?php echo intval($sub_level_2_padding_left_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" />
					px
                    </td>
				  </tr>
				  <tr>
					<td colspan="4">
					   <table class="layout_box_table" width="100%">
					     <tr>
						   <td align="center">
                               <?php echo WEIGHT_WORD; ?>:
                              <select name="sub_level_2_bold_over" id="sub_level_2_bold_over">
                               <option value="-not selected-" <?php if ($sub_level_2_bold_over == "-not selected-") echo "selected='selected'"; ?> class="not_set"><?php echo _NOT_SELECTED_; ?></option>
                               <option value="normal" <?php if ($sub_level_2_bold_over == "normal") echo "selected='selected'"; ?>>Normal</option>
                               <option value="bold" <?php if ($sub_level_2_bold_over == "bold") echo "selected='selected'"; ?>>Bold</option>
                               <option value="bolder" <?php if ($sub_level_2_bold_over == "bolder") echo "selected='selected'"; ?>>Bolder</option>
                               <option value="lighter" <?php if ($sub_level_2_bold_over == "lighter") echo "selected='selected'"; ?>>Lighter</option>
                               <option value="100" <?php if ($sub_level_2_bold_over == "100") echo "selected='selected'"; ?>>100</option>
                               <option value="200" <?php if ($sub_level_2_bold_over == "200") echo "selected='selected'"; ?>>200</option>
                               <option value="300" <?php if ($sub_level_2_bold_over == "300") echo "selected='selected'"; ?>>300</option>
                               <option value="400" <?php if ($sub_level_2_bold_over == "400") echo "selected='selected'"; ?>>400</option>
                               <option value="500" <?php if ($sub_level_2_bold_over == "500") echo "selected='selected'"; ?>>500</option>
                               <option value="600" <?php if ($sub_level_2_bold_over == "600") echo "selected='selected'"; ?>>600</option>
                               <option value="700" <?php if ($sub_level_2_bold_over == "700") echo "selected='selected'"; ?>>700</option>
                               <option value="800" <?php if ($sub_level_2_bold_over == "800") echo "selected='selected'"; ?>>800</option>
                               <option value="900" <?php if ($sub_level_2_bold_over == "900") echo "selected='selected'"; ?>>900</option>
                               </select>
						  </td>
						  <td align="center">
							  <?php echo ITALIC_WORD; ?>: 
							  <input name="sub_level_2_italic_over" type="checkbox" id="sub_level_2_italic_over" value="1" <?php if ($sub_level_2_italic_over == 1) echo "checked='checked'"; ?>>
						  </td>
						 <td align="center">
						      <?php echo UNDERLINE_WORD; ?>: 
						      <input name="sub_level_2_underline_over" type="checkbox" id="sub_level_2_underline_over" value="1" <?php if ($sub_level_2_underline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo OVERLINE_WORD; ?>: 
						      <input name="sub_level_2_overline_over" type="checkbox" id="sub_level_2_overline_over" value="1" <?php if ($sub_level_2_overline_over == 1) echo "checked='checked'"; ?>>
						 </td>
						 <td align="center">
						      <?php echo BLINK_WORD; ?>: 
						      <input name="sub_level_2_blink_over" type="checkbox" id="sub_level_2_blink_over" value="1" <?php if ($sub_level_2_blink_over == 1) echo "checked='checked'"; ?>>
						 </td>
					   </tr>
					   <tr>
						   <td align="center">
							   <?php echo SHADOW_WORD; ?>:
							  <input name="sub_level_2_shadow_over" type="checkbox" id="sub_level_2_shadow_over" value="1" <?php if ($sub_level_2_shadow_over == 1) echo "checked='checked'"; ?> onClick="enable_disable_shadow('sub_level_2', 'over');"> 
						  </td>
						  <td align="center">
							  <?php echo COLOR_WORD; ?>: 
							    <input name="sub_level_2_shadow_color_over" type="text" id="sub_level_2_shadow_color_over" value="<?php echo $sub_level_2_shadow_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" /> <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_shadow_color_over');"><?php echo RGB_WORD; ?></a></span>						  </td>
						  <td align="center">
						      <?php echo X_OFFSET_WORD; ?>: 
						        <input name="sub_level_2_shadow_x_offset_over" type="text" id="sub_level_2_shadow_x_offset_over" value="<?php echo $sub_level_2_shadow_x_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo Y_OFFSET_WORD; ?>: 
						        <input name="sub_level_2_shadow_y_offset_over" type="text" id="sub_level_2_shadow_y_offset_over" value="<?php echo $sub_level_2_shadow_y_offset_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
						  <td align="center">
						      <?php echo BLUR_WORD; ?>: 
						        <input name="sub_level_2_shadow_blur_over" type="text" id="sub_level_2_shadow_blur_over" value="<?php echo $sub_level_2_shadow_blur_over; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
						        px
						 </td>
					   </tr>
					 </table>
				  </tr>
			</table></td></tr>
		</table></td></tr>

	  <tr><td><table class="group_box_table" width="100%">
			 <tr>
			   <td class="sub_title"><?php echo BACKGROUND_WORD; ?></td>
		     </tr>
				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="6" class="sub_title"><?php echo MOUSE_OUT; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="sub_level_2_bkgd_color_out" type="text" id="sub_level_2_bkgd_color_out" value="<?php echo $sub_level_2_bkgd_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_bkgd_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo OPACITY_WORD; ?>: </td>
					<td><input name="sub_level_2_bkgd_opacity_out" type="text" id="sub_level_2_bkgd_opacity_out" value="<?php echo $sub_level_2_bkgd_opacity_out; ?>" size="10" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					%</td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="sub_level_2_border_out" type="text" id="sub_level_2_border_out" value="<?php echo intval($sub_level_2_border_out); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="sub_level_2_border_color_out" type="text" id="sub_level_2_border_color_out" value="<?php echo $sub_level_2_border_color_out; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_border_color_out');"> <?php echo RGB_WORD; ?></a></span></td>
				  </tr>
				  <tr>
			</table>
            
            </td></tr>
             <tr>
             	<td>
                  <table class="layout_box_table" width="100%">
                  <tr>
                    <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_horizontal_out" id="sub_level_2_box_shadow_horizontal_out" value="<?php echo $sub_level_2_box_shadow_horizontal_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_vertical_out" id="sub_level_2_box_shadow_vertical_out" value="<?php echo $sub_level_2_box_shadow_vertical_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_blur_out" id="sub_level_2_box_shadow_blur_out" value="<?php echo $sub_level_2_box_shadow_blur_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_spread_out" id="sub_level_2_box_shadow_spread_out" value="<?php echo $sub_level_2_box_shadow_spread_out; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_color_out" id="sub_level_2_box_shadow_color_out" value="<?php echo $sub_level_2_box_shadow_color_out; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color_out');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="sub_level_2_box_shadow_inset_out" id="sub_level_2_box_shadow_inset_out" value="1" <?php if ($sub_level_2_box_shadow_inset_out ==1) echo "checked='checked'"; ?> /></td>
                  </tr>
                </table>
                </td>
             </tr>

				<tr><td><table class="layout_box_table" width="100%">
				  <tr>
					 <td colspan="4" class="sub_title"><?php echo MOUSE_OVER; ?></td>
				  </tr>
				  <tr>
					<td align="right"><?php echo BACKGROUND_COLOR; ?>: </td>
					<td><input name="sub_level_2_bkgd_color_over" type="text" id="sub_level_2_bkgd_color_over" value="<?php echo $sub_level_2_bkgd_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_bkgd_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
					<td align="right"><?php echo BORDER_WORD; ?>: </td>
					<td><input name="sub_level_2_border_over" type="text" id="sub_level_2_border_over" value="<?php echo intval($sub_level_2_border_over); ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /> 
					px</td>
					<td align="right"><?php echo BORDER_COLOR; ?>: </td>
					<td><input name="sub_level_2_border_color_over" type="text" id="sub_level_2_border_color_over" value="<?php echo $sub_level_2_border_color_over; ?>" size="10" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                      <span class="small_message"><a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_border_color_over');"> <?php echo RGB_WORD; ?></a></span></td>
				  </tr>
			</table>
            
            </td></tr>
             <tr>
             	<td>
                  <table class="layout_box_table" width="100%">
                  <tr>
                    <td align="right"><b><?php echo BOX_SHADOW; ?></b></td>
                    <td align="right"><?php echo HORIZONTAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_horizontal_over" id="sub_level_2_box_shadow_horizontal_over" value="<?php echo $sub_level_2_box_shadow_horizontal_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo VERTICAL_OFFSET; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_vertical_over" id="sub_level_2_box_shadow_vertical_over" value="<?php echo $sub_level_2_box_shadow_vertical_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo BLUR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_blur_over" id="sub_level_2_box_shadow_blur_over" value="<?php echo $sub_level_2_box_shadow_blur_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo SPREAD_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_spread_over" id="sub_level_2_box_shadow_spread_over" value="<?php echo $sub_level_2_box_shadow_spread_over; ?>" size="6" onClick="TextFieldClick(this);" onChange="TextFieldChange(this);" onBlur="TextFieldBlur(this);" /></td>
                    <td align="right"><?php echo COLOR_WORD; ?>: </td>
                    <td><input type="text" name="sub_level_2_box_shadow_color_over" id="sub_level_2_box_shadow_color_over" value="<?php echo $sub_level_2_box_shadow_color_over; ?>" size="6" onClick="TextFieldClick(this);" onBlur="CheckColorString(this); TextFieldBlur(this);" />
                     <span class="small_message"> <a href=# onClick="javascript: popupcolorpicker('frm_menu_styles', 'sub_level_2_box_shadow_color_over');"><?php echo RGB_WORD; ?></a></span></td>
                    <td align="right"><?php echo INSET_WORD; ?>: </td>
                    <td><input type="checkbox" name="sub_level_2_box_shadow_inset_over" id="sub_level_2_box_shadow_inset_over" value="1" <?php if ($sub_level_2_box_shadow_inset_over ==1) echo "checked='checked'"; ?> /></td>
                  </tr>
                </table>
                </td>
             </tr>

	  </table></td></tr>
	
	 </table>
	  
	 
	 
	</td>
  </tr>
  
</table>
</table>

<table width="90%" border="0" cellspacing="0" cellpadding="0">
  <tr><td colspan="3">&nbsp;</td></tr>
  <tr>
		<td align="center">
          <div class='button_console_preview' style="width:110px;" onClick="PreviewPageSelect();"><span class='button_console_text_w_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
		</td>
		<td align="center">          
          <div class='button_console_save' style="width:110px;" onClick="SaveMenuStyles();"><span class='button_console_text_w_icon'><?php echo UPDATE_WORD; ?></span></div>
          <input type="hidden" value="<?php echo $menu; ?>" name="menu" id="menu" />
          <input type="hidden" name="operation" id="operation" />
		</td>
	  </tr>
</table>
</form>
</div>

<div id="page_select_div" style="display:none;">
<?php echo EDIT_CSS_SELECT_PAGE_FOR_PREVIEW; ?>:<br />
<select id="page_select" onChange="Preview(this.value, 0);">
<?php
	$query = "SELECT page_name FROM `" . BWB_TABLE_PREFIX . "page_data`";
	$result = $bwb_dbh->query($query);
	while($row = $result->fetch(PDO::FETCH_ASSOC))
	{
		$page_name = $row['page_name'];
		echo "		<option value='$page_name'>$page_name</option>\n";
	}
?>
</select>
<div id="preview_go" onClick="Preview(document.getElementById('page_select').value, 0);">&nbsp;</div>
</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
</script>

</body>
</html>