<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	3/9/2013	ELL
// Revised: 6/28/2013	ELL
// Implemented popup message class.
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
// Revised: 12/22/2013	ELL
// Restored ability to check for saved and prompt user for action.
// Revised: 6/16/2014	ELL
// Added content sensitive help for relevant plugins.
// Revised: 9/21/2014	ELL
// Upgraded CKEditor for 4.0.2 to 4.4.4.
// Revised: 10/16/2014	ELL
// Added ability to turn off site styles when disable_site_styles flag is set.
// Revised: 11/21/2014	ELL
// Added delete page, border area or blog.
// Revised: 12/1/2014	ELL
// Added revert confirmation message.
// Revised: 1/22/2015	ELL
// Updated CKEditor from version 4.4.5 to version 4.4.6.
// Revised:	2/2/2012	ELL
// Fixed bug with "See Site" button not updating to new file after "Save As".


	include ("check_session.php");
		
	$mode = $_REQUEST['mode'];
	$refresh_buttons = $_REQUEST['refresh_buttons'];
	
	$page_name = $_REQUEST['page_name'];
	$blog_id = $_REQUEST['blog_id'];
	$special = $_REQUEST['special'];	//Flag to tell if editing special page (header, footer, side panel...).
	if ($mode == "blog")
	{
		$_SESSION['last_blog_edited'] = $blog_id;
		if (!isset($page_name) || ($page_name == ""))
		{
			// If editing blog, page name not sent with blog ID so need to retrieve from blogs table.
			$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "blogs WHERE id = '$blog_id'";
			$result = $bwb_dbh->query($query);
			$row = $result->fetch(PDO::FETCH_ASSOC);
			$page_name = $row['page_name'];
		}
		$_SESSION['last_page_edited'] = $page_name;
		$special = 0;
	}
	elseif (!isset($special))
	{
		$_SESSION['last_page_edited'] = $page_name;
		$special = 0;
	}
	else
		$_SESSION['last_border_edited'] = $page_name;
	
	
	if (BWB_BASE_DIR == '')
		$userfiles = '';
	else
		$userfiles = "/" . BWB_BASE_DIR;
		
	if (BWB_WEBPAGE_DIR == '')
		$website_folder = '';
	else
		$website_folder = "/" . BWB_WEBPAGE_DIR;

	$plugin_help = array();
	if ($mode != "blog")
	{
		$query = "SELECT plugins FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name = '$page_name'";
		$result = $bwb_dbh->query($query);
		$row = $result->fetch(PDO::FETCH_ASSOC);
		$plugins = $row['plugins'];
		if ((isset($plugins)) && ($plugins != ""))
		{
			$plugin_arr = explode(",", $plugins);
			foreach ($plugin_arr as $plugin_id)
			{
				$query = "SELECT `name`, `help_path` FROM `" . BWB_TABLE_PREFIX . "plugins` WHERE `id` = '$plugin_id'";
				$result = $bwb_dbh->query($query);
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$plugin_help[$row['name']] = $row['help_path'];
			}
		}
	}
	
	if ($special == 1)
		$query = "SELECT disable_site_styles FROM " . BWB_TABLE_PREFIX . "page_data_special WHERE page_name='$page_name'";
	else
		$query = "SELECT disable_site_styles FROM " . BWB_TABLE_PREFIX . "page_data WHERE page_name='$page_name'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))
		$disable_site_styles = $row['disable_site_styles'];
	else
		$disable_site_styles = 0;
		
	if (isset($_SESSION['site_styles']))	{
		$disable_site_styles = $_SESSION['site_styles'];
		unset($_SESSION['site_styles']);
	}
	
	$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "options_selected WHERE option_name='CodeMirrorTheme'";
	$result = $bwb_dbh->query($query);
	if ($row = $result->fetch(PDO::FETCH_ASSOC))	{
		$CodeMirrorTheme = $row['option_value'];
		if (strpos($CodeMirrorTheme, "solarized") !== false)
			$CodeMirrorCSS = "solarized";
		else
			$CodeMirrorCSS = $row['option_value'];
	}
	else	{
		$CodeMirrorTheme = "rubyblue";
		$CodeMirrorCSS = "rubyblue";
	}
?>
<html>
<head>
<title><?php if ($mode == "blog") echo "Blog ID " . $blog_id; else echo $page_name; ?> - Editing | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">

<link rel="stylesheet" href="../ckeditor/plugins/codemirror/theme/<?php echo $CodeMirrorCSS; ?>.css">

<script language="javascript" type="text/javascript" src="../ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="js/jquery.min.js"></script>
<script language="javascript" type="text/javascript" src="js/browser_detect.js"></script>
<script language="javascript" type="text/javascript" src="js/mouse_position.js"></script>
<script language="javascript" type="text/javascript" src="js/popup_msg.js"></script>
<script language="javascript" type="text/javascript" src="js/edit_page.js"></script>
<script language="javascript" type="text/javascript" src="js/fix_on_mouse_out.js"></script>

<script type="text/javascript" language="javascript">
 var page_name = "<?php echo $page_name; ?>";
 var special = "<?php echo $special; ?>";
 var blog_id = "<?php echo $blog_id; ?>";
 var mode = "<?php echo $mode; ?>";
 var prepend = "<?php echo $prepend; ?>";
 var postpend = "<?php echo $postpend; ?>";
 var userfiles = "<?php echo $userfiles; ?>";
 var website_folder = "<?php echo $website_folder; ?>";
 var disable_site_styles = <?php echo $disable_site_styles; ?>;
 
 var saved = true;
 
 var browser = BrowserDetect.browser;
 var browser_version = BrowserDetect.version;
// alert(browser + " " + browser_version);
 var help_list_html = "<div id='help_list_close_btn'><img src='theme/<?php echo $theme; ?>/images/close-button.png' alt='Close' onClick=\"document.getElementById('help_list').style.display='none';\" style='cursor:pointer;' /></div>\n";
<?php
	foreach ($plugin_help as $name => $url)
	{
		echo " help_list_html = help_list_html + \"<span onClick=\\\"window.open('$url', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');\\\" style='cursor:pointer'>$name</span><br />\";\n";
	}
?>
	help_list_html = help_list_html + "<hr /><span onClick=\"window.open('http://breezewebsitebuilder.com/docs/cms/help.html#plugins', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');\" style='cursor:pointer'>Plugins</span><br />";
	
	help_list_html = help_list_html + "<hr /><span onClick=\"window.open('http://breezewebsitebuilder.com/docs/cms/help.html#edit_page', 'Help', 'scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800');\" style='cursor:pointer'>Using Page Editor</span>";
	
<?php
	echo "	var EDITOR_STARTING_UPDATE_MSG = \"" . EDITOR_STARTING_UPDATE_MSG . "\";\n";
	echo "	var EDITOR_PREPARING_PREVIEW_MSG = \"" . EDITOR_PREPARING_PREVIEW_MSG . "\";\n";
	echo "	var EDITOR_REVERT_BLOG_CONFIRM_1_MSG = \"" . EDITOR_REVERT_BLOG_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_BLOG_CONFIRM_2_MSG = \"" . EDITOR_REVERT_BLOG_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERT_AREA_CONFIRM_1_MSG = \"" . EDITOR_REVERT_AREA_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_AREA_CONFIRM_2_MSG = \"" . EDITOR_REVERT_AREA_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERT_PAGE_CONFIRM_1_MSG = \"" . EDITOR_REVERT_PAGE_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_REVERT_PAGE_CONFIRM_2_MSG = \"" . EDITOR_REVERT_PAGE_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_REVERTING_MSG = \"" . EDITOR_REVERTING_MSG . "\";\n";
	echo "	var EDITOR_REVERT_ERR = \"" . EDITOR_REVERT_ERR . "\";\n";
	echo "	var EDITOR_PAGE_NOT_SAVED_MSG = \"" . EDITOR_PAGE_NOT_SAVED_MSG . "\";\n";
	echo "	var EDITOR_PAGE_BLANK_ERR = \"" . EDITOR_PAGE_BLANK_ERR . "\";\n";
	echo "	var EDITOR_PAGE_ALREADY_EXISTS_1_ERR = \"" . EDITOR_PAGE_ALREADY_EXISTS_1_ERR . "\";\n";
	echo "	var EDITOR_PAGE_ALREADY_EXISTS_2_ERR = \"" . EDITOR_PAGE_ALREADY_EXISTS_2_ERR . "\";\n";
	echo "	var EDITOR_AREA_ALREADY_EXISTS_1_ERR = \"" . EDITOR_AREA_ALREADY_EXISTS_1_ERR . "\";\n";
	echo "	var EDITOR_AREA_ALREADY_EXISTS_2_ERR = \"" . EDITOR_AREA_ALREADY_EXISTS_2_ERR . "\";\n";
	echo "	var EDITOR_DELETE_BLOG_CONFIRM_1_MSG = \"" . EDITOR_DELETE_BLOG_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_DELETE_BLOG_CONFIRM_2_MSG = \"" . EDITOR_DELETE_BLOG_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_DELETE_AREA_CONFIRM_1_MSG = \"" . EDITOR_DELETE_AREA_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_DELETE_AREA_CONFIRM_2_MSG = \"" . EDITOR_DELETE_AREA_CONFIRM_2_MSG . "\";\n";
	echo "	var EDITOR_DELETE_PAGE_CONFIRM_1_MSG = \"" . EDITOR_DELETE_PAGE_CONFIRM_1_MSG . "\";\n";
	echo "	var EDITOR_DELETE_PAGE_CONFIRM_2_MSG = \"" . EDITOR_DELETE_PAGE_CONFIRM_2_MSG . "\";\n";
	echo "	var SAVE_AS_WORD = \"" . SAVE_AS_WORD . "\";\n";
	echo "	var YES_WORD = \"" . YES_WORD . "\";\n";
	echo "	var NO_WORD = \"" . NO_WORD . "\";\n";
	echo "	var OK_WORD = \"" . OK_WORD . "\";\n";
	echo "	var CANCEL_WORD = \"" . CANCEL_WORD . "\";\n";
?>
</script>

</head>

<body id="workspace_body">

<form action="edit_page.php" method="post" name="frmEditPage">
<div style="height:93%; width:100%;" id="editorContainer" name="editorContainer"></div>

	<script type="text/javascript" language="javascript">
    //<![CDATA[
		CKEDITOR_BASEPATH = '../ckeditor/';
		
		CKEDITOR.replace( 'editorContainer', {
			filebrowserBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_WEBPAGE_DIR; ?>&langCode=<?php echo BWB_LANG; ?>',
			filebrowserImageBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_IMAGE_DIR; ?>&type=Images&langCode=<?php echo BWB_LANG; ?>',
			filebrowserFlashBrowseUrl: '/kfm/index.php?startup_folder=<?php echo BWB_FLASH_DIR; ?>&type=Flash&langCode=<?php echo BWB_LANG; ?>',
<?php 
	if ($disable_site_styles != 1)
	{
		echo "			contentsCss : [";
		$query = "SELECT * FROM " . BWB_TABLE_PREFIX . "style_sheets";
		$result = $bwb_dbh->query($query);
		$delim = "";
		while ($row = $result->fetch(PDO::FETCH_ASSOC))
		{
			$style_sheet = $row["name"] . ".css";
			echo $delim . "'" . $userfiles . "/" . BWB_CSS_DIR . "/" . $style_sheet . "'";
			$delim = ",";
		}
		echo "]\n";
	}
	else
		echo "			contentsCss : ['/ckeditor/contents.css']\n";
?>
		});

		CKEDITOR.config.language = '<?php echo BWB_LANG; ?>';
		CKEDITOR.config.extraPlugins = 'zoom,letterspacing,codemirror';
		CKEDITOR.config.skin = 'kama';
		CKEDITOR.config.allowedContent = true;
		if (disable_site_styles != 1)
			CKEDITOR.config.stylesSet = 'bwb_styles:/ckeditor/styles.js';
        var editorElem = document.getElementById("editorContainer");
        CKEDITOR.config.width = '99%';

		if ((browser == "Explorer") && (browser_version <= 7))
        	CKEDITOR.config.height = document.body.clientHeight - 215;
		else if ((browser == "Opera") && (browser_version < 13))
			CKEDITOR.config.height = window.innerHeight - 205;
		else if ((browser == "Explorer") && (browser_version == 8))
			CKEDITOR.config.height = document.body.clientHeight - 215;
		else
			CKEDITOR.config.height = editorElem.clientHeight - 135;
        CKEDITOR.config.resize_enabled = false;
<?php
		if (isset($_SESSION['editor_mode']) && ($_SESSION['editor_mode'] == 1))
			echo "		CKEDITOR.config.startupMode = 'source';\n";
?>

	CKEDITOR.config.codemirror = {
		 // Set this to the theme you wish to use (codemirror themes)
		theme: '<?php echo $CodeMirrorTheme; ?>',
		// Whether or not you want Brackets to automatically close themselves
		autoCloseBrackets: true,
		 // Whether or not you want tags to automatically close themselves
		autoCloseTags: true,
		 // Whether or not to automatically format code should be done when the editor is loaded
		autoFormatOnStart: true, 
		// Whether or not to automatically format code which has just been uncommented
		autoFormatOnUncomment: true,
		// Whether or not to continue a comment when you press Enter inside a comment block
		continueComments: true,
		 // Whether or not you wish to enable code folding (requires 'lineNumbers' to be set to 'true')
		enableCodeFolding: true,
		// Whether or not to enable code formatting
		enableCodeFormatting: true,
		// Whether or not to enable search tools, CTRL+F (Find), CTRL+SHIFT+F (Replace), CTRL+SHIFT+R (Replace All), CTRL+G (Find Next), CTRL+SHIFT+G (Find Previous)
		enableSearchTools: true,
		// Whether or not to highlight all matches of current word/selection
		highlightMatches: true,
		 // Whether, when indenting, the first N*tabSize spaces should be replaced by N tabs
		indentWithTabs: false,
		 // Whether or not you want to show line numbers
		lineNumbers: true,
		// Whether or not you want to use line wrapping
		lineWrapping: true,
		 // Define the language specific mode 'htmlmixed' for html  including (css, xml, javascript), 'application/x-httpd-php' for php mode including html, or 'text/javascript' for using java script only 
		mode: 'htmlmixed',
		// Whether or not you want to highlight matching braces
		matchBrackets: true,
		// Whether or not you want to highlight matching tags
		matchTags: true,
		// Whether or not to show the showAutoCompleteButton   button on the toolbar
		showAutoCompleteButton: true,
		 // Whether or not to show the comment button on the toolbar
		showCommentButton: true,
		// Whether or not to show the format button on the toolbar
		showFormatButton: true,
		 // Whether or not to show the search Code button on the toolbar
		showSearchButton: true,
		 // Whether or not to show Trailing Spaces
		showTrailingSpace: true,
		// Whether or not to show the uncomment button on the toolbar
		showUncommentButton: true,
		 // Whether or not to highlight the currently active line
		styleActiveLine: true,
		// "Whether or not to use Beautify for auto formatting
		useBeautify: false
	};
			
		var bwb_ckeditor = CKEDITOR.instances['editorContainer'];
		
		function somethingChanged()	{
			if ( bwb_ckeditor.checkDirty() )
			{
				saved = false;
				window.parent.SetWorkSavedNotSaved(saved);
				try	{
					bwb_ckeditor.commands.save.enable();
				}
				catch(err)	{
					err = 0;
				}
			}
		}

		function somethingHappened(e)	{
			if ( bwb_ckeditor.checkDirty() )
				window.parent.SetWorkSavedNotSaved(true);
				
			if (e.data.name == "newpage")
			{
				e.data.command = null;
				ClearContent();
			}
			else if (e.data.name == "preview")
			{
				e.data.command = null;
				Preview();
			}
			else if (e.data.name == "save")
			{
				e.data.command = null;
				Save('save_draft');
				try	{
					bwb_ckeditor.commands.save.disable();
				}
				catch(err)	{
					err = 0;
				}
				bwb_ckeditor.resetDirty();
			}
		}
		
//		LoadPage();
		
		bwb_ckeditor.on( 'saveSnapshot', function(e) { somethingChanged(); });
		bwb_ckeditor.on( 'beforeCommandExec', function(e) { somethingHappened(e); });
		
    //]]>
    </script>
            
      
	  <table width="100%" align="center" id="btn_table"><tr>
	  <td align="left" class="medium_message" width="9%">
      <?php echo EDITOR_PAGE_NAME; ?>:<br/><span id="page_name_label"><?php echo $page_name; ?></span>
	  </td>
      <td align="center" style="min-width:90px;">
      <div class='button_console_preview_sm' style="min-width:90px;" onClick="Preview('<?php echo $page_name; ?>', 0);"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_PREVIEW; ?></span></div>
	  </td>
      <td align="center" style="min-width:80px;">
      <div class='button_console_save_sm' style="min-width:80px;" onClick="Save('save_draft');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_SAVE; ?></span></div>
	  </td>
<?php if ($mode != "blog") { ?>
      <td align="center" style="min-width:90px;">
      <div class='button_console_save_sm' style="min-width:90px;" onClick="ShowSaveAsMsg();"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_SAVE_AS; ?></span></div>
	  </td>
<?php } ?>
	  <td align="center" style="min-width:90px;">
      <div class='button_console_save_sm' style="min-width:90px;" onClick="Save('publish');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_PUBLISH; ?></span></div>
	  </td>
      <td align="center" style="min-width:80px;">
      <div class='button_console_cancel_sm' style="min-width:80px;" onClick="RevertConfirm('<?php echo $mode; ?>');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_REVERT; ?></span></div>
	  </td>
<?php if (($access_level == "admin") || ($access_level == "power_user")) { ?>
	  <td align="center" style="min-width:80px;">
      <div class='button_console_delete_sm' style="min-width:80px;" onClick="DeleteConfirm('<?php echo $mode; ?>');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_DELETE; ?></span></div>
	  </td>
<?php } ?>
      <td align="center">
      <div class='button_console_preview_sm' id="see_site_btn" style="min-width:90px;"
<?php
		echo "onClick=\"window.open('..";
		echo $userfiles . $website_folder . "/";
      	if ($special == 1)
	  		echo "index";
		else
			echo $page_name;
		echo ".php', '_blank');\"";
?>
      ><span class='button_console_text_w_sm_icon' style="min-width:90px;"><?php echo EDITOR_SEE_SITE; ?></span></div>
	  </td>
      <td align="center" style="min-width:75px;">
      <div class='button_console_delete_sm' style="min-width:75px;" onClick="ClearContent();"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_CLEAR; ?></span></div>
      </td>
	  <td width="2%">&nbsp;
      
	  </td>
      <td align="center" style="min-width:145px;">
      <div class='button_console_image_sm' style="min-width:145px;" onClick="OptimizeResetImages('optimize');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_OPTIMIZE_IMAGES; ?></span></div>
      </td>
      <td align="center" style="min-width:125px;">
      <div class='button_console_image_sm' style="min-width:125px;" onClick="OptimizeResetImages('reset');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_RESET_IMAGES; ?></span></div>
      </td>
      <td style="min-width:115px;">
<?php if ($access_level != "restricted") { ?>
      <div class='button_console_edit_sm' style="min-width:115px;" onClick="window.open('edit_css.php?style_sheet=site','_blank');"><span class='button_console_text_w_sm_icon'><?php echo EDITOR_EDIT_STYLES; ?></span></div>
<?php } else echo "&nbsp;"; ?>
      </td>
      <td width="1%">&nbsp;</td>
      <td align="center" width="2%">
      <div class="help_button" <?php if (count($plugin_help) > 0) echo "onMouseOver='OpenHelpList(" . count($plugin_help). ");'"; else echo "onClick='OpenHelpWindow();'"; ?>>
	    &nbsp;
      </div>
	  </td>
	  </tr></table>
    </form>
    
 	<div id="help_list" style="display:none;" onMouseOut="fixOnMouseOut(this, event, 'CloseHelpList();');">&nbsp;</div>

<?php include("lib/popup_msg.html"); ?>

<script language="javascript" type="text/javascript">
	HidePopupMsg();
	
<?php 
	if ($refresh_buttons)	{
		echo "	parent.LoadPluginButtons();\n";
	}
?>
	mTimer3 = setTimeout("LoadPage();", 2000);
	mTimer = setTimeout("bwb_ckeditor.commands.save.disable(); saved = true; window.parent.SetWorkSavedNotSaved(true);", 4000);
	mTimerCheckDirty = setInterval("somethingChanged();", 8000);
	
	if (document.body.scrollWidth > document.body.clientWidth)
		CKEDITOR.config.height = CKEDITOR.config.height - 40;
</script>
</body>
</html>
