<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created:	11/28/2013	ELL
// 

	include ("check_session.php");
	
	$last_page_edited = $_SESSION['last_page_edited'];
?>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Edit Page Select | Breeze Website Builder</title>
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">

<script src="js/ajax.js"> </script>
<script src="js/edit_page_select.js"></script>

<?php if (($access_level == "admin") || ($access_level == "power_user"))	{	?>
<script>
	window.onscroll = LocateAttributesDiv;
</script>
<?php	}	?>

<style>
#editor_options_div	{
<?php if (($access_level == "admin") || ($access_level == "power_user"))	{	?>
	display:block;
	position:absolute;
	top:50px;
	left:400px;
<?php	} else	echo "	display:none;\n";	?>
}
</style>
</head>

<body onload="InitializeConsole();">
	<div id="sub_level_1_buttons">
	
        <div class="button_heading_sub_level_1"><div class="button_heading_text_sub_level_1"><?php echo EDIT_PAGE_SELECT_HEADING; ?></div><div class="button_heading_help" onclick="OpenHelpWindow();">&nbsp;</div></div>
		<?php
			if ($access_level == "restricted")
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data WHERE restricted = 0 ORDER BY page_name";
			else
				$query = "SELECT page_name FROM " . BWB_TABLE_PREFIX . "page_data ORDER BY page_name";
			$result = $bwb_dbh->query($query);
			$num_results = $result->rowCount();
			for ($i = 0; $i < $num_results; $i++)
			{
				$row = $result->fetch(PDO::FETCH_ASSOC);
				$page_name = $row["page_name"];
				if ($page_name == $last_page_edited)
					$selected = " down_sub";
				else
					$selected = "";
				if ($page_name == "index")
					$home = " (Home)";
				else
					$home = "";
				

				echo "<div class='button_sub_level_1$selected' onClick=\"window.location='edit_page.php?page_name=$page_name&mode=edit';\"><span class='button_text_sub_level_1'>$page_name$home</span></div>\n";
			}
			
		?>
    </div>
    
    <div id="editor_options_div">
    <span class="bold"><?php echo EDIT_PAGE_SELECT_OPTIONS_HEADING; ?></span><br /><br />
    <input type="checkbox" id="editor_mode" name="editor_mode" onchange="SetEditorMode();" <?php if (isset($_SESSION['editor_mode']) && ($_SESSION['editor_mode'] == 1)) echo "checked='checked'"; ?> />
    <?php echo EDIT_PAGE_SELECT_SOURCE_VIEW_OPTION; ?><br /><br />
    <?php echo EDIT_PAGE_SELECT_SITE_STYLES_HEADING; ?>:<br />
    <input type="radio" id="site_styles[0]" name="site_styles" onchange="SiteStyles(-1);" checked="checked" />
    <?php echo EDIT_PAGE_SELECT_PAGE_DEFAULT_STYLES_OPTION; ?><br />
    <input type="radio" id="site_styles[1]" name="site_styles" onchange="SiteStyles(0);" />
    <?php echo EDIT_PAGE_SELECT_SITE_DEFAULT_STYLES_OPTION; ?><br />
    <input type="radio" id="site_styles[2]" name="site_styles" onchange="SiteStyles(1);" />
    <?php echo EDIT_PAGE_SELECT_DISABLE_SITE_STYLES_OPTION; ?><br />
    </div>
</body>
</html>