<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/9/2013
// Revised: 12/13/2013	ELL
// Added refresh of main menu to update buttons and set to last selections.
//
	
	include ("check_session.php");
	
	$enable_file_manager = $_SESSION['enable_file_manager'];
	if ($enable_file_manager != "100")
		header("Location: /index.php");
		
	include ("lib/copy_dir.php");
	
	//////////////////////////////////////
	ini_set('max_execution_time', 10000);
	set_time_limit(10000);
	//////////////////////////////////////////
?>
<!DOCTYPE html>
<html>
<head>
<title>Installing Plugin | Breeze Website Builder</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="theme/<?php echo $theme; ?>/manager.css" type="text/css">
<link rel="shortcut icon" href="images/favicon.ico" type="image/x-icon">
</head>
<body>
<h2><?php echo INSTALL_PLUGIN_INSTALLING_PLUGIN; ?></h2>
<?php
	
	if (is_uploaded_file($_FILES['plugin_file']['tmp_name']))
	{	
		$source = $_FILES['plugin_file']['tmp_name'];
		$file_name = $_FILES['plugin_file']['name'];
		$file_parts = explode(".", $file_name);
		$file_ext = $file_parts[count($file_parts) - 1];
		if (!((strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "zip") == 0) || (strcasecmp($file_ext, "tar") == 0)))
		{
			echo INSTALL_PLUGIN_WRONG_FILE_TYPE_MSG . " <a href='upload_plugin.php'>" . HERE_WORD . "</a> " . AND_TRY_AGAIN;
			exit;
		}
		$document_root = getenv('DOCUMENT_ROOT');
		$destination = $document_root . "/" . $file_name;
		move_uploaded_file( $source, $destination );
		$source = $destination;
		
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		// Note: phar->decompress removes the all of the file name after the FIRST dot "." then appends the ".tar"
			$tar_source =  $document_root . "/" . $file_parts[0] . ".tar";
		
		$destination = $document_root . "/tmp";
		if (!file_exists($destination))
			mkdir($destination, 0755);
		else
		{
			$bkup = $destination . date('YmdHis', time());
			rename($destination, $bkup);
			mkdir($destination, 0755);
		}
		
		echo INSTALL_PLUGIN_EXTRACTING_FILES . "<br><br>\n";
		// Extract contents of archive to disk
		if (strcasecmp($file_ext, "zip") == 0)
		{
			$zip = new ZipArchive;
			$res = $zip->open($source);
			if ($res === TRUE) {
			  $zip->extractTo($destination);
			  $zip->close();
			} else {
			  echo INSTALL_PLUGIN_ERROR_EXTRACTING_FILES_1_ERR . " " . CLICK_WORD . " <a href='upload_plugin.php'>" . HERE_WORD . "</a> " . TO_TRY_AGAIN;
			  exit;
			}
		}
		elseif ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0))
		{
			// decompress from gz
			try {
				$p = new PharData($source);
				$p->decompress(".tar"); // creates /path/to/my.tar
			} catch (Exception $e) {
				echo INSTALL_PLUGIN_ERROR_EXTRACTING_FILES_1A_ERR . " " . CLICK_WORD . " <a href='upload_plugin.php'>" . HERE_WORD . "</a> " . TO_TRY_AGAIN . "<br/>$e";
				exit;
			}
		}
		
		// unarchive from the tar
		if ((strcasecmp($file_ext, "gz") == 0) || (strcasecmp($file_ext, "tgz") == 0) || (strcasecmp($file_ext, "tar") == 0))
		{
			try {
				$phar = new PharData($tar_source);
				$phar->extractTo($destination, null, true);
			} catch (Exception $e) {
				echo INSTALL_PLUGIN_ERROR_EXTRACTING_FILES_1B_ERR . " " . CLICK_WORD . " <a href='upload_plugin.php'>" . HERE_WORD . "</a> ". TO_TRY_AGAIN . "<br/>$e";
				exit;
			}
		}
			
		// Copy files to correct folders.
		echo INSTALL_PLUGIN_COPYING_FILES . "<br><br>\n";
		$extracted_source = $document_root . "/tmp";
		$destination = $document_root;
		copydir($extracted_source, $destination, 0755, true);
		unlink($document_root . "/plugin.sql");
		unlink($source);
		if (file_exists($tar_source))
			unlink($tar_source);
		
		// Run template SQL
		$sql_file = "plugin.sql";
		include ("run_sql_file.php");
		
		$_SESSION['button_group'] = "other_functions";
		$_SESSION['button'] = "btn_users_site_options";
		$_SESSION['sub_button'] = "btn_upload_plugin";
		$_SESSION['install_plugin_mode'] = time() + 600;
?>
		<h2><?php echo INSTALL_PLUGIN_PLUGIN_INSTALLATION_COMPLETE; ?></h2>
        <p><?php echo CLICK_WORD; ?> <a href="main.php" target="_top"><?php echo HERE_WORD; ?></a> <?php echo INSTALL_PLUGIN_ADD_NEW_BUTTON_TO_MENU_MSG; ?></p>

<?php
	}
	else
		echo INSTALL_PLUGIN_ERROR_UPLOADING_FILE_ERR . " " . CLICK_WORD . " <a href='upload_plugin.php'>" . HERE_WORD . "</a> ". TO_TRY_AGAIN;
?>