<?php
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/27/2014
//
	
	function uploadImage($fileName, $maxSize, $maxW, $fullPath, $relPath, $fullPathTN, $relPathTN, $colorR, $colorG, $colorB, $maxH = null, $tnW = 100, $tnH = null, $processImg = false ){
		$folder = $relPath;
		$folderTN = $relPathTN;
		$maxlimit = $maxSize;
		$allowed_ext = "jpg,jpeg,gif,png,bmp";
		$match = "";
		$filesize = $_FILES[$fileName]['size'];
		if($filesize > 0){	
			//$filename = strtolower($_FILES[$fileName]['name']);
			$filename = $_FILES[$fileName]['name'];
			$filename = preg_replace('/\s/', '_', $filename);
		   	if($filesize < 1){ 
				$errorList[] = "$fileName, File size is empty.";
			}
			if($filesize > $maxlimit){ 
				$errorList[] = "$fileName, File size is too big.";
			}
			if(count($errorList)<1){
				$file_ext = preg_split("/\./",$filename);
				$allowed_ext = preg_split("/\,/",$allowed_ext);
				foreach($allowed_ext as $ext){
					if($ext==end($file_ext)){
						$match = "1"; // File is allowed
						if (file_exists($folder.$filename))
						{
							$NUM = time();
							$front_name = substr($file_ext[0], 0);
							$newfilename = $front_name."_".$NUM.".".end($file_ext);
						}
						else
							$newfilename = $filename;
						$filetype = end($file_ext);
						$saveFull = $folder.$newfilename;
						$saveTN = $folderTN.$newfilename;
						
						if(!file_exists($saveFull))
							move_uploaded_file ( $_FILES[$fileName]['tmp_name'] , $saveFull );
						else
							$errorList[]= "CANNOT MAKE IMAGE IT ALREADY EXISTS";
							
						// Create thumbnail
						if(!file_exists($saveTN))	{
							list($width_orig, $height_orig) = getimagesize($saveFull);
							if($tnH == null){
								if($width_orig < $tnW){
									$fwidth = $width_orig;
								}else{
									$fwidth = $tnW;
								}
								$ratio_orig = $width_orig/$height_orig;
								$fheight = $fwidth/$ratio_orig;
								
								$blank_height = $fheight;
								$top_offset = 0;
									
							}else{
								if($width_orig <= $tnW && $height_orig <= $tnH){
									$fheight = $height_orig;
									$fwidth = $width_orig;
								}else{
									if($width_orig > $tnW){
										$ratio = ($width_orig / $tnW);
										$fwidth = $tnW;
										$fheight = ($height_orig / $ratio);
										if($fheight > $tnH){
											$ratio = ($fheight / $tnH);
											$fheight = $tnH;
											$fwidth = ($fwidth / $ratio);
										}
									}
									if($height_orig > $tnH){
										$ratio = ($height_orig / $tnH);
										$fheight = $tnH;
										$fwidth = ($width_orig / $ratio);
										if($fwidth > $tnW){
											$ratio = ($fwidth / $tnW);
											$fwidth = $tnW;
											$fheight = ($fheight / $ratio);
										}
									}
								}
								if($fheight == 0 || $fwidth == 0 || $height_orig == 0 || $width_orig == 0){
									die("FATAL ERROR");
								}
								if($fheight < 45){
									$blank_height = 45;
									$top_offset = round(($blank_height - $fheight)/2);
								}else{
									$blank_height = $fheight;
								}
							}
							$image_p = imagecreatetruecolor($fwidth, $blank_height);
							$white = imagecolorallocate($image_p, $colorR, $colorG, $colorB);
							imagefill($image_p, 0, 0, $white);
							switch($filetype){
								case "gif":
									$image = @imagecreatefromgif($saveFull);
								break;
								case "jpg":
									$image = @imagecreatefromjpeg($saveFull);
								break;
								case "jpeg":
									$image = @imagecreatefromjpeg($saveFull);
								break;
								case "png":
									$image = @imagecreatefrompng($saveFull);
								break;
							}
							@imagecopyresampled($image_p, $image, 0, $top_offset, 0, 0, $fwidth, $fheight, $width_orig, $height_orig);
							switch($filetype){
								case "gif":
									if(!@imagegif($image_p, $saveTN)){
										$errorList[]= "PERMISSION DENIED [GIF]";
									}
								break;
								case "jpg":
									if(!@imagejpeg($image_p, $saveTN, 100)){
										$errorList[]= "PERMISSION DENIED [JPG]";
									}
								break;
								case "jpeg":
									if(!@imagejpeg($image_p, $saveTN, 100)){
										$errorList[]= "PERMISSION DENIED [JPEG]";
									}
								break;
								case "png":
									if(!@imagepng($image_p, $saveTN, 0)){
										$errorList[]= "PERMISSION DENIED [PNG]";
									}
								break;
							}
							@imagedestroy($filename);
						}else{
							$errorList[]= "CANNOT MAKE IMAGE IT ALREADY EXISTS";
						}
							
						if ($processIMG)	{
							// Process full-size image
						  if(!file_exists($saveFull))	{
							list($width_orig, $height_orig) = getimagesize($saveFull);
							if($maxH == null){
								if($width_orig < $maxW){
									$fwidth = $width_orig;
								}else{
									$fwidth = $maxW;
								}
								$ratio_orig = $width_orig/$height_orig;
								$fheight = $fwidth/$ratio_orig;
								
								$blank_height = $fheight;
								$top_offset = 0;
									
							}else{
								if($width_orig <= $maxW && $height_orig <= $maxH){
									$fheight = $height_orig;
									$fwidth = $width_orig;
								}else{
									if($width_orig > $maxW){
										$ratio = ($width_orig / $maxW);
										$fwidth = $maxW;
										$fheight = ($height_orig / $ratio);
										if($fheight > $maxH){
											$ratio = ($fheight / $maxH);
											$fheight = $maxH;
											$fwidth = ($fwidth / $ratio);
										}
									}
									if($height_orig > $maxH){
										$ratio = ($height_orig / $maxH);
										$fheight = $maxH;
										$fwidth = ($width_orig / $ratio);
										if($fwidth > $maxW){
											$ratio = ($fwidth / $maxW);
											$fwidth = $maxW;
											$fheight = ($fheight / $ratio);
										}
									}
								}
								if($fheight == 0 || $fwidth == 0 || $height_orig == 0 || $width_orig == 0){
									die("FATAL ERROR");
								}
								if($fheight < 45){
									$blank_height = 45;
									$top_offset = round(($blank_height - $fheight)/2);
								}else{
									$blank_height = $fheight;
								}
							}
							$image_p = imagecreatetruecolor($fwidth, $blank_height);
							$white = imagecolorallocate($image_p, $colorR, $colorG, $colorB);
							imagefill($image_p, 0, 0, $white);
							switch($filetype){
								case "gif":
									$image = @imagecreatefromgif($saveFull);
								break;
								case "jpg":
									$image = @imagecreatefromjpeg($saveFull);
								break;
								case "jpeg":
									$image = @imagecreatefromjpeg($saveFull);
								break;
								case "png":
									$image = @imagecreatefrompng($saveFull);
								break;
							}
							@imagecopyresampled($image_p, $image, 0, $top_offset, 0, 0, $fwidth, $fheight, $width_orig, $height_orig);
							switch($filetype){
								case "gif":
									if(!@imagegif($image_p, $saveFull)){
										$errorList[]= "PERMISSION DENIED [GIF]";
									}
								break;
								case "jpg":
									if(!@imagejpeg($image_p, $saveFull, 100)){
										$errorList[]= "PERMISSION DENIED [JPG]";
									}
								break;
								case "jpeg":
									if(!@imagejpeg($image_p, $saveFull, 100)){
										$errorList[]= "PERMISSION DENIED [JPEG]";
									}
								break;
								case "png":
									if(!@imagepng($image_p, $saveFull, 0)){
										$errorList[]= "PERMISSION DENIED [PNG]";
									}
								break;
							}
							@imagedestroy($filename);
						 
						}else{
							$errorList[]= "CANNOT MAKE IMAGE IT ALREADY EXISTS";
						}
					  }	// if process image
					}
				}		
			}
		}else{
			$errorList[]= "NO FILE SELECTED";
		}
		if(!$match){
		   	$errorList[]= "File type isn't allowed: $filename";
		}
		if(sizeof($errorList) == 0){
			return $fullPath . $newfilename . "@@@@@" . $fullPathTN . $newfilename;
		}else{
			$eMessage = array();
			for ($x=0; $x<sizeof($errorList); $x++){
				$eMessage[] = $errorList[$x];
			}
		   	return $eMessage;
		}
	}	// end uploadImage function
	
	//////////////////////////////////////////////////////////////////////////////////////////////////////
	$filename = strip_tags($_REQUEST['filename']);
	$maxSize = strip_tags($_REQUEST['maxSize']);
	$maxW = strip_tags($_REQUEST['maxW']);
	$fullPath = strip_tags($_REQUEST['fullPath']);
	$relPath = strip_tags($_REQUEST['relPath']);
	$fullPathTN = strip_tags($_REQUEST['fullPathTN']);
	$relPathTN = strip_tags($_REQUEST['relPathTN']);
	$colorR = strip_tags($_REQUEST['colorR']);
	$colorG = strip_tags($_REQUEST['colorG']);
	$colorB = strip_tags($_REQUEST['colorB']);
	$maxH = strip_tags($_REQUEST['maxH']);
	$tnW = strip_tags($_REQUEST['tnW']);
	$tnH = strip_tags($_REQUEST['tnH']);
	$processImg = strip_tags($_REQUEST['processImg']);
	$filesize_image = $_FILES[$filename]['size'];
	if($filesize_image > 0){
		$upload_image = uploadImage($filename, $maxSize, $maxW, $fullPath, $relPath, $fullPathTN, $relPathTN, $colorR, $colorG, $colorB, $maxH, $tnW, $tnH, $processImg);
		if(is_array($upload_image)){
			foreach($upload_image as $key => $value) {
				if($value == "-ERROR-") {
					unset($upload_image[$key]);
				}
			}
			$document = array_values($upload_image);
			for ($x=0; $x<sizeof($document); $x++){
				$errorList[] = $document[$x];
			}
			$imgUploaded = false;
		}else{
			$imgUploaded = true;
			$imageArr = explode("@@@@@", $upload_image);
			$image_full = $imageArr[0];
			$image_tn = $imageArr[1];
		}
	}else{
		$imgUploaded = false;
		$errorList[] = "File Size Empty";
	}
?>
<?php
	if($imgUploaded)
	{
		$popupW = strip_tags($_REQUEST['popupW']);
		$popupH = strip_tags($_REQUEST['popupH']);
		
		echo "<img src='".$image_tn."' border='0' width='".$tnW."' height='".$tnH."' style='cursor:default;' onClick=\"window.open('".$image_full."','view_photo','menubar=0,resizable=0,width=".$popupW.",height=".$popupH.",location=0,status=0,scrollbars=1,toolbar=0,directories=0');\" onMouseOver=\"this.style.cursor='pointer';\"  />";
	}
	else
	{
		echo '<img src="images/error.gif" width="16" height="16px" border="0" style="margin-bottom: -3px;" /> Error(s) Found: ';
		foreach($errorList as $value){
	    		echo $value.', ';
		}
	}
?>