////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/18/2013	ELL
// Revised: 7/1/2013	ELL
// Implemented popup message class.
// Revised: 2/18/2015	ELL
// Added alpha sorting of classes.
// Revised: 4/28/2015	ELL
// Added copy class function.
// Revised: 5/5/2015	ELL
// Replaced JavaScript AJAX with JQuery AJAX.
// Converted from form post to (JQuery) AJAX.
// Added style-sheet switching.


var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

var copy_rename_mode = "copy";

function OpenHelpWindow(topic)
{
	var help_url = "http://breezewebsitebuilder.com/docs/cms/help.html#" + topic;
	window.open(help_url, "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function InitializeConsole()
{
	GetClassLists();
}

//////////////////////////////////////////////////////////////////////////////////////
function GetClassLists()
{
	$.post( "get_classes.php", { style_sheet: style_sheet } ).done(PopulateClassLists) ;
}
function PopulateClassLists(data)
{
	var list_delim = ":::::";
	var row_delim = "@@@@@";
	var lists = data.split(list_delim);
	
	var JSON_class_row;

	var class_list_sort_1 = lists[0].split(row_delim);
	var html = "<select name='class' id='class'>\n";
	for (var i = 0; i < class_list_sort_1.length; i++)
	{
		JSON_class_row = JSON.parse(class_list_sort_1[i]);
		html = html + "<option value='" + JSON_class_row.class + "'>" + JSON_class_row.class + "</option>\n";
	}
	html = html + "</select>\n";
	document.getElementById("class_td").innerHTML = html;
	
	
	var class_list_sort_2 = lists[1].split(row_delim);
	var html_subclass = "<select name='subclass' id='subclass' onChange='CheckForParam(this.value);'>\n";
	html_subclass = html_subclass + "<option value=':link'>:link</option>\n";
    html_subclass = html_subclass + "<option value=':hover'>:hover</option>\n";
	html_subclass = html_subclass + "<option value=':visited'>:visited</option>\n";
	html_subclass = html_subclass + "<option value=':active'>:active</option>\n";
	html_subclass = html_subclass + "<option value='::before'>::before</option>\n";
	html_subclass = html_subclass + "<option value='::after'>::after</option>\n";
	html_subclass = html_subclass + "<option value=':checked'>:checked</option>\n";
	html_subclass = html_subclass + "<option value=':disabled'>:disabled</option>\n";
	html_subclass = html_subclass + "<option value=':enabled'>:enabled</option>\n";
	html_subclass = html_subclass + "<option value=':focus'>:focus</option>\n";
	for (var i = 0; i < class_list_sort_2.length; i++)
	{
		JSON_class_row = JSON.parse(class_list_sort_2[i]);
		html_subclass = html_subclass + "<option value='" + JSON_class_row.class + "'>" + JSON_class_row.class + "</option>\n";
	}
	html_subclass = html_subclass + "<option value=':target'>:target</option>\n";
	html_subclass = html_subclass + "<option value='::selection'>::selection</option>\n";
	html_subclass = html_subclass + "<option value=':read-only'>:read-only</option>\n";
	html_subclass = html_subclass + "<option value=':read-write'>:read-write</option>\n";
	html_subclass = html_subclass + "<option value=':not'>:not</option>\n";
	html_subclass = html_subclass + "<option value=':empty'>:empty</option>\n";
	html_subclass = html_subclass + "<option value='::first-letter'>::first-letter</option>\n";
	html_subclass = html_subclass + "<option value='::first-line'>::first-line</option>\n";
	html_subclass = html_subclass + "<option value=':first-child'>:first-child</option>\n";
	html_subclass = html_subclass + "<option value=':last-child'>:last-child</option>\n";
	html_subclass = html_subclass + "<option value=':nth-child'>:nth-child</option>\n";
	html_subclass = html_subclass + "<option value=':nth-last-child'>:nth-last-child</option>\n";
	html_subclass = html_subclass + "<option value=':only-child'>:only-child</option>\n";
	html_subclass = html_subclass + "<option value=':first-of-type'>:first-of-type</option>\n";
	html_subclass = html_subclass + "<option value=':last-of-type'>:last-of-type</option>\n";
	html_subclass = html_subclass + "<option value=':nth-of-type'>:nth-of-type</option>\n";
	html_subclass = html_subclass + "<option value=':nth-last-of-type'>:nth-last-of-type</option>\n";
	html_subclass = html_subclass + "<option value=':only-of-type'>:only-of-type</option>\n";
	html_subclass = html_subclass + "<option value=':in-range'>:in-range</option>\n";
	html_subclass = html_subclass + "<option value=':out-of-range'>:out-of-range</option>\n";
	html_subclass = html_subclass + "<option value=':valid'>:valid</option>\n";
	html_subclass = html_subclass + "<option value=':invalid'>:invalid</option>\n";
	html_subclass = html_subclass + "<option value=':lang'>:lang</option>\n";
	html_subclass = html_subclass + "<option value=':required'>:required</option>\n";
	html_subclass = html_subclass + "<option value=':optional'>:optional</option>\n";
	html_subclass = html_subclass + "<option value=':root'>:root</option>\n";
	html_subclass = html_subclass + "</select>\n";
	document.getElementById("subclass_div").innerHTML = html_subclass;
	
	
	var class_list_sort_order = lists[2].split(row_delim);
	var bgcolor = "#E5E5E5";
	
	var html_sort = "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
  	html_sort = html_sort + "<tr>\n";
    html_sort = html_sort + "<td colspan='4' class='sub_title' style='padding-left:5px;'><?php echo CLASSES_SET_CLASS_SORT_ORDER; ?></td>\n";
  	html_sort = html_sort + "</tr>\n";
  	html_sort = html_sort + "<tr bgcolor='#CCCCCC'>\n";
  	html_sort = html_sort + "<td>&nbsp;&nbsp;&nbsp;&nbsp;</td>\n";
    html_sort = html_sort + "<td><b>" + CLASSES_CLASS_DESCRIPTION + ":</b></td>\n";
    html_sort = html_sort + "<td><b>" + SORT_ORDER + ":</b></td>\n";
    html_sort = html_sort + "<td><b>" + CUSTOM_WORD + ":</b></td>\n";
  	html_sort = html_sort + "</tr>\n";
  
	for (var i = 0; i < class_list_sort_order.length; i++)
	{
		JSON_class_row = JSON.parse(class_list_sort_order[i]);
		
		html_sort = html_sort + "<tr bgcolor='" + bgcolor + "'>\n<td>&nbsp;</td>\n";
		html_sort = html_sort + "<td>" + JSON_class_row.class + " / " + JSON_class_row.description + "<input type='hidden' name='class_" + i + "' value='" + JSON_class_row.class + "'></td>\n";
		html_sort = html_sort + "<td><input type='text' name='sort_order_" + i + "' value='" + JSON_class_row.sort_order + "'></td>\n";
		if (JSON_class_row.custom == 1)
			html_sort = html_sort + "<td>&radic;</td>\n</tr>\n";
		else
			html_sort = html_sort + "<td>&nbsp;</td>\n</tr>\n";
		if (bgcolor == "#E5E5E5")
			bgcolor = "#DDDDDD";
		else
			bgcolor = "#E5E5E5";
	}
	
	html_sort = html_sort + "<tr><td colspan='4'>&nbsp;\n";
  	html_sort = html_sort + "<input type='hidden' name='style_sheet' value='" + style_sheet + "' />\n";
  	html_sort = html_sort + "<input type='hidden' name='show_class_editor' value='1' /></td></tr>\n";
  	html_sort = html_sort + "<tr>\n";
    html_sort = html_sort + "<td colspan='4' align='center' style='padding-bottom:10px;'>\n";
    html_sort = html_sort + "<div class='button_console_save' style='width:110px;' onClick='SetSortOrder();'><span class='button_console_text_w_icon'>" + UPDATE_WORD + "</span></div>\n";
    html_sort = html_sort + "</td>\n";
  	html_sort = html_sort + "</tr>\n";
	html_sort = html_sort + "</table>\n";
	
	document.getElementById("class_sort_div").innerHTML = html_sort;
	
	
	if ((lists[3] != undefined) && (lists[3] != "") && (lists[3] != null))
	{
		var custom_class_list = lists[3].split(row_delim);
		
		var html_delete = "<select name='class_delete' id='class_delete'>\n";
		
		var html_edit = "<select name='class_edit' id='class_edit' onChange='PopulateDescription();'>\n";
		html_edit = html_edit + "<option>-not selected-</option>\n";
		
		var html_copy_from = "<select name='copy_from_class' id='copy_from_class' onChange='CheckClassNames();'>\n";
		html_copy_from = html_copy_from + "<option>-not selected-</option>\n";
		
		for (var i = 0; i < custom_class_list.length; i++)
		{
			JSON_class_row = JSON.parse(custom_class_list[i]);
			html_delete = html_delete + "<option value='" + JSON_class_row.class + "'>" + JSON_class_row.class + " / " + JSON_class_row.description + "</option>\n";
			html_edit = html_edit + "<option value='" + JSON_class_row.class + "'>" + JSON_class_row.class + "</option>\n";
			html_copy_from = html_copy_from + "<option value='" + JSON_class_row.class + "'>" + JSON_class_row.class + "</option>\n";
		}
		html_delete = html_delete + "</select>\n";
		html_edit = html_edit + "</select>\n";
		html_copy_from = html_copy_from + "</select>\n";
		
		document.getElementById("class_delete_div").innerHTML = html_delete;
		document.getElementById("class_edit_div").innerHTML = html_edit;
		document.getElementById("copy_from_class_td").innerHTML = html_copy_from;
	}
	else
	{
		document.getElementById("class_delete_div").innerHTML = "<div class='no_custom_class'>" + CLASSES_NO_CUSTOM_CLASSES_DEFINED + "</div>";
		document.getElementById("class_edit_div").innerHTML = "<div class='no_custom_class'>" + CLASSES_NO_CUSTOM_CLASSES_DEFINED + "</div>";
		document.getElementById("copy_from_class_td").innerHTML = "<div class='no_custom_class'>" + CLASSES_NO_CUSTOM_CLASSES_DEFINED + "</div>";
	}
}

//////////////////////////////////////////////////////////////////////////////////////
function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	var delete_text = document.getElementById("class_delete").value;
	popup_msg.popup_msg_cell = CLASSES_DELETE_CLASS_CONFIRM_1_MSG + " <b>" + delete_text + "</b>" + CLASSES_DELETE_CLASS_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteClass(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

function DeleteClass()
{
	var class_delete = document.getElementById("class_delete").value;
	class_delete = EscapeClass(class_delete);
	HidePopupMsg();
	
	$.post( "delete_class.php", { class: class_delete, style_sheet: style_sheet } ).done(CompleteDeleteClass) ;
}
function CompleteDeleteClass(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (data == 1)
		popup_msg.status_msg = CLASSES_DELETE_CLASS_COMPLETE_MSG;
	else
		popup_msg.status_msg = response;
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateDescription()
{	
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = CLASSES_STARTING_POPULATE_MSG;
	popup_msg.popup_timeout = 3000;

	var class_edit = document.getElementById("class_edit").value;
	class_edit = EscapeClass(class_edit);
	
	$.post( "populate_class_description.php", { class: class_edit, style_sheet: style_sheet } ).done(CompletePopulateDescription) ;
}
function CompletePopulateDescription(data)
{
	document.getElementById("description_edit").value = data;
	
	if ((data == "-no data-") || (data.length < 1))
		popup_msg.status_msg = CLASSES_DESCRIPTION_NOT_FOUND_MSG;
	else
		popup_msg.status_msg = "<b>" + CLASSES_DESCRIPTION_FOUND_MSG + "<\/b><br/>\n";
	
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateDescription()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = 3000;
		
	var class_edit = document.getElementById("class_edit").value;
	class_edit = EscapeClass(class_edit);
	var description = document.getElementById("description_edit").value;
	
	$.post( "update_class_description.php", { class: class_edit, style_sheet: style_sheet, description: description } ).done(CompleteUpdateDescription) ;
}
function CompleteUpdateDescription(data)
{
	if ((data == "-no data-") || (data.length < 1))
		popup_msg.status_msg = CLASSES_COULD_NOT_UPDATE_DESCRIPTION_MSG;
	else	{
		popup_msg.status_msg = "<b>" + CLASSES_DESCRIPTION_UPDATED_MSG + "<\/b><br/>\n";
		document.getElementById("description_edit").value = "";
	}
					
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
}

//////////////////////////////////////////////////////////////////////////////////////
function EscapeClass(class_escape)
{
	class_escape = class_escape.replace(/\./g, "PERIOD");
	class_escape = class_escape.replace(/#/g, "POUND");
	class_escape = class_escape.replace(/ /g, "SPACE");
	class_escape = class_escape.replace(/,/g, "COMMA");
	class_escape = class_escape.replace(/>/g, "GREATERTHAN");
	class_escape = class_escape.replace(/&gt;/g, "GREATERTHAN");
	class_escape = class_escape.replace(/\+/g, "PLUS");
	class_escape = class_escape.replace(/~/g, "TILDA");
	return(class_escape);
}

///////////////////////////////////////////////////////////////////////////////////////
function EnableDisableSubclass(bChecked)
{
	if (bChecked)	{
		document.getElementById("subclass").style.visibility = "hidden";
		document.getElementById("subclass_heading_td").style.visibility = "hidden";
		document.getElementById("operator").style.visibility = "hidden";
		document.getElementById("selector_param_span").style.visibility = "hidden";
		document.getElementById("help_button_operator").style.visibility = "hidden";
		document.getElementById("help_button_selector").style.visibility = "hidden";
	}
	else	{
		document.getElementById("subclass").style.visibility = "visible";
		document.getElementById("subclass_heading_td").style.visibility = "visible";
		CheckForParam(document.getElementById("subclass").value);
	}
}

///////////////////////////////////////////////////////////////////////////////////////
function CheckForParam(selector)
{
	if (selector.indexOf(":") == 0)	{
		document.getElementById("operator").style.visibility = "hidden";
		document.getElementById("help_button_operator").style.visibility = "hidden";
		document.getElementById("selector_param_span").style.visibility = "hidden";
		document.getElementById("help_button_selector").style.visibility = "hidden";
	}
	else	{
		document.getElementById("operator").style.visibility = "visible";
		document.getElementById("help_button_operator").style.visibility = "visible";
	}
	
	var selectors_w_params = new Array(":not",":nth-child",":nth-last-child",":nth-of-type",":nth-last-of-type",":lang");
	
	if (selectors_w_params.indexOf(selector) > -1)
		document.getElementById("selector_param_span").style.visibility = "visible";
	else
		document.getElementById("selector_param_span").style.visibility = "hidden";
		
	var no_op_selectors = new Array(":link",":hover",":visited",":active","::before","::after",":checked",":disabled",":enabled",":focus",":target","::selection",":read-only",":read-write",":not",":empty","::first-letter","::first-line",":first-child",":last-child",":nth-child",":nth-last-child",":only-child",":first-of-type",":last-of-type",":nth-of-type",":nth-last-of-type",":only-of-type",":in-range",":out-of-range",":valid",":invalid",":lang",":required",":optional",":root");
	
	if (no_op_selectors.indexOf(selector) > -1)
		document.getElementById("help_button_selector").style.visibility = "visible";		
	else
		document.getElementById("help_button_selector").style.visibility = "hidden";
}

//////////////////////////////////////////////////////////////////////////////////////
function ChangeSort(bAlpha)
{
	var sort_alpha = 0;
	if (bAlpha === true)
		sort_alpha = 1;
	
	$.post( "get_classes.php", { style_sheet: style_sheet, class_sort_method: sort_alpha } ).done(PopulateClassLists) ;
	
	document.getElementById("sort_alpha_delete").checked = bAlpha;
	document.getElementById("sort_alpha_edit").checked = bAlpha;
	document.getElementById("sort_alpha_copy").checked = bAlpha;
	document.getElementById("sort_alpha_create").checked = bAlpha;
}

///////////////////////////////////////////////////////////////////////////////////////
function CopyClass()
{
	var copy_from_class = document.getElementById("copy_from_class").value;
	var copy_to_class = document.getElementById("copy_to_class_prefix").value + document.getElementById("copy_to_class").value;
	var to_style_sheet = document.getElementById("to_style_sheet").value;
	
	if ((copy_from_class == "-not selected-") || (copy_from_class == ""))
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 200;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = CLASSES_COPY_FROM_CLASS_BLANK_ERR;
		popup_msg.popup_timeout = 8000;
		popup_msg.ShowPopupMsg();
		return;
	}
	if (copy_to_class == "")
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 200;
		popup_msg.popup_msg_type = 2;
		popup_msg.status_msg = CLASSES_COPY_TO_CLASS_BLANK_ERR;
		popup_msg.popup_timeout = 8000;
		popup_msg.ShowPopupMsg();
		return;
	}
	
	$.post( "copy_class.php", { mode: copy_rename_mode, copy_from_class: copy_from_class, copy_to_class: copy_to_class, style_sheet: style_sheet, to_style_sheet: to_style_sheet } ).done(CompleteCopyClass) ;
}
function CompleteCopyClass(data)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 200;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (data == "-no data-")
		popup_msg.status_msg = CLASSES_COPY_CLASS_ERR;
	else if (data == "to class already exists")	{
		popup_msg.status_msg = CLASSES_COPY_CLASS_TO_CLASS_ALREADY_EXISTS_ERR;
		document.getElementById("copy_to_class").value = "";
	}
	else	{
		popup_msg.status_msg = CLASSES_COPY_CLASS_COMPLETE_MSG;
		document.getElementById("copy_to_class").value = "";
	}
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
}

function EnableDisableStyleSheetSelection(new_mode)
{
	copy_rename_mode = new_mode;
	
	if (copy_rename_mode == "copy")	{
		document.getElementById("to_style_sheet").disabled = false;
		document.getElementById("to_style_sheet_label").style.color = "#000000";
		document.getElementById("copy_radio_btn").className = "radio_button";
		document.getElementById("copy_radio_btn").className += " checked";
		document.getElementById("rename_radio_btn").className = "radio_button";
	}
	else	{
		document.getElementById("to_style_sheet").disabled = true;
		document.getElementById("to_style_sheet_label").style.color = "#A6A6A6";
		document.getElementById("copy_radio_btn").className = "radio_button";
		document.getElementById("rename_radio_btn").className = "radio_button";
		document.getElementById("rename_radio_btn").className += " checked";
	}
	
	CheckClassNames();
}

function CheckClassNames()
{
	var copy_from_class = document.getElementById("copy_from_class").value;
	var copy_to_class = document.getElementById("copy_to_class").value;
	
	if ((copy_to_class.length > 0) && (copy_to_class != " ") && (copy_from_class.length > 0) && (copy_from_class != "") && (copy_from_class != "-not selected-"))
		document.getElementById("copy_rename_btn").className = "button_console_edit";
	else
		document.getElementById("copy_rename_btn").className = "button_console_edit_disabled";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function AddClass()
{
	$.ajax({type:'POST', url: 'add_class.php', data:$('#formAddTag').serialize(), success: function(response) {
		CompleteAddClass(response);
	}});
}
function CompleteAddClass(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (response == 1)
		popup_msg.status_msg = CLASSES_ADD_CLASS_COMPLETE_MSG;
	else
		popup_msg.status_msg = response;
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
	document.getElementById("class").value = "";
	document.getElementById("description").value = "";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function DefineSubClass()
{
	$.ajax({type:'POST', url: 'define_sub_class.php', data:$('#formDefineSubclass').serialize(), success: function(response) {
		CompleteDefineSubClass(response);
	}});
}
function CompleteDefineSubClass(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (response == 1)
		popup_msg.status_msg = CLASSES_DEFINE_SUBCLASS_COMPLETE_MSG;
	else
		popup_msg.status_msg = CLASSES_DEFINE_SUBCLASS_DEFINE_ERR;
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function SetSortOrder()
{
	$.ajax({type:'POST', url: 'set_class_sort_order.php', data:$('#formSortTags').serialize(), success: function(response) {
		CompleteSetSortOrder(response);
	}});
}
function CompleteSetSortOrder(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 2000;
	if (response == 1)
		popup_msg.status_msg = CLASSES_UPDATE_SORT_ORDER_COMPLETE_MSG;
	else
		popup_msg.status_msg = CLASSES_UPDATE_SORT_ORDER_UPDATE_ERR;
	popup_msg.ShowPopupMsg();
	
	GetClassLists();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}