/////////////////////////////////////////////
// Manage Page Access Management /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/27/2015	ELL
// 
// 
//
var max_rec = 50;
var page = 0;
var num_users = 0;
var total_pages = 0;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#copy_public_user_to_restricted", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}


function DeleteUserConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_1_MSG + " <b>" + document.getElementById("selectUserNameDelete").value + "</b>" + MANAGE_PAGE_ACCESS_DELETE_USER_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteUser(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}
function DeleteUser()
{
	var user_name = document.getElementById("selectUserNameDelete").value;
	var table = document.getElementById("table_delete_user").value;
	
	$.post( "delete_user.php", { user_name: user_name, table: table, no_prefix: 1 } ).done(CompleteDeleteUser) ;
}
function CompleteDeleteUser(data)
{
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = 2000;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_USER_DELETED_1_MSG + " <b>" + data + "</b> " + MANAGE_PAGE_ACCESS_USER_DELETED_2_MSG;
	popup_msg.ShowPopupMsg();
	
	var user_table = document.getElementById("table_delete_user").value;
	RetrieveUserLists(user_table, false);
}

//////////////////////////////////////////////////////////////////////////////////////
function UpdateMessage(xmlhttp, Source)
{
	var query_complete_no_record = QUERY_COMPLETE_NO_RECORD_FOUND;
	var query_complete = "<b>" + QUERY_COMPLETE + "<\/b><br/>\n";
	var query_read_to_send = QUERY_READY_TO_SEND;
	var query_sent = QUERY_SENT;
	var query_starting = MANAGE_PAGE_ACCESS_LOCATING_PAGE_RESTRICTIONS_MSG;
	
	if (Source == "Update")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_PAGE_RESTRICTIONS_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_PAGE_RESTRICTIONS_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_UPDATING_PAGE_RESTRICTIONS_MSG;
	}
	else if (Source == "UpdateUserStatus")
	{
		query_complete_no_record = MANAGE_PAGE_ACCESS_COULD_NOT_UPDATE_USER_STATUS_MSG;
		query_complete = "<b>" + MANAGE_PAGE_ACCESS_USER_STATUS_UPDATED_MSG + "<\/b><br/>\n";
		query_starting = MANAGE_PAGE_ACCESS_UPDATING_USER_STATUS_MSG;
	}
	else if (Source == "PopulateUsers")
		query_starting = MANAGE_PAGE_ACCESS_LOCATING_USERS_MSG;

	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				var rows_str = xmlhttp.responseText;
//				alert(rows_str);
				if (rows_str == "-no data-")
					popup_msg.status_msg = query_complete_no_record;
				else
					popup_msg.status_msg = query_complete;

				if (Source == "Populate")
					PopulatePageTable(rows_str);
				else if (Source == "PopulateUsers")
					PopulateUserLists(rows_str);

			}
			else
				popup_msg.status_msg = query_complete_no_record;

			popup_msg.popup_timeout = 2000;
		}
		else if (xmlhttp.readyState==1)
			popup_msg.status_msg = query_read_to_send;
		else if (xmlhttp.readyState==2)
			popup_msg.status_msg = query_sent;
		else if (xmlhttp.readyState==3)
			popup_msg.status_msg = query_starting;
		
		popup_msg.ShowPopupMsg();
	}
	return (xmlhttp);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function RetrieveUserLists(user_table, start)
{	
	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = MANAGE_PAGE_ACCESS_RETRIEVING_USERS_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","populate_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "PopulateUsers");
		params = "user_table=" + user_table + "&page=" + page + "&max_rec=" + max_rec;
		xmlhttp.send(params);
	}
	
	document.getElementById("user_table_for_users_table").value = user_table;

	if (start)
		page = 0;
//	alert (params);
}

//////////////////////////////////////////////////////////////////////////////////////
function PopulateUserLists(rows_str)
{
//	alert(rows_str);
	var rows = new Array();

	var output_str =  "<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
	output_str = output_str + "<tr bgcolor='#CCCCCC' class='header_row'>\n";
	output_str = output_str + "<td class='header_row'><b>" + USER_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td class='header_row'><b>" + ACTIVE_WORD + "<\/b><\/td>\n";
	output_str = output_str + "<td>&nbsp;<\/td>\n";
	output_str = output_str + "</tr>\n";

	rows = rows_str.split("@@@@@");
	if (rows[0] == "-no data-")	// If no pages yet (first time).
	{
		var i = 0;
	}
	else	// Create options for access level list.
	{
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			//alert(JSON_row);
			if (JSON_row.UserID)
			{	
				if (bgclr == "#dddddd")
					bgclr = "#eeeeee";
				else
					bgclr = "#dddddd";
			
				output_str = output_str + "<tr bgcolor='" + bgclr + "'>\n<td>" + JSON_row.UserID + "<input type='hidden' value='" + JSON_row.UserID + "' id='user_id" + i + "' name='user_id" + i + "' /></td>\n<td>\n";
				
				output_str = output_str + " <input type='checkbox' name='active" + i + "' id='active" + i + "' onclick='return false'";
				if (JSON_row.Active == 1)
					output_str = output_str + " checked='checked'";
				output_str = output_str + " />\n</td>\n";
				
				output_str = output_str + "<td valign='top'>\n<img src='theme/" + theme + "/images/save.png' border=0 alt='Update' name='Update' onClick=\"CopyUserToRestricted('" + JSON_row.UserID + "', " + i + ");\" style='cursor:pointer;' />\n<\/td>\n";

			}
		}
	}
	output_str = output_str + "</tr>\n</table>\n";
	
	document.getElementById("UsersTable").innerHTML = output_str;

	///////////////////////////////////////////
	GetNumUsers();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function CopyUserToRestricted(UserID, i)
{		
	var params = "";
	var user_id_ctl = "user_id" + i;
	var active_ctl = "active" + i;

	popup_msg.popup_msg_type = 1;
	popup_msg.status_msg = EDITOR_STARTING_UPDATE_MSG;
	popup_msg.popup_timeout = -1;
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 500;
	popup_msg.ShowPopupMsg();
	
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","update_user_status.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp, "UpdateUserStatus");
		
		params = "UserID=" + document.getElementById(user_id_ctl).value;
		params = params + "&Active=" + document.getElementById(active_ctl).checked;
		params = params + "&user_table=" + document.getElementById("user_table_for_users_table").value;
		//alert(params);
		xmlhttp.send(params);
	}
}

//////////////////////////////////////////////////////////////////////////////////
function moveFirst()
{
	page = 0;
	var user_table = document.getElementById("user_table_for_users_table").value;
	RetrieveUserLists(user_table, false);
}

function movePrev()
{
	page = Math.max(0, (page - 1));
	var user_table = document.getElementById("user_table_for_users_table").value;
	RetrieveUserLists(user_table, false);
}

function moveNext()
{
	page = Math.min(total_pages, (page + 1));
	var user_table = document.getElementById("user_table_for_users_table").value;
	RetrieveUserLists(user_table, false);
}

function moveLast()
{
	page = total_pages;
	var user_table = document.getElementById("user_table_for_users_table").value;
	RetrieveUserLists(user_table, false);
}

function GetNumUsers()
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();
	var user_table = document.getElementById("user_table_for_users_table").value;

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","get_num_users.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = FinishGetNumUsers(xmlhttp);
		params = "user_table=" + user_table;
		xmlhttp.send(params);
//		alert(params);
	}
}

function FinishGetNumUsers(xmlhttp)	{
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
		{
			if (xmlhttp.responseText.length > 0)
			{
				num_users = xmlhttp.responseText;
				if (num_users == "-no data-")
					num_users = 0;
			}
			else
				num_users = 0;
			total_pages = Math.ceil(num_users/max_rec) - 1;
			ShowHidePageBtns();
		}
	}
	return (xmlhttp);
}

function ShowHidePageBtns()
{
	if (total_pages < 1)
	{
		document.getElementById("user_nav_row_top").style.display = "none";
		document.getElementById("user_nav_row_bot").style.display = "none";
	}
	else
	{
		document.getElementById("user_nav_row_top").style.display = "table-row";
		document.getElementById("user_nav_row_bot").style.display = "table-row";
	}

	if (page < 1)
	{
		document.getElementById("first_top").src = "./theme/" + theme + "/images/First_disabled.gif";
		document.getElementById("prev_top").src = "./theme/" + theme + "/images/Previous_disabled.gif";
		document.getElementById("first_bot").src = "./theme/" + theme + "/images/First_disabled.gif";
		document.getElementById("prev_bot").src = "./theme/" + theme + "/images/Previous_disabled.gif";
	}
	else
	{
		document.getElementById("first_top").src = "./theme/" + theme + "/images/First.gif";
		document.getElementById("prev_top").src = "./theme/" + theme + "/images/Previous.gif";
		document.getElementById("first_bot").src = "./theme/" + theme + "/images/First.gif";
		document.getElementById("prev_bot").src = "./theme/" + theme + "/images/Previous.gif";
	}
	
	if (page == total_pages)
	{
		document.getElementById("next_top").src = "./theme/" + theme + "/images/Next_disabled.gif";
		document.getElementById("last_top").src = "./theme/" + theme + "/images/Last_disabled.gif";
		document.getElementById("next_bot").src = "./theme/" + theme + "/images/Next_disabled.gif";
		document.getElementById("last_bot").src = "./theme/" + theme + "/images/Last_disabled.gif";
	}
	else
	{
		document.getElementById("next_top").src = "./theme/" + theme + "/images/Next.gif";
		document.getElementById("last_top").src = "./theme/" + theme + "/images/Last.gif";
		document.getElementById("next_bot").src = "./theme/" + theme + "/images/Next.gif";
		document.getElementById("last_bot").src = "./theme/" + theme + "/images/Last.gif";
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}