/////////////////////////////////////////////
// Create Page Select /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 4/3/2014	ELL
// Modified: 10/14/2014	ELL
// Added grouping of plugins by category and sub categories.
// Modified: 11/9/2014	ELL
// Fix bugs with not being able to select plugin.
// Modified: 2/22/2015	ELL
// Added update template image on mouseover.

var timer_is_on = 0;

window.parent.document.title = document.title;

function OpenHelpWindow(topic)
{
	var help_url = "http://breezewebsitebuilder.com/docs/cms/help.html#" + topic;
	window.open(help_url, "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function OpenHelpList()
{	
	document.getElementById('help_list').style.display = "block";
	
	var ntop = 30;
	var nleft = 280;
	
	var strtop = ntop + "px";
	var strleft = nleft + "px";
	
	document.getElementById("help_list").style.position = "absolute";
	document.getElementById("help_list").style.top = strtop;
	document.getElementById("help_list").style.left = strleft;
}
 
function CloseHelpList()
{
	document.getElementById('help_list').style.display = "none";
}

function UpdateTemplateImage(i, clicked)
{
	document.getElementById("template_pic_edit").src = "images/" + images[i];
	document.getElementById("template_pic").src = "images/" + images[i];
	
	if (clicked)
	{
		document.getElementById("template_name").value = layouts[i];
		option_value_selected = layouts[i];
		
		for (var n = 0; n < layouts.length; n++)
		{
			layout_select_ctl = "layout_select" + n;
			document.getElementById(layout_select_ctl).className = "button_sub_level_1";
		}
		
		layout_select_ctl = "layout_select" + i;
		document.getElementById(layout_select_ctl).className = "button_sub_level_1 down_sub";
		
		mTimer = setTimeout("ShowSelections();", 1000);
		timer_is_on = 1;
	}
}

function RevertTemplateImage(layout)
{
	document.getElementById("template_pic_edit").src = "images/" + layout + ".jpg";
}

function SelectPlugin(plugin, i)
{
	document.getElementById('plugin').value = plugin;
	
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		try	{
			plugin_name_select_ctl = "plugin_select" + n;
		} 	catch(e)	{	e = 0;	}
		try	{
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
		} 	catch(e)	{	e = 0;	}
	}
	plugin_name_select_ctl = "plugin_select" + i;
	document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1 down_sub";
	
	document.getElementById("selected_plugin").innerHTML = "<b>" + plugins[plugin] + "</b>";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
	
	document.getElementById("clear_plugin_btn").style.display = "block";
}

function ClearPlugin()
{	
	var plugin_name_select_ctl = "";
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		try	{
			document.getElementById(plugin_name_select_ctl).className = "button_sub_level_1";
		} 	catch(e)	{	e = 0;	}
	}
	document.getElementById("plugin").value = "-not selected-";
	document.getElementById("selected_plugin").innerHTML = "&lsaquo;&mdash; <em>(optional)</em>";
	document.getElementById("clear_plugin_btn").style.display = "none";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
}

function SelectPluginCategory(cat_id, parent_cat_id)
{
	var cat_cnt = document.getElementById("cat_cnt").value;
	var cat_div_str;
	var cat_id_str = "div_" + cat_id;
	var cat_select;
	var n;
	for (var i = 0; i < cat_cnt; i++)
	{
		if (i != parent_cat_id)	{
			cat_div_str = "div_" + i;
			try	{
				document.getElementById(cat_div_str).style.display = "none";
			} 	catch(e)	{	e = 0;	}
			cat_select = "cat_select" + i;
			try	{
				document.getElementById(cat_select).className = "button_sub_level_1";
			} 	catch(e)	{	e = 0;	}
		}
	}
	cat_select = "cat_select" + cat_id;
	document.getElementById(cat_select).className = "button_sub_level_1 down_sub";
	
	try	{
		document.getElementById(cat_id_str).style.display = "block";
	} 	catch(e)	{	e = 0;	}
	
	var plugin_cnt = document.getElementById('plugin_cnt').value;
	for (var n = 0; n < plugin_cnt; n++)
	{
		plugin_name_select_ctl = "plugin_select" + n;
		try	{
			document.getElementById(plugin_name_select_ctl).style.width = "99%";
		} 	catch(e)	{	e = 0;	}
	}
}

function SelectPageName()
{
	if ((document.getElementById("createPage").value != "") && (document.getElementById("createPage").value != " "))
	document.getElementById("selected_page_name").innerHTML = "<b>" + document.getElementById("createPage").value + "</b>";
	mTimer = setTimeout("ShowSelections();", 1000);
	timer_is_on = 1;
}

function CheckPageName(page_name)
{
	if ((page_name.length > 0) && (page_name != " "))
		document.getElementById("create_btn").className = "button_console_add";
	else
		document.getElementById("create_btn").className = "button_console_add_disabled";
}

function ShowEnterPageName()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1 down_sub";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
	
	var page_name_input = document.getElementById("createPage");
	page_name_input.style.display = "block";
	page_name_input.style.position = "absolute";
	page_name_input.style.top = "70px";
	page_name_input.style.left = "300px";
	page_name_input.focus();
}

function ShowSelectLayout()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("createPage").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1 down_sub";
	
	var select_layout_div = document.getElementById("select_layout_div");
	select_layout_div.style.display = "block";
	select_layout_div.style.position = "absolute";
	select_layout_div.style.top = "130px";
	select_layout_div.style.left = "300px";
	select_layout_div.style.zIndex = 10;
}

function ShowPlugins()
{
	if (timer_is_on == 1)
		clearTimeout(mTimer);
	
	document.getElementById("selections_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";
	document.getElementById("createPage").style.display = "none";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1 down_sub";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
	
	var select_plugin_div = document.getElementById("select_plugin_div");
	select_plugin_div.style.display = "block";
	select_plugin_div.style.width = "80%";
	select_plugin_div.style.position = "absolute";
	select_plugin_div.style.top = "100px";
	select_plugin_div.style.left = "300px";
	select_plugin_div.style.zIndex = 10;
}

function ShowSelections()
{
	timer_is_on = 0;
	
	document.getElementById("createPage").style.display = "none";
	document.getElementById("select_plugin_div").style.display = "none";
	document.getElementById("select_layout_div").style.display = "none";

	document.getElementById("selections_div").style.display = "block";
	
	document.getElementById("enter_page_name_btn").className = "button_sub_level_1";
	document.getElementById("add_plugin_btn").className = "button_sub_level_1";
	document.getElementById("select_layout_btn").className = "button_sub_level_1";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}