////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/4/2016	ELL

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.parent.document.title = document.title;

function OpenHelpWindow(topic)
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#" + topic, "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
var warning_cnt = 0;
function DeleteCustomClassesConfirm(style_sheet)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	if (warning_cnt == 0)
		popup_msg.popup_msg_cell = CLEAR_CUSTOM_CSS_CLASSES_WARNING_MSG;
	else
		popup_msg.popup_msg_cell = CLEAR_CUSTOM_CSS_CLASSES_WARNING_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteCustomClasses(style_sheet); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
	warning_cnt++;
}

function DeleteCustomClasses(style_sheet)
{
	if (warning_cnt < 2)
		DeleteCustomClassesConfirm(style_sheet);
	else	{
		popup_msg.popup_msg_type = 1;
		popup_msg.status_msg = CLEAR_CUSTOM_CSS_CLASSES_START_MSG;
		popup_msg.popup_timeout = 10000;
		popup_msg.ShowPopupMsg();
		
		$.post( "delete_custom_classes.php", { style_sheet: style_sheet } ).done(CompleteCustomClasses) ;
	}
}
function CompleteCustomClasses(data)
{
	if (data == 1)
		popup_msg.status_msg = CLEAR_CUSTOM_CSS_CLASSES_COMPLETE_MSG;
	else
		popup_msg.status_msg = CLEAR_CUSTOM_CSS_CLASSES_COMPLETE_ERR;
	popup_msg.popup_timeout = 2000;
	popup_msg.ShowPopupMsg();
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}