////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 10/19/2014	ELL
// Modified: 2/23/2015	ELL
// Added handler for scrolling to keep options div in same position in window.
// 

var top_start;
var editor_options_div_height;

window.parent.document.title = document.title;

function InitializeConsole()
{
	var element = document.getElementById("editor_options_div");
	var style = window.getComputedStyle(element);
    var top_start_str = style.getPropertyValue('top');
	top_start_str = top_start_str.replace("px", "");
	top_start = parseInt(top_start_str);
	
    var editor_options_div_height_str = style.getPropertyValue('height');
	editor_options_div_height_str = editor_options_div_height_str.replace("px", "");
	editor_options_div_height = parseInt(editor_options_div_height_str);
}

function LocateAttributesDiv ()
{
	var viewportheight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
	if (viewportheight > top_start + editor_options_div_height)
	{
		var top = (window.pageYOffset || document.documentElement.scrollTop) - (document.documentElement.clientTop || 0);
		var scroll_top = top_start + top;
		document.getElementById("editor_options_div").style.top = scroll_top + "px";
	}
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#edit_page", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}
 
function SetEditorMode()
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","set_editor_mode.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);
		
		if (document.getElementById("editor_mode").checked == true)
			params = "editor_mode=1";
		else
			params = "editor_mode=0";
		
		xmlhttp.send(params);
	}
}

function SiteStyles(site_styles)
{
	var xmlhttp;
	xmlhttp = getXmlHttpRequestObject();

	if (xmlhttp.readyState == 4 || xmlhttp.readyState == 0)
	{
		xmlhttp.open("POST","set_editor_mode.php",true);
		xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
		xmlhttp = UpdateMessage(xmlhttp);
		
		params = "site_styles=" + site_styles;
		
		xmlhttp.send(params);
	}
}

function UpdateMessage(xmlhttp)
{
	var status_msg;
	xmlhttp.onreadystatechange=function()
	{
		if (xmlhttp.readyState==4)
			status_msg = "query complete";
		else if (xmlhttp.readyState==1)
			status_msg = "query read to send";
		else if (xmlhttp.readyState==2)
			status_msg = "query sent";
		else if (xmlhttp.readyState==3)
			status_msg = "query starting";
	}
	return (xmlhttp);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved page.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}