/////////////////////////////////////////////
// Options /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 2/17/2015	ELL
// Modified: 2/22/2015	ELL
// Added handler for scrolling to keep attributes div in same position in window.
// Modified: 10/1/2015	ELL
// Added layout template selection.
// Added insert default border areas in custom border areas check boxes.
// Added body onload function name as an attribute.
// Revised: 4/12/2016	ELL
// Fixed bug with going into Manage Page Attributes after editing page or page file, then changing attributes and clicking save
// without having clicked on any pages inside of Manage Page Attributes, and attributes not saving.
// 
//
var browser = BrowserDetect.browser;
var browser_version = BrowserDetect.version;

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

window.onscroll = LocateAttributesDiv;
var top_start;
var editor_options_div_height;

window.parent.document.title = document.title;

function InitializeConsole()
{
	var element = document.getElementById("editor_options_div");
	var style = window.getComputedStyle(element);
    var top_start_str = style.getPropertyValue('top');
	top_start_str = top_start_str.replace("px", "");
	top_start = parseInt(top_start_str);
	
    var editor_options_div_height_str = style.getPropertyValue('height');
	editor_options_div_height_str = editor_options_div_height_str.replace("px", "");
	editor_options_div_height = parseInt(editor_options_div_height_str);
}

function LocateAttributesDiv ()
{
	var viewportheight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
	if (viewportheight > top_start + editor_options_div_height)
	{
		var top = (window.pageYOffset || document.documentElement.scrollTop) - (document.documentElement.clientTop || 0);
		var scroll_top = top_start + top;
		document.getElementById("editor_options_div").style.top = scroll_top + "px";
	}
}

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#manage_page_attributes", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function GetPageAttributes(page_name, i)
{
	if (i > -1)
	{
		var page_name_select_ctl = "";
		var page_cnt = document.getElementById('page_cnt').value;
		for (var n = 0; n <page_cnt; n++)
		{
			page_name_select_ctl = "page_name_select" + n;
			document.getElementById(page_name_select_ctl).className = "button_sub_level_1";
		}
		page_name_select_ctl = "page_name_select" + i;
		document.getElementById(page_name_select_ctl).className = "button_sub_level_1 down_sub";
	}
	document.getElementById('selected_page').value = page_name;
	
	if (page_name != "")
		$.post( "get_rows.php", { table: "page_data", where: "page_name='" + page_name + "'", order_by: "page_name" } ).done(CompleteGetAttributes) ;
}
function CompleteGetAttributes(data)
{
	if (data == "-no data-")
	{
		popup_msg.top_offset = 0;
		popup_msg.left_offset = 320;
		popup_msg.popup_msg_type = 1;
		popup_msg.popup_timeout = 3000;
		popup_msg.status_msg = MANAGE_PAGE_ATTRIBUTES_ERROR_RETRIEVING_PAGE_ATTRIBUTES_ERR;
		popup_msg.ShowPopupMsg();
	}
	else
	{
		var JSON_row = JSON.parse(data);
		
		document.getElementById("template_name").value = JSON_row.template;
		document.getElementById("template_pic_edit").src = "images/" + JSON_row.template + ".jpg";
		option_value_selected = JSON_row.template;
		
		for (var i = 0; i < layouts.length; i++)
		{
			layout_select_ctl = "layout_select" + i;
			if (layouts[i] == JSON_row.template)
				document.getElementById(layout_select_ctl).className = "button_sub_level_1 down_sub";
			else
				document.getElementById(layout_select_ctl).className = "button_sub_level_1";
		}
		
		if (JSON_row.use_table_structure == 1)
			document.getElementById("use_table_structure").checked = true;
		else
			document.getElementById("use_table_structure").checked = false;
			
		if (JSON_row.use_table_structure_mobile == 1)
			document.getElementById("use_table_structure_mobile").checked = true;
		else
			document.getElementById("use_table_structure_mobile").checked = false;
			
		if (JSON_row.disable_site_styles == 1)
			document.getElementById("disable_site_styles").checked = true;
		else
			document.getElementById("disable_site_styles").checked = false;
			
		if (JSON_row.body_onload == 1)
			document.getElementById("body_onload").checked = true;
		else
			document.getElementById("body_onload").checked = false;
		document.getElementById("body_onload_function").value = JSON_row.body_onload_function;
		
		if (JSON_row.insert_default_head == 1)
			document.getElementById("insert_default_head").checked = true;
		else
			document.getElementById("insert_default_head").checked = false;
			
		if (JSON_row.insert_default_header == 1)
			document.getElementById("insert_default_header").checked = true;
		else
			document.getElementById("insert_default_header").checked = false;
			
		if (JSON_row.insert_default_top == 1)
			document.getElementById("insert_default_top").checked = true;
		else
			document.getElementById("insert_default_top").checked = false;
			
		if (JSON_row.insert_default_left == 1)
			document.getElementById("insert_default_left").checked = true;
		else
			document.getElementById("insert_default_left").checked = false;
			
		if (JSON_row.insert_default_right == 1)
			document.getElementById("insert_default_right").checked = true;
		else
			document.getElementById("insert_default_right").checked = false;
			
		if (JSON_row.insert_default_bottom == 1)
			document.getElementById("insert_default_bottom").checked = true;
		else
			document.getElementById("insert_default_bottom").checked = false;
			
		if (JSON_row.insert_default_footer == 1)
			document.getElementById("insert_default_footer").checked = true;
		else
			document.getElementById("insert_default_footer").checked = false;
	}
}

function SavePageAttributes()
{
	$.ajax({type:'POST', url: 'save_page_attributes.php', data:$('#frmPageAttributes').serialize(), success: function(response) {
		CompleteSaveAttributes(response);
	}});
}
function CompleteSaveAttributes(response)
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 1;
	popup_msg.popup_timeout = 3000;
	if (response == 1)
		popup_msg.status_msg = MANAGE_PAGE_ATTRIBUTES_PAGE_ATTRIBUTES_SAVED_MSG;
	else
		popup_msg.status_msg = MANAGE_PAGE_ATTRIBUTES_ERROR_SAVING_PAGE_ATTRIBUTES_ERR;
	popup_msg.ShowPopupMsg();
}

function UpdateTemplateImage(i, clicked)
{
	document.getElementById("template_pic_edit").src = "images/" + images[i];
	
	if (clicked)
	{
		document.getElementById("template_name").value = layouts[i];
		option_value_selected = layouts[i];
		
		for (var n = 0; n < layouts.length; n++)
		{
			layout_select_ctl = "layout_select" + n;
			document.getElementById(layout_select_ctl).className = "button_sub_level_1";
		}
		
		layout_select_ctl = "layout_select" + i;
		document.getElementById(layout_select_ctl).className = "button_sub_level_1 down_sub";
	}
}

function RevertTemplateImage(layout)
{
	document.getElementById("template_pic_edit").src = "images/" + layout + ".jpg";
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////
function ResizeWorkspace(mainWidth, mainHeight, menuWidth, headerHeight) {

}

function DisplayNotSavedMessage(btn)	{
	// Needed to complete call when deleting unsaved border area.
	window.parent.SetWorkSavedNotSaved(true);
	window.parent.next_btn = btn;
	window.parent.DoNextClick();
}