/////////////////////////////////////////////
// Users /////
////////////////////////////////////////////////////////////////////////
// Breeze Website Builder
// Copyright Silver Dolphin Solutions, LLC, Edward Lemmers, P.E.
// For licensing, see license.txt.
// Created: 7/2/2013	ELL
// Revised: 10/28/2014	ELL
// Added modify user to change access level and revise added fields email, first_name and last_name.
// Complete overhaul to switch from form posts to AJAX.

var param_array = {'popup_msg_type' : 1, 'status_msg' : '', 'popup_timeout' : -1};
var popup_msg = new PopupMsg(param_array);

var table = "users";

window.parent.document.title = document.title;

function OpenHelpWindow()
{
	window.open("http://breezewebsitebuilder.com/docs/cms/help.html#users", "Help", "scrollbars=1,resizable=1,status=0,toolbar=0,menubar=0,location=0,height=700,width=800");
}

function DeleteConfirm()
{
	popup_msg.top_offset = 0;
	popup_msg.left_offset = 300;
	popup_msg.popup_msg_type = 3;
	popup_msg.popup_btn_cnt = 2;
	popup_msg.msg_width = 450;
	popup_msg.popup_msg_cell = MANAGE_USERS_DELETE_USER_CONFIRM_1_MSG + " <b>" + document.getElementById("selectUserNameDelete").value + "</b>" + MANAGE_USERS_DELETE_USER_CONFIRM_2_MSG;
	popup_msg.popup_button_2_span = YES_WORD;
	popup_msg.popup_button_1_span = NO_WORD;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	document.getElementById("popup_button_2_span").onclick = function () { DeleteUser(); };
	document.getElementById("popup_button_1_span").onclick = function () { HidePopupMsg(); };
}

function DeleteUser()
{
	var user_name = document.getElementById("selectUserNameDelete").value;
	
	$.post( "delete_user.php", { user_name: user_name, table: table } ).done(CompleteDeleteUser) ;
}
function CompleteDeleteUser(data)
{
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = 2000;
	popup_msg.status_msg = MANAGE_USERS_USER_DELETED_1_MSG + " <b>" + data + "</b> " + MANAGE_USERS_USER_DELETED_2_MSG;
	popup_msg.ShowPopupMsg();
	
	GetUsers();
}

function GeneratePassword(source)
{
	var password = "";
	var password_length = rand(6,10);
	var i;
	var assci_segment;
	
	for (i = 0; i < password_length; i++)
	{
		assci_segment = rand(1,3);
		if (assci_segment == 1)
			password = password + String.fromCharCode(rand(48,57));	// numeric
		else if (assci_segment == 2)
			password = password + String.fromCharCode(rand(65,90));	// alpha upper case
		else
			password = password + String.fromCharCode(rand(97,122));	// alpha lower case
	}
	password = password.replace('I', 'i');
	password = password.replace('O', 'o');
	password = password.replace('l', 'L');
	
	if (source == "new")
		var frm_obj = document.getElementById ('password_new_user');
	else
		var frm_obj = document.getElementById ('password_existing_user');
		
	frm_obj.value = password;
		
	return password;
}

// Equivalent to PHP rand(min, max);
function rand ( n, m )
{
  return ( n + Math.floor ( Math.random ( ) * (m - n + 1)) );
}

function GetUsers()
{
	$.post( "get_rows.php", { table: table } ).done(PopulateUsers) ;
}
function PopulateUsers(data)
{
	var rows = new Array();
	
	rows = data.split("@@@@@");
	if (rows[0] == "-no data-")
		alert(MANAGE_USERS_NO_USERS_FOUND_ERR);
	else
	{
		var selectUserNameExistingUser = document.getElementById("selectUserNameExistingUser");
		var selectUserNameEdit = document.getElementById("selectUserNameEdit");
		var selectUserNameDelete = document.getElementById("selectUserNameDelete");
		
		selectUserNameExistingUser.options.length = 1;
		selectUserNameEdit.options.length = 1;
		selectUserNameDelete.options.length = 1;
		
		for (var i in rows)
		{
			var JSON_row = JSON.parse(rows[i]);
			selectUserNameExistingUser.options[selectUserNameExistingUser.options.length] = new Option(JSON_row.UserID, JSON_row.UserID);
			selectUserNameEdit.options[selectUserNameEdit.options.length] = new Option(JSON_row.UserID, JSON_row.UserID);
			selectUserNameDelete.options[selectUserNameDelete.options.length] = new Option(JSON_row.UserID, JSON_row.UserID);
		}
	}
}

function GetUser(user_name)
{
	$.post( "get_rows.php", { table: table, where: "`UserID` = '" + user_name + "'" } ).done(PopulateUser) ;
}
function PopulateUser(data)
{
	if (data == "-no data-")
		alert(MANAGE_USERS_NO_DATA_FOUND_FOR_USER_ERR);
	else
	{
		var JSON_row = JSON.parse(data);
		document.getElementById("selectAccessLevelEdit").value = JSON_row.AccessLevel;
		document.getElementById("email_edit").value = JSON_row.email;
		document.getElementById("first_name_edit").value = JSON_row.first_name;
		document.getElementById("last_name_edit").value = JSON_row.last_name;
	}
}

function AddUser()
{
	var user_name = document.getElementById('user_name_new_user').value;
	var password = document.getElementById('password_new_user').value;
	var AccessLevel = document.getElementById('selectAccessLevelNewUser').value;
	var email = document.getElementById('email_new_user').value;
	var first_name = document.getElementById('first_name_new_user').value;
	var last_name = document.getElementById('last_name_new_user').value;
	
	$.post( "add_user.php", { user_name: user_name, password: password, AccessLevel: AccessLevel, email: email, first_name: first_name, last_name: last_name, table: table } ).done(CompleteAddUser) ;
}
function CompleteAddUser(data)
{
	if (data == "-no data-")
		popup_msg.status_msg = MANAGE_USERS_USER_NOT_ADDED_ERR;
	else
	{
		var field_pairs = data.split("@@@@@");
		var fields = new Array();
		var pail = new Array();
		for(var i in field_pairs)
		{
			pair = field_pairs[i].split("=");
			fields[pair[0]] = pair[1];
		}
	
		popup_msg.status_msg = MANAGE_USERS_NEW_USER_ADDED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_USERS_NEW_USER_ADDED_2_MSG + " <b>" + fields['password'] + "</b> " + MANAGE_USERS_NEW_USER_ADDED_3_MSG + " <b>" + fields['AccessLevel'] + "</b>";
		if ((fields['first_name'] != "") || (fields['last_name'] != ""))
			popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_USERS_NEW_USER_ADDED_4_MSG + " <b>" + fields['first_name'] + " " + fields['last_name'] + "</b>";
		if (fields['email'] != "")
			popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_USERS_NEW_USER_ADDED_5_MSG + " <b>" + fields['email'] + "</b>";
	}
		
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.ShowPopupMsg();
	
	if (data != "-no data-")
	{
		document.getElementById('user_name_new_user').value = "";
		document.getElementById('password_new_user').value = "";
		document.getElementById('email_new_user').value = "";
		document.getElementById('first_name_new_user').value = "";
		document.getElementById('last_name_new_user').value = "";
		GetUsers();
	}
}

function ChangePassword()
{
	var user_name = document.getElementById('selectUserNameExistingUser').value;
	var password = document.getElementById('password_existing_user').value;
	
	$.post( "change_password.php", { user_name: user_name, password: password, table: table } ).done(CompleteChangePassword) ;
}
function CompleteChangePassword(data)
{
	var field_pairs = data.split("@@@@@");
	var fields = new Array();
	var pair = new Array();
	for(var i in field_pairs)
	{
		pair = field_pairs[i].split("=");
		fields[pair[0]] = pair[1];
	}
	
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = -1;
	popup_msg.status_msg = MANAGE_USERS_PASSWORD_CHANGED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_USERS_PASSWORD_CHANGED_2_MSG + " <b>" + fields['password'] + "</b>";
	popup_msg.ShowPopupMsg();
}

function ModifyUser()
{
	var user_name = document.getElementById('selectUserNameEdit').value;
	var AccessLevel = document.getElementById('selectAccessLevelEdit').value;
	var email = document.getElementById('email_edit').value;
	var first_name = document.getElementById('first_name_edit').value;
	var last_name = document.getElementById('last_name_edit').value;
	
	$.post( "modify_user.php", { user_name: user_name, AccessLevel: AccessLevel, email: email, first_name: first_name, last_name: last_name, table: table } ).done(CompleteModifyUser) ;
}
function CompleteModifyUser(data)
{
	var field_pairs = data.split("@@@@@");
	var fields = new Array();
	var pair = new Array();
	for(var i in field_pairs)
	{
		pair = field_pairs[i].split("=");
		fields[pair[0]] = pair[1];
	}
	
	popup_msg.top_offset = 100;
	popup_msg.left_offset = 320;
	popup_msg.popup_msg_type = 2;
	popup_msg.popup_timeout = 5000;
	popup_msg.status_msg = MANAGE_USERS_USER_MODIFIED_1_MSG + " <b>" + fields['user_name'] + "</b> " + MANAGE_USERS_USER_MODIFIED_2_MSG + " <b>" + fields['AccessLevel'] + "</b>";
	if ((fields['first_name'] != "") || (fields['last_name'] != ""))
		popup_msg.status_msg = popup_msg.status_msg + MANAGE_USERS_USER_MODIFIED_3_MSG + " <b>" + fields['first_name'] + " " + fields['last_name'] + "</b>";
	if (fields['email'] != "")
		popup_msg.status_msg = popup_msg.status_msg + " " + MANAGE_USERS_USER_MODIFIED_4_MSG + " <b>" + fields['email'] + "</b>";
	popup_msg.ShowPopupMsg();
}