<?php
/////////////////////////////////////////////
// Breeze Website Builder
// Copyright EB Dynamics, Inc., Edward Lemmers, P.E.
// For licensing, see license.txt.
// Build string for site.css file /////
// Revised: 10/8/2010	ELL
// Added code to allow top, bottom, left and right of border to be selected independantly in any combination when setting
// border styles.
// Revised: 11/21/2010	ELL
// Fixed bug of "not valid mysql resource" by checking for whether or not $result_build_string is set.
//
// Revised: 9/30/2011	ELL
// Added building of download files for open-source customers who purchase templates.
// Mode will switch based on whether or not wizard is enabled in options_selected table.
// If wizard is enabled, setup_site.php copies files to perspective folders and runs
// SQL directly on tables just as originally designed.  If wizard is not enabled,
// setup_site.php creates SQL file from all of the SQL commands, copies all of the
// other necessary files to a temp location, zips these files into a single file, and
// initiates download of zip file to customer.  Open-source customers will then upload
// this zip file into their Breeze Website Builder which will then unpack the files and
// apply template to their site automatically by running the SQL commands in the SQL file
// and copying the perspective files to the correct locations.
// Revised: 5/16/2013	ELL
// Added 2nd and 3rd fonts, box shadow and border radius.
// Revised: 5/23/2013	ELL
// Added clear and min/max prefix for width and height.
// Revised: 12/30/2013	ELL
// Added cursor styles.
// Revised: 1/2/2014	ELL
// Added background-size styles.
// Revised: 12/9/2014	ELL
// Added implementation of custom site and custom mobile site CSS.
// Revised: 1/12/2015	ELL
// Replaced deprecated font-stretch with letter-spacing.
// Revised: 2/14/2015	ELL
// Added visibility.
// Added full compliment of font-size units.
// Added full compliment of length units to border.
// Added full compliment of length units to all paddings.
// Added full compliment of length units to existing unit fields.
// Revised: 5/15/2015	ELL
// Added background transparancy.
// Added overflow-x and overflow-y.
// Modified handling of border style in cases of no border width specified.  If border style = none, then set border to either none
// or border style to none depending on circumstances.
// Added text-indent attribute.
//
//
function GetLengthUnitsStr($units_index)
{
	switch ($units_index)
	{
		case 0:
			$units = "px";
			break;
		case 1:
			$units = "%";
			break;
		case 2:
			$units = "em";
			break;
		case 3:
			$units = "pt";
			break;
		case 4:
			$units = "pc";
			break;
		case 5:
			$units = "cm";
			break;
		case 6:
			$units = "mm";
			break;
		case 7:
			$units = "in";
			break;
		case 8:
			$units = "rem";
			break;
		case 9:
			$units = "vw";
			break;
		case 10:
			$units = "vh";
			break;
		case 11:
			$units = "vmin";
			break;
		case 12:
			$units = "vmax";
			break;
		case 13:
			$units = "ch";
			break;
		default:
			$units = "px";
	}
	return ($units);
}

function BuildCSSString($site_css_table, $class_table, $dbh, $base_dir, $image_dir, $fonts_table, $template_id = -1)
{
	if ($base_dir == "")
		$image = "/" . $image_dir . "/";
	else
		$image = "/" . $base_dir . "/" . $image_dir . "/";
		
	$css_string = "";
	
	if (strpos($site_css_table, "site_css") !== false)
		$browser_reset = $class_table . ".browser_reset DESC, ";
	else
		$browser_reset = "";
		
	$query_custom_fonts = "SELECT * FROM " . $fonts_table . " WHERE (src IS NOT NULL) AND (src <> '')";
	if ($template_id > -1)
		$query_custom_fonts .= " AND (template_id=" . $template_id . ")";

	$result_custom_fonts = $dbh->query($query_custom_fonts);
	
	while ($row_custom_fonts = $result_custom_fonts->fetch(PDO::FETCH_ASSOC))
	{
		$font = $row_custom_fonts['font'];
		$src = $row_custom_fonts['src'];
		$weight = $row_custom_fonts['weight'];
		$style = $row_custom_fonts['style'];
		$stretch = $row_custom_fonts['stretch'];
		
		$css_string .= "@font-face {\n    font-family: " . $font . ";\n";
		$css_string .= "    src: url(" . $src . ");\n";
		if ($weight != "normal")
			$css_string .= "	font-weight: " . $weight . ";\n";
		if ($style != "normal")
			$css_string .= "	font-style: " . $style . ";\n";
		if ($stretch != "normal")
			$css_string .= "	font-stretch: " . $stretch . ";\n";
		$css_string .= "}\n\n";
	}
	$query_build_string = "SELECT * FROM " . $site_css_table . " INNER JOIN " . $class_table . " ON " . $site_css_table . ".class = " . $class_table . ".class";

	if ($template_id > -1)
		$query_build_string .= " WHERE " . $site_css_table . ".template_id=" . $template_id;
		
	$query_build_string .= " ORDER BY " . $browser_reset . $class_table . ".sort_order ASC, " . $class_table . ".subclass_sort_order ASC";

	$result_build_string = $dbh->query($query_build_string);
	if ($result_build_string)
	{
		$no_length_arr = array("xx-small","x-small","small","medium","large","x-large","xx-large","smaller","larger","initial","inherit");
		$integer_length_arr = array("px","%");
		while ($row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC))
		{
			$class = $row_bs["class"];
			if (!is_null($row_bs["use_table_data"])) $use_table_data = $row_bs["use_table_data"];
			else $use_table_data = 0;
			if ($row_bs["font"]) $font = $row_bs["font"];
			else $font = "-not selected-";
			if ($row_bs["font2"]) $font2 = $row_bs["font2"];
			else $font2 = "-not selected-";
			if ($row_bs["font3"]) $font3 = $row_bs["font3"];
			else $font3 = "-not selected-";
			if (!is_null($row_bs["font_size"])) $font_size = $row_bs["font_size"];
			else $font_size = -1;
			if (!is_null($row_bs["font_size_units"])) $font_size_units = $row_bs["font_size_units"];
			else $font_size_units = "px";
			if ($row_bs["text_color"]) $text_color = $row_bs["text_color"];
			else $text_color = "-not set-";
			
			if (!is_null($row_bs["padding_top"])) $padding_top = $row_bs["padding_top"];
			else $padding_top = -1;
			if (!is_null($row_bs["padding_right"])) $padding_right = $row_bs["padding_right"];
			else $padding_right = -1;
			if (!is_null($row_bs["padding_bottom"])) $padding_bottom = $row_bs["padding_bottom"];
			else $padding_bottom = -1;
			if (!is_null($row_bs["padding_left"])) $padding_left = $row_bs["padding_left"];
			else $padding_left = -1;
			if (!is_null($row_bs["padding_top_units"])) $padding_top_units = $row_bs["padding_top_units"];
			else $padding_top_units = 0;
			if (!is_null($row_bs["padding_right_units"])) $padding_right_units = $row_bs["padding_right_units"];
			else $padding_right_units = 0;
			if (!is_null($row_bs["padding_bottom_units"])) $padding_bottom_units = $row_bs["padding_bottom_units"];
			else $padding_bottom_units = 0;
			if (!is_null($row_bs["padding_left_units"])) $padding_left_units = $row_bs["padding_left_units"];
			else $padding_left_units = 0;
			
			if ($row_bs["weight"]) $weight = $row_bs["weight"];
			else $weight = "-not selected-";
			if (!is_null($row_bs["italic"])) $italic = $row_bs["italic"];
			else $italic = 0;
			if (!is_null($row_bs["underline"])) $underline = $row_bs["underline"];
			else $underline = 0;
			if (!is_null($row_bs["overline"])) $overline = $row_bs["overline"];
			else $overline = 0;
			if (!is_null($row_bs["blink"])) $blink = $row_bs["blink"];
			else $blink = 0;
			if ($row_bs["linethrough"]) $linethrough = $row_bs["linethrough"];
			else $linethrough = 0;
			if ($row_bs["letter_spacing"]) $letter_spacing = $row_bs["letter_spacing"];
			else $letter_spacing = -1000000;
			if (isset($row_bs["letter_spacing_units"])) $letter_spacing_units = $row_bs["letter_spacing_units"];
			else $letter_spacing_units = -1;
			if ($row_bs["oblique"]) $oblique = $row_bs["oblique"];
			else $oblique = 0;
			if ($row_bs["small_caps"]) $small_caps = $row_bs["small_caps"];
			else $small_caps = 0;
			if ($row_bs["no_text_decoration"]) $no_text_decoration = $row_bs["no_text_decoration"];
			else $no_text_decoration = 0;
			if ($row_bs["shadow"]) $shadow = $row_bs["shadow"];
			else $shadow = 0;
			if ($row_bs["shadow_color"]) $shadow_color = $row_bs["shadow_color"];
			else $shadow_color = "-not set-";
			if ($row_bs["shadow_x_offset"]) $shadow_x_offset = $row_bs["shadow_x_offset"];
			else $shadow_x_offset = 0;
			if ($row_bs["shadow_y_offset"]) $shadow_y_offset = $row_bs["shadow_y_offset"];
			else $shadow_y_offset = 0;
			if ($row_bs["shadow_blur"]) $shadow_blur = $row_bs["shadow_blur"];
			else $shadow_blur = 0;
			if (!is_null($row_bs["line_height"])) $line_height = $row_bs["line_height"];
			else $line_height = -1;
			if (!is_null($row_bs["line_height_units"])) $line_height_units = $row_bs["line_height_units"];
			else $line_height_units = -1;
			if (!is_null($row_bs["text_indent"])) $text_indent = $row_bs["text_indent"];
			else $text_indent = -1000000;
			if (!is_null($row_bs["text_indent_units"])) $text_indent_units = $row_bs["text_indent_units"];
			else $text_indent_units = -1;
			
			if ($row_bs["align"]) $align = $row_bs["align"];
			else $align = "-not selected-";
			if (!is_null($row_bs["vertical_align"])) $vertical_align = $row_bs["vertical_align"];
			else $vertical_align = "-not selected-";
			if ($row_bs["bkgd_color"]) $bkgd_color = $row_bs["bkgd_color"];
			else $bkgd_color = "-not set-";
			if ($row_bs["bkgd_transparent"]) $bkgd_transparent = $row_bs["bkgd_transparent"];
			else $bkgd_transparent = 0;
			if (!is_null($row_bs["bkgd_opacity"])) $bkgd_opacity = $row_bs["bkgd_opacity"];
			else $bkgd_opacity = -1;
			if (!is_null($row_bs["border"])) $border = $row_bs["border"];
			else $border = -1;
			if (!is_null($row_bs["border_units"])) $border_units = $row_bs["border_units"];
			else $border_units = 0;
			if ($row_bs["border_color"]) $border_color = $row_bs["border_color"];
			else $border_color = "-not set-";
			if ($row_bs["border_style"]) $border_style = $row_bs["border_style"];
			else $border_style = "-not selected-";
			if ($row_bs["outline_style"]) $outline_style = $row_bs["outline_style"];
			else $outline_style = "-not selected-";
			if ($row_bs["border_collapse"]) $border_collapse = $row_bs["border_collapse"];
			else $border_collapse = "-not selected-";
			if (!is_null($row_bs["border_sides"])) $border_sides = $row_bs["border_sides"];
			else $border_sides = 15;
			
			if (!is_null($row_bs["margin_top"])) $margin_top = $row_bs["margin_top"];
			else $margin_top = -1000000;
			if (!is_null($row_bs["margin_right"])) $margin_right = $row_bs["margin_right"];
			else $margin_right = -1000000;
			if (!is_null($row_bs["margin_left"])) $margin_left = $row_bs["margin_left"];
			else $margin_left = -1000000;
			if (!is_null($row_bs["margin_bottom"])) $margin_bottom = $row_bs["margin_bottom"];
			else $margin_bottom = -1000000;
			if ($row_bs["display"]) $display = $row_bs["display"];
			else $display = "-not selected-";
			if (!is_null($row_bs["width"])) $width = $row_bs["width"];
			else $width = -1;
			if ($row_bs["width_units"]) $width_units = $row_bs["width_units"];
			else $width_units = 0;
			if ($row_bs["width_prefix"]) $width_prefix = $row_bs["width_prefix"];
			else $width_prefix = "-not selected-";
			if (!is_null($row_bs["height"])) $height = $row_bs["height"];
			else $height = -1;
			if ($row_bs["height_units"]) $height_units = $row_bs["height_units"];
			else $height_units = 0;
			if ($row_bs["height_prefix"]) $height_prefix = $row_bs["height_prefix"];
			else $height_prefix = "-not selected-";
			if ($row_bs["background_image"]) $background_image = $row_bs["background_image"];
			else $background_image = "-not selected-";
			if ($row_bs["background_attachment"]) $background_attachment = $row_bs["background_attachment"];
			else $background_attachment = "-not selected-";
			if ($row_bs["background_repeat"]) $background_repeat = $row_bs["background_repeat"];
			else $background_repeat = "-not selected-";
			if ($row_bs["background_position"]) $background_position = $row_bs["background_position"];
			else $background_position = "-not selected-";
			if ($row_bs["background_position_x"]) $background_position_x = $row_bs["background_position_x"];
			else $background_position_x = 0;
			if ($row_bs["background_position_y"]) $background_position_y = $row_bs["background_position_y"];
			else $background_position_y = 0;
			if ($row_bs["background_position_units"]) $background_position_units = $row_bs["background_position_units"];
			else $background_position_units = 0;
			
			if ($row_bs["margin_top_units"]) $margin_top_units = $row_bs["margin_top_units"];
			else $margin_top_units = 0;
			if ($row_bs["margin_top_auto"]) $margin_top_auto = $row_bs["margin_top_auto"];
			else $margin_top_auto = 0;
			if ($row_bs["margin_right_units"]) $margin_right_units = $row_bs["$margin_right_units"];
			else $margin_right_units = 0;
			if ($row_bs["margin_right_auto"]) $margin_right_auto = $row_bs["margin_right_auto"];
			else $margin_right_auto = 0;
			if ($row_bs["margin_left_units"]) $margin_left_units = $row_bs["margin_left_units"];
			else $margin_left_units = 0;
			if ($row_bs["margin_left_auto"]) $margin_left_auto = $row_bs["margin_left_auto"];
			else $margin_left_auto = 0;
			if ($row_bs["margin_bottom_units"]) $margin_bottom_units = $row_bs["margin_bottom_units"];
			else $margin_bottom_units = 0;
			if ($row_bs["margin_bottom_auto"]) $margin_bottom_auto = $row_bs["margin_bottom_auto"];
			else $margin_bottom_auto = 0;
			
			if ($row_bs["position"]) $position = $row_bs["position"];
			else $position = "-not selected-";
			if (!is_null($row_bs["position_left"])) $position_left = $row_bs["position_left"];
			else $position_left = -1000000;
			if ($row_bs["position_left_units"]) $position_left_units = $row_bs["position_left_units"];
			else $position_left_units = 0;
			if (!is_null($row_bs["position_top"])) $position_top = $row_bs["position_top"];
			else $position_top = -1000000;
			if ($row_bs["position_top_units"]) $position_top_units = $row_bs["position_top_units"];
			else $position_top_units = 0;
			if (!is_null($row_bs["position_right"])) $position_right = $row_bs["position_right"];
			else $position_right = -1000000;
			if ($row_bs["position_right_units"]) $position_right_units = $row_bs["position_right_units"];
			else $position_right_units = 0;
			if (!is_null($row_bs["position_bottom"])) $position_bottom = $row_bs["position_bottom"];
			else $position_bottom = -1000000;
			if ($row_bs["position_bottom_units"]) $position_bottom_units = $row_bs["position_bottom_units"];
			else $position_bottom_units = 0;
			if ($row_bs["z_index"]) $z_index = $row_bs["z_index"];
			else $z_index = 0;
			if ($row_bs["overflow"]) $overflow = $row_bs["overflow"];
			else $overflow = "-not selected-";
			if ($row_bs["overflow_x"]) $overflow_x = $row_bs["overflow_x"];
			else $overflow_x = "-not selected-";
			if ($row_bs["overflow_y"]) $overflow_y = $row_bs["overflow_y"];
			else $overflow_y = "-not selected-";
			if (!is_null($row_bs["clip_top"])) $clip_top = $row_bs["clip_top"];
			else $clip_top = -1;
			if (!is_null($row_bs["clip_top_units"])) $clip_top_units = $row_bs["clip_top_units"];
			else $clip_top_units = -1;
			if (!is_null($row_bs["clip_right"])) $clip_right = $row_bs["clip_right"];
			else $clip_right = -1;
			if (!is_null($row_bs["clip_right_units"])) $clip_right_units = $row_bs["clip_right_units"];
			else $clip_right_units = -1;
			if (!is_null($row_bs["clip_bottom"])) $clip_bottom = $row_bs["clip_bottom"];
			else $clip_bottom = -1;
			if (!is_null($row_bs["clip_bottom_units"])) $clip_bottom_units = $row_bs["clip_bottom_units"];
			else $clip_bottom_units = -1;
			if (!is_null($row_bs["clip_left"])) $clip_left = $row_bs["clip_left"];
			else $clip_left = -1;
			if (!is_null($row_bs["clip_left_units"])) $clip_left_units = $row_bs["clip_left_units"];
			else $clip_left_units = -1;
			if ($row_bs["float"]) $float = $row_bs["float"];
			else $float = "-not selected-";
			if ($row_bs["white_space"]) $white_space = $row_bs["white_space"];
			else $white_space = "-not selected-";
			
			if ($row_bs["list_style_type"]) $list_style_type = $row_bs["list_style_type"];
			else $list_style_type = "-not selected-";
			if ($row_bs["list_style_position"]) $list_style_position = $row_bs["list_style_position"];
			else $list_style_position = "-not selected-";
			if ($row_bs["list_style_image"]) $list_style_image = $row_bs["list_style_image"];
			else $list_style_image = "-not selected-";
			
			if ($row_bs["table_layout"]) $table_layout = $row_bs["table_layout"];
			else $table_layout = "-not selected-";
			if ($row_bs["clear"]) $clear = $row_bs["clear"];
			else $clear = "-not selected-";
			
			if ($row_bs["radius_top_left"]) $radius_top_left = $row_bs["radius_top_left"];
			else $radius_top_left = 0;
			if ($row_bs["radius_top_left_units"]) $radius_top_left_units = $row_bs["radius_top_left_units"];
			else $radius_top_left_units = 0;
			if ($row_bs["radius_top_right"]) $radius_top_right = $row_bs["radius_top_right"];
			else $radius_top_right = 0;
			if ($row_bs["radius_top_right_units"]) $radius_top_right_units = $row_bs["radius_top_right_units"];
			else $radius_top_right_units = 0;
			if ($row_bs["radius_bottom_right"]) $radius_bottom_right = $row_bs["radius_bottom_right"];
			else $radius_bottom_right = 0;
			if ($row_bs["radius_bottom_right_units"]) $radius_bottom_right_units = $row_bs["radius_bottom_right_units"];
			else $radius_bottom_right_units = 0;
			if ($row_bs["radius_bottom_left"]) $radius_bottom_left = $row_bs["radius_bottom_left"];
			else $radius_bottom_left = 0;
			if ($row_bs["radius_bottom_left_units"]) $radius_bottom_left_units = $row_bs["radius_bottom_left_units"];
			else $radius_bottom_left_units = 0;
			
			if (isset($row_bs["box_shadow_horizontal"])) $box_shadow_horizontal = $row_bs["box_shadow_horizontal"];
			else $box_shadow_horizontal = -1000000;
			if (isset($row_bs["box_shadow_vertical"])) $box_shadow_vertical = $row_bs["box_shadow_vertical"];
			else $box_shadow_vertical = -1000000;
			if (isset($row_bs["box_shadow_blur"])) $box_shadow_blur = $row_bs["box_shadow_blur"];
			else $box_shadow_blur = -1;
			if (isset($row_bs["box_shadow_spread"])) $box_shadow_spread = $row_bs["box_shadow_spread"];
			else $box_shadow_spread = -1000000;
			if (isset($row_bs["box_shadow_color"])) $box_shadow_color = $row_bs["box_shadow_color"];
			else $box_shadow_color = "-not set-";
			if (isset($row_bs["box_shadow_inset"])) $box_shadow_inset = $row_bs["box_shadow_inset"];
			else $box_shadow_inset = 0;
			
			if ($row_bs["cursor"]) $cursor = $row_bs["cursor"];
			else $cursor = "-not selected-";
			
			if ($row_bs["background_size"]) $background_size = $row_bs["background_size"];
			else $background_size = "-not selected-";
			if ($row_bs["background_width"]) $background_width = $row_bs["background_width"];
			else $background_width = -1;
			if ($row_bs["background_width_units"]) $background_width_units = $row_bs["background_width_units"];
			else $background_width_units = 0;
			if ($row_bs["background_height"]) $background_height = $row_bs["background_height"];
			else $background_height = -1;
			if ($row_bs["background_height_units"]) $background_height_units = $row_bs["background_height_units"];
			else $background_height_units = 0;
			
			if ($row_bs["visibility"]) $visibility = $row_bs["visibility"];
			else $visibility = "-not selected-";
			
			//////////////////////////////////////////////////////////////////
		
			if ($use_table_data == 1)
			{
				$css_string .= $class . " {\n";
					
				if ($font != "-not selected-")
				{
					$css_string .= "   font-family: " . $font;
					if ($font2 != "-not selected-")
					{
						$css_string .= ", " . $font2;
						if ($font3 != "-not selected-")
							$css_string .= ", " . $font3;
					}
					$css_string .= ";\n";
				}
					
				if ($font_size != -1)
				{
					if (in_array($font_size_units, $no_length_arr))
						$css_string .= "   font-size: " . $font_size_units . ";\n";
					else
					{
						if (in_array($font_size_units, $integer_length_arr))
							$font_size = intval($font_size);
						$css_string .= "   font-size: " . $font_size . $font_size_units . ";\n";
					}
				}
				if ($text_color != "-not set-")
					$css_string .= "   color: " . $text_color . ";\n";
					
				if ($padding_top != -1)
				{
					if ($padding_top_units < 2)
						$padding_top = intval($padding_top);
					$units = GetLengthUnitsStr($padding_top_units);
					$css_string .= "   padding-top: " . $padding_top . $units . ";\n";
				}
				if ($padding_right != -1)
				{
					if ($padding_right_units < 2)
						$padding_right = intval($padding_right);
					$units = GetLengthUnitsStr($padding_right_units);
					$css_string .= "   padding-right: " . $padding_right . $units . ";\n";
				}
				if ($padding_bottom != -1)
				{
					if ($padding_bottom_units < 2)
						$padding_bottom = intval($padding_bottom);
					$units = GetLengthUnitsStr($padding_bottom_units);
					$css_string .= "   padding-bottom: " . $padding_bottom . $units . ";\n";
				}
				if ($padding_left != -1)
				{
					if ($padding_left_units < 2)
						$padding_left = intval($padding_left);
					$units = GetLengthUnitsStr($padding_left_units);
					$css_string .= "   padding-left: " . $padding_left . $units . ";\n";
				}
				
				if (($weight != "-not selected-") && ($weight != "normal"))
					$css_string .= "   font-weight: " . $weight . ";\n";
					
				if (($italic != 0) || ($oblique != 0))
				{
					$css_string .= "   font-style:";
					if ($italic == 1)
						$css_string .= " italic";
					if ($oblique == 1)
						$css_string .= " oblique";
					$css_string .= ";\n";
				}
				
				if ((($underline != 0) || ($overline != 0) || ($blink != 0) || ($linethrough != 0)) && ($no_text_decoration != 1))
				{
					$css_string .= "   text-decoration:";
					if ($underline == 1)
						$css_string .= " underline";
					if ($overline == 1)
						$css_string .= " overline";
					if ($blink == 1)
						$css_string .= " blink";
					if ($linethrough == 1)
						$css_string .= " linethrough";
					$css_string .= ";\n";
				}
				elseif ($no_text_decoration == 1)
					$css_string .= "   text-decoration: none;\n";
					
				if ($shadow == 1)
				{
					if ($shadow_color != "-not set-")
						$css_string .= "   text-shadow: " . $shadow_color . " " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px;\n";
					else
						$css_string .= "   text-shadow: " . $shadow_x_offset . "px " . $shadow_y_offset . "px " . $shadow_blur . "px;\n";
				}
				
				if ($line_height_units != -1)
				{
					if ($line_height_units == 0)
						$css_string .= "   line-height: normal;\n";
					elseif (($line_height_units == 1) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . ";\n";
					elseif (($line_height_units == 2) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "px;\n";
					elseif (($line_height_units == 3) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "%;\n";
					elseif (($line_height_units == 4) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "em;\n";
					elseif (($line_height_units == 5) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "pt;\n";
					elseif (($line_height_units == 6) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "pc;\n";
					elseif (($line_height_units == 7) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "cm;\n";
					elseif (($line_height_units == 8) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "mm;\n";
					elseif (($line_height_units == 9) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "in;\n";
					elseif (($line_height_units == 10) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "rem;\n";
					elseif (($line_height_units == 11) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vw;\n";
					elseif (($line_height_units == 12) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vh;\n";
					elseif (($line_height_units == 13) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vmin;\n";
					elseif (($line_height_units == 14) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "vmax;\n";
					elseif (($line_height_units == 15) && ($line_height != -1))
						$css_string .= "   line-height: " . $line_height . "ch;\n";
					elseif ($line_height_units == 16)
						$css_string .= "   line-height: inherit;\n";
					elseif ($line_height_units == 17)
						$css_string .= "   line-height: initial;\n";
				}
									
				if ($letter_spacing_units != -1)
				{
					if ($letter_spacing_units == 0)
						$css_string .= "   letter-spacing: normal;\n";
					elseif (($letter_spacing_units == 1) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . intval($letter_spacing) . "px;\n";
					elseif (($letter_spacing_units == 2) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . intval($letter_spacing) . "%;\n";
					elseif (($letter_spacing_units == 3) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "em;\n";
					elseif (($letter_spacing_units == 4) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "pt;\n";
					elseif (($letter_spacing_units == 5) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "pc;\n";
					elseif (($letter_spacing_units == 6) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "cm;\n";
					elseif (($letter_spacing_units == 7) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "mm;\n";
					elseif (($letter_spacing_units == 8) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "in;\n";
					elseif (($letter_spacing_units == 9) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "rem;\n";
					elseif (($letter_spacing_units == 10) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vw;\n";
					elseif (($letter_spacing_units == 11) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vh;\n";
					elseif (($letter_spacing_units == 12) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vmin;\n";
					elseif (($letter_spacing_units == 13) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "vmax;\n";
					elseif (($letter_spacing_units == 14) && ($letter_spacing != -1000000))
						$css_string .= "   letter-spacing: " . $letter_spacing . "ch;\n";
					elseif ($letter_spacing_units == 15)
						$css_string .= "   letter-spacing: initial;\n";
					elseif ($letter_spacing_units == 15)
						$css_string .= "   letter-spacing: inherit;\n";
				}		   
					
				if ($small_caps == 1)
					$css_string .= "   font-variant: small-caps;\n";
				if ($align != "-not selected-")
					$css_string .= "   text-align: " . $align . ";\n";
				if (($vertical_align != "-not selected-") && ($vertical_align != "") && isset($vertical_align))
					$css_string .= "   vertical-align: " . $vertical_align . ";\n";
					
				if ($bkgd_transparent == 1)
				{
					$css_string .= "   background: transparent;\n";
				}
				else
				{
					if ($bkgd_color != "-not set-")
						$css_string .= "   background-color: " . $bkgd_color . ";\n";
						
					if ($bkgd_opacity != -1)
					{
						$css_string .= "   filter: alpha(opacity=" . $bkgd_opacity . ");\n";
						$css_string .= "   -moz-opacity: " . $bkgd_opacity . "%;\n";
						$bkgd_opacity = $bkgd_opacity/100;
						$css_string .= "   opacity: " . $bkgd_opacity . ";\n";
					}
				}
				
				if ($border > -1)
				{
					if ($border_units < 2)
						$border = intval($border);
					$units = GetLengthUnitsStr($border_units);
						
					if ($border_sides == 15) // All sides selected.
					{
						if ($border_style == "-not selected-") $border_style_str = "solid";
						else $border_style_str = $border_style;
						
						if ($border == 0)
							$css_string .= "   border: 0;\n";
						elseif ($border_color != "-not set-")
							$css_string .= "   border: " . $border . $units . " " . $border_style_str . " " . $border_color . ";\n";
						else
							$css_string .= "   border: " . $border . $units . " " . $border_style_str . ";\n";
					}
					else  // Not all sides selected.  Look for each side.
					{
						if (($border_sides & 8) == 8)
						{
							$border_side_str = "-top";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color . ";\n";
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color . ";\n";
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . ";\n";
						}
						if (($border_sides & 4) == 4)
						{
							$border_side_str = "-bottom";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color . ";\n";
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color . ";\n";
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . ";\n";
						}
						if (($border_sides & 2) == 2)
						{
							$border_side_str = "-left";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color . ";\n";
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color . ";\n";
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . ";\n";
						}
						if (($border_sides & 1) == 1)
						{
							$border_side_str = "-right";
							if ($border_style == "-not selected-") $border_style_str = "solid";
							else $border_style_str = $border_style;
							
							if ($border == 0)
								$css_string .= "   border" . $border_side_str . ": 0 " . $border_style_str . " " . $border_color . ";\n";
							elseif ($border_color != "-not set-")
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . " " . $border_color . ";\n";
							else
								$css_string .= "   border" . $border_side_str . ": " . $border . $units . " " . $border_style_str . ";\n";
						}
					}
				}
				
				if (($border_style != "-not selected-") && ($border < 0))
				{			
					if ($border_style == "none")
					{
						if ($border_sides == 15) // All sides selected.
							$css_string .= "   border: none;\n";
						else
						{
							if (($border_sides & 8) == 8)
								$css_string .= "   border-top: none;\n";
							if (($border_sides & 4) == 4)
								$css_string .= "   border-bottom: none;\n";
							if (($border_sides & 2) == 2)
								$css_string .= "   border-left: none;\n";
							if (($border_sides & 1) == 1)
								$css_string .= "   border-right: none;\n";
						}
					}
					else
					{
						if ($border_sides == 15) // All sides selected.
							$css_string .= "   border-style: " . $border_style . ";\n";
						else
						{
							if (($border_sides & 8) == 8)
								$css_string .= "   border-top: " . $border_style . ";\n";
							if (($border_sides & 4) == 4)
								$css_string .= "   border-bottom: " . $border_style . ";\n";;
							if (($border_sides & 2) == 2)
								$css_string .= "   border-left: " . $border_style . ";\n";
							if (($border_sides & 1) == 1)
								$css_string .= "   border-right: " . $border_style . ";\n";
						}
					}
				}
					
				if ($outline_style != "-not selected-")
					$css_string .= "   outline-style: " . $outline_style . ";\n";
				
				if ($border_collapse != "-not selected-")
					$css_string .= "   border-collapse: " . $border_collapse . ";\n";
					
				if ($margin_top_units < 2)
					$margin_top = intval($margin_top);
				$units = GetLengthUnitsStr($margin_top_units);
				if (($margin_top != -1000000) && ($margin_top_auto == 0))
					$css_string .= "   margin-top: " . $margin_top . $units . ";\n";
				elseif ($margin_top_auto == 1)
					$css_string .= "   margin-top: auto;\n";
					
				if ($margin_right_units < 2)
					$margin_right = intval($margin_right);
				$units = GetLengthUnitsStr($margin_right_units);
				if (($margin_right != -1000000) && ($margin_right_auto == 0))
					$css_string .= "   margin-right: " . $margin_right . $units . ";\n";
				elseif ($margin_right_auto == 1)
					$css_string .= "   margin-right: auto;\n";
					
				if ($margin_left_units < 2)
					$margin_left = intval($margin_left);
				$units = GetLengthUnitsStr($margin_left_units);
				if (($margin_left != -1000000) && ($margin_left_auto == 0))
					$css_string .= "   margin-left: " . $margin_left . $units . ";\n";
				elseif ($margin_left_auto == 1)
					$css_string .= "   margin-left: auto;\n";
					
				if ($margin_bottom_units < 2)
					$margin_bottom = intval($margin_bottom);
				$units = GetLengthUnitsStr($margin_bottom_units);
				if (($margin_bottom != -1000000) && ($margin_bottom_auto == 0))
					$css_string .= "   margin-bottom: " . $margin_bottom . $units . ";\n";
				elseif ($margin_bottom_auto == 1)
					$css_string .= "   margin-bottom: auto;\n";
					
					
				if ($position != "-not selected-")
					$css_string .= "   position: " . $position  . ";\n";
					
				if ($position_left_units < 2)
					$position_left = intval($position_left);
				$units = GetLengthUnitsStr($position_left_units);
				if ($position_left != -1000000)
					$css_string .= "   left: " . $position_left . $units . ";\n";
				
				if ($position_top_units < 2)
					$position_top = intval($position_top);
				$units = GetLengthUnitsStr($position_top_units);
				if ($position_top != -1000000)
					$css_string .= "   top: " . $position_top . $units . ";\n";
					
				if ($position_right_units < 2)
					$position_right = intval($position_right);
				$units = GetLengthUnitsStr($position_right_units);
				if ($position_right != -1000000)
					$css_string .= "   right: " . $position_right . $units . ";\n";
					
				if ($position_bottom_units < 2)
					$position_bottom = intval($position_bottom);
				$units = GetLengthUnitsStr($position_bottom_units);
				if ($position_bottom != -1000000)
					$css_string .= "   bottom: " . $position_bottom . $units . ";\n";
					
				if ($z_index != -1000000)
					$css_string .= "   z-index: " . $z_index  . ";\n";
					
				if ($overflow != "-not selected-")
					$css_string .= "   overflow: " . $overflow  . ";\n";
				if ($overflow_x != "-not selected-")
					$css_string .= "   overflow-x: " . $overflow_x  . ";\n";
				if ($overflow_y != "-not selected-")
					$css_string .= "   overflow-y: " . $overflow_y  . ";\n";
					
				if ($float != "-not selected-")
					$css_string .= "   float: " . $float  . ";\n";
					
				if ($white_space != "-not selected-")
					$css_string .= "   white_space: " . $white_space  . ";\n";
				
				if (($clip_top != -1) && ($clip_right != -1) && ($clip_bottom != -1) && ($clip_left != -1))
				{		
					if ($clip_top_units < 2)
						$clip_top = intval($clip_top);
					$units_top = GetLengthUnitsStr($clip_top_units);
					if ($clip_right_units < 2)
						$clip_right = intval($clip_right);
					$units_right = GetLengthUnitsStr($clip_right_units);
					if ($clip_bottom_units < 2)
						$clip_bottom = intval($clip_bottom);
					$units_bottom = GetLengthUnitsStr($clip_bottom_units);
					if ($clip_left_units < 2)
						$clip_left = intval($clip_left);
					$units_left = GetLengthUnitsStr($clip_left_units);
						
					if ($clip_top != -1)
						$css_string .= "   clip: rect(" . $clip_top . $units_top . "," . $clip_right . $units_right . "," . $clip_bottom . $units_bottom . "," . $clip_left . $units_left . ");\n";
				}
				
				
				if ($display != "-not selected-")
					$css_string .= "   display: " . $display . ";\n";
					
				if ($width != -1)
				{
					if ($width_units < 2)
						$width = intval($width);
					$units = GetLengthUnitsStr($width_units);
					
					if ($width_prefix == "-not selected-")
						$prefix = "";
					else
						$prefix = $width_prefix . "-";
						
					$css_string .= "   " . $prefix . "width: " . $width . $units . ";\n";
				}
				if ($height != -1)
				{
					if ($height_units < 2)
						$height = intval($height);
					$units = GetLengthUnitsStr($height_units);
					
					if ($height_prefix == "-not selected-")
						$prefix = "";
					else
						$prefix = $height_prefix . "-";
						
					$css_string .= "   " . $prefix . "height: " . $height . $units . ";\n";
				}
				
				if (($background_image != "-not set-") && ($background_image != "-not selected-") && ($background_image != ""))
					$css_string .= "   background-image: url('" . $image . $background_image . "');\n";
				if (($background_attachment != "-not selected-") && ($background_attachment != ""))
					$css_string .= "   background-attachment: " . $background_attachment . ";\n";
				if (($background_repeat != "-not selected-") && ($background_repeat != ""))
					$css_string .= "   background-repeat: " . $background_repeat . ";\n";
				if (($background_position != "-not selected-") && ($background_position != "") && ($background_position != "xpos ypos"))
					$css_string .= "   background-position: " . $background_position . ";\n";
				elseif ($background_position == "xpos ypos")
				{
					if ($background_position_units < 2)	{
						$background_position_x = intval($background_position_x);
						$background_position_y = intval($background_position_y);
					}
					$units = GetLengthUnitsStr($background_position_units);
					
					$css_string .= "   background-position: " . $background_position_x . $units . " " . $background_position_y . $units . ";\n";
				}
				
				if ($list_style_type != "-not selected-")
					$css_string .= "   list-style-type: " . $list_style_type . ";\n";
				if ($list_style_position != "-not selected-")
					$css_string .= "   list-style-position: " . $list_style_position . ";\n";
				if (($list_style_image != "-not set-") && ($list_style_image != "-not selected-") && ($list_style_image != ""))
					$css_string .= "   list-style-image: url('" . $image . $list_style_image . "');\n";
					
				if ($table_layout != "-not selected-")
					$css_string .= "   table-layout: " . $table_layout . ";\n";
				if ($clear != "-not selected-")
					$css_string .= "   clear: " . $clear . ";\n";
					
				if ($radius_top_left > 0)
				{
					if ($radius_top_left_units < 2)
						$radius_top_left = intval($radius_top_left);
					$units = GetLengthUnitsStr($radius_top_left_units);
					
					$css_string .= "   border-top-left-radius: " . $radius_top_left . $units . ";\n";
				}
				if ($radius_top_right > 0)
				{
					if ($radius_top_right_units < 2)
						$radius_top_right = intval($radius_top_right);
					$units = GetLengthUnitsStr($radius_top_right_units);
					
					$css_string .= "   border-top-right-radius: " . $radius_top_right . $units . ";\n";
				}
				if ($radius_bottom_right > 0)
				{
					if ($radius_bottom_right_units < 2)
						$radius_bottom_right = intval($radius_bottom_right);
					$units = GetLengthUnitsStr($radius_bottom_right_units);
					
					$css_string .= "   border-bottom-right-radius: " . $radius_bottom_right . $units . ";\n";
				}
				if ($radius_bottom_left > 0)
				{
					if ($radius_bottom_left_units < 2)
						$radius_bottom_left = intval($radius_bottom_left);
					$units = GetLengthUnitsStr($radius_bottom_left_units);
					
					$css_string .= "   border-bottom-left-radius: " . $radius_bottom_left . $units . ";\n";
				}
				
				if ($box_shadow_horizontal != -1000000)
				{
					$css_string .= "   box-shadow: " . $box_shadow_horizontal . "px " . $box_shadow_vertical . "px";
					if ($box_shadow_blur > -1)
						$css_string .= " " . $box_shadow_blur . "px";
					if ($box_shadow_spread != -1000000)
						$css_string .= " " . $box_shadow_spread . "px";
					if (isset($box_shadow_color) && ($box_shadow_color != "-not set-"))
						$css_string .= " " . $box_shadow_color;
					if ($box_shadow_inset == 1)
						$css_string .= " inset";
					$css_string .= ";\n";
				}
				
				if ($cursor != "-not selected-")
					$css_string .= "   cursor: " . $cursor  . ";\n";
					
					
					
				if ($background_size != "-not selected-")
				{
					if (!(($background_size == "scale") && ($background_width < 0))) // If scale, must have a positive dimension.
					{
						$css_string .= "   background-size: ";
						if (($background_size == "scale") && ($background_width > -1))
						{
							if ($background_width_units < 2)
								$background_width = intval($background_width);
							$units = GetLengthUnitsStr($background_width_units);
							
							$css_string .= $background_width . $units;
								
							if ($background_height > -1)
							{
								if ($background_height_units < 2)
									$background_height = intval($background_height);
								$units = GetLengthUnitsStr($background_height_units);
							
								$css_string .= " " . $background_height . $units;
							}
						}
						elseif ($background_size != "scale")
							$css_string .= $background_size;
						$css_string .= ";\n";
					}
				}
				
				if ($visibility != "-not selected-")
					$css_string .= "   visibility: " . $visibility . ";\n";
					
				if ($text_indent != -1000000)
				{
					if ($text_indent_units < 2)
						$text_indent = intval($text_indent);
					$units = GetLengthUnitsStr($text_indent_units);
					$css_string .= "   text-indent: " . $text_indent . $units . ";\n";
				}
				
				$css_string .= "}\n\n";
			} // end if use table data for tag
		}	// end while
	}
	
	if (((strpos($site_css_table, "site_css") !== false) || (strpos($site_css_table, "site_mobile_css") !== false)) && (strpos($site_css_table, "preview") === false))
	{
		if (strpos($site_css_table, "site_mobile_css") !== false)	{
			$prefix = str_replace("site_mobile_css", "", $site_css_table);
			$custom_table = $prefix . "custom_site_mobile_css";
		}
		else	{
			$prefix = str_replace("site_css", "", $site_css_table);
			$custom_table = $prefix . "custom_site_css";
		}
		$query_build_string = "SELECT * FROM `" . $custom_table . "`";

		if ($template_id > -1)
			$query_build_string .= " WHERE template_id = " . $template_id;
		$result_build_string = $dbh->query($query_build_string);
		$row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC);
		if ($row_bs["custom_css"])
			$css_string .= $row_bs["custom_css"];
	}
	elseif (((strpos($site_css_table, "site_css") !== false) || (strpos($site_css_table, "site_mobile_css") !== false)) && (strpos($site_css_table, "preview") !== false))
	{
		$prefix = str_replace("site_css_preview", "", $site_css_table);

		$custom_table = $prefix . "custom_site_css_preview";
		$query_build_string = "SELECT * FROM `" . $custom_table . "`";

		$result_build_string = $dbh->query($query_build_string);
		$row_bs = $result_build_string->fetch(PDO::FETCH_ASSOC);
		if ($row_bs["custom_css"])
			$css_string .= $row_bs["custom_css"];
	}

	return ($css_string);
		
}
?>